/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.enumeration;

import java.util.ArrayList;
import java.util.List;
import net.bytebuddy.build.CachedReturnPlugin;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface EnumerationDescription
extends NamedElement {
    public String getValue();

    public TypeDescription getEnumerationType();

    public <T extends Enum<T>> T load(Class<T> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Latent
    extends AbstractBase {
        private final TypeDescription enumerationType;
        private final String value;

        /*
         * WARNING - void declaration
         */
        public Latent(TypeDescription enumerationType, String value) {
            void var2_2;
            void var1_1;
            this.enumerationType = var1_1;
            this.value = var2_2;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public TypeDescription getEnumerationType() {
            return this.enumerationType;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T extends Enum<T>> T load(Class<T> type) {
            void var1_1;
            if (!this.enumerationType.represents(type)) {
                throw new IllegalArgumentException(type + " does not represent " + this.enumerationType);
            }
            return Enum.valueOf(var1_1, this.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForLoadedEnumeration
    extends AbstractBase {
        private final Enum<?> value;

        /*
         * WARNING - void declaration
         */
        public ForLoadedEnumeration(Enum<?> value) {
            void var1_1;
            this.value = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static List<EnumerationDescription> asList(Enum<?>[] enumerations) {
            void var1_1;
            Enum<?>[] enumArray;
            ArrayList<ForLoadedEnumeration> result = new ArrayList<ForLoadedEnumeration>(enumerations.length);
            for (Enum<?> enumeration : enumArray) {
                result.add(new ForLoadedEnumeration(enumeration));
            }
            return var1_1;
        }

        @Override
        public String getValue() {
            return this.value.name();
        }

        @Override
        public TypeDescription getEnumerationType() {
            return TypeDescription.ForLoadedType.of(this.value.getDeclaringClass());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T extends Enum<T>> T load(Class<T> type) {
            void var1_1;
            if (this.value.getDeclaringClass() == type) {
                return (T)this.value;
            }
            return Enum.valueOf(var1_1, this.value.name());
        }
    }

    public static abstract class AbstractBase
    implements EnumerationDescription {
        private transient /* synthetic */ int hashCode;

        public String getActualName() {
            return this.getValue();
        }

        @CachedReturnPlugin.Enhance(value="hashCode")
        public int hashCode() {
            int n;
            int n2 = this.hashCode;
            if (n2 != 0) {
                n = 0;
            } else {
                AbstractBase abstractBase = this;
                n = n2 = abstractBase.getValue().hashCode() + 31 * abstractBase.getEnumerationType().hashCode();
            }
            if (n == 0) {
                n2 = this.hashCode;
            } else {
                this.hashCode = n2;
            }
            return n2;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(@MaybeNull Object other) {
            void var1_1;
            if (this == other) {
                return true;
            }
            if (!(other instanceof EnumerationDescription)) {
                return false;
            }
            EnumerationDescription enumerationDescription = (EnumerationDescription)other;
            return this.getEnumerationType().equals(enumerationDescription.getEnumerationType()) && this.getValue().equals(var1_1.getValue());
        }

        public String toString() {
            return this.getValue();
        }
    }
}

