/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.annotation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationTypeMismatchException;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.build.CachedReturnPlugin;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.enumeration.EnumerationDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.utility.nullability.AlwaysNull;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface AnnotationValue<T, S> {
    @AlwaysNull
    public static final AnnotationValue<?, ?> UNDEFINED = null;

    public State getState();

    public Sort getSort();

    public AnnotationValue<T, S> filter(MethodDescription.InDefinedShape var1);

    public AnnotationValue<T, S> filter(MethodDescription.InDefinedShape var1, TypeDefinition var2);

    public T resolve();

    public <W> W resolve(Class<? extends W> var1);

    public Loaded<S> load(@MaybeNull ClassLoader var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForIncompatibleType<U, V>
    extends AbstractBase<U, V> {
        private final TypeDescription typeDescription;

        /*
         * WARNING - void declaration
         */
        public ForIncompatibleType(TypeDescription typeDescription) {
            void var1_1;
            this.typeDescription = var1_1;
        }

        @Override
        public State getState() {
            return State.UNRESOLVED;
        }

        @Override
        public Sort getSort() {
            return Sort.NONE;
        }

        @Override
        public AnnotationValue<U, V> filter(MethodDescription.InDefinedShape property, TypeDefinition typeDefinition) {
            return this;
        }

        @Override
        public U resolve() {
            throw new IllegalStateException("Property is defined with an incompatible runtime type: " + this.typeDescription);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public net.bytebuddy.description.annotation.AnnotationValue$Loaded<V> load(@MaybeNull ClassLoader classLoader) {
            try {
                return new Loaded(Class.forName(this.typeDescription.getName(), false, classLoader));
            }
            catch (ClassNotFoundException exception) {
                void var1_2;
                return new ForMissingType.Loaded(this.typeDescription.getName(), (ClassNotFoundException)var1_2);
            }
        }

        public String toString() {
            return "/* Warning type incompatibility! \"" + this.typeDescription.getName() + "\" */";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Loaded<W>
        extends Loaded.AbstractBase.ForUnresolvedProperty<W> {
            private final Class<?> type;

            /*
             * WARNING - void declaration
             */
            public Loaded(Class<?> type) {
                void var1_1;
                this.type = var1_1;
            }

            @Override
            public W resolve() {
                throw new IncompatibleClassChangeError(this.type.toString());
            }

            public String toString() {
                return "/* Warning type incompatibility! \"" + this.type.getName() + "\" */";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForMissingValue<U, V>
    extends AbstractBase<U, V> {
        private final TypeDescription typeDescription;
        private final String property;

        /*
         * WARNING - void declaration
         */
        public ForMissingValue(TypeDescription typeDescription, String property) {
            void var2_2;
            void var1_1;
            this.typeDescription = var1_1;
            this.property = var2_2;
        }

        @Override
        public State getState() {
            return State.UNDEFINED;
        }

        @Override
        public Sort getSort() {
            return Sort.NONE;
        }

        @Override
        public AnnotationValue<U, V> filter(MethodDescription.InDefinedShape property, TypeDefinition typeDefinition) {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public net.bytebuddy.description.annotation.AnnotationValue$Loaded<V> load(@MaybeNull ClassLoader classLoader) {
            try {
                Class<?> type = Class.forName(this.typeDescription.getName(), false, classLoader);
                if (type.isAnnotation()) {
                    return new Loaded(type, this.property);
                }
                return new ForIncompatibleType.Loaded(type);
            }
            catch (ClassNotFoundException exception) {
                void var1_2;
                return new ForMissingType.Loaded(this.typeDescription.getName(), (ClassNotFoundException)var1_2);
            }
        }

        @Override
        public U resolve() {
            throw new IllegalStateException(this.typeDescription + " does not define " + this.property);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Loaded<W>
        extends Loaded.AbstractBase<W> {
            private final Class<? extends Annotation> type;
            private final String property;

            /*
             * WARNING - void declaration
             */
            public Loaded(Class<? extends Annotation> type, String property) {
                void var2_2;
                void var1_1;
                this.type = var1_1;
                this.property = var2_2;
            }

            @Override
            public State getState() {
                return State.UNDEFINED;
            }

            @Override
            public W resolve() {
                throw new IncompleteAnnotationException(this.type, this.property);
            }

            @Override
            public boolean represents(Object value) {
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForMismatchedType<U, V>
    extends AbstractBase<U, V> {
        private final MethodDescription.InDefinedShape property;
        private final String value;

        /*
         * WARNING - void declaration
         */
        public ForMismatchedType(MethodDescription.InDefinedShape property, String value) {
            void var2_2;
            void var1_1;
            this.property = var1_1;
            this.value = var2_2;
        }

        @Override
        public State getState() {
            return State.UNRESOLVED;
        }

        @Override
        public Sort getSort() {
            return Sort.NONE;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AnnotationValue<U, V> filter(MethodDescription.InDefinedShape property, TypeDefinition typeDefinition) {
            void var1_1;
            return new ForMismatchedType<U, V>((MethodDescription.InDefinedShape)var1_1, this.value);
        }

        @Override
        public U resolve() {
            throw new IllegalStateException(this.value + " cannot be used as value for " + this.property);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public net.bytebuddy.description.annotation.AnnotationValue$Loaded<V> load(@MaybeNull ClassLoader classLoader) {
            try {
                Class<?> type = Class.forName(this.property.getDeclaringType().getName(), false, classLoader);
                try {
                    return new Loaded(type.getMethod(this.property.getName(), new Class[0]), this.value);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return new ForIncompatibleType.Loaded(type);
                }
            }
            catch (ClassNotFoundException exception) {
                void var1_2;
                return new ForMissingType.Loaded(this.property.getDeclaringType().getName(), (ClassNotFoundException)var1_2);
            }
        }

        public String toString() {
            return "/* Warning type mismatch! \"" + this.value + "\" */";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Loaded<W>
        extends Loaded.AbstractBase.ForUnresolvedProperty<W> {
            private final Method property;
            private final String value;

            /*
             * WARNING - void declaration
             */
            public Loaded(Method property, String value) {
                void var2_2;
                void var1_1;
                this.property = var1_1;
                this.value = var2_2;
            }

            @Override
            public W resolve() {
                throw new AnnotationTypeMismatchException(this.property, this.value);
            }

            public String toString() {
                return "/* Warning type mismatch! \"" + this.value + "\" */";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForMissingType<U, V>
    extends AbstractBase<U, V> {
        private final String typeName;

        /*
         * WARNING - void declaration
         */
        public ForMissingType(String typeName) {
            void var1_1;
            this.typeName = var1_1;
        }

        @Override
        public State getState() {
            return State.UNRESOLVED;
        }

        @Override
        public Sort getSort() {
            return Sort.NONE;
        }

        @Override
        public AnnotationValue<U, V> filter(MethodDescription.InDefinedShape property, TypeDefinition typeDefinition) {
            return this;
        }

        @Override
        public U resolve() {
            throw new IllegalStateException("Type not found: " + this.typeName);
        }

        @Override
        public net.bytebuddy.description.annotation.AnnotationValue$Loaded<V> load(@MaybeNull ClassLoader classLoader) {
            return new Loaded(this.typeName, new ClassNotFoundException(this.typeName));
        }

        public String toString() {
            return this.typeName + ".class /* Warning: type not present! */";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Loaded<U>
        extends Loaded.AbstractBase.ForUnresolvedProperty<U> {
            private final String typeName;
            private final ClassNotFoundException exception;

            /*
             * WARNING - void declaration
             */
            public Loaded(String typeName, ClassNotFoundException exception) {
                void var2_2;
                void var1_1;
                this.typeName = var1_1;
                this.exception = var2_2;
            }

            @Override
            public U resolve() {
                throw new TypeNotPresentException(this.typeName, this.exception);
            }

            public String toString() {
                return this.typeName + ".class /* Warning: type not present! */";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForDescriptionArray<U, V>
    extends AbstractBase<U, V> {
        private final Class<?> unloadedComponentType;
        private final TypeDescription componentType;
        private final List<? extends AnnotationValue<?, ?>> values;
        private transient /* synthetic */ int hashCode;

        /*
         * WARNING - void declaration
         */
        public ForDescriptionArray(Class<?> unloadedComponentType, TypeDescription componentType, List<? extends AnnotationValue<?, ?>> values) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.unloadedComponentType = var1_1;
            this.componentType = var2_2;
            this.values = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public static <W extends Enum<W>> AnnotationValue<EnumerationDescription[], W[]> of(TypeDescription enumerationType, EnumerationDescription[] enumerationDescription) {
            void var2_2;
            TypeDescription typeDescription;
            void var1_1;
            ArrayList values = new ArrayList(enumerationDescription.length);
            for (void value : var1_1) {
                if (!value.getEnumerationType().equals(enumerationType)) {
                    throw new IllegalArgumentException(value + " is not of " + enumerationType);
                }
                values.add(ForEnumerationDescription.of((EnumerationDescription)value));
            }
            return new ForDescriptionArray<EnumerationDescription[], W[]>(EnumerationDescription.class, typeDescription, (List<AnnotationValue<?, ?>>)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public static <W extends Annotation> AnnotationValue<AnnotationDescription[], W[]> of(TypeDescription annotationType, AnnotationDescription[] annotationDescription) {
            void var2_2;
            TypeDescription typeDescription;
            void var1_1;
            ArrayList values = new ArrayList(annotationDescription.length);
            for (void value : var1_1) {
                if (!value.getAnnotationType().equals(annotationType)) {
                    throw new IllegalArgumentException(value + " is not of " + annotationType);
                }
                values.add(new ForAnnotationDescription((AnnotationDescription)value));
            }
            return new ForDescriptionArray<AnnotationDescription[], W[]>(AnnotationDescription.class, typeDescription, (List<AnnotationValue<?, ?>>)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public static AnnotationValue<TypeDescription[], Class<?>[]> of(TypeDescription[] typeDescription) {
            void var1_1;
            TypeDescription[] typeDescriptionArray;
            ArrayList values = new ArrayList(typeDescription.length);
            for (TypeDescription value : typeDescriptionArray) {
                values.add(ForTypeDescription.of(value));
            }
            return new ForDescriptionArray<TypeDescription[], Class<?>[]>(TypeDescription.class, TypeDescription.ForLoadedType.of(Class.class), (List<AnnotationValue<?, ?>>)var1_1);
        }

        @Override
        public State getState() {
            return State.RESOLVED;
        }

        @Override
        public Sort getSort() {
            return Sort.ARRAY;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming component type for array type.")
        public AnnotationValue<U, V> filter(MethodDescription.InDefinedShape property, TypeDefinition typeDefinition) {
            void var1_1;
            if (typeDefinition.isArray() && typeDefinition.getComponentType().asErasure().equals(this.componentType)) {
                for (AnnotationValue<?, ?> value : this.values) {
                    if (value.getSort() != Sort.of(this.componentType)) {
                        return new ForMismatchedType(property, RenderingDispatcher.CURRENT.toArrayErrorString(value.getSort()));
                    }
                    if ((value = value.filter(property, typeDefinition.getComponentType())).getState() == State.RESOLVED) continue;
                    return value;
                }
                return this;
            }
            return new ForMismatchedType((MethodDescription.InDefinedShape)var1_1, RenderingDispatcher.CURRENT.toArrayErrorString(Sort.of(this.componentType)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public U resolve() {
            void var1_1;
            Object resolved = Array.newInstance(this.unloadedComponentType, this.values.size());
            int index = 0;
            for (AnnotationValue<?, ?> value : this.values) {
                Array.set(resolved, index++, value.resolve());
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public net.bytebuddy.description.annotation.AnnotationValue$Loaded<V> load(@MaybeNull ClassLoader classLoader) {
            ArrayList values = new ArrayList(this.values.size());
            for (AnnotationValue<?, ?> value : this.values) {
                values.add(value.load(classLoader));
            }
            try {
                void var2_2;
                void var1_1;
                return new Loaded(this.componentType.isPrimitive() ? this.unloadedComponentType : Class.forName(this.componentType.getName(), false, (ClassLoader)var1_1), (List<net.bytebuddy.description.annotation.AnnotationValue$Loaded<?>>)var2_2);
            }
            catch (ClassNotFoundException exception) {
                void var3_4;
                return new ForMissingType.Loaded(this.componentType.getName(), (ClassNotFoundException)var3_4);
            }
        }

        /*
         * WARNING - void declaration
         */
        @CachedReturnPlugin.Enhance(value="hashCode")
        public int hashCode() {
            int n;
            int n2 = this.hashCode;
            if (n2 != 0) {
                n = 0;
            } else {
                void var2_3;
                ForDescriptionArray forDescriptionArray = this;
                int result = 1;
                for (AnnotationValue annotationValue : forDescriptionArray.values) {
                    result = result * 31 + annotationValue.hashCode();
                }
                n = n2 = var2_3;
            }
            if (n == 0) {
                n2 = this.hashCode;
            } else {
                this.hashCode = n2;
            }
            return n2;
        }

        public boolean equals(@MaybeNull Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnnotationValue)) {
                return false;
            }
            Object value = (other = (AnnotationValue)other).resolve();
            if (!value.getClass().isArray()) {
                return false;
            }
            if (this.values.size() != Array.getLength(value)) {
                return false;
            }
            Iterator<AnnotationValue<?, ?>> iterator = this.values.iterator();
            for (int index = 0; index < this.values.size(); ++index) {
                AnnotationValue<?, ?> annotationValue = iterator.next();
                if (annotationValue.resolve().equals(Array.get(value, index))) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return RenderingDispatcher.CURRENT.toSourceString(this.values);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class Loaded<W>
        extends Loaded.AbstractBase<W> {
            private final Class<W> componentType;
            private final List<net.bytebuddy.description.annotation.AnnotationValue$Loaded<?>> values;
            private transient /* synthetic */ int hashCode;

            /*
             * WARNING - void declaration
             */
            protected Loaded(Class<W> componentType, List<net.bytebuddy.description.annotation.AnnotationValue$Loaded<?>> values) {
                void var2_2;
                void var1_1;
                this.componentType = var1_1;
                this.values = var2_2;
            }

            @Override
            public State getState() {
                for (net.bytebuddy.description.annotation.AnnotationValue$Loaded<?> loaded : this.values) {
                    if (loaded.getState().isResolved()) continue;
                    return State.UNRESOLVED;
                }
                return State.RESOLVED;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public W resolve() {
                void var1_1;
                Object array = Array.newInstance(this.componentType, this.values.size());
                int index = 0;
                for (net.bytebuddy.description.annotation.AnnotationValue$Loaded<?> annotationValue : this.values) {
                    Array.set(array, index++, annotationValue.resolve());
                }
                return var1_1;
            }

            @Override
            public boolean represents(Object value) {
                if (!value.getClass().isArray()) {
                    return false;
                }
                if (value.getClass().getComponentType() != this.componentType) {
                    return false;
                }
                if (this.values.size() != Array.getLength(value)) {
                    return false;
                }
                Iterator<net.bytebuddy.description.annotation.AnnotationValue$Loaded<?>> iterator = this.values.iterator();
                for (int index = 0; index < Array.getLength(value); ++index) {
                    net.bytebuddy.description.annotation.AnnotationValue$Loaded<?> loaded = iterator.next();
                    if (loaded.represents(Array.get(value, index))) continue;
                    return false;
                }
                return true;
            }

            /*
             * WARNING - void declaration
             */
            @CachedReturnPlugin.Enhance(value="hashCode")
            public int hashCode() {
                int n;
                int n2 = this.hashCode;
                if (n2 != 0) {
                    n = 0;
                } else {
                    void var2_3;
                    Loaded loaded = this;
                    int result = 1;
                    for (net.bytebuddy.description.annotation.AnnotationValue$Loaded loaded2 : loaded.values) {
                        result = result * 31 + loaded2.hashCode();
                    }
                    n = n2 = var2_3;
                }
                if (n == 0) {
                    n2 = this.hashCode;
                } else {
                    this.hashCode = n2;
                }
                return n2;
            }

            public boolean equals(@MaybeNull Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof net.bytebuddy.description.annotation.AnnotationValue$Loaded)) {
                    return false;
                }
                net.bytebuddy.description.annotation.AnnotationValue$Loaded annotationValue = (net.bytebuddy.description.annotation.AnnotationValue$Loaded)other;
                if (!annotationValue.getState().isResolved()) {
                    return false;
                }
                Object value = annotationValue.resolve();
                if (!value.getClass().isArray()) {
                    return false;
                }
                if (this.values.size() != Array.getLength(value)) {
                    return false;
                }
                Iterator<net.bytebuddy.description.annotation.AnnotationValue$Loaded<?>> iterator = this.values.iterator();
                for (int index = 0; index < Array.getLength(value); ++index) {
                    net.bytebuddy.description.annotation.AnnotationValue$Loaded<?> self = iterator.next();
                    if (self.getState().isResolved() && self.resolve().equals(Array.get(value, index))) continue;
                    return false;
                }
                return true;
            }

            public String toString() {
                return RenderingDispatcher.CURRENT.toSourceString(this.values);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForTypeDescription<U extends Class<U>>
    extends AbstractBase<TypeDescription, U> {
        private static final boolean NO_INITIALIZATION = false;
        private static final Map<TypeDescription, Class<?>> PRIMITIVE_TYPES = new HashMap();
        private final TypeDescription typeDescription;

        /*
         * WARNING - void declaration
         */
        public ForTypeDescription(TypeDescription typeDescription) {
            void var1_1;
            this.typeDescription = var1_1;
        }

        public static <V extends Class<V>> AnnotationValue<TypeDescription, V> of(TypeDescription typeDescription) {
            TypeDescription typeDescription2;
            return new ForTypeDescription(typeDescription2);
        }

        @Override
        public State getState() {
            return State.RESOLVED;
        }

        @Override
        public Sort getSort() {
            return Sort.TYPE;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AnnotationValue<TypeDescription, U> filter(MethodDescription.InDefinedShape property, TypeDefinition typeDefinition) {
            void var1_1;
            if (typeDefinition.asErasure().represents((Type)((Object)Class.class))) {
                return this;
            }
            void v0 = var1_1;
            return new ForMismatchedType((MethodDescription.InDefinedShape)v0, v0.getReturnType().isArray() ? RenderingDispatcher.CURRENT.toArrayErrorString(Sort.TYPE) : Class.class.getName() + '[' + this.typeDescription.getName() + ']');
        }

        @Override
        public TypeDescription resolve() {
            return this.typeDescription;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public net.bytebuddy.description.annotation.AnnotationValue$Loaded<U> load(@MaybeNull ClassLoader classLoader) {
            try {
                return new Loaded(this.typeDescription.isPrimitive() ? PRIMITIVE_TYPES.get(this.typeDescription) : Class.forName(this.typeDescription.getName(), false, classLoader));
            }
            catch (ClassNotFoundException exception) {
                void var1_2;
                return new ForMissingType.Loaded(this.typeDescription.getName(), (ClassNotFoundException)var1_2);
            }
        }

        public int hashCode() {
            return this.typeDescription.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(@MaybeNull Object other) {
            void var1_1;
            return this == other || other instanceof AnnotationValue && this.typeDescription.equals(((AnnotationValue)var1_1).resolve());
        }

        public String toString() {
            return RenderingDispatcher.CURRENT.toSourceString(this.typeDescription);
        }

        /*
         * WARNING - void declaration
         */
        static {
            Class[] classArray = new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE};
            int cfr_ignored_0 = classArray.length;
            for (int i = 0; i < 9; ++i) {
                void var2_2;
                Class type = classArray[i];
                PRIMITIVE_TYPES.put(TypeDescription.ForLoadedType.of(type), (Class<?>)var2_2);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class Loaded<U extends Class<U>>
        extends Loaded.AbstractBase<U> {
            private final U type;

            /*
             * WARNING - void declaration
             */
            public Loaded(U type) {
                void var1_1;
                this.type = var1_1;
            }

            @Override
            public State getState() {
                return State.RESOLVED;
            }

            @Override
            public U resolve() {
                return this.type;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean represents(Object value) {
                void var1_1;
                return this.type.equals(var1_1);
            }

            public int hashCode() {
                return this.type.hashCode();
            }

            /*
             * WARNING - void declaration
             */
            public boolean equals(@MaybeNull Object other) {
                void var1_1;
                if (this == other) {
                    return true;
                }
                if (!(other instanceof net.bytebuddy.description.annotation.AnnotationValue$Loaded)) {
                    return false;
                }
                net.bytebuddy.description.annotation.AnnotationValue$Loaded annotationValue = (net.bytebuddy.description.annotation.AnnotationValue$Loaded)other;
                return annotationValue.getState().isResolved() && this.type.equals(var1_1.resolve());
            }

            public String toString() {
                return RenderingDispatcher.CURRENT.toSourceString(TypeDescription.ForLoadedType.of(this.type));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForEnumerationDescription<U extends Enum<U>>
    extends AbstractBase<EnumerationDescription, U> {
        private final EnumerationDescription enumerationDescription;

        /*
         * WARNING - void declaration
         */
        public ForEnumerationDescription(EnumerationDescription enumerationDescription) {
            void var1_1;
            this.enumerationDescription = var1_1;
        }

        public static <V extends Enum<V>> AnnotationValue<EnumerationDescription, V> of(EnumerationDescription value) {
            EnumerationDescription enumerationDescription;
            return new ForEnumerationDescription(enumerationDescription);
        }

        @Override
        public EnumerationDescription resolve() {
            return this.enumerationDescription;
        }

        @Override
        public State getState() {
            return State.RESOLVED;
        }

        @Override
        public Sort getSort() {
            return Sort.ENUMERATION;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AnnotationValue<EnumerationDescription, U> filter(MethodDescription.InDefinedShape property, TypeDefinition typeDefinition) {
            void var1_1;
            if (typeDefinition.asErasure().equals(this.enumerationDescription.getEnumerationType())) {
                return this;
            }
            void v0 = var1_1;
            return new ForMismatchedType((MethodDescription.InDefinedShape)v0, v0.getReturnType().isArray() ? RenderingDispatcher.CURRENT.toArrayErrorString(Sort.ENUMERATION) : this.enumerationDescription.getEnumerationType().getName() + '.' + this.enumerationDescription.getValue());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public net.bytebuddy.description.annotation.AnnotationValue$Loaded<U> load(@MaybeNull ClassLoader classLoader) {
            try {
                return new Loaded(this.enumerationDescription.load(Class.forName(this.enumerationDescription.getEnumerationType().getName(), false, classLoader)));
            }
            catch (ClassNotFoundException exception) {
                void var1_2;
                return new ForMissingType.Loaded(this.enumerationDescription.getEnumerationType().getName(), (ClassNotFoundException)var1_2);
            }
        }

        public int hashCode() {
            return this.enumerationDescription.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(@MaybeNull Object other) {
            void var1_1;
            return this == other || other instanceof AnnotationValue && this.enumerationDescription.equals(((AnnotationValue)var1_1).resolve());
        }

        public String toString() {
            return this.enumerationDescription.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class WithUnknownConstant<U extends Enum<U>>
        extends AbstractBase<EnumerationDescription, U> {
            private final TypeDescription typeDescription;
            private final String value;

            /*
             * WARNING - void declaration
             */
            public WithUnknownConstant(TypeDescription typeDescription, String value) {
                void var2_2;
                void var1_1;
                this.typeDescription = var1_1;
                this.value = var2_2;
            }

            @Override
            public State getState() {
                return State.UNRESOLVED;
            }

            @Override
            public Sort getSort() {
                return Sort.NONE;
            }

            @Override
            public AnnotationValue<EnumerationDescription, U> filter(MethodDescription.InDefinedShape property, TypeDefinition typeDefinition) {
                return this;
            }

            @Override
            public EnumerationDescription resolve() {
                throw new IllegalStateException(this.typeDescription + " does not declare enumeration constant " + this.value);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public net.bytebuddy.description.annotation.AnnotationValue$Loaded<U> load(@MaybeNull ClassLoader classLoader) {
                try {
                    return new Loaded(Class.forName(this.typeDescription.getName(), false, classLoader), this.value);
                }
                catch (ClassNotFoundException exception) {
                    void var1_2;
                    return new ForMissingType.Loaded(this.typeDescription.getName(), (ClassNotFoundException)var1_2);
                }
            }

            public String toString() {
                return this.value + " /* Warning: constant not present! */";
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class Loaded
            extends Loaded.AbstractBase.ForUnresolvedProperty<Enum<?>> {
                private final Class<? extends Enum<?>> enumType;
                private final String value;

                /*
                 * WARNING - void declaration
                 */
                public Loaded(Class<? extends Enum<?>> enumType, String value) {
                    void var2_2;
                    void var1_1;
                    this.enumType = var1_1;
                    this.value = var2_2;
                }

                @Override
                public Enum<?> resolve() {
                    throw new EnumConstantNotPresentException(this.enumType, this.value);
                }

                public String toString() {
                    return this.value + " /* Warning: constant not present! */";
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Loaded<V extends Enum<V>>
        extends Loaded.AbstractBase<V> {
            private final V enumeration;

            /*
             * WARNING - void declaration
             */
            public Loaded(V enumeration) {
                void var1_1;
                this.enumeration = var1_1;
            }

            @Override
            public State getState() {
                return State.RESOLVED;
            }

            @Override
            public V resolve() {
                return this.enumeration;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean represents(Object value) {
                void var1_1;
                return ((Enum)this.enumeration).equals(var1_1);
            }

            public int hashCode() {
                return ((Enum)this.enumeration).hashCode();
            }

            /*
             * WARNING - void declaration
             */
            public boolean equals(@MaybeNull Object other) {
                void var1_1;
                if (this == other) {
                    return true;
                }
                if (!(other instanceof net.bytebuddy.description.annotation.AnnotationValue$Loaded)) {
                    return false;
                }
                net.bytebuddy.description.annotation.AnnotationValue$Loaded annotationValue = (net.bytebuddy.description.annotation.AnnotationValue$Loaded)other;
                return annotationValue.getState().isResolved() && ((Enum)this.enumeration).equals(var1_1.resolve());
            }

            public String toString() {
                return ((Enum)this.enumeration).toString();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class WithIncompatibleRuntimeType
            extends Loaded.AbstractBase<Enum<?>> {
                private final Class<?> type;

                /*
                 * WARNING - void declaration
                 */
                public WithIncompatibleRuntimeType(Class<?> type) {
                    void var1_1;
                    this.type = var1_1;
                }

                @Override
                public State getState() {
                    return State.UNRESOLVED;
                }

                @Override
                public Enum<?> resolve() {
                    throw new IncompatibleClassChangeError("Not an enumeration type: " + this.type.getName());
                }

                @Override
                public boolean represents(Object value) {
                    return false;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForAnnotationDescription<U extends Annotation>
    extends AbstractBase<AnnotationDescription, U> {
        private final AnnotationDescription annotationDescription;

        /*
         * WARNING - void declaration
         */
        public ForAnnotationDescription(AnnotationDescription annotationDescription) {
            void var1_1;
            this.annotationDescription = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static <V extends Annotation> AnnotationValue<AnnotationDescription, V> of(TypeDescription annotationType, Map<String, ? extends AnnotationValue<?, ?>> annotationValues) {
            void var1_1;
            TypeDescription typeDescription;
            return new ForAnnotationDescription(new AnnotationDescription.Latent(typeDescription, (Map<String, ? extends AnnotationValue<?, ?>>)var1_1));
        }

        @Override
        public State getState() {
            return State.RESOLVED;
        }

        @Override
        public Sort getSort() {
            return Sort.ANNOTATION;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AnnotationValue<AnnotationDescription, U> filter(MethodDescription.InDefinedShape property, TypeDefinition typeDefinition) {
            void var1_1;
            if (typeDefinition.asErasure().equals(this.annotationDescription.getAnnotationType())) {
                return this;
            }
            void v0 = var1_1;
            return new ForMismatchedType((MethodDescription.InDefinedShape)v0, v0.getReturnType().isArray() ? RenderingDispatcher.CURRENT.toArrayErrorString(Sort.ANNOTATION) : this.annotationDescription.toString());
        }

        @Override
        public AnnotationDescription resolve() {
            return this.annotationDescription;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public net.bytebuddy.description.annotation.AnnotationValue$Loaded<U> load(@MaybeNull ClassLoader classLoader) {
            try {
                return new Loaded(this.annotationDescription.prepare(Class.forName(this.annotationDescription.getAnnotationType().getName(), false, classLoader)).load());
            }
            catch (ClassNotFoundException exception) {
                void var1_2;
                return new ForMissingType.Loaded(this.annotationDescription.getAnnotationType().getName(), (ClassNotFoundException)var1_2);
            }
        }

        public int hashCode() {
            return this.annotationDescription.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(@MaybeNull Object other) {
            void var1_1;
            return this == other || other instanceof AnnotationValue && this.annotationDescription.equals(((AnnotationValue)var1_1).resolve());
        }

        public String toString() {
            return this.annotationDescription.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Loaded<V extends Annotation>
        extends Loaded.AbstractBase<V> {
            private final V annotation;

            /*
             * WARNING - void declaration
             */
            public Loaded(V annotation) {
                void var1_1;
                this.annotation = var1_1;
            }

            @Override
            public State getState() {
                return State.RESOLVED;
            }

            @Override
            public V resolve() {
                return this.annotation;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean represents(Object value) {
                void var1_1;
                return this.annotation.equals(var1_1);
            }

            public int hashCode() {
                return this.annotation.hashCode();
            }

            /*
             * WARNING - void declaration
             */
            public boolean equals(@MaybeNull Object other) {
                void var1_1;
                if (this == other) {
                    return true;
                }
                if (!(other instanceof net.bytebuddy.description.annotation.AnnotationValue$Loaded)) {
                    return false;
                }
                net.bytebuddy.description.annotation.AnnotationValue$Loaded annotationValue = (net.bytebuddy.description.annotation.AnnotationValue$Loaded)other;
                return annotationValue.getState().isResolved() && this.annotation.equals(var1_1.resolve());
            }

            public String toString() {
                return this.annotation.toString();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForConstant<U>
    extends AbstractBase<U, U> {
        private final U value;
        private final PropertyDelegate propertyDelegate;
        private transient /* synthetic */ int hashCode;

        /*
         * WARNING - void declaration
         */
        protected ForConstant(U value, PropertyDelegate propertyDelegate) {
            void var2_2;
            void var1_1;
            this.value = var1_1;
            this.propertyDelegate = var2_2;
        }

        public static AnnotationValue<Boolean, Boolean> of(boolean value) {
            boolean bl;
            return new ForConstant<Boolean>(bl, PropertyDelegate.ForNonArrayType.BOOLEAN);
        }

        public static AnnotationValue<Byte, Byte> of(byte value) {
            byte by;
            return new ForConstant<Byte>(by, PropertyDelegate.ForNonArrayType.BYTE);
        }

        public static AnnotationValue<Short, Short> of(short value) {
            short s;
            return new ForConstant<Short>(s, PropertyDelegate.ForNonArrayType.SHORT);
        }

        public static AnnotationValue<Character, Character> of(char value) {
            char c;
            return new ForConstant<Character>(Character.valueOf(c), PropertyDelegate.ForNonArrayType.CHARACTER);
        }

        public static AnnotationValue<Integer, Integer> of(int value) {
            int n;
            return new ForConstant<Integer>(n, PropertyDelegate.ForNonArrayType.INTEGER);
        }

        public static AnnotationValue<Long, Long> of(long value) {
            long l;
            return new ForConstant<Long>(l, PropertyDelegate.ForNonArrayType.LONG);
        }

        public static AnnotationValue<Float, Float> of(float value) {
            float f;
            return new ForConstant<Float>(Float.valueOf(f), PropertyDelegate.ForNonArrayType.FLOAT);
        }

        public static AnnotationValue<Double, Double> of(double value) {
            double d;
            return new ForConstant<Double>(d, PropertyDelegate.ForNonArrayType.DOUBLE);
        }

        public static AnnotationValue<String, String> of(String value) {
            String string;
            return new ForConstant<String>(string, PropertyDelegate.ForNonArrayType.STRING);
        }

        public static AnnotationValue<boolean[], boolean[]> of(boolean ... value) {
            boolean[] blArray;
            return new ForConstant<boolean[]>(blArray, PropertyDelegate.ForArrayType.BOOLEAN);
        }

        public static AnnotationValue<byte[], byte[]> of(byte ... value) {
            byte[] byArray;
            return new ForConstant<byte[]>(byArray, PropertyDelegate.ForArrayType.BYTE);
        }

        public static AnnotationValue<short[], short[]> of(short ... value) {
            short[] sArray;
            return new ForConstant<short[]>(sArray, PropertyDelegate.ForArrayType.SHORT);
        }

        public static AnnotationValue<char[], char[]> of(char ... value) {
            char[] cArray;
            return new ForConstant<char[]>(cArray, PropertyDelegate.ForArrayType.CHARACTER);
        }

        public static AnnotationValue<int[], int[]> of(int ... value) {
            int[] nArray;
            return new ForConstant<int[]>(nArray, PropertyDelegate.ForArrayType.INTEGER);
        }

        public static AnnotationValue<long[], long[]> of(long ... value) {
            long[] lArray;
            return new ForConstant<long[]>(lArray, PropertyDelegate.ForArrayType.LONG);
        }

        public static AnnotationValue<float[], float[]> of(float ... value) {
            float[] fArray;
            return new ForConstant<float[]>(fArray, PropertyDelegate.ForArrayType.FLOAT);
        }

        public static AnnotationValue<double[], double[]> of(double ... value) {
            double[] dArray;
            return new ForConstant<double[]>(dArray, PropertyDelegate.ForArrayType.DOUBLE);
        }

        public static AnnotationValue<String[], String[]> of(String ... value) {
            String[] stringArray;
            return new ForConstant<String[]>(stringArray, PropertyDelegate.ForArrayType.STRING);
        }

        public static AnnotationValue<?, ?> of(Object value) {
            Object object;
            if (value instanceof Boolean) {
                return ForConstant.of((boolean)((Boolean)value));
            }
            if (value instanceof Byte) {
                return ForConstant.of((byte)((Byte)value));
            }
            if (value instanceof Short) {
                return ForConstant.of((short)((Short)value));
            }
            if (value instanceof Character) {
                return ForConstant.of(((Character)value).charValue());
            }
            if (value instanceof Integer) {
                return ForConstant.of((int)((Integer)value));
            }
            if (value instanceof Long) {
                return ForConstant.of((long)((Long)value));
            }
            if (value instanceof Float) {
                return ForConstant.of(((Float)value).floatValue());
            }
            if (value instanceof Double) {
                return ForConstant.of((double)((Double)value));
            }
            if (value instanceof String) {
                return ForConstant.of((String)value);
            }
            if (value instanceof boolean[]) {
                return ForConstant.of((boolean[])value);
            }
            if (value instanceof byte[]) {
                return ForConstant.of((byte[])value);
            }
            if (value instanceof short[]) {
                return ForConstant.of((short[])value);
            }
            if (value instanceof char[]) {
                return ForConstant.of((char[])value);
            }
            if (value instanceof int[]) {
                return ForConstant.of((int[])value);
            }
            if (value instanceof long[]) {
                return ForConstant.of((long[])value);
            }
            if (value instanceof float[]) {
                return ForConstant.of((float[])value);
            }
            if (value instanceof double[]) {
                return ForConstant.of((double[])value);
            }
            if (value instanceof String[]) {
                return ForConstant.of((String[])value);
            }
            throw new IllegalArgumentException("Not a constant annotation value: " + object);
        }

        @Override
        public State getState() {
            return State.RESOLVED;
        }

        @Override
        public Sort getSort() {
            return Sort.of(TypeDescription.ForLoadedType.of(this.value.getClass()).asUnboxed());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AnnotationValue<U, U> filter(MethodDescription.InDefinedShape property, TypeDefinition typeDefinition) {
            void var1_1;
            if (typeDefinition.asErasure().asBoxed().represents(this.value.getClass())) {
                return this;
            }
            if (this.value.getClass().isArray()) {
                return new ForMismatchedType(property, RenderingDispatcher.CURRENT.toArrayErrorString(Sort.of(TypeDescription.ForLoadedType.of(this.value.getClass().getComponentType()))));
            }
            if (this.value instanceof Enum) {
                return new ForMismatchedType(property, this.value.getClass().getName() + '.' + ((Enum)this.value).name());
            }
            return new ForMismatchedType((MethodDescription.InDefinedShape)var1_1, RenderingDispatcher.CURRENT.toTypeErrorString(this.value.getClass()) + '[' + this.value + ']');
        }

        @Override
        public U resolve() {
            return this.value;
        }

        @Override
        public net.bytebuddy.description.annotation.AnnotationValue$Loaded<U> load(@MaybeNull ClassLoader classLoader) {
            return new Loaded<U>(this.value, this.propertyDelegate);
        }

        @CachedReturnPlugin.Enhance(value="hashCode")
        public int hashCode() {
            int n;
            int n2 = this.hashCode;
            if (n2 != 0) {
                n = 0;
            } else {
                ForConstant forConstant = this;
                n = n2 = forConstant.propertyDelegate.hashCode(forConstant.value);
            }
            if (n == 0) {
                n2 = this.hashCode;
            } else {
                this.hashCode = n2;
            }
            return n2;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(@MaybeNull Object other) {
            void var1_1;
            return this == other || other instanceof AnnotationValue && this.propertyDelegate.equals(this.value, ((AnnotationValue)var1_1).resolve());
        }

        public String toString() {
            return this.propertyDelegate.toString(this.value);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class Loaded<V>
        extends Loaded.AbstractBase<V> {
            private final V value;
            private final PropertyDelegate propertyDelegate;
            private transient /* synthetic */ int hashCode;

            /*
             * WARNING - void declaration
             */
            protected Loaded(V value, PropertyDelegate propertyDelegate) {
                void var2_2;
                void var1_1;
                this.value = var1_1;
                this.propertyDelegate = var2_2;
            }

            @Override
            public State getState() {
                return State.RESOLVED;
            }

            @Override
            public V resolve() {
                return this.propertyDelegate.copy(this.value);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean represents(Object value) {
                void var1_1;
                return this.propertyDelegate.equals(this.value, var1_1);
            }

            @CachedReturnPlugin.Enhance(value="hashCode")
            public int hashCode() {
                int n;
                int n2 = this.hashCode;
                if (n2 != 0) {
                    n = 0;
                } else {
                    Loaded loaded = this;
                    n = n2 = loaded.propertyDelegate.hashCode(loaded.value);
                }
                if (n == 0) {
                    n2 = this.hashCode;
                } else {
                    this.hashCode = n2;
                }
                return n2;
            }

            /*
             * WARNING - void declaration
             */
            public boolean equals(@MaybeNull Object other) {
                void var1_1;
                if (this == other) {
                    return true;
                }
                if (!(other instanceof net.bytebuddy.description.annotation.AnnotationValue$Loaded)) {
                    return false;
                }
                net.bytebuddy.description.annotation.AnnotationValue$Loaded annotationValue = (net.bytebuddy.description.annotation.AnnotationValue$Loaded)other;
                return annotationValue.getState().isResolved() && this.propertyDelegate.equals(this.value, var1_1.resolve());
            }

            public String toString() {
                return this.propertyDelegate.toString(this.value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static interface PropertyDelegate {
            public <S> S copy(S var1);

            public int hashCode(Object var1);

            public boolean equals(Object var1, Object var2);

            public String toString(Object var1);

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum ForArrayType implements PropertyDelegate
            {
                BOOLEAN{

                    protected final Object doCopy(Object value) {
                        return ((boolean[])value).clone();
                    }

                    public final int hashCode(Object value) {
                        return Arrays.hashCode((boolean[])value);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final boolean equals(Object self, Object other) {
                        void var2_2;
                        void var1_1;
                        return other instanceof boolean[] && Arrays.equals((boolean[])var1_1, (boolean[])var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected final String toString(Object array, int index) {
                        void var2_2;
                        void var1_1;
                        return ForNonArrayType.BOOLEAN.toString(Array.getBoolean(var1_1, (int)var2_2));
                    }
                }
                ,
                BYTE{

                    protected final Object doCopy(Object value) {
                        return ((byte[])value).clone();
                    }

                    public final int hashCode(Object value) {
                        return Arrays.hashCode((byte[])value);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final boolean equals(Object self, Object other) {
                        void var2_2;
                        void var1_1;
                        return other instanceof byte[] && Arrays.equals((byte[])var1_1, (byte[])var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected final String toString(Object array, int index) {
                        void var2_2;
                        void var1_1;
                        return ForNonArrayType.BYTE.toString(Array.getByte(var1_1, (int)var2_2));
                    }
                }
                ,
                SHORT{

                    protected final Object doCopy(Object value) {
                        return ((short[])value).clone();
                    }

                    public final int hashCode(Object value) {
                        return Arrays.hashCode((short[])value);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final boolean equals(Object self, Object other) {
                        void var2_2;
                        void var1_1;
                        return other instanceof short[] && Arrays.equals((short[])var1_1, (short[])var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected final String toString(Object array, int index) {
                        void var2_2;
                        void var1_1;
                        return ForNonArrayType.SHORT.toString(Array.getShort(var1_1, (int)var2_2));
                    }
                }
                ,
                CHARACTER{

                    protected final Object doCopy(Object value) {
                        return ((char[])value).clone();
                    }

                    public final int hashCode(Object value) {
                        return Arrays.hashCode((char[])value);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final boolean equals(Object self, Object other) {
                        void var2_2;
                        void var1_1;
                        return other instanceof char[] && Arrays.equals((char[])var1_1, (char[])var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected final String toString(Object array, int index) {
                        void var2_2;
                        void var1_1;
                        return ForNonArrayType.CHARACTER.toString(Character.valueOf(Array.getChar(var1_1, (int)var2_2)));
                    }
                }
                ,
                INTEGER{

                    protected final Object doCopy(Object value) {
                        return ((int[])value).clone();
                    }

                    public final int hashCode(Object value) {
                        return Arrays.hashCode((int[])value);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final boolean equals(Object self, Object other) {
                        void var2_2;
                        void var1_1;
                        return other instanceof int[] && Arrays.equals((int[])var1_1, (int[])var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected final String toString(Object array, int index) {
                        void var2_2;
                        void var1_1;
                        return ForNonArrayType.INTEGER.toString(Array.getInt(var1_1, (int)var2_2));
                    }
                }
                ,
                LONG{

                    protected final Object doCopy(Object value) {
                        return ((long[])value).clone();
                    }

                    public final int hashCode(Object value) {
                        return Arrays.hashCode((long[])value);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final boolean equals(Object self, Object other) {
                        void var2_2;
                        void var1_1;
                        return other instanceof long[] && Arrays.equals((long[])var1_1, (long[])var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected final String toString(Object array, int index) {
                        void var2_2;
                        void var1_1;
                        return ForNonArrayType.LONG.toString(Array.getLong(var1_1, (int)var2_2));
                    }
                }
                ,
                FLOAT{

                    protected final Object doCopy(Object value) {
                        return ((float[])value).clone();
                    }

                    public final int hashCode(Object value) {
                        return Arrays.hashCode((float[])value);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final boolean equals(Object self, Object other) {
                        void var2_2;
                        void var1_1;
                        return other instanceof float[] && Arrays.equals((float[])var1_1, (float[])var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected final String toString(Object array, int index) {
                        void var2_2;
                        void var1_1;
                        return ForNonArrayType.FLOAT.toString(Float.valueOf(Array.getFloat(var1_1, (int)var2_2)));
                    }
                }
                ,
                DOUBLE{

                    protected final Object doCopy(Object value) {
                        return ((double[])value).clone();
                    }

                    public final int hashCode(Object value) {
                        return Arrays.hashCode((double[])value);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final boolean equals(Object self, Object other) {
                        void var2_2;
                        void var1_1;
                        return other instanceof double[] && Arrays.equals((double[])var1_1, (double[])var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected final String toString(Object array, int index) {
                        void var2_2;
                        void var1_1;
                        return ForNonArrayType.DOUBLE.toString(Array.getDouble(var1_1, (int)var2_2));
                    }
                }
                ,
                STRING{

                    protected final Object doCopy(Object value) {
                        return ((String[])value).clone();
                    }

                    public final int hashCode(Object value) {
                        return Arrays.hashCode((String[])value);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final boolean equals(Object self, Object other) {
                        void var2_2;
                        void var1_1;
                        return other instanceof String[] && Arrays.equals((String[])var1_1, (String[])var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected final String toString(Object array, int index) {
                        void var2_2;
                        void var1_1;
                        return ForNonArrayType.STRING.toString(Array.get(var1_1, (int)var2_2));
                    }
                };


                /*
                 * WARNING - void declaration
                 */
                @Override
                public <S> S copy(S value) {
                    void var1_1;
                    return (S)this.doCopy(var1_1);
                }

                protected abstract Object doCopy(Object var1);

                /*
                 * WARNING - void declaration
                 */
                @Override
                public String toString(Object value) {
                    void var2_2;
                    ArrayList<String> elements = new ArrayList<String>(Array.getLength(value));
                    for (int index = 0; index < Array.getLength(value); ++index) {
                        elements.add(this.toString(value, index));
                    }
                    return RenderingDispatcher.CURRENT.toSourceString((List<?>)var2_2);
                }

                protected abstract String toString(Object var1, int var2);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum ForNonArrayType implements PropertyDelegate
            {
                BOOLEAN{

                    /*
                     * WARNING - void declaration
                     */
                    public final String toString(Object value) {
                        void var1_1;
                        return RenderingDispatcher.CURRENT.toSourceString((Boolean)var1_1);
                    }
                }
                ,
                BYTE{

                    /*
                     * WARNING - void declaration
                     */
                    public final String toString(Object value) {
                        void var1_1;
                        return RenderingDispatcher.CURRENT.toSourceString((Byte)var1_1);
                    }
                }
                ,
                SHORT{

                    /*
                     * WARNING - void declaration
                     */
                    public final String toString(Object value) {
                        void var1_1;
                        return RenderingDispatcher.CURRENT.toSourceString((Short)var1_1);
                    }
                }
                ,
                CHARACTER{

                    /*
                     * WARNING - void declaration
                     */
                    public final String toString(Object value) {
                        void var1_1;
                        return RenderingDispatcher.CURRENT.toSourceString(((Character)var1_1).charValue());
                    }
                }
                ,
                INTEGER{

                    /*
                     * WARNING - void declaration
                     */
                    public final String toString(Object value) {
                        void var1_1;
                        return RenderingDispatcher.CURRENT.toSourceString((Integer)var1_1);
                    }
                }
                ,
                LONG{

                    /*
                     * WARNING - void declaration
                     */
                    public final String toString(Object value) {
                        void var1_1;
                        return RenderingDispatcher.CURRENT.toSourceString((Long)var1_1);
                    }
                }
                ,
                FLOAT{

                    /*
                     * WARNING - void declaration
                     */
                    public final String toString(Object value) {
                        void var1_1;
                        return RenderingDispatcher.CURRENT.toSourceString(((Float)var1_1).floatValue());
                    }
                }
                ,
                DOUBLE{

                    /*
                     * WARNING - void declaration
                     */
                    public final String toString(Object value) {
                        void var1_1;
                        return RenderingDispatcher.CURRENT.toSourceString((Double)var1_1);
                    }
                }
                ,
                STRING{

                    /*
                     * WARNING - void declaration
                     */
                    public final String toString(Object value) {
                        void var1_1;
                        return RenderingDispatcher.CURRENT.toSourceString((String)var1_1);
                    }
                };


                @Override
                public <S> S copy(S value) {
                    return value;
                }

                @Override
                public int hashCode(Object value) {
                    return value.hashCode();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean equals(Object self, Object other) {
                    void var2_2;
                    return self.equals(var2_2);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractBase<U, V>
    implements AnnotationValue<U, V> {
        @Override
        public <W> W resolve(Class<? extends W> type) {
            return type.cast(this.resolve());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AnnotationValue<U, V> filter(MethodDescription.InDefinedShape property) {
            void var1_1;
            void v0 = var1_1;
            return this.filter((MethodDescription.InDefinedShape)v0, v0.getReturnType());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sort {
        BOOLEAN(90),
        BYTE(66),
        SHORT(83),
        CHARACTER(67),
        INTEGER(73),
        LONG(74),
        FLOAT(70),
        DOUBLE(68),
        STRING(115),
        TYPE(99),
        ENUMERATION(101),
        ANNOTATION(64),
        ARRAY(91),
        NONE(0);

        private final int tag;

        /*
         * WARNING - void declaration
         */
        private Sort(int tag) {
            void var3_3;
            this.tag = var3_3;
        }

        public static Sort of(TypeDefinition typeDefinition) {
            TypeDefinition typeDefinition2;
            if (typeDefinition.represents(Boolean.TYPE)) {
                return BOOLEAN;
            }
            if (typeDefinition.represents(Byte.TYPE)) {
                return BYTE;
            }
            if (typeDefinition.represents(Short.TYPE)) {
                return SHORT;
            }
            if (typeDefinition.represents(Character.TYPE)) {
                return CHARACTER;
            }
            if (typeDefinition.represents(Integer.TYPE)) {
                return INTEGER;
            }
            if (typeDefinition.represents(Long.TYPE)) {
                return LONG;
            }
            if (typeDefinition.represents(Float.TYPE)) {
                return FLOAT;
            }
            if (typeDefinition.represents(Double.TYPE)) {
                return DOUBLE;
            }
            if (typeDefinition.represents((Type)((Object)String.class))) {
                return STRING;
            }
            if (typeDefinition.represents((Type)((Object)Class.class))) {
                return TYPE;
            }
            if (typeDefinition.isEnum()) {
                return ENUMERATION;
            }
            if (typeDefinition.isAnnotation()) {
                return ANNOTATION;
            }
            if (typeDefinition2.isArray()) {
                return ARRAY;
            }
            return NONE;
        }

        protected final int getTag() {
            return this.tag;
        }

        public final boolean isDefined() {
            return this != NONE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        UNDEFINED,
        UNRESOLVED,
        RESOLVED;


        public final boolean isDefined() {
            return this != UNDEFINED;
        }

        public final boolean isResolved() {
            return this == RESOLVED;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Loaded<U> {
        public State getState();

        public U resolve();

        public <V> V resolve(Class<? extends V> var1);

        public boolean represents(Object var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class AbstractBase<W>
        implements Loaded<W> {
            @Override
            public <X> X resolve(Class<? extends X> type) {
                return type.cast(this.resolve());
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static abstract class ForUnresolvedProperty<Z>
            extends AbstractBase<Z> {
                @Override
                public State getState() {
                    return State.UNRESOLVED;
                }

                @Override
                public boolean represents(Object value) {
                    return false;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class RenderingDispatcher
    extends Enum<RenderingDispatcher> {
        public static final /* enum */ RenderingDispatcher LEGACY_VM;
        public static final /* enum */ RenderingDispatcher JAVA_9_CAPABLE_VM;
        public static final /* enum */ RenderingDispatcher JAVA_14_CAPABLE_VM;
        public static final /* enum */ RenderingDispatcher JAVA_17_CAPABLE_VM;
        public static final /* enum */ RenderingDispatcher JAVA_19_CAPABLE_VM;
        private static final String ARRAY_PREFIX = "Array with component tag: ";
        public static final RenderingDispatcher CURRENT;
        private final char openingBrace;
        private final char closingBrace;
        private final boolean componentAsInteger;
        private static final /* synthetic */ RenderingDispatcher[] $VALUES;

        public static RenderingDispatcher[] values() {
            return (RenderingDispatcher[])$VALUES.clone();
        }

        public static RenderingDispatcher valueOf(String name) {
            String string;
            return Enum.valueOf(RenderingDispatcher.class, string);
        }

        /*
         * WARNING - void declaration
         */
        private RenderingDispatcher(char openingBrace, char closingBrace, boolean componentAsInteger) {
            void var3_3;
            this.openingBrace = var3_3;
            this.closingBrace = closingBrace;
            this.componentAsInteger = componentAsInteger;
        }

        public String toSourceString(boolean value) {
            return Boolean.toString(value);
        }

        public String toSourceString(byte value) {
            return Byte.toString(value);
        }

        public String toSourceString(short value) {
            return Short.toString(value);
        }

        public abstract String toSourceString(char var1);

        public String toSourceString(int value) {
            return Integer.toString(value);
        }

        public abstract String toSourceString(long var1);

        public abstract String toSourceString(float var1);

        public abstract String toSourceString(double var1);

        public abstract String toSourceString(String var1);

        public abstract String toSourceString(TypeDescription var1);

        /*
         * WARNING - void declaration
         */
        public String toSourceString(List<?> values) {
            void var2_2;
            Iterator iterator;
            StringBuilder stringBuilder = new StringBuilder().append(this.openingBrace);
            boolean first = true;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                if (first) {
                    first = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(value);
            }
            return var2_2.append(this.closingBrace).toString();
        }

        /*
         * WARNING - void declaration
         */
        public String toArrayErrorString(Sort sort) {
            void var1_1;
            return ARRAY_PREFIX + (this.componentAsInteger || !sort.isDefined() ? Integer.toString(sort.getTag()) : Character.toString((char)var1_1.getTag()));
        }

        public String toTypeErrorString(Class<?> type) {
            return type.toString();
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var0;
            LEGACY_VM = new RenderingDispatcher('[', ']', true){
                {
                    void var3_3;
                }

                public final String toSourceString(char value) {
                    return Character.toString(value);
                }

                public final String toSourceString(long value) {
                    return Long.toString(value);
                }

                public final String toSourceString(float value) {
                    return Float.toString(value);
                }

                public final String toSourceString(double value) {
                    return Double.toString(value);
                }

                public final String toSourceString(String value) {
                    return value;
                }

                public final String toSourceString(TypeDescription value) {
                    return value.toString();
                }
            };
            JAVA_9_CAPABLE_VM = new RenderingDispatcher('{', '}', true){
                {
                    void var3_3;
                }

                /*
                 * WARNING - void declaration
                 */
                public final String toSourceString(char value) {
                    void var2_2;
                    StringBuilder stringBuilder = new StringBuilder("'");
                    if (value == '\'') {
                        stringBuilder.append("\\'");
                    } else {
                        void var1_1;
                        stringBuilder.append((char)var1_1);
                    }
                    return var2_2.append('\'').toString();
                }

                /*
                 * WARNING - void declaration
                 */
                public final String toSourceString(long value) {
                    void var1_1;
                    if (Math.abs(value) <= Integer.MAX_VALUE) {
                        return String.valueOf(value);
                    }
                    return (long)var1_1 + "L";
                }

                /*
                 * WARNING - void declaration
                 */
                public final String toSourceString(float value) {
                    if (Math.abs(value) <= Float.MAX_VALUE) {
                        return value + "f";
                    }
                    if (Float.isInfinite(value)) {
                        void var1_1;
                        if (var1_1 < 0.0f) {
                            return "-1.0f/0.0f";
                        }
                        return "1.0f/0.0f";
                    }
                    return "0.0f/0.0f";
                }

                /*
                 * WARNING - void declaration
                 */
                public final String toSourceString(double value) {
                    if (Math.abs(value) <= Double.MAX_VALUE) {
                        return Double.toString(value);
                    }
                    if (Double.isInfinite(value)) {
                        void var1_1;
                        if (var1_1 < 0.0) {
                            return "-1.0/0.0";
                        }
                        return "1.0/0.0";
                    }
                    return "0.0/0.0";
                }

                /*
                 * WARNING - void declaration
                 */
                public final String toSourceString(String value) {
                    void var1_1;
                    return "\"" + (value.indexOf(34) == -1 ? value : var1_1.replace("\"", "\\\"")) + "\"";
                }

                /*
                 * WARNING - void declaration
                 */
                public final String toSourceString(TypeDescription value) {
                    void var1_1;
                    return var1_1.getActualName() + ".class";
                }
            };
            JAVA_14_CAPABLE_VM = new RenderingDispatcher('{', '}', true){
                {
                    void var3_3;
                }

                /*
                 * WARNING - void declaration
                 */
                public final String toSourceString(byte value) {
                    void var1_1;
                    return "(byte)0x" + Integer.toHexString(var1_1 & 0xFF);
                }

                /*
                 * WARNING - void declaration
                 */
                public final String toSourceString(char value) {
                    void var2_2;
                    StringBuilder stringBuilder = new StringBuilder("'");
                    if (value == '\'') {
                        stringBuilder.append("\\'");
                    } else {
                        void var1_1;
                        stringBuilder.append((char)var1_1);
                    }
                    return var2_2.append('\'').toString();
                }

                /*
                 * WARNING - void declaration
                 */
                public final String toSourceString(long value) {
                    void var1_1;
                    return (long)var1_1 + "L";
                }

                /*
                 * WARNING - void declaration
                 */
                public final String toSourceString(float value) {
                    if (Math.abs(value) <= Float.MAX_VALUE) {
                        return value + "f";
                    }
                    if (Float.isInfinite(value)) {
                        void var1_1;
                        if (var1_1 < 0.0f) {
                            return "-1.0f/0.0f";
                        }
                        return "1.0f/0.0f";
                    }
                    return "0.0f/0.0f";
                }

                /*
                 * WARNING - void declaration
                 */
                public final String toSourceString(double value) {
                    if (Math.abs(value) <= Double.MAX_VALUE) {
                        return Double.toString(value);
                    }
                    if (Double.isInfinite(value)) {
                        void var1_1;
                        if (var1_1 < 0.0) {
                            return "-1.0/0.0";
                        }
                        return "1.0/0.0";
                    }
                    return "0.0/0.0";
                }

                /*
                 * WARNING - void declaration
                 */
                public final String toSourceString(String value) {
                    void var1_1;
                    return "\"" + (value.indexOf(34) == -1 ? value : var1_1.replace("\"", "\\\"")) + "\"";
                }

                /*
                 * WARNING - void declaration
                 */
                public final String toSourceString(TypeDescription value) {
                    void var1_1;
                    return var1_1.getActualName() + ".class";
                }
            };
            JAVA_17_CAPABLE_VM = new RenderingDispatcher('{', '}', false){
                {
                    void var3_3;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final String toSourceString(byte value) {
                    void var1_1;
                    return "(byte)0x" + Integer.toHexString(var1_1 & 0xFF);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final String toSourceString(char value) {
                    void var2_2;
                    StringBuilder stringBuilder = new StringBuilder("'");
                    if (value == '\'') {
                        stringBuilder.append("\\'");
                    } else {
                        void var1_1;
                        stringBuilder.append((char)var1_1);
                    }
                    return var2_2.append('\'').toString();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final String toSourceString(long value) {
                    void var1_1;
                    return (long)var1_1 + "L";
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final String toSourceString(float value) {
                    if (Math.abs(value) <= Float.MAX_VALUE) {
                        return value + "f";
                    }
                    if (Float.isInfinite(value)) {
                        void var1_1;
                        if (var1_1 < 0.0f) {
                            return "-1.0f/0.0f";
                        }
                        return "1.0f/0.0f";
                    }
                    return "0.0f/0.0f";
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final String toSourceString(double value) {
                    if (Math.abs(value) <= Double.MAX_VALUE) {
                        return Double.toString(value);
                    }
                    if (Double.isInfinite(value)) {
                        void var1_1;
                        if (var1_1 < 0.0) {
                            return "-1.0/0.0";
                        }
                        return "1.0/0.0";
                    }
                    return "0.0/0.0";
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final String toSourceString(String value) {
                    void var1_1;
                    return "\"" + (value.indexOf(34) == -1 ? value : var1_1.replace("\"", "\\\"")) + "\"";
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final String toSourceString(TypeDescription value) {
                    void var1_1;
                    return var1_1.getActualName() + ".class";
                }

                @Override
                public final String toTypeErrorString(Class<?> type) {
                    return type.getName();
                }
            };
            JAVA_19_CAPABLE_VM = new RenderingDispatcher('{', '}', ClassFileVersion.ofThisVm(ClassFileVersion.JAVA_V5).isLessThan(ClassFileVersion.JAVA_V17)){
                {
                    void var3_3;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final String toSourceString(byte value) {
                    void var1_1;
                    return "(byte)0x" + Integer.toHexString(var1_1 & 0xFF);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final String toSourceString(char value) {
                    void var2_2;
                    StringBuilder stringBuilder = new StringBuilder("'");
                    if (value == '\'') {
                        stringBuilder.append("\\'");
                    } else {
                        void var1_1;
                        stringBuilder.append((char)var1_1);
                    }
                    return var2_2.append('\'').toString();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final String toSourceString(long value) {
                    void var1_1;
                    return (long)var1_1 + "L";
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final String toSourceString(float value) {
                    if (Math.abs(value) <= Float.MAX_VALUE) {
                        return value + "f";
                    }
                    if (Float.isInfinite(value)) {
                        void var1_1;
                        if (var1_1 < 0.0f) {
                            return "-1.0f/0.0f";
                        }
                        return "1.0f/0.0f";
                    }
                    return "0.0f/0.0f";
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final String toSourceString(double value) {
                    if (Math.abs(value) <= Double.MAX_VALUE) {
                        return Double.toString(value);
                    }
                    if (Double.isInfinite(value)) {
                        void var1_1;
                        if (var1_1 < 0.0) {
                            return "-1.0/0.0";
                        }
                        return "1.0/0.0";
                    }
                    return "0.0/0.0";
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final String toSourceString(String value) {
                    void var1_1;
                    return "\"" + (value.indexOf(34) == -1 ? value : var1_1.replace("\"", "\\\"")) + "\"";
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final String toSourceString(TypeDescription value) {
                    void var1_1;
                    return var1_1.getCanonicalName() + ".class";
                }

                @Override
                public final String toTypeErrorString(Class<?> type) {
                    return type.getName();
                }
            };
            $VALUES = new RenderingDispatcher[]{LEGACY_VM, JAVA_9_CAPABLE_VM, JAVA_14_CAPABLE_VM, JAVA_17_CAPABLE_VM, JAVA_19_CAPABLE_VM};
            ClassFileVersion classFileVersion = ClassFileVersion.ofThisVm(ClassFileVersion.JAVA_V5);
            CURRENT = classFileVersion.isAtLeast(ClassFileVersion.JAVA_V19) ? JAVA_19_CAPABLE_VM : (classFileVersion.isAtLeast(ClassFileVersion.JAVA_V17) ? JAVA_17_CAPABLE_VM : (classFileVersion.isAtLeast(ClassFileVersion.JAVA_V14) ? JAVA_14_CAPABLE_VM : (var0.isAtLeast(ClassFileVersion.JAVA_V9) ? JAVA_9_CAPABLE_VM : LEGACY_VM)));
        }
    }
}

