/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.FilterableList;
import net.bytebuddy.utility.nullability.AlwaysNull;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface AnnotationList
extends FilterableList<AnnotationDescription, AnnotationList> {
    public boolean isAnnotationPresent(Class<? extends Annotation> var1);

    public boolean isAnnotationPresent(TypeDescription var1);

    @MaybeNull
    public <T extends Annotation> AnnotationDescription.Loadable<T> ofType(Class<T> var1);

    public AnnotationDescription ofType(TypeDescription var1);

    public AnnotationList inherited(Set<? extends TypeDescription> var1);

    public AnnotationList visibility(ElementMatcher<? super RetentionPolicy> var1);

    public TypeList asTypeList();

    public List<String> asTypeNames();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Empty
    extends FilterableList.Empty<AnnotationDescription, AnnotationList>
    implements AnnotationList {
        /*
         * WARNING - void declaration
         */
        public static List<AnnotationList> asList(int length) {
            void var1_1;
            ArrayList<Empty> result = new ArrayList<Empty>(length);
            for (int i = 0; i < length; ++i) {
                result.add(new Empty());
            }
            return var1_1;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return false;
        }

        @Override
        public boolean isAnnotationPresent(TypeDescription annotationType) {
            return false;
        }

        @Override
        @AlwaysNull
        public <T extends Annotation> AnnotationDescription.Loadable<T> ofType(Class<T> annotationType) {
            return AnnotationDescription.UNDEFINED;
        }

        @Override
        @AlwaysNull
        public AnnotationDescription ofType(TypeDescription annotationType) {
            return AnnotationDescription.UNDEFINED;
        }

        @Override
        public AnnotationList inherited(Set<? extends TypeDescription> ignoredTypes) {
            return this;
        }

        @Override
        public AnnotationList visibility(ElementMatcher<? super RetentionPolicy> matcher) {
            return this;
        }

        @Override
        public TypeList asTypeList() {
            return new TypeList.Empty();
        }

        @Override
        public List<String> asTypeNames() {
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Explicit
    extends AbstractBase {
        private final List<? extends AnnotationDescription> annotationDescriptions;

        /*
         * WARNING - void declaration
         */
        public Explicit(AnnotationDescription ... annotationDescription) {
            this(Arrays.asList(var1_1));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Explicit(List<? extends AnnotationDescription> annotationDescriptions) {
            void var1_1;
            this.annotationDescriptions = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static List<AnnotationList> asList(List<? extends List<? extends AnnotationDescription>> annotations) {
            void var1_1;
            Iterator<? extends List<? extends AnnotationDescription>> iterator;
            ArrayList<Explicit> result = new ArrayList<Explicit>(annotations.size());
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                List annotation = (List)iterator.next();
                result.add(new Explicit((List<? extends AnnotationDescription>)var2_2));
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AnnotationDescription get(int index) {
            void var1_1;
            return this.annotationDescriptions.get((int)var1_1);
        }

        @Override
        public int size() {
            return this.annotationDescriptions.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForLoadedAnnotations
    extends AbstractBase {
        private final List<? extends Annotation> annotations;

        /*
         * WARNING - void declaration
         */
        public ForLoadedAnnotations(Annotation ... annotation) {
            this(Arrays.asList(var1_1));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ForLoadedAnnotations(List<? extends Annotation> annotations) {
            void var1_1;
            this.annotations = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static List<AnnotationList> asList(Annotation[][] annotations) {
            void var1_1;
            Annotation[][] annotationArray;
            ArrayList<ForLoadedAnnotations> result = new ArrayList<ForLoadedAnnotations>(annotations.length);
            for (Annotation[] annotation : annotationArray) {
                result.add(new ForLoadedAnnotations(annotation));
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AnnotationDescription get(int index) {
            void var1_1;
            return AnnotationDescription.ForLoadedAnnotation.of(this.annotations.get((int)var1_1));
        }

        @Override
        public int size() {
            return this.annotations.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractBase
    extends FilterableList.AbstractBase<AnnotationDescription, AnnotationList>
    implements AnnotationList {
        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            for (AnnotationDescription annotationDescription : this) {
                if (!annotationDescription.getAnnotationType().represents(annotationType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isAnnotationPresent(TypeDescription annotationType) {
            for (AnnotationDescription annotationDescription : this) {
                if (!annotationDescription.getAnnotationType().equals(annotationType)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @MaybeNull
        public <T extends Annotation> AnnotationDescription.Loadable<T> ofType(Class<T> annotationType) {
            for (AnnotationDescription annotation : this) {
                void var3_3;
                if (!annotation.getAnnotationType().represents(annotationType)) continue;
                return var3_3.prepare(annotationType);
            }
            return AnnotationDescription.UNDEFINED;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @MaybeNull
        public AnnotationDescription ofType(TypeDescription annotationType) {
            for (AnnotationDescription annotation : this) {
                void var3_3;
                if (!annotation.getAnnotationType().equals(annotationType)) continue;
                return var3_3;
            }
            return AnnotationDescription.UNDEFINED;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AnnotationList inherited(Set<? extends TypeDescription> ignoredTypes) {
            void var2_2;
            ArrayList<AnnotationDescription> inherited = new ArrayList<AnnotationDescription>(this.size());
            for (AnnotationDescription annotation : this) {
                if (ignoredTypes.contains(annotation.getAnnotationType()) || !annotation.isInherited()) continue;
                inherited.add(annotation);
            }
            return this.wrap((List)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AnnotationList visibility(ElementMatcher<? super RetentionPolicy> matcher) {
            void var2_2;
            ArrayList<AnnotationDescription> annotationDescriptions = new ArrayList<AnnotationDescription>(this.size());
            for (AnnotationDescription annotation : this) {
                if (!matcher.matches(annotation.getRetention())) continue;
                annotationDescriptions.add(annotation);
            }
            return this.wrap((List)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public TypeList asTypeList() {
            void var1_1;
            ArrayList<TypeDescription> annotationTypes = new ArrayList<TypeDescription>(this.size());
            for (AnnotationDescription annotation : this) {
                void var3_3;
                annotationTypes.add(var3_3.getAnnotationType());
            }
            return new TypeList.Explicit((List<? extends TypeDescription>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<String> asTypeNames() {
            void var1_1;
            ArrayList<String> typeNames = new ArrayList<String>(this.size());
            for (AnnotationDescription annotation : this) {
                void var3_3;
                typeNames.add(var3_3.getAnnotationType().getName());
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected AnnotationList wrap(List<AnnotationDescription> values) {
            void var1_1;
            return new Explicit((List<? extends AnnotationDescription>)var1_1);
        }
    }
}

