/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.annotation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationTypeMismatchException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.build.AccessControllerPlugin;
import net.bytebuddy.build.CachedReturnPlugin;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.annotation.AnnotationValue;
import net.bytebuddy.description.enumeration.EnumerationDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.nullability.AlwaysNull;
import net.bytebuddy.utility.nullability.MaybeNull;
import net.bytebuddy.utility.privilege.SetAccessibleAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface AnnotationDescription {
    @AlwaysNull
    public static final Loadable<?> UNDEFINED = null;

    public AnnotationValue<?, ?> getValue(String var1);

    public AnnotationValue<?, ?> getValue(MethodDescription.InDefinedShape var1);

    public TypeDescription getAnnotationType();

    public <T extends Annotation> Loadable<T> prepare(Class<T> var1);

    public RetentionPolicy getRetention();

    public Set<ElementType> getElementTypes();

    public boolean isSupportedOn(ElementType var1);

    public boolean isSupportedOn(String var1);

    public boolean isInherited();

    public boolean isDocumented();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Builder {
        private final TypeDescription annotationType;
        private final Map<String, AnnotationValue<?, ?>> annotationValues;

        /*
         * WARNING - void declaration
         */
        protected Builder(TypeDescription annotationType, Map<String, AnnotationValue<?, ?>> annotationValues) {
            void var2_2;
            void var1_1;
            this.annotationType = var1_1;
            this.annotationValues = var2_2;
        }

        public static Builder ofType(Class<? extends Annotation> annotationType) {
            return Builder.ofType(TypeDescription.ForLoadedType.of(annotationType));
        }

        public static Builder ofType(TypeDescription annotationType) {
            TypeDescription typeDescription;
            if (!annotationType.isAnnotation()) {
                throw new IllegalArgumentException("Not an annotation type: " + annotationType);
            }
            return new Builder(typeDescription, Collections.<String, AnnotationValue<?, ?>>emptyMap());
        }

        /*
         * WARNING - void declaration
         */
        public Builder define(String property, AnnotationValue<?, ?> value) {
            void var2_2;
            void var3_3;
            MethodList methodDescriptions = (MethodList)this.annotationType.getDeclaredMethods().filter(ElementMatchers.named(property));
            if (methodDescriptions.isEmpty()) {
                throw new IllegalArgumentException(this.annotationType + " does not define a property named " + property);
            }
            HashMap annotationValues = new HashMap(this.annotationValues);
            if (annotationValues.put(((MethodDescription.InDefinedShape)var3_3.getOnly()).getName(), (AnnotationValue<?, ?>)var2_2) != null) {
                void var1_1;
                throw new IllegalArgumentException("Property already defined: " + (String)var1_1);
            }
            return new Builder(this.annotationType, annotationValues);
        }

        /*
         * WARNING - void declaration
         */
        public Builder define(String property, Enum<?> value) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, new EnumerationDescription.ForLoadedEnumeration((Enum<?>)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public Builder define(String property, TypeDescription enumerationType, String value) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, new EnumerationDescription.Latent((TypeDescription)var2_2, (String)var3_3));
        }

        /*
         * WARNING - void declaration
         */
        public Builder define(String property, EnumerationDescription value) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, AnnotationValue.ForEnumerationDescription.of((EnumerationDescription)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public Builder define(String property, Annotation annotation) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, new ForLoadedAnnotation<void>(var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public Builder define(String property, AnnotationDescription annotationDescription) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, new AnnotationValue.ForAnnotationDescription((AnnotationDescription)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public Builder define(String property, Class<?> type) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, TypeDescription.ForLoadedType.of(var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public Builder define(String property, TypeDescription typeDescription) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, AnnotationValue.ForTypeDescription.of((TypeDescription)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Enum<?>> Builder defineEnumerationArray(String property, Class<T> enumerationType, T ... value) {
            void var2_2;
            void var1_1;
            void var3_3;
            EnumerationDescription[] enumerationDescription = new EnumerationDescription[value.length];
            int index = 0;
            for (void aValue : var3_3) {
                enumerationDescription[index++] = new EnumerationDescription.ForLoadedEnumeration((Enum<?>)aValue);
            }
            return this.defineEnumerationArray((String)var1_1, TypeDescription.ForLoadedType.of(var2_2), enumerationDescription);
        }

        /*
         * WARNING - void declaration
         */
        public Builder defineEnumerationArray(String property, TypeDescription enumerationType, String ... value) {
            void var2_2;
            void var1_1;
            if (!enumerationType.isEnum()) {
                throw new IllegalArgumentException("Not an enumeration type: " + enumerationType);
            }
            EnumerationDescription[] enumerationDescription = new EnumerationDescription[value.length];
            for (int i = 0; i < value.length; ++i) {
                enumerationDescription[i] = new EnumerationDescription.Latent(enumerationType, value[i]);
            }
            return this.defineEnumerationArray((String)var1_1, (TypeDescription)var2_2, enumerationDescription);
        }

        /*
         * WARNING - void declaration
         */
        public Builder defineEnumerationArray(String property, TypeDescription enumerationType, EnumerationDescription ... value) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, AnnotationValue.ForDescriptionArray.of((TypeDescription)var2_2, (EnumerationDescription[])var3_3));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> Builder defineAnnotationArray(String property, Class<T> annotationType, T ... annotation) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.defineAnnotationArray((String)var1_1, TypeDescription.ForLoadedType.of(var2_2), new AnnotationList.ForLoadedAnnotations((Annotation[])var3_3).toArray(new AnnotationDescription[0]));
        }

        /*
         * WARNING - void declaration
         */
        public Builder defineAnnotationArray(String property, TypeDescription annotationType, AnnotationDescription ... annotationDescription) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, AnnotationValue.ForDescriptionArray.of((TypeDescription)var2_2, (AnnotationDescription[])var3_3));
        }

        /*
         * WARNING - void declaration
         */
        public Builder defineTypeArray(String property, Class<?> ... type) {
            void var2_2;
            void var1_1;
            return this.defineTypeArray((String)var1_1, new TypeList.ForLoadedTypes((Class<?>)var2_2).toArray(new TypeDescription[0]));
        }

        /*
         * WARNING - void declaration
         */
        public Builder defineTypeArray(String property, TypeDescription ... typeDescription) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, AnnotationValue.ForDescriptionArray.of((TypeDescription[])var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public Builder define(String property, boolean value) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, AnnotationValue.ForConstant.of((boolean)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public Builder define(String property, byte value) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, AnnotationValue.ForConstant.of((byte)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public Builder define(String property, char value) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, AnnotationValue.ForConstant.of((char)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public Builder define(String property, short value) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, AnnotationValue.ForConstant.of((short)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public Builder define(String property, int value) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, AnnotationValue.ForConstant.of((int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public Builder define(String property, long value) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, AnnotationValue.ForConstant.of((long)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public Builder define(String property, float value) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, AnnotationValue.ForConstant.of((float)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public Builder define(String property, double value) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, AnnotationValue.ForConstant.of((double)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public Builder define(String property, String value) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, AnnotationValue.ForConstant.of((String)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public Builder defineArray(String property, boolean ... value) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, AnnotationValue.ForConstant.of((boolean[])var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public Builder defineArray(String property, byte ... value) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, AnnotationValue.ForConstant.of((byte[])var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public Builder defineArray(String property, char ... value) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, AnnotationValue.ForConstant.of((char[])var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public Builder defineArray(String property, short ... value) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, AnnotationValue.ForConstant.of((short[])var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public Builder defineArray(String property, int ... value) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, AnnotationValue.ForConstant.of((int[])var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public Builder defineArray(String property, long ... value) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, AnnotationValue.ForConstant.of((long[])var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public Builder defineArray(String property, float ... value) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, AnnotationValue.ForConstant.of((float[])var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public Builder defineArray(String property, double ... value) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, AnnotationValue.ForConstant.of((double[])var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public Builder defineArray(String property, String ... value) {
            void var2_2;
            void var1_1;
            return this.define((String)var1_1, AnnotationValue.ForConstant.of((String[])var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public AnnotationDescription build() {
            for (MethodDescription.InDefinedShape methodDescription : this.annotationType.getDeclaredMethods()) {
                void var3_3;
                void var2_2;
                AnnotationValue<?, ?> annotationValue = this.annotationValues.get(methodDescription.getName());
                if (annotationValue == null && methodDescription.getDefaultValue() == null) {
                    throw new IllegalStateException("No value or default value defined for " + methodDescription.getName());
                }
                if (annotationValue == null || annotationValue.filter(methodDescription).getState() == AnnotationValue.State.RESOLVED) continue;
                throw new IllegalStateException("Illegal annotation value for " + var2_2 + ": " + var3_3);
            }
            return new Latent(this.annotationType, this.annotationValues);
        }

        public AnnotationDescription build(boolean validated) {
            if (validated) {
                return this.build();
            }
            return new Latent(this.annotationType, this.annotationValues);
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.annotationType.equals(((Builder)object).annotationType)) {
                return false;
            }
            return ((Object)this.annotationValues).equals(((Builder)object).annotationValues);
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + this.annotationType.hashCode()) * 31 + ((Object)this.annotationValues).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Latent
    extends AbstractBase {
        private final TypeDescription annotationType;
        private final Map<String, ? extends AnnotationValue<?, ?>> annotationValues;

        /*
         * WARNING - void declaration
         */
        protected Latent(TypeDescription annotationType, Map<String, ? extends AnnotationValue<?, ?>> annotationValues) {
            void var2_2;
            void var1_1;
            this.annotationType = var1_1;
            this.annotationValues = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AnnotationValue<?, ?> getValue(MethodDescription.InDefinedShape property) {
            void var2_2;
            if (!property.getDeclaringType().equals(this.annotationType)) {
                throw new IllegalArgumentException("Not a property of " + this.annotationType + ": " + property);
            }
            AnnotationValue<?, ?> value = this.annotationValues.get(property.getName());
            if (value != null) {
                return value.filter(property);
            }
            AnnotationValue<?, ?> defaultValue = property.getDefaultValue();
            if (defaultValue == null) {
                void var1_1;
                return new AnnotationValue.ForMissingValue(this.annotationType, var1_1.getName());
            }
            return var2_2;
        }

        @Override
        public TypeDescription getAnnotationType() {
            return this.annotationType;
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> Loadable<T> prepare(Class<T> annotationType) {
            void var1_1;
            if (!this.annotationType.represents(annotationType)) {
                throw new IllegalArgumentException(annotationType + " does not represent " + this.annotationType);
            }
            return new Loadable(this, var1_1);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class Loadable<S extends Annotation>
        extends AbstractBase
        implements net.bytebuddy.description.annotation.AnnotationDescription$Loadable<S> {
            private final Class<S> annotationType;
            final /* synthetic */ Latent this$0;

            /*
             * WARNING - void declaration
             */
            protected Loadable(Latent this$0, Class<S> annotationType) {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.annotationType = var2_2;
            }

            @Override
            public S load() {
                return AnnotationInvocationHandler.of(this.annotationType.getClassLoader(), this.annotationType, this.this$0.annotationValues);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public AnnotationValue<?, ?> getValue(MethodDescription.InDefinedShape property) {
                void var1_1;
                return this.this$0.getValue((MethodDescription.InDefinedShape)var1_1);
            }

            @Override
            public TypeDescription getAnnotationType() {
                return TypeDescription.ForLoadedType.of(this.annotationType);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public <T extends Annotation> net.bytebuddy.description.annotation.AnnotationDescription$Loadable<T> prepare(Class<T> annotationType) {
                void var1_1;
                return this.this$0.prepare((Class)var1_1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForLoadedAnnotation<S extends Annotation>
    extends AbstractBase
    implements Loadable<S> {
        private static final Object[] NO_ARGUMENT;
        private final S annotation;
        private final Class<S> annotationType;
        private static final boolean ACCESS_CONTROLLER;

        /*
         * WARNING - void declaration
         */
        protected ForLoadedAnnotation(S annotation) {
            void var1_1;
            void v0 = var1_1;
            this((Annotation)v0, v0.annotationType());
        }

        /*
         * WARNING - void declaration
         */
        private ForLoadedAnnotation(S annotation, Class<S> annotationType) {
            void var2_2;
            void var1_1;
            this.annotation = var1_1;
            this.annotationType = var2_2;
        }

        @AccessControllerPlugin.Enhance
        private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
            if (ACCESS_CONTROLLER) {
                return AccessController.doPrivileged(privilegedAction);
            }
            return privilegedAction.run();
        }

        public static <U extends Annotation> Loadable<U> of(U annotation) {
            U u;
            return new ForLoadedAnnotation<U>(u);
        }

        @Override
        public S load() {
            if (this.annotationType == this.annotation.annotationType()) {
                return this.annotation;
            }
            return AnnotationInvocationHandler.of(this.annotationType.getClassLoader(), this.annotationType, ForLoadedAnnotation.asValue(this.annotation));
        }

        /*
         * WARNING - void declaration
         */
        private static Map<String, AnnotationValue<?, ?>> asValue(Annotation annotation) {
            void var1_1;
            HashMap<String, AnnotationValue<Object, Object>> annotationValues = new HashMap<String, AnnotationValue<Object, Object>>();
            for (Method property : annotation.annotationType().getDeclaredMethods()) {
                try {
                    annotationValues.put(property.getName(), ForLoadedAnnotation.asValue(property.invoke((Object)annotation, NO_ARGUMENT), property.getReturnType()));
                }
                catch (InvocationTargetException invocationTargetException) {
                    InvocationTargetException invocationTargetException2 = invocationTargetException;
                    Throwable cause = invocationTargetException.getTargetException();
                    if (cause instanceof TypeNotPresentException) {
                        annotationValues.put(property.getName(), new AnnotationValue.ForMissingType(((TypeNotPresentException)cause).typeName()));
                        continue;
                    }
                    if (cause instanceof EnumConstantNotPresentException) {
                        annotationValues.put(property.getName(), new AnnotationValue.ForEnumerationDescription.WithUnknownConstant(new TypeDescription.ForLoadedType(((EnumConstantNotPresentException)cause).enumType()), ((EnumConstantNotPresentException)cause).constantName()));
                        continue;
                    }
                    if (cause instanceof AnnotationTypeMismatchException) {
                        annotationValues.put(property.getName(), new AnnotationValue.ForMismatchedType(new MethodDescription.ForLoadedMethod(((AnnotationTypeMismatchException)cause).element()), ((AnnotationTypeMismatchException)cause).foundType()));
                        continue;
                    }
                    if (cause instanceof IncompleteAnnotationException) continue;
                    throw new IllegalStateException("Cannot read " + property, cause);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + property, exception);
                }
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static AnnotationValue<?, ?> asValue(Object value, Class<?> type) {
            Object[] objectArray;
            void var1_1;
            Object[] element;
            if (Enum.class.isAssignableFrom(type)) {
                return AnnotationValue.ForEnumerationDescription.of(new EnumerationDescription.ForLoadedEnumeration((Enum)value));
            }
            if (Enum[].class.isAssignableFrom(type)) {
                element = (Enum[])value;
                EnumerationDescription[] enumerationDescription = new EnumerationDescription[element.length];
                int index = 0;
                for (Object anElement : element) {
                    enumerationDescription[index++] = new EnumerationDescription.ForLoadedEnumeration((Enum<?>)anElement);
                }
                return AnnotationValue.ForDescriptionArray.of(TypeDescription.ForLoadedType.of(type.getComponentType()), enumerationDescription);
            }
            if (Annotation.class.isAssignableFrom(type)) {
                return AnnotationValue.ForAnnotationDescription.of(TypeDescription.ForLoadedType.of(type), ForLoadedAnnotation.asValue((Annotation)element));
            }
            if (Annotation[].class.isAssignableFrom(type)) {
                element = (Annotation[])element;
                AnnotationDescription[] annotationDescription = new AnnotationDescription[element.length];
                int index = 0;
                for (Object anElement : element) {
                    annotationDescription[index++] = new Latent(TypeDescription.ForLoadedType.of(type.getComponentType()), ForLoadedAnnotation.asValue((Annotation)anElement));
                }
                return AnnotationValue.ForDescriptionArray.of(TypeDescription.ForLoadedType.of(type.getComponentType()), annotationDescription);
            }
            if (Class.class.isAssignableFrom(type)) {
                return AnnotationValue.ForTypeDescription.of(TypeDescription.ForLoadedType.of((Class)element));
            }
            if (Class[].class.isAssignableFrom((Class<?>)var1_1)) {
                void var2_4;
                element = (Class[])element;
                TypeDescription[] typeDescription = new TypeDescription[element.length];
                int index = 0;
                for (Object anElement : objectArray) {
                    typeDescription[index++] = TypeDescription.ForLoadedType.of(anElement);
                }
                return AnnotationValue.ForDescriptionArray.of((TypeDescription[])var2_4);
            }
            return AnnotationValue.ForConstant.of(objectArray);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should always be wrapped for clarity.")
        public AnnotationValue<?, ?> getValue(MethodDescription.InDefinedShape property) {
            if (!property.getDeclaringType().represents(this.annotation.annotationType())) {
                throw new IllegalArgumentException(property + " does not represent " + this.annotation.annotationType());
            }
            try {
                boolean accessible = property.getDeclaringType().isPublic();
                Method method = property instanceof MethodDescription.ForLoadedMethod ? ((MethodDescription.ForLoadedMethod)property).getLoadedMethod() : null;
                if (method == null || method.getDeclaringClass() != this.annotation.annotationType() || !accessible && !method.isAccessible()) {
                    method = this.annotation.annotationType().getMethod(property.getName(), new Class[0]);
                    if (!accessible) {
                        ForLoadedAnnotation.doPrivileged(new SetAccessibleAction<Method>(method));
                    }
                }
                return ForLoadedAnnotation.asValue(method.invoke(this.annotation, NO_ARGUMENT), method.getReturnType()).filter(property);
            }
            catch (InvocationTargetException invocationTargetException) {
                void var3_6;
                InvocationTargetException accessible = invocationTargetException;
                Throwable cause = invocationTargetException.getTargetException();
                if (cause instanceof TypeNotPresentException) {
                    return new AnnotationValue.ForMissingType(((TypeNotPresentException)cause).typeName());
                }
                if (cause instanceof EnumConstantNotPresentException) {
                    return new AnnotationValue.ForEnumerationDescription.WithUnknownConstant(new TypeDescription.ForLoadedType(((EnumConstantNotPresentException)cause).enumType()), ((EnumConstantNotPresentException)cause).constantName());
                }
                if (cause instanceof AnnotationTypeMismatchException) {
                    return new AnnotationValue.ForMismatchedType(new MethodDescription.ForLoadedMethod(((AnnotationTypeMismatchException)cause).element()), ((AnnotationTypeMismatchException)cause).foundType());
                }
                if (cause instanceof IncompleteAnnotationException) {
                    return new AnnotationValue.ForMissingValue(new TypeDescription.ForLoadedType(((IncompleteAnnotationException)cause).annotationType()), ((IncompleteAnnotationException)cause).elementName());
                }
                throw new IllegalStateException("Error reading annotation property " + property, (Throwable)var3_6);
            }
            catch (Exception exception) {
                void var2_4;
                void var1_1;
                throw new IllegalStateException("Cannot access annotation property " + var1_1, (Throwable)var2_4);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T extends Annotation> Loadable<T> prepare(Class<T> annotationType) {
            void var1_1;
            if (!this.annotation.annotationType().getName().equals(annotationType.getName())) {
                throw new IllegalArgumentException(annotationType + " does not represent " + this.annotation.annotationType());
            }
            if (annotationType == this.annotation.annotationType()) {
                return this;
            }
            return new ForLoadedAnnotation<S>(this.annotation, var1_1);
        }

        @Override
        public TypeDescription getAnnotationType() {
            return TypeDescription.ForLoadedType.of(this.annotation.annotationType());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static {
            try {
                Class.forName("java.security.AccessController", false, null);
                ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                ACCESS_CONTROLLER = false;
            }
            catch (SecurityException securityException) {
                ACCESS_CONTROLLER = true;
            }
            NO_ARGUMENT = new Object[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractBase
    implements AnnotationDescription {
        private static final Set<ElementType> DEFAULT_TARGET = new HashSet<ElementType>();
        private static final MethodDescription.InDefinedShape RETENTION_VALUE;
        private static final MethodDescription.InDefinedShape TARGET_VALUE;
        private transient /* synthetic */ int hashCode;

        /*
         * WARNING - void declaration
         */
        @Override
        public AnnotationValue<?, ?> getValue(String property) {
            void var1_1;
            MethodList candidates = (MethodList)this.getAnnotationType().getDeclaredMethods().filter(ElementMatchers.named(property).and(ElementMatchers.takesArguments(0)).and(ElementMatchers.isPublic()).and(ElementMatchers.not(ElementMatchers.isStatic())));
            if (candidates.size() == 1) {
                void var2_2;
                return this.getValue((MethodDescription.InDefinedShape)var2_2.getOnly());
            }
            throw new IllegalArgumentException("Unknown property of " + this.getAnnotationType() + ": " + (String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public RetentionPolicy getRetention() {
            void var1_1;
            Loadable<Retention> retention = this.getAnnotationType().getDeclaredAnnotations().ofType(Retention.class);
            if (retention == null) {
                return RetentionPolicy.CLASS;
            }
            return var1_1.getValue(RETENTION_VALUE).load(ClassLoadingStrategy.BOOTSTRAP_LOADER).resolve(RetentionPolicy.class);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<ElementType> getElementTypes() {
            void var1_1;
            Loadable<Target> target = this.getAnnotationType().getDeclaredAnnotations().ofType(Target.class);
            if (target == null) {
                return Collections.unmodifiableSet(DEFAULT_TARGET);
            }
            return new HashSet<Object>(Arrays.asList((Object[])var1_1.getValue(TARGET_VALUE).load(ClassLoadingStrategy.BOOTSTRAP_LOADER).resolve(ElementType[].class)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean isSupportedOn(ElementType elementType) {
            void var1_1;
            return this.isSupportedOn(var1_1.name());
        }

        @Override
        public boolean isSupportedOn(String elementType) {
            Loadable<Target> target = this.getAnnotationType().getDeclaredAnnotations().ofType(Target.class);
            if (target == null) {
                if (elementType.equals("TYPE_USE")) {
                    return true;
                }
                for (ElementType elementType2 : DEFAULT_TARGET) {
                    if (!elementType2.name().equals(elementType)) continue;
                    return true;
                }
            } else {
                EnumerationDescription[] enumerationDescriptionArray;
                for (EnumerationDescription enumerationDescription : enumerationDescriptionArray.getValue(TARGET_VALUE).resolve(EnumerationDescription[].class)) {
                    if (!enumerationDescription.getValue().equals(elementType)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isInherited() {
            return this.getAnnotationType().getDeclaredAnnotations().isAnnotationPresent(Inherited.class);
        }

        @Override
        public boolean isDocumented() {
            return this.getAnnotationType().getDeclaredAnnotations().isAnnotationPresent(Documented.class);
        }

        /*
         * WARNING - void declaration
         */
        @CachedReturnPlugin.Enhance(value="hashCode")
        public int hashCode() {
            int n;
            int n2 = this.hashCode;
            if (n2 != 0) {
                n = 0;
            } else {
                void var2_3;
                AbstractBase abstractBase = this;
                int hashCode = 0;
                for (MethodDescription.InDefinedShape methodDescription : abstractBase.getAnnotationType().getDeclaredMethods()) {
                    hashCode += 31 * abstractBase.getValue(methodDescription).hashCode();
                }
                n = n2 = var2_3;
            }
            if (n == 0) {
                n2 = this.hashCode;
            } else {
                this.hashCode = n2;
            }
            return n2;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(@MaybeNull Object other) {
            Iterator iterator;
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnnotationDescription)) {
                return false;
            }
            AnnotationDescription annotationDescription = (AnnotationDescription)other;
            TypeDescription annotationType = this.getAnnotationType();
            if (!annotationDescription.getAnnotationType().equals(annotationType)) {
                return false;
            }
            for (MethodDescription.InDefinedShape methodDescription : iterator.getDeclaredMethods()) {
                void var3_3;
                if (this.getValue(methodDescription).equals(annotationDescription.getValue((MethodDescription.InDefinedShape)var3_3))) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var2_2;
            TypeDescription annotationType = this.getAnnotationType();
            StringBuilder toString = new StringBuilder("@");
            RenderingDispatcher.CURRENT.appendType(toString, annotationType);
            toString.append('(');
            boolean firstMember = true;
            for (MethodDescription.InDefinedShape methodDescription : annotationType.getDeclaredMethods()) {
                AnnotationValue<?, ?> value = this.getValue(methodDescription);
                if (value.getState() == AnnotationValue.State.UNDEFINED) continue;
                if (firstMember) {
                    firstMember = false;
                } else {
                    toString.append(", ");
                }
                RenderingDispatcher.CURRENT.appendPrefix(toString, methodDescription.getName(), annotationType.getDeclaredMethods().size());
                toString.append(value);
            }
            return var2_2.append(')').toString();
        }

        /*
         * WARNING - void declaration
         */
        static {
            for (ElementType elementType : ElementType.values()) {
                void var3_3;
                if (elementType.name().equals("TYPE_PARAMETER")) continue;
                DEFAULT_TARGET.add((ElementType)var3_3);
            }
            RETENTION_VALUE = (MethodDescription.InDefinedShape)((MethodList)TypeDescription.ForLoadedType.of(Retention.class).getDeclaredMethods().filter(ElementMatchers.named("value"))).getOnly();
            TARGET_VALUE = (MethodDescription.InDefinedShape)((MethodList)TypeDescription.ForLoadedType.of(Target.class).getDeclaredMethods().filter(ElementMatchers.named("value"))).getOnly();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotationInvocationHandler<T extends Annotation>
    implements InvocationHandler {
        private static final String HASH_CODE = "hashCode";
        private static final String EQUALS = "equals";
        private static final String TO_STRING = "toString";
        private static final String ANNOTATION_TYPE = "annotationType";
        private static final Object[] NO_ARGUMENT = new Object[0];
        private final Class<? extends Annotation> annotationType;
        private final LinkedHashMap<Method, AnnotationValue.Loaded<?>> values;
        private transient /* synthetic */ int hashCode;

        /*
         * WARNING - void declaration
         */
        protected AnnotationInvocationHandler(Class<T> annotationType, LinkedHashMap<Method, AnnotationValue.Loaded<?>> values) {
            void var2_2;
            void var1_1;
            this.annotationType = var1_1;
            this.values = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public static <S extends Annotation> S of(@MaybeNull ClassLoader classLoader, Class<S> annotationType, Map<String, ? extends AnnotationValue<?, ?>> values) {
            void var3_3;
            void var1_1;
            ClassLoader classLoader2;
            LinkedHashMap<Method, AnnotationValue.Loaded<Object>> loadedValues = new LinkedHashMap<Method, AnnotationValue.Loaded<Object>>();
            for (Method method : annotationType.getDeclaredMethods()) {
                void var8_8;
                AnnotationValue<?, ?> annotationValue = values.get(method.getName());
                if (annotationValue == null) {
                    Object defaultValue = method.getDefaultValue();
                    loadedValues.put(method, (defaultValue == null ? new AnnotationValue.ForMissingValue(new TypeDescription.ForLoadedType(method.getDeclaringClass()), method.getName()) : ForLoadedAnnotation.asValue(defaultValue, method.getReturnType())).load(classLoader));
                    continue;
                }
                loadedValues.put(method, var8_8.filter(new MethodDescription.ForLoadedMethod(method)).load(classLoader));
            }
            return (S)((Annotation)Proxy.newProxyInstance(classLoader2, new Class[]{annotationType}, new AnnotationInvocationHandler(var1_1, (LinkedHashMap<Method, AnnotationValue.Loaded<?>>)var3_3)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Object invoke(Object proxy, Method method, @MaybeNull Object[] argument) {
            void var2_2;
            if (method.getDeclaringClass() != this.annotationType) {
                if (method.getName().equals(HASH_CODE)) {
                    return this.hashCodeRepresentation();
                }
                if (method.getName().equals(EQUALS) && method.getParameterTypes().length == 1) {
                    void var3_3;
                    void var1_1;
                    return this.equalsRepresentation(var1_1, var3_3[0]);
                }
                if (method.getName().equals(TO_STRING)) {
                    return this.toStringRepresentation();
                }
                if (method.getName().equals(ANNOTATION_TYPE)) {
                    return this.annotationType;
                }
                throw new IllegalStateException("Unexpected method: " + method);
            }
            return this.values.get(var2_2).resolve();
        }

        /*
         * WARNING - void declaration
         */
        protected String toStringRepresentation() {
            void var1_1;
            StringBuilder toString = new StringBuilder();
            toString.append('@');
            RenderingDispatcher.CURRENT.appendType(toString, TypeDescription.ForLoadedType.of(this.annotationType));
            toString.append('(');
            boolean firstMember = true;
            for (Map.Entry<Method, AnnotationValue.Loaded<?>> entry : this.values.entrySet()) {
                if (!entry.getValue().getState().isDefined()) continue;
                if (firstMember) {
                    firstMember = false;
                } else {
                    toString.append(", ");
                }
                RenderingDispatcher.CURRENT.appendPrefix(toString, entry.getKey().getName(), this.values.entrySet().size());
                toString.append(entry.getValue().toString());
            }
            toString.append(')');
            return var1_1.toString();
        }

        /*
         * WARNING - void declaration
         */
        private int hashCodeRepresentation() {
            void var1_1;
            int hashCode = 0;
            for (Map.Entry<Method, AnnotationValue.Loaded<?>> entry : this.values.entrySet()) {
                void var3_3;
                if (!entry.getValue().getState().isDefined()) continue;
                hashCode += 127 * entry.getKey().getName().hashCode() ^ ((AnnotationValue.Loaded)var3_3.getValue()).hashCode();
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private boolean equalsRepresentation(Object self, Object other) {
            Object invocationHandler;
            if (self == other) {
                return true;
            }
            if (!this.annotationType.isInstance(other)) {
                return false;
            }
            if (Proxy.isProxyClass(other.getClass()) && (invocationHandler = Proxy.getInvocationHandler(other)) instanceof AnnotationInvocationHandler) {
                return invocationHandler.equals(this);
            }
            try {
                for (Map.Entry entry : this.values.entrySet()) {
                    try {
                        if (((AnnotationValue.Loaded)entry.getValue()).represents(((Method)entry.getKey()).invoke(other, NO_ARGUMENT))) continue;
                        return false;
                    }
                    catch (RuntimeException runtimeException) {
                        return false;
                    }
                }
                return true;
            }
            catch (InvocationTargetException invocationTargetException) {
                return false;
            }
            catch (IllegalAccessException exception) {
                void var1_2;
                throw new IllegalStateException("Could not access annotation property", (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @CachedReturnPlugin.Enhance(value="hashCode")
        public int hashCode() {
            int n;
            int n2 = this.hashCode;
            if (n2 != 0) {
                n = 0;
            } else {
                void var2_3;
                AnnotationInvocationHandler annotationInvocationHandler = this;
                int result = annotationInvocationHandler.annotationType.hashCode();
                result = result * 31 + annotationInvocationHandler.values.hashCode();
                for (Map.Entry entry : annotationInvocationHandler.values.entrySet()) {
                    result = result * 31 + entry.getValue().hashCode();
                }
                n = n2 = var2_3;
            }
            if (n == 0) {
                n2 = this.hashCode;
            } else {
                this.hashCode = n2;
            }
            return n2;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(@MaybeNull Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnnotationInvocationHandler)) {
                return false;
            }
            AnnotationInvocationHandler that = (AnnotationInvocationHandler)other;
            if (!this.annotationType.equals(that.annotationType)) {
                return false;
            }
            for (Map.Entry<Method, AnnotationValue.Loaded<?>> entry : this.values.entrySet()) {
                void var3_3;
                if (entry.getValue().equals(that.values.get(var3_3.getKey()))) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RenderingDispatcher
    extends Enum<RenderingDispatcher> {
        public static final /* enum */ RenderingDispatcher LEGACY_VM;
        public static final /* enum */ RenderingDispatcher JAVA_14_CAPABLE_VM;
        public static final /* enum */ RenderingDispatcher JAVA_19_CAPABLE_VM;
        public static final RenderingDispatcher CURRENT;
        private static final /* synthetic */ RenderingDispatcher[] $VALUES;

        public static RenderingDispatcher[] values() {
            return (RenderingDispatcher[])$VALUES.clone();
        }

        public static RenderingDispatcher valueOf(String name) {
            String string;
            return Enum.valueOf(RenderingDispatcher.class, string);
        }

        /*
         * WARNING - void declaration
         */
        public void appendPrefix(StringBuilder toString, String key, int count) {
            void var2_2;
            toString.append((String)var2_2).append('=');
        }

        /*
         * WARNING - void declaration
         */
        public void appendType(StringBuilder toString, TypeDescription typeDescription) {
            void var2_2;
            toString.append(var2_2.getName());
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var0;
            LEGACY_VM = new RenderingDispatcher();
            JAVA_14_CAPABLE_VM = new RenderingDispatcher(){

                /*
                 * WARNING - void declaration
                 */
                public final void appendPrefix(StringBuilder toString, String key, int count) {
                    if (count > 1 || !key.equals("value")) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        super.appendPrefix((StringBuilder)var1_1, (String)var2_2, (int)var3_3);
                    }
                }
            };
            JAVA_19_CAPABLE_VM = new RenderingDispatcher(){

                /*
                 * WARNING - void declaration
                 */
                public final void appendPrefix(StringBuilder toString, String key, int count) {
                    if (count > 1 || !key.equals("value")) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        super.appendPrefix((StringBuilder)var1_1, (String)var2_2, (int)var3_3);
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                public final void appendType(StringBuilder toString, TypeDescription typeDescription) {
                    void var2_2;
                    toString.append(var2_2.getCanonicalName());
                }
            };
            $VALUES = new RenderingDispatcher[]{LEGACY_VM, JAVA_14_CAPABLE_VM, JAVA_19_CAPABLE_VM};
            ClassFileVersion classFileVersion = ClassFileVersion.ofThisVm(ClassFileVersion.JAVA_V5);
            CURRENT = classFileVersion.isAtLeast(ClassFileVersion.JAVA_V19) ? JAVA_19_CAPABLE_VM : (var0.isAtLeast(ClassFileVersion.JAVA_V14) ? JAVA_14_CAPABLE_VM : LEGACY_VM);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Loadable<S extends Annotation>
    extends AnnotationDescription {
        public S load();
    }
}

