/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.bytebuddy.asm.MemberAttributeExtension;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.attribute.AnnotationValueFilter;
import net.bytebuddy.implementation.attribute.MethodAttributeAppender;
import net.bytebuddy.jar.asm.AnnotationVisitor;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class SafeVarargsPlugin
extends Plugin.ForElementMatcher {
    public SafeVarargsPlugin() {
        super(ElementMatchers.declaresMethod(ElementMatchers.isAnnotatedWith(Enhance.class)));
    }

    @Override
    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        return builder.visit(new MemberAttributeExtension.ForMethod().attribute(SafeVarargsAppender.INSTANCE).on(ElementMatchers.isAnnotatedWith(Enhance.class)));
    }

    @Override
    public void close() {
    }

    @Override
    public boolean equals(@MaybeNull Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return this.getClass() == object.getClass();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum SafeVarargsAppender implements MethodAttributeAppender,
    MethodAttributeAppender.Factory
    {
        INSTANCE;


        @Override
        public final MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void apply(MethodVisitor methodVisitor, MethodDescription methodDescription, AnnotationValueFilter annotationValueFilter) {
            if (!methodDescription.isVarArgs()) {
                throw new IllegalStateException(methodDescription + " does not have variable arguments");
            }
            if (!(methodDescription.isConstructor() || methodDescription.isStatic() || methodDescription.isFinal())) {
                void var2_2;
                throw new IllegalStateException(var2_2 + " is neither a constructor or final and cannot declare safe varargs");
            }
            AnnotationVisitor visitor = methodVisitor.visitAnnotation("Ljava/lang/SafeVarargs;", true);
            if (visitor != null) {
                void var1_1;
                var1_1.visitEnd();
            }
        }
    }

    @Documented
    @Target(value={ElementType.CONSTRUCTOR, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Enhance {
    }
}

