/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.commons.ClassRemapper;
import net.bytebuddy.jar.asm.commons.Remapper;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class RenamingPlugin
extends AsmVisitorWrapper.AbstractBase
implements Plugin {
    private final Renaming renaming;
    private final ElementMatcher<? super TypeDescription> matcher;

    /*
     * WARNING - void declaration
     */
    public RenamingPlugin(String pattern, String replacement) {
        this(new Renaming.ForPattern(Pattern.compile((String)var1_1), (String)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RenamingPlugin(String pattern, String replacement, String prefix) {
        this(new Renaming.ForPattern(Pattern.compile((String)var1_1), (String)var2_2), ElementMatchers.nameStartsWith((String)var3_3));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RenamingPlugin(Renaming renaming) {
        this((Renaming)var1_1, ElementMatchers.any());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RenamingPlugin(Renaming renaming, ElementMatcher<? super TypeDescription> matcher) {
        void var2_2;
        void var1_1;
        this.renaming = var1_1;
        this.matcher = var2_2;
    }

    @Override
    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        return builder.visit(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean matches(TypeDescription target) {
        void var1_1;
        return this.matcher.matches((TypeDescription)var1_1);
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
        void var2_2;
        return new ClassRemapper((ClassVisitor)var2_2, new RenamingRemapper(this.renaming));
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!this.renaming.equals(((RenamingPlugin)object).renaming)) {
            return false;
        }
        return this.matcher.equals(((RenamingPlugin)object).matcher);
    }

    public int hashCode() {
        return (this.getClass().hashCode() * 31 + this.renaming.hashCode()) * 31 + this.matcher.hashCode();
    }

    protected static class RenamingRemapper
    extends Remapper {
        private final Renaming renaming;
        private final Map<String, String> cache = new HashMap<String, String>();

        /*
         * WARNING - void declaration
         */
        protected RenamingRemapper(Renaming renaming) {
            void var1_1;
            this.renaming = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public String map(String internalName) {
            void var2_2;
            void var1_1;
            String renamed = this.cache.get(internalName);
            if (renamed != null) {
                return renamed;
            }
            renamed = this.renaming.apply(internalName.replace('/', '.')).replace('.', '/');
            this.cache.put((String)var1_1, renamed);
            return var2_2;
        }
    }

    public static interface Renaming {
        public String apply(String var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class Compound
        implements Renaming {
            private final List<Renaming> renamings;

            /*
             * WARNING - void declaration
             */
            public Compound(Renaming ... renaming) {
                this(Arrays.asList(var1_1));
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public Compound(List<? extends Renaming> renamings) {
                Iterator iterator;
                this.renamings = new ArrayList<Renaming>(renamings.size());
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    void var2_2;
                    Renaming remapping = (Renaming)iterator.next();
                    if (remapping instanceof Compound) {
                        this.renamings.addAll(((Compound)remapping).renamings);
                        continue;
                    }
                    if (remapping instanceof NoOp) continue;
                    this.renamings.add((Renaming)var2_2);
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String apply(String name) {
                void var1_1;
                for (Renaming renaming : this.renamings) {
                    name = renaming.apply(name);
                }
                return var1_1;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return ((Object)this.renamings).equals(((Compound)object).renamings);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + ((Object)this.renamings).hashCode();
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForPattern
        implements Renaming {
            private final Pattern pattern;
            private final String replacement;

            /*
             * WARNING - void declaration
             */
            public ForPattern(Pattern pattern, String replacement) {
                void var2_2;
                void var1_1;
                this.pattern = var1_1;
                this.replacement = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            public String apply(String name) {
                void var1_1;
                Matcher matcher = this.pattern.matcher(name);
                if (matcher.find()) {
                    void var2_2;
                    StringBuffer buffer = new StringBuffer();
                    do {
                        matcher.appendReplacement(buffer, this.replacement);
                    } while (matcher.find());
                    return var2_2.appendTail((StringBuffer)var1_1).toString();
                }
                return var1_1;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.replacement.equals(((ForPattern)object).replacement)) {
                    return false;
                }
                return this.pattern.equals(((ForPattern)object).pattern);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + this.pattern.hashCode()) * 31 + this.replacement.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum NoOp implements Renaming
        {
            INSTANCE;


            @Override
            public final String apply(String name) {
                return name;
            }
        }
    }
}

