/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.build.EntryPoint;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.TypeResolutionStrategy;
import net.bytebuddy.dynamic.scaffold.inline.MethodNameTransformer;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.CompoundList;
import net.bytebuddy.utility.FileSystem;
import net.bytebuddy.utility.QueueFactory;
import net.bytebuddy.utility.StreamDrainer;
import net.bytebuddy.utility.nullability.AlwaysNull;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Plugin
extends Closeable,
ElementMatcher<TypeDescription> {
    public DynamicType.Builder<?> apply(DynamicType.Builder<?> var1, TypeDescription var2, ClassFileLocator var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static abstract class ForElementMatcher
    implements Plugin {
        private final ElementMatcher<? super TypeDescription> matcher;

        /*
         * WARNING - void declaration
         */
        protected ForElementMatcher(ElementMatcher<? super TypeDescription> matcher) {
            void var1_1;
            this.matcher = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean matches(@MaybeNull TypeDescription target) {
            void var1_1;
            return this.matcher.matches((TypeDescription)var1_1);
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.matcher.equals(((ForElementMatcher)object).matcher);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.matcher.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class NoOp
    implements Plugin,
    Factory {
        @Override
        public Plugin make() {
            return this;
        }

        @Override
        public boolean matches(@MaybeNull TypeDescription target) {
            return false;
        }

        @Override
        public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
            throw new IllegalStateException("Cannot apply non-operational plugin");
        }

        @Override
        public void close() {
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return this.getClass() == object.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Engine {
        public static final String MODULE_INFO = "module-info.class";
        public static final String PACKAGE_INFO = "package-info.class";
        public static final String PLUGIN_FILE = "META-INF/net.bytebuddy/build.plugins";

        public Engine with(ByteBuddy var1);

        public Engine with(TypeStrategy var1);

        public Engine with(PoolStrategy var1);

        public Engine with(ClassFileLocator var1);

        public Engine with(@MaybeNull ClassFileVersion var1);

        public Engine with(Listener var1);

        public Engine withoutErrorHandlers();

        public Engine withErrorHandlers(ErrorHandler ... var1);

        public Engine withErrorHandlers(List<? extends ErrorHandler> var1);

        public Engine withParallelTransformation(int var1);

        public Engine with(Dispatcher.Factory var1);

        public Engine ignore(ElementMatcher<? super TypeDescription> var1);

        public Summary apply(File var1, File var2, Factory ... var3) throws IOException;

        public Summary apply(File var1, File var2, List<? extends Factory> var3) throws IOException;

        public Summary apply(Source var1, Target var2, Factory ... var3) throws IOException;

        public Summary apply(Source var1, Target var2, List<? extends Factory> var3) throws IOException;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class Default
        extends AbstractBase {
            private final ByteBuddy byteBuddy;
            private final TypeStrategy typeStrategy;
            private final PoolStrategy poolStrategy;
            private final ClassFileLocator classFileLocator;
            @MaybeNull
            @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.REVERSE_NULLABILITY)
            private final ClassFileVersion classFileVersion;
            private final Listener listener;
            private final ErrorHandler errorHandler;
            private final Dispatcher.Factory dispatcherFactory;
            private final ElementMatcher.Junction<? super TypeDescription> ignoredTypeMatcher;

            public Default() {
                this(new ByteBuddy());
            }

            /*
             * WARNING - void declaration
             */
            public Default(ByteBuddy byteBuddy) {
                this((ByteBuddy)var1_1, TypeStrategy.Default.REBASE);
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            protected Default(ByteBuddy byteBuddy, TypeStrategy typeStrategy) {
                this((ByteBuddy)var1_1, (TypeStrategy)var2_2, PoolStrategy.Default.FAST, ClassFileLocator.NoOp.INSTANCE, null, Listener.NoOp.INSTANCE, new ErrorHandler.Compound(ErrorHandler.Failing.FAIL_FAST, ErrorHandler.Enforcing.ALL_TYPES_RESOLVED, ErrorHandler.Enforcing.NO_LIVE_INITIALIZERS), Dispatcher.ForSerialTransformation.Factory.INSTANCE, ElementMatchers.none());
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            protected Default(ByteBuddy byteBuddy, TypeStrategy typeStrategy, PoolStrategy poolStrategy, ClassFileLocator classFileLocator, @MaybeNull ClassFileVersion classFileVersion, Listener listener, ErrorHandler errorHandler, Dispatcher.Factory dispatcherFactory, ElementMatcher.Junction<? super TypeDescription> ignoredTypeMatcher) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.byteBuddy = var1_1;
                this.typeStrategy = var2_2;
                this.poolStrategy = var3_3;
                this.classFileLocator = classFileLocator;
                this.classFileVersion = classFileVersion;
                this.listener = listener;
                this.errorHandler = errorHandler;
                this.dispatcherFactory = dispatcherFactory;
                this.ignoredTypeMatcher = ignoredTypeMatcher;
            }

            /*
             * WARNING - void declaration
             */
            public static Engine of(EntryPoint entryPoint, ClassFileVersion classFileVersion, MethodNameTransformer methodNameTransformer) {
                void var2_2;
                EntryPoint entryPoint2;
                void var1_1;
                return new Default(entryPoint.byteBuddy((ClassFileVersion)var1_1), new TypeStrategy.ForEntryPoint(entryPoint2, (MethodNameTransformer)var2_2));
            }

            /*
             * WARNING - void declaration
             */
            public static Set<String> scan(ClassLoader classLoader) throws IOException {
                void var1_2;
                HashSet<void> plugins = new HashSet<void>();
                Enumeration<URL> enumeration = classLoader.getResources(Engine.PLUGIN_FILE);
                while (enumeration.hasMoreElements()) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(((URL)enumeration.nextElement()).openStream(), "UTF-8"));
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            void var3_4;
                            plugins.add(var3_4);
                        }
                    }
                    catch (Throwable throwable) {
                        void var2_3;
                        var2_3.close();
                        throw throwable;
                    }
                    reader.close();
                }
                return var1_2;
            }

            /*
             * WARNING - void declaration
             */
            public static void main(String ... argument) throws ClassNotFoundException, IOException {
                void var1_1;
                String[] stringArray;
                if (argument.length < 2) {
                    throw new IllegalArgumentException("Expected arguments: <source> <target> [<plugin>, ...]");
                }
                ArrayList<Factory.UsingReflection> factories = new ArrayList<Factory.UsingReflection>(argument.length - 2);
                for (String plugin : Arrays.asList(argument).subList(2, argument.length)) {
                    void var3_3;
                    factories.add(new Factory.UsingReflection(Class.forName((String)var3_3)));
                }
                new Default().apply(new File(argument[0]), new File(stringArray[1]), (List<? extends Factory>)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Engine with(ByteBuddy byteBuddy) {
                void var1_1;
                return new Default((ByteBuddy)var1_1, this.typeStrategy, this.poolStrategy, this.classFileLocator, this.classFileVersion, this.listener, this.errorHandler, this.dispatcherFactory, this.ignoredTypeMatcher);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Engine with(TypeStrategy typeStrategy) {
                void var1_1;
                return new Default(this.byteBuddy, (TypeStrategy)var1_1, this.poolStrategy, this.classFileLocator, this.classFileVersion, this.listener, this.errorHandler, this.dispatcherFactory, this.ignoredTypeMatcher);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Engine with(PoolStrategy poolStrategy) {
                void var1_1;
                return new Default(this.byteBuddy, this.typeStrategy, (PoolStrategy)var1_1, this.classFileLocator, this.classFileVersion, this.listener, this.errorHandler, this.dispatcherFactory, this.ignoredTypeMatcher);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Engine with(ClassFileLocator classFileLocator) {
                void var1_1;
                return new Default(this.byteBuddy, this.typeStrategy, this.poolStrategy, new ClassFileLocator.Compound(new ClassFileLocator[]{this.classFileLocator, var1_1}), this.classFileVersion, this.listener, this.errorHandler, this.dispatcherFactory, this.ignoredTypeMatcher);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Engine with(@MaybeNull ClassFileVersion classFileVersion) {
                void var1_1;
                return new Default(this.byteBuddy, this.typeStrategy, this.poolStrategy, this.classFileLocator, (ClassFileVersion)var1_1, this.listener, this.errorHandler, this.dispatcherFactory, this.ignoredTypeMatcher);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Engine with(Listener listener) {
                void var1_1;
                return new Default(this.byteBuddy, this.typeStrategy, this.poolStrategy, this.classFileLocator, this.classFileVersion, new Listener.Compound(new Listener[]{this.listener, var1_1}), this.errorHandler, this.dispatcherFactory, this.ignoredTypeMatcher);
            }

            @Override
            public Engine withoutErrorHandlers() {
                return new Default(this.byteBuddy, this.typeStrategy, this.poolStrategy, this.classFileLocator, this.classFileVersion, this.listener, Listener.NoOp.INSTANCE, this.dispatcherFactory, this.ignoredTypeMatcher);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Engine withErrorHandlers(List<? extends ErrorHandler> errorHandlers) {
                void var1_1;
                return new Default(this.byteBuddy, this.typeStrategy, this.poolStrategy, this.classFileLocator, this.classFileVersion, this.listener, new ErrorHandler.Compound((List<? extends ErrorHandler>)var1_1), this.dispatcherFactory, this.ignoredTypeMatcher);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Engine with(Dispatcher.Factory dispatcherFactory) {
                void var1_1;
                return new Default(this.byteBuddy, this.typeStrategy, this.poolStrategy, this.classFileLocator, this.classFileVersion, this.listener, this.errorHandler, (Dispatcher.Factory)var1_1, this.ignoredTypeMatcher);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Engine ignore(ElementMatcher<? super TypeDescription> matcher) {
                void var1_1;
                return new Default(this.byteBuddy, this.typeStrategy, this.poolStrategy, this.classFileLocator, this.classFileVersion, this.listener, this.errorHandler, this.dispatcherFactory, this.ignoredTypeMatcher.or(var1_1));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Summary apply(Source source, Target target, List<? extends Factory> factories) throws IOException {
                Listener.Compound listener = new Listener.Compound(this.listener, new Listener.ForErrorHandler(this.errorHandler));
                ArrayList<TypeDescription> transformed2 = new ArrayList<TypeDescription>();
                LinkedHashMap<TypeDescription, List<Throwable>> failed = new LinkedHashMap<TypeDescription, List<Throwable>>();
                ArrayList<String> unresolved = new ArrayList<String>();
                Throwable rethrown = null;
                ArrayList<Plugin> plugins = new ArrayList<Plugin>(factories.size());
                ArrayList<WithInitialization> initializers = new ArrayList<WithInitialization>();
                ArrayList<WithPreprocessor> preprocessors = new ArrayList<WithPreprocessor>();
                try {
                    factories = factories.iterator();
                    while (factories.hasNext()) {
                        Factory factory = (Factory)factories.next();
                        Plugin plugin = factory.make();
                        plugins.add(plugin);
                        if (plugin instanceof WithPreprocessor) {
                            preprocessors.add((WithPreprocessor)plugin);
                        }
                        if (!(plugin instanceof WithInitialization)) continue;
                        initializers.add((WithInitialization)plugin);
                    }
                    Source.Origin origin = source.read();
                    try {
                        ClassFileLocator.Compound classFileLocator = new ClassFileLocator.Compound(origin.toClassFileLocator(this.classFileVersion), this.classFileLocator);
                        TypePool typePool = this.poolStrategy.typePool(classFileLocator);
                        Manifest manifest = origin.getManifest();
                        listener.onManifest(manifest);
                        Target.Sink sink = target.write(manifest);
                        try {
                            for (WithInitialization initializer : initializers) {
                                sink.store(initializer.initialize(classFileLocator));
                            }
                            Dispatcher dispatcher = this.dispatcherFactory.make(sink, transformed2, failed, unresolved);
                            try {
                                Iterator iterator = origin.iterator();
                                while (iterator.hasNext()) {
                                    Source.Element element = (Source.Element)iterator.next();
                                    if (Thread.interrupted()) {
                                        Thread.currentThread().interrupt();
                                        throw new IllegalStateException("Thread interrupted during plugin engine application");
                                    }
                                    String name = element.getName();
                                    while (name.startsWith("/")) {
                                        name = name.substring(1);
                                    }
                                    if (!(!name.endsWith(".class") || name.startsWith("META-INF") && !name.startsWith("META-INF/versions/") || name.endsWith(Engine.PACKAGE_INFO) || name.endsWith(Engine.MODULE_INFO))) {
                                        try {
                                            ClassFileVersion classFileVersion = name.startsWith("META-INF/versions/") ? ClassFileVersion.ofJavaVersion(Integer.parseInt(name.substring(18, name.indexOf(47, 18)))) : null;
                                            if (classFileVersion == null || classFileVersion.isAtLeast(ClassFileVersion.JAVA_V8) && this.classFileVersion != null && this.classFileVersion.isAtLeast(ClassFileVersion.JAVA_V9) && classFileVersion.isAtMost(this.classFileVersion)) {
                                                String string = name;
                                                String typeName = string.substring(string.startsWith("META-INF/versions/") ? name.indexOf(47, 18) + 1 : 0, name.length() - 6).replace('/', '.');
                                                dispatcher.accept(new Preprocessor(element, typeName, new SourceEntryPrependingClassFileLocator(typeName, element, classFileLocator), classFileVersion, typePool, listener, plugins, preprocessors), preprocessors.isEmpty());
                                                continue;
                                            }
                                            listener.onResource(name);
                                            sink.retain(element);
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            listener.onResource(name);
                                            sink.retain(element);
                                        }
                                        continue;
                                    }
                                    if (name.equals("META-INF/MANIFEST.MF")) continue;
                                    listener.onResource(name);
                                    sink.retain(element);
                                }
                                dispatcher.complete();
                            }
                            catch (Throwable transformed2) {
                                Iterator iterator;
                                iterator.close();
                                throw transformed2;
                            }
                            dispatcher.close();
                            if (!failed.isEmpty()) {
                                listener.onError(failed);
                            }
                        }
                        finally {
                            sink.close();
                        }
                    }
                    finally {
                        origin.close();
                    }
                }
                catch (Throwable throwable) {
                    for (Plugin plugin : plugins) {
                        try {
                            plugin.close();
                        }
                        catch (Throwable throwable2) {
                            try {
                                void var3_7;
                                listener.onError((Plugin)var3_7, throwable2);
                            }
                            catch (Throwable throwable3) {}
                        }
                    }
                    throw throwable;
                }
                for (Plugin plugin : plugins) {
                    try {
                        plugin.close();
                    }
                    catch (Throwable throwable) {
                        try {
                            listener.onError(plugin, throwable);
                        }
                        catch (Throwable chained) {
                            void var1_3;
                            rethrown = rethrown == null ? var1_3 : rethrown;
                        }
                    }
                }
                if (rethrown == null) {
                    void var5_9;
                    return new Summary((List<TypeDescription>)var5_9, failed, unresolved);
                }
                if (rethrown instanceof IOException) {
                    throw (IOException)rethrown;
                }
                if (rethrown instanceof RuntimeException) {
                    throw (RuntimeException)rethrown;
                }
                throw new IllegalStateException(rethrown);
            }

            public boolean equals(@MaybeNull Object object) {
                block17: {
                    block16: {
                        ClassFileVersion classFileVersion;
                        block15: {
                            if (this == object) {
                                return true;
                            }
                            if (object == null) {
                                return false;
                            }
                            if (this.getClass() != object.getClass()) {
                                return false;
                            }
                            if (!this.byteBuddy.equals(((Default)object).byteBuddy)) {
                                return false;
                            }
                            if (!this.typeStrategy.equals(((Default)object).typeStrategy)) {
                                return false;
                            }
                            if (!this.poolStrategy.equals(((Default)object).poolStrategy)) {
                                return false;
                            }
                            if (!this.classFileLocator.equals(((Default)object).classFileLocator)) {
                                return false;
                            }
                            ClassFileVersion classFileVersion2 = ((Default)object).classFileVersion;
                            classFileVersion = this.classFileVersion;
                            if (classFileVersion2 == null) break block15;
                            if (classFileVersion == null) break block16;
                            if (!classFileVersion.equals(classFileVersion2)) {
                                return false;
                            }
                            break block17;
                        }
                        if (classFileVersion == null) break block17;
                    }
                    return false;
                }
                if (!this.listener.equals(((Default)object).listener)) {
                    return false;
                }
                if (!this.errorHandler.equals(((Default)object).errorHandler)) {
                    return false;
                }
                if (!this.dispatcherFactory.equals(((Default)object).dispatcherFactory)) {
                    return false;
                }
                return this.ignoredTypeMatcher.equals(((Default)object).ignoredTypeMatcher);
            }

            public int hashCode() {
                int n = ((((this.getClass().hashCode() * 31 + this.byteBuddy.hashCode()) * 31 + this.typeStrategy.hashCode()) * 31 + this.poolStrategy.hashCode()) * 31 + this.classFileLocator.hashCode()) * 31;
                ClassFileVersion classFileVersion = this.classFileVersion;
                if (classFileVersion != null) {
                    n = n + classFileVersion.hashCode();
                }
                return (((n * 31 + this.listener.hashCode()) * 31 + this.errorHandler.hashCode()) * 31 + this.dispatcherFactory.hashCode()) * 31 + this.ignoredTypeMatcher.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            private class Preprocessor
            implements Callable<Callable<? extends Dispatcher.Materializable>> {
                private final Source.Element element;
                private final String typeName;
                private final ClassFileLocator classFileLocator;
                @MaybeNull
                @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.REVERSE_NULLABILITY)
                private final ClassFileVersion classFileVersion;
                private final TypePool typePool;
                private final Listener listener;
                private final List<Plugin> plugins;
                private final List<WithPreprocessor> preprocessors;

                /*
                 * WARNING - void declaration
                 */
                private Preprocessor(Source.Element element, String typeName, @MaybeNull ClassFileLocator classFileLocator, ClassFileVersion classFileVersion, TypePool typePool, Listener listener, List<Plugin> plugins, List<WithPreprocessor> preprocessors) {
                    void var3_3;
                    void var2_2;
                    this.element = var2_2;
                    this.typeName = var3_3;
                    this.classFileLocator = classFileLocator;
                    this.classFileVersion = classFileVersion;
                    this.typePool = typePool;
                    this.listener = listener;
                    this.plugins = plugins;
                    this.preprocessors = preprocessors;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Callable<Dispatcher.Materializable> call() throws Exception {
                    this.listener.onDiscovery(this.typeName);
                    TypePool.Resolution resolution = this.typePool.describe(this.typeName);
                    if (resolution.isResolved()) {
                        TypeDescription typeDescription = resolution.resolve();
                        try {
                            if (!Default.this.ignoredTypeMatcher.matches(typeDescription)) {
                                for (WithPreprocessor withPreprocessor : this.preprocessors) {
                                    withPreprocessor.onPreprocess(typeDescription, this.classFileLocator);
                                }
                                Preprocessor preprocessor = this;
                                return preprocessor.new Resolved(preprocessor.classFileVersion, typeDescription);
                            }
                            return new Ignored(typeDescription);
                        }
                        catch (Throwable throwable) {
                            void var2_3;
                            void var1_1;
                            this.listener.onComplete((TypeDescription)var1_1);
                            if (throwable instanceof Exception) {
                                throw (Exception)throwable;
                            }
                            if (throwable instanceof Error) {
                                throw (Error)throwable;
                            }
                            throw new IllegalStateException((Throwable)var2_3);
                        }
                    }
                    return new Unresolved();
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                private class Unresolved
                implements Callable<Dispatcher.Materializable> {
                    private Unresolved() {
                    }

                    @Override
                    public Dispatcher.Materializable call() {
                        Preprocessor.this.listener.onUnresolved(Preprocessor.this.typeName);
                        return new Dispatcher.Materializable.ForUnresolvedElement(Preprocessor.this.element, Preprocessor.this.typeName);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                private class Ignored
                implements Callable<Dispatcher.Materializable> {
                    private final TypeDescription typeDescription;

                    /*
                     * WARNING - void declaration
                     */
                    private Ignored(TypeDescription typeDescription) {
                        void var2_2;
                        this.typeDescription = var2_2;
                    }

                    @Override
                    public Dispatcher.Materializable call() {
                        try {
                            Preprocessor.this.listener.onIgnored(this.typeDescription, Preprocessor.this.plugins);
                        }
                        finally {
                            Preprocessor.this.listener.onComplete(this.typeDescription);
                        }
                        return new Dispatcher.Materializable.ForRetainedElement(Preprocessor.this.element);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                private class Resolved
                implements Callable<Dispatcher.Materializable> {
                    @MaybeNull
                    private final ClassFileVersion classFileVersion;
                    private final TypeDescription typeDescription;

                    /*
                     * WARNING - void declaration
                     */
                    private Resolved(ClassFileVersion classFileVersion, TypeDescription typeDescription) {
                        void var3_3;
                        void var2_2;
                        this.classFileVersion = var2_2;
                        this.typeDescription = var3_3;
                    }

                    /*
                     * Loose catch block
                     * WARNING - void declaration
                     */
                    @Override
                    public Dispatcher.Materializable call() {
                        ArrayList<Plugin> applied = new ArrayList<Plugin>();
                        ArrayList<Plugin> ignored = new ArrayList<Plugin>();
                        ArrayList<Throwable> errored = new ArrayList<Throwable>();
                        try {
                            void var2_3;
                            Object object;
                            DynamicType.Builder<?> builder = Default.this.typeStrategy.builder(Default.this.byteBuddy, this.typeDescription, Preprocessor.this.classFileLocator);
                            for (Plugin plugin : Preprocessor.this.plugins) {
                                try {
                                    if (plugin.matches(this.typeDescription)) {
                                        builder = plugin.apply(builder, this.typeDescription, Preprocessor.this.classFileLocator);
                                        Preprocessor.this.listener.onTransformation(this.typeDescription, plugin);
                                        applied.add(plugin);
                                        continue;
                                    }
                                    Preprocessor.this.listener.onIgnored(this.typeDescription, plugin);
                                    ignored.add(plugin);
                                }
                                catch (Throwable throwable) {
                                    Preprocessor.this.listener.onError(this.typeDescription, plugin, throwable);
                                    errored.add(throwable);
                                }
                            }
                            if (!errored.isEmpty()) {
                                Preprocessor.this.listener.onError(this.typeDescription, errored);
                                object = new Dispatcher.Materializable.ForFailedElement(Preprocessor.this.element, this.typeDescription, errored);
                                return object;
                            }
                            if (!applied.isEmpty()) {
                                Object object2;
                                try {
                                    void var1_1;
                                    DynamicType.Unloaded<?> dynamicType = builder.make(TypeResolutionStrategy.Disabled.INSTANCE, Preprocessor.this.typePool);
                                    Preprocessor.this.listener.onTransformation(this.typeDescription, (List<Plugin>)var1_1);
                                    for (Map.Entry<TypeDescription, LoadedTypeInitializer> entry : dynamicType.getLoadedTypeInitializers().entrySet()) {
                                        if (!entry.getValue().isAlive()) continue;
                                        Preprocessor.this.listener.onLiveInitializer(this.typeDescription, entry.getKey());
                                    }
                                    object2 = new Dispatcher.Materializable.ForTransformedElement(this.classFileVersion, dynamicType);
                                    return object2;
                                }
                                catch (Throwable throwable) {
                                    void var3_4;
                                    errored.add(throwable);
                                    Preprocessor.this.listener.onError(this.typeDescription, errored);
                                    object2 = new Dispatcher.Materializable.ForFailedElement(Preprocessor.this.element, this.typeDescription, (List<Throwable>)var3_4);
                                    Preprocessor.this.listener.onComplete(this.typeDescription);
                                    return object2;
                                }
                            }
                            Preprocessor.this.listener.onIgnored(this.typeDescription, (List<Plugin>)var2_3);
                            object = new Dispatcher.Materializable.ForRetainedElement(Preprocessor.this.element);
                            return object;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                        }
                        finally {
                            Preprocessor.this.listener.onComplete(this.typeDescription);
                        }
                    }
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            protected static class SourceEntryPrependingClassFileLocator
            implements ClassFileLocator {
                private final String name;
                private final Source.Element element;
                private final ClassFileLocator delegate;

                /*
                 * WARNING - void declaration
                 */
                protected SourceEntryPrependingClassFileLocator(String name, Source.Element element, ClassFileLocator delegate) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.name = var1_1;
                    this.element = var2_2;
                    this.delegate = var3_3;
                }

                /*
                 * WARNING - void declaration
                 */
                public ClassFileLocator.Resolution locate(String name) throws IOException {
                    void var1_1;
                    if (name.endsWith(this.name)) {
                        ClassFileLocator.Resolution.Explicit explicit;
                        InputStream inputStream = this.element.getInputStream();
                        try {
                            explicit = new ClassFileLocator.Resolution.Explicit(StreamDrainer.DEFAULT.drain(inputStream));
                        }
                        catch (Throwable throwable) {
                            var1_1.close();
                            throw throwable;
                        }
                        inputStream.close();
                        return explicit;
                    }
                    return this.delegate.locate((String)var1_1);
                }

                public void close() throws IOException {
                    this.delegate.close();
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.name.equals(((SourceEntryPrependingClassFileLocator)object).name)) {
                        return false;
                    }
                    if (!this.element.equals(((SourceEntryPrependingClassFileLocator)object).element)) {
                        return false;
                    }
                    return this.delegate.equals(((SourceEntryPrependingClassFileLocator)object).delegate);
                }

                public int hashCode() {
                    return ((this.getClass().hashCode() * 31 + this.name.hashCode()) * 31 + this.element.hashCode()) * 31 + this.delegate.hashCode();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class AbstractBase
        implements Engine {
            /*
             * WARNING - void declaration
             */
            @Override
            public Engine withErrorHandlers(ErrorHandler ... errorHandler) {
                void var1_1;
                return this.withErrorHandlers(Arrays.asList(var1_1));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Engine withParallelTransformation(int threads) {
                void var1_1;
                if (threads <= 0) {
                    throw new IllegalArgumentException("Number of threads must be positive: " + threads);
                }
                return this.with(new Dispatcher.ForParallelTransformation.WithThrowawayExecutorService.Factory((int)var1_1));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Summary apply(File source, File target, Factory ... factory) throws IOException {
                void var3_3;
                void var2_2;
                void var1_1;
                return this.apply((File)var1_1, (File)var2_2, Arrays.asList(var3_3));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Summary apply(File source, File target, List<? extends Factory> factories) throws IOException {
                void var3_3;
                void var2_2;
                void var1_1;
                return this.apply(source.isDirectory() ? new Source.ForFolder(source) : new Source.ForJarFile((File)var1_1), target.isDirectory() ? new Target.ForFolder(target) : new Target.ForJarFile((File)var2_2), (List<? extends Factory>)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Summary apply(Source source, Target target, Factory ... factory) throws IOException {
                void var3_3;
                void var2_2;
                void var1_1;
                return this.apply((Source)var1_1, (Target)var2_2, Arrays.asList(var3_3));
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Summary {
            private final List<TypeDescription> transformed;
            private final Map<TypeDescription, List<Throwable>> failed;
            private final List<String> unresolved;

            /*
             * WARNING - void declaration
             */
            public Summary(List<TypeDescription> transformed, Map<TypeDescription, List<Throwable>> failed, List<String> unresolved) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.transformed = var1_1;
                this.failed = var2_2;
                this.unresolved = var3_3;
            }

            public List<TypeDescription> getTransformed() {
                return this.transformed;
            }

            public Map<TypeDescription, List<Throwable>> getFailed() {
                return this.failed;
            }

            public List<String> getUnresolved() {
                return this.unresolved;
            }

            /*
             * WARNING - void declaration
             */
            public int hashCode() {
                void var1_1;
                int result = this.transformed.hashCode();
                result = result * 31 + this.failed.hashCode();
                var1_1 = var1_1 * 31 + this.unresolved.hashCode();
                return (int)var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public boolean equals(@MaybeNull Object other) {
                void var1_1;
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Summary summary = (Summary)other;
                return this.transformed.equals(summary.transformed) && this.failed.equals(summary.failed) && this.unresolved.equals(var1_1.unresolved);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Dispatcher
        extends Closeable {
            public void accept(Callable<? extends Callable<? extends Materializable>> var1, boolean var2) throws IOException;

            public void complete() throws IOException;

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class ForParallelTransformation
            implements Dispatcher {
                private final Target.Sink sink;
                private final List<TypeDescription> transformed;
                private final Map<TypeDescription, List<Throwable>> failed;
                private final List<String> unresolved;
                private final CompletionService<Callable<Materializable>> preprocessings;
                private final CompletionService<Materializable> materializers;
                private int deferred;
                private final Set<Future<?>> futures;

                /*
                 * WARNING - void declaration
                 */
                protected ForParallelTransformation(Executor executor, Target.Sink sink, List<TypeDescription> transformed, Map<TypeDescription, List<Throwable>> failed, List<String> unresolved) {
                    void var1_1;
                    void var3_3;
                    void var2_2;
                    this.sink = var2_2;
                    this.transformed = var3_3;
                    this.failed = failed;
                    this.unresolved = unresolved;
                    this.preprocessings = new ExecutorCompletionService<Callable<Materializable>>(executor);
                    this.materializers = new ExecutorCompletionService<Materializable>((Executor)var1_1);
                    this.futures = new HashSet();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void accept(Callable<? extends Callable<? extends Materializable>> work, boolean eager) {
                    void var1_1;
                    if (eager) {
                        this.futures.add(this.materializers.submit(new EagerWork(work)));
                        return;
                    }
                    ++this.deferred;
                    this.futures.add(this.preprocessings.submit((Callable<Callable<Materializable>>)var1_1));
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void complete() throws IOException {
                    try {
                        Future<Materializable> future;
                        ArrayList preprocessings = new ArrayList(this.deferred);
                        while (this.deferred-- > 0) {
                            future = this.preprocessings.take();
                            this.futures.remove(future);
                            preprocessings.add(future.get());
                        }
                        for (Callable preprocessing : preprocessings) {
                            this.futures.add(this.materializers.submit(preprocessing));
                        }
                        while (!this.futures.isEmpty()) {
                            future = this.materializers.take();
                            this.futures.remove(future);
                            future.get().materialize(this.sink, this.transformed, this.failed, this.unresolved);
                        }
                        return;
                    }
                    catch (InterruptedException exception) {
                        void var1_2;
                        Thread.currentThread().interrupt();
                        throw new IllegalStateException((Throwable)var1_2);
                    }
                    catch (ExecutionException executionException) {
                        void var2_5;
                        ExecutionException executionException2 = executionException;
                        Throwable cause = executionException.getCause();
                        if (cause instanceof IOException) {
                            throw (IOException)cause;
                        }
                        if (cause instanceof RuntimeException) {
                            throw (RuntimeException)cause;
                        }
                        if (cause instanceof Error) {
                            throw (Error)cause;
                        }
                        throw new IllegalStateException((Throwable)var2_5);
                    }
                }

                @Override
                public void close() {
                    for (Future<?> future : this.futures) {
                        future.cancel(true);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                protected static class EagerWork
                implements Callable<Materializable> {
                    private final Callable<? extends Callable<? extends Materializable>> work;

                    /*
                     * WARNING - void declaration
                     */
                    protected EagerWork(Callable<? extends Callable<? extends Materializable>> work) {
                        void var1_1;
                        this.work = var1_1;
                    }

                    @Override
                    public Materializable call() throws Exception {
                        return this.work.call().call();
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        return this.work.equals(((EagerWork)object).work);
                    }

                    public int hashCode() {
                        return this.getClass().hashCode() * 31 + this.work.hashCode();
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                public static class Factory
                implements net.bytebuddy.build.Plugin$Engine$Dispatcher$Factory {
                    private final Executor executor;

                    /*
                     * WARNING - void declaration
                     */
                    public Factory(Executor executor) {
                        void var1_1;
                        this.executor = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Dispatcher make(Target.Sink sink, List<TypeDescription> transformed, Map<TypeDescription, List<Throwable>> failed, List<String> unresolved) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        return new ForParallelTransformation(this.executor, (Target.Sink)var1_1, (List<TypeDescription>)var2_2, (Map<TypeDescription, List<Throwable>>)var3_3, unresolved);
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        return this.executor.equals(((Factory)object).executor);
                    }

                    public int hashCode() {
                        return this.getClass().hashCode() * 31 + this.executor.hashCode();
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                public static class WithThrowawayExecutorService
                extends ForParallelTransformation {
                    private final ExecutorService executorService;

                    /*
                     * WARNING - void declaration
                     */
                    protected WithThrowawayExecutorService(ExecutorService executorService, Target.Sink sink, List<TypeDescription> transformed, Map<TypeDescription, List<Throwable>> failed, List<String> unresolved) {
                        super(executorService, (Target.Sink)var2_2, (List<TypeDescription>)var3_3, failed, unresolved);
                        void var1_1;
                        void var3_3;
                        void var2_2;
                        this.executorService = var1_1;
                    }

                    @Override
                    public void close() {
                        try {
                            super.close();
                            return;
                        }
                        finally {
                            this.executorService.shutdown();
                        }
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        return this.executorService.equals(((WithThrowawayExecutorService)object).executorService);
                    }

                    public int hashCode() {
                        return this.getClass().hashCode() * 31 + this.executorService.hashCode();
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    @HashCodeAndEqualsPlugin.Enhance
                    public static class Factory
                    implements net.bytebuddy.build.Plugin$Engine$Dispatcher$Factory {
                        private final int threads;

                        /*
                         * WARNING - void declaration
                         */
                        public Factory(int threads) {
                            void var1_1;
                            this.threads = var1_1;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public Dispatcher make(Target.Sink sink, List<TypeDescription> transformed, Map<TypeDescription, List<Throwable>> failed, List<String> unresolved) {
                            void var3_3;
                            void var2_2;
                            void var1_1;
                            return new WithThrowawayExecutorService(Executors.newFixedThreadPool(this.threads), (Target.Sink)var1_1, (List<TypeDescription>)var2_2, (Map<TypeDescription, List<Throwable>>)var3_3, unresolved);
                        }

                        public boolean equals(@MaybeNull Object object) {
                            if (this == object) {
                                return true;
                            }
                            if (object == null) {
                                return false;
                            }
                            if (this.getClass() != object.getClass()) {
                                return false;
                            }
                            return this.threads == ((Factory)object).threads;
                        }

                        public int hashCode() {
                            return this.getClass().hashCode() * 31 + this.threads;
                        }
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class ForSerialTransformation
            implements Dispatcher {
                private final Target.Sink sink;
                private final List<TypeDescription> transformed;
                private final Map<TypeDescription, List<Throwable>> failed;
                private final List<String> unresolved;
                private final List<Callable<? extends Materializable>> preprocessings;

                /*
                 * WARNING - void declaration
                 */
                protected ForSerialTransformation(Target.Sink sink, List<TypeDescription> transformed, Map<TypeDescription, List<Throwable>> failed, List<String> unresolved) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.sink = var1_1;
                    this.transformed = var2_2;
                    this.failed = var3_3;
                    this.unresolved = unresolved;
                    this.preprocessings = new ArrayList<Callable<? extends Materializable>>();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void accept(Callable<? extends Callable<? extends Materializable>> work, boolean eager) throws IOException {
                    try {
                        void var2_2;
                        Callable<? extends Materializable> preprocessed = work.call();
                        if (var2_2 == false) {
                            this.preprocessings.add(preprocessed);
                            return;
                        }
                        preprocessed.call().materialize(this.sink, this.transformed, this.failed, this.unresolved);
                    }
                    catch (Exception exception) {
                        void var1_1;
                        Exception exception2 = exception;
                        if (exception instanceof IOException) {
                            throw (IOException)exception2;
                        }
                        if (exception2 instanceof RuntimeException) {
                            throw (RuntimeException)exception2;
                        }
                        throw new IllegalStateException((Throwable)var1_1);
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void complete() throws IOException {
                    Iterator<Callable<? extends Materializable>> iterator = this.preprocessings.iterator();
                    while (iterator.hasNext()) {
                        Callable<? extends Materializable> preprocessing = iterator.next();
                        if (Thread.interrupted()) {
                            Thread.currentThread().interrupt();
                            throw new IllegalStateException("Interrupted during plugin engine completion");
                        }
                        try {
                            void var2_2;
                            ((Materializable)var2_2.call()).materialize(this.sink, this.transformed, this.failed, this.unresolved);
                        }
                        catch (Exception exception) {
                            Exception exception2 = exception;
                            if (exception instanceof IOException) {
                                throw (IOException)exception2;
                            }
                            if (exception2 instanceof RuntimeException) {
                                throw (RuntimeException)exception2;
                            }
                            throw new IllegalStateException((Throwable)((Object)iterator));
                        }
                    }
                }

                @Override
                public void close() {
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static enum Factory implements net.bytebuddy.build.Plugin$Engine$Dispatcher$Factory
                {
                    INSTANCE;


                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final Dispatcher make(Target.Sink sink, List<TypeDescription> transformed, Map<TypeDescription, List<Throwable>> failed, List<String> unresolved) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        return new ForSerialTransformation((Target.Sink)var1_1, (List<TypeDescription>)var2_2, (Map<TypeDescription, List<Throwable>>)var3_3, unresolved);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static interface Factory {
                public Dispatcher make(Target.Sink var1, List<TypeDescription> var2, Map<TypeDescription, List<Throwable>> var3, List<String> var4);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static interface Materializable {
                public void materialize(Target.Sink var1, List<TypeDescription> var2, Map<TypeDescription, List<Throwable>> var3, List<String> var4) throws IOException;

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static class ForUnresolvedElement
                implements Materializable {
                    private final Source.Element element;
                    private final String typeName;

                    /*
                     * WARNING - void declaration
                     */
                    protected ForUnresolvedElement(Source.Element element, String typeName) {
                        void var2_2;
                        void var1_1;
                        this.element = var1_1;
                        this.typeName = var2_2;
                    }

                    @Override
                    public void materialize(Target.Sink sink, List<TypeDescription> transformed, Map<TypeDescription, List<Throwable>> failed, List<String> unresolved) throws IOException {
                        sink.retain(this.element);
                        unresolved.add(this.typeName);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static class ForFailedElement
                implements Materializable {
                    private final Source.Element element;
                    private final TypeDescription typeDescription;
                    private final List<Throwable> errored;

                    /*
                     * WARNING - void declaration
                     */
                    protected ForFailedElement(Source.Element element, TypeDescription typeDescription, List<Throwable> errored) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.element = var1_1;
                        this.typeDescription = var2_2;
                        this.errored = var3_3;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void materialize(Target.Sink sink, List<TypeDescription> transformed, Map<TypeDescription, List<Throwable>> failed, List<String> unresolved) throws IOException {
                        void var3_3;
                        sink.retain(this.element);
                        var3_3.put(this.typeDescription, this.errored);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static class ForRetainedElement
                implements Materializable {
                    private final Source.Element element;

                    /*
                     * WARNING - void declaration
                     */
                    protected ForRetainedElement(Source.Element element) {
                        void var1_1;
                        this.element = var1_1;
                    }

                    @Override
                    public void materialize(Target.Sink sink, List<TypeDescription> transformed, Map<TypeDescription, List<Throwable>> failed, List<String> unresolved) throws IOException {
                        sink.retain(this.element);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static class ForTransformedElement
                implements Materializable {
                    @MaybeNull
                    private final ClassFileVersion classFileVersion;
                    private final DynamicType dynamicType;

                    /*
                     * WARNING - void declaration
                     */
                    protected ForTransformedElement(@MaybeNull ClassFileVersion classFileVersion, DynamicType dynamicType) {
                        void var2_2;
                        void var1_1;
                        this.classFileVersion = var1_1;
                        this.dynamicType = var2_2;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void materialize(Target.Sink sink, List<TypeDescription> transformed, Map<TypeDescription, List<Throwable>> failed, List<String> unresolved) throws IOException {
                        void var2_2;
                        if (this.classFileVersion == null) {
                            sink.store(this.dynamicType.getAllTypes());
                        } else {
                            void var1_1;
                            var1_1.store(this.classFileVersion, this.dynamicType.getAllTypes());
                        }
                        var2_2.add(this.dynamicType.getTypeDescription());
                    }
                }
            }
        }

        public static interface Target {
            public Sink write(@MaybeNull Manifest var1) throws IOException;

            @HashCodeAndEqualsPlugin.Enhance
            public static class ForJarFile
            implements Target {
                private final File file;

                /*
                 * WARNING - void declaration
                 */
                public ForJarFile(File file) {
                    void var1_1;
                    this.file = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public Sink write(@MaybeNull Manifest manifest) throws IOException {
                    FileOutputStream outputStream = new FileOutputStream(this.file);
                    try {
                        if (manifest == null) {
                            return new Sink.ForJarOutputStream(new JarOutputStream(outputStream));
                        }
                        return new Sink.ForJarOutputStream(new JarOutputStream((OutputStream)outputStream, manifest));
                    }
                    catch (RuntimeException exception) {
                        ((OutputStream)outputStream).close();
                        throw exception;
                    }
                    catch (IOException exception) {
                        ((OutputStream)outputStream).close();
                        throw exception;
                    }
                    catch (Error error) {
                        void var1_4;
                        void var2_5;
                        var2_5.close();
                        throw var1_4;
                    }
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.file.equals(((ForJarFile)object).file);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.file.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class ForFolder
            implements Target,
            Sink {
                private final File folder;
                private final boolean link;

                /*
                 * WARNING - void declaration
                 */
                public ForFolder(File folder) {
                    this((File)var1_1, false);
                    void var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public ForFolder(File folder, boolean link) {
                    void var2_2;
                    void var1_1;
                    this.folder = var1_1;
                    this.link = var2_2;
                }

                /*
                 * WARNING - void declaration
                 */
                private static void doStore(File folder, Map<TypeDescription, byte[]> binaryRepresentations) throws IOException {
                    for (Map.Entry<TypeDescription, byte[]> entry : binaryRepresentations.entrySet()) {
                        File target = new File(folder, entry.getKey().getInternalName() + ".class");
                        if (!target.getParentFile().isDirectory() && !target.getParentFile().mkdirs()) {
                            throw new IOException("Could not create directory: " + target.getParent());
                        }
                        FileOutputStream outputStream = new FileOutputStream(target);
                        try {
                            void var2_3;
                            ((OutputStream)outputStream).write((byte[])var2_3.getValue());
                        }
                        catch (Throwable throwable) {
                            void var3_4;
                            var3_4.close();
                            throw throwable;
                        }
                        ((OutputStream)outputStream).close();
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Sink write(@MaybeNull Manifest manifest) throws IOException {
                    if (manifest != null) {
                        File target = new File(this.folder, "META-INF/MANIFEST.MF");
                        if (!target.getParentFile().isDirectory() && !target.getParentFile().mkdirs()) {
                            throw new IOException("Could not create directory: " + target.getParent());
                        }
                        FileOutputStream outputStream = new FileOutputStream(target);
                        try {
                            void var1_1;
                            var1_1.write(outputStream);
                        }
                        catch (Throwable throwable) {
                            void var2_3;
                            var2_3.close();
                            throw throwable;
                        }
                        ((OutputStream)outputStream).close();
                    }
                    return this;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void store(Map<TypeDescription, byte[]> binaryRepresentations) throws IOException {
                    void var1_1;
                    ForFolder.doStore(this.folder, (Map<TypeDescription, byte[]>)var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void store(ClassFileVersion classFileVersion, Map<TypeDescription, byte[]> binaryRepresentations) throws IOException {
                    void var2_2;
                    void var1_1;
                    ForFolder.doStore(new File(this.folder, "META-INF/versions/" + var1_1.getJavaVersion()), (Map<TypeDescription, byte[]>)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void retain(Source.Element element) throws IOException {
                    block13: {
                        void var3_4;
                        block11: {
                            block14: {
                                File resolved;
                                File target;
                                block12: {
                                    String name = element.getName();
                                    target = new File(this.folder, name);
                                    if (name.endsWith("/")) break block11;
                                    resolved = element.resolveAs(File.class);
                                    if (!target.getCanonicalPath().startsWith(this.folder.getCanonicalPath() + File.separatorChar)) {
                                        throw new IllegalArgumentException(target + " is not a subdirectory of " + this.folder);
                                    }
                                    if (!target.getParentFile().isDirectory() && !target.getParentFile().mkdirs()) {
                                        throw new IOException("Could not create directory: " + target.getParent());
                                    }
                                    if (resolved == null || resolved.equals(target)) break block12;
                                    if (this.link) {
                                        FileSystem.getInstance().link(resolved, target);
                                    } else {
                                        FileSystem.getInstance().copy(resolved, target);
                                    }
                                    break block13;
                                }
                                if (target.equals(resolved)) break block14;
                                InputStream inputStream = element.getInputStream();
                                try {
                                    FileOutputStream outputStream = new FileOutputStream(target);
                                    try {
                                        int length;
                                        byte[] buffer = new byte[1024];
                                        while ((length = inputStream.read(buffer)) != -1) {
                                            ((OutputStream)outputStream).write(buffer, 0, length);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        void var2_2;
                                        var2_2.close();
                                        throw throwable;
                                    }
                                    ((OutputStream)outputStream).close();
                                }
                                catch (Throwable throwable) {
                                    void var1_1;
                                    var1_1.close();
                                    throw throwable;
                                }
                                inputStream.close();
                                break block13;
                            }
                            return;
                        }
                        if (!var3_4.isDirectory() && !var3_4.mkdirs()) {
                            throw new IllegalStateException("Cannot create requested directory: " + var3_4);
                        }
                    }
                }

                @Override
                public void close() {
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (this.link != ((ForFolder)object).link) {
                        return false;
                    }
                    return this.folder.equals(((ForFolder)object).folder);
                }

                public int hashCode() {
                    return (this.getClass().hashCode() * 31 + this.folder.hashCode()) * 31 + this.link;
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class InMemory
            implements Target,
            Sink {
                @HashCodeAndEqualsPlugin.Identity
                private final Map<String, byte[]> storage;

                public InMemory() {
                    this(new HashMap<String, byte[]>());
                }

                /*
                 * WARNING - void declaration
                 */
                public InMemory(Map<String, byte[]> storage) {
                    void var1_1;
                    this.storage = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Sink write(@MaybeNull Manifest manifest) throws IOException {
                    if (manifest != null) {
                        void var2_3;
                        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                        try {
                            void var1_1;
                            var1_1.write(outputStream);
                        }
                        finally {
                            outputStream.close();
                        }
                        this.storage.put("META-INF/MANIFEST.MF", var2_3.toByteArray());
                    }
                    return this;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void store(Map<TypeDescription, byte[]> binaryRepresentations) {
                    for (Map.Entry<TypeDescription, byte[]> entry : binaryRepresentations.entrySet()) {
                        void var2_2;
                        this.storage.put(entry.getKey().getInternalName() + ".class", (byte[])var2_2.getValue());
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void store(ClassFileVersion classFileVersion, Map<TypeDescription, byte[]> binaryRepresentations) throws IOException {
                    for (Map.Entry<TypeDescription, byte[]> entry : binaryRepresentations.entrySet()) {
                        void var3_3;
                        this.storage.put("META-INF/versions/" + classFileVersion.getJavaVersion() + "/" + entry.getKey().getInternalName() + ".class", (byte[])var3_3.getValue());
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void retain(Source.Element element2) throws IOException {
                    String string = element2.getName();
                    if (!string.endsWith("/")) {
                        void var1_1;
                        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                        try {
                            InputStream inputStream = element2.getInputStream();
                            try {
                                int length;
                                byte[] buffer = new byte[1024];
                                while ((length = inputStream.read(buffer)) != -1) {
                                    outputStream.write(buffer, 0, length);
                                }
                            }
                            catch (Throwable element2) {
                                void var3_5;
                                var3_5.close();
                                throw element2;
                            }
                            inputStream.close();
                        }
                        finally {
                            outputStream.close();
                        }
                        this.storage.put(var1_1.getName(), ((ByteArrayOutputStream)((Object)string)).toByteArray());
                    }
                }

                @Override
                public void close() {
                }

                public Map<String, byte[]> getStorage() {
                    return this.storage;
                }

                /*
                 * WARNING - void declaration
                 */
                public Map<String, byte[]> toTypeMap() {
                    void var1_1;
                    HashMap binaryRepresentations = new HashMap();
                    for (Map.Entry<String, byte[]> entry : this.storage.entrySet()) {
                        void var3_3;
                        if (!entry.getKey().endsWith(".class") || entry.getKey().startsWith("META-INF/versions/")) continue;
                        binaryRepresentations.put(entry.getKey().substring(0, entry.getKey().length() - 6).replace('/', '.'), var3_3.getValue());
                    }
                    return var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public Map<String, byte[]> toTypeMap(ClassFileVersion classFileVersion) {
                    void var2_2;
                    HashMap<String, byte[]> binaryRepresentations = new HashMap<String, byte[]>();
                    HashMap<String, Integer> versions = new HashMap<String, Integer>();
                    for (Map.Entry<String, byte[]> entry : this.storage.entrySet()) {
                        Integer current;
                        int version;
                        String suffix;
                        block4: {
                            if (!entry.getKey().endsWith(".class")) continue;
                            if (entry.getKey().startsWith("META-INF/versions/")) {
                                suffix = entry.getKey().substring(entry.getKey().indexOf(47, 18) + 1);
                                try {
                                    int candidate = Integer.parseInt(entry.getKey().substring(18, entry.getKey().indexOf(47, 18)));
                                    if (candidate < 7 || candidate > classFileVersion.getJavaVersion()) continue;
                                    version = candidate;
                                    break block4;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    continue;
                                }
                            }
                            suffix = entry.getKey();
                            version = 0;
                        }
                        if ((current = (Integer)versions.get(suffix)) != null && current >= version) continue;
                        versions.put(suffix, version);
                        binaryRepresentations.put(suffix.substring(0, suffix.length() - 6).replace('/', '.'), entry.getValue());
                    }
                    return var2_2;
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.storage == ((InMemory)object).storage;
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + System.identityHashCode(this.storage);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Discarding implements Target,
            Sink
            {
                INSTANCE;


                @Override
                public final Sink write(@MaybeNull Manifest manifest) {
                    return this;
                }

                @Override
                public final void store(Map<TypeDescription, byte[]> binaryRepresentations) {
                }

                @Override
                public final void store(ClassFileVersion classFileVersion, Map<TypeDescription, byte[]> binaryRepresentations) throws IOException {
                }

                @Override
                public final void retain(Source.Element element) {
                }

                @Override
                public final void close() {
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static interface Sink
            extends Closeable {
                public void store(Map<TypeDescription, byte[]> var1) throws IOException;

                public void store(ClassFileVersion var1, Map<TypeDescription, byte[]> var2) throws IOException;

                public void retain(Source.Element var1) throws IOException;

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static class ForJarOutputStream
                implements Sink {
                    private final JarOutputStream outputStream;

                    /*
                     * WARNING - void declaration
                     */
                    public ForJarOutputStream(JarOutputStream outputStream) {
                        void var1_1;
                        this.outputStream = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void store(Map<TypeDescription, byte[]> binaryRepresentations) throws IOException {
                        for (Map.Entry<TypeDescription, byte[]> entry : binaryRepresentations.entrySet()) {
                            void var2_2;
                            this.outputStream.putNextEntry(new JarEntry(entry.getKey().getInternalName() + ".class"));
                            this.outputStream.write((byte[])var2_2.getValue());
                            this.outputStream.closeEntry();
                        }
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void store(ClassFileVersion classFileVersion, Map<TypeDescription, byte[]> binaryRepresentations) throws IOException {
                        for (Map.Entry<TypeDescription, byte[]> entry : binaryRepresentations.entrySet()) {
                            void var3_3;
                            this.outputStream.putNextEntry(new JarEntry("META-INF/versions/" + classFileVersion.getJavaVersion() + "/" + entry.getKey().getInternalName() + ".class"));
                            this.outputStream.write((byte[])var3_3.getValue());
                            this.outputStream.closeEntry();
                        }
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void retain(Source.Element element) throws IOException {
                        JarEntry entry = element.resolveAs(JarEntry.class);
                        String name = element.getName();
                        this.outputStream.putNextEntry(entry == null ? new JarEntry(name) : entry);
                        if (entry != null || !name.endsWith("/")) {
                            InputStream inputStream = element.getInputStream();
                            try {
                                int length;
                                byte[] buffer = new byte[1024];
                                while ((length = inputStream.read(buffer)) != -1) {
                                    void var3_5;
                                    this.outputStream.write(buffer, 0, (int)var3_5);
                                }
                            }
                            catch (Throwable throwable) {
                                void var1_1;
                                var1_1.close();
                                throw throwable;
                            }
                            inputStream.close();
                        }
                        this.outputStream.closeEntry();
                    }

                    @Override
                    public void close() throws IOException {
                        this.outputStream.close();
                    }
                }
            }
        }

        public static interface Source {
            public Origin read() throws IOException;

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class Filtering
            implements Source {
                private final Source delegate;
                private final ElementMatcher<Element> matcher;
                private final boolean manifest;

                /*
                 * WARNING - void declaration
                 */
                public Filtering(Source delegate, ElementMatcher<Element> matcher) {
                    this((Source)var1_1, (ElementMatcher<Element>)var2_2, true);
                    void var2_2;
                    void var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public Filtering(Source delegate, ElementMatcher<Element> matcher, boolean manifest) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.delegate = var1_1;
                    this.matcher = var2_2;
                    this.manifest = var3_3;
                }

                /*
                 * WARNING - void declaration
                 */
                public static Source dropMultiReleaseClassFilesAbove(Source delegate, ClassFileVersion classFileVersion) {
                    void var1_1;
                    Source source;
                    return new Filtering(source, new MultiReleaseVersionMatcher((ClassFileVersion)var1_1));
                }

                public static Source dropFolders(Source delegate) {
                    Source source;
                    return new Filtering(source, NoFolderMatcher.INSTANCE);
                }

                @Override
                public Origin read() throws IOException {
                    return new Origin.Filtering(this.delegate.read(), this.matcher, this.manifest);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (this.manifest != ((Filtering)object).manifest) {
                        return false;
                    }
                    if (!this.delegate.equals(((Filtering)object).delegate)) {
                        return false;
                    }
                    return this.matcher.equals(((Filtering)object).matcher);
                }

                public int hashCode() {
                    return ((this.getClass().hashCode() * 31 + this.delegate.hashCode()) * 31 + this.matcher.hashCode()) * 31 + this.manifest;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                protected static enum NoFolderMatcher implements ElementMatcher<Element>
                {
                    INSTANCE;


                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final boolean matches(@MaybeNull Element target) {
                        void var1_1;
                        return target == null || !var1_1.getName().endsWith("/");
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                protected static class MultiReleaseVersionMatcher
                implements ElementMatcher<Element> {
                    private final ClassFileVersion classFileVersion;

                    /*
                     * WARNING - void declaration
                     */
                    protected MultiReleaseVersionMatcher(ClassFileVersion classFileVersion) {
                        void var1_1;
                        this.classFileVersion = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public boolean matches(@MaybeNull Element target) {
                        if (target == null) {
                            return true;
                        }
                        String name = target.getName();
                        if (name.startsWith("/")) {
                            name = name.substring(1);
                        }
                        if (name.startsWith("META-INF/versions/")) {
                            void var1_2;
                            try {
                                int version = Integer.parseInt(name.substring(18, name.indexOf(47, 18)));
                            }
                            catch (NumberFormatException numberFormatException) {
                                return true;
                            }
                            return var1_2 <= this.classFileVersion.getJavaVersion();
                        }
                        return true;
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        return this.classFileVersion.equals(((MultiReleaseVersionMatcher)object).classFileVersion);
                    }

                    public int hashCode() {
                        return this.getClass().hashCode() * 31 + this.classFileVersion.hashCode();
                    }
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            public static class ForJarFile
            implements Source {
                private final File file;

                /*
                 * WARNING - void declaration
                 */
                public ForJarFile(File file) {
                    void var1_1;
                    this.file = var1_1;
                }

                public Origin read() throws IOException {
                    return new Origin.ForJarFile(new JarFile(this.file, false));
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.file.equals(((ForJarFile)object).file);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.file.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class ForFolder
            implements Source,
            Origin {
                private final File folder;

                /*
                 * WARNING - void declaration
                 */
                public ForFolder(File folder) {
                    void var1_1;
                    this.folder = var1_1;
                }

                @Override
                public Origin read() {
                    return this;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public ClassFileLocator toClassFileLocator(@MaybeNull ClassFileVersion classFileVersion) throws IOException {
                    void var1_1;
                    if (classFileVersion == null) {
                        return new ClassFileLocator.ForFolder(this.folder);
                    }
                    return ClassFileLocator.ForFolder.of(this.folder, (ClassFileVersion)var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                @MaybeNull
                public Manifest getManifest() throws IOException {
                    File file = new File(this.folder, "META-INF/MANIFEST.MF");
                    if (file.exists()) {
                        Manifest manifest;
                        FileInputStream inputStream = new FileInputStream(file);
                        try {
                            manifest = new Manifest(inputStream);
                        }
                        catch (Throwable throwable) {
                            void var1_1;
                            var1_1.close();
                            throw throwable;
                        }
                        ((InputStream)inputStream).close();
                        return manifest;
                    }
                    return NO_MANIFEST;
                }

                @Override
                public Iterator<Element> iterator() {
                    ForFolder forFolder = this;
                    return forFolder.new FolderIterator(forFolder.folder);
                }

                @Override
                public void close() {
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.folder.equals(((ForFolder)object).folder);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.folder.hashCode();
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                protected class FolderIterator
                implements Iterator<Element> {
                    private final Queue<File> files = QueueFactory.make();

                    /*
                     * WARNING - void declaration
                     */
                    protected FolderIterator(File folder) {
                        File[] file = folder.listFiles();
                        if (file != null) {
                            void var1_1;
                            for (void candidate : var1_1) {
                                if (candidate.equals(new File(folder, "META-INF/MANIFEST.MF"))) continue;
                                this.files.add((File)candidate);
                            }
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.files.isEmpty();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    @SuppressFBWarnings(value={"IT_NO_SUCH_ELEMENT"}, justification="Exception is thrown by invoking removeFirst on an empty list.")
                    public Element next() {
                        void var1_1;
                        File[] file;
                        File next = this.files.remove();
                        if (next.isDirectory() && (file = next.listFiles()) != null) {
                            void var2_2;
                            for (void candidate : var2_2) {
                                if (candidate.equals(new File(ForFolder.this.folder, "META-INF/MANIFEST.MF"))) continue;
                                this.files.add((File)candidate);
                            }
                        }
                        return new Element.ForFile(ForFolder.this.folder, (File)var1_1);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class InMemory
            implements Source,
            Origin {
                private final Map<String, byte[]> storage;

                /*
                 * WARNING - void declaration
                 */
                public InMemory(Map<String, byte[]> storage) {
                    void var1_1;
                    this.storage = var1_1;
                }

                public static Source ofTypes(Class<?> ... type) {
                    return InMemory.ofTypes(Arrays.asList(type));
                }

                public static Source ofTypes(Collection<? extends Class<?>> types) {
                    return InMemory.ofTypes(types, Collections.<ClassFileVersion, Collection<Class<?>>>emptyMap());
                }

                /*
                 * WARNING - void declaration
                 */
                public static Source ofTypes(Collection<? extends Class<?>> types, Map<ClassFileVersion, Collection<? extends Class<?>>> versionedTypes) {
                    void var2_2;
                    void var1_1;
                    Collection<Class<?>> collection;
                    HashMap versionedBinaryRepresentations = new HashMap();
                    for (Map.Entry iterator : versionedTypes.entrySet()) {
                        HashMap<TypeDescription, byte[]> binaryRepresentations = new HashMap<TypeDescription, byte[]>();
                        for (Class type : (Collection)iterator.getValue()) {
                            binaryRepresentations.put(TypeDescription.ForLoadedType.of(type), ClassFileLocator.ForClassLoader.read(type));
                        }
                        versionedBinaryRepresentations.put(iterator.getKey(), binaryRepresentations);
                    }
                    HashMap<TypeDescription, byte[]> binaryRepresentations = new HashMap<TypeDescription, byte[]>();
                    for (Class<?> type : collection) {
                        binaryRepresentations.put(TypeDescription.ForLoadedType.of(type), ClassFileLocator.ForClassLoader.read(type));
                    }
                    return InMemory.ofTypes((Map<TypeDescription, byte[]>)var1_1, (Map<ClassFileVersion, Map<TypeDescription, byte[]>>)var2_2);
                }

                public static Source ofTypes(Map<TypeDescription, byte[]> binaryRepresentations) {
                    return InMemory.ofTypes(binaryRepresentations, Collections.<ClassFileVersion, Map<TypeDescription, byte[]>>emptyMap());
                }

                /*
                 * WARNING - void declaration
                 */
                public static Source ofTypes(Map<TypeDescription, byte[]> binaryRepresentations, Map<ClassFileVersion, Map<TypeDescription, byte[]>> versionedBinaryRepresentations) {
                    void var2_2;
                    Iterator iterator;
                    Iterator iterator2;
                    HashMap storage = new HashMap();
                    for (Map.Entry entry : iterator2.entrySet()) {
                        storage.put(((TypeDescription)entry.getKey()).getInternalName() + ".class", entry.getValue());
                    }
                    for (Map.Entry entry : iterator.entrySet()) {
                        iterator = ((Map)entry.getValue()).entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry2 = iterator.next();
                            storage.put("META-INF/versions/" + ((ClassFileVersion)entry.getKey()).getJavaVersion() + "/" + ((TypeDescription)entry2.getKey()).getInternalName() + ".class", entry2.getValue());
                        }
                    }
                    return new InMemory((Map<String, byte[]>)var2_2);
                }

                @Override
                public Origin read() {
                    return this;
                }

                @Override
                public ClassFileLocator toClassFileLocator(@MaybeNull ClassFileVersion classFileVersion) {
                    return ClassFileLocator.Simple.ofResources(this.storage);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                @MaybeNull
                public Manifest getManifest() throws IOException {
                    void var1_1;
                    byte[] binaryRepresentation = this.storage.get("META-INF/MANIFEST.MF");
                    if (binaryRepresentation == null) {
                        return NO_MANIFEST;
                    }
                    return new Manifest(new ByteArrayInputStream((byte[])var1_1));
                }

                @Override
                public Iterator<Element> iterator() {
                    return new MapEntryIterator(this.storage.entrySet().iterator());
                }

                @Override
                public void close() {
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return ((Object)this.storage).equals(((InMemory)object).storage);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + ((Object)this.storage).hashCode();
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                protected static class MapEntryIterator
                implements Iterator<Element> {
                    private final Iterator<Map.Entry<String, byte[]>> iterator;

                    /*
                     * WARNING - void declaration
                     */
                    protected MapEntryIterator(Iterator<Map.Entry<String, byte[]>> iterator) {
                        void var1_1;
                        this.iterator = var1_1;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Element next() {
                        void var1_1;
                        Map.Entry<String, byte[]> entry = this.iterator.next();
                        return new Element.ForByteArray(entry.getKey(), (byte[])var1_1.getValue());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class Compound
            implements Source {
                private final Collection<? extends Source> sources;

                /*
                 * WARNING - void declaration
                 */
                public Compound(Collection<? extends Source> sources) {
                    void var1_1;
                    this.sources = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public net.bytebuddy.build.Plugin$Engine$Source$Origin read() throws IOException {
                    if (this.sources.isEmpty()) {
                        return Empty.INSTANCE;
                    }
                    if (this.sources.size() == 1) {
                        return this.sources.iterator().next().read();
                    }
                    ArrayList<net.bytebuddy.build.Plugin$Engine$Source$Origin> arrayList = new ArrayList<net.bytebuddy.build.Plugin$Engine$Source$Origin>(this.sources.size());
                    try {
                        for (Source source : this.sources) {
                            arrayList.add(source.read());
                        }
                    }
                    catch (IOException exception) {
                        void var2_5;
                        for (net.bytebuddy.build.Plugin$Engine$Source$Origin origin : arrayList) {
                            origin.close();
                        }
                        throw var2_5;
                    }
                    return new Origin(arrayList);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return ((Object)this.sources).equals(((Compound)object).sources);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + ((Object)this.sources).hashCode();
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                protected static class Origin
                implements net.bytebuddy.build.Plugin$Engine$Source$Origin {
                    private final List<net.bytebuddy.build.Plugin$Engine$Source$Origin> origins;

                    /*
                     * WARNING - void declaration
                     */
                    protected Origin(List<net.bytebuddy.build.Plugin$Engine$Source$Origin> origins) {
                        void var1_1;
                        this.origins = var1_1;
                    }

                    @Override
                    public Manifest getManifest() throws IOException {
                        for (net.bytebuddy.build.Plugin$Engine$Source$Origin origin : this.origins) {
                            Manifest manifest = origin.getManifest();
                            if (manifest == null) continue;
                            return origin;
                        }
                        return NO_MANIFEST;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public ClassFileLocator toClassFileLocator(@MaybeNull ClassFileVersion classFileVersion) throws IOException {
                        void var2_2;
                        ArrayList<ClassFileLocator> classFileLocators = new ArrayList<ClassFileLocator>(this.origins.size());
                        for (net.bytebuddy.build.Plugin$Engine$Source$Origin origin : this.origins) {
                            classFileLocators.add(origin.toClassFileLocator(classFileVersion));
                        }
                        return new ClassFileLocator.Compound((List<? extends ClassFileLocator>)var2_2);
                    }

                    @Override
                    public Iterator<Element> iterator() {
                        return new CompoundIterator(this.origins);
                    }

                    @Override
                    public void close() throws IOException {
                        for (net.bytebuddy.build.Plugin$Engine$Source$Origin origin : this.origins) {
                            origin.close();
                        }
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        return ((Object)this.origins).equals(((Origin)object).origins);
                    }

                    public int hashCode() {
                        return this.getClass().hashCode() * 31 + ((Object)this.origins).hashCode();
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    protected static class CompoundIterator
                    implements Iterator<Element> {
                        @MaybeNull
                        private Iterator<? extends Element> current;
                        private final Queue<? extends Iterable<? extends Element>> backlog;

                        /*
                         * WARNING - void declaration
                         */
                        protected CompoundIterator(List<? extends Iterable<? extends Element>> iterables) {
                            void var1_1;
                            this.backlog = QueueFactory.make(var1_1);
                            this.forward();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.current != null && this.current.hasNext();
                        }

                        @Override
                        public Element next() {
                            try {
                                if (this.current != null) {
                                    Element element = this.current.next();
                                    return element;
                                }
                                throw new NoSuchElementException();
                            }
                            finally {
                                this.forward();
                            }
                        }

                        private void forward() {
                            while (!(this.current != null && this.current.hasNext() || this.backlog.isEmpty())) {
                                this.current = this.backlog.remove().iterator();
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("remove");
                        }
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Empty implements Source,
            Origin
            {
                INSTANCE;


                @Override
                public final Origin read() {
                    return this;
                }

                @Override
                public final ClassFileLocator toClassFileLocator(@MaybeNull ClassFileVersion classFileVersion) {
                    return ClassFileLocator.NoOp.INSTANCE;
                }

                @Override
                @MaybeNull
                public final Manifest getManifest() {
                    return NO_MANIFEST;
                }

                @Override
                public final Iterator<Element> iterator() {
                    return Collections.emptySet().iterator();
                }

                @Override
                public final void close() {
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static interface Element {
                public String getName();

                public InputStream getInputStream() throws IOException;

                @MaybeNull
                public <T> T resolveAs(Class<T> var1);

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                public static class ForJarEntry
                implements Element {
                    private final JarFile file;
                    private final JarEntry entry;

                    /*
                     * WARNING - void declaration
                     */
                    public ForJarEntry(JarFile file, JarEntry entry) {
                        void var2_2;
                        void var1_1;
                        this.file = var1_1;
                        this.entry = var2_2;
                    }

                    @Override
                    public String getName() {
                        return this.entry.getName();
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        return this.file.getInputStream(this.entry);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    @MaybeNull
                    public <T> T resolveAs(Class<T> type) {
                        void var1_1;
                        if (JarEntry.class.isAssignableFrom((Class<?>)var1_1)) {
                            return (T)this.entry;
                        }
                        return null;
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (!this.file.equals(((ForJarEntry)object).file)) {
                            return false;
                        }
                        return this.entry.equals(((ForJarEntry)object).entry);
                    }

                    public int hashCode() {
                        return (this.getClass().hashCode() * 31 + this.file.hashCode()) * 31 + this.entry.hashCode();
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                public static class ForFile
                implements Element {
                    private final File root;
                    private final File file;

                    /*
                     * WARNING - void declaration
                     */
                    public ForFile(File root, File file) {
                        void var2_2;
                        void var1_1;
                        this.root = var1_1;
                        this.file = var2_2;
                    }

                    @Override
                    public String getName() {
                        return this.root.getAbsoluteFile().toURI().relativize(this.file.getAbsoluteFile().toURI()).getPath();
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        return new FileInputStream(this.file);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    @MaybeNull
                    public <T> T resolveAs(Class<T> type) {
                        void var1_1;
                        if (File.class.isAssignableFrom((Class<?>)var1_1)) {
                            return (T)this.file;
                        }
                        return null;
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (!this.root.equals(((ForFile)object).root)) {
                            return false;
                        }
                        return this.file.equals(((ForFile)object).file);
                    }

                    public int hashCode() {
                        return (this.getClass().hashCode() * 31 + this.root.hashCode()) * 31 + this.file.hashCode();
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="The array is not modified by class contract.")
                public static class ForByteArray
                implements Element {
                    private final String name;
                    private final byte[] binaryRepresentation;

                    /*
                     * WARNING - void declaration
                     */
                    public ForByteArray(String name, byte[] binaryRepresentation) {
                        void var2_2;
                        void var1_1;
                        this.name = var1_1;
                        this.binaryRepresentation = var2_2;
                    }

                    @Override
                    public String getName() {
                        return this.name;
                    }

                    @Override
                    public InputStream getInputStream() {
                        return new ByteArrayInputStream(this.binaryRepresentation);
                    }

                    @Override
                    @AlwaysNull
                    public <T> T resolveAs(Class<T> type) {
                        return null;
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (!this.name.equals(((ForByteArray)object).name)) {
                            return false;
                        }
                        return Arrays.equals(this.binaryRepresentation, ((ForByteArray)object).binaryRepresentation);
                    }

                    public int hashCode() {
                        return (this.getClass().hashCode() * 31 + this.name.hashCode()) * 31 + Arrays.hashCode(this.binaryRepresentation);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static interface Origin
            extends Closeable,
            Iterable<Element> {
                @AlwaysNull
                public static final Manifest NO_MANIFEST = null;

                @MaybeNull
                public Manifest getManifest() throws IOException;

                public ClassFileLocator toClassFileLocator(@MaybeNull ClassFileVersion var1) throws IOException;

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                public static class Filtering
                implements Origin {
                    private final Origin delegate;
                    private final ElementMatcher<Element> matcher;
                    private final boolean manifest;

                    /*
                     * WARNING - void declaration
                     */
                    public Filtering(Origin delegate, ElementMatcher<Element> matcher) {
                        this((Origin)var1_1, (ElementMatcher<Element>)var2_2, true);
                        void var2_2;
                        void var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public Filtering(Origin delegate, ElementMatcher<Element> matcher, boolean manifest) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.delegate = var1_1;
                        this.matcher = var2_2;
                        this.manifest = var3_3;
                    }

                    @Override
                    @MaybeNull
                    public Manifest getManifest() throws IOException {
                        if (this.manifest) {
                            return this.delegate.getManifest();
                        }
                        return NO_MANIFEST;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public ClassFileLocator toClassFileLocator(@MaybeNull ClassFileVersion classFileVersion) throws IOException {
                        void var1_1;
                        return this.delegate.toClassFileLocator((ClassFileVersion)var1_1);
                    }

                    @Override
                    public Iterator<Element> iterator() {
                        return new FilteringIterator(this.delegate.iterator(), this.matcher);
                    }

                    @Override
                    public void close() throws IOException {
                        this.delegate.close();
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (this.manifest != ((Filtering)object).manifest) {
                            return false;
                        }
                        if (!this.delegate.equals(((Filtering)object).delegate)) {
                            return false;
                        }
                        return this.matcher.equals(((Filtering)object).matcher);
                    }

                    public int hashCode() {
                        return ((this.getClass().hashCode() * 31 + this.delegate.hashCode()) * 31 + this.matcher.hashCode()) * 31 + this.manifest;
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    private static class FilteringIterator
                    implements Iterator<Element> {
                        private final Iterator<Element> iterator;
                        private final ElementMatcher<Element> matcher;
                        @MaybeNull
                        private Element current;

                        /*
                         * WARNING - void declaration
                         */
                        private FilteringIterator(Iterator<Element> iterator, ElementMatcher<Element> matcher) {
                            this.iterator = iterator;
                            this.matcher = matcher;
                            while (iterator.hasNext()) {
                                void var3_3;
                                Element element = iterator.next();
                                if (!matcher.matches(element)) continue;
                                this.current = var3_3;
                                break;
                            }
                        }

                        @Override
                        public boolean hasNext() {
                            return this.current != null;
                        }

                        @Override
                        public Element next() {
                            if (this.current == null) {
                                throw new NoSuchElementException();
                            }
                            try {
                                Element element = this.current;
                                return element;
                            }
                            finally {
                                this.current = null;
                                while (this.iterator.hasNext()) {
                                    Element element = this.iterator.next();
                                    if (!this.matcher.matches(element)) continue;
                                    this.current = element;
                                    break;
                                }
                            }
                        }

                        @Override
                        public void remove() {
                            this.iterator.remove();
                        }
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static class ForJarFile
                implements Origin {
                    private final JarFile file;

                    /*
                     * WARNING - void declaration
                     */
                    public ForJarFile(JarFile file) {
                        void var1_1;
                        this.file = var1_1;
                    }

                    @Override
                    @MaybeNull
                    public Manifest getManifest() throws IOException {
                        return this.file.getManifest();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public ClassFileLocator toClassFileLocator(@MaybeNull ClassFileVersion classFileVersion) throws IOException {
                        void var1_1;
                        if (classFileVersion == null) {
                            return new ClassFileLocator.ForJarFile(this.file);
                        }
                        return ClassFileLocator.ForJarFile.of(this.file, (ClassFileVersion)var1_1);
                    }

                    @Override
                    public void close() throws IOException {
                        this.file.close();
                    }

                    @Override
                    public Iterator<Element> iterator() {
                        ForJarFile forJarFile = this;
                        return new JarFileIterator(forJarFile, forJarFile.file.entries());
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    protected class JarFileIterator
                    implements Iterator<Element> {
                        private final Enumeration<JarEntry> enumeration;
                        final /* synthetic */ ForJarFile this$0;

                        /*
                         * WARNING - void declaration
                         */
                        protected JarFileIterator(ForJarFile this$0, Enumeration<JarEntry> enumeration) {
                            void var2_2;
                            void var1_1;
                            this.this$0 = var1_1;
                            this.enumeration = var2_2;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.enumeration.hasMoreElements();
                        }

                        @Override
                        public Element next() {
                            return new Element.ForJarEntry(this.this$0.file, this.enumeration.nextElement());
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("remove");
                        }
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Listener
        extends ErrorHandler {
            public void onDiscovery(String var1);

            public void onTransformation(TypeDescription var1, Plugin var2);

            public void onTransformation(TypeDescription var1, List<Plugin> var2);

            public void onIgnored(TypeDescription var1, Plugin var2);

            public void onIgnored(TypeDescription var1, List<Plugin> var2);

            public void onComplete(TypeDescription var1);

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class Compound
            implements Listener {
                private final List<Listener> listeners = new ArrayList<Listener>();

                /*
                 * WARNING - void declaration
                 */
                public Compound(Listener ... listener) {
                    this(Arrays.asList(var1_1));
                    void var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public Compound(List<? extends Listener> listeners) {
                    Iterator iterator;
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        void var2_2;
                        Listener listener = (Listener)iterator.next();
                        if (listener instanceof Compound) {
                            this.listeners.addAll(((Compound)listener).listeners);
                            continue;
                        }
                        if (listener instanceof NoOp) continue;
                        this.listeners.add((Listener)var2_2);
                    }
                }

                @Override
                public void onDiscovery(String typeName) {
                    for (Listener listener : this.listeners) {
                        listener.onDiscovery(typeName);
                    }
                }

                @Override
                public void onTransformation(TypeDescription typeDescription, Plugin plugin) {
                    for (Listener listener : this.listeners) {
                        listener.onTransformation(typeDescription, plugin);
                    }
                }

                @Override
                public void onTransformation(TypeDescription typeDescription, List<Plugin> plugins) {
                    for (Listener listener : this.listeners) {
                        listener.onTransformation(typeDescription, plugins);
                    }
                }

                @Override
                public void onIgnored(TypeDescription typeDescription, Plugin plugin) {
                    for (Listener listener : this.listeners) {
                        listener.onIgnored(typeDescription, plugin);
                    }
                }

                @Override
                public void onIgnored(TypeDescription typeDescription, List<Plugin> plugins) {
                    for (Listener listener : this.listeners) {
                        listener.onIgnored(typeDescription, plugins);
                    }
                }

                @Override
                public void onError(TypeDescription typeDescription, Plugin plugin, Throwable throwable) {
                    for (Listener listener : this.listeners) {
                        listener.onError(typeDescription, plugin, throwable);
                    }
                }

                @Override
                public void onError(TypeDescription typeDescription, List<Throwable> throwables) {
                    for (Listener listener : this.listeners) {
                        listener.onError(typeDescription, throwables);
                    }
                }

                @Override
                public void onError(Map<TypeDescription, List<Throwable>> throwables) {
                    for (Listener listener : this.listeners) {
                        listener.onError(throwables);
                    }
                }

                @Override
                public void onError(Plugin plugin, Throwable throwable) {
                    for (Listener listener : this.listeners) {
                        listener.onError(plugin, throwable);
                    }
                }

                @Override
                public void onLiveInitializer(TypeDescription typeDescription, TypeDescription definingType) {
                    for (Listener listener : this.listeners) {
                        listener.onLiveInitializer(typeDescription, definingType);
                    }
                }

                @Override
                public void onComplete(TypeDescription typeDescription) {
                    for (Listener listener : this.listeners) {
                        listener.onComplete(typeDescription);
                    }
                }

                @Override
                public void onUnresolved(String typeName) {
                    for (Listener listener : this.listeners) {
                        listener.onUnresolved(typeName);
                    }
                }

                @Override
                public void onManifest(@MaybeNull Manifest manifest) {
                    for (Listener listener : this.listeners) {
                        listener.onManifest(manifest);
                    }
                }

                @Override
                public void onResource(String name) {
                    for (Listener listener : this.listeners) {
                        listener.onResource(name);
                    }
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return ((Object)this.listeners).equals(((Compound)object).listeners);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + ((Object)this.listeners).hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class ForErrorHandler
            extends Adapter {
                private final ErrorHandler errorHandler;

                /*
                 * WARNING - void declaration
                 */
                public ForErrorHandler(ErrorHandler errorHandler) {
                    void var1_1;
                    this.errorHandler = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onError(TypeDescription typeDescription, Plugin plugin, Throwable throwable) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.errorHandler.onError((TypeDescription)var1_1, (Plugin)var2_2, (Throwable)var3_3);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onError(TypeDescription typeDescription, List<Throwable> throwables) {
                    void var2_2;
                    void var1_1;
                    this.errorHandler.onError((TypeDescription)var1_1, (List<Throwable>)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onError(Map<TypeDescription, List<Throwable>> throwables) {
                    void var1_1;
                    this.errorHandler.onError((Map<TypeDescription, List<Throwable>>)var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onError(Plugin plugin, Throwable throwable) {
                    void var2_2;
                    void var1_1;
                    this.errorHandler.onError((Plugin)var1_1, (Throwable)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onLiveInitializer(TypeDescription typeDescription, TypeDescription definingType) {
                    void var2_2;
                    void var1_1;
                    this.errorHandler.onLiveInitializer((TypeDescription)var1_1, (TypeDescription)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onUnresolved(String typeName) {
                    void var1_1;
                    this.errorHandler.onUnresolved((String)var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onManifest(@MaybeNull Manifest manifest) {
                    void var1_1;
                    this.errorHandler.onManifest((Manifest)var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onResource(String name) {
                    void var1_1;
                    this.errorHandler.onResource((String)var1_1);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.errorHandler.equals(((ForErrorHandler)object).errorHandler);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.errorHandler.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class WithErrorsOnly
            extends Adapter {
                private final Listener delegate;

                /*
                 * WARNING - void declaration
                 */
                public WithErrorsOnly(Listener delegate) {
                    void var1_1;
                    this.delegate = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onError(TypeDescription typeDescription, Plugin plugin, Throwable throwable) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.delegate.onError((TypeDescription)var1_1, (Plugin)var2_2, (Throwable)var3_3);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onError(TypeDescription typeDescription, List<Throwable> throwables) {
                    void var2_2;
                    void var1_1;
                    this.delegate.onError((TypeDescription)var1_1, (List<Throwable>)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onError(Map<TypeDescription, List<Throwable>> throwables) {
                    void var1_1;
                    this.delegate.onError((Map<TypeDescription, List<Throwable>>)var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onError(Plugin plugin, Throwable throwable) {
                    void var2_2;
                    void var1_1;
                    this.delegate.onError((Plugin)var1_1, (Throwable)var2_2);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.delegate.equals(((WithErrorsOnly)object).delegate);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.delegate.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class WithTransformationsOnly
            extends Adapter {
                private final Listener delegate;

                /*
                 * WARNING - void declaration
                 */
                public WithTransformationsOnly(Listener delegate) {
                    void var1_1;
                    this.delegate = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onTransformation(TypeDescription typeDescription, Plugin plugin) {
                    void var2_2;
                    void var1_1;
                    this.delegate.onTransformation((TypeDescription)var1_1, (Plugin)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onTransformation(TypeDescription typeDescription, List<Plugin> plugins) {
                    void var2_2;
                    void var1_1;
                    this.delegate.onTransformation((TypeDescription)var1_1, (List<Plugin>)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onError(TypeDescription typeDescription, Plugin plugin, Throwable throwable) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.delegate.onError((TypeDescription)var1_1, (Plugin)var2_2, (Throwable)var3_3);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onError(TypeDescription typeDescription, List<Throwable> throwables) {
                    void var2_2;
                    void var1_1;
                    this.delegate.onError((TypeDescription)var1_1, (List<Throwable>)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onError(Map<TypeDescription, List<Throwable>> throwables) {
                    void var1_1;
                    this.delegate.onError((Map<TypeDescription, List<Throwable>>)var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onError(Plugin plugin, Throwable throwable) {
                    void var2_2;
                    void var1_1;
                    this.delegate.onError((Plugin)var1_1, (Throwable)var2_2);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.delegate.equals(((WithTransformationsOnly)object).delegate);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.delegate.hashCode();
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            public static class StreamWriting
            extends Adapter {
                protected static final String PREFIX = "[Byte Buddy]";
                private final PrintStream printStream;

                /*
                 * WARNING - void declaration
                 */
                public StreamWriting(PrintStream printStream) {
                    void var1_1;
                    this.printStream = var1_1;
                }

                public static StreamWriting toSystemOut() {
                    return new StreamWriting(System.out);
                }

                public static StreamWriting toSystemError() {
                    return new StreamWriting(System.err);
                }

                public Listener withTransformationsOnly() {
                    return new WithTransformationsOnly(this);
                }

                public Listener withErrorsOnly() {
                    return new WithErrorsOnly(this);
                }

                /*
                 * WARNING - void declaration
                 */
                public void onDiscovery(String typeName) {
                    void var1_1;
                    this.printStream.printf("[Byte Buddy] DISCOVERY %s", var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                public void onTransformation(TypeDescription typeDescription, Plugin plugin) {
                    void var2_2;
                    void var1_1;
                    this.printStream.printf("[Byte Buddy] TRANSFORM %s for %s", var1_1, var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                public void onIgnored(TypeDescription typeDescription, Plugin plugin) {
                    void var2_2;
                    void var1_1;
                    this.printStream.printf("[Byte Buddy] IGNORE %s for %s", var1_1, var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                public void onError(TypeDescription typeDescription, Plugin plugin, Throwable throwable) {
                    PrintStream printStream = this.printStream;
                    synchronized (printStream) {
                        void var3_4;
                        void var2_3;
                        void var1_1;
                        this.printStream.printf("[Byte Buddy] ERROR %s for %s", var1_1, var2_3);
                        var3_4.printStackTrace(this.printStream);
                        return;
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                public void onError(Plugin plugin, Throwable throwable) {
                    PrintStream printStream = this.printStream;
                    synchronized (printStream) {
                        void var2_3;
                        void var1_1;
                        this.printStream.printf("[Byte Buddy] ERROR %s", var1_1);
                        var2_3.printStackTrace(this.printStream);
                        return;
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                public void onUnresolved(String typeName) {
                    void var1_1;
                    this.printStream.printf("[Byte Buddy] UNRESOLVED %s", var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                public void onLiveInitializer(TypeDescription typeDescription, TypeDescription definingType) {
                    void var2_2;
                    void var1_1;
                    this.printStream.printf("[Byte Buddy] LIVE %s on %s", var1_1, var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                public void onComplete(TypeDescription typeDescription) {
                    void var1_1;
                    this.printStream.printf("[Byte Buddy] COMPLETE %s", var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                public void onManifest(@MaybeNull Manifest manifest) {
                    void var1_1;
                    this.printStream.printf("[Byte Buddy] MANIFEST %b", var1_1 != null);
                }

                /*
                 * WARNING - void declaration
                 */
                public void onResource(String name) {
                    void var1_1;
                    this.printStream.printf("[Byte Buddy] RESOURCE %s", var1_1);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.printStream.equals(((StreamWriting)object).printStream);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.printStream.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static abstract class Adapter
            implements Listener {
                @Override
                public void onDiscovery(String typeName) {
                }

                @Override
                public void onTransformation(TypeDescription typeDescription, Plugin plugin) {
                }

                @Override
                public void onTransformation(TypeDescription typeDescription, List<Plugin> plugins) {
                }

                @Override
                public void onIgnored(TypeDescription typeDescription, Plugin plugin) {
                }

                @Override
                public void onIgnored(TypeDescription typeDescription, List<Plugin> plugins) {
                }

                @Override
                public void onError(TypeDescription typeDescription, Plugin plugin, Throwable throwable) {
                }

                @Override
                public void onError(TypeDescription typeDescription, List<Throwable> throwables) {
                }

                @Override
                public void onError(Map<TypeDescription, List<Throwable>> throwables) {
                }

                @Override
                public void onError(Plugin plugin, Throwable throwable) {
                }

                @Override
                public void onLiveInitializer(TypeDescription typeDescription, TypeDescription definingType) {
                }

                @Override
                public void onComplete(TypeDescription typeDescription) {
                }

                @Override
                public void onUnresolved(String typeName) {
                }

                @Override
                public void onManifest(@MaybeNull Manifest manifest) {
                }

                @Override
                public void onResource(String name) {
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum NoOp implements Listener
            {
                INSTANCE;


                @Override
                public final void onDiscovery(String typeName) {
                }

                @Override
                public final void onTransformation(TypeDescription typeDescription, Plugin plugin) {
                }

                @Override
                public final void onTransformation(TypeDescription typeDescription, List<Plugin> plugins) {
                }

                @Override
                public final void onIgnored(TypeDescription typeDescription, Plugin plugin) {
                }

                @Override
                public final void onIgnored(TypeDescription typeDescription, List<Plugin> plugins) {
                }

                @Override
                public final void onError(TypeDescription typeDescription, Plugin plugin, Throwable throwable) {
                }

                @Override
                public final void onError(TypeDescription typeDescription, List<Throwable> throwables) {
                }

                @Override
                public final void onError(Map<TypeDescription, List<Throwable>> throwables) {
                }

                @Override
                public final void onError(Plugin plugin, Throwable throwable) {
                }

                @Override
                public final void onLiveInitializer(TypeDescription typeDescription, TypeDescription definingType) {
                }

                @Override
                public final void onComplete(TypeDescription typeDescription) {
                }

                @Override
                public final void onUnresolved(String typeName) {
                }

                @Override
                public final void onManifest(@MaybeNull Manifest manifest) {
                }

                @Override
                public final void onResource(String name) {
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface ErrorHandler {
            public void onError(TypeDescription var1, Plugin var2, Throwable var3);

            public void onError(TypeDescription var1, List<Throwable> var2);

            public void onError(Map<TypeDescription, List<Throwable>> var1);

            public void onError(Plugin var1, Throwable var2);

            public void onLiveInitializer(TypeDescription var1, TypeDescription var2);

            public void onUnresolved(String var1);

            public void onManifest(@MaybeNull Manifest var1);

            public void onResource(String var1);

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class Compound
            implements ErrorHandler {
                private final List<ErrorHandler> errorHandlers = new ArrayList<ErrorHandler>();

                /*
                 * WARNING - void declaration
                 */
                public Compound(ErrorHandler ... errorHandler) {
                    this(Arrays.asList(var1_1));
                    void var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public Compound(List<? extends ErrorHandler> errorHandlers) {
                    Iterator iterator;
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        void var2_2;
                        ErrorHandler errorHandler = (ErrorHandler)iterator.next();
                        if (errorHandler instanceof Compound) {
                            this.errorHandlers.addAll(((Compound)errorHandler).errorHandlers);
                            continue;
                        }
                        if (errorHandler instanceof Listener.NoOp) continue;
                        this.errorHandlers.add((ErrorHandler)var2_2);
                    }
                }

                @Override
                public void onError(TypeDescription typeDescription, Plugin plugin, Throwable throwable) {
                    for (ErrorHandler errorHandler : this.errorHandlers) {
                        errorHandler.onError(typeDescription, plugin, throwable);
                    }
                }

                @Override
                public void onError(TypeDescription typeDescription, List<Throwable> throwables) {
                    for (ErrorHandler errorHandler : this.errorHandlers) {
                        errorHandler.onError(typeDescription, throwables);
                    }
                }

                @Override
                public void onError(Map<TypeDescription, List<Throwable>> throwables) {
                    for (ErrorHandler errorHandler : this.errorHandlers) {
                        errorHandler.onError(throwables);
                    }
                }

                @Override
                public void onError(Plugin plugin, Throwable throwable) {
                    for (ErrorHandler errorHandler : this.errorHandlers) {
                        errorHandler.onError(plugin, throwable);
                    }
                }

                @Override
                public void onLiveInitializer(TypeDescription typeDescription, TypeDescription definingType) {
                    for (ErrorHandler errorHandler : this.errorHandlers) {
                        errorHandler.onLiveInitializer(typeDescription, definingType);
                    }
                }

                @Override
                public void onUnresolved(String typeName) {
                    for (ErrorHandler errorHandler : this.errorHandlers) {
                        errorHandler.onUnresolved(typeName);
                    }
                }

                @Override
                public void onManifest(@MaybeNull Manifest manifest) {
                    for (ErrorHandler errorHandler : this.errorHandlers) {
                        errorHandler.onManifest(manifest);
                    }
                }

                @Override
                public void onResource(String name) {
                    for (ErrorHandler errorHandler : this.errorHandlers) {
                        errorHandler.onResource(name);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Enforcing implements ErrorHandler
            {
                ALL_TYPES_RESOLVED{

                    /*
                     * WARNING - void declaration
                     */
                    public final void onUnresolved(String typeName) {
                        void var1_1;
                        throw new IllegalStateException("Failed to resolve type description for " + (String)var1_1);
                    }
                }
                ,
                NO_LIVE_INITIALIZERS{

                    /*
                     * WARNING - void declaration
                     */
                    public final void onLiveInitializer(TypeDescription typeDescription, TypeDescription initializedType) {
                        void var2_2;
                        void var1_1;
                        throw new IllegalStateException("Failed to instrument " + var1_1 + " due to live initializer for " + var2_2);
                    }
                }
                ,
                CLASS_FILES_ONLY{

                    /*
                     * WARNING - void declaration
                     */
                    public final void onResource(String name) {
                        void var1_1;
                        throw new IllegalStateException("Discovered a resource when only class files were allowed: " + (String)var1_1);
                    }
                }
                ,
                MANIFEST_REQUIRED{

                    public final void onManifest(@MaybeNull Manifest manifest) {
                        if (manifest == null) {
                            throw new IllegalStateException("Required a manifest but no manifest was found");
                        }
                    }
                };


                @Override
                public void onError(TypeDescription typeDescription, Plugin plugin, Throwable throwable) {
                }

                @Override
                public void onError(TypeDescription typeDescription, List<Throwable> throwables) {
                }

                @Override
                public void onError(Map<TypeDescription, List<Throwable>> throwables) {
                }

                @Override
                public void onError(Plugin plugin, Throwable throwable) {
                }

                @Override
                public void onLiveInitializer(TypeDescription typeDescription, TypeDescription definingType) {
                }

                @Override
                public void onUnresolved(String typeName) {
                }

                @Override
                public void onManifest(@MaybeNull Manifest manifest) {
                }

                @Override
                public void onResource(String name) {
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Failing implements ErrorHandler
            {
                FAIL_FAST{

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final void onError(TypeDescription typeDescription, Plugin plugin, Throwable throwable) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        throw new IllegalStateException("Failed to transform " + var1_1 + " using " + var2_2, (Throwable)var3_3);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final void onError(TypeDescription typeDescription, List<Throwable> throwables) {
                        void var2_2;
                        void var1_1;
                        throw new IllegalStateException("Failed to transform " + var1_1 + ": " + var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final void onError(Map<TypeDescription, List<Throwable>> throwables) {
                        void var1_1;
                        throw new IllegalStateException("Failed to transform at least one type: " + var1_1);
                    }
                }
                ,
                FAIL_AFTER_TYPE{

                    @Override
                    public final void onError(TypeDescription typeDescription, Plugin plugin, Throwable throwable) {
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final void onError(TypeDescription typeDescription, List<Throwable> throwables) {
                        void var2_2;
                        void var1_1;
                        throw new IllegalStateException("Failed to transform " + var1_1 + ": " + var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final void onError(Map<TypeDescription, List<Throwable>> throwables) {
                        void var1_1;
                        throw new IllegalStateException("Failed to transform at least one type: " + var1_1);
                    }
                }
                ,
                FAIL_LAST{

                    @Override
                    public final void onError(TypeDescription typeDescription, Plugin plugin, Throwable throwable) {
                    }

                    @Override
                    public final void onError(TypeDescription typeDescription, List<Throwable> throwables) {
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final void onError(Map<TypeDescription, List<Throwable>> throwables) {
                        void var1_1;
                        throw new IllegalStateException("Failed to transform at least one type: " + var1_1);
                    }
                };


                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onError(Plugin plugin, Throwable throwable) {
                    void var2_2;
                    void var1_1;
                    throw new IllegalStateException("Failed to close plugin " + var1_1, (Throwable)var2_2);
                }

                @Override
                public void onLiveInitializer(TypeDescription typeDescription, TypeDescription definingType) {
                }

                @Override
                public void onUnresolved(String typeName) {
                }

                @Override
                public void onManifest(Manifest manifest) {
                }

                @Override
                public void onResource(String name) {
                }
            }
        }

        public static interface PoolStrategy {
            public TypePool typePool(ClassFileLocator var1);

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Eager implements PoolStrategy
            {
                FAST(TypePool.Default.ReaderMode.FAST),
                EXTENDED(TypePool.Default.ReaderMode.EXTENDED);

                private final TypePool.Default.ReaderMode readerMode;

                /*
                 * WARNING - void declaration
                 */
                private Eager(TypePool.Default.ReaderMode readerMode) {
                    void var3_3;
                    this.readerMode = var3_3;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final TypePool typePool(ClassFileLocator classFileLocator) {
                    void var1_1;
                    return new TypePool.Default((TypePool.CacheProvider)new TypePool.CacheProvider.Simple(), (ClassFileLocator)var1_1, this.readerMode, TypePool.ClassLoading.ofPlatformLoader());
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Default implements PoolStrategy
            {
                FAST(TypePool.Default.ReaderMode.FAST),
                EXTENDED(TypePool.Default.ReaderMode.EXTENDED);

                private final TypePool.Default.ReaderMode readerMode;

                /*
                 * WARNING - void declaration
                 */
                private Default(TypePool.Default.ReaderMode readerMode) {
                    void var3_3;
                    this.readerMode = var3_3;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final TypePool typePool(ClassFileLocator classFileLocator) {
                    void var1_1;
                    return new TypePool.Default.WithLazyResolution((TypePool.CacheProvider)new TypePool.CacheProvider.Simple(), (ClassFileLocator)var1_1, this.readerMode, TypePool.ClassLoading.ofPlatformLoader());
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface TypeStrategy {
            public DynamicType.Builder<?> builder(ByteBuddy var1, TypeDescription var2, ClassFileLocator var3);

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class ForEntryPoint
            implements TypeStrategy {
                private final EntryPoint entryPoint;
                private final MethodNameTransformer methodNameTransformer;

                /*
                 * WARNING - void declaration
                 */
                public ForEntryPoint(EntryPoint entryPoint, MethodNameTransformer methodNameTransformer) {
                    void var2_2;
                    void var1_1;
                    this.entryPoint = var1_1;
                    this.methodNameTransformer = var2_2;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public DynamicType.Builder<?> builder(ByteBuddy byteBuddy, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
                    void var3_3;
                    void var1_1;
                    void var2_2;
                    return this.entryPoint.transform((TypeDescription)var2_2, (ByteBuddy)var1_1, (ClassFileLocator)var3_3, this.methodNameTransformer);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.entryPoint.equals(((ForEntryPoint)object).entryPoint)) {
                        return false;
                    }
                    return this.methodNameTransformer.equals(((ForEntryPoint)object).methodNameTransformer);
                }

                public int hashCode() {
                    return (this.getClass().hashCode() * 31 + this.entryPoint.hashCode()) * 31 + this.methodNameTransformer.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Default implements TypeStrategy
            {
                REDEFINE{

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final DynamicType.Builder<?> builder(ByteBuddy byteBuddy, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
                        void var3_3;
                        void var2_2;
                        return byteBuddy.redefine((TypeDescription)var2_2, (ClassFileLocator)var3_3);
                    }
                }
                ,
                REBASE{

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final DynamicType.Builder<?> builder(ByteBuddy byteBuddy, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
                        void var3_3;
                        void var2_2;
                        return byteBuddy.rebase((TypeDescription)var2_2, (ClassFileLocator)var3_3);
                    }
                }
                ,
                DECORATE{

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final DynamicType.Builder<?> builder(ByteBuddy byteBuddy, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
                        void var3_3;
                        void var2_2;
                        return byteBuddy.decorate((TypeDescription)var2_2, (ClassFileLocator)var3_3);
                    }
                };

            }
        }
    }

    public static interface Factory {
        public Plugin make();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class UsingReflection
        implements Factory {
            private final Class<? extends Plugin> type;
            private final List<ArgumentResolver> argumentResolvers;

            /*
             * WARNING - void declaration
             */
            public UsingReflection(Class<? extends Plugin> type) {
                this((Class<? extends Plugin>)var1_1, Collections.emptyList());
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            protected UsingReflection(Class<? extends Plugin> type, List<ArgumentResolver> argumentResolvers) {
                void var2_2;
                void var1_1;
                this.type = var1_1;
                this.argumentResolvers = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            public UsingReflection with(ArgumentResolver ... argumentResolver) {
                void var1_1;
                return this.with(Arrays.asList(var1_1));
            }

            /*
             * WARNING - void declaration
             */
            public UsingReflection with(List<? extends ArgumentResolver> argumentResolvers) {
                void var1_1;
                return new UsingReflection(this.type, CompoundList.of(var1_1, this.argumentResolvers));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Plugin make() {
                void var1_1;
                Instantiator instantiator = new Instantiator.Unresolved(this.type);
                block0: for (Constructor<?> constructor : this.type.getConstructors()) {
                    if (constructor.isSynthetic()) continue;
                    ArrayList<Object> arguments = new ArrayList<Object>(constructor.getParameterTypes().length);
                    int index = 0;
                    for (Class<?> type : constructor.getParameterTypes()) {
                        boolean resolved = false;
                        for (ArgumentResolver argumentResolver : this.argumentResolvers) {
                            ArgumentResolver.Resolution resolution = argumentResolver.resolve(index, type);
                            if (!resolution.isResolved()) continue;
                            arguments.add(resolution.getArgument());
                            resolved = true;
                            break;
                        }
                        if (!resolved) continue block0;
                        ++index;
                    }
                    instantiator = instantiator.replaceBy(new Instantiator.Resolved(constructor, arguments));
                }
                return var1_1.instantiate();
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.type.equals(((UsingReflection)object).type)) {
                    return false;
                }
                return ((Object)this.argumentResolvers).equals(((UsingReflection)object).argumentResolvers);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + this.type.hashCode()) * 31 + ((Object)this.argumentResolvers).hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static interface ArgumentResolver {
                public Resolution resolve(int var1, Class<?> var2);

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                public static class ForIndex
                implements ArgumentResolver {
                    private static final Map<Class<?>, Class<?>> WRAPPER_TYPES = new HashMap();
                    private final int index;
                    @MaybeNull
                    @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.REVERSE_NULLABILITY)
                    private final Object value;

                    /*
                     * WARNING - void declaration
                     */
                    public ForIndex(int index, @MaybeNull Object value) {
                        void var2_2;
                        void var1_1;
                        this.index = var1_1;
                        this.value = var2_2;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Resolution resolve(int index, Class<?> type) {
                        void var2_2;
                        void var1_1;
                        if (this.index != var1_1) {
                            return Resolution.Unresolved.INSTANCE;
                        }
                        if (type.isPrimitive()) {
                            if (WRAPPER_TYPES.get(type).isInstance(this.value)) {
                                return new Resolution.Resolved(this.value);
                            }
                            return Resolution.Unresolved.INSTANCE;
                        }
                        if (this.value == null || var2_2.isInstance(this.value)) {
                            return new Resolution.Resolved(this.value);
                        }
                        return Resolution.Unresolved.INSTANCE;
                    }

                    static {
                        WRAPPER_TYPES.put(Boolean.TYPE, Boolean.class);
                        WRAPPER_TYPES.put(Byte.TYPE, Byte.class);
                        WRAPPER_TYPES.put(Short.TYPE, Short.class);
                        WRAPPER_TYPES.put(Character.TYPE, Character.class);
                        WRAPPER_TYPES.put(Integer.TYPE, Integer.class);
                        WRAPPER_TYPES.put(Long.TYPE, Long.class);
                        WRAPPER_TYPES.put(Float.TYPE, Float.class);
                        WRAPPER_TYPES.put(Double.TYPE, Double.class);
                    }

                    public boolean equals(@MaybeNull Object object) {
                        block11: {
                            block10: {
                                Object object2;
                                block9: {
                                    if (this == object) {
                                        return true;
                                    }
                                    if (object == null) {
                                        return false;
                                    }
                                    if (this.getClass() != object.getClass()) {
                                        return false;
                                    }
                                    if (this.index != ((ForIndex)object).index) {
                                        return false;
                                    }
                                    object = ((ForIndex)object).value;
                                    object2 = this.value;
                                    if (object == null) break block9;
                                    if (object2 == null) break block10;
                                    if (!object2.equals(object)) {
                                        return false;
                                    }
                                    break block11;
                                }
                                if (object2 == null) break block11;
                            }
                            return false;
                        }
                        return true;
                    }

                    public int hashCode() {
                        int n = (this.getClass().hashCode() * 31 + this.index) * 31;
                        Object object = this.value;
                        if (object != null) {
                            n = n + object.hashCode();
                        }
                        return n;
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    @HashCodeAndEqualsPlugin.Enhance
                    public static class WithDynamicType
                    implements ArgumentResolver {
                        private final int index;
                        @MaybeNull
                        @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.REVERSE_NULLABILITY)
                        private final String value;

                        /*
                         * WARNING - void declaration
                         */
                        public WithDynamicType(int index, @MaybeNull String value) {
                            void var2_2;
                            void var1_1;
                            this.index = var1_1;
                            this.value = var2_2;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public Resolution resolve(int index, Class<?> type) {
                            if (this.index != index) {
                                return Resolution.Unresolved.INSTANCE;
                            }
                            if (type == Character.TYPE || type == Character.class) {
                                if (this.value != null && this.value.length() == 1) {
                                    return new Resolution.Resolved(Character.valueOf(this.value.charAt(0)));
                                }
                                return Resolution.Unresolved.INSTANCE;
                            }
                            if (type == String.class) {
                                return new Resolution.Resolved(this.value);
                            }
                            if (type.isPrimitive()) {
                                type = (Class)WRAPPER_TYPES.get(type);
                            }
                            try {
                                void var2_5;
                                Method valueOf = type.getMethod("valueOf", String.class);
                                if (Modifier.isStatic(valueOf.getModifiers()) && var2_5.isAssignableFrom(valueOf.getReturnType())) {
                                    return new Resolution.Resolved(valueOf.invoke(null, this.value));
                                }
                                return Resolution.Unresolved.INSTANCE;
                            }
                            catch (IllegalAccessException exception) {
                                throw new IllegalStateException(exception);
                            }
                            catch (InvocationTargetException exception) {
                                void var1_4;
                                throw new IllegalStateException(var1_4.getTargetException());
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                return Resolution.Unresolved.INSTANCE;
                            }
                        }

                        public boolean equals(@MaybeNull Object object) {
                            block11: {
                                block10: {
                                    String string;
                                    block9: {
                                        if (this == object) {
                                            return true;
                                        }
                                        if (object == null) {
                                            return false;
                                        }
                                        if (this.getClass() != object.getClass()) {
                                            return false;
                                        }
                                        if (this.index != ((WithDynamicType)object).index) {
                                            return false;
                                        }
                                        object = ((WithDynamicType)object).value;
                                        string = this.value;
                                        if (object == null) break block9;
                                        if (string == null) break block10;
                                        if (!string.equals(object)) {
                                            return false;
                                        }
                                        break block11;
                                    }
                                    if (string == null) break block11;
                                }
                                return false;
                            }
                            return true;
                        }

                        public int hashCode() {
                            int n = (this.getClass().hashCode() * 31 + this.index) * 31;
                            String string = this.value;
                            if (string != null) {
                                n = n + string.hashCode();
                            }
                            return n;
                        }
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                public static class ForType<T>
                implements ArgumentResolver {
                    private final Class<? extends T> type;
                    private final T value;

                    /*
                     * WARNING - void declaration
                     */
                    protected ForType(Class<? extends T> type, T value) {
                        void var2_2;
                        void var1_1;
                        this.type = var1_1;
                        this.value = var2_2;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public static <S> ArgumentResolver of(Class<? extends S> type, S value) {
                        void var1_1;
                        Class<? extends S> clazz;
                        return new ForType<void>(clazz, var1_1);
                    }

                    @Override
                    public Resolution resolve(int index, Class<?> type) {
                        if (type == this.type) {
                            return new Resolution.Resolved(this.value);
                        }
                        return Resolution.Unresolved.INSTANCE;
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (!this.type.equals(((ForType)object).type)) {
                            return false;
                        }
                        return this.value.equals(((ForType)object).value);
                    }

                    public int hashCode() {
                        return (this.getClass().hashCode() * 31 + this.type.hashCode()) * 31 + this.value.hashCode();
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static enum NoOp implements ArgumentResolver
                {
                    INSTANCE;


                    @Override
                    public final Resolution resolve(int index, Class<?> type) {
                        return Resolution.Unresolved.INSTANCE;
                    }
                }

                public static interface Resolution {
                    public boolean isResolved();

                    @MaybeNull
                    public Object getArgument();

                    @HashCodeAndEqualsPlugin.Enhance
                    public static class Resolved
                    implements Resolution {
                        @MaybeNull
                        @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.REVERSE_NULLABILITY)
                        private final Object argument;

                        /*
                         * WARNING - void declaration
                         */
                        public Resolved(@MaybeNull Object argument) {
                            void var1_1;
                            this.argument = var1_1;
                        }

                        public boolean isResolved() {
                            return true;
                        }

                        @MaybeNull
                        public Object getArgument() {
                            return this.argument;
                        }

                        public boolean equals(@MaybeNull Object object) {
                            block10: {
                                block9: {
                                    Object object2;
                                    block8: {
                                        if (this == object) {
                                            return true;
                                        }
                                        if (object == null) {
                                            return false;
                                        }
                                        if (this.getClass() != object.getClass()) {
                                            return false;
                                        }
                                        object = ((Resolved)object).argument;
                                        object2 = this.argument;
                                        if (object == null) break block8;
                                        if (object2 == null) break block9;
                                        if (!object2.equals(object)) {
                                            return false;
                                        }
                                        break block10;
                                    }
                                    if (object2 == null) break block10;
                                }
                                return false;
                            }
                            return true;
                        }

                        public int hashCode() {
                            int n = this.getClass().hashCode() * 31;
                            Object object = this.argument;
                            if (object != null) {
                                n = n + object.hashCode();
                            }
                            return n;
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public static enum Unresolved implements Resolution
                    {
                        INSTANCE;


                        @Override
                        public final boolean isResolved() {
                            return false;
                        }

                        @Override
                        public final Object getArgument() {
                            throw new IllegalStateException("Cannot get the argument for an unresolved parameter");
                        }
                    }
                }
            }

            @Documented
            @Target(value={ElementType.CONSTRUCTOR})
            @Retention(value=RetentionPolicy.RUNTIME)
            public static @interface Priority {
                public static final int DEFAULT = 0;

                public int value();
            }

            protected static interface Instantiator {
                public Instantiator replaceBy(Resolved var1);

                public Plugin instantiate();

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                public static class Resolved
                implements Instantiator {
                    private final Constructor<? extends Plugin> constructor;
                    private final List<?> arguments;

                    /*
                     * WARNING - void declaration
                     */
                    protected Resolved(Constructor<? extends Plugin> constructor, List<?> arguments) {
                        void var2_2;
                        void var1_1;
                        this.constructor = var1_1;
                        this.arguments = var2_2;
                    }

                    protected Constructor<? extends Plugin> getConstructor() {
                        return this.constructor;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Instantiator replaceBy(Resolved instantiator) {
                        void var2_3;
                        void var1_1;
                        void var3_5;
                        int rightPriority;
                        Priority left = this.constructor.getAnnotation(Priority.class);
                        Priority right = instantiator.getConstructor().getAnnotation(Priority.class);
                        int leftPriority = left == null ? 0 : left.value();
                        int n = rightPriority = right == null ? 0 : right.value();
                        if (leftPriority > rightPriority) {
                            return this;
                        }
                        if (leftPriority < var3_5) {
                            return instantiator;
                        }
                        if (this.constructor.getParameterTypes().length > instantiator.getConstructor().getParameterTypes().length) {
                            return this;
                        }
                        if (this.constructor.getParameterTypes().length < instantiator.getConstructor().getParameterTypes().length) {
                            return instantiator;
                        }
                        return new Ambiguous(this.constructor, var1_1.getConstructor(), (int)var2_3, this.constructor.getParameterTypes().length);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Plugin instantiate() {
                        try {
                            return this.constructor.newInstance(this.arguments.toArray(new Object[0]));
                        }
                        catch (InstantiationException exception) {
                            throw new IllegalStateException("Failed to instantiate plugin via " + this.constructor, exception);
                        }
                        catch (IllegalAccessException exception) {
                            throw new IllegalStateException("Failed to access " + this.constructor, exception);
                        }
                        catch (InvocationTargetException exception) {
                            void var1_3;
                            throw new IllegalStateException("Error during construction of" + this.constructor, var1_3.getTargetException());
                        }
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (!this.constructor.equals(((Resolved)object).constructor)) {
                            return false;
                        }
                        return ((Object)this.arguments).equals(((Resolved)object).arguments);
                    }

                    public int hashCode() {
                        return (this.getClass().hashCode() * 31 + this.constructor.hashCode()) * 31 + ((Object)this.arguments).hashCode();
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                public static class Ambiguous
                implements Instantiator {
                    private final Constructor<?> left;
                    private final Constructor<?> right;
                    private final int priority;
                    private final int parameters;

                    /*
                     * WARNING - void declaration
                     */
                    protected Ambiguous(Constructor<?> left, Constructor<?> right, int priority, int parameters) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.left = var1_1;
                        this.right = var2_2;
                        this.priority = var3_3;
                        this.parameters = parameters;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Instantiator replaceBy(Resolved instantiator) {
                        void var2_2;
                        Priority priority = instantiator.getConstructor().getAnnotation(Priority.class);
                        if ((priority == null ? 0 : priority.value()) > this.priority) {
                            return instantiator;
                        }
                        if ((priority == null ? 0 : var2_2.value()) < this.priority) {
                            return this;
                        }
                        if (instantiator.getConstructor().getParameterTypes().length > this.parameters) {
                            void var1_1;
                            return var1_1;
                        }
                        return this;
                    }

                    @Override
                    public Plugin instantiate() {
                        throw new IllegalStateException("Ambiguous constructors " + this.left + " and " + this.right);
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (this.priority != ((Ambiguous)object).priority) {
                            return false;
                        }
                        if (this.parameters != ((Ambiguous)object).parameters) {
                            return false;
                        }
                        if (!this.left.equals(((Ambiguous)object).left)) {
                            return false;
                        }
                        return this.right.equals(((Ambiguous)object).right);
                    }

                    public int hashCode() {
                        return (((this.getClass().hashCode() * 31 + this.left.hashCode()) * 31 + this.right.hashCode()) * 31 + this.priority) * 31 + this.parameters;
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                public static class Unresolved
                implements Instantiator {
                    private final Class<? extends Plugin> type;

                    /*
                     * WARNING - void declaration
                     */
                    protected Unresolved(Class<? extends Plugin> type) {
                        void var1_1;
                        this.type = var1_1;
                    }

                    @Override
                    public Instantiator replaceBy(Resolved instantiator) {
                        return instantiator;
                    }

                    @Override
                    public Plugin instantiate() {
                        throw new IllegalStateException("No constructor resolvable for " + this.type);
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        return this.type.equals(((Unresolved)object).type);
                    }

                    public int hashCode() {
                        return this.getClass().hashCode() * 31 + this.type.hashCode();
                    }
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class Simple
        implements Factory {
            private final Plugin plugin;

            /*
             * WARNING - void declaration
             */
            public Simple(Plugin plugin) {
                void var1_1;
                this.plugin = var1_1;
            }

            public Plugin make() {
                return this.plugin;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.plugin.equals(((Simple)object).plugin);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.plugin.hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface WithInitialization
    extends Plugin {
        public Map<TypeDescription, byte[]> initialize(ClassFileLocator var1);
    }

    public static interface WithPreprocessor
    extends Plugin {
        public void onPreprocess(TypeDescription var1, ClassFileLocator var2);
    }
}

