/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.asm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.jar.asm.AnnotationVisitor;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.ConstantDynamic;
import net.bytebuddy.jar.asm.FieldVisitor;
import net.bytebuddy.jar.asm.Handle;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.RecordComponentVisitor;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.jar.asm.TypePath;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.OpenedClassReader;
import net.bytebuddy.utility.nullability.AlwaysNull;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class TypeReferenceAdjustment
extends AsmVisitorWrapper.AbstractBase {
    private final boolean strict;
    private final ElementMatcher.Junction<? super TypeDescription> filter;

    /*
     * WARNING - void declaration
     */
    protected TypeReferenceAdjustment(boolean strict, ElementMatcher.Junction<? super TypeDescription> filter) {
        void var2_2;
        void var1_1;
        this.strict = var1_1;
        this.filter = var2_2;
    }

    public static TypeReferenceAdjustment strict() {
        return new TypeReferenceAdjustment(true, ElementMatchers.none());
    }

    public static TypeReferenceAdjustment relaxed() {
        return new TypeReferenceAdjustment(false, ElementMatchers.none());
    }

    /*
     * WARNING - void declaration
     */
    public TypeReferenceAdjustment filter(ElementMatcher<? super TypeDescription> filter) {
        void var1_1;
        return new TypeReferenceAdjustment(this.strict, this.filter.or(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
        void var2_2;
        return new TypeReferenceClassVisitor((ClassVisitor)var2_2, this.strict, this.filter, typePool);
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (this.strict != ((TypeReferenceAdjustment)object).strict) {
            return false;
        }
        return this.filter.equals(((TypeReferenceAdjustment)object).filter);
    }

    public int hashCode() {
        return (this.getClass().hashCode() * 31 + this.strict) * 31 + this.filter.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TypeReferenceClassVisitor
    extends ClassVisitor {
        @AlwaysNull
        private static final AnnotationVisitor IGNORE_ANNOTATION = null;
        @AlwaysNull
        private static final FieldVisitor IGNORE_FIELD = null;
        @AlwaysNull
        private static final MethodVisitor IGNORE_METHOD = null;
        private final boolean strict;
        private final ElementMatcher<? super TypeDescription> filter;
        private final TypePool typePool;
        private final Set<String> observedTypes;
        private final Set<String> visitedInnerTypes;

        /*
         * WARNING - void declaration
         */
        protected TypeReferenceClassVisitor(ClassVisitor classVisitor, boolean strict, ElementMatcher<? super TypeDescription> filter, TypePool typePool) {
            super(OpenedClassReader.ASM_API, (ClassVisitor)var1_1);
            void var3_3;
            void var2_2;
            void var1_1;
            this.typePool = typePool;
            this.strict = var2_2;
            this.filter = var3_3;
            this.observedTypes = new HashSet<String>();
            this.visitedInnerTypes = new HashSet<String>();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visit(int version, int modifiers, String internalName, @MaybeNull String genericSignature, @MaybeNull String superClassInternalName, @MaybeNull String[] interfaceInternalName) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (superClassInternalName != null) {
                this.observedTypes.add(superClassInternalName);
            }
            if (interfaceInternalName != null) {
                this.observedTypes.addAll(Arrays.asList(interfaceInternalName));
            }
            super.visit((int)var1_1, (int)var2_2, (String)var3_3, genericSignature, superClassInternalName, interfaceInternalName);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitNestHost(String nestHost) {
            void var1_1;
            this.observedTypes.add(nestHost);
            super.visitNestHost((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitOuterClass(String ownerTypeInternalName, String methodName, String methodDescriptor) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.observedTypes.add(ownerTypeInternalName);
            super.visitOuterClass((String)var1_1, (String)var2_2, (String)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitNestMember(String nestMember) {
            void var1_1;
            this.observedTypes.add(nestMember);
            super.visitNestMember((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitInnerClass(String internalName, String outerName, String innerName, int modifiers) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.visitedInnerTypes.add(internalName);
            super.visitInnerClass((String)var1_1, (String)var2_2, (String)var3_3, modifiers);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @MaybeNull
        public RecordComponentVisitor visitRecordComponent(String name, String descriptor, @MaybeNull String signature) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.observedTypes.add(Type.getType(descriptor).getInternalName());
            return super.visitRecordComponent((String)var1_1, (String)var2_2, (String)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @MaybeNull
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            void var2_2;
            this.observedTypes.add(Type.getType(descriptor).getInternalName());
            AnnotationVisitor annotationVisitor = super.visitAnnotation(descriptor, (boolean)var2_2);
            if (annotationVisitor != null) {
                void var1_1;
                return new TypeReferenceAnnotationVisitor(this, (AnnotationVisitor)var1_1);
            }
            return IGNORE_ANNOTATION;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @MaybeNull
        public AnnotationVisitor visitTypeAnnotation(int typeReference, @MaybeNull TypePath typePath, String descriptor, boolean visible) {
            void var3_4;
            void var2_3;
            this.observedTypes.add(Type.getType(descriptor).getInternalName());
            AnnotationVisitor annotationVisitor = super.visitTypeAnnotation(typeReference, (TypePath)var2_3, (String)var3_4, visible);
            if (annotationVisitor != null) {
                void var1_2;
                return new TypeReferenceAnnotationVisitor(this, (AnnotationVisitor)var1_2);
            }
            return IGNORE_ANNOTATION;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @MaybeNull
        public FieldVisitor visitField(int modifiers, String name, String descriptor, @MaybeNull String signature, @MaybeNull Object value) {
            void var2_3;
            FieldVisitor fieldVisitor = super.visitField(modifiers, (String)var2_3, descriptor, signature, value);
            if (fieldVisitor != null) {
                void var1_2;
                void var3_4;
                this.resolve(Type.getType((String)var3_4));
                return new TypeReferenceFieldVisitor(this, (FieldVisitor)var1_2);
            }
            return IGNORE_FIELD;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @MaybeNull
        public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, @MaybeNull String signature, @MaybeNull String[] exceptionInternalName) {
            void var2_3;
            MethodVisitor methodVisitor = super.visitMethod(modifiers, (String)var2_3, descriptor, signature, exceptionInternalName);
            if (methodVisitor != null) {
                void var1_2;
                void var3_4;
                this.resolve(Type.getType((String)var3_4));
                if (exceptionInternalName != null) {
                    this.observedTypes.addAll(Arrays.asList(exceptionInternalName));
                }
                return new TypeReferenceMethodVisitor(this, (MethodVisitor)var1_2);
            }
            return IGNORE_METHOD;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming declaring type for type member.")
        public void visitEnd() {
            block2: for (String observedType : this.observedTypes) {
                void var2_2;
                if (!this.visitedInnerTypes.add(observedType)) continue;
                TypePool.Resolution resolution = this.typePool.describe(observedType.replace('/', '.'));
                if (resolution.isResolved()) {
                    void var3_4;
                    TypeDescription typeDescription = var3_4.resolve();
                    if (this.filter.matches(typeDescription)) continue;
                    while (typeDescription != null && typeDescription.isNestedClass()) {
                        super.visitInnerClass(typeDescription.getInternalName(), typeDescription.isMemberType() ? typeDescription.getDeclaringType().getInternalName() : null, typeDescription.isAnonymousType() ? null : typeDescription.getSimpleName(), typeDescription.getModifiers());
                        try {
                            while ((typeDescription = typeDescription.getEnclosingType()) != null && !this.visitedInnerTypes.add(typeDescription.getInternalName())) {
                            }
                        }
                        catch (RuntimeException exception) {
                            void var2_3;
                            if (!this.strict) continue block2;
                            throw var2_3;
                        }
                    }
                    continue;
                }
                if (!this.strict) continue;
                throw new IllegalStateException("Could not locate type for: " + var2_2.replace('/', '.'));
            }
            super.visitEnd();
        }

        /*
         * WARNING - void declaration
         */
        protected void resolve(Type type) {
            if (type.getSort() == 11) {
                this.resolve(type.getReturnType());
                for (Type argumentType : type.getArgumentTypes()) {
                    this.resolve(argumentType);
                }
                return;
            }
            while (type.getSort() == 9) {
                type = type.getElementType();
            }
            if (type.getSort() == 10) {
                void var1_1;
                this.observedTypes.add(var1_1.getInternalName());
            }
        }

        protected void resolve(Handle handle) {
            Type[] typeArray;
            this.observedTypes.add(handle.getOwner());
            Type methodType = Type.getType(handle.getDesc());
            this.resolve(methodType.getReturnType());
            for (Type type : typeArray.getArgumentTypes()) {
                this.resolve(type);
            }
        }

        protected void resolve(ConstantDynamic constant) {
            Type[] methodType = Type.getType(constant.getDescriptor());
            this.resolve(methodType.getReturnType());
            for (Type type : methodType.getArgumentTypes()) {
                this.resolve(type);
            }
            this.resolve(constant.getBootstrapMethod());
            for (int index = 0; index < constant.getBootstrapMethodArgumentCount(); ++index) {
                this.resolve(constant.getBootstrapMethodArgument(index));
            }
        }

        /*
         * WARNING - void declaration
         */
        private void observeInternalName(String internalName) {
            void var1_1;
            int index = internalName.lastIndexOf(91);
            if (index != -1) {
                void var2_2;
                internalName = internalName.substring((int)(var2_2 + 2), internalName.length() - 1);
            }
            this.observedTypes.add((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        protected void resolve(Object value) {
            if (value instanceof Type) {
                this.resolve((Type)value);
                return;
            }
            if (value instanceof Handle) {
                this.resolve((Handle)value);
                return;
            }
            if (value instanceof ConstantDynamic) {
                void var1_1;
                this.resolve((ConstantDynamic)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$200(TypeReferenceClassVisitor x0, String x1) {
            void var1_1;
            x0.observeInternalName((String)var1_1);
        }

        protected class TypeReferenceMethodVisitor
        extends MethodVisitor {
            final /* synthetic */ TypeReferenceClassVisitor this$0;

            /*
             * WARNING - void declaration
             */
            protected TypeReferenceMethodVisitor(TypeReferenceClassVisitor this$0, MethodVisitor methodVisitor) {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super(OpenedClassReader.ASM_API, (MethodVisitor)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @MaybeNull
            public AnnotationVisitor visitAnnotationDefault() {
                AnnotationVisitor annotationVisitor = super.visitAnnotationDefault();
                if (annotationVisitor != null) {
                    void var1_1;
                    return new TypeReferenceAnnotationVisitor(this.this$0, (AnnotationVisitor)var1_1);
                }
                return IGNORE_ANNOTATION;
            }

            /*
             * WARNING - void declaration
             */
            @MaybeNull
            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                void var2_2;
                this.this$0.observedTypes.add(Type.getType(descriptor).getInternalName());
                AnnotationVisitor annotationVisitor = super.visitAnnotation(descriptor, (boolean)var2_2);
                if (annotationVisitor != null) {
                    void var1_1;
                    return new TypeReferenceAnnotationVisitor(this.this$0, (AnnotationVisitor)var1_1);
                }
                return IGNORE_ANNOTATION;
            }

            /*
             * WARNING - void declaration
             */
            @MaybeNull
            public AnnotationVisitor visitTypeAnnotation(int typeReference, @MaybeNull TypePath typePath, String descriptor, boolean visible) {
                void var3_4;
                void var2_3;
                this.this$0.observedTypes.add(Type.getType(descriptor).getInternalName());
                AnnotationVisitor annotationVisitor = super.visitTypeAnnotation(typeReference, (TypePath)var2_3, (String)var3_4, visible);
                if (annotationVisitor != null) {
                    void var1_2;
                    return new TypeReferenceAnnotationVisitor(this.this$0, (AnnotationVisitor)var1_2);
                }
                return IGNORE_ANNOTATION;
            }

            /*
             * WARNING - void declaration
             */
            @MaybeNull
            public AnnotationVisitor visitParameterAnnotation(int index, String descriptor, boolean visible) {
                void var3_4;
                void var2_3;
                this.this$0.observedTypes.add(Type.getType(descriptor).getInternalName());
                AnnotationVisitor annotationVisitor = super.visitParameterAnnotation(index, (String)var2_3, (boolean)var3_4);
                if (annotationVisitor != null) {
                    void var1_2;
                    return new TypeReferenceAnnotationVisitor(this.this$0, (AnnotationVisitor)var1_2);
                }
                return IGNORE_ANNOTATION;
            }

            /*
             * WARNING - void declaration
             */
            @MaybeNull
            public AnnotationVisitor visitInsnAnnotation(int typeReference, @MaybeNull TypePath typePath, String descriptor, boolean visible) {
                void var3_4;
                void var2_3;
                this.this$0.observedTypes.add(Type.getType(descriptor).getInternalName());
                AnnotationVisitor annotationVisitor = super.visitInsnAnnotation(typeReference, (TypePath)var2_3, (String)var3_4, visible);
                if (annotationVisitor != null) {
                    void var1_2;
                    return new TypeReferenceAnnotationVisitor(this.this$0, (AnnotationVisitor)var1_2);
                }
                return IGNORE_ANNOTATION;
            }

            /*
             * WARNING - void declaration
             */
            @MaybeNull
            public AnnotationVisitor visitTryCatchAnnotation(int typeReference, @MaybeNull TypePath typePath, String descriptor, boolean visible) {
                void var3_4;
                void var2_3;
                this.this$0.observedTypes.add(Type.getType(descriptor).getInternalName());
                AnnotationVisitor annotationVisitor = super.visitTryCatchAnnotation(typeReference, (TypePath)var2_3, (String)var3_4, visible);
                if (annotationVisitor != null) {
                    void var1_2;
                    return new TypeReferenceAnnotationVisitor(this.this$0, (AnnotationVisitor)var1_2);
                }
                return IGNORE_ANNOTATION;
            }

            /*
             * WARNING - void declaration
             */
            @MaybeNull
            public AnnotationVisitor visitLocalVariableAnnotation(int typeReference, @MaybeNull TypePath typePath, Label[] start, Label[] end, int[] offset, String descriptor, boolean visible) {
                void var3_4;
                void var2_3;
                this.this$0.observedTypes.add(Type.getType(descriptor).getInternalName());
                AnnotationVisitor annotationVisitor = super.visitLocalVariableAnnotation(typeReference, (TypePath)var2_3, (Label[])var3_4, end, offset, descriptor, visible);
                if (annotationVisitor != null) {
                    void var1_2;
                    return new TypeReferenceAnnotationVisitor(this.this$0, (AnnotationVisitor)var1_2);
                }
                return IGNORE_ANNOTATION;
            }

            /*
             * WARNING - void declaration
             */
            public void visitTypeInsn(int opcode, String internalName) {
                void var2_2;
                void var1_1;
                TypeReferenceClassVisitor.access$200(this.this$0, internalName);
                super.visitTypeInsn((int)var1_1, (String)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public void visitFieldInsn(int opcode, String ownerInternalName, String name, String descriptor) {
                void var3_3;
                void var2_2;
                void var1_1;
                TypeReferenceClassVisitor.access$200(this.this$0, ownerInternalName);
                this.this$0.resolve(Type.getType(descriptor));
                super.visitFieldInsn((int)var1_1, (String)var2_2, (String)var3_3, descriptor);
            }

            /*
             * WARNING - void declaration
             */
            public void visitMethodInsn(int opcode, String ownerInternalName, String name, String descriptor, boolean isInterface) {
                void var3_3;
                void var2_2;
                void var1_1;
                TypeReferenceClassVisitor.access$200(this.this$0, ownerInternalName);
                this.this$0.resolve(Type.getType(descriptor));
                super.visitMethodInsn((int)var1_1, (String)var2_2, (String)var3_3, descriptor, isInterface);
            }

            /*
             * WARNING - void declaration
             */
            public void visitInvokeDynamicInsn(String name, String descriptor, Handle handle, Object ... argument) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0.resolve(Type.getType(descriptor));
                this.this$0.resolve(handle);
                Object[] objectArray = argument;
                int n = argument.length;
                for (int i = 0; i < n; ++i) {
                    Object anArgument = objectArray[i];
                    this.this$0.resolve(anArgument);
                }
                super.visitInvokeDynamicInsn((String)var1_1, (String)var2_2, (Handle)var3_3, argument);
            }

            /*
             * WARNING - void declaration
             */
            public void visitLdcInsn(Object value) {
                void var1_1;
                this.this$0.resolve(value);
                super.visitLdcInsn(var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void visitMultiANewArrayInsn(String descriptor, int dimension) {
                void var2_2;
                void var1_1;
                this.this$0.resolve(Type.getType(descriptor));
                super.visitMultiANewArrayInsn((String)var1_1, (int)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public void visitTryCatchBlock(Label start, Label end, Label handler, @MaybeNull String typeInternalName) {
                void var3_3;
                void var2_2;
                void var1_1;
                if (typeInternalName != null) {
                    this.this$0.observedTypes.add(typeInternalName);
                }
                super.visitTryCatchBlock((Label)var1_1, (Label)var2_2, (Label)var3_3, typeInternalName);
            }
        }

        protected class TypeReferenceFieldVisitor
        extends FieldVisitor {
            final /* synthetic */ TypeReferenceClassVisitor this$0;

            /*
             * WARNING - void declaration
             */
            protected TypeReferenceFieldVisitor(TypeReferenceClassVisitor this$0, FieldVisitor fieldVisitor) {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super(OpenedClassReader.ASM_API, (FieldVisitor)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @MaybeNull
            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                void var2_2;
                this.this$0.observedTypes.add(Type.getType(descriptor).getInternalName());
                AnnotationVisitor annotationVisitor = super.visitAnnotation(descriptor, (boolean)var2_2);
                if (annotationVisitor != null) {
                    void var1_1;
                    return new TypeReferenceAnnotationVisitor(this.this$0, (AnnotationVisitor)var1_1);
                }
                return IGNORE_ANNOTATION;
            }
        }

        protected class TypeReferenceAnnotationVisitor
        extends AnnotationVisitor {
            final /* synthetic */ TypeReferenceClassVisitor this$0;

            /*
             * WARNING - void declaration
             */
            protected TypeReferenceAnnotationVisitor(TypeReferenceClassVisitor this$0, AnnotationVisitor annotationVisitor) {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super(OpenedClassReader.ASM_API, (AnnotationVisitor)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public void visit(String name, Object value) {
                void var2_2;
                void var1_1;
                this.this$0.resolve(value);
                super.visit((String)var1_1, var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public void visitEnum(String name, String descriptor, String value) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0.observedTypes.add(Type.getType(descriptor).getInternalName());
                super.visitEnum((String)var1_1, (String)var2_2, (String)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @MaybeNull
            public AnnotationVisitor visitAnnotation(String name, String descriptor) {
                void var2_2;
                this.this$0.observedTypes.add(Type.getType(descriptor).getInternalName());
                AnnotationVisitor annotationVisitor = super.visitAnnotation(name, (String)var2_2);
                if (annotationVisitor != null) {
                    void var1_1;
                    return new TypeReferenceAnnotationVisitor(this.this$0, (AnnotationVisitor)var1_1);
                }
                return IGNORE_ANNOTATION;
            }

            /*
             * WARNING - void declaration
             */
            @MaybeNull
            public AnnotationVisitor visitArray(String name) {
                AnnotationVisitor annotationVisitor = super.visitArray(name);
                if (annotationVisitor != null) {
                    void var1_1;
                    return new TypeReferenceAnnotationVisitor(this.this$0, (AnnotationVisitor)var1_1);
                }
                return IGNORE_ANNOTATION;
            }
        }
    }
}

