/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.asm;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.FieldVisitor;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.CompoundList;
import net.bytebuddy.utility.OpenedClassReader;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class ModifierAdjustment
extends AsmVisitorWrapper.AbstractBase {
    private final List<Adjustment<TypeDescription>> typeAdjustments;
    private final List<Adjustment<FieldDescription.InDefinedShape>> fieldAdjustments;
    private final List<Adjustment<MethodDescription>> methodAdjustments;

    public ModifierAdjustment() {
        this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    protected ModifierAdjustment(List<Adjustment<TypeDescription>> typeAdjustments, List<Adjustment<FieldDescription.InDefinedShape>> fieldAdjustments, List<Adjustment<MethodDescription>> methodAdjustments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.typeAdjustments = var1_1;
        this.fieldAdjustments = var2_2;
        this.methodAdjustments = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public ModifierAdjustment withTypeModifiers(ModifierContributor.ForType ... modifierContributor) {
        void var1_1;
        return this.withTypeModifiers(Arrays.asList(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public ModifierAdjustment withTypeModifiers(List<? extends ModifierContributor.ForType> modifierContributors) {
        void var1_1;
        return this.withTypeModifiers(ElementMatchers.any(), (List<? extends ModifierContributor.ForType>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ModifierAdjustment withTypeModifiers(ElementMatcher<? super TypeDescription> matcher, ModifierContributor.ForType ... modifierContributor) {
        void var2_2;
        void var1_1;
        return this.withTypeModifiers((ElementMatcher<? super TypeDescription>)var1_1, Arrays.asList(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public ModifierAdjustment withTypeModifiers(ElementMatcher<? super TypeDescription> matcher, List<? extends ModifierContributor.ForType> modifierContributors) {
        void var2_2;
        void var1_1;
        return new ModifierAdjustment(CompoundList.of(new Adjustment(var1_1, ModifierContributor.Resolver.of(var2_2)), this.typeAdjustments), this.fieldAdjustments, this.methodAdjustments);
    }

    /*
     * WARNING - void declaration
     */
    public ModifierAdjustment withFieldModifiers(ModifierContributor.ForField ... modifierContributor) {
        void var1_1;
        return this.withFieldModifiers(Arrays.asList(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public ModifierAdjustment withFieldModifiers(List<? extends ModifierContributor.ForField> modifierContributors) {
        void var1_1;
        return this.withFieldModifiers(ElementMatchers.any(), (List<? extends ModifierContributor.ForField>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ModifierAdjustment withFieldModifiers(ElementMatcher<? super FieldDescription.InDefinedShape> matcher, ModifierContributor.ForField ... modifierContributor) {
        void var2_2;
        void var1_1;
        return this.withFieldModifiers((ElementMatcher<? super FieldDescription.InDefinedShape>)var1_1, Arrays.asList(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public ModifierAdjustment withFieldModifiers(ElementMatcher<? super FieldDescription.InDefinedShape> matcher, List<? extends ModifierContributor.ForField> modifierContributors) {
        void var2_2;
        void var1_1;
        return new ModifierAdjustment(this.typeAdjustments, CompoundList.of(new Adjustment(var1_1, ModifierContributor.Resolver.of(var2_2)), this.fieldAdjustments), this.methodAdjustments);
    }

    /*
     * WARNING - void declaration
     */
    public ModifierAdjustment withMethodModifiers(ModifierContributor.ForMethod ... modifierContributor) {
        void var1_1;
        return this.withMethodModifiers(Arrays.asList(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public ModifierAdjustment withMethodModifiers(List<? extends ModifierContributor.ForMethod> modifierContributors) {
        void var1_1;
        return this.withMethodModifiers(ElementMatchers.any(), (List<? extends ModifierContributor.ForMethod>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ModifierAdjustment withMethodModifiers(ElementMatcher<? super MethodDescription> matcher, ModifierContributor.ForMethod ... modifierContributor) {
        void var2_2;
        void var1_1;
        return this.withMethodModifiers((ElementMatcher<? super MethodDescription>)var1_1, Arrays.asList(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public ModifierAdjustment withMethodModifiers(ElementMatcher<? super MethodDescription> matcher, List<? extends ModifierContributor.ForMethod> modifierContributors) {
        void var2_2;
        void var1_1;
        return this.withInvokableModifiers(ElementMatchers.isMethod().and(var1_1), (List<? extends ModifierContributor.ForMethod>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ModifierAdjustment withConstructorModifiers(ModifierContributor.ForMethod ... modifierContributor) {
        void var1_1;
        return this.withConstructorModifiers(Arrays.asList(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public ModifierAdjustment withConstructorModifiers(List<? extends ModifierContributor.ForMethod> modifierContributors) {
        void var1_1;
        return this.withConstructorModifiers(ElementMatchers.any(), (List<? extends ModifierContributor.ForMethod>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ModifierAdjustment withConstructorModifiers(ElementMatcher<? super MethodDescription> matcher, ModifierContributor.ForMethod ... modifierContributor) {
        void var2_2;
        void var1_1;
        return this.withConstructorModifiers((ElementMatcher<? super MethodDescription>)var1_1, Arrays.asList(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public ModifierAdjustment withConstructorModifiers(ElementMatcher<? super MethodDescription> matcher, List<? extends ModifierContributor.ForMethod> modifierContributors) {
        void var2_2;
        void var1_1;
        return this.withInvokableModifiers(ElementMatchers.isConstructor().and(var1_1), (List<? extends ModifierContributor.ForMethod>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ModifierAdjustment withInvokableModifiers(ModifierContributor.ForMethod ... modifierContributor) {
        void var1_1;
        return this.withInvokableModifiers(Arrays.asList(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public ModifierAdjustment withInvokableModifiers(List<? extends ModifierContributor.ForMethod> modifierContributors) {
        void var1_1;
        return this.withInvokableModifiers(ElementMatchers.any(), (List<? extends ModifierContributor.ForMethod>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ModifierAdjustment withInvokableModifiers(ElementMatcher<? super MethodDescription> matcher, ModifierContributor.ForMethod ... modifierContributor) {
        void var2_2;
        void var1_1;
        return this.withInvokableModifiers((ElementMatcher<? super MethodDescription>)var1_1, Arrays.asList(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public ModifierAdjustment withInvokableModifiers(ElementMatcher<? super MethodDescription> matcher, List<? extends ModifierContributor.ForMethod> modifierContributors) {
        void var2_2;
        void var1_1;
        return new ModifierAdjustment(this.typeAdjustments, this.fieldAdjustments, CompoundList.of(new Adjustment(var1_1, ModifierContributor.Resolver.of(var2_2)), this.methodAdjustments));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ModifierAdjustingClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
        void var3_3;
        void var1_1;
        void var2_2;
        HashMap<String, FieldDescription.InDefinedShape> mappedFields = new HashMap<String, FieldDescription.InDefinedShape>();
        for (FieldDescription.InDefinedShape fieldDescription : fields) {
            mappedFields.put(fieldDescription.getInternalName() + fieldDescription.getDescriptor(), fieldDescription);
        }
        HashMap<String, MethodDescription> mappedMethods = new HashMap<String, MethodDescription>();
        for (MethodDescription methodDescription : CompoundList.of(methods, new MethodDescription.Latent.TypeInitializer(instrumentedType))) {
            mappedMethods.put(methodDescription.getInternalName() + methodDescription.getDescriptor(), methodDescription);
        }
        return new ModifierAdjustingClassVisitor((ClassVisitor)var2_2, this.typeAdjustments, this.fieldAdjustments, this.methodAdjustments, (TypeDescription)var1_1, (Map<String, FieldDescription.InDefinedShape>)var3_3, mappedMethods);
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!((Object)this.typeAdjustments).equals(((ModifierAdjustment)object).typeAdjustments)) {
            return false;
        }
        if (!((Object)this.fieldAdjustments).equals(((ModifierAdjustment)object).fieldAdjustments)) {
            return false;
        }
        return ((Object)this.methodAdjustments).equals(((ModifierAdjustment)object).methodAdjustments);
    }

    public int hashCode() {
        return ((this.getClass().hashCode() * 31 + ((Object)this.typeAdjustments).hashCode()) * 31 + ((Object)this.fieldAdjustments).hashCode()) * 31 + ((Object)this.methodAdjustments).hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ModifierAdjustingClassVisitor
    extends ClassVisitor {
        private final List<Adjustment<TypeDescription>> typeAdjustments;
        private final List<Adjustment<FieldDescription.InDefinedShape>> fieldAdjustments;
        private final List<Adjustment<MethodDescription>> methodAdjustments;
        private final TypeDescription instrumentedType;
        private final Map<String, FieldDescription.InDefinedShape> fields;
        private final Map<String, MethodDescription> methods;

        /*
         * WARNING - void declaration
         */
        protected ModifierAdjustingClassVisitor(ClassVisitor classVisitor, List<Adjustment<TypeDescription>> typeAdjustments, List<Adjustment<FieldDescription.InDefinedShape>> fieldAdjustments, List<Adjustment<MethodDescription>> methodAdjustments, TypeDescription instrumentedType, Map<String, FieldDescription.InDefinedShape> fields, Map<String, MethodDescription> methods) {
            super(OpenedClassReader.ASM_API, (ClassVisitor)var1_1);
            void var3_3;
            void var2_2;
            void var1_1;
            this.typeAdjustments = var2_2;
            this.fieldAdjustments = var3_3;
            this.methodAdjustments = methodAdjustments;
            this.instrumentedType = instrumentedType;
            this.fields = fields;
            this.methods = methods;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visit(int version, int modifiers, String internalName, @MaybeNull String signature, @MaybeNull String superClassName, @MaybeNull String[] interfaceName) {
            void var3_3;
            void var2_2;
            void var1_1;
            for (Adjustment<TypeDescription> adjustment : this.typeAdjustments) {
                if (!adjustment.matches(this.instrumentedType)) continue;
                modifiers = adjustment.resolve(modifiers);
                break;
            }
            super.visit((int)var1_1, (int)var2_2, (String)var3_3, signature, superClassName, interfaceName);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitInnerClass(String internalName, @MaybeNull String outerName, @MaybeNull String innerName, int modifiers) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (this.instrumentedType.getInternalName().equals(internalName)) {
                for (Adjustment<TypeDescription> adjustment : this.typeAdjustments) {
                    if (!adjustment.matches(this.instrumentedType)) continue;
                    modifiers = adjustment.resolve(modifiers);
                    break;
                }
            }
            super.visitInnerClass((String)var1_1, (String)var2_2, (String)var3_3, modifiers);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @MaybeNull
        public FieldVisitor visitField(int modifiers, String internalName, String descriptor, @MaybeNull String signature, @MaybeNull Object value) {
            void var3_3;
            void var2_2;
            void var1_1;
            FieldDescription.InDefinedShape fieldDescription = this.fields.get(internalName + descriptor);
            if (fieldDescription != null) {
                for (Adjustment<FieldDescription.InDefinedShape> adjustment : this.fieldAdjustments) {
                    if (!adjustment.matches(fieldDescription)) continue;
                    modifiers = adjustment.resolve(modifiers);
                    break;
                }
            }
            return super.visitField((int)var1_1, (String)var2_2, (String)var3_3, signature, value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @MaybeNull
        public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, @MaybeNull String signature, @MaybeNull String[] exception) {
            void var3_3;
            void var2_2;
            void var1_1;
            MethodDescription methodDescription = this.methods.get(internalName + descriptor);
            if (methodDescription != null) {
                for (Adjustment<MethodDescription> adjustment : this.methodAdjustments) {
                    if (!adjustment.matches(methodDescription)) continue;
                    modifiers = adjustment.resolve(modifiers);
                    break;
                }
            }
            return super.visitMethod((int)var1_1, (String)var2_2, (String)var3_3, signature, exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    protected static class Adjustment<T>
    implements ElementMatcher<T> {
        private final ElementMatcher<? super T> matcher;
        private final ModifierContributor.Resolver<?> resolver;

        /*
         * WARNING - void declaration
         */
        protected Adjustment(ElementMatcher<? super T> matcher, ModifierContributor.Resolver<?> resolver) {
            void var2_2;
            void var1_1;
            this.matcher = var1_1;
            this.resolver = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean matches(@MaybeNull T target) {
            void var1_1;
            return this.matcher.matches(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        protected int resolve(int modifiers) {
            void var1_1;
            return this.resolver.resolve((int)var1_1);
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.matcher.equals(((Adjustment)object).matcher)) {
                return false;
            }
            return this.resolver.equals(((Adjustment)object).resolver);
        }

        public int hashCode() {
            return (this.getClass().hashCode() * 31 + this.matcher.hashCode()) * 31 + this.resolver.hashCode();
        }
    }
}

