/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.asm;

import java.util.HashMap;
import java.util.Map;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.FieldVisitor;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.CompoundList;
import net.bytebuddy.utility.OpenedClassReader;
import net.bytebuddy.utility.nullability.AlwaysNull;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class MemberRemoval
extends AsmVisitorWrapper.AbstractBase {
    private final ElementMatcher.Junction<FieldDescription.InDefinedShape> fieldMatcher;
    private final ElementMatcher.Junction<MethodDescription> methodMatcher;

    public MemberRemoval() {
        this(ElementMatchers.none(), ElementMatchers.none());
    }

    /*
     * WARNING - void declaration
     */
    protected MemberRemoval(ElementMatcher.Junction<FieldDescription.InDefinedShape> fieldMatcher, ElementMatcher.Junction<MethodDescription> methodMatcher) {
        void var2_2;
        void var1_1;
        this.fieldMatcher = var1_1;
        this.methodMatcher = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public MemberRemoval stripFields(ElementMatcher<? super FieldDescription.InDefinedShape> matcher) {
        void var1_1;
        return new MemberRemoval(this.fieldMatcher.or(var1_1), this.methodMatcher);
    }

    /*
     * WARNING - void declaration
     */
    public MemberRemoval stripMethods(ElementMatcher<? super MethodDescription> matcher) {
        void var1_1;
        return this.stripInvokables(ElementMatchers.isMethod().and(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public MemberRemoval stripConstructors(ElementMatcher<? super MethodDescription> matcher) {
        void var1_1;
        return this.stripInvokables(ElementMatchers.isConstructor().and(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public MemberRemoval stripInvokables(ElementMatcher<? super MethodDescription> matcher) {
        void var1_1;
        return new MemberRemoval(this.fieldMatcher, this.methodMatcher.or(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
        void var3_5;
        void var2_4;
        HashMap<String, FieldDescription.InDefinedShape> mappedFields = new HashMap<String, FieldDescription.InDefinedShape>();
        for (FieldDescription.InDefinedShape fieldDescription : fields) {
            mappedFields.put(fieldDescription.getInternalName() + fieldDescription.getDescriptor(), fieldDescription);
        }
        HashMap<String, MethodDescription> mappedMethods = new HashMap<String, MethodDescription>();
        for (MethodDescription methodDescription : CompoundList.of(methods, new MethodDescription.Latent.TypeInitializer(instrumentedType))) {
            void var1_3;
            mappedMethods.put(methodDescription.getInternalName() + methodDescription.getDescriptor(), (MethodDescription)var1_3);
        }
        return new MemberRemovingClassVisitor((ClassVisitor)var2_4, this.fieldMatcher, this.methodMatcher, (Map<String, FieldDescription.InDefinedShape>)var3_5, mappedMethods);
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!this.fieldMatcher.equals(((MemberRemoval)object).fieldMatcher)) {
            return false;
        }
        return this.methodMatcher.equals(((MemberRemoval)object).methodMatcher);
    }

    public int hashCode() {
        return (this.getClass().hashCode() * 31 + this.fieldMatcher.hashCode()) * 31 + this.methodMatcher.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MemberRemovingClassVisitor
    extends ClassVisitor {
        private static final FieldVisitor REMOVE_FIELD = null;
        @AlwaysNull
        private static final MethodVisitor REMOVE_METHOD = null;
        private final ElementMatcher.Junction<FieldDescription.InDefinedShape> fieldMatcher;
        private final ElementMatcher.Junction<MethodDescription> methodMatcher;
        private final Map<String, FieldDescription.InDefinedShape> fields;
        private final Map<String, MethodDescription> methods;

        /*
         * WARNING - void declaration
         */
        protected MemberRemovingClassVisitor(ClassVisitor classVisitor, ElementMatcher.Junction<FieldDescription.InDefinedShape> fieldMatcher, ElementMatcher.Junction<MethodDescription> methodMatcher, Map<String, FieldDescription.InDefinedShape> fields, Map<String, MethodDescription> methods) {
            super(OpenedClassReader.ASM_API, (ClassVisitor)var1_1);
            void var3_3;
            void var2_2;
            void var1_1;
            this.fieldMatcher = var2_2;
            this.methodMatcher = var3_3;
            this.fields = fields;
            this.methods = methods;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @MaybeNull
        public FieldVisitor visitField(int modifiers, String internalName, String descriptor, @MaybeNull String signature, @MaybeNull Object value) {
            void var3_3;
            void var2_2;
            void var1_1;
            FieldDescription.InDefinedShape fieldDescription = this.fields.get(internalName + descriptor);
            if (fieldDescription != null && this.fieldMatcher.matches(fieldDescription)) {
                return REMOVE_FIELD;
            }
            return super.visitField((int)var1_1, (String)var2_2, (String)var3_3, signature, value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @MaybeNull
        public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, @MaybeNull String signature, @MaybeNull String[] exception) {
            void var3_3;
            void var2_2;
            void var1_1;
            MethodDescription methodDescription = this.methods.get(internalName + descriptor);
            if (methodDescription != null && this.methodMatcher.matches(methodDescription)) {
                return REMOVE_METHOD;
            }
            return super.visitMethod((int)var1_1, (String)var2_2, (String)var3_3, signature, exception);
        }
    }
}

