/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.asm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.FieldVisitor;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.CompoundList;
import net.bytebuddy.utility.OpenedClassReader;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface AsmVisitorWrapper {
    public static final int NO_FLAGS = 0;

    public int mergeWriter(int var1);

    public int mergeReader(int var1);

    public ClassVisitor wrap(TypeDescription var1, ClassVisitor var2, Implementation.Context var3, TypePool var4, FieldList<FieldDescription.InDefinedShape> var5, MethodList<?> var6, int var7, int var8);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Compound
    implements AsmVisitorWrapper {
        private final List<AsmVisitorWrapper> asmVisitorWrappers = new ArrayList<AsmVisitorWrapper>();

        /*
         * WARNING - void declaration
         */
        public Compound(AsmVisitorWrapper ... asmVisitorWrapper) {
            this(Arrays.asList(var1_1));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Compound(List<? extends AsmVisitorWrapper> asmVisitorWrappers) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                AsmVisitorWrapper asmVisitorWrapper = (AsmVisitorWrapper)iterator.next();
                if (asmVisitorWrapper instanceof Compound) {
                    this.asmVisitorWrappers.addAll(((Compound)asmVisitorWrapper).asmVisitorWrappers);
                    continue;
                }
                if (asmVisitorWrapper instanceof NoOp) continue;
                this.asmVisitorWrappers.add((AsmVisitorWrapper)var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int mergeWriter(int flags) {
            void var1_1;
            for (AsmVisitorWrapper asmVisitorWrapper : this.asmVisitorWrappers) {
                flags = asmVisitorWrapper.mergeWriter(flags);
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int mergeReader(int flags) {
            void var1_1;
            for (AsmVisitorWrapper asmVisitorWrapper : this.asmVisitorWrappers) {
                flags = asmVisitorWrapper.mergeReader(flags);
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
            void var2_2;
            for (AsmVisitorWrapper asmVisitorWrapper : this.asmVisitorWrappers) {
                classVisitor = asmVisitorWrapper.wrap(instrumentedType, classVisitor, implementationContext, typePool, fields, methods, writerFlags, readerFlags);
            }
            return var2_2;
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return ((Object)this.asmVisitorWrappers).equals(((Compound)object).asmVisitorWrappers);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + ((Object)this.asmVisitorWrappers).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class ForDeclaredMethods
    implements AsmVisitorWrapper {
        private final List<Entry> entries;
        private final int writerFlags;
        private final int readerFlags;

        public ForDeclaredMethods() {
            this(Collections.emptyList(), 0, 0);
        }

        /*
         * WARNING - void declaration
         */
        protected ForDeclaredMethods(List<Entry> entries, int writerFlags, int readerFlags) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.entries = var1_1;
            this.writerFlags = var2_2;
            this.readerFlags = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public ForDeclaredMethods method(ElementMatcher<? super MethodDescription> matcher, MethodVisitorWrapper ... methodVisitorWrapper) {
            void var2_2;
            void var1_1;
            return this.method((ElementMatcher<? super MethodDescription>)var1_1, Arrays.asList(var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public ForDeclaredMethods method(ElementMatcher<? super MethodDescription> matcher, List<? extends MethodVisitorWrapper> methodVisitorWrappers) {
            void var2_2;
            void var1_1;
            return this.invokable(ElementMatchers.isMethod().and(var1_1), (List<? extends MethodVisitorWrapper>)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public ForDeclaredMethods constructor(ElementMatcher<? super MethodDescription> matcher, MethodVisitorWrapper ... methodVisitorWrapper) {
            void var2_2;
            void var1_1;
            return this.constructor((ElementMatcher<? super MethodDescription>)var1_1, Arrays.asList(var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public ForDeclaredMethods constructor(ElementMatcher<? super MethodDescription> matcher, List<? extends MethodVisitorWrapper> methodVisitorWrappers) {
            void var2_2;
            void var1_1;
            return this.invokable(ElementMatchers.isConstructor().and(var1_1), (List<? extends MethodVisitorWrapper>)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public ForDeclaredMethods invokable(ElementMatcher<? super MethodDescription> matcher, MethodVisitorWrapper ... methodVisitorWrapper) {
            void var2_2;
            void var1_1;
            return this.invokable((ElementMatcher<? super MethodDescription>)var1_1, Arrays.asList(var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public ForDeclaredMethods invokable(ElementMatcher<? super MethodDescription> matcher, List<? extends MethodVisitorWrapper> methodVisitorWrappers) {
            void var2_2;
            void var1_1;
            return new ForDeclaredMethods(CompoundList.of(this.entries, new Entry((ElementMatcher<? super MethodDescription>)var1_1, (List<? extends MethodVisitorWrapper>)var2_2)), this.writerFlags, this.readerFlags);
        }

        /*
         * WARNING - void declaration
         */
        public ForDeclaredMethods writerFlags(int flags) {
            void var1_1;
            return new ForDeclaredMethods(this.entries, this.writerFlags | var1_1, this.readerFlags);
        }

        /*
         * WARNING - void declaration
         */
        public ForDeclaredMethods readerFlags(int flags) {
            void var1_1;
            return new ForDeclaredMethods(this.entries, this.writerFlags, this.readerFlags | var1_1);
        }

        @Override
        public int mergeWriter(int flags) {
            return flags | this.writerFlags;
        }

        @Override
        public int mergeReader(int flags) {
            return flags | this.readerFlags;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
            void var3_3;
            void var1_1;
            void var2_2;
            HashMap<String, MethodDescription> mapped = new HashMap<String, MethodDescription>();
            for (MethodDescription methodDescription : CompoundList.of(methods, new MethodDescription.Latent.TypeInitializer(instrumentedType))) {
                mapped.put(methodDescription.getInternalName() + methodDescription.getDescriptor(), methodDescription);
            }
            return new DispatchingVisitor(this, (ClassVisitor)var2_2, (TypeDescription)var1_1, (Implementation.Context)var3_3, typePool, mapped, writerFlags, readerFlags);
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (this.writerFlags != ((ForDeclaredMethods)object).writerFlags) {
                return false;
            }
            if (this.readerFlags != ((ForDeclaredMethods)object).readerFlags) {
                return false;
            }
            return ((Object)this.entries).equals(((ForDeclaredMethods)object).entries);
        }

        public int hashCode() {
            return ((this.getClass().hashCode() * 31 + ((Object)this.entries).hashCode()) * 31 + this.writerFlags) * 31 + this.readerFlags;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class DispatchingVisitor
        extends ClassVisitor {
            private final TypeDescription instrumentedType;
            private final Implementation.Context implementationContext;
            private final TypePool typePool;
            private final int writerFlags;
            private final int readerFlags;
            private final Map<String, MethodDescription> methods;
            final /* synthetic */ ForDeclaredMethods this$0;

            /*
             * WARNING - void declaration
             */
            protected DispatchingVisitor(ForDeclaredMethods this$0, ClassVisitor classVisitor, TypeDescription instrumentedType, Implementation.Context implementationContext, TypePool typePool, Map<String, MethodDescription> methods, int writerFlags, int readerFlags) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super(OpenedClassReader.ASM_API, (ClassVisitor)var2_2);
                this.instrumentedType = var3_3;
                this.implementationContext = implementationContext;
                this.typePool = typePool;
                this.methods = methods;
                this.writerFlags = writerFlags;
                this.readerFlags = readerFlags;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @MaybeNull
            public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, @MaybeNull String signature, @MaybeNull String[] exceptions) {
                void var1_2;
                Iterator iterator;
                MethodVisitor methodVisitor = super.visitMethod(modifiers, internalName, descriptor, signature, exceptions);
                MethodDescription methodDescription = this.methods.get(internalName + (String)((Object)iterator));
                if (methodVisitor != null && methodDescription != null) {
                    for (Entry entry : this.this$0.entries) {
                        if (!entry.matches(methodDescription)) continue;
                        methodVisitor = entry.wrap(this.instrumentedType, methodDescription, methodVisitor, this.implementationContext, this.typePool, this.writerFlags, this.readerFlags);
                    }
                }
                return var1_2;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class Entry
        implements MethodVisitorWrapper,
        ElementMatcher<MethodDescription> {
            private final ElementMatcher<? super MethodDescription> matcher;
            private final List<? extends MethodVisitorWrapper> methodVisitorWrappers;

            /*
             * WARNING - void declaration
             */
            protected Entry(ElementMatcher<? super MethodDescription> matcher, List<? extends MethodVisitorWrapper> methodVisitorWrappers) {
                void var2_2;
                void var1_1;
                this.matcher = var1_1;
                this.methodVisitorWrappers = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean matches(@MaybeNull MethodDescription target) {
                void var1_1;
                return this.matcher.matches((MethodDescription)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public MethodVisitor wrap(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, TypePool typePool, int writerFlags, int readerFlags) {
                void var3_3;
                for (MethodVisitorWrapper methodVisitorWrapper : this.methodVisitorWrappers) {
                    methodVisitor = methodVisitorWrapper.wrap(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, typePool, writerFlags, readerFlags);
                }
                return var3_3;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.matcher.equals(((Entry)object).matcher)) {
                    return false;
                }
                return ((Object)this.methodVisitorWrappers).equals(((Entry)object).methodVisitorWrappers);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + this.matcher.hashCode()) * 31 + ((Object)this.methodVisitorWrappers).hashCode();
            }
        }

        public static interface MethodVisitorWrapper {
            public MethodVisitor wrap(TypeDescription var1, MethodDescription var2, MethodVisitor var3, Implementation.Context var4, TypePool var5, int var6, int var7);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class ForDeclaredFields
    extends AbstractBase {
        private final List<Entry> entries;

        public ForDeclaredFields() {
            this(Collections.emptyList());
        }

        /*
         * WARNING - void declaration
         */
        protected ForDeclaredFields(List<Entry> entries) {
            void var1_1;
            this.entries = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ForDeclaredFields field(ElementMatcher<? super FieldDescription.InDefinedShape> matcher, FieldVisitorWrapper ... fieldVisitorWrapper) {
            void var2_2;
            void var1_1;
            return this.field((ElementMatcher<? super FieldDescription.InDefinedShape>)var1_1, Arrays.asList(var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public ForDeclaredFields field(ElementMatcher<? super FieldDescription.InDefinedShape> matcher, List<? extends FieldVisitorWrapper> fieldVisitorWrappers) {
            void var2_2;
            void var1_1;
            return new ForDeclaredFields(CompoundList.of(this.entries, new Entry((ElementMatcher<? super FieldDescription.InDefinedShape>)var1_1, (List<? extends FieldVisitorWrapper>)var2_2)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
            void var3_3;
            void var1_1;
            void var2_2;
            HashMap<String, FieldDescription.InDefinedShape> mapped = new HashMap<String, FieldDescription.InDefinedShape>();
            for (FieldDescription.InDefinedShape fieldDescription : fields) {
                mapped.put(fieldDescription.getInternalName() + fieldDescription.getDescriptor(), fieldDescription);
            }
            return new DispatchingVisitor(this, (ClassVisitor)var2_2, (TypeDescription)var1_1, (Map<String, FieldDescription.InDefinedShape>)var3_3);
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return ((Object)this.entries).equals(((ForDeclaredFields)object).entries);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + ((Object)this.entries).hashCode();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class DispatchingVisitor
        extends ClassVisitor {
            private final TypeDescription instrumentedType;
            private final Map<String, FieldDescription.InDefinedShape> fields;
            final /* synthetic */ ForDeclaredFields this$0;

            /*
             * WARNING - void declaration
             */
            protected DispatchingVisitor(ForDeclaredFields this$0, ClassVisitor classVisitor, TypeDescription instrumentedType, Map<String, FieldDescription.InDefinedShape> fields) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super(OpenedClassReader.ASM_API, (ClassVisitor)var2_2);
                this.instrumentedType = var3_3;
                this.fields = fields;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @MaybeNull
            public FieldVisitor visitField(int modifiers, String internalName, String descriptor, @MaybeNull String signature, @MaybeNull Object value) {
                void var1_2;
                Iterator iterator;
                FieldVisitor fieldVisitor = super.visitField(modifiers, internalName, descriptor, signature, value);
                FieldDescription.InDefinedShape fieldDescription = this.fields.get(internalName + (String)((Object)iterator));
                if (fieldVisitor != null && fieldDescription != null) {
                    for (Entry entry : this.this$0.entries) {
                        if (!entry.matches(fieldDescription)) continue;
                        fieldVisitor = entry.wrap(this.instrumentedType, fieldDescription, fieldVisitor);
                    }
                }
                return var1_2;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class Entry
        implements FieldVisitorWrapper,
        ElementMatcher<FieldDescription.InDefinedShape> {
            private final ElementMatcher<? super FieldDescription.InDefinedShape> matcher;
            private final List<? extends FieldVisitorWrapper> fieldVisitorWrappers;

            /*
             * WARNING - void declaration
             */
            protected Entry(ElementMatcher<? super FieldDescription.InDefinedShape> matcher, List<? extends FieldVisitorWrapper> fieldVisitorWrappers) {
                void var2_2;
                void var1_1;
                this.matcher = var1_1;
                this.fieldVisitorWrappers = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean matches(@MaybeNull FieldDescription.InDefinedShape target) {
                void var1_1;
                return this.matcher.matches((FieldDescription.InDefinedShape)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public FieldVisitor wrap(TypeDescription instrumentedType, FieldDescription.InDefinedShape fieldDescription, FieldVisitor fieldVisitor) {
                void var3_3;
                for (FieldVisitorWrapper fieldVisitorWrapper : this.fieldVisitorWrappers) {
                    fieldVisitor = fieldVisitorWrapper.wrap(instrumentedType, fieldDescription, fieldVisitor);
                }
                return var3_3;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.matcher.equals(((Entry)object).matcher)) {
                    return false;
                }
                return ((Object)this.fieldVisitorWrappers).equals(((Entry)object).fieldVisitorWrappers);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + this.matcher.hashCode()) * 31 + ((Object)this.fieldVisitorWrappers).hashCode();
            }
        }

        public static interface FieldVisitorWrapper {
            public FieldVisitor wrap(TypeDescription var1, FieldDescription.InDefinedShape var2, FieldVisitor var3);
        }
    }

    public static abstract class AbstractBase
    implements AsmVisitorWrapper {
        public int mergeWriter(int flags) {
            return flags;
        }

        public int mergeReader(int flags) {
            return flags;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NoOp implements AsmVisitorWrapper
    {
        INSTANCE;


        @Override
        public final int mergeWriter(int flags) {
            return flags;
        }

        @Override
        public final int mergeReader(int flags) {
            return flags;
        }

        @Override
        public final ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
            return classVisitor;
        }
    }
}

