/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.asm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.build.RepeatedAnnotationPlugin;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationValue;
import net.bytebuddy.description.enumeration.EnumerationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.TargetType;
import net.bytebuddy.dynamic.scaffold.FieldLocator;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.implementation.bytecode.Addition;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.Removal;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.implementation.bytecode.Throw;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.collection.ArrayAccess;
import net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.DefaultValue;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.constant.JavaConstantValue;
import net.bytebuddy.implementation.bytecode.constant.MethodConstant;
import net.bytebuddy.implementation.bytecode.constant.NullConstant;
import net.bytebuddy.implementation.bytecode.constant.SerializedConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.Invokedynamic;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.AnnotationVisitor;
import net.bytebuddy.jar.asm.Attribute;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Opcodes;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.jar.asm.TypePath;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.AsmClassReader;
import net.bytebuddy.utility.CompoundList;
import net.bytebuddy.utility.ConstantValue;
import net.bytebuddy.utility.JavaConstant;
import net.bytebuddy.utility.JavaType;
import net.bytebuddy.utility.OpenedClassReader;
import net.bytebuddy.utility.nullability.AlwaysNull;
import net.bytebuddy.utility.nullability.MaybeNull;
import net.bytebuddy.utility.visitor.ExceptionTableSensitiveMethodVisitor;
import net.bytebuddy.utility.visitor.LineNumberPrependingMethodVisitor;
import net.bytebuddy.utility.visitor.StackAwareMethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class Advice
implements AsmVisitorWrapper.ForDeclaredMethods.MethodVisitorWrapper,
Implementation {
    @AlwaysNull
    private static final AsmClassReader UNDEFINED;
    private static final MethodDescription.InDefinedShape SKIP_ON;
    private static final MethodDescription.InDefinedShape SKIP_ON_INDEX;
    private static final MethodDescription.InDefinedShape PREPEND_LINE_NUMBER;
    private static final MethodDescription.InDefinedShape INLINE_ENTER;
    private static final MethodDescription.InDefinedShape SUPPRESS_ENTER;
    private static final MethodDescription.InDefinedShape REPEAT_ON;
    private static final MethodDescription.InDefinedShape REPEAT_ON_INDEX;
    private static final MethodDescription.InDefinedShape ON_THROWABLE;
    private static final MethodDescription.InDefinedShape BACKUP_ARGUMENTS;
    private static final MethodDescription.InDefinedShape INLINE_EXIT;
    private static final MethodDescription.InDefinedShape SUPPRESS_EXIT;
    private final Dispatcher.Resolved.ForMethodEnter methodEnter;
    private final Dispatcher.Resolved.ForMethodExit methodExit;
    private final Assigner assigner;
    private final ExceptionHandler exceptionHandler;
    private final Implementation delegate;

    /*
     * WARNING - void declaration
     */
    protected Advice(Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit) {
        this((Dispatcher.Resolved.ForMethodEnter)var1_1, (Dispatcher.Resolved.ForMethodExit)var2_2, Assigner.DEFAULT, ExceptionHandler.Default.SUPPRESSING, SuperMethodCall.INSTANCE);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Advice(Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, Assigner assigner, ExceptionHandler exceptionHandler, Implementation delegate) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.methodEnter = var1_1;
        this.methodExit = var2_2;
        this.assigner = var3_3;
        this.exceptionHandler = exceptionHandler;
        this.delegate = delegate;
    }

    public static Advice to(Class<?> advice) {
        Class<?> clazz = advice;
        return Advice.to(clazz, ClassFileLocator.ForClassLoader.of(clazz.getClassLoader()));
    }

    /*
     * WARNING - void declaration
     */
    public static Advice to(Class<?> advice, ClassFileLocator classFileLocator) {
        void var1_1;
        return Advice.to(TypeDescription.ForLoadedType.of(advice), (ClassFileLocator)var1_1);
    }

    public static Advice to(TypeDescription advice) {
        return Advice.to(advice, (ClassFileLocator)ClassFileLocator.NoOp.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    public static Advice to(TypeDescription advice, ClassFileLocator classFileLocator) {
        void var1_1;
        return Advice.to(advice, PostProcessor.NoOp.INSTANCE, (ClassFileLocator)var1_1, Collections.emptyList(), Delegator.ForRegularInvocation.Factory.INSTANCE, AsmClassReader.Factory.Default.IMPLICIT);
    }

    /*
     * WARNING - void declaration
     */
    protected static Advice to(TypeDescription advice, PostProcessor.Factory postProcessorFactory, ClassFileLocator classFileLocator, List<? extends OffsetMapping.Factory<?>> userFactories, Delegator.Factory delegatorFactory, AsmClassReader.Factory classReaderFactory) {
        Dispatcher.Unresolved methodEnter = Dispatcher.Inactive.INSTANCE;
        Dispatcher.Unresolved methodExit = Dispatcher.Inactive.INSTANCE;
        for (MethodDescription.InDefinedShape methodDescription : advice.getDeclaredMethods()) {
            methodEnter = Advice.locate(OnMethodEnter.class, INLINE_ENTER, methodEnter, methodDescription, delegatorFactory);
            methodExit = Advice.locate(OnMethodExit.class, INLINE_EXIT, methodExit, methodDescription, delegatorFactory);
        }
        if (!methodEnter.isAlive() && !methodExit.isAlive()) {
            throw new IllegalArgumentException("No advice defined by " + advice);
        }
        try {
            void var1_1;
            void var3_3;
            void var2_2;
            AsmClassReader classReader = methodEnter.isBinary() || methodExit.isBinary() ? classReaderFactory.make(var2_2.locate(advice.getName()).resolve()) : UNDEFINED;
            return new Advice(methodEnter.asMethodEnter(userFactories, classReader, methodExit, postProcessorFactory), methodExit.asMethodExit((List<? extends OffsetMapping.Factory<?>>)var3_3, classReader, methodEnter, (PostProcessor.Factory)var1_1));
        }
        catch (IOException exception) {
            TypeDescription typeDescription;
            throw new IllegalStateException("Error reading class file of " + typeDescription, exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Advice to(Class<?> enterAdvice, Class<?> exitAdvice) {
        void var3_3;
        void var2_2;
        ClassLoader exitLoader;
        void var1_1;
        Class<?> clazz;
        ClassLoader enterLoader = enterAdvice.getClassLoader();
        return Advice.to(clazz, var1_1, enterLoader == (exitLoader = exitAdvice.getClassLoader()) ? ClassFileLocator.ForClassLoader.of(enterLoader) : new ClassFileLocator.Compound(ClassFileLocator.ForClassLoader.of((ClassLoader)var2_2), ClassFileLocator.ForClassLoader.of((ClassLoader)var3_3)));
    }

    /*
     * WARNING - void declaration
     */
    public static Advice to(Class<?> enterAdvice, Class<?> exitAdvice, ClassFileLocator classFileLocator) {
        void var2_2;
        void var1_1;
        return Advice.to(TypeDescription.ForLoadedType.of(enterAdvice), TypeDescription.ForLoadedType.of(var1_1), (ClassFileLocator)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice) {
        void var1_1;
        return Advice.to(enterAdvice, (TypeDescription)var1_1, (ClassFileLocator)ClassFileLocator.NoOp.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    public static Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice, ClassFileLocator classFileLocator) {
        void var2_2;
        void var1_1;
        return Advice.to(enterAdvice, (TypeDescription)var1_1, PostProcessor.NoOp.INSTANCE, (ClassFileLocator)var2_2, Collections.emptyList(), Delegator.ForRegularInvocation.Factory.INSTANCE, AsmClassReader.Factory.Default.IMPLICIT);
    }

    /*
     * WARNING - void declaration
     */
    protected static Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice, PostProcessor.Factory postProcessorFactory, ClassFileLocator classFileLocator, List<? extends OffsetMapping.Factory<?>> userFactories, Delegator.Factory delegatorFactory, AsmClassReader.Factory classReaderFactory) {
        Dispatcher.Unresolved methodEnter = Dispatcher.Inactive.INSTANCE;
        Dispatcher.Unresolved methodExit = Dispatcher.Inactive.INSTANCE;
        for (MethodDescription.InDefinedShape methodDescription : enterAdvice.getDeclaredMethods()) {
            methodEnter = Advice.locate(OnMethodEnter.class, INLINE_ENTER, methodEnter, methodDescription, delegatorFactory);
        }
        if (!methodEnter.isAlive()) {
            throw new IllegalArgumentException("No enter advice defined by " + enterAdvice);
        }
        for (MethodDescription.InDefinedShape methodDescription : exitAdvice.getDeclaredMethods()) {
            methodExit = Advice.locate(OnMethodExit.class, INLINE_EXIT, methodExit, methodDescription, delegatorFactory);
        }
        if (!methodExit.isAlive()) {
            throw new IllegalArgumentException("No exit advice defined by " + exitAdvice);
        }
        try {
            void var2_2;
            void var3_3;
            return new Advice(methodEnter.asMethodEnter(userFactories, methodEnter.isBinary() ? classReaderFactory.make(classFileLocator.locate(enterAdvice.getName()).resolve()) : UNDEFINED, methodExit, postProcessorFactory), methodExit.asMethodExit(userFactories, methodExit.isBinary() ? classReaderFactory.make(var3_3.locate(exitAdvice.getName()).resolve()) : UNDEFINED, methodEnter, (PostProcessor.Factory)var2_2));
        }
        catch (IOException exception) {
            void var1_1;
            TypeDescription typeDescription;
            throw new IllegalStateException("Error reading class file of " + typeDescription + " or " + var1_1, exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Dispatcher.Unresolved locate(Class<? extends Annotation> type, MethodDescription.InDefinedShape property, Dispatcher.Unresolved dispatcher, MethodDescription.InDefinedShape methodDescription, Delegator.Factory delegatorFactory) {
        void var3_3;
        void var1_1;
        AnnotationDescription.Loadable<? extends Annotation> loadable;
        AnnotationDescription.Loadable<? extends Annotation> annotation = methodDescription.getDeclaredAnnotations().ofType(type);
        if (annotation == null) {
            return dispatcher;
        }
        if (dispatcher.isAlive()) {
            void var2_2;
            throw new IllegalStateException("Duplicate advice for " + var2_2 + " and " + methodDescription);
        }
        if (!methodDescription.isStatic()) {
            throw new IllegalStateException("Advice for " + methodDescription + " is not static");
        }
        if (loadable.getValue((MethodDescription.InDefinedShape)var1_1).resolve(Boolean.class).booleanValue()) {
            return new Dispatcher.Inlining(methodDescription);
        }
        return new Dispatcher.Delegating((MethodDescription.InDefinedShape)var3_3, delegatorFactory);
    }

    public static WithCustomMapping withCustomMapping() {
        return new WithCustomMapping();
    }

    /*
     * WARNING - void declaration
     */
    public AsmVisitorWrapper.ForDeclaredMethods on(ElementMatcher<? super MethodDescription> matcher) {
        void var1_1;
        return new AsmVisitorWrapper.ForDeclaredMethods().invokable((ElementMatcher<? super MethodDescription>)var1_1, this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MethodVisitor wrap(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, TypePool typePool, int writerFlags, int readerFlags) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (instrumentedMethod.isAbstract() || instrumentedMethod.isNative()) {
            return methodVisitor;
        }
        return this.doWrap((TypeDescription)var1_1, (MethodDescription)var2_2, (MethodVisitor)var3_3, implementationContext, writerFlags, readerFlags);
    }

    /*
     * WARNING - void declaration
     */
    protected MethodVisitor doWrap(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, int writerFlags, int readerFlags) {
        void var2_2;
        void var1_1;
        void var3_3;
        if (this.methodEnter.isPrependLineNumber()) {
            methodVisitor = new LineNumberPrependingMethodVisitor(methodVisitor);
        }
        if (!this.methodExit.isAlive()) {
            return new AdviceVisitor.WithoutExitAdvice(methodVisitor, implementationContext, this.assigner, this.exceptionHandler.resolve(instrumentedMethod, instrumentedType), instrumentedType, instrumentedMethod, this.methodEnter, writerFlags, readerFlags);
        }
        if (this.methodExit.getThrowable().represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class))) {
            return new AdviceVisitor.WithExitAdvice.WithoutExceptionHandling(methodVisitor, implementationContext, this.assigner, this.exceptionHandler.resolve(instrumentedMethod, instrumentedType), instrumentedType, instrumentedMethod, this.methodEnter, this.methodExit, writerFlags, readerFlags);
        }
        if (instrumentedMethod.isConstructor()) {
            throw new IllegalStateException("Cannot catch exception during constructor call for " + instrumentedMethod);
        }
        return new AdviceVisitor.WithExitAdvice.WithExceptionHandling((MethodVisitor)var3_3, implementationContext, this.assigner, this.exceptionHandler.resolve(instrumentedMethod, instrumentedType), (TypeDescription)var1_1, (MethodDescription)var2_2, this.methodEnter, this.methodExit, writerFlags, readerFlags, this.methodExit.getThrowable());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        void var1_1;
        return this.delegate.prepare((InstrumentedType)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        void var1_1;
        return new Appender(this, implementationTarget, this.delegate.appender((Implementation.Target)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Advice withAssigner(Assigner assigner) {
        void var1_1;
        return new Advice(this.methodEnter, this.methodExit, (Assigner)var1_1, this.exceptionHandler, this.delegate);
    }

    public Advice withExceptionPrinting() {
        return this.withExceptionHandler(ExceptionHandler.Default.PRINTING);
    }

    /*
     * WARNING - void declaration
     */
    public Advice withExceptionHandler(StackManipulation exceptionHandler) {
        void var1_1;
        return this.withExceptionHandler(new ExceptionHandler.Simple((StackManipulation)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Advice withExceptionHandler(ExceptionHandler exceptionHandler) {
        void var1_1;
        return new Advice(this.methodEnter, this.methodExit, this.assigner, (ExceptionHandler)var1_1, this.delegate);
    }

    /*
     * WARNING - void declaration
     */
    public Implementation wrap(Implementation implementation) {
        void var1_1;
        return new Advice(this.methodEnter, this.methodExit, this.assigner, this.exceptionHandler, (Implementation)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        UNDEFINED = null;
        MethodList<MethodDescription.InDefinedShape> enter = TypeDescription.ForLoadedType.of(OnMethodEnter.class).getDeclaredMethods();
        SKIP_ON = (MethodDescription.InDefinedShape)((MethodList)enter.filter(ElementMatchers.named("skipOn"))).getOnly();
        SKIP_ON_INDEX = (MethodDescription.InDefinedShape)((MethodList)enter.filter(ElementMatchers.named("skipOnIndex"))).getOnly();
        PREPEND_LINE_NUMBER = (MethodDescription.InDefinedShape)((MethodList)enter.filter(ElementMatchers.named("prependLineNumber"))).getOnly();
        INLINE_ENTER = (MethodDescription.InDefinedShape)((MethodList)enter.filter(ElementMatchers.named("inline"))).getOnly();
        SUPPRESS_ENTER = (MethodDescription.InDefinedShape)((MethodList)enter.filter(ElementMatchers.named("suppress"))).getOnly();
        MethodList<MethodDescription.InDefinedShape> exit = TypeDescription.ForLoadedType.of(OnMethodExit.class).getDeclaredMethods();
        REPEAT_ON = (MethodDescription.InDefinedShape)((MethodList)exit.filter(ElementMatchers.named("repeatOn"))).getOnly();
        REPEAT_ON_INDEX = (MethodDescription.InDefinedShape)((MethodList)exit.filter(ElementMatchers.named("repeatOnIndex"))).getOnly();
        ON_THROWABLE = (MethodDescription.InDefinedShape)((MethodList)exit.filter(ElementMatchers.named("onThrowable"))).getOnly();
        BACKUP_ARGUMENTS = (MethodDescription.InDefinedShape)((MethodList)exit.filter(ElementMatchers.named("backupArguments"))).getOnly();
        INLINE_EXIT = (MethodDescription.InDefinedShape)((MethodList)exit.filter(ElementMatchers.named("inline"))).getOnly();
        SUPPRESS_EXIT = (MethodDescription.InDefinedShape)((MethodList)var0.filter(ElementMatchers.named("suppress"))).getOnly();
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!this.methodEnter.equals(((Advice)object).methodEnter)) {
            return false;
        }
        if (!this.methodExit.equals(((Advice)object).methodExit)) {
            return false;
        }
        if (!this.assigner.equals(((Advice)object).assigner)) {
            return false;
        }
        if (!this.exceptionHandler.equals(((Advice)object).exceptionHandler)) {
            return false;
        }
        return this.delegate.equals(((Advice)object).delegate);
    }

    public int hashCode() {
        return ((((this.getClass().hashCode() * 31 + this.methodEnter.hashCode()) * 31 + this.methodExit.hashCode()) * 31 + this.assigner.hashCode()) * 31 + this.exceptionHandler.hashCode()) * 31 + this.delegate.hashCode();
    }

    public static final class OnNonDefaultValue {
        private OnNonDefaultValue() {
            throw new UnsupportedOperationException("This class only serves as a marker type and should not be instantiated");
        }
    }

    public static final class OnDefaultValue {
        private OnDefaultValue() {
            throw new UnsupportedOperationException("This class only serves as a marker type and should not be instantiated");
        }
    }

    private static class NoExceptionHandler
    extends Throwable {
        private static final long serialVersionUID = 1L;
        private static final TypeDescription DESCRIPTION = TypeDescription.ForLoadedType.of(NoExceptionHandler.class);

        private NoExceptionHandler() {
            throw new UnsupportedOperationException("This class only serves as a marker type and should not be instantiated");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class WithCustomMapping {
        private final PostProcessor.Factory postProcessorFactory;
        private final Delegator.Factory delegatorFactory;
        private final AsmClassReader.Factory classReaderFactory;
        private final Map<Class<? extends Annotation>, OffsetMapping.Factory<?>> offsetMappings;

        protected WithCustomMapping() {
            this(PostProcessor.NoOp.INSTANCE, Collections.emptyMap(), Delegator.ForRegularInvocation.Factory.INSTANCE, AsmClassReader.Factory.Default.IMPLICIT);
        }

        /*
         * WARNING - void declaration
         */
        protected WithCustomMapping(PostProcessor.Factory postProcessorFactory, Map<Class<? extends Annotation>, OffsetMapping.Factory<?>> offsetMappings, Delegator.Factory delegatorFactory, AsmClassReader.Factory classReaderFactory) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.postProcessorFactory = var1_1;
            this.offsetMappings = var2_2;
            this.delegatorFactory = var3_3;
            this.classReaderFactory = classReaderFactory;
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bind(Class<T> type, @MaybeNull Object value) {
            void var2_2;
            void var1_1;
            return this.bind(OffsetMapping.ForStackManipulation.Factory.of(var1_1, var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bind(Class<T> type, Field field) {
            void var2_2;
            void var1_1;
            return this.bind((Class<T>)var1_1, new FieldDescription.ForLoadedField((Field)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bind(Class<T> type, FieldDescription fieldDescription) {
            void var2_2;
            void var1_1;
            return this.bind(new OffsetMapping.ForField.Resolved.Factory(var1_1, (FieldDescription)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bind(Class<T> type, Method method, int index) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (index < 0) {
                throw new IllegalArgumentException("A parameter cannot be negative: " + index);
            }
            if (method.getParameterTypes().length <= index) {
                throw new IllegalArgumentException(method + " does not declare a parameter with index " + index);
            }
            return this.bind((Class<T>)var1_1, (ParameterDescription)new MethodDescription.ForLoadedMethod((Method)var2_2).getParameters().get((int)var3_3));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bind(Class<T> type, Constructor<?> constructor, int index) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (index < 0) {
                throw new IllegalArgumentException("A parameter cannot be negative: " + index);
            }
            if (constructor.getParameterTypes().length <= index) {
                throw new IllegalArgumentException(constructor + " does not declare a parameter with index " + index);
            }
            return this.bind((Class<T>)var1_1, (ParameterDescription)new MethodDescription.ForLoadedConstructor((Constructor<?>)var2_2).getParameters().get((int)var3_3));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bind(Class<T> type, ParameterDescription parameterDescription) {
            void var2_2;
            void var1_1;
            return this.bind(new OffsetMapping.ForArgument.Resolved.Factory(var1_1, (ParameterDescription)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bind(Class<T> type, Class<?> value) {
            void var2_2;
            void var1_1;
            return this.bind((Class<T>)var1_1, TypeDescription.ForLoadedType.of(var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bind(Class<T> type, TypeDescription value) {
            void var2_2;
            void var1_1;
            return this.bind(new OffsetMapping.ForStackManipulation.Factory(var1_1, (TypeDescription)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bind(Class<T> type, Enum<?> value) {
            void var2_2;
            void var1_1;
            return this.bind((Class<T>)var1_1, new EnumerationDescription.ForLoadedEnumeration((Enum<?>)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bind(Class<T> type, EnumerationDescription value) {
            void var2_2;
            void var1_1;
            return this.bind(new OffsetMapping.ForStackManipulation.Factory(var1_1, (EnumerationDescription)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bindSerialized(Class<T> type, Serializable value) {
            void var1_1;
            void var2_2;
            void v0 = var2_2;
            return this.bindSerialized((Class<T>)var1_1, v0, (Class)v0.getClass());
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation, S extends Serializable> WithCustomMapping bindSerialized(Class<T> type, S value, Class<? super S> targetType) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.bind(OffsetMapping.ForSerializedValue.Factory.of(var1_1, var2_2, var3_3));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bindProperty(Class<T> type, String property) {
            void var2_2;
            void var1_1;
            return this.bind(OffsetMapping.ForStackManipulation.OfAnnotationProperty.of(var1_1, (String)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bind(Class<T> type, JavaConstant constant) {
            void var2_2;
            void var1_1;
            return this.bind((Class<T>)var1_1, (ConstantValue)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bind(Class<T> type, ConstantValue constant) {
            void var2_2;
            void var1_1;
            return this.bind(new OffsetMapping.ForStackManipulation.Factory(var1_1, constant.toStackManipulation(), var2_2.getTypeDescription().asGenericType()));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bind(Class<T> type, StackManipulation stackManipulation, java.lang.reflect.Type targetType) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.bind((Class<T>)var1_1, (StackManipulation)var2_2, TypeDefinition.Sort.describe((java.lang.reflect.Type)var3_3));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bind(Class<T> type, StackManipulation stackManipulation, TypeDescription.Generic targetType) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.bind(new OffsetMapping.ForStackManipulation.Factory(var1_1, (StackManipulation)var2_2, (TypeDescription.Generic)var3_3));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bindLambda(Class<T> type, Constructor<?> constructor, Class<?> functionalInterface) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.bindLambda((Class<T>)var1_1, new MethodDescription.ForLoadedConstructor((Constructor<?>)var2_2), TypeDescription.ForLoadedType.of(var3_3));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bindLambda(Class<T> type, Constructor<?> constructor, Class<?> functionalInterface, MethodGraph.Compiler methodGraphCompiler) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.bindLambda((Class<T>)var1_1, new MethodDescription.ForLoadedConstructor((Constructor<?>)var2_2), TypeDescription.ForLoadedType.of(var3_3), methodGraphCompiler);
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bindLambda(Class<T> type, Method method, Class<?> functionalInterface) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.bindLambda((Class<T>)var1_1, new MethodDescription.ForLoadedMethod((Method)var2_2), TypeDescription.ForLoadedType.of(var3_3));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bindLambda(Class<T> type, Method method, Class<?> functionalInterface, MethodGraph.Compiler methodGraphCompiler) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.bindLambda((Class<T>)var1_1, new MethodDescription.ForLoadedMethod((Method)var2_2), TypeDescription.ForLoadedType.of(var3_3), methodGraphCompiler);
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bindLambda(Class<T> type, MethodDescription.InDefinedShape methodDescription, TypeDescription functionalInterface) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.bindLambda((Class<T>)var1_1, (MethodDescription.InDefinedShape)var2_2, (TypeDescription)var3_3, MethodGraph.Compiler.DEFAULT);
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bindLambda(Class<T> type, MethodDescription.InDefinedShape methodDescription, TypeDescription functionalInterface, MethodGraph.Compiler methodGraphCompiler) {
            void var2_2;
            void var1_1;
            if (!functionalInterface.isInterface()) {
                throw new IllegalArgumentException(functionalInterface + " is not an interface type");
            }
            MethodList methods = (MethodList)methodGraphCompiler.compile((TypeDefinition)functionalInterface).listNodes().asMethodList().filter(ElementMatchers.isAbstract());
            if (methods.size() != 1) {
                void var3_3;
                throw new IllegalArgumentException(var3_3 + " does not define exactly one abstract method: " + methods);
            }
            return this.bindDynamic((Class<T>)var1_1, (MethodDescription.InDefinedShape)new MethodDescription.Latent(new TypeDescription.Latent("java.lang.invoke.LambdaMetafactory", 1, TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(Object.class), new TypeDescription.Generic[0]), "metafactory", 9, Collections.emptyList(), JavaType.CALL_SITE.getTypeStub().asGenericType(), Arrays.asList(new ParameterDescription.Token(JavaType.METHOD_HANDLES_LOOKUP.getTypeStub().asGenericType()), new ParameterDescription.Token(TypeDescription.ForLoadedType.of(String.class).asGenericType()), new ParameterDescription.Token(JavaType.METHOD_TYPE.getTypeStub().asGenericType()), new ParameterDescription.Token(JavaType.METHOD_TYPE.getTypeStub().asGenericType()), new ParameterDescription.Token(JavaType.METHOD_HANDLE.getTypeStub().asGenericType()), new ParameterDescription.Token(JavaType.METHOD_TYPE.getTypeStub().asGenericType())), Collections.emptyList(), Collections.emptyList(), AnnotationValue.UNDEFINED, TypeDescription.Generic.UNDEFINED), JavaConstant.MethodType.ofSignature((MethodDescription)methods.asDefined().getOnly()), JavaConstant.MethodHandle.of((MethodDescription.InDefinedShape)var2_2), JavaConstant.MethodType.ofSignature((MethodDescription)methods.asDefined().getOnly()));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bindDynamic(Class<T> type, Method bootstrapMethod, Object ... constant) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.bindDynamic((Class<T>)var1_1, (Method)var2_2, (List<?>)Arrays.asList(var3_3));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bindDynamic(Class<T> type, Method bootstrapMethod, List<?> constants) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.bindDynamic((Class<T>)var1_1, (MethodDescription.InDefinedShape)new MethodDescription.ForLoadedMethod((Method)var2_2), (List<?>)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bindDynamic(Class<T> type, Constructor<?> bootstrapMethod, Object ... constant) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.bindDynamic((Class<T>)var1_1, (Constructor<?>)var2_2, (List<?>)Arrays.asList(var3_3));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bindDynamic(Class<T> type, Constructor<?> bootstrapMethod, List<?> constants) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.bindDynamic((Class<T>)var1_1, (MethodDescription.InDefinedShape)new MethodDescription.ForLoadedConstructor((Constructor<?>)var2_2), (List<?>)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bindDynamic(Class<T> type, MethodDescription.InDefinedShape bootstrapMethod, Object ... constant) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.bindDynamic((Class<T>)var1_1, (MethodDescription.InDefinedShape)var2_2, (List<?>)Arrays.asList(var3_3));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bindDynamic(Class<T> type, MethodDescription.InDefinedShape bootstrapMethod, List<?> constants) {
            void var3_3;
            void var2_2;
            void var1_1;
            List<JavaConstant> arguments = JavaConstant.Simple.wrap(constants);
            if (!bootstrapMethod.isInvokeBootstrap(TypeList.Explicit.of(arguments))) {
                throw new IllegalArgumentException("Not a valid bootstrap method " + bootstrapMethod + " for " + arguments);
            }
            return this.bind(new OffsetMapping.ForStackManipulation.OfDynamicInvocation(var1_1, (MethodDescription.InDefinedShape)var2_2, (List<? extends JavaConstant>)((List<JavaConstant>)((List<? extends JavaConstant>)var3_3))));
        }

        /*
         * WARNING - void declaration
         */
        public <T extends Annotation> WithCustomMapping bind(Class<T> type, OffsetMapping offsetMapping) {
            void var2_2;
            void var1_1;
            return this.bind(new OffsetMapping.Factory.Simple(var1_1, (OffsetMapping)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public WithCustomMapping bind(OffsetMapping.Factory<?> offsetMapping) {
            void var2_2;
            LinkedHashMap offsetMappings = new LinkedHashMap(this.offsetMappings);
            if (!offsetMapping.getAnnotationType().isAnnotation()) {
                throw new IllegalArgumentException("Not an annotation type: " + offsetMapping.getAnnotationType());
            }
            if (offsetMappings.put(offsetMapping.getAnnotationType(), offsetMapping) != null) {
                void var1_1;
                throw new IllegalArgumentException("Annotation type already mapped: " + var1_1.getAnnotationType());
            }
            return new WithCustomMapping(this.postProcessorFactory, (Map<Class<? extends Annotation>, OffsetMapping.Factory<?>>)var2_2, this.delegatorFactory, this.classReaderFactory);
        }

        /*
         * WARNING - void declaration
         */
        public WithCustomMapping bootstrap(Constructor<?> constructor) {
            void var1_1;
            return this.bootstrap(new MethodDescription.ForLoadedConstructor((Constructor<?>)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public WithCustomMapping bootstrap(Constructor<?> constructor, BootstrapArgumentResolver.Factory resolverFactory) {
            void var2_2;
            void var1_1;
            return this.bootstrap(new MethodDescription.ForLoadedConstructor((Constructor<?>)var1_1), (BootstrapArgumentResolver.Factory)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public WithCustomMapping bootstrap(Method method) {
            void var1_1;
            return this.bootstrap(new MethodDescription.ForLoadedMethod((Method)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public WithCustomMapping bootstrap(Method method, BootstrapArgumentResolver.Factory resolver) {
            void var2_2;
            void var1_1;
            return this.bootstrap(new MethodDescription.ForLoadedMethod((Method)var1_1), (BootstrapArgumentResolver.Factory)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public WithCustomMapping bootstrap(Method method, BootstrapArgumentResolver.Factory resolver, TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.bootstrap(new MethodDescription.ForLoadedMethod((Method)var1_1), (BootstrapArgumentResolver.Factory)var2_2, (TypeDescription.Generic.Visitor<? extends TypeDescription.Generic>)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public WithCustomMapping bootstrap(MethodDescription.InDefinedShape bootstrap) {
            void var1_1;
            return this.bootstrap((MethodDescription.InDefinedShape)var1_1, (BootstrapArgumentResolver.Factory)BootstrapArgumentResolver.ForDefaultValues.Factory.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        public WithCustomMapping bootstrap(MethodDescription.InDefinedShape bootstrap, BootstrapArgumentResolver.Factory resolverFactory) {
            void var2_2;
            void var1_1;
            return this.bootstrap((MethodDescription.InDefinedShape)var1_1, (BootstrapArgumentResolver.Factory)var2_2, (TypeDescription.Generic.Visitor<? extends TypeDescription.Generic>)TypeDescription.Generic.Visitor.NoOp.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        public WithCustomMapping bootstrap(MethodDescription.InDefinedShape bootstrap, BootstrapArgumentResolver.Factory resolverFactory, TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new WithCustomMapping(this.postProcessorFactory, this.offsetMappings, Delegator.ForDynamicInvocation.of((MethodDescription.InDefinedShape)var1_1, (BootstrapArgumentResolver.Factory)var2_2, (TypeDescription.Generic.Visitor<? extends TypeDescription.Generic>)var3_3), this.classReaderFactory);
        }

        /*
         * WARNING - void declaration
         */
        public WithCustomMapping with(PostProcessor.Factory postProcessorFactory) {
            void var1_1;
            return new WithCustomMapping(new PostProcessor.Factory.Compound(new PostProcessor.Factory[]{this.postProcessorFactory, var1_1}), this.offsetMappings, this.delegatorFactory, this.classReaderFactory);
        }

        /*
         * WARNING - void declaration
         */
        public WithCustomMapping with(AsmClassReader.Factory classReaderFactory) {
            void var1_1;
            return new WithCustomMapping(this.postProcessorFactory, this.offsetMappings, this.delegatorFactory, (AsmClassReader.Factory)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public Advice to(Class<?> advice) {
            void var1_1;
            void v0 = var1_1;
            return this.to((Class<?>)v0, ClassFileLocator.ForClassLoader.of(v0.getClassLoader()));
        }

        /*
         * WARNING - void declaration
         */
        public Advice to(Class<?> advice, ClassFileLocator classFileLocator) {
            void var2_2;
            void var1_1;
            return this.to(TypeDescription.ForLoadedType.of(var1_1), (ClassFileLocator)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public Advice to(TypeDescription advice, ClassFileLocator classFileLocator) {
            void var2_2;
            return Advice.to(advice, this.postProcessorFactory, (ClassFileLocator)var2_2, new ArrayList(this.offsetMappings.values()), this.delegatorFactory, this.classReaderFactory);
        }

        /*
         * WARNING - void declaration
         */
        public Advice to(Class<?> enterAdvice, Class<?> exitAdvice) {
            void var3_3;
            ClassLoader exitLoader;
            void var2_2;
            void var1_1;
            ClassLoader enterLoader = enterAdvice.getClassLoader();
            return this.to((Class<?>)var1_1, (Class<?>)var2_2, enterLoader == (exitLoader = exitAdvice.getClassLoader()) ? ClassFileLocator.ForClassLoader.of(enterLoader) : new ClassFileLocator.Compound(ClassFileLocator.ForClassLoader.of((ClassLoader)var3_3), ClassFileLocator.ForClassLoader.of(exitLoader)));
        }

        /*
         * WARNING - void declaration
         */
        public Advice to(Class<?> enterAdvice, Class<?> exitAdvice, ClassFileLocator classFileLocator) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.to(TypeDescription.ForLoadedType.of(var1_1), TypeDescription.ForLoadedType.of(var2_2), (ClassFileLocator)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice) {
            void var2_2;
            void var1_1;
            return this.to((TypeDescription)var1_1, (TypeDescription)var2_2, (ClassFileLocator)ClassFileLocator.NoOp.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        public Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice, ClassFileLocator classFileLocator) {
            void var3_3;
            void var2_2;
            return Advice.to(enterAdvice, (TypeDescription)var2_2, this.postProcessorFactory, (ClassFileLocator)var3_3, new ArrayList(this.offsetMappings.values()), this.delegatorFactory, this.classReaderFactory);
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.postProcessorFactory.equals(((WithCustomMapping)object).postProcessorFactory)) {
                return false;
            }
            if (!this.delegatorFactory.equals(((WithCustomMapping)object).delegatorFactory)) {
                return false;
            }
            if (!this.classReaderFactory.equals(((WithCustomMapping)object).classReaderFactory)) {
                return false;
            }
            return ((Object)this.offsetMappings).equals(((WithCustomMapping)object).offsetMappings);
        }

        public int hashCode() {
            return (((this.getClass().hashCode() * 31 + this.postProcessorFactory.hashCode()) * 31 + this.delegatorFactory.hashCode()) * 31 + this.classReaderFactory.hashCode()) * 31 + ((Object)this.offsetMappings).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static abstract class AssignReturned
    implements PostProcessor {
        public static final int NO_INDEX = -1;
        protected final TypeDescription typeDescription;
        protected final ExceptionHandler.Factory exceptionHandlerFactory;
        protected final boolean exit;
        protected final boolean skipOnDefaultValue;

        /*
         * WARNING - void declaration
         */
        protected AssignReturned(TypeDescription typeDescription, ExceptionHandler.Factory exceptionHandlerFactory, boolean exit, boolean skipOnDefaultValue) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.typeDescription = var1_1;
            this.exceptionHandlerFactory = var2_2;
            this.exit = var3_3;
            this.skipOnDefaultValue = skipOnDefaultValue;
        }

        @Override
        public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, StackMapFrameHandler.ForPostProcessor stackMapFrameHandler, StackManipulation exceptionHandler) {
            ArrayList<StackManipulation> stackManipulations = new ArrayList<StackManipulation>(this.getHandlers().size());
            for (Handler handler : this.getHandlers()) {
                stackManipulations.add(handler.resolve(instrumentedType, instrumentedMethod, assigner, argumentHandler, this.getType(), this.toLoadInstruction(handler, this.exit ? argumentHandler.exit() : argumentHandler.enter())));
            }
            StackManipulation stackManipulation = this.exceptionHandlerFactory.wrap(new StackManipulation.Compound(stackManipulations), exceptionHandler, stackMapFrameHandler);
            if (this.skipOnDefaultValue) {
                return DefaultValueSkip.of(stackManipulation, stackMapFrameHandler, this.exit ? argumentHandler.exit() : argumentHandler.enter(), this.typeDescription);
            }
            return stackManipulation;
        }

        protected abstract TypeDescription getType();

        protected abstract Collection<Handler> getHandlers();

        protected abstract StackManipulation toLoadInstruction(Handler var1, int var2);

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (this.exit != ((AssignReturned)object).exit) {
                return false;
            }
            if (this.skipOnDefaultValue != ((AssignReturned)object).skipOnDefaultValue) {
                return false;
            }
            if (!this.typeDescription.equals(((AssignReturned)object).typeDescription)) {
                return false;
            }
            return this.exceptionHandlerFactory.equals(((AssignReturned)object).exceptionHandlerFactory);
        }

        public int hashCode() {
            return (((this.getClass().hashCode() * 31 + this.typeDescription.hashCode()) * 31 + this.exceptionHandlerFactory.hashCode()) * 31 + this.exit) * 31 + this.skipOnDefaultValue;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class Factory
        implements PostProcessor.Factory {
            private static final MethodDescription.InDefinedShape SKIP_ON_DEFAULT_VALUE = (MethodDescription.InDefinedShape)((MethodList)TypeDescription.ForLoadedType.of(AsScalar.class).getDeclaredMethods().filter(ElementMatchers.named("skipOnDefaultValue"))).getOnly();
            private final List<? extends Handler.Factory<?>> factories;
            private final ExceptionHandler.Factory exceptionHandlerFactory;

            public Factory() {
                this(Arrays.asList(ToArguments.Handler.Factory.INSTANCE, ToAllArguments.Handler.Factory.INSTANCE, ToThis.Handler.Factory.INSTANCE, ToFields.Handler.Factory.INSTANCE, ToReturned.Handler.Factory.INSTANCE, ToThrown.Handler.Factory.INSTANCE), ExceptionHandler.Factory.NoOp.INSTANCE);
            }

            /*
             * WARNING - void declaration
             */
            protected Factory(List<? extends Handler.Factory<?>> factories, ExceptionHandler.Factory exceptionHandlerFactory) {
                void var2_2;
                void var1_1;
                this.factories = var1_1;
                this.exceptionHandlerFactory = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            public Factory with(Class<? extends Annotation> type, Handler ... handler) {
                void var2_2;
                void var1_1;
                return this.with((Class<? extends Annotation>)var1_1, Arrays.asList(var2_2));
            }

            /*
             * WARNING - void declaration
             */
            public Factory with(Class<? extends Annotation> type, List<Handler> handlers) {
                void var2_2;
                void var1_1;
                return this.with(new Handler.Factory.Simple(var1_1, (List<Handler>)var2_2));
            }

            /*
             * WARNING - void declaration
             */
            public Factory with(Handler.Factory<?> factory) {
                void var1_1;
                return new Factory(CompoundList.of(this.factories, var1_1), this.exceptionHandlerFactory);
            }

            /*
             * WARNING - void declaration
             */
            public PostProcessor.Factory withSuppressed(Class<? extends Throwable> exceptionType) {
                void var1_1;
                return this.withSuppressed(TypeDescription.ForLoadedType.of(var1_1));
            }

            /*
             * WARNING - void declaration
             */
            public PostProcessor.Factory withSuppressed(TypeDescription exceptionType) {
                void var1_1;
                if (!exceptionType.isAssignableTo(Throwable.class)) {
                    throw new IllegalArgumentException(exceptionType + " is not a throwable type");
                }
                return new Factory(this.factories, new ExceptionHandler.Factory.Enabled((TypeDescription)var1_1));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public PostProcessor make(List<? extends AnnotationDescription> annotations, TypeDescription returnType, boolean exit) {
                void var3_3;
                void var2_2;
                Iterator iterator;
                if (returnType.represents(Void.TYPE)) {
                    return PostProcessor.NoOp.INSTANCE;
                }
                HashMap factories = new HashMap();
                for (Handler.Factory<?> factory : this.factories) {
                    if (factories.put(factory.getAnnotationType().getName(), factory) == null) continue;
                    throw new IllegalStateException("Duplicate registration of handler for " + factory.getAnnotationType());
                }
                LinkedHashMap handlers = new LinkedHashMap();
                boolean scalar = false;
                boolean skipOnDefaultValue = true;
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    AnnotationDescription annotation = (AnnotationDescription)iterator.next();
                    if (annotation.getAnnotationType().represents((java.lang.reflect.Type)((Object)AsScalar.class))) {
                        scalar = true;
                        skipOnDefaultValue = annotation.getValue(SKIP_ON_DEFAULT_VALUE).resolve(Boolean.class);
                        continue;
                    }
                    Handler.Factory factory = (Handler.Factory)factories.get(annotation.getAnnotationType().getName());
                    if (factory == null || handlers.put(factory.getAnnotationType(), factory.make(returnType, exit, annotation.prepare(factory.getAnnotationType()))) == null) continue;
                    throw new IllegalStateException("Duplicate handler registration for " + annotation.getAnnotationType());
                }
                if (handlers.isEmpty()) {
                    return PostProcessor.NoOp.INSTANCE;
                }
                if (!scalar && returnType.isArray()) {
                    return new ForArray(returnType, this.exceptionHandlerFactory, exit, handlers.values());
                }
                return new ForScalar((TypeDescription)var2_2, this.exceptionHandlerFactory, (boolean)var3_3, skipOnDefaultValue, handlers.values());
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!((Object)this.factories).equals(((Factory)object).factories)) {
                    return false;
                }
                return this.exceptionHandlerFactory.equals(((Factory)object).exceptionHandlerFactory);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + ((Object)this.factories).hashCode()) * 31 + this.exceptionHandlerFactory.hashCode();
            }
        }

        public static interface Handler {
            public int getIndex();

            public StackManipulation resolve(TypeDescription var1, MethodDescription var2, Assigner var3, ArgumentHandler var4, TypeDescription var5, StackManipulation var6);

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static interface Factory<T extends Annotation> {
                public Class<T> getAnnotationType();

                public List<Handler> make(TypeDescription var1, boolean var2, AnnotationDescription.Loadable<? extends T> var3);

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                public static class Simple<S extends Annotation>
                implements Factory<S> {
                    private final Class<S> type;
                    private final List<Handler> handlers;

                    /*
                     * WARNING - void declaration
                     */
                    public Simple(Class<S> type, List<Handler> handlers) {
                        void var2_2;
                        void var1_1;
                        this.type = var1_1;
                        this.handlers = var2_2;
                    }

                    @Override
                    public Class<S> getAnnotationType() {
                        return this.type;
                    }

                    @Override
                    public List<Handler> make(TypeDescription returnType, boolean exit, AnnotationDescription.Loadable<? extends S> annotation) {
                        return this.handlers;
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (!this.type.equals(((Simple)object).type)) {
                            return false;
                        }
                        return ((Object)this.handlers).equals(((Simple)object).handlers);
                    }

                    public int hashCode() {
                        return (this.getClass().hashCode() * 31 + this.type.hashCode()) * 31 + ((Object)this.handlers).hashCode();
                    }
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        protected static class ExceptionHandler
        implements StackManipulation {
            private final StackManipulation stackManipulation;
            private final StackManipulation exceptionHandler;
            private final TypeDescription exceptionType;
            private final StackMapFrameHandler.ForPostProcessor stackMapFrameHandler;

            /*
             * WARNING - void declaration
             */
            protected ExceptionHandler(StackManipulation stackManipulation, StackManipulation exceptionHandler, TypeDescription exceptionType, StackMapFrameHandler.ForPostProcessor stackMapFrameHandler) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.stackManipulation = var1_1;
                this.exceptionHandler = var2_2;
                this.exceptionType = var3_3;
                this.stackMapFrameHandler = stackMapFrameHandler;
            }

            public boolean isValid() {
                return this.stackManipulation.isValid() && this.exceptionHandler.isValid();
            }

            /*
             * WARNING - void declaration
             */
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                void var3_3;
                void var1_1;
                void var2_2;
                Label start = new Label();
                Label handler = new Label();
                Label end = new Label();
                Label label = handler;
                methodVisitor.visitTryCatchBlock(start, label, label, this.exceptionType.getInternalName());
                methodVisitor.visitLabel(start);
                StackManipulation.Size size = this.stackManipulation.apply(methodVisitor, implementationContext);
                methodVisitor.visitJumpInsn(167, end);
                methodVisitor.visitLabel(handler);
                this.stackMapFrameHandler.injectIntermediateFrame(methodVisitor, Collections.singletonList(this.exceptionType));
                size = this.exceptionHandler.apply(methodVisitor, (Implementation.Context)var2_2).aggregate(size);
                methodVisitor.visitLabel(end);
                this.stackMapFrameHandler.injectIntermediateFrame((MethodVisitor)var1_1, Collections.emptyList());
                return var3_3;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.stackManipulation.equals(((ExceptionHandler)object).stackManipulation)) {
                    return false;
                }
                if (!this.exceptionHandler.equals(((ExceptionHandler)object).exceptionHandler)) {
                    return false;
                }
                if (!this.exceptionType.equals(((ExceptionHandler)object).exceptionType)) {
                    return false;
                }
                return this.stackMapFrameHandler.equals(((ExceptionHandler)object).stackMapFrameHandler);
            }

            public int hashCode() {
                return (((this.getClass().hashCode() * 31 + this.stackManipulation.hashCode()) * 31 + this.exceptionHandler.hashCode()) * 31 + this.exceptionType.hashCode()) * 31 + this.stackMapFrameHandler.hashCode();
            }

            public static interface Factory {
                public StackManipulation wrap(StackManipulation var1, StackManipulation var2, StackMapFrameHandler.ForPostProcessor var3);

                @HashCodeAndEqualsPlugin.Enhance
                public static class Enabled
                implements Factory {
                    private final TypeDescription exceptionType;

                    /*
                     * WARNING - void declaration
                     */
                    protected Enabled(TypeDescription exceptionType) {
                        void var1_1;
                        this.exceptionType = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public StackManipulation wrap(StackManipulation stackManipulation, StackManipulation exceptionHandler, StackMapFrameHandler.ForPostProcessor stackMapFrameHandler) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        return new ExceptionHandler((StackManipulation)var1_1, (StackManipulation)var2_2, this.exceptionType, (StackMapFrameHandler.ForPostProcessor)var3_3);
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        return this.exceptionType.equals(((Enabled)object).exceptionType);
                    }

                    public int hashCode() {
                        return this.getClass().hashCode() * 31 + this.exceptionType.hashCode();
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static enum NoOp implements Factory
                {
                    INSTANCE;


                    @Override
                    public final StackManipulation wrap(StackManipulation stackManipulation, StackManipulation exceptionHandler, StackMapFrameHandler.ForPostProcessor stackMapFrameHandler) {
                        return stackManipulation;
                    }
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        protected static class DefaultValueSkip
        implements StackManipulation {
            private final StackManipulation stackManipulation;
            private final StackMapFrameHandler.ForPostProcessor stackMapFrameHandler;
            private final int offset;
            private final Dispatcher dispatcher;

            /*
             * WARNING - void declaration
             */
            protected DefaultValueSkip(StackManipulation stackManipulation, StackMapFrameHandler.ForPostProcessor stackMapFrameHandler, int offset, Dispatcher dispatcher) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.stackManipulation = var1_1;
                this.stackMapFrameHandler = var2_2;
                this.offset = var3_3;
                this.dispatcher = dispatcher;
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected static StackManipulation of(StackManipulation stackManipulation, StackMapFrameHandler.ForPostProcessor stackMapFrameHandler, int offset, TypeDefinition typeDefinition) {
                void var3_3;
                void var2_2;
                void var1_1;
                StackManipulation stackManipulation2;
                Dispatcher dispatcher;
                if (typeDefinition.isPrimitive()) {
                    if (typeDefinition.represents(Boolean.TYPE) || typeDefinition.represents(Byte.TYPE) || typeDefinition.represents(Short.TYPE) || typeDefinition.represents(Character.TYPE) || typeDefinition.represents(Integer.TYPE)) {
                        dispatcher = Dispatcher.INTEGER;
                        return new DefaultValueSkip(stackManipulation2, (StackMapFrameHandler.ForPostProcessor)var1_1, (int)var2_2, (Dispatcher)var3_3);
                    } else if (dispatcher.represents(Long.TYPE)) {
                        dispatcher = Dispatcher.LONG;
                        return new DefaultValueSkip(stackManipulation2, (StackMapFrameHandler.ForPostProcessor)var1_1, (int)var2_2, (Dispatcher)var3_3);
                    } else if (dispatcher.represents(Float.TYPE)) {
                        dispatcher = Dispatcher.FLOAT;
                        return new DefaultValueSkip(stackManipulation2, (StackMapFrameHandler.ForPostProcessor)var1_1, (int)var2_2, (Dispatcher)var3_3);
                    } else {
                        if (!dispatcher.represents(Double.TYPE)) throw new IllegalArgumentException("Cannot apply skip for " + (Object)((Object)dispatcher));
                        dispatcher = Dispatcher.DOUBLE;
                    }
                    return new DefaultValueSkip(stackManipulation2, (StackMapFrameHandler.ForPostProcessor)var1_1, (int)var2_2, (Dispatcher)var3_3);
                } else {
                    dispatcher = Dispatcher.REFERENCE;
                }
                return new DefaultValueSkip(stackManipulation2, (StackMapFrameHandler.ForPostProcessor)var1_1, (int)var2_2, (Dispatcher)var3_3);
            }

            public boolean isValid() {
                return this.stackManipulation.isValid();
            }

            /*
             * WARNING - void declaration
             */
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                void var2_2;
                void var1_1;
                void var3_3;
                Label label = new Label();
                StackManipulation.Size size = this.dispatcher.apply(methodVisitor, this.offset, label).aggregate(this.stackManipulation.apply(methodVisitor, implementationContext));
                methodVisitor.visitInsn(0);
                methodVisitor.visitLabel((Label)var3_3);
                this.stackMapFrameHandler.injectIntermediateFrame(methodVisitor, Collections.emptyList());
                var1_1.visitInsn(0);
                return var2_2;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (this.offset != ((DefaultValueSkip)object).offset) {
                    return false;
                }
                if (!this.dispatcher.equals((Object)((DefaultValueSkip)object).dispatcher)) {
                    return false;
                }
                if (!this.stackManipulation.equals(((DefaultValueSkip)object).stackManipulation)) {
                    return false;
                }
                return this.stackMapFrameHandler.equals(((DefaultValueSkip)object).stackMapFrameHandler);
            }

            public int hashCode() {
                return (((this.getClass().hashCode() * 31 + this.stackManipulation.hashCode()) * 31 + this.stackMapFrameHandler.hashCode()) * 31 + this.offset) * 31 + this.dispatcher.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static enum Dispatcher {
                INTEGER{

                    /*
                     * WARNING - void declaration
                     */
                    protected final StackManipulation.Size apply(MethodVisitor methodVisitor, int offset, Label label) {
                        void var3_3;
                        void var1_1;
                        void var2_2;
                        methodVisitor.visitVarInsn(21, (int)var2_2);
                        var1_1.visitJumpInsn(153, (Label)var3_3);
                        return new StackManipulation.Size(0, 1);
                    }
                }
                ,
                LONG{

                    /*
                     * WARNING - void declaration
                     */
                    protected final StackManipulation.Size apply(MethodVisitor methodVisitor, int offset, Label label) {
                        void var3_3;
                        void var1_1;
                        void var2_2;
                        methodVisitor.visitVarInsn(22, (int)var2_2);
                        methodVisitor.visitInsn(9);
                        methodVisitor.visitInsn(148);
                        var1_1.visitJumpInsn(153, (Label)var3_3);
                        return new StackManipulation.Size(0, 4);
                    }
                }
                ,
                FLOAT{

                    /*
                     * WARNING - void declaration
                     */
                    protected final StackManipulation.Size apply(MethodVisitor methodVisitor, int offset, Label label) {
                        void var3_3;
                        void var1_1;
                        void var2_2;
                        methodVisitor.visitVarInsn(23, (int)var2_2);
                        methodVisitor.visitInsn(11);
                        methodVisitor.visitInsn(149);
                        var1_1.visitJumpInsn(153, (Label)var3_3);
                        return new StackManipulation.Size(0, 2);
                    }
                }
                ,
                DOUBLE{

                    /*
                     * WARNING - void declaration
                     */
                    protected final StackManipulation.Size apply(MethodVisitor methodVisitor, int offset, Label label) {
                        void var3_3;
                        void var1_1;
                        void var2_2;
                        methodVisitor.visitVarInsn(24, (int)var2_2);
                        methodVisitor.visitInsn(14);
                        methodVisitor.visitInsn(151);
                        var1_1.visitJumpInsn(153, (Label)var3_3);
                        return new StackManipulation.Size(0, 4);
                    }
                }
                ,
                REFERENCE{

                    /*
                     * WARNING - void declaration
                     */
                    protected final StackManipulation.Size apply(MethodVisitor methodVisitor, int offset, Label label) {
                        void var3_3;
                        void var1_1;
                        void var2_2;
                        methodVisitor.visitVarInsn(25, (int)var2_2);
                        var1_1.visitJumpInsn(198, (Label)var3_3);
                        return new StackManipulation.Size(0, 2);
                    }
                };


                protected abstract StackManipulation.Size apply(MethodVisitor var1, int var2, Label var3);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class ForScalar
        extends AssignReturned {
            private final List<Handler> handlers = new ArrayList<Handler>();

            /*
             * WARNING - void declaration
             */
            protected ForScalar(TypeDescription typeDescription, ExceptionHandler.Factory exceptionHandlerFactory, boolean exit, boolean skipOnDefaultValue, Collection<List<Handler>> handlers) {
                super((TypeDescription)((Object)iterator), (ExceptionHandler.Factory)object2, (boolean)exit, (boolean)skipOnDefaultValue);
                void object2;
                Iterator iterator;
                for (List list : handlers) {
                    for (Handler handler : list) {
                        void var3_7;
                        int n = handler.getIndex();
                        if (n >= 0) {
                            throw new IllegalStateException("Handler on array requires negative index for " + handler);
                        }
                        this.handlers.add((Handler)var3_7);
                    }
                }
            }

            @Override
            protected TypeDescription getType() {
                return this.typeDescription;
            }

            @Override
            protected Collection<Handler> getHandlers() {
                return this.handlers;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected StackManipulation toLoadInstruction(Handler handler, int offset) {
                void var2_2;
                return MethodVariableAccess.of(this.typeDescription).loadFrom((int)var2_2);
            }

            @Override
            public boolean equals(@MaybeNull Object object) {
                if (!super.equals(object)) {
                    return false;
                }
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return ((Object)this.handlers).equals(((ForScalar)object).handlers);
            }

            @Override
            public int hashCode() {
                return super.hashCode() * 31 + ((Object)this.handlers).hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class ForArray
        extends AssignReturned {
            private final Map<Handler, Integer> handlers = new LinkedHashMap<Handler, Integer>();

            /*
             * WARNING - void declaration
             */
            protected ForArray(TypeDescription typeDescription, ExceptionHandler.Factory exceptionHandlerFactory, boolean exit, Collection<List<Handler>> handlers) {
                super((TypeDescription)((Object)iterator), (ExceptionHandler.Factory)object2, (boolean)exit, true);
                void object2;
                Iterator iterator;
                for (List list : handlers) {
                    for (Handler handler : list) {
                        void var3_7;
                        int index = handler.getIndex();
                        if (index < 0) {
                            throw new IllegalStateException("Handler on array requires positive index for " + handler);
                        }
                        this.handlers.put((Handler)var3_7, index);
                    }
                }
            }

            @Override
            @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming component type for array type.")
            protected TypeDescription getType() {
                return this.typeDescription.getComponentType();
            }

            @Override
            protected Collection<Handler> getHandlers() {
                return this.handlers.keySet();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming component type for array type.")
            protected StackManipulation toLoadInstruction(Handler handler, int offset) {
                void var1_1;
                void var2_2;
                return new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadFrom((int)var2_2), IntegerConstant.forValue(this.handlers.get(var1_1)), ArrayAccess.of(this.typeDescription.getComponentType()).load());
            }

            @Override
            public boolean equals(@MaybeNull Object object) {
                if (!super.equals(object)) {
                    return false;
                }
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return ((Object)this.handlers).equals(((ForArray)object).handlers);
            }

            @Override
            public int hashCode() {
                return super.hashCode() * 31 + ((Object)this.handlers).hashCode();
            }
        }

        @Documented
        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.METHOD})
        public static @interface ToThrown {
            public int index() default -1;

            public Assigner.Typing typing() default Assigner.Typing.STATIC;

            @HashCodeAndEqualsPlugin.Enhance
            public static class Handler
            implements net.bytebuddy.asm.Advice$AssignReturned$Handler {
                private final int index;
                private final Assigner.Typing typing;

                /*
                 * WARNING - void declaration
                 */
                protected Handler(int index, Assigner.Typing typing) {
                    void var2_2;
                    void var1_1;
                    this.index = var1_1;
                    this.typing = var2_2;
                }

                public int getIndex() {
                    return this.index;
                }

                /*
                 * WARNING - void declaration
                 */
                public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, TypeDescription type, StackManipulation value) {
                    void var1_1;
                    StackManipulation assignment = assigner.assign(type.asGenericType(), TypeDefinition.Sort.describe(Throwable.class), this.typing);
                    if (!assignment.isValid()) {
                        throw new IllegalStateException("Cannot assign " + type + " to " + Throwable.class.getName());
                    }
                    return new StackManipulation.Compound(new StackManipulation[]{value, var1_1, MethodVariableAccess.REFERENCE.storeAt(argumentHandler.thrown())});
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (this.index != ((Handler)object).index) {
                        return false;
                    }
                    return this.typing.equals((Object)((Handler)object).typing);
                }

                public int hashCode() {
                    return (this.getClass().hashCode() * 31 + this.index) * 31 + this.typing.hashCode();
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static final class Factory
                extends Enum<Factory>
                implements net.bytebuddy.asm.Advice$AssignReturned$Handler$Factory<ToThrown> {
                    public static final /* enum */ Factory INSTANCE;
                    private static final MethodDescription.InDefinedShape TO_THROWN_INDEX;
                    private static final MethodDescription.InDefinedShape TO_THROWN_TYPING;
                    private static final /* synthetic */ Factory[] $VALUES;

                    public static Factory[] values() {
                        return (Factory[])$VALUES.clone();
                    }

                    public static Factory valueOf(String name) {
                        String string;
                        return Enum.valueOf(Factory.class, string);
                    }

                    @Override
                    public final Class<ToThrown> getAnnotationType() {
                        return ToThrown.class;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming annotation for exit advice.")
                    public final List<net.bytebuddy.asm.Advice$AssignReturned$Handler> make(TypeDescription returnType, boolean exit, AnnotationDescription.Loadable<? extends ToThrown> annotation) {
                        void var3_3;
                        if (!exit) {
                            void var1_1;
                            throw new IllegalStateException("Cannot assign thrown value from enter advice for " + var1_1);
                        }
                        return Collections.singletonList(new Handler(annotation.getValue(TO_THROWN_INDEX).resolve(Integer.class), var3_3.getValue(TO_THROWN_TYPING).resolve(EnumerationDescription.class).load(Assigner.Typing.class)));
                    }

                    /*
                     * WARNING - void declaration
                     */
                    static {
                        void var0;
                        INSTANCE = new Factory();
                        $VALUES = new Factory[]{INSTANCE};
                        MethodList<MethodDescription.InDefinedShape> methods = TypeDescription.ForLoadedType.of(ToThrown.class).getDeclaredMethods();
                        TO_THROWN_INDEX = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("index"))).getOnly();
                        TO_THROWN_TYPING = (MethodDescription.InDefinedShape)((MethodList)var0.filter(ElementMatchers.named("typing"))).getOnly();
                    }
                }
            }
        }

        @Documented
        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.METHOD})
        public static @interface ToReturned {
            public int index() default -1;

            public Assigner.Typing typing() default Assigner.Typing.STATIC;

            @HashCodeAndEqualsPlugin.Enhance
            public static class Handler
            implements net.bytebuddy.asm.Advice$AssignReturned$Handler {
                private final int index;
                private final Assigner.Typing typing;

                /*
                 * WARNING - void declaration
                 */
                protected Handler(int index, Assigner.Typing typing) {
                    void var2_2;
                    void var1_1;
                    this.index = var1_1;
                    this.typing = var2_2;
                }

                public int getIndex() {
                    return this.index;
                }

                /*
                 * WARNING - void declaration
                 */
                public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, TypeDescription type, StackManipulation value) {
                    void var2_2;
                    void var1_1;
                    void var3_3;
                    if (instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                        return StackManipulation.Trivial.INSTANCE;
                    }
                    StackManipulation assignment = var3_3.assign(type.asGenericType(), instrumentedMethod.getReturnType(), this.typing);
                    if (!assignment.isValid()) {
                        throw new IllegalStateException("Cannot assign " + type + " to " + instrumentedMethod.getReturnType());
                    }
                    return new StackManipulation.Compound(new StackManipulation[]{value, var1_1, MethodVariableAccess.of(var2_2.getReturnType()).storeAt(argumentHandler.returned())});
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (this.index != ((Handler)object).index) {
                        return false;
                    }
                    return this.typing.equals((Object)((Handler)object).typing);
                }

                public int hashCode() {
                    return (this.getClass().hashCode() * 31 + this.index) * 31 + this.typing.hashCode();
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static final class Factory
                extends Enum<Factory>
                implements net.bytebuddy.asm.Advice$AssignReturned$Handler$Factory<ToReturned> {
                    public static final /* enum */ Factory INSTANCE;
                    private static final MethodDescription.InDefinedShape TO_RETURNED_INDEX;
                    private static final MethodDescription.InDefinedShape TO_RETURNED_TYPING;
                    private static final /* synthetic */ Factory[] $VALUES;

                    public static Factory[] values() {
                        return (Factory[])$VALUES.clone();
                    }

                    public static Factory valueOf(String name) {
                        String string;
                        return Enum.valueOf(Factory.class, string);
                    }

                    @Override
                    public final Class<ToReturned> getAnnotationType() {
                        return ToReturned.class;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final List<net.bytebuddy.asm.Advice$AssignReturned$Handler> make(TypeDescription returnType, boolean exit, AnnotationDescription.Loadable<? extends ToReturned> annotation) {
                        void var3_3;
                        if (!exit) {
                            void var1_1;
                            throw new IllegalStateException("Cannot write returned value from enter advice for " + var1_1);
                        }
                        return Collections.singletonList(new Handler(annotation.getValue(TO_RETURNED_INDEX).resolve(Integer.class), var3_3.getValue(TO_RETURNED_TYPING).resolve(EnumerationDescription.class).load(Assigner.Typing.class)));
                    }

                    /*
                     * WARNING - void declaration
                     */
                    static {
                        void var0;
                        INSTANCE = new Factory();
                        $VALUES = new Factory[]{INSTANCE};
                        MethodList<MethodDescription.InDefinedShape> methods = TypeDescription.ForLoadedType.of(ToReturned.class).getDeclaredMethods();
                        TO_RETURNED_INDEX = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("index"))).getOnly();
                        TO_RETURNED_TYPING = (MethodDescription.InDefinedShape)((MethodList)var0.filter(ElementMatchers.named("typing"))).getOnly();
                    }
                }
            }
        }

        @Documented
        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.METHOD})
        public static @interface ToFields {
            public ToField[] value();

            @HashCodeAndEqualsPlugin.Enhance
            public static class Handler
            implements net.bytebuddy.asm.Advice$AssignReturned$Handler {
                private final int index;
                private final String name;
                private final TypeDescription declaringType;
                private final Assigner.Typing typing;

                /*
                 * WARNING - void declaration
                 */
                protected Handler(int index, String name, TypeDescription declaringType, Assigner.Typing typing) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.index = var1_1;
                    this.name = var2_2;
                    this.declaringType = var3_3;
                    this.typing = typing;
                }

                public int getIndex() {
                    return this.index;
                }

                /*
                 * WARNING - void declaration
                 */
                @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming component type for array type.")
                public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, TypeDescription type, StackManipulation value) {
                    void var2_2;
                    void var1_1;
                    void var3_3;
                    StackManipulation stackManipulation;
                    FieldLocator.AbstractBase locator = this.declaringType.represents(Void.TYPE) ? new FieldLocator.ForClassHierarchy(instrumentedType) : new FieldLocator.ForExactType(this.declaringType);
                    FieldLocator.Resolution resolution = this.name.equals("") ? FieldLocator.Resolution.Simple.ofBeanAccessor(locator, instrumentedMethod) : locator.locate(this.name);
                    if (!resolution.isResolved()) {
                        throw new IllegalStateException("Cannot resolve field " + this.name + " for " + instrumentedType);
                    }
                    if (!resolution.getField().isVisibleTo(instrumentedType)) {
                        throw new IllegalStateException(resolution.getField() + " is not visible to " + instrumentedType);
                    }
                    if (resolution.getField().isStatic()) {
                        stackManipulation = StackManipulation.Trivial.INSTANCE;
                    } else {
                        if (instrumentedMethod.isStatic()) {
                            throw new IllegalStateException("Cannot access member field " + resolution.getField() + " from static " + instrumentedMethod);
                        }
                        if (!stackManipulation.isAssignableTo(resolution.getField().getDeclaringType().asErasure())) {
                            throw new IllegalStateException(stackManipulation + " does not define " + resolution.getField());
                        }
                        stackManipulation = MethodVariableAccess.loadThis();
                    }
                    StackManipulation assignment = var3_3.assign(type.asGenericType(), resolution.getField().getType(), this.typing);
                    if (!assignment.isValid()) {
                        throw new IllegalStateException("Cannot assign " + type + " to " + resolution.getField());
                    }
                    return new StackManipulation.Compound(new StackManipulation[]{var1_1, value, var2_2, FieldAccess.forField(resolution.getField()).write()});
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (this.index != ((Handler)object).index) {
                        return false;
                    }
                    if (!this.typing.equals((Object)((Handler)object).typing)) {
                        return false;
                    }
                    if (!this.name.equals(((Handler)object).name)) {
                        return false;
                    }
                    return this.declaringType.equals(((Handler)object).declaringType);
                }

                public int hashCode() {
                    return (((this.getClass().hashCode() * 31 + this.index) * 31 + this.name.hashCode()) * 31 + this.declaringType.hashCode()) * 31 + this.typing.hashCode();
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static final class Factory
                extends Enum<Factory>
                implements net.bytebuddy.asm.Advice$AssignReturned$Handler$Factory<ToFields> {
                    public static final /* enum */ Factory INSTANCE;
                    private static final MethodDescription.InDefinedShape TO_FIELDS_VALUE;
                    private static final MethodDescription.InDefinedShape TO_FIELD_VALUE;
                    private static final MethodDescription.InDefinedShape TO_FIELD_INDEX;
                    private static final MethodDescription.InDefinedShape TO_FIELD_DECLARING_TYPE;
                    private static final MethodDescription.InDefinedShape TO_FIELD_TYPING;
                    private static final /* synthetic */ Factory[] $VALUES;

                    public static Factory[] values() {
                        return (Factory[])$VALUES.clone();
                    }

                    public static Factory valueOf(String name) {
                        String string;
                        return Enum.valueOf(Factory.class, string);
                    }

                    @Override
                    public final Class<ToFields> getAnnotationType() {
                        return ToFields.class;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final List<net.bytebuddy.asm.Advice$AssignReturned$Handler> make(TypeDescription returnType, boolean exit, AnnotationDescription.Loadable<? extends ToFields> annotation) {
                        void var1_1;
                        void var3_4;
                        ArrayList<Handler> handlers = new ArrayList<Handler>();
                        for (AnnotationDescription field : var3_4.getValue(TO_FIELDS_VALUE).resolve(AnnotationDescription[].class)) {
                            handlers.add(new Handler(field.getValue(TO_FIELD_INDEX).resolve(Integer.class), field.getValue(TO_FIELD_VALUE).resolve(String.class), field.getValue(TO_FIELD_DECLARING_TYPE).resolve(TypeDescription.class), field.getValue(TO_FIELD_TYPING).resolve(EnumerationDescription.class).load(Assigner.Typing.class)));
                        }
                        return var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    static {
                        void var0;
                        INSTANCE = new Factory();
                        $VALUES = new Factory[]{INSTANCE};
                        TO_FIELDS_VALUE = (MethodDescription.InDefinedShape)((MethodList)TypeDescription.ForLoadedType.of(ToFields.class).getDeclaredMethods().filter(ElementMatchers.named("value"))).getOnly();
                        MethodList<MethodDescription.InDefinedShape> methods = TypeDescription.ForLoadedType.of(ToField.class).getDeclaredMethods();
                        TO_FIELD_VALUE = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("value"))).getOnly();
                        TO_FIELD_INDEX = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("index"))).getOnly();
                        TO_FIELD_DECLARING_TYPE = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("declaringType"))).getOnly();
                        TO_FIELD_TYPING = (MethodDescription.InDefinedShape)((MethodList)var0.filter(ElementMatchers.named("typing"))).getOnly();
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @Target(value={})
            @RepeatedAnnotationPlugin.Enhance(value=ToFields.class)
            @Repeatable(value=ToFields.class)
            public static @interface ToField {
                public String value() default "";

                public Class<?> declaringType() default void.class;

                public int index() default -1;

                public Assigner.Typing typing() default Assigner.Typing.STATIC;
            }
        }

        @Documented
        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.METHOD})
        public static @interface ToThis {
            public int index() default -1;

            public Assigner.Typing typing() default Assigner.Typing.STATIC;

            @HashCodeAndEqualsPlugin.Enhance
            public static class Handler
            implements net.bytebuddy.asm.Advice$AssignReturned$Handler {
                private final int index;
                private final Assigner.Typing typing;
                private final boolean exit;

                /*
                 * WARNING - void declaration
                 */
                protected Handler(int index, Assigner.Typing typing, boolean exit) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.index = var1_1;
                    this.typing = var2_2;
                    this.exit = var3_3;
                }

                public int getIndex() {
                    return this.index;
                }

                /*
                 * WARNING - void declaration
                 */
                public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, TypeDescription type, StackManipulation value) {
                    void var2_2;
                    void var3_3;
                    if (instrumentedMethod.isStatic()) {
                        throw new IllegalStateException("Cannot assign this reference for static method " + instrumentedMethod);
                    }
                    if (!this.exit && instrumentedMethod.isConstructor()) {
                        throw new IllegalStateException("Cannot assign this reference in constructor prior to initialization for " + instrumentedMethod);
                    }
                    StackManipulation assignment = var3_3.assign(type.asGenericType(), instrumentedType.asGenericType(), this.typing);
                    if (!assignment.isValid()) {
                        void var1_1;
                        throw new IllegalStateException("Cannot assign " + type + " to " + var1_1);
                    }
                    return new StackManipulation.Compound(new StackManipulation[]{value, var2_2, MethodVariableAccess.REFERENCE.storeAt(argumentHandler.argument(0))});
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (this.index != ((Handler)object).index) {
                        return false;
                    }
                    if (this.exit != ((Handler)object).exit) {
                        return false;
                    }
                    return this.typing.equals((Object)((Handler)object).typing);
                }

                public int hashCode() {
                    return ((this.getClass().hashCode() * 31 + this.index) * 31 + this.typing.hashCode()) * 31 + this.exit;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static final class Factory
                extends Enum<Factory>
                implements net.bytebuddy.asm.Advice$AssignReturned$Handler$Factory<ToThis> {
                    public static final /* enum */ Factory INSTANCE;
                    private static final MethodDescription.InDefinedShape TO_THIS_INDEX;
                    private static final MethodDescription.InDefinedShape TO_THIS_TYPING;
                    private static final /* synthetic */ Factory[] $VALUES;

                    public static Factory[] values() {
                        return (Factory[])$VALUES.clone();
                    }

                    public static Factory valueOf(String name) {
                        String string;
                        return Enum.valueOf(Factory.class, string);
                    }

                    @Override
                    public final Class<ToThis> getAnnotationType() {
                        return ToThis.class;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final List<net.bytebuddy.asm.Advice$AssignReturned$Handler> make(TypeDescription returnType, boolean exit, AnnotationDescription.Loadable<? extends ToThis> annotation) {
                        void var2_2;
                        void var3_3;
                        return Collections.singletonList(new Handler(annotation.getValue(TO_THIS_INDEX).resolve(Integer.class), var3_3.getValue(TO_THIS_TYPING).resolve(EnumerationDescription.class).load(Assigner.Typing.class), (boolean)var2_2));
                    }

                    /*
                     * WARNING - void declaration
                     */
                    static {
                        void var0;
                        INSTANCE = new Factory();
                        $VALUES = new Factory[]{INSTANCE};
                        MethodList<MethodDescription.InDefinedShape> methods = TypeDescription.ForLoadedType.of(ToThis.class).getDeclaredMethods();
                        TO_THIS_INDEX = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("index"))).getOnly();
                        TO_THIS_TYPING = (MethodDescription.InDefinedShape)((MethodList)var0.filter(ElementMatchers.named("typing"))).getOnly();
                    }
                }
            }
        }

        @Documented
        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.METHOD})
        public static @interface ToAllArguments {
            public int index() default -1;

            public Assigner.Typing typing() default Assigner.Typing.STATIC;

            @HashCodeAndEqualsPlugin.Enhance
            public static class Handler
            implements net.bytebuddy.asm.Advice$AssignReturned$Handler {
                private final int index;
                private final Assigner.Typing typing;

                /*
                 * WARNING - void declaration
                 */
                protected Handler(int index, Assigner.Typing typing) {
                    void var2_2;
                    void var1_1;
                    this.index = var1_1;
                    this.typing = var2_2;
                }

                public int getIndex() {
                    return this.index;
                }

                /*
                 * WARNING - void declaration
                 */
                @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming component type for array type.")
                public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, TypeDescription type, StackManipulation value) {
                    void var1_1;
                    ArrayList<StackManipulation.Compound> stackManipulations = new ArrayList<StackManipulation.Compound>(instrumentedMethod.getParameters().size());
                    if (!type.isArray()) {
                        StackManipulation assignment = assigner.assign(type.asGenericType(), TypeDefinition.Sort.describe(Object[].class), this.typing);
                        if (!assignment.isValid()) {
                            throw new IllegalStateException("Cannot assign " + type + " to " + Object[].class);
                        }
                        type = TypeDescription.ForLoadedType.of(Object[].class);
                        value = new StackManipulation.Compound(value, assignment);
                    }
                    for (ParameterDescription parameterDescription : instrumentedMethod.getParameters()) {
                        void var2_2;
                        StackManipulation assignment = assigner.assign(type.getComponentType().asGenericType(), parameterDescription.getType(), this.typing);
                        if (!assignment.isValid()) {
                            throw new IllegalStateException("Cannot assign " + type.getComponentType() + " to " + parameterDescription);
                        }
                        stackManipulations.add(new StackManipulation.Compound(assignment, MethodVariableAccess.of(parameterDescription.getType()).storeAt(argumentHandler.argument(var2_2.getOffset()))));
                    }
                    return new StackManipulation.Compound(value, ArrayAccess.of(type.getComponentType()).forEach((List<? extends StackManipulation>)var1_1), Removal.SINGLE);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (this.index != ((Handler)object).index) {
                        return false;
                    }
                    return this.typing.equals((Object)((Handler)object).typing);
                }

                public int hashCode() {
                    return (this.getClass().hashCode() * 31 + this.index) * 31 + this.typing.hashCode();
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static final class Factory
                extends Enum<Factory>
                implements net.bytebuddy.asm.Advice$AssignReturned$Handler$Factory<ToAllArguments> {
                    public static final /* enum */ Factory INSTANCE;
                    private static final MethodDescription.InDefinedShape TO_ALL_ARGUMENTS_INDEX;
                    private static final MethodDescription.InDefinedShape TO_ALL_ARGUMENTS_TYPING;
                    private static final /* synthetic */ Factory[] $VALUES;

                    public static Factory[] values() {
                        return (Factory[])$VALUES.clone();
                    }

                    public static Factory valueOf(String name) {
                        String string;
                        return Enum.valueOf(Factory.class, string);
                    }

                    @Override
                    public final Class<ToAllArguments> getAnnotationType() {
                        return ToAllArguments.class;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final List<net.bytebuddy.asm.Advice$AssignReturned$Handler> make(TypeDescription typeDescription, boolean exit, AnnotationDescription.Loadable<? extends ToAllArguments> annotation) {
                        void var3_3;
                        return Collections.singletonList(new Handler(annotation.getValue(TO_ALL_ARGUMENTS_INDEX).resolve(Integer.class), var3_3.getValue(TO_ALL_ARGUMENTS_TYPING).resolve(EnumerationDescription.class).load(Assigner.Typing.class)));
                    }

                    /*
                     * WARNING - void declaration
                     */
                    static {
                        void var0;
                        INSTANCE = new Factory();
                        $VALUES = new Factory[]{INSTANCE};
                        MethodList<MethodDescription.InDefinedShape> methods = TypeDescription.ForLoadedType.of(ToAllArguments.class).getDeclaredMethods();
                        TO_ALL_ARGUMENTS_INDEX = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("index"))).getOnly();
                        TO_ALL_ARGUMENTS_TYPING = (MethodDescription.InDefinedShape)((MethodList)var0.filter(ElementMatchers.named("typing"))).getOnly();
                    }
                }
            }
        }

        @Documented
        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.METHOD})
        public static @interface ToArguments {
            public ToArgument[] value();

            @HashCodeAndEqualsPlugin.Enhance
            public static class Handler
            implements net.bytebuddy.asm.Advice$AssignReturned$Handler {
                private final int value;
                private final int index;
                private final Assigner.Typing typing;

                /*
                 * WARNING - void declaration
                 */
                protected Handler(int value, int index, Assigner.Typing typing) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.value = var1_1;
                    this.index = var2_2;
                    this.typing = var3_3;
                }

                public int getIndex() {
                    return this.index;
                }

                /*
                 * WARNING - void declaration
                 */
                public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, TypeDescription type, StackManipulation value) {
                    void var2_2;
                    void var1_1;
                    void var3_3;
                    if (instrumentedMethod.getParameters().size() < this.value) {
                        throw new IllegalStateException(instrumentedMethod + " declares less then " + this.value + " parameters");
                    }
                    StackManipulation assignment = var3_3.assign(type.asGenericType(), ((ParameterDescription)instrumentedMethod.getParameters().get(this.value)).getType(), this.typing);
                    if (!assignment.isValid()) {
                        throw new IllegalStateException("Cannot assign " + type + " to " + ((ParameterDescription)instrumentedMethod.getParameters().get(this.value)).getType());
                    }
                    return new StackManipulation.Compound(new StackManipulation[]{value, var1_1, MethodVariableAccess.of(((ParameterDescription)instrumentedMethod.getParameters().get(this.value)).getType()).storeAt(argumentHandler.argument(((ParameterDescription)var2_2.getParameters().get(this.value)).getOffset()))});
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (this.value != ((Handler)object).value) {
                        return false;
                    }
                    if (this.index != ((Handler)object).index) {
                        return false;
                    }
                    return this.typing.equals((Object)((Handler)object).typing);
                }

                public int hashCode() {
                    return ((this.getClass().hashCode() * 31 + this.value) * 31 + this.index) * 31 + this.typing.hashCode();
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static final class Factory
                extends Enum<Factory>
                implements net.bytebuddy.asm.Advice$AssignReturned$Handler$Factory<ToArguments> {
                    public static final /* enum */ Factory INSTANCE;
                    private static final MethodDescription.InDefinedShape TO_ARGUMENTS_VALUE;
                    private static final MethodDescription.InDefinedShape TO_ARGUMENT_VALUE;
                    private static final MethodDescription.InDefinedShape TO_ARGUMENT_INDEX;
                    private static final MethodDescription.InDefinedShape TO_ARGUMENT_TYPING;
                    private static final /* synthetic */ Factory[] $VALUES;

                    public static Factory[] values() {
                        return (Factory[])$VALUES.clone();
                    }

                    public static Factory valueOf(String name) {
                        String string;
                        return Enum.valueOf(Factory.class, string);
                    }

                    @Override
                    public final Class<ToArguments> getAnnotationType() {
                        return ToArguments.class;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final List<net.bytebuddy.asm.Advice$AssignReturned$Handler> make(TypeDescription returnType, boolean exit, AnnotationDescription.Loadable<? extends ToArguments> annotation) {
                        void var2_3;
                        AnnotationDescription[] annotationDescriptionArray;
                        ArrayList<Handler> handlers = new ArrayList<Handler>();
                        for (AnnotationDescription argument : annotationDescriptionArray.getValue(TO_ARGUMENTS_VALUE).resolve(AnnotationDescription[].class)) {
                            int value = argument.getValue(TO_ARGUMENT_VALUE).resolve(Integer.class);
                            if (value < 0) {
                                throw new IllegalStateException("An argument cannot have a negative index for " + returnType);
                            }
                            handlers.add(new Handler(value, argument.getValue(TO_ARGUMENT_INDEX).resolve(Integer.class), argument.getValue(TO_ARGUMENT_TYPING).resolve(EnumerationDescription.class).load(Assigner.Typing.class)));
                        }
                        return var2_3;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    static {
                        void var0;
                        INSTANCE = new Factory();
                        $VALUES = new Factory[]{INSTANCE};
                        TO_ARGUMENTS_VALUE = (MethodDescription.InDefinedShape)((MethodList)TypeDescription.ForLoadedType.of(ToArguments.class).getDeclaredMethods().filter(ElementMatchers.named("value"))).getOnly();
                        MethodList<MethodDescription.InDefinedShape> methods = TypeDescription.ForLoadedType.of(ToArgument.class).getDeclaredMethods();
                        TO_ARGUMENT_VALUE = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("value"))).getOnly();
                        TO_ARGUMENT_INDEX = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("index"))).getOnly();
                        TO_ARGUMENT_TYPING = (MethodDescription.InDefinedShape)((MethodList)var0.filter(ElementMatchers.named("typing"))).getOnly();
                    }
                }
            }

            @Target(value={})
            @RepeatedAnnotationPlugin.Enhance(value=ToArguments.class)
            @Repeatable(value=ToArguments.class)
            public static @interface ToArgument {
                public int value();

                public int index() default -1;

                public Assigner.Typing typing() default Assigner.Typing.STATIC;
            }
        }

        @Documented
        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.METHOD})
        public static @interface AsScalar {
            public boolean skipOnDefaultValue() default true;
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Unused {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface StubValue {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Local {
        public String value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Exit {
        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Enter {
        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Origin {
        public static final String DEFAULT = "";

        public String value() default "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface FieldSetterHandle {
        public String value() default "";

        public Class<?> declaringType() default void.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface FieldGetterHandle {
        public String value() default "";

        public Class<?> declaringType() default void.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface FieldValue {
        public String value() default "";

        public Class<?> declaringType() default void.class;

        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface DynamicConstant {
        public String name() default "_";

        public JavaConstant.MethodHandle.HandleType bootstrapType();

        public Class<?> bootstrapOwner() default void.class;

        public String bootstrapName();

        public Class<?> bootstrapReturnType();

        public Class<?>[] bootstrapParameterTypes();

        public boolean invokedynamic() default false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Handle {
        public JavaConstant.MethodHandle.HandleType type();

        public Class<?> owner() default void.class;

        public String name();

        public Class<?> returnType();

        public Class<?>[] parameterTypes();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface SelfCallHandle {
        public boolean bound() default true;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Thrown {
        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.DYNAMIC;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Return {
        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface AllArguments {
        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;

        public boolean includeSelf() default false;

        public boolean nullIfEmpty() default false;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Argument {
        public int value();

        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;

        public boolean optional() default false;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface This {
        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;

        public boolean optional() default false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface OnMethodExit {
        public Class<?> repeatOn() default void.class;

        public int repeatOnIndex() default -1;

        public Class<? extends Throwable> onThrowable() default NoExceptionHandler.class;

        public boolean backupArguments() default true;

        public boolean inline() default true;

        public Class<? extends Throwable> suppress() default NoExceptionHandler.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface OnMethodEnter {
        public Class<?> skipOn() default void.class;

        public int skipOnIndex() default -1;

        public boolean prependLineNumber() default true;

        public boolean inline() default true;

        public Class<? extends Throwable> suppress() default NoExceptionHandler.class;
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class Appender
    implements ByteCodeAppender {
        private final Advice advice;
        private final Implementation.Target implementationTarget;
        private final ByteCodeAppender delegate;

        /*
         * WARNING - void declaration
         */
        protected Appender(Advice advice, Implementation.Target implementationTarget, ByteCodeAppender delegate) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.advice = var1_1;
            this.implementationTarget = var2_2;
            this.delegate = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            void var3_3;
            void var2_2;
            void var1_1;
            EmulatingMethodVisitor emulatingMethodVisitor = new EmulatingMethodVisitor(methodVisitor, this.delegate);
            methodVisitor = this.advice.doWrap(this.implementationTarget.getInstrumentedType(), instrumentedMethod, emulatingMethodVisitor, implementationContext, 0, 0);
            return emulatingMethodVisitor.resolve((MethodVisitor)var1_1, (Implementation.Context)var2_2, (MethodDescription)var3_3);
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.advice.equals(((Appender)object).advice)) {
                return false;
            }
            if (!this.implementationTarget.equals(((Appender)object).implementationTarget)) {
                return false;
            }
            return this.delegate.equals(((Appender)object).delegate);
        }

        public int hashCode() {
            return ((this.getClass().hashCode() * 31 + this.advice.hashCode()) * 31 + this.implementationTarget.hashCode()) * 31 + this.delegate.hashCode();
        }

        protected static class EmulatingMethodVisitor
        extends MethodVisitor {
            private final ByteCodeAppender delegate;
            private int stackSize;
            private int localVariableLength;

            /*
             * WARNING - void declaration
             */
            protected EmulatingMethodVisitor(MethodVisitor methodVisitor, ByteCodeAppender delegate) {
                super(OpenedClassReader.ASM_API, (MethodVisitor)var1_1);
                void var2_2;
                void var1_1;
                this.delegate = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            protected ByteCodeAppender.Size resolve(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                void var1_1;
                void var2_2;
                void var3_3;
                methodVisitor.visitCode();
                ByteCodeAppender.Size size = this.delegate.apply(methodVisitor, implementationContext, (MethodDescription)var3_3);
                methodVisitor.visitMaxs(size.getOperandStackSize(), var2_2.getLocalVariableSize());
                var1_1.visitEnd();
                return new ByteCodeAppender.Size(this.stackSize, this.localVariableLength);
            }

            public void visitCode() {
            }

            /*
             * WARNING - void declaration
             */
            public void visitMaxs(int stackSize, int localVariableLength) {
                void var2_2;
                void var1_1;
                this.stackSize = var1_1;
                this.localVariableLength = var2_2;
            }

            public void visitEnd() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AdviceVisitor
    extends ExceptionTableSensitiveMethodVisitor
    implements Dispatcher.RelocationHandler.Relocation {
        private static final int THIS_VARIABLE_INDEX = 0;
        private static final String THIS_VARIABLE_NAME = "this";
        protected final MethodDescription instrumentedMethod;
        private final Label preparationStart;
        private final Dispatcher.Bound methodEnter;
        protected final Dispatcher.Bound methodExit;
        protected final ArgumentHandler.ForInstrumentedMethod argumentHandler;
        protected final MethodSizeHandler.ForInstrumentedMethod methodSizeHandler;
        protected final StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler;

        /*
         * WARNING - void declaration
         */
        @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"}, justification="Self reference is not used before constructor completion.")
        protected AdviceVisitor(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, StackManipulation exceptionHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, List<? extends TypeDescription> postMethodTypes, int writerFlags, int readerFlags) {
            super(OpenedClassReader.ASM_API, methodVisitor);
            void var3_3;
            void var2_2;
            void var1_1;
            this.instrumentedMethod = instrumentedMethod;
            this.preparationStart = new Label();
            TreeMap<String, TypeDefinition> namedTypes = new TreeMap<String, TypeDefinition>();
            namedTypes.putAll(methodEnter.getNamedTypes());
            namedTypes.putAll(methodExit.getNamedTypes());
            this.argumentHandler = methodExit.getArgumentHandlerFactory().resolve(instrumentedMethod, methodEnter.getAdviceType(), methodExit.getAdviceType(), namedTypes);
            List<TypeDescription> initialTypes = CompoundList.of(methodExit.getAdviceType().represents(Void.TYPE) ? Collections.emptyList() : Collections.singletonList(methodExit.getAdviceType().asErasure()), this.argumentHandler.getNamedTypes());
            List latentTypes = methodEnter.getActualAdviceType().represents(Void.TYPE) ? Collections.emptyList() : Collections.singletonList(methodEnter.getActualAdviceType().asErasure());
            List preMethodTypes = methodEnter.getAdviceType().represents(Void.TYPE) ? Collections.emptyList() : Collections.singletonList(methodEnter.getAdviceType().asErasure());
            this.methodSizeHandler = MethodSizeHandler.Default.of(instrumentedMethod, initialTypes, preMethodTypes, postMethodTypes, this.argumentHandler.isCopyingArguments(), writerFlags);
            this.stackMapFrameHandler = StackMapFrameHandler.Default.of(instrumentedType, instrumentedMethod, initialTypes, latentTypes, preMethodTypes, postMethodTypes, methodExit.isAlive(), this.argumentHandler.isCopyingArguments(), implementationContext.getClassFileVersion(), writerFlags, readerFlags);
            this.methodEnter = methodEnter.bind(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, assigner, this.argumentHandler, this.methodSizeHandler, this.stackMapFrameHandler, exceptionHandler, this);
            this.methodExit = methodExit.bind(instrumentedType, instrumentedMethod, (MethodVisitor)var1_1, (Implementation.Context)var2_2, (Assigner)var3_3, this.argumentHandler, this.methodSizeHandler, this.stackMapFrameHandler, exceptionHandler, new Dispatcher.RelocationHandler.Relocation.ForLabel(this.preparationStart));
        }

        @Override
        protected void onAfterExceptionTable() {
            this.methodEnter.prepare();
            this.onUserPrepare();
            this.methodExit.prepare();
            this.methodEnter.initialize();
            this.methodExit.initialize();
            this.stackMapFrameHandler.injectInitializationFrame(this.mv);
            this.methodEnter.apply();
            this.mv.visitLabel(this.preparationStart);
            this.methodSizeHandler.requireStackSize(this.argumentHandler.prepare(this.mv));
            this.stackMapFrameHandler.injectStartFrame(this.mv);
            this.mv.visitInsn(0);
            this.onUserStart();
        }

        protected abstract void onUserPrepare();

        protected abstract void onUserStart();

        /*
         * WARNING - void declaration
         */
        @Override
        protected void onVisitVarInsn(int opcode, int offset) {
            void var2_2;
            void var1_1;
            this.mv.visitVarInsn((int)var1_1, this.argumentHandler.argument((int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void onVisitIincInsn(int offset, int increment) {
            void var2_2;
            void var1_1;
            this.mv.visitIincInsn(this.argumentHandler.argument((int)var1_1), (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onVisitFrame(int type, int localVariableLength, @MaybeNull Object[] localVariable, int stackSize, @MaybeNull Object[] stack) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.stackMapFrameHandler.translateFrame(this.mv, (int)var1_1, (int)var2_2, (Object[])var3_3, stackSize, stack);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitMaxs(int stackSize, int localVariableLength) {
            void var2_2;
            void var1_1;
            this.onUserEnd();
            this.mv.visitMaxs(this.methodSizeHandler.compoundStackSize((int)var1_1), this.methodSizeHandler.compoundLocalVariableLength((int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int offset) {
            void var1_1;
            void var3_3;
            void var2_2;
            this.mv.visitLocalVariable(name, (String)var2_2, (String)var3_3, start, end, offset == 0 && THIS_VARIABLE_NAME.equals(var1_1) ? offset : this.argumentHandler.argument(offset));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AnnotationVisitor visitLocalVariableAnnotation(int typeReference, TypePath typePath, Label[] start, Label[] end, int[] offset, String descriptor, boolean visible) {
            void var3_3;
            void var2_2;
            void var1_1;
            int[] translated = new int[offset.length];
            for (int index = 0; index < offset.length; ++index) {
                translated[index] = this.argumentHandler.argument(offset[index]);
            }
            return this.mv.visitLocalVariableAnnotation((int)var1_1, (TypePath)var2_2, (Label[])var3_3, end, translated, descriptor, visible);
        }

        protected abstract void onUserEnd();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static abstract class WithExitAdvice
        extends AdviceVisitor {
            protected final Label returnHandler = new Label();

            /*
             * WARNING - void declaration
             */
            protected WithExitAdvice(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, StackManipulation exceptionHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, List<? extends TypeDescription> postMethodTypes, int writerFlags, int readerFlags) {
                super(StackAwareMethodVisitor.of((MethodVisitor)var1_1, instrumentedMethod), (Implementation.Context)var2_2, (Assigner)var3_3, exceptionHandler, instrumentedType, instrumentedMethod, methodEnter, methodExit, postMethodTypes, writerFlags, readerFlags);
                void var3_3;
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void apply(MethodVisitor methodVisitor) {
                void var1_1;
                if (this.instrumentedMethod.getReturnType().represents(Boolean.TYPE) || this.instrumentedMethod.getReturnType().represents(Byte.TYPE) || this.instrumentedMethod.getReturnType().represents(Short.TYPE) || this.instrumentedMethod.getReturnType().represents(Character.TYPE) || this.instrumentedMethod.getReturnType().represents(Integer.TYPE)) {
                    methodVisitor.visitInsn(3);
                } else if (this.instrumentedMethod.getReturnType().represents(Long.TYPE)) {
                    methodVisitor.visitInsn(9);
                } else if (this.instrumentedMethod.getReturnType().represents(Float.TYPE)) {
                    methodVisitor.visitInsn(11);
                } else if (this.instrumentedMethod.getReturnType().represents(Double.TYPE)) {
                    methodVisitor.visitInsn(14);
                } else if (!this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                    methodVisitor.visitInsn(1);
                }
                var1_1.visitJumpInsn(167, this.returnHandler);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected void onVisitInsn(int opcode) {
                switch (opcode) {
                    case 177: {
                        ((StackAwareMethodVisitor)this.mv).drainStack();
                        break;
                    }
                    case 172: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(54, 21, StackSize.SINGLE));
                        break;
                    }
                    case 174: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(56, 23, StackSize.SINGLE));
                        break;
                    }
                    case 175: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(57, 24, StackSize.DOUBLE));
                        break;
                    }
                    case 173: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(55, 22, StackSize.DOUBLE));
                        break;
                    }
                    case 176: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(58, 25, StackSize.SINGLE));
                        break;
                    }
                    default: {
                        void var1_1;
                        this.mv.visitInsn((int)var1_1);
                        return;
                    }
                }
                this.mv.visitJumpInsn(167, this.returnHandler);
            }

            @Override
            protected void onUserEnd() {
                this.mv.visitLabel(this.returnHandler);
                this.onUserReturn();
                this.stackMapFrameHandler.injectCompletionFrame(this.mv);
                this.methodExit.apply();
                this.onExitAdviceReturn();
                if (this.instrumentedMethod.getReturnType().represents(Boolean.TYPE) || this.instrumentedMethod.getReturnType().represents(Byte.TYPE) || this.instrumentedMethod.getReturnType().represents(Short.TYPE) || this.instrumentedMethod.getReturnType().represents(Character.TYPE) || this.instrumentedMethod.getReturnType().represents(Integer.TYPE)) {
                    this.mv.visitVarInsn(21, this.argumentHandler.returned());
                    this.mv.visitInsn(172);
                } else if (this.instrumentedMethod.getReturnType().represents(Long.TYPE)) {
                    this.mv.visitVarInsn(22, this.argumentHandler.returned());
                    this.mv.visitInsn(173);
                } else if (this.instrumentedMethod.getReturnType().represents(Float.TYPE)) {
                    this.mv.visitVarInsn(23, this.argumentHandler.returned());
                    this.mv.visitInsn(174);
                } else if (this.instrumentedMethod.getReturnType().represents(Double.TYPE)) {
                    this.mv.visitVarInsn(24, this.argumentHandler.returned());
                    this.mv.visitInsn(175);
                } else if (!this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                    this.mv.visitVarInsn(25, this.argumentHandler.returned());
                    this.mv.visitInsn(176);
                } else {
                    this.mv.visitInsn(177);
                }
                this.methodSizeHandler.requireStackSize(this.instrumentedMethod.getReturnType().getStackSize().getSize());
            }

            protected abstract void onUserReturn();

            protected abstract void onExitAdviceReturn();

            protected static class WithExceptionHandling
            extends WithExitAdvice {
                private final TypeDescription throwable;
                private final Label exceptionHandler;
                protected final Label userStart;

                /*
                 * WARNING - void declaration
                 */
                protected WithExceptionHandling(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, StackManipulation exceptionHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, int writerFlags, int readerFlags, TypeDescription throwable) {
                    super((MethodVisitor)var1_1, (Implementation.Context)var2_2, (Assigner)var3_3, exceptionHandler, instrumentedType, instrumentedMethod, methodEnter, methodExit, instrumentedMethod.getReturnType().represents(Void.TYPE) ? Collections.singletonList(TypeDescription.ForLoadedType.of(Throwable.class)) : Arrays.asList(instrumentedMethod.getReturnType().asErasure(), TypeDescription.ForLoadedType.of(Throwable.class)), writerFlags, readerFlags);
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.throwable = throwable;
                    this.exceptionHandler = new Label();
                    this.userStart = new Label();
                }

                protected void onUserPrepare() {
                    this.mv.visitTryCatchBlock(this.userStart, this.returnHandler, this.exceptionHandler, this.throwable.getInternalName());
                }

                protected void onUserStart() {
                    this.mv.visitLabel(this.userStart);
                }

                /*
                 * WARNING - void declaration
                 */
                protected void onUserReturn() {
                    void var1_1;
                    this.stackMapFrameHandler.injectReturnFrame(this.mv);
                    if (this.instrumentedMethod.getReturnType().represents(Boolean.TYPE) || this.instrumentedMethod.getReturnType().represents(Byte.TYPE) || this.instrumentedMethod.getReturnType().represents(Short.TYPE) || this.instrumentedMethod.getReturnType().represents(Character.TYPE) || this.instrumentedMethod.getReturnType().represents(Integer.TYPE)) {
                        this.mv.visitVarInsn(54, this.argumentHandler.returned());
                    } else if (this.instrumentedMethod.getReturnType().represents(Long.TYPE)) {
                        this.mv.visitVarInsn(55, this.argumentHandler.returned());
                    } else if (this.instrumentedMethod.getReturnType().represents(Float.TYPE)) {
                        this.mv.visitVarInsn(56, this.argumentHandler.returned());
                    } else if (this.instrumentedMethod.getReturnType().represents(Double.TYPE)) {
                        this.mv.visitVarInsn(57, this.argumentHandler.returned());
                    } else if (!this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                        this.mv.visitVarInsn(58, this.argumentHandler.returned());
                    }
                    this.mv.visitInsn(1);
                    this.mv.visitVarInsn(58, this.argumentHandler.thrown());
                    Label endOfHandler = new Label();
                    this.mv.visitJumpInsn(167, endOfHandler);
                    this.mv.visitLabel(this.exceptionHandler);
                    this.stackMapFrameHandler.injectExceptionFrame(this.mv);
                    this.mv.visitVarInsn(58, this.argumentHandler.thrown());
                    if (this.instrumentedMethod.getReturnType().represents(Boolean.TYPE) || this.instrumentedMethod.getReturnType().represents(Byte.TYPE) || this.instrumentedMethod.getReturnType().represents(Short.TYPE) || this.instrumentedMethod.getReturnType().represents(Character.TYPE) || this.instrumentedMethod.getReturnType().represents(Integer.TYPE)) {
                        this.mv.visitInsn(3);
                        this.mv.visitVarInsn(54, this.argumentHandler.returned());
                    } else if (this.instrumentedMethod.getReturnType().represents(Long.TYPE)) {
                        this.mv.visitInsn(9);
                        this.mv.visitVarInsn(55, this.argumentHandler.returned());
                    } else if (this.instrumentedMethod.getReturnType().represents(Float.TYPE)) {
                        this.mv.visitInsn(11);
                        this.mv.visitVarInsn(56, this.argumentHandler.returned());
                    } else if (this.instrumentedMethod.getReturnType().represents(Double.TYPE)) {
                        this.mv.visitInsn(14);
                        this.mv.visitVarInsn(57, this.argumentHandler.returned());
                    } else if (!this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                        this.mv.visitInsn(1);
                        this.mv.visitVarInsn(58, this.argumentHandler.returned());
                    }
                    this.mv.visitLabel((Label)var1_1);
                    this.methodSizeHandler.requireStackSize(StackSize.SINGLE.getSize());
                }

                /*
                 * WARNING - void declaration
                 */
                protected void onExitAdviceReturn() {
                    void var1_1;
                    this.mv.visitVarInsn(25, this.argumentHandler.thrown());
                    Label endOfHandler = new Label();
                    this.mv.visitJumpInsn(198, endOfHandler);
                    this.mv.visitVarInsn(25, this.argumentHandler.thrown());
                    this.mv.visitInsn(191);
                    this.mv.visitLabel((Label)var1_1);
                    this.stackMapFrameHandler.injectPostCompletionFrame(this.mv);
                }
            }

            protected static class WithoutExceptionHandling
            extends WithExitAdvice {
                /*
                 * WARNING - void declaration
                 */
                protected WithoutExceptionHandling(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, StackManipulation exceptionHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, int writerFlags, int readerFlags) {
                    super((MethodVisitor)var1_1, (Implementation.Context)var2_2, (Assigner)var3_3, exceptionHandler, instrumentedType, instrumentedMethod, methodEnter, methodExit, instrumentedMethod.getReturnType().represents(Void.TYPE) ? Collections.emptyList() : Collections.singletonList(instrumentedMethod.getReturnType().asErasure()), writerFlags, readerFlags);
                    void var3_3;
                    void var2_2;
                    void var1_1;
                }

                protected void onUserPrepare() {
                }

                protected void onUserStart() {
                }

                protected void onUserReturn() {
                    if (this.instrumentedMethod.getReturnType().represents(Boolean.TYPE) || this.instrumentedMethod.getReturnType().represents(Byte.TYPE) || this.instrumentedMethod.getReturnType().represents(Short.TYPE) || this.instrumentedMethod.getReturnType().represents(Character.TYPE) || this.instrumentedMethod.getReturnType().represents(Integer.TYPE)) {
                        this.stackMapFrameHandler.injectReturnFrame(this.mv);
                        this.mv.visitVarInsn(54, this.argumentHandler.returned());
                        return;
                    }
                    if (this.instrumentedMethod.getReturnType().represents(Long.TYPE)) {
                        this.stackMapFrameHandler.injectReturnFrame(this.mv);
                        this.mv.visitVarInsn(55, this.argumentHandler.returned());
                        return;
                    }
                    if (this.instrumentedMethod.getReturnType().represents(Float.TYPE)) {
                        this.stackMapFrameHandler.injectReturnFrame(this.mv);
                        this.mv.visitVarInsn(56, this.argumentHandler.returned());
                        return;
                    }
                    if (this.instrumentedMethod.getReturnType().represents(Double.TYPE)) {
                        this.stackMapFrameHandler.injectReturnFrame(this.mv);
                        this.mv.visitVarInsn(57, this.argumentHandler.returned());
                        return;
                    }
                    if (!this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                        this.stackMapFrameHandler.injectReturnFrame(this.mv);
                        this.mv.visitVarInsn(58, this.argumentHandler.returned());
                    }
                }

                protected void onExitAdviceReturn() {
                }
            }
        }

        protected static class WithoutExitAdvice
        extends AdviceVisitor {
            /*
             * WARNING - void declaration
             */
            protected WithoutExitAdvice(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, StackManipulation exceptionHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, int writerFlags, int readerFlags) {
                super((MethodVisitor)var1_1, (Implementation.Context)var2_2, (Assigner)var3_3, exceptionHandler, instrumentedType, instrumentedMethod, methodEnter, Dispatcher.Inactive.INSTANCE, Collections.emptyList(), writerFlags, readerFlags);
                void var3_3;
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public void apply(MethodVisitor methodVisitor) {
                void var1_1;
                if (this.instrumentedMethod.getReturnType().represents(Boolean.TYPE) || this.instrumentedMethod.getReturnType().represents(Byte.TYPE) || this.instrumentedMethod.getReturnType().represents(Short.TYPE) || this.instrumentedMethod.getReturnType().represents(Character.TYPE) || this.instrumentedMethod.getReturnType().represents(Integer.TYPE)) {
                    methodVisitor.visitInsn(3);
                    methodVisitor.visitInsn(172);
                    return;
                }
                if (this.instrumentedMethod.getReturnType().represents(Long.TYPE)) {
                    methodVisitor.visitInsn(9);
                    methodVisitor.visitInsn(173);
                    return;
                }
                if (this.instrumentedMethod.getReturnType().represents(Float.TYPE)) {
                    methodVisitor.visitInsn(11);
                    methodVisitor.visitInsn(174);
                    return;
                }
                if (this.instrumentedMethod.getReturnType().represents(Double.TYPE)) {
                    methodVisitor.visitInsn(14);
                    methodVisitor.visitInsn(175);
                    return;
                }
                if (this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                    methodVisitor.visitInsn(177);
                    return;
                }
                methodVisitor.visitInsn(1);
                var1_1.visitInsn(176);
            }

            protected void onUserPrepare() {
            }

            protected void onUserStart() {
            }

            protected void onUserEnd() {
            }
        }
    }

    protected static interface Dispatcher {
        @AlwaysNull
        public static final MethodVisitor IGNORE_METHOD = null;
        @AlwaysNull
        public static final AnnotationVisitor IGNORE_ANNOTATION = null;

        public boolean isAlive();

        public TypeDefinition getAdviceType();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class Delegating
        implements Unresolved {
            protected final MethodDescription.InDefinedShape adviceMethod;
            protected final Delegator.Factory delegatorFactory;

            /*
             * WARNING - void declaration
             */
            protected Delegating(MethodDescription.InDefinedShape adviceMethod, Delegator.Factory delegatorFactory) {
                void var2_2;
                void var1_1;
                this.adviceMethod = var1_1;
                this.delegatorFactory = var2_2;
            }

            @Override
            public boolean isAlive() {
                return true;
            }

            @Override
            public boolean isBinary() {
                return false;
            }

            @Override
            public TypeDefinition getAdviceType() {
                return this.adviceMethod.getReturnType();
            }

            @Override
            public Map<String, TypeDefinition> getNamedTypes() {
                return Collections.emptyMap();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter asMethodEnter(List<? extends OffsetMapping.Factory<?>> userFactories, @MaybeNull AsmClassReader classReader, Unresolved methodExit, PostProcessor.Factory postProcessorFactory) {
                void var3_3;
                void var1_1;
                void var2_2;
                Delegator delegator = this.delegatorFactory.make(this.adviceMethod, false);
                return Resolved.ForMethodEnter.of(this.adviceMethod, postProcessorFactory.make(this.adviceMethod.getDeclaredAnnotations(), delegator.getTypeToken().getReturnType(), false), (Delegator)var2_2, var1_1, methodExit.getAdviceType(), var3_3.isAlive());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit asMethodExit(List<? extends OffsetMapping.Factory<?>> userFactories, @MaybeNull AsmClassReader classReader, Unresolved methodEnter, PostProcessor.Factory postProcessorFactory) {
                void var3_3;
                void var1_1;
                void var2_2;
                Map<String, TypeDefinition> namedTypes = methodEnter.getNamedTypes();
                for (ParameterDescription parameterDescription : this.adviceMethod.getParameters()) {
                    AnnotationDescription.Loadable<Local> annotationDescription = parameterDescription.getDeclaredAnnotations().ofType(Local.class);
                    if (annotationDescription == null) continue;
                    String name = annotationDescription.getValue(OffsetMapping.ForLocalValue.Factory.LOCAL_VALUE).resolve(String.class);
                    TypeDefinition typeDefinition = namedTypes.get(name);
                    if (typeDefinition == null) {
                        throw new IllegalStateException(this.adviceMethod + " attempts use of undeclared local variable " + name);
                    }
                    if (typeDefinition.equals(parameterDescription.getType())) continue;
                    throw new IllegalStateException(this.adviceMethod + " does not read variable " + name + " as " + typeDefinition);
                }
                Delegator delegator = this.delegatorFactory.make(this.adviceMethod, true);
                return Resolved.ForMethodExit.of(this.adviceMethod, postProcessorFactory.make(this.adviceMethod.getDeclaredAnnotations(), delegator.getTypeToken().getReturnType(), true), delegator, (Map<String, TypeDefinition>)var2_2, var1_1, var3_3.getAdviceType());
            }

            public String toString() {
                return "Delegate to " + this.adviceMethod;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.adviceMethod.equals(((Delegating)object).adviceMethod)) {
                    return false;
                }
                return this.delegatorFactory.equals(((Delegating)object).delegatorFactory);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + this.adviceMethod.hashCode()) * 31 + this.delegatorFactory.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static abstract class Resolved
            extends Resolved.AbstractBase {
                protected final Delegator delegator;

                /*
                 * WARNING - void declaration
                 */
                protected Resolved(MethodDescription.InDefinedShape adviceMethod, PostProcessor postProcessor, List<? extends OffsetMapping.Factory<?>> factories, TypeDescription throwableType, TypeDescription relocatableType, int relocatableIndex, Delegator delegator) {
                    super((MethodDescription.InDefinedShape)var1_1, (PostProcessor)var2_2, (List<? extends OffsetMapping.Factory<?>>)var3_3, throwableType, relocatableType, relocatableIndex, OffsetMapping.Factory.AdviceType.DELEGATION);
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.delegator = delegator;
                }

                @Override
                public Map<String, TypeDefinition> getNamedTypes() {
                    return Collections.emptyMap();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Bound bind(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, ArgumentHandler.ForInstrumentedMethod argumentHandler, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, StackManipulation exceptionHandler, RelocationHandler.Relocation relocation) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.delegator.assertVisibility(instrumentedType);
                    return this.resolve((TypeDescription)var1_1, (MethodDescription)var2_2, (MethodVisitor)var3_3, implementationContext, assigner, argumentHandler, methodSizeHandler, stackMapFrameHandler, exceptionHandler, relocation);
                }

                protected abstract Bound resolve(TypeDescription var1, MethodDescription var2, MethodVisitor var3, Implementation.Context var4, Assigner var5, ArgumentHandler.ForInstrumentedMethod var6, MethodSizeHandler.ForInstrumentedMethod var7, StackMapFrameHandler.ForInstrumentedMethod var8, StackManipulation var9, RelocationHandler.Relocation var10);

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                protected static abstract class ForMethodExit
                extends Resolved
                implements net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit {
                    private final boolean backupArguments;

                    /*
                     * WARNING - void declaration
                     */
                    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming annotation for exit advice.")
                    protected ForMethodExit(MethodDescription.InDefinedShape adviceMethod, PostProcessor postProcessor, Map<String, TypeDefinition> namedTypes, List<? extends OffsetMapping.Factory<?>> userFactories, TypeDefinition enterType, Delegator delegator) {
                        super(adviceMethod, (PostProcessor)var2_2, CompoundList.of(Arrays.asList(OffsetMapping.ForArgument.Unresolved.Factory.INSTANCE, OffsetMapping.ForAllArguments.Factory.INSTANCE, OffsetMapping.ForThisReference.Factory.INSTANCE, OffsetMapping.ForField.Unresolved.Factory.INSTANCE, OffsetMapping.ForFieldHandle.Unresolved.ReaderFactory.INSTANCE, OffsetMapping.ForFieldHandle.Unresolved.WriterFactory.INSTANCE, OffsetMapping.ForOrigin.Factory.INSTANCE, OffsetMapping.ForSelfCallHandle.Factory.INSTANCE, OffsetMapping.ForHandle.Factory.INSTANCE, OffsetMapping.ForDynamicConstant.Factory.INSTANCE, OffsetMapping.ForUnusedValue.Factory.INSTANCE, OffsetMapping.ForStubValue.INSTANCE, OffsetMapping.ForEnterValue.Factory.of(enterType), OffsetMapping.ForExitValue.Factory.of(adviceMethod.getReturnType()), new OffsetMapping.ForLocalValue.Factory((Map<String, TypeDefinition>)var3_3), OffsetMapping.ForReturnValue.Factory.INSTANCE, OffsetMapping.ForThrowable.Factory.of(adviceMethod)), userFactories), adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(SUPPRESS_EXIT).resolve(TypeDescription.class), adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(REPEAT_ON).resolve(TypeDescription.class), (int)adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(REPEAT_ON_INDEX).resolve(Integer.class), delegator);
                        void var1_1;
                        void var3_3;
                        void var2_2;
                        this.backupArguments = var1_1.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(BACKUP_ARGUMENTS).resolve(Boolean.class);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming annotation for exit advice.")
                    protected static net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit of(MethodDescription.InDefinedShape adviceMethod, PostProcessor postProcessor, Delegator delegator, Map<String, TypeDefinition> namedTypes, List<? extends OffsetMapping.Factory<?>> userFactories, TypeDefinition enterType) {
                        void var2_2;
                        void var3_3;
                        void var1_1;
                        MethodDescription.InDefinedShape inDefinedShape;
                        TypeDescription throwable = adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(ON_THROWABLE).resolve(TypeDescription.class);
                        if (throwable.represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class))) {
                            return new WithoutExceptionHandler(adviceMethod, postProcessor, namedTypes, userFactories, enterType, delegator);
                        }
                        return new WithExceptionHandler(inDefinedShape, (PostProcessor)var1_1, (Map<String, TypeDefinition>)var3_3, userFactories, enterType, throwable, (Delegator)var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    protected Bound resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, ArgumentHandler.ForInstrumentedMethod argumentHandler, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, StackManipulation exceptionHandler, RelocationHandler.Relocation relocation) {
                        void var2_2;
                        void var3_3;
                        void var1_1;
                        return this.doResolve((TypeDescription)var1_1, instrumentedMethod, (MethodVisitor)var3_3, implementationContext, assigner, argumentHandler.bindExit(this.delegator.getTypeToken(), this.getThrowable().represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class))), methodSizeHandler.bindExit(this.delegator.getTypeToken()), stackMapFrameHandler.bindExit(this.delegator.getTypeToken()), this.suppressionHandler.bind(exceptionHandler), this.relocationHandler.bind((MethodDescription)var2_2, relocation), exceptionHandler);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    private Bound doResolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, ArgumentHandler.ForAdvice argumentHandler, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler, RelocationHandler.Bound relocationHandler, StackManipulation exceptionHandler) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        ArrayList<OffsetMapping.Target> offsetMappings = new ArrayList<OffsetMapping.Target>(this.offsetMappings.size());
                        for (OffsetMapping offsetMapping : this.offsetMappings.values()) {
                            offsetMappings.add(offsetMapping.resolve(instrumentedType, instrumentedMethod, assigner, argumentHandler, OffsetMapping.Sort.EXIT));
                        }
                        return new AdviceMethodWriter.ForMethodExit(this.delegator.getTypeToken(), (TypeDescription)var1_1, (MethodDescription)var2_2, assigner, this.postProcessor, offsetMappings, (MethodVisitor)var3_3, implementationContext, argumentHandler, methodSizeHandler, stackMapFrameHandler, suppressionHandler, relocationHandler, exceptionHandler, this.delegator);
                    }

                    @Override
                    public ArgumentHandler.Factory getArgumentHandlerFactory() {
                        if (this.backupArguments) {
                            return ArgumentHandler.Factory.COPYING;
                        }
                        return ArgumentHandler.Factory.SIMPLE;
                    }

                    @Override
                    public TypeDefinition getAdviceType() {
                        return this.delegator.getTypeToken().getReturnType();
                    }

                    @Override
                    public boolean equals(@MaybeNull Object object) {
                        if (!super.equals(object)) {
                            return false;
                        }
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        return this.backupArguments == ((ForMethodExit)object).backupArguments;
                    }

                    @Override
                    public int hashCode() {
                        return super.hashCode() * 31 + this.backupArguments;
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    protected static class WithoutExceptionHandler
                    extends ForMethodExit {
                        /*
                         * WARNING - void declaration
                         */
                        protected WithoutExceptionHandler(MethodDescription.InDefinedShape adviceMethod, PostProcessor postProcessor, Map<String, TypeDefinition> namedTypes, List<? extends OffsetMapping.Factory<?>> userFactories, TypeDefinition enterType, Delegator delegator) {
                            super((MethodDescription.InDefinedShape)var1_1, (PostProcessor)var2_2, (Map<String, TypeDefinition>)var3_3, userFactories, enterType, delegator);
                            void var3_3;
                            void var2_2;
                            void var1_1;
                        }

                        @Override
                        public TypeDescription getThrowable() {
                            return NoExceptionHandler.DESCRIPTION;
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    @HashCodeAndEqualsPlugin.Enhance
                    protected static class WithExceptionHandler
                    extends ForMethodExit {
                        private final TypeDescription throwable;

                        /*
                         * WARNING - void declaration
                         */
                        protected WithExceptionHandler(MethodDescription.InDefinedShape adviceMethod, PostProcessor postProcessor, Map<String, TypeDefinition> namedTypes, List<? extends OffsetMapping.Factory<?>> userFactories, TypeDefinition enterType, TypeDescription throwable, Delegator delegator) {
                            super((MethodDescription.InDefinedShape)var1_1, (PostProcessor)var2_2, (Map<String, TypeDefinition>)var3_3, userFactories, enterType, delegator);
                            void var3_3;
                            void var2_2;
                            void var1_1;
                            this.throwable = throwable;
                        }

                        @Override
                        public TypeDescription getThrowable() {
                            return this.throwable;
                        }

                        @Override
                        public boolean equals(@MaybeNull Object object) {
                            if (!super.equals(object)) {
                                return false;
                            }
                            if (this == object) {
                                return true;
                            }
                            if (object == null) {
                                return false;
                            }
                            if (this.getClass() != object.getClass()) {
                                return false;
                            }
                            return this.throwable.equals(((WithExceptionHandler)object).throwable);
                        }

                        @Override
                        public int hashCode() {
                            return super.hashCode() * 31 + this.throwable.hashCode();
                        }
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                protected static abstract class ForMethodEnter
                extends Resolved
                implements net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter {
                    private final boolean prependLineNumber;

                    /*
                     * WARNING - void declaration
                     */
                    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming annotation for exit advice.")
                    protected ForMethodEnter(MethodDescription.InDefinedShape adviceMethod, PostProcessor postProcessor, List<? extends OffsetMapping.Factory<?>> userFactories, TypeDefinition exitType, Delegator delegator) {
                        super(adviceMethod, (PostProcessor)var2_2, CompoundList.of(Arrays.asList(OffsetMapping.ForArgument.Unresolved.Factory.INSTANCE, OffsetMapping.ForAllArguments.Factory.INSTANCE, OffsetMapping.ForThisReference.Factory.INSTANCE, OffsetMapping.ForField.Unresolved.Factory.INSTANCE, OffsetMapping.ForFieldHandle.Unresolved.ReaderFactory.INSTANCE, OffsetMapping.ForFieldHandle.Unresolved.WriterFactory.INSTANCE, OffsetMapping.ForOrigin.Factory.INSTANCE, OffsetMapping.ForSelfCallHandle.Factory.INSTANCE, OffsetMapping.ForHandle.Factory.INSTANCE, OffsetMapping.ForDynamicConstant.Factory.INSTANCE, OffsetMapping.ForUnusedValue.Factory.INSTANCE, OffsetMapping.ForStubValue.INSTANCE, OffsetMapping.ForExitValue.Factory.of(exitType), new OffsetMapping.Factory.Illegal<Thrown>(Thrown.class), new OffsetMapping.Factory.Illegal<Enter>(Enter.class), new OffsetMapping.Factory.Illegal<Local>(Local.class), new OffsetMapping.Factory.Illegal<Return>(Return.class)), var3_3), adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(SUPPRESS_ENTER).resolve(TypeDescription.class), adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(SKIP_ON).resolve(TypeDescription.class), (int)adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(SKIP_ON_INDEX).resolve(Integer.class), delegator);
                        void var1_1;
                        void var3_3;
                        void var2_2;
                        this.prependLineNumber = var1_1.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(PREPEND_LINE_NUMBER).resolve(Boolean.class);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected static net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter of(MethodDescription.InDefinedShape adviceMethod, PostProcessor postProcessor, Delegator delegator, List<? extends OffsetMapping.Factory<?>> userFactories, TypeDefinition exitType, boolean methodExit) {
                        void var2_2;
                        void var3_3;
                        void var1_1;
                        MethodDescription.InDefinedShape inDefinedShape;
                        if (methodExit) {
                            return new WithRetainedEnterType(adviceMethod, postProcessor, userFactories, exitType, delegator);
                        }
                        return new WithDiscardedEnterType(inDefinedShape, (PostProcessor)var1_1, (List<? extends OffsetMapping.Factory<?>>)var3_3, exitType, (Delegator)var2_2);
                    }

                    @Override
                    public boolean isPrependLineNumber() {
                        return this.prependLineNumber;
                    }

                    @Override
                    public TypeDefinition getActualAdviceType() {
                        return this.delegator.getTypeToken().getReturnType();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    protected Bound resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, ArgumentHandler.ForInstrumentedMethod argumentHandler, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, StackManipulation exceptionHandler, RelocationHandler.Relocation relocation) {
                        void var2_2;
                        void var3_3;
                        void var1_1;
                        return this.doResolve((TypeDescription)var1_1, instrumentedMethod, (MethodVisitor)var3_3, implementationContext, assigner, argumentHandler.bindEnter(this.delegator.getTypeToken()), methodSizeHandler.bindEnter(this.delegator.getTypeToken()), stackMapFrameHandler.bindEnter(this.delegator.getTypeToken()), this.suppressionHandler.bind(exceptionHandler), this.relocationHandler.bind((MethodDescription)var2_2, relocation), exceptionHandler);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected Bound doResolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, ArgumentHandler.ForAdvice argumentHandler, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler, RelocationHandler.Bound relocationHandler, StackManipulation exceptionHandler) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        ArrayList<OffsetMapping.Target> offsetMappings = new ArrayList<OffsetMapping.Target>(this.offsetMappings.size());
                        for (OffsetMapping offsetMapping : this.offsetMappings.values()) {
                            offsetMappings.add(offsetMapping.resolve(instrumentedType, instrumentedMethod, assigner, argumentHandler, OffsetMapping.Sort.ENTER));
                        }
                        return new AdviceMethodWriter.ForMethodEnter(this.delegator.getTypeToken(), (TypeDescription)var1_1, (MethodDescription)var2_2, assigner, this.postProcessor, offsetMappings, (MethodVisitor)var3_3, implementationContext, argumentHandler, methodSizeHandler, stackMapFrameHandler, suppressionHandler, relocationHandler, exceptionHandler, this.delegator);
                    }

                    @Override
                    public boolean equals(@MaybeNull Object object) {
                        if (!super.equals(object)) {
                            return false;
                        }
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        return this.prependLineNumber == ((ForMethodEnter)object).prependLineNumber;
                    }

                    @Override
                    public int hashCode() {
                        return super.hashCode() * 31 + this.prependLineNumber;
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    protected static class WithDiscardedEnterType
                    extends ForMethodEnter {
                        /*
                         * WARNING - void declaration
                         */
                        protected WithDiscardedEnterType(MethodDescription.InDefinedShape adviceMethod, PostProcessor postProcessor, List<? extends OffsetMapping.Factory<?>> userFactories, TypeDefinition exitType, Delegator delegator) {
                            super((MethodDescription.InDefinedShape)var1_1, (PostProcessor)var2_2, (List<? extends OffsetMapping.Factory<?>>)var3_3, exitType, delegator);
                            void var3_3;
                            void var2_2;
                            void var1_1;
                        }

                        @Override
                        public TypeDefinition getAdviceType() {
                            return TypeDescription.ForLoadedType.of(Void.TYPE);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        protected Bound doResolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, ArgumentHandler.ForAdvice argumentHandler, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler, RelocationHandler.Bound relocationHandler, StackManipulation exceptionHandler) {
                            void var3_3;
                            void var2_2;
                            void var1_1;
                            methodSizeHandler.requireLocalVariableLengthPadding(this.delegator.getTypeToken().getReturnType().getStackSize().getSize());
                            return super.doResolve((TypeDescription)var1_1, (MethodDescription)var2_2, (MethodVisitor)var3_3, implementationContext, assigner, argumentHandler, methodSizeHandler, stackMapFrameHandler, suppressionHandler, relocationHandler, exceptionHandler);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    protected static class WithRetainedEnterType
                    extends ForMethodEnter {
                        /*
                         * WARNING - void declaration
                         */
                        protected WithRetainedEnterType(MethodDescription.InDefinedShape adviceMethod, PostProcessor postProcessor, List<? extends OffsetMapping.Factory<?>> userFactories, TypeDefinition exitType, Delegator delegator) {
                            super((MethodDescription.InDefinedShape)var1_1, (PostProcessor)var2_2, (List<? extends OffsetMapping.Factory<?>>)var3_3, exitType, delegator);
                            void var3_3;
                            void var2_2;
                            void var1_1;
                        }

                        @Override
                        public TypeDefinition getAdviceType() {
                            return this.delegator.getTypeToken().getReturnType();
                        }
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                protected static abstract class AdviceMethodWriter
                implements Bound {
                    protected final MethodDescription.TypeToken typeToken;
                    private final TypeDescription instrumentedType;
                    private final MethodDescription instrumentedMethod;
                    private final Assigner assigner;
                    private final List<OffsetMapping.Target> offsetMappings;
                    protected final MethodVisitor methodVisitor;
                    protected final Implementation.Context implementationContext;
                    protected final ArgumentHandler.ForAdvice argumentHandler;
                    protected final MethodSizeHandler.ForAdvice methodSizeHandler;
                    protected final StackMapFrameHandler.ForAdvice stackMapFrameHandler;
                    private final SuppressionHandler.Bound suppressionHandler;
                    private final RelocationHandler.Bound relocationHandler;
                    private final StackManipulation exceptionHandler;
                    private final PostProcessor postProcessor;
                    private final Delegator delegator;

                    /*
                     * WARNING - void declaration
                     */
                    protected AdviceMethodWriter(MethodDescription.TypeToken typeToken, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, PostProcessor postProcessor, List<OffsetMapping.Target> offsetMappings, MethodVisitor methodVisitor, Implementation.Context implementationContext, ArgumentHandler.ForAdvice argumentHandler, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler, RelocationHandler.Bound relocationHandler, StackManipulation exceptionHandler, Delegator delegator) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.typeToken = var1_1;
                        this.instrumentedType = var2_2;
                        this.instrumentedMethod = var3_3;
                        this.assigner = assigner;
                        this.postProcessor = postProcessor;
                        this.offsetMappings = offsetMappings;
                        this.methodVisitor = methodVisitor;
                        this.implementationContext = implementationContext;
                        this.argumentHandler = argumentHandler;
                        this.methodSizeHandler = methodSizeHandler;
                        this.stackMapFrameHandler = stackMapFrameHandler;
                        this.suppressionHandler = suppressionHandler;
                        this.relocationHandler = relocationHandler;
                        this.exceptionHandler = exceptionHandler;
                        this.delegator = delegator;
                    }

                    @Override
                    public void prepare() {
                        this.suppressionHandler.onPrepare(this.methodVisitor);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void apply() {
                        void var3_3;
                        this.suppressionHandler.onStart(this.methodVisitor);
                        int index = 0;
                        int currentStackSize = 0;
                        int maximumStackSize = 0;
                        for (OffsetMapping.Target offsetMapping : this.offsetMappings) {
                            maximumStackSize = Math.max(maximumStackSize, (currentStackSize += this.typeToken.getParameterTypes().get(index++).getStackSize().getSize()) + offsetMapping.resolveRead().apply(this.methodVisitor, this.implementationContext).getMaximalSize());
                        }
                        maximumStackSize = Math.max(maximumStackSize, this.delegator.apply(this.instrumentedType, this.instrumentedMethod).apply(this.methodVisitor, this.implementationContext).getMaximalSize());
                        this.suppressionHandler.onEndWithSkip(this.methodVisitor, this.implementationContext, this.methodSizeHandler, this.stackMapFrameHandler, this.typeToken.getReturnType());
                        if (this.typeToken.getReturnType().represents(Boolean.TYPE) || this.typeToken.getReturnType().represents(Byte.TYPE) || this.typeToken.getReturnType().represents(Short.TYPE) || this.typeToken.getReturnType().represents(Character.TYPE) || this.typeToken.getReturnType().represents(Integer.TYPE)) {
                            this.methodVisitor.visitVarInsn(54, this.isExitAdvice() ? this.argumentHandler.exit() : this.argumentHandler.enter());
                        } else if (this.typeToken.getReturnType().represents(Long.TYPE)) {
                            this.methodVisitor.visitVarInsn(55, this.isExitAdvice() ? this.argumentHandler.exit() : this.argumentHandler.enter());
                        } else if (this.typeToken.getReturnType().represents(Float.TYPE)) {
                            this.methodVisitor.visitVarInsn(56, this.isExitAdvice() ? this.argumentHandler.exit() : this.argumentHandler.enter());
                        } else if (this.typeToken.getReturnType().represents(Double.TYPE)) {
                            this.methodVisitor.visitVarInsn(57, this.isExitAdvice() ? this.argumentHandler.exit() : this.argumentHandler.enter());
                        } else if (this.typeToken.getReturnType().represents(Void.TYPE)) {
                            this.methodVisitor.visitInsn(0);
                        } else {
                            this.methodVisitor.visitVarInsn(58, this.isExitAdvice() ? this.argumentHandler.exit() : this.argumentHandler.enter());
                        }
                        this.methodSizeHandler.requireStackSize(this.postProcessor.resolve(this.instrumentedType, this.instrumentedMethod, this.assigner, this.argumentHandler, this.stackMapFrameHandler, this.exceptionHandler).apply(this.methodVisitor, this.implementationContext).getMaximalSize());
                        this.methodSizeHandler.requireStackSize(this.relocationHandler.apply(this.methodVisitor, this.implementationContext, this.isExitAdvice() ? this.argumentHandler.exit() : this.argumentHandler.enter()));
                        this.stackMapFrameHandler.injectCompletionFrame(this.methodVisitor);
                        this.methodSizeHandler.requireStackSize(Math.max((int)var3_3, this.typeToken.getReturnType().getStackSize().getSize()));
                        this.methodSizeHandler.requireLocalVariableLength(this.instrumentedMethod.getStackSize() + this.typeToken.getReturnType().getStackSize().getSize());
                    }

                    protected abstract boolean isExitAdvice();

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    protected static class ForMethodExit
                    extends AdviceMethodWriter {
                        /*
                         * WARNING - void declaration
                         */
                        protected ForMethodExit(MethodDescription.TypeToken typeToken, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, PostProcessor postProcessor, List<OffsetMapping.Target> offsetMappings, MethodVisitor methodVisitor, Implementation.Context implementationContext, ArgumentHandler.ForAdvice argumentHandler, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler, RelocationHandler.Bound relocationHandler, StackManipulation exceptionHandler, Delegator delegator) {
                            super((MethodDescription.TypeToken)var1_1, (TypeDescription)var2_2, (MethodDescription)var3_3, assigner, postProcessor, offsetMappings, methodVisitor, implementationContext, argumentHandler, methodSizeHandler, stackMapFrameHandler, suppressionHandler, relocationHandler, exceptionHandler, delegator);
                            void var3_3;
                            void var2_2;
                            void var1_1;
                        }

                        @Override
                        public void initialize() {
                            if (this.typeToken.getReturnType().represents(Boolean.TYPE) || this.typeToken.getReturnType().represents(Byte.TYPE) || this.typeToken.getReturnType().represents(Short.TYPE) || this.typeToken.getReturnType().represents(Character.TYPE) || this.typeToken.getReturnType().represents(Integer.TYPE)) {
                                this.methodVisitor.visitInsn(3);
                                this.methodVisitor.visitVarInsn(54, this.argumentHandler.exit());
                            } else if (this.typeToken.getReturnType().represents(Long.TYPE)) {
                                this.methodVisitor.visitInsn(9);
                                this.methodVisitor.visitVarInsn(55, this.argumentHandler.exit());
                            } else if (this.typeToken.getReturnType().represents(Float.TYPE)) {
                                this.methodVisitor.visitInsn(11);
                                this.methodVisitor.visitVarInsn(56, this.argumentHandler.exit());
                            } else if (this.typeToken.getReturnType().represents(Double.TYPE)) {
                                this.methodVisitor.visitInsn(14);
                                this.methodVisitor.visitVarInsn(57, this.argumentHandler.exit());
                            } else if (!this.typeToken.getReturnType().represents(Void.TYPE)) {
                                this.methodVisitor.visitInsn(1);
                                this.methodVisitor.visitVarInsn(58, this.argumentHandler.exit());
                            }
                            this.methodSizeHandler.requireStackSize(this.typeToken.getReturnType().getStackSize().getSize());
                        }

                        @Override
                        protected boolean isExitAdvice() {
                            return true;
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    protected static class ForMethodEnter
                    extends AdviceMethodWriter {
                        /*
                         * WARNING - void declaration
                         */
                        protected ForMethodEnter(MethodDescription.TypeToken typeToken, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, PostProcessor postProcessor, List<OffsetMapping.Target> offsetMappings, MethodVisitor methodVisitor, Implementation.Context implementationContext, ArgumentHandler.ForAdvice argumentHandler, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler, RelocationHandler.Bound relocationHandler, StackManipulation exceptionHandler, Delegator delegator) {
                            super((MethodDescription.TypeToken)var1_1, (TypeDescription)var2_2, (MethodDescription)var3_3, assigner, postProcessor, offsetMappings, methodVisitor, implementationContext, argumentHandler, methodSizeHandler, stackMapFrameHandler, suppressionHandler, relocationHandler, exceptionHandler, delegator);
                            void var3_3;
                            void var2_2;
                            void var1_1;
                        }

                        @Override
                        public void initialize() {
                        }

                        @Override
                        protected boolean isExitAdvice() {
                            return false;
                        }
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class Inlining
        implements Unresolved {
            protected final MethodDescription.InDefinedShape adviceMethod;
            private final Map<String, TypeDefinition> namedTypes;

            /*
             * WARNING - void declaration
             */
            protected Inlining(MethodDescription.InDefinedShape adviceMethod) {
                Iterator iterator;
                this.adviceMethod = adviceMethod;
                this.namedTypes = new HashMap<String, TypeDefinition>();
                for (ParameterDescription parameterDescription : iterator.getParameters()) {
                    void var3_3;
                    String name;
                    TypeDefinition previous;
                    AnnotationDescription.Loadable<Local> annotationDescription = parameterDescription.getDeclaredAnnotations().ofType(Local.class);
                    if (annotationDescription == null || (previous = this.namedTypes.put(name = annotationDescription.getValue(OffsetMapping.ForLocalValue.Factory.LOCAL_VALUE).resolve(String.class), parameterDescription.getType())) == null || previous.equals(parameterDescription.getType())) continue;
                    throw new IllegalStateException("Local variable for " + (String)var3_3 + " is defined with inconsistent types");
                }
            }

            @Override
            public boolean isAlive() {
                return true;
            }

            @Override
            public boolean isBinary() {
                return true;
            }

            @Override
            public TypeDescription getAdviceType() {
                return this.adviceMethod.getReturnType().asErasure();
            }

            @Override
            public Map<String, TypeDefinition> getNamedTypes() {
                return this.namedTypes;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter asMethodEnter(List<? extends OffsetMapping.Factory<?>> userFactories, @MaybeNull AsmClassReader classReader, Unresolved methodExit, PostProcessor.Factory postProcessorFactory) {
                void var3_3;
                void var2_2;
                void var1_1;
                if (classReader == null) {
                    throw new IllegalStateException("Class reader not expected null");
                }
                return Resolved.ForMethodEnter.of(this.adviceMethod, postProcessorFactory.make(this.adviceMethod.getDeclaredAnnotations(), this.adviceMethod.getReturnType().asErasure(), false), this.namedTypes, var1_1, methodExit.getAdviceType(), (AsmClassReader)var2_2, var3_3.isAlive());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit asMethodExit(List<? extends OffsetMapping.Factory<?>> userFactories, @MaybeNull AsmClassReader classReader, Unresolved methodEnter, PostProcessor.Factory postProcessorFactory) {
                void var3_3;
                void var2_2;
                void var1_1;
                HashMap<String, TypeDefinition> namedTypes = new HashMap<String, TypeDefinition>(methodEnter.getNamedTypes());
                HashMap<String, TypeDefinition> uninitializedNamedTypes = new HashMap<String, TypeDefinition>();
                for (Map.Entry<String, TypeDefinition> entry : this.namedTypes.entrySet()) {
                    TypeDefinition typeDefinition = (TypeDefinition)namedTypes.get(entry.getKey());
                    TypeDefinition uninitializedTypeDefinition = (TypeDefinition)uninitializedNamedTypes.get(entry.getKey());
                    if (typeDefinition == null && uninitializedTypeDefinition == null) {
                        namedTypes.put(entry.getKey(), entry.getValue());
                        uninitializedNamedTypes.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    if ((typeDefinition == null ? uninitializedTypeDefinition : typeDefinition).equals(entry.getValue())) continue;
                    throw new IllegalStateException("Local variable for " + entry.getKey() + " is defined with inconsistent types");
                }
                return Resolved.ForMethodExit.of(this.adviceMethod, postProcessorFactory.make(this.adviceMethod.getDeclaredAnnotations(), this.adviceMethod.getReturnType().asErasure(), true), namedTypes, uninitializedNamedTypes, var1_1, (AsmClassReader)var2_2, var3_3.getAdviceType());
            }

            public String toString() {
                return "Delegate to " + this.adviceMethod;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.adviceMethod.equals(((Inlining)object).adviceMethod)) {
                    return false;
                }
                return ((Object)this.namedTypes).equals(((Inlining)object).namedTypes);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + this.adviceMethod.hashCode()) * 31 + ((Object)this.namedTypes).hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static class CodeTranslationVisitor
            extends MethodVisitor {
                protected final MethodVisitor methodVisitor;
                protected final Implementation.Context implementationContext;
                protected final ArgumentHandler.ForAdvice argumentHandler;
                protected final MethodSizeHandler.ForAdvice methodSizeHandler;
                protected final StackMapFrameHandler.ForAdvice stackMapFrameHandler;
                private final TypeDescription instrumentedType;
                private final MethodDescription instrumentedMethod;
                private final Assigner assigner;
                protected final MethodDescription.InDefinedShape adviceMethod;
                private final Map<Integer, OffsetMapping.Target> offsetMappings;
                private final SuppressionHandler.Bound suppressionHandler;
                private final RelocationHandler.Bound relocationHandler;
                private final StackManipulation exceptionHandler;
                private final PostProcessor postProcessor;
                private final boolean exit;
                protected final Label endOfMethod;

                /*
                 * WARNING - void declaration
                 */
                protected CodeTranslationVisitor(MethodVisitor methodVisitor, Implementation.Context implementationContext, ArgumentHandler.ForAdvice argumentHandler, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, MethodDescription.InDefinedShape adviceMethod, Map<Integer, OffsetMapping.Target> offsetMappings, SuppressionHandler.Bound suppressionHandler, RelocationHandler.Bound relocationHandler, StackManipulation exceptionHandler, PostProcessor postProcessor, boolean exit) {
                    super(OpenedClassReader.ASM_API, StackAwareMethodVisitor.of(methodVisitor, instrumentedMethod));
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.methodVisitor = var1_1;
                    this.implementationContext = var2_2;
                    this.argumentHandler = var3_3;
                    this.methodSizeHandler = methodSizeHandler;
                    this.stackMapFrameHandler = stackMapFrameHandler;
                    this.instrumentedType = instrumentedType;
                    this.instrumentedMethod = instrumentedMethod;
                    this.assigner = assigner;
                    this.adviceMethod = adviceMethod;
                    this.offsetMappings = offsetMappings;
                    this.suppressionHandler = suppressionHandler;
                    this.relocationHandler = relocationHandler;
                    this.exceptionHandler = exceptionHandler;
                    this.postProcessor = postProcessor;
                    this.exit = exit;
                    this.endOfMethod = new Label();
                }

                /*
                 * WARNING - void declaration
                 */
                protected void propagateHandler(Label label) {
                    void var1_1;
                    ((StackAwareMethodVisitor)this.mv).register((Label)var1_1, Collections.singletonList(StackSize.SINGLE));
                }

                @Override
                public void visitParameter(String name, int modifiers) {
                }

                @Override
                public void visitAnnotableParameterCount(int count, boolean visible) {
                }

                @Override
                @MaybeNull
                public AnnotationVisitor visitAnnotationDefault() {
                    return IGNORE_ANNOTATION;
                }

                @Override
                @MaybeNull
                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                    return IGNORE_ANNOTATION;
                }

                @Override
                @MaybeNull
                public AnnotationVisitor visitTypeAnnotation(int typeReference, @MaybeNull TypePath typePath, String descriptor, boolean visible) {
                    return IGNORE_ANNOTATION;
                }

                @Override
                @MaybeNull
                public AnnotationVisitor visitParameterAnnotation(int index, String descriptor, boolean visible) {
                    return IGNORE_ANNOTATION;
                }

                @Override
                public void visitAttribute(Attribute attribute) {
                }

                @Override
                public void visitCode() {
                    this.suppressionHandler.onStart(this.methodVisitor);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void visitFrame(int type, int localVariableLength, @MaybeNull Object[] localVariable, int stackSize, @MaybeNull Object[] stack) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.stackMapFrameHandler.translateFrame(this.methodVisitor, (int)var1_1, (int)var2_2, (Object[])var3_3, stackSize, stack);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void visitVarInsn(int opcode, int offset) {
                    void var2_3;
                    void var1_1;
                    OffsetMapping.Target target = this.offsetMappings.get(offset);
                    if (target != null) {
                        void var2_4;
                        void var1_2;
                        switch (opcode) {
                            case 21: 
                            case 23: 
                            case 25: {
                                StackManipulation stackManipulation = target.resolveRead();
                                StackSize expectedGrowth = StackSize.SINGLE;
                                break;
                            }
                            case 22: 
                            case 24: {
                                StackManipulation stackManipulation = target.resolveRead();
                                StackSize expectedGrowth = StackSize.DOUBLE;
                                break;
                            }
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: {
                                void var3_5;
                                StackManipulation stackManipulation = var3_5.resolveWrite();
                                StackSize expectedGrowth = StackSize.ZERO;
                                break;
                            }
                            default: {
                                void stackManipulation;
                                throw new IllegalStateException("Unexpected opcode: " + (int)stackManipulation);
                            }
                        }
                        this.methodSizeHandler.requireStackSizePadding(var1_2.apply(this.mv, this.implementationContext).getMaximalSize() - var2_4.getSize());
                        return;
                    }
                    this.mv.visitVarInsn((int)var1_1, this.argumentHandler.mapped((int)var2_3));
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void visitIincInsn(int offset, int value) {
                    void var2_2;
                    void var1_1;
                    OffsetMapping.Target target = this.offsetMappings.get(offset);
                    if (target != null) {
                        void var3_3;
                        this.methodSizeHandler.requireStackSizePadding(var3_3.resolveIncrement(value).apply(this.mv, this.implementationContext).getMaximalSize());
                        return;
                    }
                    this.mv.visitIincInsn(this.argumentHandler.mapped((int)var1_1), (int)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void visitInsn(int opcode) {
                    switch (opcode) {
                        case 177: {
                            ((StackAwareMethodVisitor)this.mv).drainStack();
                            break;
                        }
                        case 172: {
                            this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(54, 21, StackSize.SINGLE));
                            break;
                        }
                        case 176: {
                            this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(58, 25, StackSize.SINGLE));
                            break;
                        }
                        case 174: {
                            this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(56, 23, StackSize.SINGLE));
                            break;
                        }
                        case 173: {
                            this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(55, 22, StackSize.DOUBLE));
                            break;
                        }
                        case 175: {
                            this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(57, 24, StackSize.DOUBLE));
                            break;
                        }
                        default: {
                            void var1_1;
                            this.mv.visitInsn((int)var1_1);
                            return;
                        }
                    }
                    this.mv.visitJumpInsn(167, this.endOfMethod);
                }

                @Override
                public void visitEnd() {
                    this.suppressionHandler.onEnd(this.methodVisitor, this.implementationContext, this.methodSizeHandler, this.stackMapFrameHandler, this.adviceMethod.getReturnType());
                    this.methodVisitor.visitLabel(this.endOfMethod);
                    if (this.adviceMethod.getReturnType().represents(Boolean.TYPE) || this.adviceMethod.getReturnType().represents(Byte.TYPE) || this.adviceMethod.getReturnType().represents(Short.TYPE) || this.adviceMethod.getReturnType().represents(Character.TYPE) || this.adviceMethod.getReturnType().represents(Integer.TYPE)) {
                        this.stackMapFrameHandler.injectReturnFrame(this.methodVisitor);
                        this.methodVisitor.visitVarInsn(54, this.exit ? this.argumentHandler.exit() : this.argumentHandler.enter());
                    } else if (this.adviceMethod.getReturnType().represents(Long.TYPE)) {
                        this.stackMapFrameHandler.injectReturnFrame(this.methodVisitor);
                        this.methodVisitor.visitVarInsn(55, this.exit ? this.argumentHandler.exit() : this.argumentHandler.enter());
                    } else if (this.adviceMethod.getReturnType().represents(Float.TYPE)) {
                        this.stackMapFrameHandler.injectReturnFrame(this.methodVisitor);
                        this.methodVisitor.visitVarInsn(56, this.exit ? this.argumentHandler.exit() : this.argumentHandler.enter());
                    } else if (this.adviceMethod.getReturnType().represents(Double.TYPE)) {
                        this.stackMapFrameHandler.injectReturnFrame(this.methodVisitor);
                        this.methodVisitor.visitVarInsn(57, this.exit ? this.argumentHandler.exit() : this.argumentHandler.enter());
                    } else if (!this.adviceMethod.getReturnType().represents(Void.TYPE)) {
                        this.stackMapFrameHandler.injectReturnFrame(this.methodVisitor);
                        this.methodVisitor.visitVarInsn(58, this.exit ? this.argumentHandler.exit() : this.argumentHandler.enter());
                    }
                    this.methodSizeHandler.requireStackSize(this.postProcessor.resolve(this.instrumentedType, this.instrumentedMethod, this.assigner, this.argumentHandler, this.stackMapFrameHandler, this.exceptionHandler).apply(this.methodVisitor, this.implementationContext).getMaximalSize());
                    this.methodSizeHandler.requireStackSize(this.relocationHandler.apply(this.methodVisitor, this.implementationContext, this.exit ? this.argumentHandler.exit() : this.argumentHandler.enter()));
                    this.stackMapFrameHandler.injectCompletionFrame(this.methodVisitor);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void visitMaxs(int stackSize, int localVariableLength) {
                    void var2_2;
                    void var1_1;
                    this.methodSizeHandler.recordMaxima((int)var1_1, (int)var2_2);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static abstract class Resolved
            extends Resolved.AbstractBase {
                protected final MethodDescription.InDefinedShape adviceMethod;
                protected final AsmClassReader classReader;

                /*
                 * WARNING - void declaration
                 */
                protected Resolved(MethodDescription.InDefinedShape adviceMethod, PostProcessor postProcessor, List<? extends OffsetMapping.Factory<?>> factories, TypeDescription throwableType, TypeDescription relocatableType, int relocatableIndex, AsmClassReader classReader) {
                    super(adviceMethod, (PostProcessor)var2_2, (List<? extends OffsetMapping.Factory<?>>)var3_3, throwableType, relocatableType, relocatableIndex, OffsetMapping.Factory.AdviceType.INLINING);
                    void var1_1;
                    void var3_3;
                    void var2_2;
                    this.adviceMethod = var1_1;
                    this.classReader = classReader;
                }

                protected abstract Map<Integer, TypeDefinition> resolveInitializationTypes(ArgumentHandler var1);

                protected abstract MethodVisitor apply(MethodVisitor var1, Implementation.Context var2, Assigner var3, ArgumentHandler.ForInstrumentedMethod var4, MethodSizeHandler.ForInstrumentedMethod var5, StackMapFrameHandler.ForInstrumentedMethod var6, TypeDescription var7, MethodDescription var8, SuppressionHandler.Bound var9, RelocationHandler.Bound var10, StackManipulation var11);

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                protected static abstract class ForMethodExit
                extends Resolved
                implements net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit {
                    private final Map<String, TypeDefinition> uninitializedNamedTypes;
                    private final boolean backupArguments;

                    /*
                     * WARNING - void declaration
                     */
                    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming annotation for exit advice.")
                    protected ForMethodExit(MethodDescription.InDefinedShape adviceMethod, PostProcessor postProcessor, Map<String, TypeDefinition> namedTypes, Map<String, TypeDefinition> uninitializedNamedTypes, List<? extends OffsetMapping.Factory<?>> userFactories, AsmClassReader classReader, TypeDefinition enterType) {
                        super(adviceMethod, (PostProcessor)var2_2, CompoundList.of(Arrays.asList(OffsetMapping.ForArgument.Unresolved.Factory.INSTANCE, OffsetMapping.ForAllArguments.Factory.INSTANCE, OffsetMapping.ForThisReference.Factory.INSTANCE, OffsetMapping.ForField.Unresolved.Factory.INSTANCE, OffsetMapping.ForFieldHandle.Unresolved.ReaderFactory.INSTANCE, OffsetMapping.ForFieldHandle.Unresolved.WriterFactory.INSTANCE, OffsetMapping.ForOrigin.Factory.INSTANCE, OffsetMapping.ForSelfCallHandle.Factory.INSTANCE, OffsetMapping.ForHandle.Factory.INSTANCE, OffsetMapping.ForDynamicConstant.Factory.INSTANCE, OffsetMapping.ForUnusedValue.Factory.INSTANCE, OffsetMapping.ForStubValue.INSTANCE, OffsetMapping.ForEnterValue.Factory.of(enterType), OffsetMapping.ForExitValue.Factory.of(adviceMethod.getReturnType()), new OffsetMapping.ForLocalValue.Factory((Map<String, TypeDefinition>)var3_3), OffsetMapping.ForReturnValue.Factory.INSTANCE, OffsetMapping.ForThrowable.Factory.of(adviceMethod)), userFactories), adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(SUPPRESS_EXIT).resolve(TypeDescription.class), adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(REPEAT_ON).resolve(TypeDescription.class), (int)adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(REPEAT_ON_INDEX).resolve(Integer.class), classReader);
                        void var1_1;
                        void var3_3;
                        void var2_2;
                        this.uninitializedNamedTypes = uninitializedNamedTypes;
                        this.backupArguments = var1_1.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(BACKUP_ARGUMENTS).resolve(Boolean.class);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming annotation for exit advice.")
                    protected static net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit of(MethodDescription.InDefinedShape adviceMethod, PostProcessor postProcessor, Map<String, TypeDefinition> namedTypes, Map<String, TypeDefinition> uninitializedNamedTypes, List<? extends OffsetMapping.Factory<?>> userFactories, AsmClassReader classReader, TypeDefinition enterType) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        MethodDescription.InDefinedShape inDefinedShape;
                        TypeDescription throwable = adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(ON_THROWABLE).resolve(TypeDescription.class);
                        if (throwable.represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class))) {
                            return new WithoutExceptionHandler(adviceMethod, postProcessor, namedTypes, uninitializedNamedTypes, userFactories, classReader, enterType);
                        }
                        return new WithExceptionHandler(inDefinedShape, (PostProcessor)var1_1, (Map<String, TypeDefinition>)var2_2, (Map<String, TypeDefinition>)var3_3, userFactories, classReader, enterType, throwable);
                    }

                    @Override
                    public Map<String, TypeDefinition> getNamedTypes() {
                        return this.uninitializedNamedTypes;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    protected Map<Integer, TypeDefinition> resolveInitializationTypes(ArgumentHandler argumentHandler) {
                        void var2_2;
                        TreeMap<Integer, TypeDefinition> resolved = new TreeMap<Integer, TypeDefinition>();
                        for (Map.Entry<String, TypeDefinition> entry : this.uninitializedNamedTypes.entrySet()) {
                            resolved.put(argumentHandler.named(entry.getKey()), entry.getValue());
                        }
                        if (!this.adviceMethod.getReturnType().represents(Void.TYPE)) {
                            void var1_1;
                            resolved.put(var1_1.exit(), this.adviceMethod.getReturnType());
                        }
                        return var2_2;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    protected MethodVisitor apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, ArgumentHandler.ForInstrumentedMethod argumentHandler, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, SuppressionHandler.Bound suppressionHandler, RelocationHandler.Bound relocationHandler, StackManipulation exceptionHandler) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        MethodDescription.TypeToken typeToken = this.adviceMethod.asTypeToken();
                        return this.doApply((MethodVisitor)var1_1, (Implementation.Context)var2_2, (Assigner)var3_3, argumentHandler.bindExit(typeToken, this.getThrowable().represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class))), methodSizeHandler.bindExit(typeToken), stackMapFrameHandler.bindExit(typeToken), instrumentedType, instrumentedMethod, suppressionHandler, relocationHandler, exceptionHandler);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    private MethodVisitor doApply(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, ArgumentHandler.ForAdvice argumentHandler, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, SuppressionHandler.Bound suppressionHandler, RelocationHandler.Bound relocationHandler, StackManipulation exceptionHandler) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        HashMap<Integer, OffsetMapping.Target> offsetMappings = new HashMap<Integer, OffsetMapping.Target>();
                        for (Map.Entry<Integer, OffsetMapping> entry : this.offsetMappings.entrySet()) {
                            offsetMappings.put(entry.getKey(), entry.getValue().resolve(instrumentedType, instrumentedMethod, assigner, argumentHandler, OffsetMapping.Sort.EXIT));
                        }
                        return new CodeTranslationVisitor((MethodVisitor)var1_1, (Implementation.Context)var2_2, argumentHandler, methodSizeHandler, stackMapFrameHandler, instrumentedType, instrumentedMethod, (Assigner)var3_3, this.adviceMethod, offsetMappings, suppressionHandler, relocationHandler, exceptionHandler, this.postProcessor, true);
                    }

                    @Override
                    public ArgumentHandler.Factory getArgumentHandlerFactory() {
                        if (this.backupArguments) {
                            return ArgumentHandler.Factory.COPYING;
                        }
                        return ArgumentHandler.Factory.SIMPLE;
                    }

                    @Override
                    public TypeDefinition getAdviceType() {
                        return this.adviceMethod.getReturnType();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Bound bind(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, ArgumentHandler.ForInstrumentedMethod argumentHandler, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, StackManipulation exceptionHandler, RelocationHandler.Relocation relocation) {
                        void var2_2;
                        void var3_3;
                        void var1_1;
                        return new AdviceMethodInliner(this, (TypeDescription)var1_1, instrumentedMethod, (MethodVisitor)var3_3, implementationContext, assigner, argumentHandler, methodSizeHandler, stackMapFrameHandler, this.suppressionHandler.bind(exceptionHandler), this.relocationHandler.bind((MethodDescription)var2_2, relocation), exceptionHandler, this.classReader);
                    }

                    @Override
                    public boolean equals(@MaybeNull Object object) {
                        if (!super.equals(object)) {
                            return false;
                        }
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (this.backupArguments != ((ForMethodExit)object).backupArguments) {
                            return false;
                        }
                        return ((Object)this.uninitializedNamedTypes).equals(((ForMethodExit)object).uninitializedNamedTypes);
                    }

                    @Override
                    public int hashCode() {
                        return (super.hashCode() * 31 + ((Object)this.uninitializedNamedTypes).hashCode()) * 31 + this.backupArguments;
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    protected static class WithoutExceptionHandler
                    extends ForMethodExit {
                        /*
                         * WARNING - void declaration
                         */
                        protected WithoutExceptionHandler(MethodDescription.InDefinedShape adviceMethod, PostProcessor postProcessor, Map<String, TypeDefinition> namedTypes, Map<String, TypeDefinition> uninitializedNamedTypes, List<? extends OffsetMapping.Factory<?>> userFactories, AsmClassReader classReader, TypeDefinition enterType) {
                            super((MethodDescription.InDefinedShape)var1_1, (PostProcessor)var2_2, (Map<String, TypeDefinition>)var3_3, uninitializedNamedTypes, userFactories, classReader, enterType);
                            void var3_3;
                            void var2_2;
                            void var1_1;
                        }

                        @Override
                        public TypeDescription getThrowable() {
                            return NoExceptionHandler.DESCRIPTION;
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    @HashCodeAndEqualsPlugin.Enhance
                    protected static class WithExceptionHandler
                    extends ForMethodExit {
                        private final TypeDescription throwable;

                        /*
                         * WARNING - void declaration
                         */
                        protected WithExceptionHandler(MethodDescription.InDefinedShape adviceMethod, PostProcessor postProcessor, Map<String, TypeDefinition> namedTypes, Map<String, TypeDefinition> uninitializedNamedTypes, List<? extends OffsetMapping.Factory<?>> userFactories, AsmClassReader classReader, TypeDefinition enterType, TypeDescription throwable) {
                            super((MethodDescription.InDefinedShape)var1_1, (PostProcessor)var2_2, (Map<String, TypeDefinition>)var3_3, uninitializedNamedTypes, userFactories, classReader, enterType);
                            void var3_3;
                            void var2_2;
                            void var1_1;
                            this.throwable = throwable;
                        }

                        @Override
                        public TypeDescription getThrowable() {
                            return this.throwable;
                        }

                        @Override
                        public boolean equals(@MaybeNull Object object) {
                            if (!super.equals(object)) {
                                return false;
                            }
                            if (this == object) {
                                return true;
                            }
                            if (object == null) {
                                return false;
                            }
                            if (this.getClass() != object.getClass()) {
                                return false;
                            }
                            return this.throwable.equals(((WithExceptionHandler)object).throwable);
                        }

                        @Override
                        public int hashCode() {
                            return super.hashCode() * 31 + this.throwable.hashCode();
                        }
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                protected static abstract class ForMethodEnter
                extends Resolved
                implements net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter {
                    private final Map<String, TypeDefinition> namedTypes;
                    private final boolean prependLineNumber;

                    /*
                     * WARNING - void declaration
                     */
                    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming annotation for exit advice.")
                    protected ForMethodEnter(MethodDescription.InDefinedShape adviceMethod, PostProcessor postProcessor, Map<String, TypeDefinition> namedTypes, List<? extends OffsetMapping.Factory<?>> userFactories, TypeDefinition exitType, AsmClassReader classReader) {
                        super(adviceMethod, (PostProcessor)var2_2, CompoundList.of(Arrays.asList(OffsetMapping.ForArgument.Unresolved.Factory.INSTANCE, OffsetMapping.ForAllArguments.Factory.INSTANCE, OffsetMapping.ForThisReference.Factory.INSTANCE, OffsetMapping.ForField.Unresolved.Factory.INSTANCE, OffsetMapping.ForFieldHandle.Unresolved.ReaderFactory.INSTANCE, OffsetMapping.ForFieldHandle.Unresolved.WriterFactory.INSTANCE, OffsetMapping.ForOrigin.Factory.INSTANCE, OffsetMapping.ForSelfCallHandle.Factory.INSTANCE, OffsetMapping.ForHandle.Factory.INSTANCE, OffsetMapping.ForDynamicConstant.Factory.INSTANCE, OffsetMapping.ForUnusedValue.Factory.INSTANCE, OffsetMapping.ForStubValue.INSTANCE, OffsetMapping.ForThrowable.Factory.INSTANCE, OffsetMapping.ForExitValue.Factory.of(exitType), new OffsetMapping.ForLocalValue.Factory(namedTypes), new OffsetMapping.Factory.Illegal<Thrown>(Thrown.class), new OffsetMapping.Factory.Illegal<Enter>(Enter.class), new OffsetMapping.Factory.Illegal<Return>(Return.class)), userFactories), adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(SUPPRESS_ENTER).resolve(TypeDescription.class), adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(SKIP_ON).resolve(TypeDescription.class), (int)adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(SKIP_ON_INDEX).resolve(Integer.class), classReader);
                        void var1_1;
                        void var3_3;
                        void var2_2;
                        this.namedTypes = var3_3;
                        this.prependLineNumber = var1_1.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(PREPEND_LINE_NUMBER).resolve(Boolean.class);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected static net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter of(MethodDescription.InDefinedShape adviceMethod, PostProcessor postProcessor, Map<String, TypeDefinition> namedTypes, List<? extends OffsetMapping.Factory<?>> userFactories, TypeDefinition exitType, AsmClassReader classReader, boolean methodExit) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        MethodDescription.InDefinedShape inDefinedShape;
                        if (methodExit) {
                            return new WithRetainedEnterType(adviceMethod, postProcessor, namedTypes, userFactories, exitType, classReader);
                        }
                        return new WithDiscardedEnterType(inDefinedShape, (PostProcessor)var1_1, (Map<String, TypeDefinition>)var2_2, (List<? extends OffsetMapping.Factory<?>>)var3_3, exitType, classReader);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    protected Map<Integer, TypeDefinition> resolveInitializationTypes(ArgumentHandler argumentHandler) {
                        void var2_2;
                        TreeMap<Integer, TypeDefinition> resolved = new TreeMap<Integer, TypeDefinition>();
                        for (Map.Entry<String, TypeDefinition> entry : this.namedTypes.entrySet()) {
                            resolved.put(argumentHandler.named(entry.getKey()), entry.getValue());
                        }
                        return var2_2;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Bound bind(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, ArgumentHandler.ForInstrumentedMethod argumentHandler, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, StackManipulation exceptionHandler, RelocationHandler.Relocation relocation) {
                        void var2_2;
                        void var3_3;
                        void var1_1;
                        return new AdviceMethodInliner(this, (TypeDescription)var1_1, instrumentedMethod, (MethodVisitor)var3_3, implementationContext, assigner, argumentHandler, methodSizeHandler, stackMapFrameHandler, this.suppressionHandler.bind(exceptionHandler), this.relocationHandler.bind((MethodDescription)var2_2, relocation), exceptionHandler, this.classReader);
                    }

                    @Override
                    public boolean isPrependLineNumber() {
                        return this.prependLineNumber;
                    }

                    @Override
                    public TypeDefinition getActualAdviceType() {
                        return this.adviceMethod.getReturnType();
                    }

                    @Override
                    public Map<String, TypeDefinition> getNamedTypes() {
                        return this.namedTypes;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    protected MethodVisitor apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, ArgumentHandler.ForInstrumentedMethod argumentHandler, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, SuppressionHandler.Bound suppressionHandler, RelocationHandler.Bound relocationHandler, StackManipulation exceptionHandler) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        MethodDescription.TypeToken typeToken = this.adviceMethod.asTypeToken();
                        return this.doApply((MethodVisitor)var1_1, (Implementation.Context)var2_2, (Assigner)var3_3, argumentHandler.bindEnter(typeToken), methodSizeHandler.bindEnter(typeToken), stackMapFrameHandler.bindEnter(typeToken), instrumentedType, instrumentedMethod, suppressionHandler, relocationHandler, exceptionHandler);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected MethodVisitor doApply(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, ArgumentHandler.ForAdvice argumentHandler, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, SuppressionHandler.Bound suppressionHandler, RelocationHandler.Bound relocationHandler, StackManipulation exceptionHandler) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        HashMap<Integer, OffsetMapping.Target> offsetMappings = new HashMap<Integer, OffsetMapping.Target>();
                        for (Map.Entry<Integer, OffsetMapping> entry : this.offsetMappings.entrySet()) {
                            offsetMappings.put(entry.getKey(), entry.getValue().resolve(instrumentedType, instrumentedMethod, assigner, argumentHandler, OffsetMapping.Sort.ENTER));
                        }
                        return new CodeTranslationVisitor((MethodVisitor)var1_1, (Implementation.Context)var2_2, argumentHandler, methodSizeHandler, stackMapFrameHandler, instrumentedType, instrumentedMethod, (Assigner)var3_3, this.adviceMethod, offsetMappings, suppressionHandler, relocationHandler, exceptionHandler, this.postProcessor, false);
                    }

                    @Override
                    public boolean equals(@MaybeNull Object object) {
                        if (!super.equals(object)) {
                            return false;
                        }
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (this.prependLineNumber != ((ForMethodEnter)object).prependLineNumber) {
                            return false;
                        }
                        return ((Object)this.namedTypes).equals(((ForMethodEnter)object).namedTypes);
                    }

                    @Override
                    public int hashCode() {
                        return (super.hashCode() * 31 + ((Object)this.namedTypes).hashCode()) * 31 + this.prependLineNumber;
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    protected static class WithDiscardedEnterType
                    extends ForMethodEnter {
                        /*
                         * WARNING - void declaration
                         */
                        protected WithDiscardedEnterType(MethodDescription.InDefinedShape adviceMethod, PostProcessor postProcessor, Map<String, TypeDefinition> namedTypes, List<? extends OffsetMapping.Factory<?>> userFactories, TypeDefinition exitType, AsmClassReader classReader) {
                            super((MethodDescription.InDefinedShape)var1_1, (PostProcessor)var2_2, (Map<String, TypeDefinition>)var3_3, userFactories, exitType, classReader);
                            void var3_3;
                            void var2_2;
                            void var1_1;
                        }

                        @Override
                        public TypeDefinition getAdviceType() {
                            return TypeDescription.ForLoadedType.of(Void.TYPE);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        protected MethodVisitor doApply(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, ArgumentHandler.ForAdvice argumentHandler, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, SuppressionHandler.Bound suppressionHandler, RelocationHandler.Bound relocationHandler, StackManipulation exceptionHandler) {
                            void var3_3;
                            void var2_2;
                            void var1_1;
                            methodSizeHandler.requireLocalVariableLengthPadding(this.adviceMethod.getReturnType().getStackSize().getSize());
                            return super.doApply((MethodVisitor)var1_1, (Implementation.Context)var2_2, (Assigner)var3_3, argumentHandler, methodSizeHandler, stackMapFrameHandler, instrumentedType, instrumentedMethod, suppressionHandler, relocationHandler, exceptionHandler);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    protected static class WithRetainedEnterType
                    extends ForMethodEnter {
                        /*
                         * WARNING - void declaration
                         */
                        protected WithRetainedEnterType(MethodDescription.InDefinedShape adviceMethod, PostProcessor postProcessor, Map<String, TypeDefinition> namedTypes, List<? extends OffsetMapping.Factory<?>> userFactories, TypeDefinition exitType, AsmClassReader classReader) {
                            super((MethodDescription.InDefinedShape)var1_1, (PostProcessor)var2_2, (Map<String, TypeDefinition>)var3_3, userFactories, exitType, classReader);
                            void var3_3;
                            void var2_2;
                            void var1_1;
                        }

                        @Override
                        public TypeDefinition getAdviceType() {
                            return this.adviceMethod.getReturnType();
                        }
                    }
                }

                protected class AdviceMethodInliner
                extends ClassVisitor
                implements Bound {
                    protected final TypeDescription instrumentedType;
                    protected final MethodDescription instrumentedMethod;
                    protected final MethodVisitor methodVisitor;
                    protected final Implementation.Context implementationContext;
                    protected final Assigner assigner;
                    protected final ArgumentHandler.ForInstrumentedMethod argumentHandler;
                    protected final MethodSizeHandler.ForInstrumentedMethod methodSizeHandler;
                    protected final StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler;
                    protected final SuppressionHandler.Bound suppressionHandler;
                    protected final RelocationHandler.Bound relocationHandler;
                    protected final StackManipulation exceptionHandler;
                    protected final AsmClassReader classReader;
                    protected final List<Label> labels;
                    final /* synthetic */ Resolved this$0;

                    /*
                     * WARNING - void declaration
                     */
                    protected AdviceMethodInliner(Resolved this$0, TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, ArgumentHandler.ForInstrumentedMethod argumentHandler, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler, RelocationHandler.Bound relocationHandler, StackManipulation exceptionHandler, AsmClassReader classReader) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.this$0 = var1_1;
                        super(OpenedClassReader.ASM_API);
                        this.instrumentedType = var2_2;
                        this.instrumentedMethod = var3_3;
                        this.methodVisitor = methodVisitor;
                        this.implementationContext = implementationContext;
                        this.assigner = assigner;
                        this.argumentHandler = argumentHandler;
                        this.methodSizeHandler = methodSizeHandler;
                        this.stackMapFrameHandler = stackMapFrameHandler;
                        this.suppressionHandler = suppressionHandler;
                        this.relocationHandler = relocationHandler;
                        this.exceptionHandler = exceptionHandler;
                        this.classReader = classReader;
                        this.labels = new ArrayList<Label>();
                    }

                    public void prepare() {
                        this.classReader.accept(new ExceptionTableExtractor(this), 6);
                        this.suppressionHandler.onPrepare(this.methodVisitor);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void initialize() {
                        for (Map.Entry<Integer, TypeDefinition> typeDefinition : this.this$0.resolveInitializationTypes(this.argumentHandler).entrySet()) {
                            void var2_2;
                            if (typeDefinition.getValue().represents(Boolean.TYPE) || typeDefinition.getValue().represents(Byte.TYPE) || typeDefinition.getValue().represents(Short.TYPE) || typeDefinition.getValue().represents(Character.TYPE) || typeDefinition.getValue().represents(Integer.TYPE)) {
                                this.methodVisitor.visitInsn(3);
                                this.methodVisitor.visitVarInsn(54, typeDefinition.getKey());
                            } else if (typeDefinition.getValue().represents(Long.TYPE)) {
                                this.methodVisitor.visitInsn(9);
                                this.methodVisitor.visitVarInsn(55, typeDefinition.getKey());
                            } else if (typeDefinition.getValue().represents(Float.TYPE)) {
                                this.methodVisitor.visitInsn(11);
                                this.methodVisitor.visitVarInsn(56, typeDefinition.getKey());
                            } else if (typeDefinition.getValue().represents(Double.TYPE)) {
                                this.methodVisitor.visitInsn(14);
                                this.methodVisitor.visitVarInsn(57, typeDefinition.getKey());
                            } else {
                                this.methodVisitor.visitInsn(1);
                                this.methodVisitor.visitVarInsn(58, typeDefinition.getKey());
                            }
                            this.methodSizeHandler.requireStackSize(((TypeDefinition)var2_2.getValue()).getStackSize().getSize());
                        }
                    }

                    public void apply() {
                        this.classReader.accept(this, 2 | this.stackMapFrameHandler.getReaderHint());
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @MaybeNull
                    public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, @MaybeNull String signature, @MaybeNull String[] exception) {
                        void var3_3;
                        void var2_2;
                        if (this.this$0.adviceMethod.getInternalName().equals(var2_2) && this.this$0.adviceMethod.getDescriptor().equals(var3_3)) {
                            AdviceMethodInliner adviceMethodInliner = this;
                            return new ExceptionTableSubstitutor(adviceMethodInliner, adviceMethodInliner.this$0.apply(this.methodVisitor, this.implementationContext, this.assigner, this.argumentHandler, this.methodSizeHandler, this.stackMapFrameHandler, this.instrumentedType, this.instrumentedMethod, this.suppressionHandler, this.relocationHandler, this.exceptionHandler));
                        }
                        return IGNORE_METHOD;
                    }

                    protected class ExceptionTableSubstitutor
                    extends MethodVisitor {
                        private final Map<Label, Label> substitutions;
                        private int index;
                        final /* synthetic */ AdviceMethodInliner this$1;

                        /*
                         * WARNING - void declaration
                         */
                        protected ExceptionTableSubstitutor(AdviceMethodInliner this$1, MethodVisitor methodVisitor) {
                            void var2_2;
                            void var1_1;
                            this.this$1 = var1_1;
                            super(OpenedClassReader.ASM_API, (MethodVisitor)var2_2);
                            this.substitutions = new IdentityHashMap<Label, Label>();
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                            void var1_1;
                            void var3_3;
                            void var2_2;
                            this.substitutions.put(start, this.this$1.labels.get(this.index++));
                            this.substitutions.put((Label)var2_2, this.this$1.labels.get(this.index++));
                            Label actualHandler = this.this$1.labels.get(this.index++);
                            this.substitutions.put((Label)var3_3, actualHandler);
                            ((CodeTranslationVisitor)this.mv).propagateHandler((Label)var1_1);
                        }

                        @MaybeNull
                        public AnnotationVisitor visitTryCatchAnnotation(int typeReference, @MaybeNull TypePath typePath, String descriptor, boolean visible) {
                            return IGNORE_ANNOTATION;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void visitLabel(Label label) {
                            void var1_1;
                            ExceptionTableSubstitutor exceptionTableSubstitutor = this;
                            super.visitLabel(exceptionTableSubstitutor.resolve((Label)var1_1));
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void visitJumpInsn(int opcode, Label label) {
                            void var2_2;
                            void var1_1;
                            super.visitJumpInsn((int)var1_1, this.resolve((Label)var2_2));
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void visitTableSwitchInsn(int minimum, int maximum, Label defaultOption, Label ... label) {
                            void var3_3;
                            void var2_2;
                            void var1_1;
                            super.visitTableSwitchInsn((int)var1_1, (int)var2_2, (Label)var3_3, this.resolve(label));
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void visitLookupSwitchInsn(Label defaultOption, int[] keys, Label[] label) {
                            void var3_3;
                            void var2_2;
                            void var1_1;
                            ExceptionTableSubstitutor exceptionTableSubstitutor = this;
                            super.visitLookupSwitchInsn(exceptionTableSubstitutor.resolve((Label)var1_1), (int[])var2_2, this.resolve((Label[])var3_3));
                        }

                        /*
                         * WARNING - void declaration
                         */
                        private Label[] resolve(Label[] label) {
                            void var2_2;
                            void var1_1;
                            Label[] resolved = new Label[label.length];
                            int index = 0;
                            for (void aLabel : var1_1) {
                                resolved[index++] = this.resolve((Label)aLabel);
                            }
                            return var2_2;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        private Label resolve(Label label) {
                            void var2_2;
                            Label substitution = this.substitutions.get(label);
                            if (substitution == null) {
                                void var1_1;
                                return var1_1;
                            }
                            return var2_2;
                        }
                    }

                    protected class ExceptionTableCollector
                    extends MethodVisitor {
                        private final MethodVisitor methodVisitor;
                        final /* synthetic */ AdviceMethodInliner this$1;

                        /*
                         * WARNING - void declaration
                         */
                        protected ExceptionTableCollector(AdviceMethodInliner this$1, MethodVisitor methodVisitor) {
                            void var2_2;
                            void var1_1;
                            this.this$1 = var1_1;
                            super(OpenedClassReader.ASM_API);
                            this.methodVisitor = var2_2;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void visitTryCatchBlock(Label start, Label end, Label handler, @MaybeNull String type) {
                            void var3_3;
                            void var2_2;
                            void var1_1;
                            this.methodVisitor.visitTryCatchBlock(start, end, handler, type);
                            this.this$1.labels.addAll(Arrays.asList(var1_1, var2_2, var3_3));
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @MaybeNull
                        public AnnotationVisitor visitTryCatchAnnotation(int typeReference, @MaybeNull TypePath typePath, String descriptor, boolean visible) {
                            void var3_3;
                            void var2_2;
                            void var1_1;
                            return this.methodVisitor.visitTryCatchAnnotation((int)var1_1, (TypePath)var2_2, (String)var3_3, visible);
                        }
                    }

                    protected class ExceptionTableExtractor
                    extends ClassVisitor {
                        final /* synthetic */ AdviceMethodInliner this$1;

                        /*
                         * WARNING - void declaration
                         */
                        protected ExceptionTableExtractor(AdviceMethodInliner this$1) {
                            void var1_1;
                            this.this$1 = var1_1;
                            super(OpenedClassReader.ASM_API);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @MaybeNull
                        public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, @MaybeNull String signature, @MaybeNull String[] exception) {
                            void var3_3;
                            void var2_2;
                            if (this.this$1.this$0.adviceMethod.getInternalName().equals(var2_2) && this.this$1.this$0.adviceMethod.getDescriptor().equals(var3_3)) {
                                return new ExceptionTableCollector(this.this$1, this.this$1.methodVisitor);
                            }
                            return IGNORE_METHOD;
                        }
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Inactive implements Bound,
        Resolved.ForMethodEnter,
        Resolved.ForMethodExit,
        Unresolved
        {
            INSTANCE;


            @Override
            public final boolean isAlive() {
                return false;
            }

            @Override
            public final boolean isBinary() {
                return false;
            }

            @Override
            public final TypeDescription getAdviceType() {
                return TypeDescription.ForLoadedType.of(Void.TYPE);
            }

            @Override
            public final boolean isPrependLineNumber() {
                return false;
            }

            @Override
            public final TypeDefinition getActualAdviceType() {
                return TypeDescription.ForLoadedType.of(Void.TYPE);
            }

            @Override
            public final Map<String, TypeDefinition> getNamedTypes() {
                return Collections.emptyMap();
            }

            @Override
            public final TypeDescription getThrowable() {
                return NoExceptionHandler.DESCRIPTION;
            }

            @Override
            public final ArgumentHandler.Factory getArgumentHandlerFactory() {
                return ArgumentHandler.Factory.SIMPLE;
            }

            @Override
            public final Resolved.ForMethodEnter asMethodEnter(List<? extends OffsetMapping.Factory<?>> userFactories, @MaybeNull AsmClassReader classReader, Unresolved methodExit, PostProcessor.Factory postProcessorFactory) {
                return this;
            }

            @Override
            public final Resolved.ForMethodExit asMethodExit(List<? extends OffsetMapping.Factory<?>> userFactories, @MaybeNull AsmClassReader classReader, Unresolved methodEnter, PostProcessor.Factory postProcessorFactory) {
                return this;
            }

            @Override
            public final void prepare() {
            }

            @Override
            public final void initialize() {
            }

            @Override
            public final void apply() {
            }

            @Override
            public final Bound bind(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, ArgumentHandler.ForInstrumentedMethod argumentHandler, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, StackManipulation exceptionHandler, RelocationHandler.Relocation relocation) {
                return this;
            }
        }

        public static interface Bound {
            public void prepare();

            public void initialize();

            public void apply();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Resolved
        extends Dispatcher {
            public Map<String, TypeDefinition> getNamedTypes();

            public Bound bind(TypeDescription var1, MethodDescription var2, MethodVisitor var3, Implementation.Context var4, Assigner var5, ArgumentHandler.ForInstrumentedMethod var6, MethodSizeHandler.ForInstrumentedMethod var7, StackMapFrameHandler.ForInstrumentedMethod var8, StackManipulation var9, RelocationHandler.Relocation var10);

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static abstract class AbstractBase
            implements Resolved {
                protected final PostProcessor postProcessor;
                protected final Map<Integer, OffsetMapping> offsetMappings;
                protected final SuppressionHandler suppressionHandler;
                protected final RelocationHandler relocationHandler;

                /*
                 * WARNING - void declaration
                 */
                protected AbstractBase(MethodDescription.InDefinedShape adviceMethod, PostProcessor postProcessor, List<? extends OffsetMapping.Factory<?>> factories, TypeDescription throwableType, TypeDescription relocatableType, int relocatableIndex, OffsetMapping.Factory.AdviceType adviceType) {
                    void var1_1;
                    Iterator iterator;
                    this.postProcessor = postProcessor;
                    HashMap<TypeDescription, OffsetMapping.Factory> offsetMappings = new HashMap<TypeDescription, OffsetMapping.Factory>();
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        OffsetMapping.Factory factory = (OffsetMapping.Factory)iterator.next();
                        offsetMappings.put(TypeDescription.ForLoadedType.of(factory.getAnnotationType()), factory);
                    }
                    this.offsetMappings = new LinkedHashMap<Integer, OffsetMapping>();
                    for (ParameterDescription.InDefinedShape parameterDescription : adviceMethod.getParameters()) {
                        OffsetMapping offsetMapping = null;
                        for (AnnotationDescription annotationDescription : parameterDescription.getDeclaredAnnotations()) {
                            OffsetMapping.Factory factory = (OffsetMapping.Factory)offsetMappings.get(annotationDescription.getAnnotationType());
                            if (factory == null) continue;
                            OffsetMapping current = factory.make(parameterDescription, annotationDescription.prepare(factory.getAnnotationType()), adviceType);
                            if (offsetMapping == null) {
                                offsetMapping = current;
                                continue;
                            }
                            throw new IllegalStateException(parameterDescription + " is bound to both " + current + " and " + offsetMapping);
                        }
                        this.offsetMappings.put(parameterDescription.getOffset(), offsetMapping == null ? new OffsetMapping.ForArgument.Unresolved(parameterDescription) : offsetMapping);
                    }
                    this.suppressionHandler = SuppressionHandler.Suppressing.of(throwableType);
                    this.relocationHandler = RelocationHandler.ForType.of(relocatableType, relocatableIndex, var1_1.getReturnType());
                }

                @Override
                public boolean isAlive() {
                    return true;
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.postProcessor.equals(((AbstractBase)object).postProcessor)) {
                        return false;
                    }
                    if (!((Object)this.offsetMappings).equals(((AbstractBase)object).offsetMappings)) {
                        return false;
                    }
                    if (!this.suppressionHandler.equals(((AbstractBase)object).suppressionHandler)) {
                        return false;
                    }
                    return this.relocationHandler.equals(((AbstractBase)object).relocationHandler);
                }

                public int hashCode() {
                    return (((this.getClass().hashCode() * 31 + this.postProcessor.hashCode()) * 31 + ((Object)this.offsetMappings).hashCode()) * 31 + this.suppressionHandler.hashCode()) * 31 + this.relocationHandler.hashCode();
                }
            }

            public static interface ForMethodExit
            extends Resolved {
                public TypeDescription getThrowable();

                public ArgumentHandler.Factory getArgumentHandlerFactory();
            }

            public static interface ForMethodEnter
            extends Resolved {
                public boolean isPrependLineNumber();

                public TypeDefinition getActualAdviceType();
            }
        }

        public static interface RelocationHandler {
            public Bound bind(MethodDescription var1, Relocation var2);

            @HashCodeAndEqualsPlugin.Enhance
            public static class ForType
            implements RelocationHandler {
                private final TypeDescription typeDescription;
                private final int index;

                /*
                 * WARNING - void declaration
                 */
                protected ForType(TypeDescription typeDescription, int index) {
                    void var2_2;
                    void var1_1;
                    this.typeDescription = var1_1;
                    this.index = var2_2;
                }

                /*
                 * WARNING - void declaration
                 */
                @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming component type for array type.")
                protected static RelocationHandler of(TypeDescription typeDescription, int index, TypeDefinition returnedType) {
                    void var1_1;
                    TypeDescription typeDescription2;
                    void var2_2;
                    TypeDefinition targetType;
                    if (index >= 0) {
                        if (targetType.isArray()) {
                            targetType = targetType.getComponentType();
                        } else {
                            throw new IllegalStateException(targetType + " is not an array type but an index for a relocation is defined");
                        }
                    }
                    if (typeDescription.represents(Void.TYPE)) {
                        return Disabled.INSTANCE;
                    }
                    if (typeDescription.represents((java.lang.reflect.Type)((Object)OnDefaultValue.class))) {
                        return ForValue.of(targetType, index, false);
                    }
                    if (typeDescription.represents((java.lang.reflect.Type)((Object)OnNonDefaultValue.class))) {
                        return ForValue.of(targetType, index, true);
                    }
                    if (typeDescription.isPrimitive() || var2_2.isPrimitive()) {
                        throw new IllegalStateException("Cannot relocate execution by instance type for primitive type");
                    }
                    return new ForType(typeDescription2, (int)var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                public net.bytebuddy.asm.Advice$Dispatcher$RelocationHandler$Bound bind(MethodDescription instrumentedMethod, Relocation relocation) {
                    void var2_2;
                    void var1_1;
                    return new Bound(this, (MethodDescription)var1_1, (Relocation)var2_2);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (this.index != ((ForType)object).index) {
                        return false;
                    }
                    return this.typeDescription.equals(((ForType)object).typeDescription);
                }

                public int hashCode() {
                    return (this.getClass().hashCode() * 31 + this.typeDescription.hashCode()) * 31 + this.index;
                }

                @HashCodeAndEqualsPlugin.Enhance(includeSyntheticFields=true)
                protected class Bound
                implements net.bytebuddy.asm.Advice$Dispatcher$RelocationHandler$Bound {
                    private final MethodDescription instrumentedMethod;
                    private final Relocation relocation;
                    final /* synthetic */ ForType this$0;

                    /*
                     * WARNING - void declaration
                     */
                    protected Bound(ForType this$0, MethodDescription instrumentedMethod, Relocation relocation) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.this$0 = var1_1;
                        this.instrumentedMethod = var2_2;
                        this.relocation = var3_3;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public int apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, int offset) {
                        void var2_3;
                        void var1_1;
                        int size22;
                        if (this.instrumentedMethod.isConstructor()) {
                            throw new IllegalStateException("Cannot skip code execution from constructor: " + this.instrumentedMethod);
                        }
                        methodVisitor.visitVarInsn(25, offset);
                        Label noSkip = new Label();
                        if (this.this$0.index < 0) {
                            size22 = 0;
                        } else {
                            void size22;
                            void var3_4;
                            methodVisitor.visitJumpInsn(198, noSkip);
                            methodVisitor.visitVarInsn(25, (int)var3_4);
                            size22 = IntegerConstant.forValue(this.this$0.index).apply(methodVisitor, (Implementation.Context)size22).getMaximalSize() + 1;
                            methodVisitor.visitInsn(50);
                        }
                        methodVisitor.visitTypeInsn(193, this.this$0.typeDescription.getInternalName());
                        methodVisitor.visitJumpInsn(153, noSkip);
                        this.relocation.apply(methodVisitor);
                        var1_1.visitLabel(noSkip);
                        return (int)var2_3;
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (!this.instrumentedMethod.equals(((Bound)object).instrumentedMethod)) {
                            return false;
                        }
                        if (!this.relocation.equals(((Bound)object).relocation)) {
                            return false;
                        }
                        return this.this$0.equals(((Bound)object).this$0);
                    }

                    public int hashCode() {
                        return ((this.getClass().hashCode() * 31 + this.instrumentedMethod.hashCode()) * 31 + this.relocation.hashCode()) * 31 + this.this$0.hashCode();
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum ForValue {
                BOOLEAN(21, 51, 154, 153, 0){
                    {
                        void var3_3;
                    }

                    protected final void convertValue(MethodVisitor methodVisitor) {
                    }
                }
                ,
                BYTE(21, 51, 154, 153, 0){
                    {
                        void var3_3;
                    }

                    protected final void convertValue(MethodVisitor methodVisitor) {
                    }
                }
                ,
                SHORT(21, 53, 154, 153, 0){
                    {
                        void var3_3;
                    }

                    protected final void convertValue(MethodVisitor methodVisitor) {
                    }
                }
                ,
                CHARACTER(21, 52, 154, 153, 0){
                    {
                        void var3_3;
                    }

                    protected final void convertValue(MethodVisitor methodVisitor) {
                    }
                }
                ,
                INTEGER(21, 46, 154, 153, 0){
                    {
                        void var3_3;
                    }

                    protected final void convertValue(MethodVisitor methodVisitor) {
                    }
                }
                ,
                LONG(22, 47, 154, 153, 0){
                    {
                        void var3_3;
                    }

                    protected final void convertValue(MethodVisitor methodVisitor) {
                        methodVisitor.visitInsn(136);
                    }
                }
                ,
                FLOAT(23, 48, 154, 153, 2){
                    {
                        void var3_3;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected final void convertValue(MethodVisitor methodVisitor) {
                        void var1_1;
                        methodVisitor.visitInsn(11);
                        var1_1.visitInsn(149);
                    }
                }
                ,
                DOUBLE(24, 49, 154, 153, 4){
                    {
                        void var3_3;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected final void convertValue(MethodVisitor methodVisitor) {
                        void var1_1;
                        methodVisitor.visitInsn(14);
                        var1_1.visitInsn(151);
                    }
                }
                ,
                REFERENCE(25, 50, 199, 198, 0){
                    {
                        void var3_3;
                    }

                    protected final void convertValue(MethodVisitor methodVisitor) {
                    }
                };

                private final int load;
                private final int arrayLoad;
                private final int defaultJump;
                private final int nonDefaultJump;
                private final int requiredSize;

                /*
                 * WARNING - void declaration
                 */
                private ForValue(int load, int arrayLoad, int defaultJump, int nonDefaultJump, int requiredSize) {
                    void var3_3;
                    this.load = var3_3;
                    this.arrayLoad = arrayLoad;
                    this.defaultJump = defaultJump;
                    this.nonDefaultJump = nonDefaultJump;
                    this.requiredSize = requiredSize;
                }

                /*
                 * WARNING - void declaration
                 */
                protected static RelocationHandler of(TypeDefinition typeDefinition, int index, boolean inverted) {
                    void var1_1;
                    Object object;
                    void var2_2;
                    Object skipDispatcher;
                    if (typeDefinition.represents(Boolean.TYPE)) {
                        skipDispatcher = BOOLEAN;
                    } else if (skipDispatcher.represents(Byte.TYPE)) {
                        skipDispatcher = BYTE;
                    } else if (skipDispatcher.represents(Short.TYPE)) {
                        skipDispatcher = SHORT;
                    } else if (skipDispatcher.represents(Character.TYPE)) {
                        skipDispatcher = CHARACTER;
                    } else if (skipDispatcher.represents(Integer.TYPE)) {
                        skipDispatcher = INTEGER;
                    } else if (skipDispatcher.represents(Long.TYPE)) {
                        skipDispatcher = LONG;
                    } else if (skipDispatcher.represents(Float.TYPE)) {
                        skipDispatcher = FLOAT;
                    } else if (skipDispatcher.represents(Double.TYPE)) {
                        skipDispatcher = DOUBLE;
                    } else {
                        if (skipDispatcher.represents(Void.TYPE)) {
                            throw new IllegalStateException("Cannot skip on default value for void return type");
                        }
                        skipDispatcher = REFERENCE;
                    }
                    if (var2_2 != false) {
                        TypeDefinition typeDefinition2 = skipDispatcher;
                        typeDefinition2.getClass();
                        return new OfNonDefault((ForValue)((Object)typeDefinition2), index);
                    }
                    TypeDefinition typeDefinition3 = object;
                    typeDefinition3.getClass();
                    return new OfDefault((ForValue)((Object)typeDefinition3), (int)var1_1);
                }

                protected abstract void convertValue(MethodVisitor var1);

                @HashCodeAndEqualsPlugin.Enhance(includeSyntheticFields=true)
                protected class Bound
                implements net.bytebuddy.asm.Advice$Dispatcher$RelocationHandler$Bound {
                    private final MethodDescription instrumentedMethod;
                    private final Relocation relocation;
                    private final int index;
                    private final boolean inverted;
                    final /* synthetic */ ForValue this$0;

                    /*
                     * WARNING - void declaration
                     */
                    protected Bound(ForValue this$0, MethodDescription instrumentedMethod, Relocation relocation, int index, boolean inverted) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.this$0 = var1_1;
                        this.instrumentedMethod = var2_2;
                        this.relocation = var3_3;
                        this.index = index;
                        this.inverted = inverted;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public int apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, int offset) {
                        void var2_3;
                        void var1_1;
                        int size22;
                        if (this.instrumentedMethod.isConstructor()) {
                            throw new IllegalStateException("Cannot skip code execution from constructor: " + this.instrumentedMethod);
                        }
                        Label noSkip = new Label();
                        if (this.index < 0) {
                            size22 = this.this$0.requiredSize;
                            methodVisitor.visitVarInsn(this.this$0.load, offset);
                        } else {
                            void size22;
                            void var3_4;
                            methodVisitor.visitVarInsn(25, offset);
                            methodVisitor.visitJumpInsn(198, noSkip);
                            methodVisitor.visitVarInsn(25, (int)var3_4);
                            size22 = Math.max(this.this$0.requiredSize, IntegerConstant.forValue(this.index).apply(methodVisitor, (Implementation.Context)size22).getMaximalSize() + 1);
                            methodVisitor.visitInsn(this.this$0.arrayLoad);
                        }
                        this.this$0.convertValue(methodVisitor);
                        methodVisitor.visitJumpInsn(this.inverted ? this.this$0.nonDefaultJump : this.this$0.defaultJump, noSkip);
                        this.relocation.apply(methodVisitor);
                        var1_1.visitLabel(noSkip);
                        return (int)var2_3;
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (this.index != ((Bound)object).index) {
                            return false;
                        }
                        if (this.inverted != ((Bound)object).inverted) {
                            return false;
                        }
                        if (!this.this$0.equals((Object)((Bound)object).this$0)) {
                            return false;
                        }
                        if (!this.instrumentedMethod.equals(((Bound)object).instrumentedMethod)) {
                            return false;
                        }
                        return this.relocation.equals(((Bound)object).relocation);
                    }

                    public int hashCode() {
                        return ((((this.getClass().hashCode() * 31 + this.instrumentedMethod.hashCode()) * 31 + this.relocation.hashCode()) * 31 + this.index) * 31 + this.inverted) * 31 + this.this$0.hashCode();
                    }
                }

                @HashCodeAndEqualsPlugin.Enhance(includeSyntheticFields=true)
                protected class OfNonDefault
                implements RelocationHandler {
                    private final int index;
                    final /* synthetic */ ForValue this$0;

                    /*
                     * WARNING - void declaration
                     */
                    protected OfNonDefault(ForValue this$0, int index) {
                        void var2_2;
                        void var1_1;
                        this.this$0 = var1_1;
                        this.index = var2_2;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public net.bytebuddy.asm.Advice$Dispatcher$RelocationHandler$Bound bind(MethodDescription instrumentedMethod, Relocation relocation) {
                        void var2_2;
                        void var1_1;
                        return new Bound(this.this$0, (MethodDescription)var1_1, (Relocation)var2_2, this.index, true);
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (this.index != ((OfNonDefault)object).index) {
                            return false;
                        }
                        return this.this$0.equals((Object)((OfNonDefault)object).this$0);
                    }

                    public int hashCode() {
                        return (this.getClass().hashCode() * 31 + this.index) * 31 + this.this$0.hashCode();
                    }
                }

                @HashCodeAndEqualsPlugin.Enhance(includeSyntheticFields=true)
                protected class OfDefault
                implements RelocationHandler {
                    private final int index;
                    final /* synthetic */ ForValue this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public OfDefault(ForValue this$0, int index) {
                        void var2_2;
                        void var1_1;
                        this.this$0 = var1_1;
                        this.index = var2_2;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public net.bytebuddy.asm.Advice$Dispatcher$RelocationHandler$Bound bind(MethodDescription instrumentedMethod, Relocation relocation) {
                        void var2_2;
                        void var1_1;
                        return new Bound(this.this$0, (MethodDescription)var1_1, (Relocation)var2_2, this.index, false);
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (this.index != ((OfDefault)object).index) {
                            return false;
                        }
                        return this.this$0.equals((Object)((OfDefault)object).this$0);
                    }

                    public int hashCode() {
                        return (this.getClass().hashCode() * 31 + this.index) * 31 + this.this$0.hashCode();
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Disabled implements RelocationHandler,
            Bound
            {
                INSTANCE;


                @Override
                public final Bound bind(MethodDescription instrumentedMethod, Relocation relocation) {
                    return this;
                }

                @Override
                public final int apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, int offset) {
                    return 0;
                }
            }

            public static interface Bound {
                public static final int NO_REQUIRED_SIZE = 0;

                public int apply(MethodVisitor var1, Implementation.Context var2, int var3);
            }

            public static interface Relocation {
                public void apply(MethodVisitor var1);

                @HashCodeAndEqualsPlugin.Enhance
                public static class ForLabel
                implements Relocation {
                    private final Label label;

                    /*
                     * WARNING - void declaration
                     */
                    public ForLabel(Label label) {
                        void var1_1;
                        this.label = var1_1;
                    }

                    public void apply(MethodVisitor methodVisitor) {
                        methodVisitor.visitJumpInsn(167, this.label);
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        return this.label.equals(((ForLabel)object).label);
                    }

                    public int hashCode() {
                        return this.getClass().hashCode() * 31 + this.label.hashCode();
                    }
                }
            }
        }

        public static interface SuppressionHandler {
            public Bound bind(StackManipulation var1);

            @HashCodeAndEqualsPlugin.Enhance
            public static class Suppressing
            implements SuppressionHandler {
                private final TypeDescription suppressedType;

                /*
                 * WARNING - void declaration
                 */
                protected Suppressing(TypeDescription suppressedType) {
                    void var1_1;
                    this.suppressedType = var1_1;
                }

                protected static SuppressionHandler of(TypeDescription suppressedType) {
                    TypeDescription typeDescription;
                    if (suppressedType.represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class))) {
                        return NoOp.INSTANCE;
                    }
                    return new Suppressing(typeDescription);
                }

                /*
                 * WARNING - void declaration
                 */
                public net.bytebuddy.asm.Advice$Dispatcher$SuppressionHandler$Bound bind(StackManipulation exceptionHandler) {
                    void var1_1;
                    return new Bound(this.suppressedType, (StackManipulation)var1_1);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.suppressedType.equals(((Suppressing)object).suppressedType);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.suppressedType.hashCode();
                }

                protected static class Bound
                implements net.bytebuddy.asm.Advice$Dispatcher$SuppressionHandler$Bound {
                    private final TypeDescription suppressedType;
                    private final StackManipulation exceptionHandler;
                    private final Label startOfMethod;
                    private final Label endOfMethod;

                    /*
                     * WARNING - void declaration
                     */
                    protected Bound(TypeDescription suppressedType, StackManipulation exceptionHandler) {
                        void var2_2;
                        void var1_1;
                        this.suppressedType = var1_1;
                        this.exceptionHandler = var2_2;
                        this.startOfMethod = new Label();
                        this.endOfMethod = new Label();
                    }

                    public void onPrepare(MethodVisitor methodVisitor) {
                        methodVisitor.visitTryCatchBlock(this.startOfMethod, this.endOfMethod, this.endOfMethod, this.suppressedType.getInternalName());
                    }

                    public void onStart(MethodVisitor methodVisitor) {
                        methodVisitor.visitLabel(this.startOfMethod);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void onEnd(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, TypeDefinition returnType) {
                        void var2_2;
                        void var3_3;
                        methodVisitor.visitLabel(this.endOfMethod);
                        stackMapFrameHandler.injectExceptionFrame(methodVisitor);
                        var3_3.requireStackSize(1 + this.exceptionHandler.apply(methodVisitor, (Implementation.Context)var2_2).getMaximalSize());
                        if (returnType.represents(Boolean.TYPE) || returnType.represents(Byte.TYPE) || returnType.represents(Short.TYPE) || returnType.represents(Character.TYPE) || returnType.represents(Integer.TYPE)) {
                            methodVisitor.visitInsn(3);
                            return;
                        }
                        if (returnType.represents(Long.TYPE)) {
                            methodVisitor.visitInsn(9);
                            return;
                        }
                        if (returnType.represents(Float.TYPE)) {
                            methodVisitor.visitInsn(11);
                            return;
                        }
                        if (returnType.represents(Double.TYPE)) {
                            methodVisitor.visitInsn(14);
                            return;
                        }
                        if (!returnType.represents(Void.TYPE)) {
                            void var1_1;
                            var1_1.visitInsn(1);
                        }
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void onEndWithSkip(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, TypeDefinition returnType) {
                        void var1_1;
                        void var3_3;
                        void var2_2;
                        Label skipExceptionHandler = new Label();
                        methodVisitor.visitJumpInsn(167, skipExceptionHandler);
                        this.onEnd(methodVisitor, (Implementation.Context)var2_2, (MethodSizeHandler.ForAdvice)var3_3, stackMapFrameHandler, returnType);
                        methodVisitor.visitLabel(skipExceptionHandler);
                        stackMapFrameHandler.injectReturnFrame((MethodVisitor)var1_1);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum NoOp implements SuppressionHandler,
            Bound
            {
                INSTANCE;


                @Override
                public final Bound bind(StackManipulation exceptionHandler) {
                    return this;
                }

                @Override
                public final void onPrepare(MethodVisitor methodVisitor) {
                }

                @Override
                public final void onStart(MethodVisitor methodVisitor) {
                }

                @Override
                public final void onEnd(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, TypeDefinition returnType) {
                }

                @Override
                public final void onEndWithSkip(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, TypeDefinition returnType) {
                }
            }

            public static interface Bound {
                public void onPrepare(MethodVisitor var1);

                public void onStart(MethodVisitor var1);

                public void onEnd(MethodVisitor var1, Implementation.Context var2, MethodSizeHandler.ForAdvice var3, StackMapFrameHandler.ForAdvice var4, TypeDefinition var5);

                public void onEndWithSkip(MethodVisitor var1, Implementation.Context var2, MethodSizeHandler.ForAdvice var3, StackMapFrameHandler.ForAdvice var4, TypeDefinition var5);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Unresolved
        extends Dispatcher {
            public boolean isBinary();

            public Map<String, TypeDefinition> getNamedTypes();

            public Resolved.ForMethodEnter asMethodEnter(List<? extends OffsetMapping.Factory<?>> var1, @MaybeNull AsmClassReader var2, Unresolved var3, PostProcessor.Factory var4);

            public Resolved.ForMethodExit asMethodExit(List<? extends OffsetMapping.Factory<?>> var1, @MaybeNull AsmClassReader var2, Unresolved var3, PostProcessor.Factory var4);
        }
    }

    public static interface ExceptionHandler {
        public StackManipulation resolve(MethodDescription var1, TypeDescription var2);

        @HashCodeAndEqualsPlugin.Enhance
        public static class Simple
        implements ExceptionHandler {
            private final StackManipulation stackManipulation;

            /*
             * WARNING - void declaration
             */
            public Simple(StackManipulation stackManipulation) {
                void var1_1;
                this.stackManipulation = var1_1;
            }

            public StackManipulation resolve(MethodDescription instrumentedMethod, TypeDescription instrumentedType) {
                return this.stackManipulation;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.stackManipulation.equals(((Simple)object).stackManipulation);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.stackManipulation.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Default implements ExceptionHandler
        {
            SUPPRESSING{

                public final StackManipulation resolve(MethodDescription instrumentedMethod, TypeDescription instrumentedType) {
                    return Removal.SINGLE;
                }
            }
            ,
            PRINTING{

                public final StackManipulation resolve(MethodDescription instrumentedMethod, TypeDescription instrumentedType) {
                    try {
                        return MethodInvocation.invoke(new MethodDescription.ForLoadedMethod(Throwable.class.getMethod("printStackTrace", new Class[0])));
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new IllegalStateException("Cannot locate Throwable::printStackTrace");
                    }
                }
            }
            ,
            RETHROWING{

                public final StackManipulation resolve(MethodDescription instrumentedMethod, TypeDescription instrumentedType) {
                    return Throw.INSTANCE;
                }
            };

        }
    }

    public static interface StackMapFrameHandler {
        public void translateFrame(MethodVisitor var1, int var2, int var3, @MaybeNull Object[] var4, int var5, @MaybeNull Object[] var6);

        public void injectReturnFrame(MethodVisitor var1);

        public void injectExceptionFrame(MethodVisitor var1);

        public void injectCompletionFrame(MethodVisitor var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class Default
        implements ForInstrumentedMethod {
            protected static final Object[] EMPTY = new Object[0];
            protected final TypeDescription instrumentedType;
            protected final MethodDescription instrumentedMethod;
            protected final List<? extends TypeDescription> initialTypes;
            protected final List<? extends TypeDescription> latentTypes;
            protected final List<? extends TypeDescription> preMethodTypes;
            protected final List<? extends TypeDescription> postMethodTypes;
            protected final boolean expandFrames;
            protected int currentFrameDivergence;

            /*
             * WARNING - void declaration
             */
            protected Default(TypeDescription instrumentedType, MethodDescription instrumentedMethod, List<? extends TypeDescription> initialTypes, List<? extends TypeDescription> latentTypes, List<? extends TypeDescription> preMethodTypes, List<? extends TypeDescription> postMethodTypes, boolean expandFrames) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.instrumentedType = var1_1;
                this.instrumentedMethod = var2_2;
                this.initialTypes = var3_3;
                this.latentTypes = latentTypes;
                this.preMethodTypes = preMethodTypes;
                this.postMethodTypes = postMethodTypes;
                this.expandFrames = expandFrames;
            }

            /*
             * WARNING - void declaration
             */
            protected static ForInstrumentedMethod of(TypeDescription instrumentedType, MethodDescription instrumentedMethod, List<? extends TypeDescription> initialTypes, List<? extends TypeDescription> latentTypes, List<? extends TypeDescription> preMethodTypes, List<? extends TypeDescription> postMethodTypes, boolean exitAdvice, boolean copyArguments, ClassFileVersion classFileVersion, int writerFlags, int readerFlags) {
                void var1_1;
                void var3_3;
                void var2_2;
                TypeDescription typeDescription;
                if ((writerFlags & 2) != 0 || classFileVersion.isLessThan(ClassFileVersion.JAVA_V6)) {
                    return NoOp.INSTANCE;
                }
                if (!exitAdvice && initialTypes.isEmpty()) {
                    return new Trivial(instrumentedType, instrumentedMethod, latentTypes, (readerFlags & 8) != 0);
                }
                if (copyArguments) {
                    return new WithPreservedArguments.WithArgumentCopy(instrumentedType, instrumentedMethod, initialTypes, latentTypes, preMethodTypes, postMethodTypes, (readerFlags & 8) != 0);
                }
                return new WithPreservedArguments.WithoutArgumentCopy(typeDescription, instrumentedMethod, (List<? extends TypeDescription>)var2_2, (List<? extends TypeDescription>)var3_3, preMethodTypes, postMethodTypes, (readerFlags & 8) != 0, !var1_1.isConstructor());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public net.bytebuddy.asm.Advice$StackMapFrameHandler$ForAdvice bindEnter(MethodDescription.TypeToken typeToken) {
                void var1_1;
                return new ForAdvice(this, (MethodDescription.TypeToken)var1_1, this.initialTypes, this.latentTypes, this.preMethodTypes, TranslationMode.ENTER, this.instrumentedMethod.isConstructor() ? Initialization.UNITIALIZED : Initialization.INITIALIZED);
            }

            @Override
            public int getReaderHint() {
                if (this.expandFrames) {
                    return 8;
                }
                return 0;
            }

            /*
             * WARNING - void declaration
             */
            protected void translateFrame(MethodVisitor methodVisitor, TranslationMode translationMode, boolean isStatic, MethodDescription.TypeToken typeToken, List<? extends TypeDescription> additionalTypes, int type, int localVariableLength, @MaybeNull Object[] localVariable, int stackSize, @MaybeNull Object[] stack) {
                void var1_1;
                int n;
                switch (type) {
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 1: {
                        this.currentFrameDivergence += localVariableLength;
                        break;
                    }
                    case 2: {
                        this.currentFrameDivergence -= localVariableLength;
                        if (this.currentFrameDivergence >= 0) break;
                        throw new IllegalStateException(typeToken + " dropped " + Math.abs(this.currentFrameDivergence) + " implicit frames");
                    }
                    case -1: 
                    case 0: {
                        void var2_3;
                        int offset;
                        if (typeToken.getParameterTypes().size() + (isStatic ? 0 : 1) > localVariableLength) {
                            throw new IllegalStateException("Inconsistent frame length for " + typeToken + ": " + localVariableLength);
                        }
                        if (isStatic) {
                            offset = 0;
                        } else {
                            if (!translationMode.isPossibleThisFrameValue(this.instrumentedType, this.instrumentedMethod, localVariable[0])) {
                                throw new IllegalStateException(typeToken + " is inconsistent for 'this' reference: " + localVariable[0]);
                            }
                            offset = 1;
                        }
                        for (int index = 0; index < typeToken.getParameterTypes().size(); ++index) {
                            if (Initialization.INITIALIZED.toFrame(typeToken.getParameterTypes().get(index)).equals(localVariable[index + offset])) continue;
                            throw new IllegalStateException(typeToken + " is inconsistent at " + index + ": " + localVariable[index + offset]);
                        }
                        Object[] translated = new Object[localVariableLength - (isStatic ? 0 : 1) - typeToken.getParameterTypes().size() + (this.instrumentedMethod.isStatic() ? 0 : 1) + this.instrumentedMethod.getParameters().size() + additionalTypes.size()];
                        int index = translationMode.copy(this.instrumentedType, this.instrumentedMethod, localVariable, translated);
                        for (TypeDescription typeDescription : additionalTypes) {
                            translated[index++] = Initialization.INITIALIZED.toFrame(typeDescription);
                        }
                        if (translated.length != index) {
                            void var3_4;
                            System.arraycopy(localVariable, typeToken.getParameterTypes().size() + (var3_4 != false ? 0 : 1), translated, index, translated.length - index);
                        }
                        n = translated.length;
                        localVariable = translated;
                        this.currentFrameDivergence = translated.length - var2_3;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected frame type: " + type);
                    }
                }
                var1_1.visitFrame(type, n, localVariable, (int)stackSize, (Object[])stack);
            }

            /*
             * WARNING - void declaration
             */
            protected void injectFullFrame(MethodVisitor methodVisitor, Initialization initialization, List<? extends TypeDescription> typesInArray, List<? extends TypeDescription> typesOnStack) {
                void var2_2;
                void var1_1;
                Object[] localVariable = new Object[this.instrumentedMethod.getParameters().size() + (this.instrumentedMethod.isStatic() ? 0 : 1) + typesInArray.size()];
                int index = 0;
                if (!this.instrumentedMethod.isStatic()) {
                    ++index;
                    localVariable[0] = ((Initialization)((Object)initialization)).toFrame(this.instrumentedType);
                }
                for (TypeDescription typeDescription : this.instrumentedMethod.getParameters().asTypeList().asErasures()) {
                    localVariable[index++] = Initialization.INITIALIZED.toFrame(typeDescription);
                }
                for (TypeDescription typeDescription : typesInArray) {
                    localVariable[index++] = Initialization.INITIALIZED.toFrame(typeDescription);
                }
                index = 0;
                Object[] stackType = new Object[typesOnStack.size()];
                for (TypeDescription typeDescription : typesOnStack) {
                    void var3_5;
                    stackType[index++] = Initialization.INITIALIZED.toFrame((TypeDescription)var3_5);
                }
                var1_1.visitFrame(this.expandFrames ? -1 : 0, localVariable.length, localVariable, stackType.length, (Object[])var2_2);
                this.currentFrameDivergence = 0;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected class ForAdvice
            implements net.bytebuddy.asm.Advice$StackMapFrameHandler$ForAdvice {
                protected final MethodDescription.TypeToken typeToken;
                protected final List<? extends TypeDescription> startTypes;
                private final List<? extends TypeDescription> intermediateTypes;
                protected final List<? extends TypeDescription> endTypes;
                protected final TranslationMode translationMode;
                private final Initialization initialization;
                private boolean intermediate;
                final /* synthetic */ Default this$0;

                /*
                 * WARNING - void declaration
                 */
                protected ForAdvice(Default this$0, MethodDescription.TypeToken typeToken, List<? extends TypeDescription> startTypes, List<? extends TypeDescription> intermediateTypes, List<? extends TypeDescription> endTypes, TranslationMode translationMode, Initialization initialization) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.typeToken = var2_2;
                    this.startTypes = var3_3;
                    this.intermediateTypes = intermediateTypes;
                    this.endTypes = endTypes;
                    this.translationMode = translationMode;
                    this.initialization = initialization;
                    this.intermediate = false;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void translateFrame(MethodVisitor methodVisitor, int type, int localVariableLength, @MaybeNull Object[] localVariable, int stackSize, @MaybeNull Object[] stack) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0.translateFrame((MethodVisitor)var1_1, this.translationMode, true, this.typeToken, this.startTypes, (int)var2_2, (int)var3_3, localVariable, stackSize, stack);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void injectReturnFrame(MethodVisitor methodVisitor) {
                    void var1_1;
                    if (!this.this$0.expandFrames && this.this$0.currentFrameDivergence == 0) {
                        if (this.typeToken.getReturnType().represents(Void.TYPE)) {
                            methodVisitor.visitFrame(3, EMPTY.length, EMPTY, EMPTY.length, EMPTY);
                            return;
                        }
                        methodVisitor.visitFrame(4, EMPTY.length, EMPTY, 1, new Object[]{Initialization.INITIALIZED.toFrame(this.typeToken.getReturnType())});
                        return;
                    }
                    this.this$0.injectFullFrame((MethodVisitor)var1_1, this.initialization, this.startTypes, this.typeToken.getReturnType().represents(Void.TYPE) ? Collections.emptyList() : Collections.singletonList(this.typeToken.getReturnType()));
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void injectExceptionFrame(MethodVisitor methodVisitor) {
                    void var1_1;
                    if (!this.this$0.expandFrames && this.this$0.currentFrameDivergence == 0) {
                        methodVisitor.visitFrame(4, EMPTY.length, EMPTY, 1, new Object[]{Type.getInternalName(Throwable.class)});
                        return;
                    }
                    this.this$0.injectFullFrame((MethodVisitor)var1_1, this.initialization, this.startTypes, Collections.singletonList(TypeDescription.ForLoadedType.of(Throwable.class)));
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void injectCompletionFrame(MethodVisitor methodVisitor) {
                    void var1_1;
                    if (!this.this$0.expandFrames) {
                        if (this.this$0.currentFrameDivergence == 0 && (this.intermediate || this.endTypes.size() < 4)) {
                            void var2_2;
                            if (this.intermediate || this.endTypes.isEmpty()) {
                                methodVisitor.visitFrame(3, EMPTY.length, EMPTY, EMPTY.length, EMPTY);
                                return;
                            }
                            Object[] local = new Object[this.endTypes.size()];
                            int index = 0;
                            for (TypeDescription typeDescription : this.endTypes) {
                                local[index++] = Initialization.INITIALIZED.toFrame(typeDescription);
                            }
                            methodVisitor.visitFrame(1, local.length, (Object[])var2_2, EMPTY.length, EMPTY);
                            return;
                        }
                        if (this.this$0.currentFrameDivergence < 3 && this.endTypes.isEmpty()) {
                            methodVisitor.visitFrame(2, this.this$0.currentFrameDivergence, EMPTY, EMPTY.length, EMPTY);
                            this.this$0.currentFrameDivergence = 0;
                            return;
                        }
                    }
                    this.this$0.injectFullFrame((MethodVisitor)var1_1, this.initialization, CompoundList.of(this.startTypes, this.endTypes), Collections.emptyList());
                }

                /*
                 * Could not resolve type clashes
                 * Unable to fully structure code
                 */
                @Override
                public void injectIntermediateFrame(MethodVisitor methodVisitor, List<? extends TypeDescription> stack) {
                    if (this.this$0.expandFrames) ** GOTO lbl-1000
                    if (this.intermediate && stack.size() < 2) {
                        if (stack.isEmpty()) {
                            methodVisitor.visitFrame(3, Default.EMPTY.length, Default.EMPTY, Default.EMPTY.length, Default.EMPTY);
                        } else {
                            methodVisitor.visitFrame(4, Default.EMPTY.length, Default.EMPTY, 1, new Object[]{Initialization.INITIALIZED.toFrame(stack.get(0))});
                        }
                    } else if (this.this$0.currentFrameDivergence == 0 && this.intermediateTypes.size() < 4 && (stack.isEmpty() || stack.size() < 2 && this.intermediateTypes.isEmpty())) {
                        if (this.intermediateTypes.isEmpty()) {
                            if (stack.isEmpty()) {
                                methodVisitor.visitFrame(3, Default.EMPTY.length, Default.EMPTY, Default.EMPTY.length, Default.EMPTY);
                            } else {
                                methodVisitor.visitFrame(4, Default.EMPTY.length, Default.EMPTY, 1, new Object[]{Initialization.INITIALIZED.toFrame(stack.get(0))});
                            }
                        } else {
                            local = new Object[this.intermediateTypes.size()];
                            index = 0;
                            for (TypeDescription typeDescription : this.intermediateTypes) {
                                local[index++] = Initialization.INITIALIZED.toFrame(typeDescription);
                            }
                            methodVisitor.visitFrame(1, local.length, (Object[])var2_2, Default.EMPTY.length, Default.EMPTY);
                        }
                    } else if (this.this$0.currentFrameDivergence < 3 && this.intermediateTypes.isEmpty() && var2_2.isEmpty()) {
                        methodVisitor.visitFrame(2, this.this$0.currentFrameDivergence, Default.EMPTY, Default.EMPTY.length, Default.EMPTY);
                    } else lbl-1000:
                    // 2 sources

                    {
                        this.this$0.injectFullFrame((MethodVisitor)var1_1, this.initialization, CompoundList.of(this.startTypes, this.intermediateTypes), (List<? extends TypeDescription>)var2_2);
                    }
                    this.this$0.currentFrameDivergence = this.intermediateTypes.size() - this.endTypes.size();
                    this.intermediate = true;
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static abstract class WithPreservedArguments
            extends Default {
                protected boolean allowCompactCompletionFrame;

                /*
                 * WARNING - void declaration
                 */
                protected WithPreservedArguments(TypeDescription instrumentedType, MethodDescription instrumentedMethod, List<? extends TypeDescription> initialTypes, List<? extends TypeDescription> latentTypes, List<? extends TypeDescription> preMethodTypes, List<? extends TypeDescription> postMethodTypes, boolean expandFrames, boolean allowCompactCompletionFrame) {
                    super((TypeDescription)var1_1, (MethodDescription)var2_2, (List<? extends TypeDescription>)var3_3, latentTypes, preMethodTypes, postMethodTypes, expandFrames);
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.allowCompactCompletionFrame = allowCompactCompletionFrame;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                @SuppressFBWarnings(value={"RC_REF_COMPARISON_BAD_PRACTICE"}, justification="ASM models frames by reference identity.")
                protected void translateFrame(MethodVisitor methodVisitor, TranslationMode translationMode, boolean isStatic, MethodDescription.TypeToken typeToken, List<? extends TypeDescription> additionalTypes, int type, int localVariableLength, @MaybeNull Object[] localVariable, int stackSize, @MaybeNull Object[] stack) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    if (type == 0 && localVariableLength > 0 && localVariable[0] != Opcodes.UNINITIALIZED_THIS) {
                        this.allowCompactCompletionFrame = true;
                    }
                    super.translateFrame((MethodVisitor)var1_1, (TranslationMode)var2_2, (boolean)var3_3, typeToken, additionalTypes, type, localVariableLength, localVariable, stackSize, stack);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public net.bytebuddy.asm.Advice$StackMapFrameHandler$ForAdvice bindExit(MethodDescription.TypeToken typeToken) {
                    void var1_1;
                    return new ForAdvice(this, (MethodDescription.TypeToken)var1_1, CompoundList.of(this.initialTypes, this.preMethodTypes, this.postMethodTypes), Collections.emptyList(), Collections.emptyList(), TranslationMode.EXIT, Initialization.INITIALIZED);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void injectReturnFrame(MethodVisitor methodVisitor) {
                    void var1_1;
                    if (!this.expandFrames && this.currentFrameDivergence == 0) {
                        if (this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                            methodVisitor.visitFrame(3, EMPTY.length, EMPTY, EMPTY.length, EMPTY);
                            return;
                        }
                        methodVisitor.visitFrame(4, EMPTY.length, EMPTY, 1, new Object[]{Initialization.INITIALIZED.toFrame(this.instrumentedMethod.getReturnType().asErasure())});
                        return;
                    }
                    this.injectFullFrame((MethodVisitor)var1_1, Initialization.INITIALIZED, CompoundList.of(this.initialTypes, this.preMethodTypes), this.instrumentedMethod.getReturnType().represents(Void.TYPE) ? Collections.emptyList() : Collections.singletonList(this.instrumentedMethod.getReturnType().asErasure()));
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void injectExceptionFrame(MethodVisitor methodVisitor) {
                    void var1_1;
                    if (!this.expandFrames && this.currentFrameDivergence == 0) {
                        methodVisitor.visitFrame(4, EMPTY.length, EMPTY, 1, new Object[]{Type.getInternalName(Throwable.class)});
                        return;
                    }
                    this.injectFullFrame((MethodVisitor)var1_1, Initialization.INITIALIZED, CompoundList.of(this.initialTypes, this.preMethodTypes), Collections.singletonList(TypeDescription.ForLoadedType.of(Throwable.class)));
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void injectCompletionFrame(MethodVisitor methodVisitor) {
                    void var1_1;
                    if (this.allowCompactCompletionFrame && !this.expandFrames && this.currentFrameDivergence == 0 && this.postMethodTypes.size() < 4) {
                        void var2_2;
                        if (this.postMethodTypes.isEmpty()) {
                            methodVisitor.visitFrame(3, EMPTY.length, EMPTY, EMPTY.length, EMPTY);
                            return;
                        }
                        Object[] local = new Object[this.postMethodTypes.size()];
                        int index = 0;
                        for (TypeDescription typeDescription : this.postMethodTypes) {
                            local[index++] = Initialization.INITIALIZED.toFrame(typeDescription);
                        }
                        methodVisitor.visitFrame(1, local.length, (Object[])var2_2, EMPTY.length, EMPTY);
                        return;
                    }
                    this.injectFullFrame((MethodVisitor)var1_1, Initialization.INITIALIZED, CompoundList.of(this.initialTypes, this.preMethodTypes, this.postMethodTypes), Collections.emptyList());
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void injectPostCompletionFrame(MethodVisitor methodVisitor) {
                    void var1_1;
                    if (!this.expandFrames && this.currentFrameDivergence == 0) {
                        methodVisitor.visitFrame(3, EMPTY.length, EMPTY, EMPTY.length, EMPTY);
                        return;
                    }
                    this.injectFullFrame((MethodVisitor)var1_1, Initialization.INITIALIZED, CompoundList.of(this.initialTypes, this.preMethodTypes, this.postMethodTypes), Collections.emptyList());
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void injectInitializationFrame(MethodVisitor methodVisitor) {
                    if (!this.initialTypes.isEmpty()) {
                        void var2_3;
                        void var1_1;
                        if (!this.expandFrames && this.initialTypes.size() < 4) {
                            Object[] localVariable = new Object[this.initialTypes.size()];
                            int index = 0;
                            for (TypeDescription typeDescription : this.initialTypes) {
                                localVariable[index++] = Initialization.INITIALIZED.toFrame(typeDescription);
                            }
                            methodVisitor.visitFrame(1, localVariable.length, localVariable, EMPTY.length, EMPTY);
                            return;
                        }
                        Object[] localVariable = new Object[(this.instrumentedMethod.isStatic() ? 0 : 1) + this.instrumentedMethod.getParameters().size() + this.initialTypes.size()];
                        int index = 0;
                        if (this.instrumentedMethod.isConstructor()) {
                            ++index;
                            localVariable[0] = Opcodes.UNINITIALIZED_THIS;
                        } else if (!this.instrumentedMethod.isStatic()) {
                            ++index;
                            localVariable[0] = Initialization.INITIALIZED.toFrame(this.instrumentedType);
                        }
                        for (TypeDescription typeDescription : this.instrumentedMethod.getParameters().asTypeList().asErasures()) {
                            localVariable[index++] = Initialization.INITIALIZED.toFrame(typeDescription);
                        }
                        for (TypeDescription typeDescription : this.initialTypes) {
                            localVariable[index++] = Initialization.INITIALIZED.toFrame(typeDescription);
                        }
                        var1_1.visitFrame(this.expandFrames ? -1 : 0, localVariable.length, (Object[])var2_3, EMPTY.length, EMPTY);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                protected static class WithArgumentCopy
                extends WithPreservedArguments {
                    /*
                     * WARNING - void declaration
                     */
                    protected WithArgumentCopy(TypeDescription instrumentedType, MethodDescription instrumentedMethod, List<? extends TypeDescription> initialTypes, List<? extends TypeDescription> latentTypes, List<? extends TypeDescription> preMethodTypes, List<? extends TypeDescription> postMethodTypes, boolean expandFrames) {
                        super((TypeDescription)var1_1, (MethodDescription)var2_2, (List<? extends TypeDescription>)var3_3, latentTypes, preMethodTypes, postMethodTypes, expandFrames, true);
                        void var3_3;
                        void var2_2;
                        void var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void injectStartFrame(MethodVisitor methodVisitor) {
                        if (!this.instrumentedMethod.isStatic() || !this.instrumentedMethod.getParameters().isEmpty()) {
                            if (!this.expandFrames && (this.instrumentedMethod.isStatic() ? 0 : 1) + this.instrumentedMethod.getParameters().size() < 4) {
                                Object[] localVariable = new Object[(this.instrumentedMethod.isStatic() ? 0 : 1) + this.instrumentedMethod.getParameters().size()];
                                int index = 0;
                                if (this.instrumentedMethod.isConstructor()) {
                                    ++index;
                                    localVariable[0] = Opcodes.UNINITIALIZED_THIS;
                                } else if (!this.instrumentedMethod.isStatic()) {
                                    ++index;
                                    localVariable[0] = Initialization.INITIALIZED.toFrame(this.instrumentedType);
                                }
                                for (TypeDescription typeDescription : this.instrumentedMethod.getParameters().asTypeList().asErasures()) {
                                    localVariable[index++] = Initialization.INITIALIZED.toFrame(typeDescription);
                                }
                                methodVisitor.visitFrame(1, localVariable.length, localVariable, EMPTY.length, EMPTY);
                            } else {
                                void var2_3;
                                void var1_1;
                                Object[] localVariable = new Object[(this.instrumentedMethod.isStatic() ? 0 : 2) + (this.instrumentedMethod.getParameters().size() << 1) + this.initialTypes.size() + this.preMethodTypes.size()];
                                int index = 0;
                                if (this.instrumentedMethod.isConstructor()) {
                                    ++index;
                                    localVariable[0] = Opcodes.UNINITIALIZED_THIS;
                                } else if (!this.instrumentedMethod.isStatic()) {
                                    ++index;
                                    localVariable[0] = Initialization.INITIALIZED.toFrame(this.instrumentedType);
                                }
                                for (TypeDescription typeDescription : this.instrumentedMethod.getParameters().asTypeList().asErasures()) {
                                    localVariable[index++] = Initialization.INITIALIZED.toFrame(typeDescription);
                                }
                                for (TypeDescription typeDescription : this.initialTypes) {
                                    localVariable[index++] = Initialization.INITIALIZED.toFrame(typeDescription);
                                }
                                for (TypeDescription typeDescription : this.preMethodTypes) {
                                    localVariable[index++] = Initialization.INITIALIZED.toFrame(typeDescription);
                                }
                                if (this.instrumentedMethod.isConstructor()) {
                                    localVariable[index++] = Opcodes.UNINITIALIZED_THIS;
                                } else if (!this.instrumentedMethod.isStatic()) {
                                    localVariable[index++] = Initialization.INITIALIZED.toFrame(this.instrumentedType);
                                }
                                for (TypeDescription typeDescription : this.instrumentedMethod.getParameters().asTypeList().asErasures()) {
                                    localVariable[index++] = Initialization.INITIALIZED.toFrame(typeDescription);
                                }
                                var1_1.visitFrame(this.expandFrames ? -1 : 0, localVariable.length, (Object[])var2_3, EMPTY.length, EMPTY);
                            }
                        }
                        this.currentFrameDivergence = (this.instrumentedMethod.isStatic() ? 0 : 1) + this.instrumentedMethod.getParameters().size();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    @SuppressFBWarnings(value={"RC_REF_COMPARISON_BAD_PRACTICE"}, justification="ASM models frames by reference identity.")
                    public void translateFrame(MethodVisitor methodVisitor, int type, int localVariableLength, @MaybeNull Object[] localVariable, int stackSize, @MaybeNull Object[] stack) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        switch (type) {
                            case 3: 
                            case 4: {
                                break;
                            }
                            case 1: {
                                this.currentFrameDivergence += localVariableLength;
                                break;
                            }
                            case 2: {
                                this.currentFrameDivergence -= localVariableLength;
                                break;
                            }
                            case -1: 
                            case 0: {
                                Object[] translated = new Object[localVariableLength + (this.instrumentedMethod.isStatic() ? 0 : 1) + this.instrumentedMethod.getParameters().size() + this.initialTypes.size() + this.preMethodTypes.size()];
                                int index = 0;
                                if (this.instrumentedMethod.isConstructor()) {
                                    void var10_11;
                                    Initialization initialization = Initialization.INITIALIZED;
                                    boolean bl = false;
                                    while (var10_11 < localVariableLength) {
                                        if (localVariable[var10_11] == Opcodes.UNINITIALIZED_THIS) {
                                            initialization = Initialization.UNITIALIZED;
                                            break;
                                        }
                                        ++var10_11;
                                    }
                                    ++index;
                                    translated[0] = initialization.toFrame(this.instrumentedType);
                                } else if (!this.instrumentedMethod.isStatic()) {
                                    ++index;
                                    translated[0] = Initialization.INITIALIZED.toFrame(this.instrumentedType);
                                }
                                for (TypeDescription typeDescription : this.instrumentedMethod.getParameters().asTypeList().asErasures()) {
                                    translated[index++] = Initialization.INITIALIZED.toFrame(typeDescription);
                                }
                                for (TypeDescription typeDescription : this.initialTypes) {
                                    translated[index++] = Initialization.INITIALIZED.toFrame(typeDescription);
                                }
                                for (TypeDescription typeDescription : this.preMethodTypes) {
                                    translated[index++] = Initialization.INITIALIZED.toFrame(typeDescription);
                                }
                                if (localVariableLength > 0) {
                                    System.arraycopy(localVariable, 0, translated, index, localVariableLength);
                                }
                                localVariableLength = translated.length;
                                localVariable = translated;
                                this.currentFrameDivergence = localVariableLength;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unexpected frame type: " + type);
                            }
                        }
                        if (this.instrumentedMethod.isConstructor() && this.currentFrameDivergence < this.instrumentedMethod.getStackSize()) {
                            throw new IllegalStateException(this.instrumentedMethod + " dropped implicit 'this' frame");
                        }
                        var1_1.visitFrame((int)var2_2, (int)var3_3, localVariable, stackSize, stack);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                protected static class WithoutArgumentCopy
                extends WithPreservedArguments {
                    /*
                     * WARNING - void declaration
                     */
                    protected WithoutArgumentCopy(TypeDescription instrumentedType, MethodDescription instrumentedMethod, List<? extends TypeDescription> initialTypes, List<? extends TypeDescription> latentTypes, List<? extends TypeDescription> preMethodTypes, List<? extends TypeDescription> postMethodTypes, boolean expandFrames, boolean allowCompactCompletionFrame) {
                        super((TypeDescription)var1_1, (MethodDescription)var2_2, (List<? extends TypeDescription>)var3_3, latentTypes, preMethodTypes, postMethodTypes, expandFrames, allowCompactCompletionFrame);
                        void var3_3;
                        void var2_2;
                        void var1_1;
                    }

                    @Override
                    public void injectStartFrame(MethodVisitor methodVisitor) {
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void translateFrame(MethodVisitor methodVisitor, int type, int localVariableLength, @MaybeNull Object[] localVariable, int stackSize, @MaybeNull Object[] stack) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.translateFrame((MethodVisitor)var1_1, TranslationMode.COPY, this.instrumentedMethod.isStatic(), this.instrumentedMethod.asTypeToken(), CompoundList.of(this.initialTypes, this.preMethodTypes), (int)var2_2, (int)var3_3, localVariable, stackSize, stack);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static class Trivial
            extends Default {
                /*
                 * WARNING - void declaration
                 */
                protected Trivial(TypeDescription instrumentedType, MethodDescription instrumentedMethod, List<? extends TypeDescription> latentTypes, boolean expandFrames) {
                    super((TypeDescription)var1_1, (MethodDescription)var2_2, Collections.emptyList(), (List<? extends TypeDescription>)var3_3, Collections.emptyList(), Collections.emptyList(), expandFrames);
                    void var3_3;
                    void var2_2;
                    void var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void translateFrame(MethodVisitor methodVisitor, int type, int localVariableLength, @MaybeNull Object[] localVariable, int stackSize, @MaybeNull Object[] stack) {
                    void var3_3;
                    void var2_2;
                    methodVisitor.visitFrame((int)var2_2, (int)var3_3, localVariable, stackSize, stack);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public net.bytebuddy.asm.Advice$StackMapFrameHandler$ForAdvice bindExit(MethodDescription.TypeToken typeToken) {
                    void var1_1;
                    throw new IllegalStateException("Did not expect exit advice " + var1_1 + " for " + this.instrumentedMethod);
                }

                @Override
                public void injectReturnFrame(MethodVisitor methodVisitor) {
                    throw new IllegalStateException("Did not expect return frame for " + this.instrumentedMethod);
                }

                @Override
                public void injectExceptionFrame(MethodVisitor methodVisitor) {
                    throw new IllegalStateException("Did not expect exception frame for " + this.instrumentedMethod);
                }

                @Override
                public void injectCompletionFrame(MethodVisitor methodVisitor) {
                    throw new IllegalStateException("Did not expect completion frame for " + this.instrumentedMethod);
                }

                @Override
                public void injectPostCompletionFrame(MethodVisitor methodVisitor) {
                    throw new IllegalStateException("Did not expect post completion frame for " + this.instrumentedMethod);
                }

                @Override
                public void injectInitializationFrame(MethodVisitor methodVisitor) {
                }

                @Override
                public void injectStartFrame(MethodVisitor methodVisitor) {
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static enum Initialization {
                UNITIALIZED{

                    /*
                     * WARNING - void declaration
                     */
                    protected final Object toFrame(TypeDescription typeDescription) {
                        if (typeDescription.isPrimitive()) {
                            void var1_1;
                            throw new IllegalArgumentException("Cannot assume primitive uninitialized value: " + var1_1);
                        }
                        return Opcodes.UNINITIALIZED_THIS;
                    }
                }
                ,
                INITIALIZED{

                    /*
                     * WARNING - void declaration
                     */
                    protected final Object toFrame(TypeDescription typeDescription) {
                        void var1_1;
                        if (typeDescription.represents(Boolean.TYPE) || typeDescription.represents(Byte.TYPE) || typeDescription.represents(Short.TYPE) || typeDescription.represents(Character.TYPE) || typeDescription.represents(Integer.TYPE)) {
                            return Opcodes.INTEGER;
                        }
                        if (typeDescription.represents(Long.TYPE)) {
                            return Opcodes.LONG;
                        }
                        if (typeDescription.represents(Float.TYPE)) {
                            return Opcodes.FLOAT;
                        }
                        if (typeDescription.represents(Double.TYPE)) {
                            return Opcodes.DOUBLE;
                        }
                        return var1_1.getInternalName();
                    }
                };


                protected abstract Object toFrame(TypeDescription var1);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static enum TranslationMode {
                COPY{

                    /*
                     * WARNING - void declaration
                     */
                    protected final int copy(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Object[] localVariable, Object[] translated) {
                        void var1_2;
                        void var3_4;
                        void var2_3;
                        int length = instrumentedMethod.getParameters().size() + (var2_3.isStatic() ? 0 : 1);
                        System.arraycopy(var3_4, 0, translated, 0, length);
                        return (int)var1_2;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected final boolean isPossibleThisFrameValue(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Object frame) {
                        void var3_3;
                        void var1_1;
                        return instrumentedMethod.isConstructor() && Opcodes.UNINITIALIZED_THIS.equals(frame) || Initialization.INITIALIZED.toFrame((TypeDescription)var1_1).equals(var3_3);
                    }
                }
                ,
                ENTER{

                    /*
                     * WARNING - void declaration
                     */
                    protected final int copy(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Object[] localVariable, Object[] translated) {
                        void var3_4;
                        int index = 0;
                        if (!instrumentedMethod.isStatic()) {
                            Iterator iterator;
                            ++index;
                            translated[0] = instrumentedMethod.isConstructor() ? Opcodes.UNINITIALIZED_THIS : Initialization.INITIALIZED.toFrame((TypeDescription)((Object)iterator));
                        }
                        for (TypeDescription typeDescription : instrumentedMethod.getParameters().asTypeList().asErasures()) {
                            void var2_2;
                            translated[index++] = Initialization.INITIALIZED.toFrame((TypeDescription)var2_2);
                        }
                        return (int)var3_4;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected final boolean isPossibleThisFrameValue(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Object frame) {
                        void var3_3;
                        void var1_1;
                        if (instrumentedMethod.isConstructor()) {
                            return Opcodes.UNINITIALIZED_THIS.equals(frame);
                        }
                        return Initialization.INITIALIZED.toFrame((TypeDescription)var1_1).equals(var3_3);
                    }
                }
                ,
                EXIT{

                    /*
                     * WARNING - void declaration
                     */
                    protected final int copy(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Object[] localVariable, Object[] translated) {
                        void var3_4;
                        int index = 0;
                        if (!instrumentedMethod.isStatic()) {
                            Iterator iterator;
                            ++index;
                            translated[0] = Initialization.INITIALIZED.toFrame((TypeDescription)((Object)iterator));
                        }
                        for (TypeDescription typeDescription : instrumentedMethod.getParameters().asTypeList().asErasures()) {
                            void var2_2;
                            translated[index++] = Initialization.INITIALIZED.toFrame((TypeDescription)var2_2);
                        }
                        return (int)var3_4;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected final boolean isPossibleThisFrameValue(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Object frame) {
                        void var3_3;
                        void var1_1;
                        return Initialization.INITIALIZED.toFrame((TypeDescription)var1_1).equals(var3_3);
                    }
                };


                protected abstract int copy(TypeDescription var1, MethodDescription var2, Object[] var3, Object[] var4);

                protected abstract boolean isPossibleThisFrameValue(TypeDescription var1, MethodDescription var2, Object var3);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum NoOp implements ForAdvice,
        ForInstrumentedMethod
        {
            INSTANCE;


            @Override
            public final ForAdvice bindEnter(MethodDescription.TypeToken typeToken) {
                return this;
            }

            @Override
            public final ForAdvice bindExit(MethodDescription.TypeToken typeToken) {
                return this;
            }

            @Override
            public final int getReaderHint() {
                return 4;
            }

            @Override
            public final void translateFrame(MethodVisitor methodVisitor, int type, int localVariableLength, @MaybeNull Object[] localVariable, int stackSize, @MaybeNull Object[] stack) {
            }

            @Override
            public final void injectReturnFrame(MethodVisitor methodVisitor) {
            }

            @Override
            public final void injectExceptionFrame(MethodVisitor methodVisitor) {
            }

            @Override
            public final void injectCompletionFrame(MethodVisitor methodVisitor) {
            }

            @Override
            public final void injectInitializationFrame(MethodVisitor methodVisitor) {
            }

            @Override
            public final void injectStartFrame(MethodVisitor methodVisitor) {
            }

            @Override
            public final void injectPostCompletionFrame(MethodVisitor methodVisitor) {
            }

            @Override
            public final void injectIntermediateFrame(MethodVisitor methodVisitor, List<? extends TypeDescription> stack) {
            }
        }

        public static interface ForAdvice
        extends StackMapFrameHandler,
        ForPostProcessor {
        }

        public static interface ForInstrumentedMethod
        extends StackMapFrameHandler {
            public ForAdvice bindEnter(MethodDescription.TypeToken var1);

            public ForAdvice bindExit(MethodDescription.TypeToken var1);

            public int getReaderHint();

            public void injectInitializationFrame(MethodVisitor var1);

            public void injectStartFrame(MethodVisitor var1);

            public void injectPostCompletionFrame(MethodVisitor var1);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface ForPostProcessor {
            public void injectIntermediateFrame(MethodVisitor var1, List<? extends TypeDescription> var2);
        }
    }

    protected static interface MethodSizeHandler {
        public static final int UNDEFINED_SIZE = Short.MAX_VALUE;

        public void requireStackSize(int var1);

        public void requireLocalVariableLength(int var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class Default
        implements ForInstrumentedMethod {
            protected final MethodDescription instrumentedMethod;
            protected final List<? extends TypeDescription> initialTypes;
            protected final List<? extends TypeDescription> preMethodTypes;
            protected final List<? extends TypeDescription> postMethodTypes;
            protected int stackSize;
            protected int localVariableLength;

            /*
             * WARNING - void declaration
             */
            protected Default(MethodDescription instrumentedMethod, List<? extends TypeDescription> initialTypes, List<? extends TypeDescription> preMethodTypes, List<? extends TypeDescription> postMethodTypes) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.instrumentedMethod = var1_1;
                this.initialTypes = var2_2;
                this.preMethodTypes = var3_3;
                this.postMethodTypes = postMethodTypes;
            }

            /*
             * WARNING - void declaration
             */
            protected static ForInstrumentedMethod of(MethodDescription instrumentedMethod, List<? extends TypeDescription> initialTypes, List<? extends TypeDescription> preMethodTypes, List<? extends TypeDescription> postMethodTypes, boolean copyArguments, int writerFlags) {
                void var3_3;
                void var2_2;
                void var1_1;
                MethodDescription methodDescription;
                if ((writerFlags & 3) != 0) {
                    return NoOp.INSTANCE;
                }
                if (copyArguments) {
                    return new WithCopiedArguments(instrumentedMethod, initialTypes, preMethodTypes, postMethodTypes);
                }
                return new WithRetainedArguments(methodDescription, (List<? extends TypeDescription>)var1_1, (List<? extends TypeDescription>)var2_2, (List<? extends TypeDescription>)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public net.bytebuddy.asm.Advice$MethodSizeHandler$ForAdvice bindEnter(MethodDescription.TypeToken typeToken) {
                void var1_1;
                return new ForAdvice(this, (MethodDescription.TypeToken)var1_1, this.instrumentedMethod.getStackSize() + StackSize.of(this.initialTypes));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void requireStackSize(int stackSize) {
                void var1_1;
                this.stackSize = Math.max(this.stackSize, (int)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void requireLocalVariableLength(int localVariableLength) {
                void var1_1;
                this.localVariableLength = Math.max(this.localVariableLength, (int)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int compoundStackSize(int stackSize) {
                void var1_1;
                return Math.max(this.stackSize, (int)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int compoundLocalVariableLength(int localVariableLength) {
                void var1_1;
                return Math.max(this.localVariableLength, (int)(var1_1 + StackSize.of(this.postMethodTypes) + StackSize.of(this.initialTypes) + StackSize.of(this.preMethodTypes)));
            }

            protected class ForAdvice
            implements net.bytebuddy.asm.Advice$MethodSizeHandler$ForAdvice {
                private final MethodDescription.TypeToken typeToken;
                private final int baseLocalVariableLength;
                private int stackSizePadding;
                private int localVariableLengthPadding;
                final /* synthetic */ Default this$0;

                /*
                 * WARNING - void declaration
                 */
                protected ForAdvice(Default this$0, MethodDescription.TypeToken typeToken, int baseLocalVariableLength) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.typeToken = var2_2;
                    this.baseLocalVariableLength = var3_3;
                }

                /*
                 * WARNING - void declaration
                 */
                public void requireStackSize(int stackSize) {
                    void var1_1;
                    this.this$0.requireStackSize((int)var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                public void requireLocalVariableLength(int localVariableLength) {
                    void var1_1;
                    this.this$0.requireLocalVariableLength((int)var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                public void requireStackSizePadding(int stackSizePadding) {
                    void var1_1;
                    this.stackSizePadding = Math.max(this.stackSizePadding, (int)var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                public void requireLocalVariableLengthPadding(int localVariableLengthPadding) {
                    void var1_1;
                    this.localVariableLengthPadding = Math.max(this.localVariableLengthPadding, (int)var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                public void recordMaxima(int stackSize, int localVariableLength) {
                    void var2_2;
                    void var1_1;
                    this.this$0.requireStackSize((int)(var1_1 + this.stackSizePadding));
                    this.this$0.requireLocalVariableLength((int)(var2_2 - StackSize.of(this.typeToken.getParameterTypes()) + this.baseLocalVariableLength + this.localVariableLengthPadding));
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static class WithCopiedArguments
            extends Default {
                /*
                 * WARNING - void declaration
                 */
                protected WithCopiedArguments(MethodDescription instrumentedMethod, List<? extends TypeDescription> initialTypes, List<? extends TypeDescription> preMethodTypes, List<? extends TypeDescription> postMethodTypes) {
                    super((MethodDescription)var1_1, (List<? extends TypeDescription>)var2_2, (List<? extends TypeDescription>)var3_3, postMethodTypes);
                    void var3_3;
                    void var2_2;
                    void var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public net.bytebuddy.asm.Advice$MethodSizeHandler$ForAdvice bindExit(MethodDescription.TypeToken typeToken) {
                    void var1_1;
                    return new ForAdvice(this, (MethodDescription.TypeToken)var1_1, 2 * this.instrumentedMethod.getStackSize() + StackSize.of(this.initialTypes) + StackSize.of(this.preMethodTypes) + StackSize.of(this.postMethodTypes));
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public int compoundLocalVariableLength(int localVariableLength) {
                    void var1_1;
                    return Math.max(this.localVariableLength, (int)(var1_1 + this.instrumentedMethod.getStackSize() + StackSize.of(this.postMethodTypes) + StackSize.of(this.initialTypes) + StackSize.of(this.preMethodTypes)));
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static class WithRetainedArguments
            extends Default {
                /*
                 * WARNING - void declaration
                 */
                protected WithRetainedArguments(MethodDescription instrumentedMethod, List<? extends TypeDescription> initialTypes, List<? extends TypeDescription> preMethodTypes, List<? extends TypeDescription> postMethodTypes) {
                    super((MethodDescription)var1_1, (List<? extends TypeDescription>)var2_2, (List<? extends TypeDescription>)var3_3, postMethodTypes);
                    void var3_3;
                    void var2_2;
                    void var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public net.bytebuddy.asm.Advice$MethodSizeHandler$ForAdvice bindExit(MethodDescription.TypeToken typeToken) {
                    void var1_1;
                    return new ForAdvice(this, (MethodDescription.TypeToken)var1_1, this.instrumentedMethod.getStackSize() + StackSize.of(this.postMethodTypes) + StackSize.of(this.initialTypes) + StackSize.of(this.preMethodTypes));
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public int compoundLocalVariableLength(int localVariableLength) {
                    void var1_1;
                    return Math.max(this.localVariableLength, (int)(var1_1 + StackSize.of(this.postMethodTypes) + StackSize.of(this.initialTypes) + StackSize.of(this.preMethodTypes)));
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum NoOp implements ForAdvice,
        ForInstrumentedMethod
        {
            INSTANCE;


            @Override
            public final ForAdvice bindEnter(MethodDescription.TypeToken typeToken) {
                return this;
            }

            @Override
            public final ForAdvice bindExit(MethodDescription.TypeToken typeToken) {
                return this;
            }

            @Override
            public final int compoundStackSize(int stackSize) {
                return Short.MAX_VALUE;
            }

            @Override
            public final int compoundLocalVariableLength(int localVariableLength) {
                return Short.MAX_VALUE;
            }

            @Override
            public final void requireStackSize(int stackSize) {
            }

            @Override
            public final void requireLocalVariableLength(int localVariableLength) {
            }

            @Override
            public final void requireStackSizePadding(int stackSizePadding) {
            }

            @Override
            public final void requireLocalVariableLengthPadding(int localVariableLengthPadding) {
            }

            @Override
            public final void recordMaxima(int stackSize, int localVariableLength) {
            }
        }

        public static interface ForAdvice
        extends MethodSizeHandler {
            public void requireStackSizePadding(int var1);

            public void requireLocalVariableLengthPadding(int var1);

            public void recordMaxima(int var1, int var2);
        }

        public static interface ForInstrumentedMethod
        extends MethodSizeHandler {
            public ForAdvice bindEnter(MethodDescription.TypeToken var1);

            public ForAdvice bindExit(MethodDescription.TypeToken var1);

            public int compoundStackSize(int var1);

            public int compoundLocalVariableLength(int var1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BootstrapArgumentResolver {
        public List<JavaConstant> resolve(TypeDescription var1, MethodDescription var2);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class ForDefaultValues
        implements BootstrapArgumentResolver {
            private final MethodDescription.InDefinedShape adviceMethod;
            private final boolean exit;

            /*
             * WARNING - void declaration
             */
            protected ForDefaultValues(MethodDescription.InDefinedShape adviceMethod, boolean exit) {
                void var2_2;
                void var1_1;
                this.adviceMethod = var1_1;
                this.exit = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public List<JavaConstant> resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                void var2_2;
                void var1_1;
                if (instrumentedMethod.isTypeInitializer()) {
                    return Arrays.asList(JavaConstant.Simple.ofLoaded(this.adviceMethod.getDeclaringType().getName()), JavaConstant.Simple.ofLoaded(this.exit ? 1 : 0), JavaConstant.Simple.of(instrumentedType), JavaConstant.Simple.ofLoaded(instrumentedMethod.getInternalName()));
                }
                return Arrays.asList(JavaConstant.Simple.ofLoaded(this.adviceMethod.getDeclaringType().getName()), JavaConstant.Simple.ofLoaded(this.exit ? 1 : 0), JavaConstant.Simple.of((TypeDescription)var1_1), JavaConstant.Simple.ofLoaded(instrumentedMethod.getInternalName()), JavaConstant.MethodHandle.of((MethodDescription.InDefinedShape)var2_2.asDefined()));
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (this.exit != ((ForDefaultValues)object).exit) {
                    return false;
                }
                return this.adviceMethod.equals(((ForDefaultValues)object).adviceMethod);
            }

            public int hashCode() {
                return (this.getClass().hashCode() * 31 + this.adviceMethod.hashCode()) * 31 + this.exit;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Factory implements net.bytebuddy.asm.Advice$BootstrapArgumentResolver$Factory
            {
                INSTANCE;


                /*
                 * WARNING - void declaration
                 */
                @Override
                public final BootstrapArgumentResolver resolve(MethodDescription.InDefinedShape adviceMethod, boolean exit) {
                    void var2_2;
                    void var1_1;
                    return new ForDefaultValues((MethodDescription.InDefinedShape)var1_1, (boolean)var2_2);
                }
            }
        }

        public static interface Factory {
            public BootstrapArgumentResolver resolve(MethodDescription.InDefinedShape var1, boolean var2);
        }
    }

    protected static interface Delegator {
        public StackManipulation apply(TypeDescription var1, MethodDescription var2);

        public MethodDescription.TypeToken getTypeToken();

        public void assertVisibility(TypeDescription var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class ForDynamicInvocation
        implements Delegator {
            private final MethodDescription.InDefinedShape bootstrapMethod;
            private final MethodDescription.SignatureToken signatureToken;
            private final BootstrapArgumentResolver resolver;

            /*
             * WARNING - void declaration
             */
            protected ForDynamicInvocation(MethodDescription.InDefinedShape bootstrapMethod, MethodDescription.SignatureToken signatureToken, BootstrapArgumentResolver resolver) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.bootstrapMethod = var1_1;
                this.signatureToken = var2_2;
                this.resolver = var3_3;
            }

            /*
             * WARNING - void declaration
             */
            protected static net.bytebuddy.asm.Advice$Delegator$Factory of(MethodDescription.InDefinedShape bootstrapMethod, BootstrapArgumentResolver.Factory resolverFactory, TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor) {
                void var2_2;
                void var1_1;
                MethodDescription.InDefinedShape inDefinedShape;
                if (!bootstrapMethod.isInvokeBootstrap()) {
                    throw new IllegalArgumentException("Not a suitable bootstrap target: " + bootstrapMethod);
                }
                return new Factory(inDefinedShape, (BootstrapArgumentResolver.Factory)var1_1, (TypeDescription.Generic.Visitor<? extends TypeDescription.Generic>)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public StackManipulation apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                void var1_1;
                void var2_2;
                List<JavaConstant> constants = this.resolver.resolve(instrumentedType, (MethodDescription)var2_2);
                if (!this.bootstrapMethod.isInvokeBootstrap(TypeList.Explicit.of(constants))) {
                    throw new IllegalStateException("Cannot invoke " + this.bootstrapMethod + " with arguments: " + constants);
                }
                return MethodInvocation.invoke(this.bootstrapMethod).dynamic(this.signatureToken.getName(), this.signatureToken.getReturnType(), this.signatureToken.getParameterTypes(), (List<? extends JavaConstant>)var1_1);
            }

            @Override
            public MethodDescription.TypeToken getTypeToken() {
                return this.signatureToken.asTypeToken();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void assertVisibility(TypeDescription instrumentedType) {
                if (!this.bootstrapMethod.isVisibleTo(instrumentedType)) {
                    void var1_1;
                    throw new IllegalStateException(this.bootstrapMethod + " is not visible to " + var1_1);
                }
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.bootstrapMethod.equals(((ForDynamicInvocation)object).bootstrapMethod)) {
                    return false;
                }
                if (!this.signatureToken.equals(((ForDynamicInvocation)object).signatureToken)) {
                    return false;
                }
                return this.resolver.equals(((ForDynamicInvocation)object).resolver);
            }

            public int hashCode() {
                return ((this.getClass().hashCode() * 31 + this.bootstrapMethod.hashCode()) * 31 + this.signatureToken.hashCode()) * 31 + this.resolver.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            protected static class Factory
            implements net.bytebuddy.asm.Advice$Delegator$Factory {
                private final MethodDescription.InDefinedShape bootstrapMethod;
                private final BootstrapArgumentResolver.Factory resolverFactory;
                private final TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor;

                /*
                 * WARNING - void declaration
                 */
                protected Factory(MethodDescription.InDefinedShape bootstrapMethod, BootstrapArgumentResolver.Factory resolverFactory, TypeDescription.Generic.Visitor<? extends TypeDescription.Generic> visitor) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.bootstrapMethod = var1_1;
                    this.resolverFactory = var2_2;
                    this.visitor = var3_3;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Delegator make(MethodDescription.InDefinedShape adviceMethod, boolean exit) {
                    void var2_2;
                    void var1_1;
                    return new ForDynamicInvocation(this.bootstrapMethod, new MethodDescription.SignatureToken(adviceMethod.getInternalName(), adviceMethod.getReturnType().accept(this.visitor).asErasure(), adviceMethod.getParameters().asTypeList().accept(this.visitor).asErasures()), this.resolverFactory.resolve((MethodDescription.InDefinedShape)var1_1, (boolean)var2_2));
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.bootstrapMethod.equals(((Factory)object).bootstrapMethod)) {
                        return false;
                    }
                    if (!this.resolverFactory.equals(((Factory)object).resolverFactory)) {
                        return false;
                    }
                    return this.visitor.equals(((Factory)object).visitor);
                }

                public int hashCode() {
                    return ((this.getClass().hashCode() * 31 + this.bootstrapMethod.hashCode()) * 31 + this.resolverFactory.hashCode()) * 31 + this.visitor.hashCode();
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForRegularInvocation
        implements Delegator {
            private final MethodDescription.InDefinedShape adviceMethod;

            /*
             * WARNING - void declaration
             */
            protected ForRegularInvocation(MethodDescription.InDefinedShape adviceMethod) {
                void var1_1;
                this.adviceMethod = var1_1;
            }

            public StackManipulation apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                return MethodInvocation.invoke(this.adviceMethod);
            }

            public MethodDescription.TypeToken getTypeToken() {
                return this.adviceMethod.asTypeToken();
            }

            /*
             * WARNING - void declaration
             */
            public void assertVisibility(TypeDescription instrumentedType) {
                if (!this.adviceMethod.isVisibleTo(instrumentedType)) {
                    void var1_1;
                    throw new IllegalStateException(this.adviceMethod + " is not visible to " + var1_1);
                }
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.adviceMethod.equals(((ForRegularInvocation)object).adviceMethod);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.adviceMethod.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static enum Factory implements net.bytebuddy.asm.Advice$Delegator$Factory
            {
                INSTANCE;


                /*
                 * WARNING - void declaration
                 */
                @Override
                public final Delegator make(MethodDescription.InDefinedShape adviceMethod, boolean exit) {
                    void var1_1;
                    return new ForRegularInvocation((MethodDescription.InDefinedShape)var1_1);
                }
            }
        }

        public static interface Factory {
            public Delegator make(MethodDescription.InDefinedShape var1, boolean var2);
        }
    }

    public static interface PostProcessor {
        public StackManipulation resolve(TypeDescription var1, MethodDescription var2, Assigner var3, ArgumentHandler var4, StackMapFrameHandler.ForPostProcessor var5, StackManipulation var6);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class Compound
        implements PostProcessor {
            private final List<PostProcessor> postProcessors;

            /*
             * WARNING - void declaration
             */
            protected Compound(List<PostProcessor> postProcessors) {
                void var1_1;
                this.postProcessors = var1_1;
            }

            @Override
            public StackManipulation resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, StackMapFrameHandler.ForPostProcessor stackMapFrameHandler, StackManipulation exceptionHandler) {
                ArrayList<StackManipulation> stackManipulations = new ArrayList<StackManipulation>(this.postProcessors.size());
                for (PostProcessor postProcessor : this.postProcessors) {
                    stackManipulations.add(postProcessor.resolve(instrumentedType, instrumentedMethod, assigner, argumentHandler, stackMapFrameHandler, exceptionHandler));
                }
                return new StackManipulation.Compound(stackManipulations);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return ((Object)this.postProcessors).equals(((Compound)object).postProcessors);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + ((Object)this.postProcessors).hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum NoOp implements PostProcessor,
        Factory
        {
            INSTANCE;


            @Override
            public final StackManipulation resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, StackMapFrameHandler.ForPostProcessor stackMapFrameHandler, StackManipulation exceptionHandler) {
                return StackManipulation.Trivial.INSTANCE;
            }

            @Override
            public final PostProcessor make(List<? extends AnnotationDescription> annotations, TypeDescription returnType, boolean exit) {
                return this;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Factory {
            public PostProcessor make(List<? extends AnnotationDescription> var1, TypeDescription var2, boolean var3);

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class Compound
            implements Factory {
                private final List<Factory> factories = new ArrayList<Factory>();

                /*
                 * WARNING - void declaration
                 */
                public Compound(Factory ... factory) {
                    this(Arrays.asList(var1_1));
                    void var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public Compound(List<? extends Factory> factories) {
                    Iterator iterator;
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        void var2_2;
                        Factory factory = (Factory)iterator.next();
                        if (factory instanceof Compound) {
                            this.factories.addAll(((Compound)factory).factories);
                            continue;
                        }
                        if (factory instanceof NoOp) continue;
                        this.factories.add((Factory)var2_2);
                    }
                }

                @Override
                public PostProcessor make(List<? extends AnnotationDescription> annotations, TypeDescription returnType, boolean exit) {
                    ArrayList<PostProcessor> postProcessors = new ArrayList<PostProcessor>(this.factories.size());
                    for (Factory factory : this.factories) {
                        postProcessors.add(factory.make(annotations, returnType, exit));
                    }
                    return new net.bytebuddy.asm.Advice$PostProcessor$Compound(postProcessors);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return ((Object)this.factories).equals(((Compound)object).factories);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + ((Object)this.factories).hashCode();
                }
            }
        }
    }

    public static interface ArgumentHandler {
        public static final int THIS_REFERENCE = 0;

        public int argument(int var1);

        public int exit();

        public int enter();

        public int named(String var1);

        public int returned();

        public int thrown();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Factory {
            SIMPLE{

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected final ForInstrumentedMethod resolve(MethodDescription instrumentedMethod, TypeDefinition enterType, TypeDefinition exitType, SortedMap<String, TypeDefinition> namedTypes) {
                    void var2_2;
                    void var3_3;
                    void var1_1;
                    return new ForInstrumentedMethod.Default.Simple((MethodDescription)var1_1, (TypeDefinition)var3_3, namedTypes, (TypeDefinition)var2_2);
                }
            }
            ,
            COPYING{

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected final ForInstrumentedMethod resolve(MethodDescription instrumentedMethod, TypeDefinition enterType, TypeDefinition exitType, SortedMap<String, TypeDefinition> namedTypes) {
                    void var2_2;
                    void var3_3;
                    void var1_1;
                    return new ForInstrumentedMethod.Default.Copying((MethodDescription)var1_1, (TypeDefinition)var3_3, namedTypes, (TypeDefinition)var2_2);
                }
            };


            protected abstract ForInstrumentedMethod resolve(MethodDescription var1, TypeDefinition var2, TypeDefinition var3, SortedMap<String, TypeDefinition> var4);
        }

        public static interface ForAdvice
        extends ArgumentHandler {
            public int mapped(int var1);

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static abstract class Default
            implements ForAdvice {
                protected final MethodDescription instrumentedMethod;
                protected final MethodDescription.TypeToken typeToken;
                protected final TypeDefinition exitType;
                protected final SortedMap<String, TypeDefinition> namedTypes;

                /*
                 * WARNING - void declaration
                 */
                protected Default(MethodDescription instrumentedMethod, MethodDescription.TypeToken typeToken, TypeDefinition exitType, SortedMap<String, TypeDefinition> namedTypes) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.instrumentedMethod = var1_1;
                    this.typeToken = var2_2;
                    this.exitType = var3_3;
                    this.namedTypes = namedTypes;
                }

                @Override
                public int argument(int offset) {
                    return offset;
                }

                @Override
                public int exit() {
                    return this.instrumentedMethod.getStackSize();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public int named(String name) {
                    void var1_1;
                    return this.instrumentedMethod.getStackSize() + this.exitType.getStackSize().getSize() + StackSize.of(this.namedTypes.headMap((String)var1_1).values());
                }

                @Override
                public int enter() {
                    return this.instrumentedMethod.getStackSize() + this.exitType.getStackSize().getSize() + StackSize.of(this.namedTypes.values());
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                protected static class ForMethodExit
                extends Default {
                    private final TypeDefinition enterType;
                    private final StackSize throwableSize;

                    /*
                     * WARNING - void declaration
                     */
                    protected ForMethodExit(MethodDescription instrumentedMethod, MethodDescription.TypeToken typeToken, TypeDefinition exitType, SortedMap<String, TypeDefinition> namedTypes, TypeDefinition enterType, StackSize throwableSize) {
                        super((MethodDescription)var1_1, (MethodDescription.TypeToken)var2_2, (TypeDefinition)var3_3, namedTypes);
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.enterType = enterType;
                        this.throwableSize = throwableSize;
                    }

                    @Override
                    public int returned() {
                        return this.instrumentedMethod.getStackSize() + this.exitType.getStackSize().getSize() + StackSize.of(this.namedTypes.values()) + this.enterType.getStackSize().getSize();
                    }

                    @Override
                    public int thrown() {
                        return this.instrumentedMethod.getStackSize() + this.exitType.getStackSize().getSize() + StackSize.of(this.namedTypes.values()) + this.enterType.getStackSize().getSize() + this.instrumentedMethod.getReturnType().getStackSize().getSize();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public int mapped(int offset) {
                        void var1_1;
                        return this.instrumentedMethod.getStackSize() + this.exitType.getStackSize().getSize() + StackSize.of(this.namedTypes.values()) + this.enterType.getStackSize().getSize() + this.instrumentedMethod.getReturnType().getStackSize().getSize() + this.throwableSize.getSize() - StackSize.of(this.typeToken.getParameterTypes()) + var1_1;
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (!this.throwableSize.equals((Object)((ForMethodExit)object).throwableSize)) {
                            return false;
                        }
                        return this.enterType.equals(((ForMethodExit)object).enterType);
                    }

                    public int hashCode() {
                        return (this.getClass().hashCode() * 31 + this.enterType.hashCode()) * 31 + this.throwableSize.hashCode();
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                protected static class ForMethodEnter
                extends Default {
                    /*
                     * WARNING - void declaration
                     */
                    protected ForMethodEnter(MethodDescription instrumentedMethod, MethodDescription.TypeToken typeToken, TypeDefinition exitType, SortedMap<String, TypeDefinition> namedTypes) {
                        super((MethodDescription)var1_1, (MethodDescription.TypeToken)var2_2, (TypeDefinition)var3_3, namedTypes);
                        void var3_3;
                        void var2_2;
                        void var1_1;
                    }

                    @Override
                    public int returned() {
                        throw new IllegalStateException("Cannot resolve the return value offset during enter advice");
                    }

                    @Override
                    public int thrown() {
                        throw new IllegalStateException("Cannot resolve the thrown value offset during enter advice");
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public int mapped(int offset) {
                        void var1_1;
                        return this.instrumentedMethod.getStackSize() + this.exitType.getStackSize().getSize() + StackSize.of(this.namedTypes.values()) - StackSize.of(this.typeToken.getParameterTypes()) + var1_1;
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        return this.getClass() == object.getClass();
                    }

                    public int hashCode() {
                        return this.getClass().hashCode();
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface ForInstrumentedMethod
        extends ArgumentHandler {
            public int prepare(MethodVisitor var1);

            public ForAdvice bindEnter(MethodDescription.TypeToken var1);

            public ForAdvice bindExit(MethodDescription.TypeToken var1, boolean var2);

            public boolean isCopyingArguments();

            public List<TypeDescription> getNamedTypes();

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static abstract class Default
            implements ForInstrumentedMethod {
                protected final MethodDescription instrumentedMethod;
                protected final TypeDefinition exitType;
                protected final SortedMap<String, TypeDefinition> namedTypes;
                protected final TypeDefinition enterType;

                /*
                 * WARNING - void declaration
                 */
                protected Default(MethodDescription instrumentedMethod, TypeDefinition exitType, SortedMap<String, TypeDefinition> namedTypes, TypeDefinition enterType) {
                    void var2_2;
                    void var3_3;
                    void var1_1;
                    this.instrumentedMethod = var1_1;
                    this.namedTypes = var3_3;
                    this.exitType = var2_2;
                    this.enterType = enterType;
                }

                @Override
                public int exit() {
                    return this.instrumentedMethod.getStackSize();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public int named(String name) {
                    void var1_1;
                    return this.instrumentedMethod.getStackSize() + this.exitType.getStackSize().getSize() + StackSize.of(this.namedTypes.headMap((String)var1_1).values());
                }

                @Override
                public int enter() {
                    return this.instrumentedMethod.getStackSize() + this.exitType.getStackSize().getSize() + StackSize.of(this.namedTypes.values());
                }

                @Override
                public int returned() {
                    return this.instrumentedMethod.getStackSize() + this.exitType.getStackSize().getSize() + StackSize.of(this.namedTypes.values()) + this.enterType.getStackSize().getSize();
                }

                @Override
                public int thrown() {
                    return this.instrumentedMethod.getStackSize() + this.exitType.getStackSize().getSize() + StackSize.of(this.namedTypes.values()) + this.enterType.getStackSize().getSize() + this.instrumentedMethod.getReturnType().getStackSize().getSize();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public ForAdvice bindEnter(MethodDescription.TypeToken typeToken) {
                    void var1_1;
                    return new ForAdvice.Default.ForMethodEnter(this.instrumentedMethod, (MethodDescription.TypeToken)var1_1, this.exitType, this.namedTypes);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public ForAdvice bindExit(MethodDescription.TypeToken typeToken, boolean skipThrowable) {
                    void var2_2;
                    void var1_1;
                    return new ForAdvice.Default.ForMethodExit(this.instrumentedMethod, (MethodDescription.TypeToken)var1_1, this.exitType, this.namedTypes, this.enterType, var2_2 != false ? StackSize.ZERO : StackSize.SINGLE);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public List<TypeDescription> getNamedTypes() {
                    void var1_1;
                    ArrayList<TypeDescription> namedTypes = new ArrayList<TypeDescription>(this.namedTypes.size());
                    for (TypeDefinition typeDefinition : this.namedTypes.values()) {
                        void var3_3;
                        namedTypes.add(var3_3.asErasure());
                    }
                    return var1_1;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                protected static class Copying
                extends Default {
                    /*
                     * WARNING - void declaration
                     */
                    protected Copying(MethodDescription instrumentedMethod, TypeDefinition exitType, SortedMap<String, TypeDefinition> namedTypes, TypeDefinition enterType) {
                        super((MethodDescription)var1_1, (TypeDefinition)var2_2, (SortedMap<String, TypeDefinition>)var3_3, enterType);
                        void var3_3;
                        void var2_2;
                        void var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public int argument(int offset) {
                        void var1_1;
                        return this.instrumentedMethod.getStackSize() + this.exitType.getStackSize().getSize() + StackSize.of(this.namedTypes.values()) + this.enterType.getStackSize().getSize() + var1_1;
                    }

                    @Override
                    public boolean isCopyingArguments() {
                        return true;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public int prepare(MethodVisitor methodVisitor) {
                        void var2_2;
                        StackSize stackSize;
                        if (!this.instrumentedMethod.isStatic()) {
                            methodVisitor.visitVarInsn(25, 0);
                            methodVisitor.visitVarInsn(58, this.instrumentedMethod.getStackSize() + this.exitType.getStackSize().getSize() + StackSize.of(this.namedTypes.values()) + this.enterType.getStackSize().getSize());
                            stackSize = StackSize.SINGLE;
                        } else {
                            stackSize = StackSize.ZERO;
                        }
                        for (ParameterDescription parameterDescription : this.instrumentedMethod.getParameters()) {
                            Type type = Type.getType(parameterDescription.getType().asErasure().getDescriptor());
                            methodVisitor.visitVarInsn(type.getOpcode(21), parameterDescription.getOffset());
                            methodVisitor.visitVarInsn(type.getOpcode(54), this.instrumentedMethod.getStackSize() + this.exitType.getStackSize().getSize() + StackSize.of(this.namedTypes.values()) + this.enterType.getStackSize().getSize() + parameterDescription.getOffset());
                            stackSize = stackSize.maximum(parameterDescription.getType().getStackSize());
                        }
                        return var2_2.getSize();
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        return this.getClass() == object.getClass();
                    }

                    public int hashCode() {
                        return this.getClass().hashCode();
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                protected static class Simple
                extends Default {
                    /*
                     * WARNING - void declaration
                     */
                    protected Simple(MethodDescription instrumentedMethod, TypeDefinition exitType, SortedMap<String, TypeDefinition> namedTypes, TypeDefinition enterType) {
                        super((MethodDescription)var1_1, (TypeDefinition)var2_2, (SortedMap<String, TypeDefinition>)var3_3, enterType);
                        void var3_3;
                        void var2_2;
                        void var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public int argument(int offset) {
                        void var1_1;
                        if (offset < this.instrumentedMethod.getStackSize()) {
                            return offset;
                        }
                        return (int)(var1_1 + this.exitType.getStackSize().getSize() + StackSize.of(this.namedTypes.values()) + this.enterType.getStackSize().getSize());
                    }

                    @Override
                    public boolean isCopyingArguments() {
                        return false;
                    }

                    @Override
                    public int prepare(MethodVisitor methodVisitor) {
                        return 0;
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        return this.getClass() == object.getClass();
                    }

                    public int hashCode() {
                        return this.getClass().hashCode();
                    }
                }
            }
        }
    }

    public static interface OffsetMapping {
        public Target resolve(TypeDescription var1, MethodDescription var2, Assigner var3, ArgumentHandler var4, Sort var5);

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForSerializedValue
        implements OffsetMapping {
            private final TypeDescription.Generic target;
            private final TypeDescription typeDescription;
            private final StackManipulation deserialization;

            /*
             * WARNING - void declaration
             */
            public ForSerializedValue(TypeDescription.Generic target, TypeDescription typeDescription, StackManipulation deserialization) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.target = var1_1;
                this.typeDescription = var2_2;
                this.deserialization = var3_3;
            }

            /*
             * WARNING - void declaration
             */
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                void var1_1;
                StackManipulation assignment = assigner.assign(this.typeDescription.asGenericType(), this.target, Assigner.Typing.DYNAMIC);
                if (!assignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.typeDescription + " to " + this.target);
                }
                return new Target.ForStackManipulation(new StackManipulation.Compound(new StackManipulation[]{this.deserialization, var1_1}));
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.target.equals(((ForSerializedValue)object).target)) {
                    return false;
                }
                if (!this.typeDescription.equals(((ForSerializedValue)object).typeDescription)) {
                    return false;
                }
                return this.deserialization.equals(((ForSerializedValue)object).deserialization);
            }

            public int hashCode() {
                return ((this.getClass().hashCode() * 31 + this.target.hashCode()) * 31 + this.typeDescription.hashCode()) * 31 + this.deserialization.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class Factory<T extends Annotation>
            implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<T> {
                private final Class<T> annotationType;
                private final TypeDescription typeDescription;
                private final StackManipulation deserialization;

                /*
                 * WARNING - void declaration
                 */
                protected Factory(Class<T> annotationType, TypeDescription typeDescription, StackManipulation deserialization) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.annotationType = var1_1;
                    this.typeDescription = var2_2;
                    this.deserialization = var3_3;
                }

                /*
                 * WARNING - void declaration
                 */
                public static <S extends Annotation, U extends Serializable> net.bytebuddy.asm.Advice$OffsetMapping$Factory<S> of(Class<S> annotationType, U target, Class<? super U> targetType) {
                    void var1_1;
                    void var2_2;
                    Class<S> clazz;
                    if (!targetType.isInstance(target)) {
                        throw new IllegalArgumentException(target + " is no instance of " + targetType);
                    }
                    return new Factory<S>(clazz, TypeDescription.ForLoadedType.of(var2_2), SerializedConstant.of((Serializable)var1_1));
                }

                @Override
                public Class<T> getAnnotationType() {
                    return this.annotationType;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, Factory.AdviceType adviceType) {
                    void var1_1;
                    return new ForSerializedValue(var1_1.getType(), this.typeDescription, this.deserialization);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.annotationType.equals(((Factory)object).annotationType)) {
                        return false;
                    }
                    if (!this.typeDescription.equals(((Factory)object).typeDescription)) {
                        return false;
                    }
                    return this.deserialization.equals(((Factory)object).deserialization);
                }

                public int hashCode() {
                    return ((this.getClass().hashCode() * 31 + this.annotationType.hashCode()) * 31 + this.typeDescription.hashCode()) * 31 + this.deserialization.hashCode();
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForStackManipulation
        implements OffsetMapping {
            private final StackManipulation stackManipulation;
            private final TypeDescription.Generic typeDescription;
            private final TypeDescription.Generic targetType;
            private final Assigner.Typing typing;

            /*
             * WARNING - void declaration
             */
            public ForStackManipulation(StackManipulation stackManipulation, TypeDescription.Generic typeDescription, TypeDescription.Generic targetType, Assigner.Typing typing) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.stackManipulation = var1_1;
                this.typeDescription = var2_2;
                this.targetType = var3_3;
                this.typing = typing;
            }

            /*
             * WARNING - void declaration
             */
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                void var1_1;
                StackManipulation assignment = assigner.assign(this.typeDescription, this.targetType, this.typing);
                if (!assignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.typeDescription + " to " + this.targetType);
                }
                return new Target.ForStackManipulation(new StackManipulation.Compound(new StackManipulation[]{this.stackManipulation, var1_1}));
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.typing.equals((Object)((ForStackManipulation)object).typing)) {
                    return false;
                }
                if (!this.stackManipulation.equals(((ForStackManipulation)object).stackManipulation)) {
                    return false;
                }
                if (!this.typeDescription.equals(((ForStackManipulation)object).typeDescription)) {
                    return false;
                }
                return this.targetType.equals(((ForStackManipulation)object).targetType);
            }

            public int hashCode() {
                return (((this.getClass().hashCode() * 31 + this.stackManipulation.hashCode()) * 31 + this.typeDescription.hashCode()) * 31 + this.targetType.hashCode()) * 31 + this.typing.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class OfDynamicInvocation<T extends Annotation>
            implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<T> {
                private final Class<T> annotationType;
                private final MethodDescription.InDefinedShape bootstrapMethod;
                private final List<? extends JavaConstant> arguments;

                /*
                 * WARNING - void declaration
                 */
                public OfDynamicInvocation(Class<T> annotationType, MethodDescription.InDefinedShape bootstrapMethod, List<? extends JavaConstant> arguments) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.annotationType = var1_1;
                    this.bootstrapMethod = var2_2;
                    this.arguments = var3_3;
                }

                @Override
                public Class<T> getAnnotationType() {
                    return this.annotationType;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, Factory.AdviceType adviceType) {
                    void var1_1;
                    void var2_2;
                    if (!target.getType().isInterface()) {
                        throw new IllegalArgumentException(target.getType() + " is not an interface");
                    }
                    if (!target.getType().getInterfaces().isEmpty()) {
                        throw new IllegalArgumentException(target.getType() + " must not extend other interfaces");
                    }
                    if (!target.getType().isPublic()) {
                        throw new IllegalArgumentException(target.getType() + " is mot public");
                    }
                    MethodList methodCandidates = (MethodList)target.getType().getDeclaredMethods().filter(ElementMatchers.isAbstract());
                    if (methodCandidates.size() != 1) {
                        throw new IllegalArgumentException(target.getType() + " must declare exactly one abstract method");
                    }
                    return new ForStackManipulation(MethodInvocation.invoke(this.bootstrapMethod).dynamic(((MethodDescription)var2_2.getOnly()).getInternalName(), target.getType().asErasure(), Collections.emptyList(), this.arguments), target.getType(), var1_1.getType(), Assigner.Typing.STATIC);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.annotationType.equals(((OfDynamicInvocation)object).annotationType)) {
                        return false;
                    }
                    if (!this.bootstrapMethod.equals(((OfDynamicInvocation)object).bootstrapMethod)) {
                        return false;
                    }
                    return ((Object)this.arguments).equals(((OfDynamicInvocation)object).arguments);
                }

                public int hashCode() {
                    return ((this.getClass().hashCode() * 31 + this.annotationType.hashCode()) * 31 + this.bootstrapMethod.hashCode()) * 31 + ((Object)this.arguments).hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class OfAnnotationProperty<T extends Annotation>
            implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<T> {
                private final Class<T> annotationType;
                private final MethodDescription.InDefinedShape property;

                /*
                 * WARNING - void declaration
                 */
                protected OfAnnotationProperty(Class<T> annotationType, MethodDescription.InDefinedShape property) {
                    void var2_2;
                    void var1_1;
                    this.annotationType = var1_1;
                    this.property = var2_2;
                }

                /*
                 * WARNING - void declaration
                 */
                public static <S extends Annotation> net.bytebuddy.asm.Advice$OffsetMapping$Factory<S> of(Class<S> annotationType, String property) {
                    if (!annotationType.isAnnotation()) {
                        throw new IllegalArgumentException("Not an annotation type: " + annotationType);
                    }
                    try {
                        return new OfAnnotationProperty<S>(annotationType, new MethodDescription.ForLoadedMethod(annotationType.getMethod(property, new Class[0])));
                    }
                    catch (NoSuchMethodException exception) {
                        void var2_2;
                        Class<S> clazz;
                        void var1_1;
                        throw new IllegalArgumentException("Cannot find a property " + (String)var1_1 + " on " + clazz, (Throwable)var2_2);
                    }
                }

                @Override
                public Class<T> getAnnotationType() {
                    return this.annotationType;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, Factory.AdviceType adviceType) {
                    void var1_1;
                    void var2_2;
                    ConstantValue value = ConstantValue.Simple.wrapOrNull(annotation.getValue(this.property).resolve());
                    if (value == null) {
                        throw new IllegalStateException("Property does not represent a constant value: " + this.property);
                    }
                    return new ForStackManipulation(value.toStackManipulation(), var2_2.getTypeDescription().asGenericType(), var1_1.getType(), Assigner.Typing.STATIC);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.annotationType.equals(((OfAnnotationProperty)object).annotationType)) {
                        return false;
                    }
                    return this.property.equals(((OfAnnotationProperty)object).property);
                }

                public int hashCode() {
                    return (this.getClass().hashCode() * 31 + this.annotationType.hashCode()) * 31 + this.property.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class OfDefaultValue<T extends Annotation>
            implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<T> {
                private final Class<T> annotationType;

                /*
                 * WARNING - void declaration
                 */
                public OfDefaultValue(Class<T> annotationType) {
                    void var1_1;
                    this.annotationType = var1_1;
                }

                @Override
                public Class<T> getAnnotationType() {
                    return this.annotationType;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, Factory.AdviceType adviceType) {
                    void var1_1;
                    return new ForStackManipulation(DefaultValue.of(target.getType()), target.getType(), var1_1.getType(), Assigner.Typing.STATIC);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.annotationType.equals(((OfDefaultValue)object).annotationType);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.annotationType.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class Factory<T extends Annotation>
            implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<T> {
                private final Class<T> annotationType;
                private final StackManipulation stackManipulation;
                private final TypeDescription.Generic typeDescription;

                /*
                 * WARNING - void declaration
                 */
                public Factory(Class<T> annotationType, TypeDescription typeDescription) {
                    this((Class<T>)var1_1, ClassConstant.of((TypeDescription)var2_2), TypeDescription.ForLoadedType.of(Class.class).asGenericType());
                    void var2_2;
                    void var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public Factory(Class<T> annotationType, EnumerationDescription enumerationDescription) {
                    this((Class<T>)var1_1, FieldAccess.forEnumeration(enumerationDescription), var2_2.getEnumerationType().asGenericType());
                    void var2_2;
                    void var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public Factory(Class<T> annotationType, ConstantValue constant) {
                    this((Class<T>)var1_1, constant.toStackManipulation(), var2_2.getTypeDescription().asGenericType());
                    void var2_2;
                    void var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public Factory(Class<T> annotationType, StackManipulation stackManipulation, TypeDescription.Generic typeDescription) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.annotationType = var1_1;
                    this.stackManipulation = var2_2;
                    this.typeDescription = var3_3;
                }

                /*
                 * WARNING - void declaration
                 */
                public static <S extends Annotation> net.bytebuddy.asm.Advice$OffsetMapping$Factory<S> of(Class<S> annotationType, @MaybeNull Object value) {
                    void var1_1;
                    Class<S> clazz;
                    if (value == null) {
                        return new OfDefaultValue<S>(annotationType);
                    }
                    return new Factory<S>(clazz, ConstantValue.Simple.wrap(var1_1));
                }

                @Override
                public Class<T> getAnnotationType() {
                    return this.annotationType;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, Factory.AdviceType adviceType) {
                    void var1_1;
                    return new ForStackManipulation(this.stackManipulation, this.typeDescription, var1_1.getType(), Assigner.Typing.STATIC);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.annotationType.equals(((Factory)object).annotationType)) {
                        return false;
                    }
                    if (!this.stackManipulation.equals(((Factory)object).stackManipulation)) {
                        return false;
                    }
                    return this.typeDescription.equals(((Factory)object).typeDescription);
                }

                public int hashCode() {
                    return ((this.getClass().hashCode() * 31 + this.annotationType.hashCode()) * 31 + this.stackManipulation.hashCode()) * 31 + this.typeDescription.hashCode();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class ForThrowable
        implements OffsetMapping {
            private final TypeDescription.Generic target;
            private final boolean readOnly;
            private final Assigner.Typing typing;

            /*
             * WARNING - void declaration
             */
            protected ForThrowable(TypeDescription.Generic target, AnnotationDescription.Loadable<Thrown> annotation) {
                this((TypeDescription.Generic)var1_1, annotation.getValue(Factory.THROWN_READ_ONLY).resolve(Boolean.class), var2_2.getValue(Factory.THROWN_TYPING).resolve(EnumerationDescription.class).load(Assigner.Typing.class));
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public ForThrowable(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.target = var1_1;
                this.readOnly = var2_2;
                this.typing = var3_3;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                void var2_2;
                void var1_1;
                void var3_3;
                StackManipulation readAssignment = assigner.assign(TypeDescription.ForLoadedType.of(Throwable.class).asGenericType(), this.target, this.typing);
                if (!readAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign Throwable to " + this.target);
                }
                if (this.readOnly) {
                    return new Target.ForVariable.ReadOnly(TypeDescription.ForLoadedType.of(Throwable.class), argumentHandler.thrown(), readAssignment);
                }
                StackManipulation writeAssignment = var3_3.assign(this.target, TypeDescription.ForLoadedType.of(Throwable.class).asGenericType(), this.typing);
                if (!writeAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.target + " to Throwable");
                }
                return new Target.ForVariable.ReadWrite(TypeDescription.ForLoadedType.of(Throwable.class), argumentHandler.thrown(), (StackManipulation)var1_1, (StackManipulation)var2_2);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (this.readOnly != ((ForThrowable)object).readOnly) {
                    return false;
                }
                if (!this.typing.equals((Object)((ForThrowable)object).typing)) {
                    return false;
                }
                return this.target.equals(((ForThrowable)object).target);
            }

            public int hashCode() {
                return ((this.getClass().hashCode() * 31 + this.target.hashCode()) * 31 + this.readOnly) * 31 + this.typing.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static final class Factory
            extends Enum<Factory>
            implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<Thrown> {
                public static final /* enum */ Factory INSTANCE;
                private static final MethodDescription.InDefinedShape THROWN_READ_ONLY;
                private static final MethodDescription.InDefinedShape THROWN_TYPING;
                private static final /* synthetic */ Factory[] $VALUES;

                public static Factory[] values() {
                    return (Factory[])$VALUES.clone();
                }

                public static Factory valueOf(String name) {
                    String string;
                    return Enum.valueOf(Factory.class, string);
                }

                @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming annotation for exit advice.")
                protected static net.bytebuddy.asm.Advice$OffsetMapping$Factory<?> of(MethodDescription.InDefinedShape adviceMethod) {
                    if (adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(ON_THROWABLE).resolve(TypeDescription.class).represents((java.lang.reflect.Type)((Object)NoExceptionHandler.class))) {
                        return new Factory.Illegal<Thrown>(Thrown.class);
                    }
                    return INSTANCE;
                }

                @Override
                public final Class<Thrown> getAnnotationType() {
                    return Thrown.class;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Thrown> annotation, Factory.AdviceType adviceType) {
                    void var2_2;
                    void var1_1;
                    if (adviceType.isDelegation() && !annotation.getValue(THROWN_READ_ONLY).resolve(Boolean.class).booleanValue()) {
                        throw new IllegalStateException("Cannot use writable " + target + " on read-only parameter");
                    }
                    return new ForThrowable(var1_1.getType(), (AnnotationDescription.Loadable<Thrown>)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                static {
                    void var0;
                    INSTANCE = new Factory();
                    $VALUES = new Factory[]{INSTANCE};
                    MethodList<MethodDescription.InDefinedShape> methods = TypeDescription.ForLoadedType.of(Thrown.class).getDeclaredMethods();
                    THROWN_READ_ONLY = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("readOnly"))).getOnly();
                    THROWN_TYPING = (MethodDescription.InDefinedShape)((MethodList)var0.filter(ElementMatchers.named("typing"))).getOnly();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class ForReturnValue
        implements OffsetMapping {
            private final TypeDescription.Generic target;
            private final boolean readOnly;
            private final Assigner.Typing typing;

            /*
             * WARNING - void declaration
             */
            protected ForReturnValue(TypeDescription.Generic target, AnnotationDescription.Loadable<Return> annotation) {
                this((TypeDescription.Generic)var1_1, annotation.getValue(Factory.RETURN_READ_ONLY).resolve(Boolean.class), var2_2.getValue(Factory.RETURN_TYPING).resolve(EnumerationDescription.class).load(Assigner.Typing.class));
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public ForReturnValue(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.target = var1_1;
                this.readOnly = var2_2;
                this.typing = var3_3;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                void var3_3;
                void var1_1;
                void var2_2;
                StackManipulation readAssignment = assigner.assign(instrumentedMethod.getReturnType(), this.target, this.typing);
                if (!readAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + instrumentedMethod.getReturnType() + " to " + this.target);
                }
                if (this.readOnly) {
                    if (instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                        return new Target.ForDefaultValue.ReadOnly(this.target);
                    }
                    return new Target.ForVariable.ReadOnly(instrumentedMethod.getReturnType(), argumentHandler.returned(), readAssignment);
                }
                StackManipulation writeAssignment = assigner.assign(this.target, instrumentedMethod.getReturnType(), this.typing);
                if (!writeAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.target + " to " + instrumentedMethod.getReturnType());
                }
                if (instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                    return new Target.ForDefaultValue.ReadWrite(this.target);
                }
                return new Target.ForVariable.ReadWrite(var2_2.getReturnType(), argumentHandler.returned(), (StackManipulation)var1_1, (StackManipulation)var3_3);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (this.readOnly != ((ForReturnValue)object).readOnly) {
                    return false;
                }
                if (!this.typing.equals((Object)((ForReturnValue)object).typing)) {
                    return false;
                }
                return this.target.equals(((ForReturnValue)object).target);
            }

            public int hashCode() {
                return ((this.getClass().hashCode() * 31 + this.target.hashCode()) * 31 + this.readOnly) * 31 + this.typing.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static final class Factory
            extends Enum<Factory>
            implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<Return> {
                public static final /* enum */ Factory INSTANCE;
                private static final MethodDescription.InDefinedShape RETURN_READ_ONLY;
                private static final MethodDescription.InDefinedShape RETURN_TYPING;
                private static final /* synthetic */ Factory[] $VALUES;

                public static Factory[] values() {
                    return (Factory[])$VALUES.clone();
                }

                public static Factory valueOf(String name) {
                    String string;
                    return Enum.valueOf(Factory.class, string);
                }

                @Override
                public final Class<Return> getAnnotationType() {
                    return Return.class;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Return> annotation, Factory.AdviceType adviceType) {
                    void var2_2;
                    void var1_1;
                    if (adviceType.isDelegation() && !annotation.getValue(RETURN_READ_ONLY).resolve(Boolean.class).booleanValue()) {
                        throw new IllegalStateException("Cannot write return value for " + target + " in read-only context");
                    }
                    return new ForReturnValue(var1_1.getType(), (AnnotationDescription.Loadable<Return>)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                static {
                    void var0;
                    INSTANCE = new Factory();
                    $VALUES = new Factory[]{INSTANCE};
                    MethodList<MethodDescription.InDefinedShape> methods = TypeDescription.ForLoadedType.of(Return.class).getDeclaredMethods();
                    RETURN_READ_ONLY = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("readOnly"))).getOnly();
                    RETURN_TYPING = (MethodDescription.InDefinedShape)((MethodList)var0.filter(ElementMatchers.named("typing"))).getOnly();
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForLocalValue
        implements OffsetMapping {
            private final TypeDescription.Generic target;
            private final TypeDescription.Generic localType;
            private final String name;

            /*
             * WARNING - void declaration
             */
            public ForLocalValue(TypeDescription.Generic target, TypeDescription.Generic localType, String name) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.target = var1_1;
                this.localType = var2_2;
                this.name = var3_3;
            }

            /*
             * WARNING - void declaration
             */
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                void var2_2;
                void var1_1;
                void var3_3;
                StackManipulation readAssignment = assigner.assign(this.localType, this.target, Assigner.Typing.STATIC);
                StackManipulation writeAssignment = var3_3.assign(this.target, this.localType, Assigner.Typing.STATIC);
                if (!readAssignment.isValid() || !writeAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.localType + " to " + this.target);
                }
                return new Target.ForVariable.ReadWrite(this.target, argumentHandler.named(this.name), (StackManipulation)var1_1, (StackManipulation)var2_2);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.name.equals(((ForLocalValue)object).name)) {
                    return false;
                }
                if (!this.target.equals(((ForLocalValue)object).target)) {
                    return false;
                }
                return this.localType.equals(((ForLocalValue)object).localType);
            }

            public int hashCode() {
                return ((this.getClass().hashCode() * 31 + this.target.hashCode()) * 31 + this.localType.hashCode()) * 31 + this.name.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            protected static class Factory
            implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<Local> {
                protected static final MethodDescription.InDefinedShape LOCAL_VALUE = (MethodDescription.InDefinedShape)((MethodList)TypeDescription.ForLoadedType.of(Local.class).getDeclaredMethods().filter(ElementMatchers.named("value"))).getOnly();
                private final Map<String, TypeDefinition> namedTypes;

                /*
                 * WARNING - void declaration
                 */
                protected Factory(Map<String, TypeDefinition> namedTypes) {
                    void var1_1;
                    this.namedTypes = var1_1;
                }

                @Override
                public Class<Local> getAnnotationType() {
                    return Local.class;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Local> annotation, Factory.AdviceType adviceType) {
                    void var2_2;
                    void var3_3;
                    void var1_1;
                    String name = annotation.getValue(LOCAL_VALUE).resolve(String.class);
                    TypeDefinition namedType = this.namedTypes.get(name);
                    if (namedType == null) {
                        throw new IllegalStateException("Named local variable is unknown: " + name);
                    }
                    return new ForLocalValue(var1_1.getType(), var3_3.asGenericType(), (String)var2_2);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return ((Object)this.namedTypes).equals(((Factory)object).namedTypes);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + ((Object)this.namedTypes).hashCode();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class ForExitValue
        implements OffsetMapping {
            private final TypeDescription.Generic target;
            private final TypeDescription.Generic exitType;
            private final boolean readOnly;
            private final Assigner.Typing typing;

            /*
             * WARNING - void declaration
             */
            protected ForExitValue(TypeDescription.Generic target, TypeDescription.Generic exitType, AnnotationDescription.Loadable<Exit> annotation) {
                this((TypeDescription.Generic)var1_1, (TypeDescription.Generic)var2_2, annotation.getValue(Factory.EXIT_READ_ONLY).resolve(Boolean.class), var3_3.getValue(Factory.EXIT_TYPING).resolve(EnumerationDescription.class).load(Assigner.Typing.class));
                void var3_3;
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public ForExitValue(TypeDescription.Generic target, TypeDescription.Generic exitType, boolean readOnly, Assigner.Typing typing) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.target = var1_1;
                this.exitType = var2_2;
                this.readOnly = var3_3;
                this.typing = typing;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                void var2_2;
                void var1_1;
                void var3_3;
                StackManipulation readAssignment = assigner.assign(this.exitType, this.target, this.typing);
                if (!readAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.exitType + " to " + this.target);
                }
                if (this.readOnly) {
                    return new Target.ForVariable.ReadOnly(this.target, argumentHandler.exit(), readAssignment);
                }
                StackManipulation writeAssignment = var3_3.assign(this.target, this.exitType, this.typing);
                if (!writeAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.target + " to " + this.exitType);
                }
                return new Target.ForVariable.ReadWrite(this.target, argumentHandler.exit(), (StackManipulation)var1_1, (StackManipulation)var2_2);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (this.readOnly != ((ForExitValue)object).readOnly) {
                    return false;
                }
                if (!this.typing.equals((Object)((ForExitValue)object).typing)) {
                    return false;
                }
                if (!this.target.equals(((ForExitValue)object).target)) {
                    return false;
                }
                return this.exitType.equals(((ForExitValue)object).exitType);
            }

            public int hashCode() {
                return (((this.getClass().hashCode() * 31 + this.target.hashCode()) * 31 + this.exitType.hashCode()) * 31 + this.readOnly) * 31 + this.typing.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            protected static class Factory
            implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<Exit> {
                private static final MethodDescription.InDefinedShape EXIT_READ_ONLY;
                private static final MethodDescription.InDefinedShape EXIT_TYPING;
                private final TypeDefinition exitType;

                /*
                 * WARNING - void declaration
                 */
                protected Factory(TypeDefinition exitType) {
                    void var1_1;
                    this.exitType = var1_1;
                }

                protected static net.bytebuddy.asm.Advice$OffsetMapping$Factory<Exit> of(TypeDefinition typeDefinition) {
                    TypeDefinition typeDefinition2;
                    if (typeDefinition.represents(Void.TYPE)) {
                        return new Factory.Illegal<Exit>(Exit.class);
                    }
                    return new Factory(typeDefinition2);
                }

                @Override
                public Class<Exit> getAnnotationType() {
                    return Exit.class;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Exit> annotation, Factory.AdviceType adviceType) {
                    void var2_2;
                    void var1_1;
                    if (adviceType.isDelegation() && !annotation.getValue(EXIT_READ_ONLY).resolve(Boolean.class).booleanValue()) {
                        throw new IllegalStateException("Cannot use writable " + target + " on read-only parameter");
                    }
                    return new ForExitValue(var1_1.getType(), this.exitType.asGenericType(), (AnnotationDescription.Loadable<Exit>)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                static {
                    void var0;
                    MethodList<MethodDescription.InDefinedShape> methods = TypeDescription.ForLoadedType.of(Exit.class).getDeclaredMethods();
                    EXIT_READ_ONLY = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("readOnly"))).getOnly();
                    EXIT_TYPING = (MethodDescription.InDefinedShape)((MethodList)var0.filter(ElementMatchers.named("typing"))).getOnly();
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.exitType.equals(((Factory)object).exitType);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.exitType.hashCode();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class ForEnterValue
        implements OffsetMapping {
            private final TypeDescription.Generic target;
            private final TypeDescription.Generic enterType;
            private final boolean readOnly;
            private final Assigner.Typing typing;

            /*
             * WARNING - void declaration
             */
            protected ForEnterValue(TypeDescription.Generic target, TypeDescription.Generic enterType, AnnotationDescription.Loadable<Enter> annotation) {
                this((TypeDescription.Generic)var1_1, (TypeDescription.Generic)var2_2, annotation.getValue(Factory.ENTER_READ_ONLY).resolve(Boolean.class), var3_3.getValue(Factory.ENTER_TYPING).resolve(EnumerationDescription.class).load(Assigner.Typing.class));
                void var3_3;
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public ForEnterValue(TypeDescription.Generic target, TypeDescription.Generic enterType, boolean readOnly, Assigner.Typing typing) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.target = var1_1;
                this.enterType = var2_2;
                this.readOnly = var3_3;
                this.typing = typing;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                void var2_2;
                void var1_1;
                void var3_3;
                StackManipulation readAssignment = assigner.assign(this.enterType, this.target, this.typing);
                if (!readAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.enterType + " to " + this.target);
                }
                if (this.readOnly) {
                    return new Target.ForVariable.ReadOnly(this.target, argumentHandler.enter(), readAssignment);
                }
                StackManipulation writeAssignment = var3_3.assign(this.target, this.enterType, this.typing);
                if (!writeAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.target + " to " + this.enterType);
                }
                return new Target.ForVariable.ReadWrite(this.target, argumentHandler.enter(), (StackManipulation)var1_1, (StackManipulation)var2_2);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (this.readOnly != ((ForEnterValue)object).readOnly) {
                    return false;
                }
                if (!this.typing.equals((Object)((ForEnterValue)object).typing)) {
                    return false;
                }
                if (!this.target.equals(((ForEnterValue)object).target)) {
                    return false;
                }
                return this.enterType.equals(((ForEnterValue)object).enterType);
            }

            public int hashCode() {
                return (((this.getClass().hashCode() * 31 + this.target.hashCode()) * 31 + this.enterType.hashCode()) * 31 + this.readOnly) * 31 + this.typing.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            protected static class Factory
            implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<Enter> {
                private static final MethodDescription.InDefinedShape ENTER_READ_ONLY;
                private static final MethodDescription.InDefinedShape ENTER_TYPING;
                private final TypeDefinition enterType;

                /*
                 * WARNING - void declaration
                 */
                protected Factory(TypeDefinition enterType) {
                    void var1_1;
                    this.enterType = var1_1;
                }

                protected static net.bytebuddy.asm.Advice$OffsetMapping$Factory<Enter> of(TypeDefinition typeDefinition) {
                    TypeDefinition typeDefinition2;
                    if (typeDefinition.represents(Void.TYPE)) {
                        return new Factory.Illegal<Enter>(Enter.class);
                    }
                    return new Factory(typeDefinition2);
                }

                @Override
                public Class<Enter> getAnnotationType() {
                    return Enter.class;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Enter> annotation, Factory.AdviceType adviceType) {
                    void var2_2;
                    void var1_1;
                    if (adviceType.isDelegation() && !annotation.getValue(ENTER_READ_ONLY).resolve(Boolean.class).booleanValue()) {
                        throw new IllegalStateException("Cannot use writable " + target + " on read-only parameter");
                    }
                    return new ForEnterValue(var1_1.getType(), this.enterType.asGenericType(), (AnnotationDescription.Loadable<Enter>)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                static {
                    void var0;
                    MethodList<MethodDescription.InDefinedShape> methods = TypeDescription.ForLoadedType.of(Enter.class).getDeclaredMethods();
                    ENTER_READ_ONLY = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("readOnly"))).getOnly();
                    ENTER_TYPING = (MethodDescription.InDefinedShape)((MethodList)var0.filter(ElementMatchers.named("typing"))).getOnly();
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.enterType.equals(((Factory)object).enterType);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.enterType.hashCode();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ForStubValue implements OffsetMapping,
        Factory<StubValue>
        {
            INSTANCE;


            /*
             * WARNING - void declaration
             */
            @Override
            public final Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                void var2_2;
                void var3_3;
                return new Target.ForDefaultValue.ReadOnly(instrumentedMethod.getReturnType(), var3_3.assign(var2_2.getReturnType(), TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(Object.class), Assigner.Typing.DYNAMIC));
            }

            @Override
            public final Class<StubValue> getAnnotationType() {
                return StubValue.class;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<StubValue> annotation, Factory.AdviceType adviceType) {
                if (!target.getType().represents((java.lang.reflect.Type)((Object)Object.class))) {
                    void var1_1;
                    throw new IllegalStateException("Cannot use StubValue on non-Object parameter type " + var1_1);
                }
                return this;
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForUnusedValue
        implements OffsetMapping {
            private final TypeDefinition target;

            /*
             * WARNING - void declaration
             */
            public ForUnusedValue(TypeDefinition target) {
                void var1_1;
                this.target = var1_1;
            }

            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                return new Target.ForDefaultValue.ReadWrite(this.target);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.target.equals(((ForUnusedValue)object).target);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.target.hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static enum Factory implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<Unused>
            {
                INSTANCE;


                @Override
                public final Class<Unused> getAnnotationType() {
                    return Unused.class;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Unused> annotation, Factory.AdviceType adviceType) {
                    void var1_1;
                    return new ForUnusedValue(var1_1.getType());
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class ForDynamicConstant
        implements OffsetMapping {
            private final String name;
            private final TypeDescription typeDescription;
            private final JavaConstant.MethodHandle.HandleType bootstrapType;
            private final TypeDescription bootstrapOwner;
            private final String bootstrapName;
            private final TypeDescription bootstrapReturnType;
            private final List<? extends TypeDescription> bootstrapParameterTypes;
            private final List<JavaConstant> arguments;
            private final boolean invokedynamic;

            /*
             * WARNING - void declaration
             */
            public ForDynamicConstant(String name, TypeDescription typeDescription, JavaConstant.MethodHandle.HandleType bootstrapType, TypeDescription bootstrapOwner, String bootstrapName, TypeDescription bootstrapReturnType, List<? extends TypeDescription> bootstrapParameterTypes, List<JavaConstant> arguments, boolean invokedynamic) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.name = var1_1;
                this.typeDescription = var2_2;
                this.bootstrapType = var3_3;
                this.bootstrapOwner = bootstrapOwner;
                this.bootstrapName = bootstrapName;
                this.bootstrapReturnType = bootstrapReturnType;
                this.bootstrapParameterTypes = bootstrapParameterTypes;
                this.arguments = arguments;
                this.invokedynamic = invokedynamic;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                void var1_1;
                TypeDescription bootstrapOwner;
                TypeDescription typeDescription = bootstrapOwner = this.bootstrapOwner.represents(Void.TYPE) ? instrumentedType : this.bootstrapOwner;
                if (this.invokedynamic) {
                    return new Target.ForStackManipulation(new Invokedynamic(this.name, JavaConstant.MethodType.of(this.typeDescription, new TypeDescription[0]), new JavaConstant.MethodHandle(this.bootstrapType, bootstrapOwner, this.bootstrapName, this.bootstrapReturnType, this.bootstrapParameterTypes), this.arguments));
                }
                return new Target.ForStackManipulation(new JavaConstantValue(new JavaConstant.Dynamic(this.name, this.typeDescription, new JavaConstant.MethodHandle(this.bootstrapType, (TypeDescription)var1_1, this.bootstrapName, this.bootstrapReturnType, this.bootstrapParameterTypes), this.arguments)));
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (this.invokedynamic != ((ForDynamicConstant)object).invokedynamic) {
                    return false;
                }
                if (!this.bootstrapType.equals((Object)((ForDynamicConstant)object).bootstrapType)) {
                    return false;
                }
                if (!this.name.equals(((ForDynamicConstant)object).name)) {
                    return false;
                }
                if (!this.bootstrapName.equals(((ForDynamicConstant)object).bootstrapName)) {
                    return false;
                }
                if (!this.typeDescription.equals(((ForDynamicConstant)object).typeDescription)) {
                    return false;
                }
                if (!this.bootstrapOwner.equals(((ForDynamicConstant)object).bootstrapOwner)) {
                    return false;
                }
                if (!this.bootstrapReturnType.equals(((ForDynamicConstant)object).bootstrapReturnType)) {
                    return false;
                }
                if (!((Object)this.bootstrapParameterTypes).equals(((ForDynamicConstant)object).bootstrapParameterTypes)) {
                    return false;
                }
                return ((Object)this.arguments).equals(((ForDynamicConstant)object).arguments);
            }

            public int hashCode() {
                return ((((((((this.getClass().hashCode() * 31 + this.name.hashCode()) * 31 + this.typeDescription.hashCode()) * 31 + this.bootstrapType.hashCode()) * 31 + this.bootstrapOwner.hashCode()) * 31 + this.bootstrapName.hashCode()) * 31 + this.bootstrapReturnType.hashCode()) * 31 + ((Object)this.bootstrapParameterTypes).hashCode()) * 31 + ((Object)this.arguments).hashCode()) * 31 + this.invokedynamic;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static final class Factory
            extends Enum<Factory>
            implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<DynamicConstant> {
                public static final /* enum */ Factory INSTANCE;
                private static final MethodDescription.InDefinedShape NAME;
                private static final MethodDescription.InDefinedShape BOOTSTRAP_TYPE;
                private static final MethodDescription.InDefinedShape BOOTSTRAP_OWNER;
                private static final MethodDescription.InDefinedShape BOOTSTRAP_NAME;
                private static final MethodDescription.InDefinedShape BOOTSTRAP_RETURN_TYPE;
                private static final MethodDescription.InDefinedShape BOOTSTRAP_PARAMETER_TYPES;
                private static final MethodDescription.InDefinedShape INVOKEDYNAMIC;
                private static final /* synthetic */ Factory[] $VALUES;

                public static Factory[] values() {
                    return (Factory[])$VALUES.clone();
                }

                public static Factory valueOf(String name) {
                    String string;
                    return Enum.valueOf(Factory.class, string);
                }

                @Override
                public final Class<DynamicConstant> getAnnotationType() {
                    return DynamicConstant.class;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<DynamicConstant> annotation, Factory.AdviceType adviceType) {
                    void var2_2;
                    void var1_1;
                    return new ForDynamicConstant(annotation.getValue(NAME).resolve(String.class), var1_1.getType().asErasure(), annotation.getValue(BOOTSTRAP_TYPE).resolve(EnumerationDescription.class).load(JavaConstant.MethodHandle.HandleType.class), annotation.getValue(BOOTSTRAP_OWNER).resolve(TypeDescription.class), annotation.getValue(BOOTSTRAP_NAME).resolve(String.class), annotation.getValue(BOOTSTRAP_RETURN_TYPE).resolve(TypeDescription.class), Arrays.asList((Object[])annotation.getValue(BOOTSTRAP_PARAMETER_TYPES).resolve(TypeDescription[].class)), Collections.<JavaConstant>emptyList(), var2_2.getValue(INVOKEDYNAMIC).resolve(Boolean.class));
                }

                /*
                 * WARNING - void declaration
                 */
                static {
                    void var0;
                    INSTANCE = new Factory();
                    $VALUES = new Factory[]{INSTANCE};
                    MethodList<MethodDescription.InDefinedShape> methods = TypeDescription.ForLoadedType.of(DynamicConstant.class).getDeclaredMethods();
                    NAME = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("name"))).getOnly();
                    BOOTSTRAP_TYPE = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("bootstrapType"))).getOnly();
                    BOOTSTRAP_OWNER = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("bootstrapOwner"))).getOnly();
                    BOOTSTRAP_NAME = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("bootstrapName"))).getOnly();
                    BOOTSTRAP_RETURN_TYPE = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("bootstrapReturnType"))).getOnly();
                    BOOTSTRAP_PARAMETER_TYPES = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("bootstrapParameterTypes"))).getOnly();
                    INVOKEDYNAMIC = (MethodDescription.InDefinedShape)((MethodList)var0.filter(ElementMatchers.named("invokedynamic"))).getOnly();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class ForHandle
        implements OffsetMapping {
            private final JavaConstant.MethodHandle.HandleType type;
            private final TypeDescription owner;
            private final String name;
            private final TypeDescription returnType;
            private final List<? extends TypeDescription> parameterTypes;

            /*
             * WARNING - void declaration
             */
            protected ForHandle(JavaConstant.MethodHandle.HandleType type, TypeDescription owner, String name, TypeDescription returnType, List<? extends TypeDescription> parameterTypes) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.type = var1_1;
                this.owner = var2_2;
                this.name = var3_3;
                this.returnType = returnType;
                this.parameterTypes = parameterTypes;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                void var1_1;
                return new Target.ForStackManipulation(new JavaConstantValue(new JavaConstant.MethodHandle(this.type, (TypeDescription)(this.owner.represents(Void.TYPE) ? var1_1 : this.owner), this.name, this.returnType, this.parameterTypes)));
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.type.equals((Object)((ForHandle)object).type)) {
                    return false;
                }
                if (!this.name.equals(((ForHandle)object).name)) {
                    return false;
                }
                if (!this.owner.equals(((ForHandle)object).owner)) {
                    return false;
                }
                if (!this.returnType.equals(((ForHandle)object).returnType)) {
                    return false;
                }
                return ((Object)this.parameterTypes).equals(((ForHandle)object).parameterTypes);
            }

            public int hashCode() {
                return ((((this.getClass().hashCode() * 31 + this.type.hashCode()) * 31 + this.owner.hashCode()) * 31 + this.name.hashCode()) * 31 + this.returnType.hashCode()) * 31 + ((Object)this.parameterTypes).hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static final class Factory
            extends Enum<Factory>
            implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<Handle> {
                public static final /* enum */ Factory INSTANCE;
                private static final MethodDescription.InDefinedShape TYPE;
                private static final MethodDescription.InDefinedShape OWNER;
                private static final MethodDescription.InDefinedShape NAME;
                private static final MethodDescription.InDefinedShape RETURN_TYPE;
                private static final MethodDescription.InDefinedShape PARAMETER_TYPES;
                private static final /* synthetic */ Factory[] $VALUES;

                public static Factory[] values() {
                    return (Factory[])$VALUES.clone();
                }

                public static Factory valueOf(String name) {
                    String string;
                    return Enum.valueOf(Factory.class, string);
                }

                @Override
                public final Class<Handle> getAnnotationType() {
                    return Handle.class;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Handle> annotation, Factory.AdviceType adviceType) {
                    void var2_2;
                    if (!target.getType().asErasure().isAssignableFrom(JavaType.METHOD_HANDLE.getTypeStub())) {
                        void var1_1;
                        throw new IllegalStateException("Cannot assign a MethodHandle to " + var1_1);
                    }
                    return new ForHandle(annotation.getValue(TYPE).resolve(EnumerationDescription.class).load(JavaConstant.MethodHandle.HandleType.class), annotation.getValue(OWNER).resolve(TypeDescription.class), annotation.getValue(NAME).resolve(String.class), annotation.getValue(RETURN_TYPE).resolve(TypeDescription.class), Arrays.asList((Object[])var2_2.getValue(PARAMETER_TYPES).resolve(TypeDescription[].class)));
                }

                /*
                 * WARNING - void declaration
                 */
                static {
                    void var0;
                    INSTANCE = new Factory();
                    $VALUES = new Factory[]{INSTANCE};
                    MethodList<MethodDescription.InDefinedShape> methods = TypeDescription.ForLoadedType.of(Handle.class).getDeclaredMethods();
                    TYPE = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("type"))).getOnly();
                    OWNER = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("owner"))).getOnly();
                    NAME = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("name"))).getOnly();
                    RETURN_TYPE = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("returnType"))).getOnly();
                    PARAMETER_TYPES = (MethodDescription.InDefinedShape)((MethodList)var0.filter(ElementMatchers.named("parameterTypes"))).getOnly();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ForSelfCallHandle implements OffsetMapping
        {
            BOUND{

                /*
                 * WARNING - void declaration
                 */
                protected final StackManipulation decorate(MethodDescription methodDescription, StackManipulation stackManipulation) {
                    void var3_3;
                    ArrayList<StackManipulation> stackManipulations = new ArrayList<StackManipulation>(1 + (methodDescription.isStatic() ? 0 : 2) + methodDescription.getParameters().size() * 3);
                    stackManipulations.add(stackManipulation);
                    if (!methodDescription.isStatic()) {
                        stackManipulations.add(MethodVariableAccess.loadThis());
                        stackManipulations.add(MethodInvocation.invoke(new MethodDescription.Latent(JavaType.METHOD_HANDLE.getTypeStub(), new MethodDescription.Token("bindTo", 1, JavaType.METHOD_HANDLE.getTypeStub().asGenericType(), new TypeList.Generic.Explicit(TypeDefinition.Sort.describe(Object.class))))));
                    }
                    if (!methodDescription.getParameters().isEmpty()) {
                        void var2_2;
                        Iterator iterator;
                        ArrayList<StackManipulation.Compound> values = new ArrayList<StackManipulation.Compound>(methodDescription.getParameters().size());
                        for (ParameterDescription parameterDescription : iterator.getParameters()) {
                            values.add((StackManipulation.Compound)(parameterDescription.getType().isPrimitive() ? new StackManipulation.Compound(MethodVariableAccess.load(parameterDescription), Assigner.DEFAULT.assign(parameterDescription.getType(), parameterDescription.getType().asErasure().asBoxed().asGenericType(), Assigner.Typing.STATIC)) : MethodVariableAccess.load(parameterDescription)));
                        }
                        stackManipulations.add(IntegerConstant.forValue(0));
                        stackManipulations.add(ArrayFactory.forType(TypeDescription.ForLoadedType.of(Object.class).asGenericType()).withValues((List<? extends StackManipulation>)var2_2));
                        stackManipulations.add(MethodInvocation.invoke(new MethodDescription.Latent(JavaType.METHOD_HANDLES.getTypeStub(), new MethodDescription.Token("insertArguments", 9, JavaType.METHOD_HANDLE.getTypeStub().asGenericType(), new TypeList.Generic.Explicit(JavaType.METHOD_HANDLE.getTypeStub(), TypeDefinition.Sort.describe(Integer.TYPE), TypeDefinition.Sort.describe(Object[].class))))));
                    }
                    return new StackManipulation.Compound((List<? extends StackManipulation>)var3_3);
                }
            }
            ,
            UNBOUND{

                protected final StackManipulation decorate(MethodDescription methodDescription, StackManipulation stackManipulation) {
                    return stackManipulation;
                }
            };


            /*
             * WARNING - void declaration
             */
            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                void var1_1;
                void var2_2;
                if (!instrumentedMethod.isMethod()) {
                    throw new IllegalStateException();
                }
                StackManipulation stackManipulation = (instrumentedMethod.isStatic() ? JavaConstant.MethodHandle.of((MethodDescription.InDefinedShape)instrumentedMethod.asDefined()) : JavaConstant.MethodHandle.ofSpecial((MethodDescription.InDefinedShape)instrumentedMethod.asDefined(), instrumentedType)).toStackManipulation();
                return new Target.ForStackManipulation(this.decorate((MethodDescription)var2_2, (StackManipulation)var1_1));
            }

            protected abstract StackManipulation decorate(MethodDescription var1, StackManipulation var2);

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static enum Factory implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<SelfCallHandle>
            {
                INSTANCE;

                private static final MethodDescription.InDefinedShape SELF_CALL_HANDLE_BOUND;

                @Override
                public final Class<SelfCallHandle> getAnnotationType() {
                    return SelfCallHandle.class;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<SelfCallHandle> annotation, Factory.AdviceType adviceType) {
                    void var2_2;
                    if (!target.getType().asErasure().isAssignableFrom(JavaType.METHOD_HANDLE.getTypeStub())) {
                        void var1_1;
                        throw new IllegalStateException("Cannot assign a MethodHandle to " + var1_1);
                    }
                    if (var2_2.getValue(SELF_CALL_HANDLE_BOUND).resolve(Boolean.class).booleanValue()) {
                        return BOUND;
                    }
                    return UNBOUND;
                }

                static {
                    SELF_CALL_HANDLE_BOUND = (MethodDescription.InDefinedShape)((MethodList)TypeDescription.ForLoadedType.of(SelfCallHandle.class).getDeclaredMethods().filter(ElementMatchers.named("bound"))).getOnly();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class ForOrigin
        implements OffsetMapping {
            private static final char DELIMITER = '#';
            private static final char ESCAPE = '\\';
            private final List<Renderer> renderers;

            /*
             * WARNING - void declaration
             */
            public ForOrigin(List<Renderer> renderers) {
                void var1_1;
                this.renderers = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public static OffsetMapping parse(String pattern) {
                void var1_1;
                void var2_2;
                String string;
                if (pattern.equals("")) {
                    return new ForOrigin(Collections.singletonList(Renderer.ForStringRepresentation.INSTANCE));
                }
                ArrayList<Renderer> renderers = new ArrayList<Renderer>(pattern.length());
                int from = 0;
                int to = pattern.indexOf(35);
                while (to != -1) {
                    if (to != 0 && pattern.charAt(to - 1) == '\\' && (to == 1 || pattern.charAt(to - 2) != '\\')) {
                        renderers.add(new Renderer.ForConstantValue(pattern.substring(from, Math.max(0, to - 1)) + '#'));
                        from = to + 1;
                    } else {
                        if (pattern.length() == to + 1) {
                            throw new IllegalStateException("Missing sort descriptor for " + pattern + " at index " + to);
                        }
                        renderers.add(new Renderer.ForConstantValue(pattern.substring(from, to).replace("\\\\", "\\")));
                        switch (pattern.charAt(to + 1)) {
                            case 'm': {
                                renderers.add(Renderer.ForMethodName.INSTANCE);
                                break;
                            }
                            case 't': {
                                renderers.add(Renderer.ForTypeName.INSTANCE);
                                break;
                            }
                            case 'd': {
                                renderers.add(Renderer.ForDescriptor.INSTANCE);
                                break;
                            }
                            case 'r': {
                                renderers.add(Renderer.ForReturnTypeName.INSTANCE);
                                break;
                            }
                            case 's': {
                                renderers.add(Renderer.ForJavaSignature.INSTANCE);
                                break;
                            }
                            case 'p': {
                                renderers.add(Renderer.ForPropertyName.INSTANCE);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Illegal sort descriptor " + pattern.charAt(to + 1) + " for " + pattern);
                            }
                        }
                        from = to + 2;
                    }
                    to = pattern.indexOf(35, from);
                }
                renderers.add(new Renderer.ForConstantValue(string.substring((int)var2_2)));
                return new ForOrigin((List<Renderer>)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                void var3_3;
                StringBuilder stringBuilder = new StringBuilder();
                for (Renderer renderer : this.renderers) {
                    stringBuilder.append(renderer.apply(instrumentedType, instrumentedMethod));
                }
                return Target.ForStackManipulation.of(var3_3.toString());
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return ((Object)this.renderers).equals(((ForOrigin)object).renderers);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + ((Object)this.renderers).hashCode();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static enum Factory implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<Origin>
            {
                INSTANCE;

                private static final MethodDescription.InDefinedShape ORIGIN_VALUE;

                @Override
                public final Class<Origin> getAnnotationType() {
                    return Origin.class;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Origin> annotation, Factory.AdviceType adviceType) {
                    void var1_1;
                    if (target.getType().asErasure().represents((java.lang.reflect.Type)((Object)Class.class))) {
                        return ForInstrumentedType.INSTANCE;
                    }
                    if (target.getType().asErasure().represents((java.lang.reflect.Type)((Object)Method.class))) {
                        return ForInstrumentedMethod.METHOD;
                    }
                    if (target.getType().asErasure().represents((java.lang.reflect.Type)((Object)Constructor.class))) {
                        return ForInstrumentedMethod.CONSTRUCTOR;
                    }
                    if (JavaType.EXECUTABLE.getTypeStub().equals(target.getType().asErasure())) {
                        return ForInstrumentedMethod.EXECUTABLE;
                    }
                    if (JavaType.METHOD_HANDLE.getTypeStub().equals(target.getType().asErasure())) {
                        return ForInstrumentedMethod.METHOD_HANDLE;
                    }
                    if (JavaType.METHOD_TYPE.getTypeStub().equals(target.getType().asErasure())) {
                        return ForInstrumentedMethod.METHOD_TYPE;
                    }
                    if (JavaType.METHOD_HANDLES_LOOKUP.getTypeStub().equals(target.getType().asErasure())) {
                        return new ForStackManipulation(MethodInvocation.lookup(), JavaType.METHOD_HANDLES_LOOKUP.getTypeStub().asGenericType(), target.getType(), Assigner.Typing.STATIC);
                    }
                    if (target.getType().asErasure().isAssignableFrom(String.class)) {
                        void var2_2;
                        return ForOrigin.parse(var2_2.getValue(ORIGIN_VALUE).resolve(String.class));
                    }
                    throw new IllegalStateException("Non-supported type " + var1_1.getType() + " for @Origin annotation");
                }

                static {
                    ORIGIN_VALUE = (MethodDescription.InDefinedShape)((MethodList)TypeDescription.ForLoadedType.of(Origin.class).getDeclaredMethods().filter(ElementMatchers.named("value"))).getOnly();
                }
            }

            public static interface Renderer {
                public String apply(TypeDescription var1, MethodDescription var2);

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static enum ForPropertyName implements Renderer
                {
                    INSTANCE;

                    public static final char SYMBOL = 'p';

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                        void var2_2;
                        return FieldAccessor.FieldNameExtractor.ForBeanProperty.INSTANCE.resolve((MethodDescription)var2_2);
                    }
                }

                @HashCodeAndEqualsPlugin.Enhance
                public static class ForConstantValue
                implements Renderer {
                    private final String value;

                    /*
                     * WARNING - void declaration
                     */
                    public ForConstantValue(String value) {
                        void var1_1;
                        this.value = var1_1;
                    }

                    public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                        return this.value;
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        return this.value.equals(((ForConstantValue)object).value);
                    }

                    public int hashCode() {
                        return this.getClass().hashCode() * 31 + this.value.hashCode();
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static enum ForStringRepresentation implements Renderer
                {
                    INSTANCE;


                    @Override
                    public final String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                        return instrumentedMethod.toString();
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static enum ForReturnTypeName implements Renderer
                {
                    INSTANCE;

                    public static final char SYMBOL = 'r';

                    @Override
                    public final String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                        return instrumentedMethod.getReturnType().asErasure().getName();
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static enum ForJavaSignature implements Renderer
                {
                    INSTANCE;

                    public static final char SYMBOL = 's';

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                        void var1_1;
                        Iterator iterator;
                        StringBuilder stringBuilder = new StringBuilder("(");
                        boolean comma = false;
                        for (TypeDescription typeDescription : iterator.getParameters().asTypeList().asErasures()) {
                            if (comma) {
                                stringBuilder.append(',');
                            } else {
                                comma = true;
                            }
                            stringBuilder.append(typeDescription.getName());
                        }
                        return var1_1.append(')').toString();
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static enum ForDescriptor implements Renderer
                {
                    INSTANCE;

                    public static final char SYMBOL = 'd';

                    @Override
                    public final String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                        return instrumentedMethod.getDescriptor();
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static enum ForTypeName implements Renderer
                {
                    INSTANCE;

                    public static final char SYMBOL = 't';

                    @Override
                    public final String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                        return instrumentedType.getName();
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static enum ForMethodName implements Renderer
                {
                    INSTANCE;

                    public static final char SYMBOL = 'm';

                    @Override
                    public final String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                        return instrumentedMethod.getInternalName();
                    }
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static abstract class ForFieldHandle
        implements OffsetMapping {
            private final Access access;

            /*
             * WARNING - void declaration
             */
            protected ForFieldHandle(Access access) {
                void var1_1;
                this.access = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                void var1_1;
                void var2_2;
                FieldDescription fieldDescription = this.resolve(instrumentedType, instrumentedMethod);
                if (!fieldDescription.isStatic() && instrumentedMethod.isStatic()) {
                    throw new IllegalStateException("Cannot access non-static field " + fieldDescription + " from static method " + instrumentedMethod);
                }
                if (sort.isPremature((MethodDescription)var2_2) && !fieldDescription.isStatic()) {
                    throw new IllegalStateException("Cannot access " + fieldDescription + " before super constructor call");
                }
                if (fieldDescription.isStatic()) {
                    return new Target.ForStackManipulation(this.access.resolve((FieldDescription.InDefinedShape)fieldDescription.asDefined()).toStackManipulation());
                }
                return new Target.ForStackManipulation(new StackManipulation.Compound(this.access.resolve((FieldDescription.InDefinedShape)var1_1.asDefined()).toStackManipulation(), MethodVariableAccess.REFERENCE.loadFrom(argumentHandler.argument(0)), MethodInvocation.invoke(new MethodDescription.Latent(JavaType.METHOD_HANDLE.getTypeStub(), new MethodDescription.Token("bindTo", 1, JavaType.METHOD_HANDLE.getTypeStub().asGenericType(), new TypeList.Generic.Explicit(TypeDefinition.Sort.describe(Object.class)))))));
            }

            protected abstract FieldDescription resolve(TypeDescription var1, MethodDescription var2);

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.access.equals((Object)((ForFieldHandle)object).access);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.access.hashCode();
            }

            @HashCodeAndEqualsPlugin.Enhance
            public static class Resolved
            extends ForFieldHandle {
                private final FieldDescription fieldDescription;

                /*
                 * WARNING - void declaration
                 */
                public Resolved(Access access, FieldDescription fieldDescription) {
                    super((Access)var1_1);
                    void var2_2;
                    void var1_1;
                    this.fieldDescription = var2_2;
                }

                /*
                 * WARNING - void declaration
                 */
                @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming declaring type for type member.")
                protected FieldDescription resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                    if (!this.fieldDescription.isStatic() && !this.fieldDescription.getDeclaringType().asErasure().isAssignableFrom(instrumentedType)) {
                        throw new IllegalStateException(this.fieldDescription + " is no member of " + instrumentedType);
                    }
                    if (!this.fieldDescription.isVisibleTo(instrumentedType)) {
                        void var1_1;
                        throw new IllegalStateException("Cannot access " + this.fieldDescription + " from " + var1_1);
                    }
                    return this.fieldDescription;
                }

                public boolean equals(@MaybeNull Object object) {
                    if (!super.equals(object)) {
                        return false;
                    }
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.fieldDescription.equals(((Resolved)object).fieldDescription);
                }

                public int hashCode() {
                    return super.hashCode() * 31 + this.fieldDescription.hashCode();
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                public static class Factory<T extends Annotation>
                implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<T> {
                    private final Class<T> annotationType;
                    private final FieldDescription fieldDescription;
                    private final Access access;

                    /*
                     * WARNING - void declaration
                     */
                    public Factory(Class<T> annotationType, FieldDescription fieldDescription, Access access) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.annotationType = var1_1;
                        this.fieldDescription = var2_2;
                        this.access = var3_3;
                    }

                    @Override
                    public Class<T> getAnnotationType() {
                        return this.annotationType;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, Factory.AdviceType adviceType) {
                        if (!target.getType().asErasure().isAssignableFrom(JavaType.METHOD_HANDLE.getTypeStub())) {
                            void var1_1;
                            throw new IllegalStateException("Cannot assign method handle to " + var1_1);
                        }
                        return new Resolved(this.access, this.fieldDescription);
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (!this.access.equals((Object)((Factory)object).access)) {
                            return false;
                        }
                        if (!this.annotationType.equals(((Factory)object).annotationType)) {
                            return false;
                        }
                        return this.fieldDescription.equals(((Factory)object).fieldDescription);
                    }

                    public int hashCode() {
                        return ((this.getClass().hashCode() * 31 + this.annotationType.hashCode()) * 31 + this.fieldDescription.hashCode()) * 31 + this.access.hashCode();
                    }
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            public static abstract class Unresolved
            extends ForFieldHandle {
                protected static final String BEAN_PROPERTY = "";
                private final String name;

                /*
                 * WARNING - void declaration
                 */
                public Unresolved(Access access, String name) {
                    super((Access)var1_1);
                    void var2_2;
                    void var1_1;
                    this.name = var2_2;
                }

                /*
                 * WARNING - void declaration
                 */
                protected FieldDescription resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                    void var2_2;
                    void var3_3;
                    FieldLocator locator = this.fieldLocator(instrumentedType);
                    FieldLocator.Resolution resolution = this.name.equals(BEAN_PROPERTY) ? FieldLocator.Resolution.Simple.ofBeanAccessor(locator, instrumentedMethod) : var3_3.locate(this.name);
                    if (!resolution.isResolved()) {
                        void var1_1;
                        throw new IllegalStateException("Cannot locate field named " + this.name + " for " + var1_1);
                    }
                    return var2_2.getField();
                }

                protected abstract FieldLocator fieldLocator(TypeDescription var1);

                public boolean equals(@MaybeNull Object object) {
                    if (!super.equals(object)) {
                        return false;
                    }
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.name.equals(((Unresolved)object).name);
                }

                public int hashCode() {
                    return super.hashCode() * 31 + this.name.hashCode();
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                protected static final class WriterFactory
                extends Enum<WriterFactory>
                implements Factory<FieldSetterHandle> {
                    public static final /* enum */ WriterFactory INSTANCE;
                    private static final MethodDescription.InDefinedShape FIELD_SETTER_HANDLE_VALUE;
                    private static final MethodDescription.InDefinedShape FIELD_SETTER_HANDLE_DECLARING_TYPE;
                    private static final /* synthetic */ WriterFactory[] $VALUES;

                    public static WriterFactory[] values() {
                        return (WriterFactory[])$VALUES.clone();
                    }

                    public static WriterFactory valueOf(String name) {
                        String string;
                        return Enum.valueOf(WriterFactory.class, string);
                    }

                    @Override
                    public final Class<FieldSetterHandle> getAnnotationType() {
                        return FieldSetterHandle.class;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<FieldSetterHandle> annotation, Factory.AdviceType adviceType) {
                        void var1_1;
                        void var2_2;
                        if (!target.getType().asErasure().isAssignableFrom(JavaType.METHOD_HANDLE.getTypeStub())) {
                            throw new IllegalStateException("Cannot assign method handle to " + target);
                        }
                        TypeDescription declaringType = annotation.getValue(FIELD_SETTER_HANDLE_DECLARING_TYPE).resolve(TypeDescription.class);
                        if (declaringType.represents(Void.TYPE)) {
                            return new WithImplicitType(Access.SETTER, annotation.getValue(FIELD_SETTER_HANDLE_VALUE).resolve(String.class));
                        }
                        return new WithExplicitType(Access.SETTER, var2_2.getValue(FIELD_SETTER_HANDLE_VALUE).resolve(String.class), (TypeDescription)var1_1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    static {
                        void var0;
                        INSTANCE = new WriterFactory();
                        $VALUES = new WriterFactory[]{INSTANCE};
                        MethodList<MethodDescription.InDefinedShape> methods = TypeDescription.ForLoadedType.of(FieldSetterHandle.class).getDeclaredMethods();
                        FIELD_SETTER_HANDLE_VALUE = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("value"))).getOnly();
                        FIELD_SETTER_HANDLE_DECLARING_TYPE = (MethodDescription.InDefinedShape)((MethodList)var0.filter(ElementMatchers.named("declaringType"))).getOnly();
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                protected static final class ReaderFactory
                extends Enum<ReaderFactory>
                implements Factory<FieldGetterHandle> {
                    public static final /* enum */ ReaderFactory INSTANCE;
                    private static final MethodDescription.InDefinedShape FIELD_GETTER_HANDLE_VALUE;
                    private static final MethodDescription.InDefinedShape FIELD_GETTER_HANDLE_DECLARING_TYPE;
                    private static final /* synthetic */ ReaderFactory[] $VALUES;

                    public static ReaderFactory[] values() {
                        return (ReaderFactory[])$VALUES.clone();
                    }

                    public static ReaderFactory valueOf(String name) {
                        String string;
                        return Enum.valueOf(ReaderFactory.class, string);
                    }

                    @Override
                    public final Class<FieldGetterHandle> getAnnotationType() {
                        return FieldGetterHandle.class;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<FieldGetterHandle> annotation, Factory.AdviceType adviceType) {
                        void var1_1;
                        void var2_2;
                        if (!target.getType().asErasure().isAssignableFrom(JavaType.METHOD_HANDLE.getTypeStub())) {
                            throw new IllegalStateException("Cannot assign method handle to " + target);
                        }
                        TypeDescription declaringType = annotation.getValue(FIELD_GETTER_HANDLE_DECLARING_TYPE).resolve(TypeDescription.class);
                        if (declaringType.represents(Void.TYPE)) {
                            return new WithImplicitType(Access.GETTER, annotation.getValue(FIELD_GETTER_HANDLE_VALUE).resolve(String.class));
                        }
                        return new WithExplicitType(Access.GETTER, var2_2.getValue(FIELD_GETTER_HANDLE_VALUE).resolve(String.class), (TypeDescription)var1_1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    static {
                        void var0;
                        INSTANCE = new ReaderFactory();
                        $VALUES = new ReaderFactory[]{INSTANCE};
                        MethodList<MethodDescription.InDefinedShape> methods = TypeDescription.ForLoadedType.of(FieldGetterHandle.class).getDeclaredMethods();
                        FIELD_GETTER_HANDLE_VALUE = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("value"))).getOnly();
                        FIELD_GETTER_HANDLE_DECLARING_TYPE = (MethodDescription.InDefinedShape)((MethodList)var0.filter(ElementMatchers.named("declaringType"))).getOnly();
                    }
                }

                @HashCodeAndEqualsPlugin.Enhance
                public static class WithExplicitType
                extends Unresolved {
                    private final TypeDescription declaringType;

                    /*
                     * WARNING - void declaration
                     */
                    public WithExplicitType(Access access, String name, TypeDescription declaringType) {
                        super((Access)var1_1, (String)var2_2);
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.declaringType = var3_3;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected FieldLocator fieldLocator(TypeDescription instrumentedType) {
                        void var1_1;
                        if (!this.declaringType.represents((java.lang.reflect.Type)((Object)TargetType.class)) && !instrumentedType.isAssignableTo(this.declaringType)) {
                            throw new IllegalStateException(this.declaringType + " is no super type of " + instrumentedType);
                        }
                        return new FieldLocator.ForExactType(TargetType.resolve(this.declaringType, (TypeDescription)var1_1));
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (!super.equals(object)) {
                            return false;
                        }
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        return this.declaringType.equals(((WithExplicitType)object).declaringType);
                    }

                    public int hashCode() {
                        return super.hashCode() * 31 + this.declaringType.hashCode();
                    }
                }

                public static class WithImplicitType
                extends Unresolved {
                    /*
                     * WARNING - void declaration
                     */
                    public WithImplicitType(Access access, String name) {
                        super((Access)var1_1, (String)var2_2);
                        void var2_2;
                        void var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected FieldLocator fieldLocator(TypeDescription instrumentedType) {
                        void var1_1;
                        return new FieldLocator.ForClassHierarchy((TypeDescription)var1_1);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Access {
                GETTER{

                    protected final JavaConstant.MethodHandle resolve(FieldDescription.InDefinedShape fieldDescription) {
                        return JavaConstant.MethodHandle.ofGetter(fieldDescription);
                    }
                }
                ,
                SETTER{

                    protected final JavaConstant.MethodHandle resolve(FieldDescription.InDefinedShape fieldDescription) {
                        return JavaConstant.MethodHandle.ofSetter(fieldDescription);
                    }
                };


                protected abstract JavaConstant.MethodHandle resolve(FieldDescription.InDefinedShape var1);
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static abstract class ForField
        implements OffsetMapping {
            private static final MethodDescription.InDefinedShape FIELD_VALUE;
            private static final MethodDescription.InDefinedShape FIELD_DECLARING_TYPE;
            private static final MethodDescription.InDefinedShape FIELD_READ_ONLY;
            private static final MethodDescription.InDefinedShape FIELD_TYPING;
            private final TypeDescription.Generic target;
            private final boolean readOnly;
            private final Assigner.Typing typing;

            /*
             * WARNING - void declaration
             */
            protected ForField(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.target = var1_1;
                this.readOnly = var2_2;
                this.typing = var3_3;
            }

            /*
             * WARNING - void declaration
             */
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                void var3_3;
                void var2_2;
                void var1_1;
                FieldDescription fieldDescription = this.resolve(instrumentedType, instrumentedMethod);
                if (!fieldDescription.isStatic() && instrumentedMethod.isStatic()) {
                    throw new IllegalStateException("Cannot access non-static field " + fieldDescription + " from static method " + instrumentedMethod);
                }
                if (sort.isPremature(instrumentedMethod) && !fieldDescription.isStatic()) {
                    if (this.readOnly) {
                        throw new IllegalStateException("Cannot read " + fieldDescription + " before super constructor call");
                    }
                    StackManipulation writeAssignment = assigner.assign(this.target, fieldDescription.getType(), this.typing);
                    if (!writeAssignment.isValid()) {
                        throw new IllegalStateException("Cannot assign " + this.target + " to " + fieldDescription);
                    }
                    return new Target.ForField.WriteOnly((FieldDescription)fieldDescription.asDefined(), writeAssignment);
                }
                StackManipulation readAssignment = assigner.assign(fieldDescription.getType(), this.target, this.typing);
                if (!readAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + fieldDescription + " to " + this.target);
                }
                if (this.readOnly) {
                    return new Target.ForField.ReadOnly(fieldDescription, readAssignment);
                }
                StackManipulation writeAssignment = assigner.assign(this.target, fieldDescription.getType(), this.typing);
                if (!writeAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.target + " to " + fieldDescription);
                }
                return new Target.ForField.ReadWrite((FieldDescription)var1_1.asDefined(), (StackManipulation)var2_2, (StackManipulation)var3_3);
            }

            protected abstract FieldDescription resolve(TypeDescription var1, MethodDescription var2);

            /*
             * WARNING - void declaration
             */
            static {
                void var0;
                MethodList<MethodDescription.InDefinedShape> methods = TypeDescription.ForLoadedType.of(FieldValue.class).getDeclaredMethods();
                FIELD_VALUE = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("value"))).getOnly();
                FIELD_DECLARING_TYPE = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("declaringType"))).getOnly();
                FIELD_READ_ONLY = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("readOnly"))).getOnly();
                FIELD_TYPING = (MethodDescription.InDefinedShape)((MethodList)var0.filter(ElementMatchers.named("typing"))).getOnly();
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (this.readOnly != ((ForField)object).readOnly) {
                    return false;
                }
                if (!this.typing.equals((Object)((ForField)object).typing)) {
                    return false;
                }
                return this.target.equals(((ForField)object).target);
            }

            public int hashCode() {
                return ((this.getClass().hashCode() * 31 + this.target.hashCode()) * 31 + this.readOnly) * 31 + this.typing.hashCode();
            }

            @HashCodeAndEqualsPlugin.Enhance
            public static class Resolved
            extends ForField {
                private final FieldDescription fieldDescription;

                /*
                 * WARNING - void declaration
                 */
                public Resolved(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, FieldDescription fieldDescription) {
                    super((TypeDescription.Generic)var1_1, (boolean)var2_2, (Assigner.Typing)var3_3);
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.fieldDescription = fieldDescription;
                }

                /*
                 * WARNING - void declaration
                 */
                @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming declaring type for type member.")
                protected FieldDescription resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                    if (!this.fieldDescription.isStatic() && !this.fieldDescription.getDeclaringType().asErasure().isAssignableFrom(instrumentedType)) {
                        throw new IllegalStateException(this.fieldDescription + " is no member of " + instrumentedType);
                    }
                    if (!this.fieldDescription.isVisibleTo(instrumentedType)) {
                        void var1_1;
                        throw new IllegalStateException("Cannot access " + this.fieldDescription + " from " + var1_1);
                    }
                    return this.fieldDescription;
                }

                public boolean equals(@MaybeNull Object object) {
                    if (!super.equals(object)) {
                        return false;
                    }
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.fieldDescription.equals(((Resolved)object).fieldDescription);
                }

                public int hashCode() {
                    return super.hashCode() * 31 + this.fieldDescription.hashCode();
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                public static class Factory<T extends Annotation>
                implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<T> {
                    private final Class<T> annotationType;
                    private final FieldDescription fieldDescription;
                    private final boolean readOnly;
                    private final Assigner.Typing typing;

                    /*
                     * WARNING - void declaration
                     */
                    public Factory(Class<T> annotationType, FieldDescription fieldDescription) {
                        this((Class<T>)var1_1, (FieldDescription)var2_2, true, Assigner.Typing.STATIC);
                        void var2_2;
                        void var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public Factory(Class<T> annotationType, FieldDescription fieldDescription, boolean readOnly, Assigner.Typing typing) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.annotationType = var1_1;
                        this.fieldDescription = var2_2;
                        this.readOnly = var3_3;
                        this.typing = typing;
                    }

                    @Override
                    public Class<T> getAnnotationType() {
                        return this.annotationType;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, Factory.AdviceType adviceType) {
                        void var1_1;
                        return new Resolved(var1_1.getType(), this.readOnly, this.typing, this.fieldDescription);
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (this.readOnly != ((Factory)object).readOnly) {
                            return false;
                        }
                        if (!this.typing.equals((Object)((Factory)object).typing)) {
                            return false;
                        }
                        if (!this.annotationType.equals(((Factory)object).annotationType)) {
                            return false;
                        }
                        return this.fieldDescription.equals(((Factory)object).fieldDescription);
                    }

                    public int hashCode() {
                        return (((this.getClass().hashCode() * 31 + this.annotationType.hashCode()) * 31 + this.fieldDescription.hashCode()) * 31 + this.readOnly) * 31 + this.typing.hashCode();
                    }
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            public static abstract class Unresolved
            extends ForField {
                protected static final String BEAN_PROPERTY = "";
                private final String name;

                /*
                 * WARNING - void declaration
                 */
                protected Unresolved(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, String name) {
                    super((TypeDescription.Generic)var1_1, (boolean)var2_2, (Assigner.Typing)var3_3);
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.name = name;
                }

                /*
                 * WARNING - void declaration
                 */
                protected FieldDescription resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                    void var2_2;
                    void var3_3;
                    FieldLocator locator = this.fieldLocator(instrumentedType);
                    FieldLocator.Resolution resolution = this.name.equals(BEAN_PROPERTY) ? FieldLocator.Resolution.Simple.ofBeanAccessor(locator, instrumentedMethod) : var3_3.locate(this.name);
                    if (!resolution.isResolved()) {
                        void var1_1;
                        throw new IllegalStateException("Cannot locate field named " + this.name + " for " + var1_1);
                    }
                    return var2_2.getField();
                }

                protected abstract FieldLocator fieldLocator(TypeDescription var1);

                public boolean equals(@MaybeNull Object object) {
                    if (!super.equals(object)) {
                        return false;
                    }
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.name.equals(((Unresolved)object).name);
                }

                public int hashCode() {
                    return super.hashCode() * 31 + this.name.hashCode();
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                protected static enum Factory implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<FieldValue>
                {
                    INSTANCE;


                    @Override
                    public final Class<FieldValue> getAnnotationType() {
                        return FieldValue.class;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<FieldValue> annotation, Factory.AdviceType adviceType) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        if (adviceType.isDelegation() && !annotation.getValue(FIELD_READ_ONLY).resolve(Boolean.class).booleanValue()) {
                            throw new IllegalStateException("Cannot write to field for " + target + " in read-only context");
                        }
                        TypeDescription declaringType = annotation.getValue(FIELD_DECLARING_TYPE).resolve(TypeDescription.class);
                        if (declaringType.represents(Void.TYPE)) {
                            return new WithImplicitType(target.getType(), annotation);
                        }
                        return new WithExplicitType(var1_1.getType(), (AnnotationDescription.Loadable<FieldValue>)var2_2, (TypeDescription)var3_3);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                public static class WithExplicitType
                extends Unresolved {
                    private final TypeDescription declaringType;

                    /*
                     * WARNING - void declaration
                     */
                    protected WithExplicitType(TypeDescription.Generic target, AnnotationDescription.Loadable<FieldValue> annotation, TypeDescription declaringType) {
                        this((TypeDescription.Generic)var1_1, annotation.getValue(FIELD_READ_ONLY).resolve(Boolean.class), annotation.getValue(FIELD_TYPING).resolve(EnumerationDescription.class).load(Assigner.Typing.class), var2_2.getValue(FIELD_VALUE).resolve(String.class), (TypeDescription)var3_3);
                        void var3_3;
                        void var2_2;
                        void var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public WithExplicitType(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, String name, TypeDescription declaringType) {
                        super((TypeDescription.Generic)var1_1, (boolean)var2_2, (Assigner.Typing)var3_3, name);
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.declaringType = declaringType;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    protected FieldLocator fieldLocator(TypeDescription instrumentedType) {
                        void var1_1;
                        if (!this.declaringType.represents((java.lang.reflect.Type)((Object)TargetType.class)) && !instrumentedType.isAssignableTo(this.declaringType)) {
                            throw new IllegalStateException(this.declaringType + " is no super type of " + instrumentedType);
                        }
                        return new FieldLocator.ForExactType(TargetType.resolve(this.declaringType, (TypeDescription)var1_1));
                    }

                    @Override
                    public boolean equals(@MaybeNull Object object) {
                        if (!super.equals(object)) {
                            return false;
                        }
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        return this.declaringType.equals(((WithExplicitType)object).declaringType);
                    }

                    @Override
                    public int hashCode() {
                        return super.hashCode() * 31 + this.declaringType.hashCode();
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static class WithImplicitType
                extends Unresolved {
                    /*
                     * WARNING - void declaration
                     */
                    protected WithImplicitType(TypeDescription.Generic target, AnnotationDescription.Loadable<FieldValue> annotation) {
                        this((TypeDescription.Generic)var1_1, annotation.getValue(FIELD_READ_ONLY).resolve(Boolean.class), annotation.getValue(FIELD_TYPING).resolve(EnumerationDescription.class).load(Assigner.Typing.class), var2_2.getValue(FIELD_VALUE).resolve(String.class));
                        void var2_2;
                        void var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public WithImplicitType(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, String name) {
                        super((TypeDescription.Generic)var1_1, (boolean)var2_2, (Assigner.Typing)var3_3, name);
                        void var3_3;
                        void var2_2;
                        void var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    protected FieldLocator fieldLocator(TypeDescription instrumentedType) {
                        void var1_1;
                        return new FieldLocator.ForClassHierarchy((TypeDescription)var1_1);
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ForInstrumentedMethod implements OffsetMapping
        {
            METHOD{

                protected final boolean isRepresentable(MethodDescription instrumentedMethod) {
                    return instrumentedMethod.isMethod();
                }

                protected final Target resolve(MethodDescription.InDefinedShape methodDescription) {
                    return Target.ForStackManipulation.of(methodDescription);
                }
            }
            ,
            CONSTRUCTOR{

                protected final boolean isRepresentable(MethodDescription instrumentedMethod) {
                    return instrumentedMethod.isConstructor();
                }

                protected final Target resolve(MethodDescription.InDefinedShape methodDescription) {
                    return Target.ForStackManipulation.of(methodDescription);
                }
            }
            ,
            EXECUTABLE{

                protected final boolean isRepresentable(MethodDescription instrumentedMethod) {
                    return true;
                }

                protected final Target resolve(MethodDescription.InDefinedShape methodDescription) {
                    return Target.ForStackManipulation.of(methodDescription);
                }
            }
            ,
            METHOD_HANDLE{

                protected final boolean isRepresentable(MethodDescription instrumentedMethod) {
                    return true;
                }

                /*
                 * WARNING - void declaration
                 */
                protected final Target resolve(MethodDescription.InDefinedShape methodDescription) {
                    void var1_1;
                    return new Target.ForStackManipulation(JavaConstant.MethodHandle.of((MethodDescription.InDefinedShape)var1_1).toStackManipulation());
                }
            }
            ,
            METHOD_TYPE{

                protected final boolean isRepresentable(MethodDescription instrumentedMethod) {
                    return true;
                }

                /*
                 * WARNING - void declaration
                 */
                protected final Target resolve(MethodDescription.InDefinedShape methodDescription) {
                    void var1_1;
                    return new Target.ForStackManipulation(JavaConstant.MethodType.of((MethodDescription)var1_1).toStackManipulation());
                }
            };


            /*
             * WARNING - void declaration
             */
            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                void var2_2;
                if (!this.isRepresentable(instrumentedMethod)) {
                    throw new IllegalStateException("Cannot represent " + instrumentedMethod + " as the specified constant");
                }
                return this.resolve((MethodDescription.InDefinedShape)var2_2.asDefined());
            }

            protected abstract boolean isRepresentable(MethodDescription var1);

            protected abstract Target resolve(MethodDescription.InDefinedShape var1);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ForInstrumentedType implements OffsetMapping
        {
            INSTANCE;


            @Override
            public final Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                return Target.ForStackManipulation.of(instrumentedType);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class ForAllArguments
        implements OffsetMapping {
            private final TypeDescription.Generic target;
            private final boolean readOnly;
            private final Assigner.Typing typing;
            private final boolean includeSelf;
            private final boolean nullIfEmpty;

            /*
             * WARNING - void declaration
             */
            protected ForAllArguments(TypeDescription.Generic target, AnnotationDescription.Loadable<AllArguments> annotation) {
                this((TypeDescription.Generic)var1_1, annotation.getValue(Factory.ALL_ARGUMENTS_READ_ONLY).resolve(Boolean.class), annotation.getValue(Factory.ALL_ARGUMENTS_TYPING).resolve(EnumerationDescription.class).load(Assigner.Typing.class), annotation.getValue(Factory.ALL_ARGUMENTS_INCLUDE_SELF).resolve(Boolean.class), var2_2.getValue(Factory.ALL_ARGUMENTS_NULL_IF_EMPTY).resolve(Boolean.class));
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public ForAllArguments(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, boolean includeSelf, boolean nullIfEmpty) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.target = var1_1;
                this.readOnly = var2_2;
                this.typing = var3_3;
                this.includeSelf = includeSelf;
                this.nullIfEmpty = nullIfEmpty;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                void var1_1;
                if (this.nullIfEmpty && instrumentedMethod.getParameters().isEmpty() && (!this.includeSelf || instrumentedMethod.isStatic())) {
                    if (this.readOnly) {
                        return new Target.ForStackManipulation(NullConstant.INSTANCE);
                    }
                    return new Target.ForStackManipulation.Writable(NullConstant.INSTANCE, Removal.SINGLE);
                }
                ArrayList<StackManipulation.Compound> reads = new ArrayList<StackManipulation.Compound>((this.includeSelf && !instrumentedMethod.isStatic() ? 1 : 0) + instrumentedMethod.getParameters().size());
                if (this.includeSelf && !instrumentedMethod.isStatic()) {
                    if (sort.isPremature(instrumentedMethod) && instrumentedMethod.isConstructor()) {
                        throw new IllegalStateException("Cannot include self in all arguments array from " + instrumentedMethod);
                    }
                    StackManipulation assignment = assigner.assign(instrumentedMethod.getDeclaringType().asGenericType(), this.target, this.typing);
                    if (!assignment.isValid()) {
                        throw new IllegalStateException("Cannot assign " + instrumentedMethod.getDeclaringType() + " to " + this.target);
                    }
                    reads.add(new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadFrom(argumentHandler.argument(0)), assignment));
                }
                for (ParameterDescription parameterDescription : instrumentedMethod.getParameters()) {
                    StackManipulation assignment = assigner.assign(parameterDescription.getType(), this.target, this.typing);
                    if (!assignment.isValid()) {
                        throw new IllegalStateException("Cannot assign " + parameterDescription + " to " + this.target);
                    }
                    reads.add(new StackManipulation.Compound(MethodVariableAccess.of(parameterDescription.getType()).loadFrom(argumentHandler.argument(parameterDescription.getOffset())), assignment));
                }
                if (this.readOnly) {
                    return new Target.ForArray.ReadOnly(this.target, reads);
                }
                ArrayList<StackManipulation.Compound> writes = new ArrayList<StackManipulation.Compound>(2 * ((this.includeSelf && !instrumentedMethod.isStatic() ? 1 : 0) + instrumentedMethod.getParameters().size()));
                if (this.includeSelf && !instrumentedMethod.isStatic()) {
                    StackManipulation assignment = assigner.assign(this.target, instrumentedMethod.getDeclaringType().asGenericType(), this.typing);
                    if (!assignment.isValid()) {
                        throw new IllegalStateException("Cannot assign " + this.target + " to " + instrumentedMethod.getDeclaringType());
                    }
                    writes.add(new StackManipulation.Compound(assignment, MethodVariableAccess.REFERENCE.storeAt(argumentHandler.argument(0))));
                }
                for (ParameterDescription parameterDescription : instrumentedMethod.getParameters()) {
                    void var2_2;
                    StackManipulation assignment = assigner.assign(this.target, parameterDescription.getType(), this.typing);
                    if (!assignment.isValid()) {
                        throw new IllegalStateException("Cannot assign " + this.target + " to " + parameterDescription);
                    }
                    writes.add(new StackManipulation.Compound(new StackManipulation[]{var2_2, MethodVariableAccess.of(parameterDescription.getType()).storeAt(argumentHandler.argument(parameterDescription.getOffset()))}));
                }
                return new Target.ForArray.ReadWrite(this.target, (List<? extends StackManipulation>)var1_1, writes);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (this.readOnly != ((ForAllArguments)object).readOnly) {
                    return false;
                }
                if (this.includeSelf != ((ForAllArguments)object).includeSelf) {
                    return false;
                }
                if (this.nullIfEmpty != ((ForAllArguments)object).nullIfEmpty) {
                    return false;
                }
                if (!this.typing.equals((Object)((ForAllArguments)object).typing)) {
                    return false;
                }
                return this.target.equals(((ForAllArguments)object).target);
            }

            public int hashCode() {
                return ((((this.getClass().hashCode() * 31 + this.target.hashCode()) * 31 + this.readOnly) * 31 + this.typing.hashCode()) * 31 + this.includeSelf) * 31 + this.nullIfEmpty;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static final class Factory
            extends Enum<Factory>
            implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<AllArguments> {
                public static final /* enum */ Factory INSTANCE;
                private static final MethodDescription.InDefinedShape ALL_ARGUMENTS_READ_ONLY;
                private static final MethodDescription.InDefinedShape ALL_ARGUMENTS_TYPING;
                private static final MethodDescription.InDefinedShape ALL_ARGUMENTS_INCLUDE_SELF;
                private static final MethodDescription.InDefinedShape ALL_ARGUMENTS_NULL_IF_EMPTY;
                private static final /* synthetic */ Factory[] $VALUES;

                public static Factory[] values() {
                    return (Factory[])$VALUES.clone();
                }

                public static Factory valueOf(String name) {
                    String string;
                    return Enum.valueOf(Factory.class, string);
                }

                @Override
                public final Class<AllArguments> getAnnotationType() {
                    return AllArguments.class;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Assuming component type for array type.")
                public final OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<AllArguments> annotation, Factory.AdviceType adviceType) {
                    void var2_2;
                    void var1_1;
                    void var3_3;
                    if (!target.getType().represents((java.lang.reflect.Type)((Object)Object.class)) && !target.getType().isArray()) {
                        throw new IllegalStateException("Cannot use AllArguments annotation on a non-array type");
                    }
                    if (var3_3.isDelegation() && !annotation.getValue(ALL_ARGUMENTS_READ_ONLY).resolve(Boolean.class).booleanValue()) {
                        throw new IllegalStateException("Cannot define writable field access for " + target);
                    }
                    return new ForAllArguments(target.getType().represents((java.lang.reflect.Type)((Object)Object.class)) ? TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(Object.class) : var1_1.getType().getComponentType(), (AnnotationDescription.Loadable<AllArguments>)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                static {
                    void var0;
                    INSTANCE = new Factory();
                    $VALUES = new Factory[]{INSTANCE};
                    MethodList<MethodDescription.InDefinedShape> methods = TypeDescription.ForLoadedType.of(AllArguments.class).getDeclaredMethods();
                    ALL_ARGUMENTS_READ_ONLY = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("readOnly"))).getOnly();
                    ALL_ARGUMENTS_TYPING = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("typing"))).getOnly();
                    ALL_ARGUMENTS_INCLUDE_SELF = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("includeSelf"))).getOnly();
                    ALL_ARGUMENTS_NULL_IF_EMPTY = (MethodDescription.InDefinedShape)((MethodList)var0.filter(ElementMatchers.named("nullIfEmpty"))).getOnly();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class ForThisReference
        implements OffsetMapping {
            private final TypeDescription.Generic target;
            private final boolean readOnly;
            private final Assigner.Typing typing;
            private final boolean optional;

            /*
             * WARNING - void declaration
             */
            protected ForThisReference(TypeDescription.Generic target, AnnotationDescription.Loadable<This> annotation) {
                this((TypeDescription.Generic)var1_1, annotation.getValue(Factory.THIS_READ_ONLY).resolve(Boolean.class), annotation.getValue(Factory.THIS_TYPING).resolve(EnumerationDescription.class).load(Assigner.Typing.class), var2_2.getValue(Factory.THIS_OPTIONAL).resolve(Boolean.class));
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public ForThisReference(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, boolean optional) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.target = var1_1;
                this.readOnly = var2_2;
                this.typing = var3_3;
                this.optional = optional;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                void var3_3;
                void var2_2;
                void var1_1;
                if (instrumentedMethod.isStatic() || sort.isPremature(instrumentedMethod)) {
                    if (this.optional) {
                        if (this.readOnly) {
                            return new Target.ForDefaultValue.ReadOnly(instrumentedType);
                        }
                        return new Target.ForDefaultValue.ReadWrite(instrumentedType);
                    }
                    throw new IllegalStateException("Cannot map this reference for static method or constructor start: " + instrumentedMethod);
                }
                StackManipulation readAssignment = assigner.assign(instrumentedType.asGenericType(), this.target, this.typing);
                if (!readAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + instrumentedType + " to " + this.target);
                }
                if (this.readOnly) {
                    return new Target.ForVariable.ReadOnly(instrumentedType.asGenericType(), argumentHandler.argument(0), readAssignment);
                }
                StackManipulation writeAssignment = assigner.assign(this.target, instrumentedType.asGenericType(), this.typing);
                if (!writeAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.target + " to " + instrumentedType);
                }
                return new Target.ForVariable.ReadWrite(var1_1.asGenericType(), argumentHandler.argument(0), (StackManipulation)var2_2, (StackManipulation)var3_3);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (this.readOnly != ((ForThisReference)object).readOnly) {
                    return false;
                }
                if (this.optional != ((ForThisReference)object).optional) {
                    return false;
                }
                if (!this.typing.equals((Object)((ForThisReference)object).typing)) {
                    return false;
                }
                return this.target.equals(((ForThisReference)object).target);
            }

            public int hashCode() {
                return (((this.getClass().hashCode() * 31 + this.target.hashCode()) * 31 + this.readOnly) * 31 + this.typing.hashCode()) * 31 + this.optional;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static final class Factory
            extends Enum<Factory>
            implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<This> {
                public static final /* enum */ Factory INSTANCE;
                private static final MethodDescription.InDefinedShape THIS_READ_ONLY;
                private static final MethodDescription.InDefinedShape THIS_TYPING;
                private static final MethodDescription.InDefinedShape THIS_OPTIONAL;
                private static final /* synthetic */ Factory[] $VALUES;

                public static Factory[] values() {
                    return (Factory[])$VALUES.clone();
                }

                public static Factory valueOf(String name) {
                    String string;
                    return Enum.valueOf(Factory.class, string);
                }

                @Override
                public final Class<This> getAnnotationType() {
                    return This.class;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<This> annotation, Factory.AdviceType adviceType) {
                    void var2_2;
                    void var1_1;
                    if (adviceType.isDelegation() && !annotation.getValue(THIS_READ_ONLY).resolve(Boolean.class).booleanValue()) {
                        throw new IllegalStateException("Cannot write to this reference for " + target + " in read-only context");
                    }
                    return new ForThisReference(var1_1.getType(), (AnnotationDescription.Loadable<This>)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                static {
                    void var0;
                    INSTANCE = new Factory();
                    $VALUES = new Factory[]{INSTANCE};
                    MethodList<MethodDescription.InDefinedShape> methods = TypeDescription.ForLoadedType.of(This.class).getDeclaredMethods();
                    THIS_READ_ONLY = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("readOnly"))).getOnly();
                    THIS_TYPING = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("typing"))).getOnly();
                    THIS_OPTIONAL = (MethodDescription.InDefinedShape)((MethodList)var0.filter(ElementMatchers.named("optional"))).getOnly();
                }
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static abstract class ForArgument
        implements OffsetMapping {
            protected final TypeDescription.Generic target;
            protected final boolean readOnly;
            private final Assigner.Typing typing;

            /*
             * WARNING - void declaration
             */
            protected ForArgument(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.target = var1_1;
                this.readOnly = var2_2;
                this.typing = var3_3;
            }

            /*
             * WARNING - void declaration
             */
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                void var3_3;
                void var2_2;
                void var1_1;
                ParameterDescription parameterDescription = this.resolve(instrumentedMethod);
                StackManipulation readAssignment = assigner.assign(parameterDescription.getType(), this.target, this.typing);
                if (!readAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + parameterDescription + " to " + this.target);
                }
                if (this.readOnly) {
                    return new Target.ForVariable.ReadOnly(parameterDescription.getType(), argumentHandler.argument(parameterDescription.getOffset()), readAssignment);
                }
                StackManipulation writeAssignment = assigner.assign(this.target, parameterDescription.getType(), this.typing);
                if (!writeAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + parameterDescription + " to " + this.target);
                }
                return new Target.ForVariable.ReadWrite(parameterDescription.getType(), argumentHandler.argument(var1_1.getOffset()), (StackManipulation)var2_2, (StackManipulation)var3_3);
            }

            protected abstract ParameterDescription resolve(MethodDescription var1);

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (this.readOnly != ((ForArgument)object).readOnly) {
                    return false;
                }
                if (!this.typing.equals((Object)((ForArgument)object).typing)) {
                    return false;
                }
                return this.target.equals(((ForArgument)object).target);
            }

            public int hashCode() {
                return ((this.getClass().hashCode() * 31 + this.target.hashCode()) * 31 + this.readOnly) * 31 + this.typing.hashCode();
            }

            @HashCodeAndEqualsPlugin.Enhance
            public static class Resolved
            extends ForArgument {
                private final ParameterDescription parameterDescription;

                /*
                 * WARNING - void declaration
                 */
                public Resolved(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, ParameterDescription parameterDescription) {
                    super((TypeDescription.Generic)var1_1, (boolean)var2_2, (Assigner.Typing)var3_3);
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.parameterDescription = parameterDescription;
                }

                /*
                 * WARNING - void declaration
                 */
                protected ParameterDescription resolve(MethodDescription instrumentedMethod) {
                    if (!this.parameterDescription.getDeclaringMethod().equals(instrumentedMethod)) {
                        void var1_1;
                        throw new IllegalStateException(this.parameterDescription + " is not a parameter of " + var1_1);
                    }
                    return this.parameterDescription;
                }

                public boolean equals(@MaybeNull Object object) {
                    if (!super.equals(object)) {
                        return false;
                    }
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.parameterDescription.equals(((Resolved)object).parameterDescription);
                }

                public int hashCode() {
                    return super.hashCode() * 31 + this.parameterDescription.hashCode();
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                public static class Factory<T extends Annotation>
                implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<T> {
                    private final Class<T> annotationType;
                    private final ParameterDescription parameterDescription;
                    private final boolean readOnly;
                    private final Assigner.Typing typing;

                    /*
                     * WARNING - void declaration
                     */
                    public Factory(Class<T> annotationType, ParameterDescription parameterDescription) {
                        this((Class<T>)var1_1, (ParameterDescription)var2_2, true, Assigner.Typing.STATIC);
                        void var2_2;
                        void var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public Factory(Class<T> annotationType, ParameterDescription parameterDescription, boolean readOnly, Assigner.Typing typing) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.annotationType = var1_1;
                        this.parameterDescription = var2_2;
                        this.readOnly = var3_3;
                        this.typing = typing;
                    }

                    @Override
                    public Class<T> getAnnotationType() {
                        return this.annotationType;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, Factory.AdviceType adviceType) {
                        void var1_1;
                        return new Resolved(var1_1.getType(), this.readOnly, this.typing, this.parameterDescription);
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (this.readOnly != ((Factory)object).readOnly) {
                            return false;
                        }
                        if (!this.typing.equals((Object)((Factory)object).typing)) {
                            return false;
                        }
                        if (!this.annotationType.equals(((Factory)object).annotationType)) {
                            return false;
                        }
                        return this.parameterDescription.equals(((Factory)object).parameterDescription);
                    }

                    public int hashCode() {
                        return (((this.getClass().hashCode() * 31 + this.annotationType.hashCode()) * 31 + this.parameterDescription.hashCode()) * 31 + this.readOnly) * 31 + this.typing.hashCode();
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class Unresolved
            extends ForArgument {
                private final int index;
                private final boolean optional;

                /*
                 * WARNING - void declaration
                 */
                protected Unresolved(TypeDescription.Generic target, AnnotationDescription.Loadable<Argument> annotation) {
                    this((TypeDescription.Generic)var1_1, annotation.getValue(Factory.ARGUMENT_READ_ONLY).resolve(Boolean.class), annotation.getValue(Factory.ARGUMENT_TYPING).resolve(EnumerationDescription.class).load(Assigner.Typing.class), annotation.getValue(Factory.ARGUMENT_VALUE).resolve(Integer.class), var2_2.getValue(Factory.ARGUMENT_OPTIONAL).resolve(Boolean.class));
                    void var2_2;
                    void var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                protected Unresolved(ParameterDescription parameterDescription) {
                    this(parameterDescription.getType(), true, Assigner.Typing.STATIC, var1_1.getIndex());
                    void var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public Unresolved(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, int index) {
                    this((TypeDescription.Generic)var1_1, (boolean)var2_2, (Assigner.Typing)var3_3, index, false);
                    void var3_3;
                    void var2_2;
                    void var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public Unresolved(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, int index, boolean optional) {
                    super((TypeDescription.Generic)var1_1, (boolean)var2_2, (Assigner.Typing)var3_3);
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.index = index;
                    this.optional = optional;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected ParameterDescription resolve(MethodDescription instrumentedMethod) {
                    void var2_2;
                    ParameterList<?> parameters = instrumentedMethod.getParameters();
                    if (parameters.size() <= this.index) {
                        void var1_1;
                        throw new IllegalStateException(var1_1 + " does not define an index " + this.index);
                    }
                    return (ParameterDescription)var2_2.get(this.index);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    if (this.optional && instrumentedMethod.getParameters().size() <= this.index) {
                        if (this.readOnly) {
                            return new Target.ForDefaultValue.ReadOnly(this.target);
                        }
                        return new Target.ForDefaultValue.ReadWrite(this.target);
                    }
                    return super.resolve((TypeDescription)var1_1, (MethodDescription)var2_2, (Assigner)var3_3, argumentHandler, sort);
                }

                @Override
                public boolean equals(@MaybeNull Object object) {
                    if (!super.equals(object)) {
                        return false;
                    }
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (this.index != ((Unresolved)object).index) {
                        return false;
                    }
                    return this.optional == ((Unresolved)object).optional;
                }

                @Override
                public int hashCode() {
                    return (super.hashCode() * 31 + this.index) * 31 + this.optional;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                protected static final class Factory
                extends Enum<Factory>
                implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<Argument> {
                    public static final /* enum */ Factory INSTANCE;
                    private static final MethodDescription.InDefinedShape ARGUMENT_VALUE;
                    private static final MethodDescription.InDefinedShape ARGUMENT_READ_ONLY;
                    private static final MethodDescription.InDefinedShape ARGUMENT_TYPING;
                    private static final MethodDescription.InDefinedShape ARGUMENT_OPTIONAL;
                    private static final /* synthetic */ Factory[] $VALUES;

                    public static Factory[] values() {
                        return (Factory[])$VALUES.clone();
                    }

                    public static Factory valueOf(String name) {
                        String string;
                        return Enum.valueOf(Factory.class, string);
                    }

                    @Override
                    public final Class<Argument> getAnnotationType() {
                        return Argument.class;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Argument> annotation, Factory.AdviceType adviceType) {
                        void var2_2;
                        void var1_1;
                        if (adviceType.isDelegation() && !annotation.getValue(ARGUMENT_READ_ONLY).resolve(Boolean.class).booleanValue()) {
                            throw new IllegalStateException("Cannot define writable field access for " + target + " when using delegation");
                        }
                        return new Unresolved(var1_1.getType(), (AnnotationDescription.Loadable<Argument>)var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    static {
                        void var0;
                        INSTANCE = new Factory();
                        $VALUES = new Factory[]{INSTANCE};
                        MethodList<MethodDescription.InDefinedShape> methods = TypeDescription.ForLoadedType.of(Argument.class).getDeclaredMethods();
                        ARGUMENT_VALUE = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("value"))).getOnly();
                        ARGUMENT_READ_ONLY = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("readOnly"))).getOnly();
                        ARGUMENT_TYPING = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("typing"))).getOnly();
                        ARGUMENT_OPTIONAL = (MethodDescription.InDefinedShape)((MethodList)var0.filter(ElementMatchers.named("optional"))).getOnly();
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Sort {
            ENTER{

                public final boolean isPremature(MethodDescription methodDescription) {
                    return methodDescription.isConstructor();
                }
            }
            ,
            EXIT{

                public final boolean isPremature(MethodDescription methodDescription) {
                    return false;
                }
            };


            public abstract boolean isPremature(MethodDescription var1);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Factory<T extends Annotation> {
            public Class<T> getAnnotationType();

            public OffsetMapping make(ParameterDescription.InDefinedShape var1, AnnotationDescription.Loadable<T> var2, AdviceType var3);

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class Illegal<T extends Annotation>
            implements Factory<T> {
                private final Class<T> annotationType;

                /*
                 * WARNING - void declaration
                 */
                public Illegal(Class<T> annotationType) {
                    void var1_1;
                    this.annotationType = var1_1;
                }

                @Override
                public Class<T> getAnnotationType() {
                    return this.annotationType;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, AdviceType adviceType) {
                    void var1_1;
                    throw new IllegalStateException("Usage of " + this.annotationType + " is not allowed on " + var1_1);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.annotationType.equals(((Illegal)object).annotationType);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.annotationType.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class Simple<T extends Annotation>
            implements Factory<T> {
                private final Class<T> annotationType;
                private final OffsetMapping offsetMapping;

                /*
                 * WARNING - void declaration
                 */
                public Simple(Class<T> annotationType, OffsetMapping offsetMapping) {
                    void var2_2;
                    void var1_1;
                    this.annotationType = var1_1;
                    this.offsetMapping = var2_2;
                }

                @Override
                public Class<T> getAnnotationType() {
                    return this.annotationType;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, AdviceType adviceType) {
                    return this.offsetMapping;
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.annotationType.equals(((Simple)object).annotationType)) {
                        return false;
                    }
                    return this.offsetMapping.equals(((Simple)object).offsetMapping);
                }

                public int hashCode() {
                    return (this.getClass().hashCode() * 31 + this.annotationType.hashCode()) * 31 + this.offsetMapping.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum AdviceType {
                DELEGATION(true),
                INLINING(false);

                private final boolean delegation;

                /*
                 * WARNING - void declaration
                 */
                private AdviceType(boolean delegation) {
                    void var3_3;
                    this.delegation = var3_3;
                }

                public final boolean isDelegation() {
                    return this.delegation;
                }
            }
        }

        public static interface Target {
            public StackManipulation resolveRead();

            public StackManipulation resolveWrite();

            public StackManipulation resolveIncrement(int var1);

            @HashCodeAndEqualsPlugin.Enhance
            public static class ForStackManipulation
            implements Target {
                private final StackManipulation stackManipulation;

                /*
                 * WARNING - void declaration
                 */
                public ForStackManipulation(StackManipulation stackManipulation) {
                    void var1_1;
                    this.stackManipulation = var1_1;
                }

                public static Target of(MethodDescription.InDefinedShape methodDescription) {
                    MethodDescription.InDefinedShape inDefinedShape;
                    return new ForStackManipulation(MethodConstant.of(inDefinedShape));
                }

                public static Target of(TypeDescription typeDescription) {
                    TypeDescription typeDescription2;
                    return new ForStackManipulation(ClassConstant.of(typeDescription2));
                }

                public static Target of(@MaybeNull Object value) {
                    Object object;
                    return new ForStackManipulation(value == null ? NullConstant.INSTANCE : ConstantValue.Simple.wrap(object).toStackManipulation());
                }

                public StackManipulation resolveRead() {
                    return this.stackManipulation;
                }

                public StackManipulation resolveWrite() {
                    throw new IllegalStateException("Cannot write to constant value: " + this.stackManipulation);
                }

                public StackManipulation resolveIncrement(int value) {
                    throw new IllegalStateException("Cannot write to constant value: " + this.stackManipulation);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.stackManipulation.equals(((ForStackManipulation)object).stackManipulation);
                }

                public int hashCode() {
                    return this.getClass().hashCode() * 31 + this.stackManipulation.hashCode();
                }

                @HashCodeAndEqualsPlugin.Enhance
                public static class Writable
                implements Target {
                    private final StackManipulation read;
                    private final StackManipulation write;

                    /*
                     * WARNING - void declaration
                     */
                    public Writable(StackManipulation read, StackManipulation write) {
                        void var2_2;
                        void var1_1;
                        this.read = var1_1;
                        this.write = var2_2;
                    }

                    public StackManipulation resolveRead() {
                        return this.read;
                    }

                    public StackManipulation resolveWrite() {
                        return this.write;
                    }

                    public StackManipulation resolveIncrement(int value) {
                        throw new IllegalStateException("Cannot increment mutable constant value: " + this.write);
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (!this.read.equals(((Writable)object).read)) {
                            return false;
                        }
                        return this.write.equals(((Writable)object).write);
                    }

                    public int hashCode() {
                        return (this.getClass().hashCode() * 31 + this.read.hashCode()) * 31 + this.write.hashCode();
                    }
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            public static abstract class ForField
            implements Target {
                protected final FieldDescription fieldDescription;
                protected final StackManipulation readAssignment;

                /*
                 * WARNING - void declaration
                 */
                protected ForField(FieldDescription fieldDescription, StackManipulation readAssignment) {
                    void var2_2;
                    void var1_1;
                    this.fieldDescription = var1_1;
                    this.readAssignment = var2_2;
                }

                public StackManipulation resolveRead() {
                    return new StackManipulation.Compound(this.fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), FieldAccess.forField(this.fieldDescription).read(), this.readAssignment);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.fieldDescription.equals(((ForField)object).fieldDescription)) {
                        return false;
                    }
                    return this.readAssignment.equals(((ForField)object).readAssignment);
                }

                public int hashCode() {
                    return (this.getClass().hashCode() * 31 + this.fieldDescription.hashCode()) * 31 + this.readAssignment.hashCode();
                }

                @HashCodeAndEqualsPlugin.Enhance
                public static class ReadWrite
                extends ForField {
                    private final StackManipulation writeAssignment;

                    /*
                     * WARNING - void declaration
                     */
                    public ReadWrite(FieldDescription fieldDescription) {
                        void var1_1;
                        StackManipulation.Trivial trivial = StackManipulation.Trivial.INSTANCE;
                        this((FieldDescription)var1_1, trivial, trivial);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public ReadWrite(FieldDescription fieldDescription, StackManipulation readAssignment, StackManipulation writeAssignment) {
                        super((FieldDescription)var1_1, (StackManipulation)var2_2);
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.writeAssignment = var3_3;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public StackManipulation resolveWrite() {
                        void var1_1;
                        StackManipulation preparation = this.fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : new StackManipulation.Compound(MethodVariableAccess.loadThis(), Duplication.SINGLE.flipOver(this.fieldDescription.getType()), Removal.SINGLE);
                        return new StackManipulation.Compound(new StackManipulation[]{this.writeAssignment, var1_1, FieldAccess.forField(this.fieldDescription).write()});
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public StackManipulation resolveIncrement(int value) {
                        void var1_1;
                        return new StackManipulation.Compound(this.resolveRead(), IntegerConstant.forValue((int)var1_1), Addition.INTEGER, this.resolveWrite());
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (!super.equals(object)) {
                            return false;
                        }
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        return this.writeAssignment.equals(((ReadWrite)object).writeAssignment);
                    }

                    public int hashCode() {
                        return super.hashCode() * 31 + this.writeAssignment.hashCode();
                    }
                }

                @HashCodeAndEqualsPlugin.Enhance
                public static class WriteOnly
                implements Target {
                    private final FieldDescription fieldDescription;
                    private final StackManipulation writeAssignment;

                    /*
                     * WARNING - void declaration
                     */
                    protected WriteOnly(FieldDescription fieldDescription, StackManipulation writeAssignment) {
                        void var2_2;
                        void var1_1;
                        this.fieldDescription = var1_1;
                        this.writeAssignment = var2_2;
                    }

                    public StackManipulation resolveRead() {
                        throw new IllegalStateException("Cannot read write-only field value");
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public StackManipulation resolveWrite() {
                        void var1_1;
                        StackManipulation preparation = this.fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : new StackManipulation.Compound(MethodVariableAccess.loadThis(), Duplication.SINGLE.flipOver(this.fieldDescription.getType()), Removal.SINGLE);
                        return new StackManipulation.Compound(new StackManipulation[]{this.writeAssignment, var1_1, FieldAccess.forField(this.fieldDescription).write()});
                    }

                    public StackManipulation resolveIncrement(int value) {
                        throw new IllegalStateException("Cannot increment write-only field value");
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (!this.fieldDescription.equals(((WriteOnly)object).fieldDescription)) {
                            return false;
                        }
                        return this.writeAssignment.equals(((WriteOnly)object).writeAssignment);
                    }

                    public int hashCode() {
                        return (this.getClass().hashCode() * 31 + this.fieldDescription.hashCode()) * 31 + this.writeAssignment.hashCode();
                    }
                }

                public static class ReadOnly
                extends ForField {
                    /*
                     * WARNING - void declaration
                     */
                    public ReadOnly(FieldDescription fieldDescription) {
                        this((FieldDescription)var1_1, StackManipulation.Trivial.INSTANCE);
                        void var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public ReadOnly(FieldDescription fieldDescription, StackManipulation readAssignment) {
                        super((FieldDescription)var1_1, (StackManipulation)var2_2);
                        void var2_2;
                        void var1_1;
                    }

                    public StackManipulation resolveWrite() {
                        throw new IllegalStateException("Cannot write to read-only field value");
                    }

                    public StackManipulation resolveIncrement(int value) {
                        throw new IllegalStateException("Cannot write to read-only field value");
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static abstract class ForArray
            implements Target {
                protected final TypeDescription.Generic target;
                protected final List<? extends StackManipulation> valueReads;

                /*
                 * WARNING - void declaration
                 */
                protected ForArray(TypeDescription.Generic target, List<? extends StackManipulation> valueReads) {
                    void var2_2;
                    void var1_1;
                    this.target = var1_1;
                    this.valueReads = var2_2;
                }

                @Override
                public StackManipulation resolveRead() {
                    return ArrayFactory.forType(this.target).withValues(this.valueReads);
                }

                @Override
                public StackManipulation resolveIncrement(int value) {
                    throw new IllegalStateException("Cannot increment read-only array value");
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.target.equals(((ForArray)object).target)) {
                        return false;
                    }
                    return ((Object)this.valueReads).equals(((ForArray)object).valueReads);
                }

                public int hashCode() {
                    return (this.getClass().hashCode() * 31 + this.target.hashCode()) * 31 + ((Object)this.valueReads).hashCode();
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                @HashCodeAndEqualsPlugin.Enhance
                public static class ReadWrite
                extends ForArray {
                    private final List<? extends StackManipulation> valueWrites;

                    /*
                     * WARNING - void declaration
                     */
                    public ReadWrite(TypeDescription.Generic target, List<? extends StackManipulation> valueReads, List<? extends StackManipulation> valueWrites) {
                        super((TypeDescription.Generic)var1_1, (List<? extends StackManipulation>)var2_2);
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.valueWrites = var3_3;
                    }

                    @Override
                    public StackManipulation resolveWrite() {
                        return new StackManipulation.Compound(ArrayAccess.of(this.target).forEach(this.valueWrites), Removal.SINGLE);
                    }

                    @Override
                    public boolean equals(@MaybeNull Object object) {
                        if (!super.equals(object)) {
                            return false;
                        }
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        return ((Object)this.valueWrites).equals(((ReadWrite)object).valueWrites);
                    }

                    @Override
                    public int hashCode() {
                        return super.hashCode() * 31 + ((Object)this.valueWrites).hashCode();
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public static class ReadOnly
                extends ForArray {
                    /*
                     * WARNING - void declaration
                     */
                    public ReadOnly(TypeDescription.Generic target, List<? extends StackManipulation> valueReads) {
                        super((TypeDescription.Generic)var1_1, (List<? extends StackManipulation>)var2_2);
                        void var2_2;
                        void var1_1;
                    }

                    @Override
                    public StackManipulation resolveWrite() {
                        throw new IllegalStateException("Cannot write to read-only array value");
                    }
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            public static abstract class ForVariable
            implements Target {
                protected final TypeDefinition typeDefinition;
                protected final int offset;
                protected final StackManipulation readAssignment;

                /*
                 * WARNING - void declaration
                 */
                protected ForVariable(TypeDefinition typeDefinition, int offset, StackManipulation readAssignment) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.typeDefinition = var1_1;
                    this.offset = var2_2;
                    this.readAssignment = var3_3;
                }

                public StackManipulation resolveRead() {
                    return new StackManipulation.Compound(MethodVariableAccess.of(this.typeDefinition).loadFrom(this.offset), this.readAssignment);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (this.offset != ((ForVariable)object).offset) {
                        return false;
                    }
                    if (!this.typeDefinition.equals(((ForVariable)object).typeDefinition)) {
                        return false;
                    }
                    return this.readAssignment.equals(((ForVariable)object).readAssignment);
                }

                public int hashCode() {
                    return ((this.getClass().hashCode() * 31 + this.typeDefinition.hashCode()) * 31 + this.offset) * 31 + this.readAssignment.hashCode();
                }

                @HashCodeAndEqualsPlugin.Enhance
                public static class ReadWrite
                extends ForVariable {
                    private final StackManipulation writeAssignment;

                    /*
                     * WARNING - void declaration
                     */
                    public ReadWrite(TypeDefinition typeDefinition, int offset) {
                        void var2_2;
                        void var1_1;
                        StackManipulation.Trivial trivial = StackManipulation.Trivial.INSTANCE;
                        this((TypeDefinition)var1_1, (int)var2_2, trivial, trivial);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public ReadWrite(TypeDefinition typeDefinition, int offset, StackManipulation readAssignment, StackManipulation writeAssignment) {
                        super((TypeDefinition)var1_1, (int)var2_2, (StackManipulation)var3_3);
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.writeAssignment = writeAssignment;
                    }

                    public StackManipulation resolveWrite() {
                        return new StackManipulation.Compound(this.writeAssignment, MethodVariableAccess.of(this.typeDefinition).storeAt(this.offset));
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public StackManipulation resolveIncrement(int value) {
                        if (this.typeDefinition.represents(Integer.TYPE)) {
                            void var1_1;
                            return MethodVariableAccess.of(this.typeDefinition).increment(this.offset, (int)var1_1);
                        }
                        return new StackManipulation.Compound(this.resolveRead(), IntegerConstant.forValue(1), Addition.INTEGER, this.resolveWrite());
                    }

                    public boolean equals(@MaybeNull Object object) {
                        if (!super.equals(object)) {
                            return false;
                        }
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        return this.writeAssignment.equals(((ReadWrite)object).writeAssignment);
                    }

                    public int hashCode() {
                        return super.hashCode() * 31 + this.writeAssignment.hashCode();
                    }
                }

                public static class ReadOnly
                extends ForVariable {
                    /*
                     * WARNING - void declaration
                     */
                    public ReadOnly(TypeDefinition typeDefinition, int offset) {
                        this((TypeDefinition)var1_1, (int)var2_2, StackManipulation.Trivial.INSTANCE);
                        void var2_2;
                        void var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public ReadOnly(TypeDefinition typeDefinition, int offset, StackManipulation readAssignment) {
                        super((TypeDefinition)var1_1, (int)var2_2, (StackManipulation)var3_3);
                        void var3_3;
                        void var2_2;
                        void var1_1;
                    }

                    public StackManipulation resolveWrite() {
                        throw new IllegalStateException("Cannot write to read-only parameter " + this.typeDefinition + " at " + this.offset);
                    }

                    public StackManipulation resolveIncrement(int value) {
                        throw new IllegalStateException("Cannot write to read-only variable " + this.typeDefinition + " at " + this.offset);
                    }
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            public static abstract class ForDefaultValue
            implements Target {
                protected final TypeDefinition typeDefinition;
                protected final StackManipulation readAssignment;

                /*
                 * WARNING - void declaration
                 */
                protected ForDefaultValue(TypeDefinition typeDefinition, StackManipulation readAssignment) {
                    void var2_2;
                    void var1_1;
                    this.typeDefinition = var1_1;
                    this.readAssignment = var2_2;
                }

                public StackManipulation resolveRead() {
                    return new StackManipulation.Compound(DefaultValue.of(this.typeDefinition), this.readAssignment);
                }

                public boolean equals(@MaybeNull Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.typeDefinition.equals(((ForDefaultValue)object).typeDefinition)) {
                        return false;
                    }
                    return this.readAssignment.equals(((ForDefaultValue)object).readAssignment);
                }

                public int hashCode() {
                    return (this.getClass().hashCode() * 31 + this.typeDefinition.hashCode()) * 31 + this.readAssignment.hashCode();
                }

                public static class ReadWrite
                extends ForDefaultValue {
                    /*
                     * WARNING - void declaration
                     */
                    public ReadWrite(TypeDefinition typeDefinition) {
                        this((TypeDefinition)var1_1, StackManipulation.Trivial.INSTANCE);
                        void var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public ReadWrite(TypeDefinition typeDefinition, StackManipulation readAssignment) {
                        super((TypeDefinition)var1_1, (StackManipulation)var2_2);
                        void var2_2;
                        void var1_1;
                    }

                    public StackManipulation resolveWrite() {
                        return Removal.of(this.typeDefinition);
                    }

                    public StackManipulation resolveIncrement(int value) {
                        return StackManipulation.Trivial.INSTANCE;
                    }
                }

                public static class ReadOnly
                extends ForDefaultValue {
                    /*
                     * WARNING - void declaration
                     */
                    public ReadOnly(TypeDefinition typeDefinition) {
                        this((TypeDefinition)var1_1, StackManipulation.Trivial.INSTANCE);
                        void var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public ReadOnly(TypeDefinition typeDefinition, StackManipulation readAssignment) {
                        super((TypeDefinition)var1_1, (StackManipulation)var2_2);
                        void var2_2;
                        void var1_1;
                    }

                    public StackManipulation resolveWrite() {
                        throw new IllegalStateException("Cannot write to read-only default value");
                    }

                    public StackManipulation resolveIncrement(int value) {
                        throw new IllegalStateException("Cannot write to read-only default value");
                    }
                }
            }

            public static abstract class AbstractReadOnlyAdapter
            implements Target {
                public StackManipulation resolveWrite() {
                    throw new IllegalStateException("Cannot write to read-only value");
                }

                public StackManipulation resolveIncrement(int value) {
                    throw new IllegalStateException("Cannot write to read-only value");
                }
            }
        }
    }
}

