/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.bytebuddy.build.CachedReturnPlugin;
import net.bytebuddy.utility.CompoundList;
import net.bytebuddy.utility.nullability.AlwaysNull;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeCache<T>
extends ReferenceQueue<ClassLoader> {
    @AlwaysNull
    private static final Class<?> NOT_FOUND = null;
    protected final Sort sort;
    protected final ConcurrentMap<StorageKey, ConcurrentMap<T, Object>> cache;

    public TypeCache() {
        this(Sort.STRONG);
    }

    /*
     * WARNING - void declaration
     */
    public TypeCache(Sort sort) {
        void var1_1;
        this.sort = var1_1;
        this.cache = new ConcurrentHashMap<StorageKey, ConcurrentMap<T, Object>>();
    }

    /*
     * WARNING - void declaration
     */
    @MaybeNull
    @SuppressFBWarnings(value={"GC_UNRELATED_TYPES"}, justification="Cross-comparison is intended.")
    public Class<?> find(@MaybeNull ClassLoader classLoader, T key) {
        void var1_1;
        void var2_2;
        ConcurrentMap storage = (ConcurrentMap)this.cache.get(new LookupKey(classLoader));
        if (storage == null) {
            return NOT_FOUND;
        }
        Object value = storage.get(var2_2);
        if (value == null) {
            return NOT_FOUND;
        }
        if (value instanceof Reference) {
            return (Class)((Reference)value).get();
        }
        return (Class)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"GC_UNRELATED_TYPES"}, justification="Cross-comparison is intended.")
    public Class<?> insert(@MaybeNull ClassLoader classLoader, T key, Class<?> type) {
        void var3_3;
        ConcurrentMap previous;
        ConcurrentMap<T, Object> storage = (ConcurrentHashMap<T, Object>)this.cache.get(new LookupKey(classLoader));
        if (storage == null && (previous = (ConcurrentMap)this.cache.putIfAbsent(new StorageKey(classLoader, this), storage = new ConcurrentHashMap<T, Object>())) != null) {
            storage = previous;
        }
        Object value = this.sort.wrap(type);
        Object previous2 = storage.putIfAbsent(key, value);
        while (previous2 != null) {
            Class previousType = (Class)(previous2 instanceof Reference ? ((Reference)previous2).get() : previous2);
            if (previousType != null) {
                return previousType;
            }
            if (storage.remove(key, previous2)) {
                previous2 = storage.putIfAbsent(key, value);
                continue;
            }
            previous2 = storage.get(key);
            if (previous2 != null) continue;
            previous2 = storage.putIfAbsent(key, value);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Class<?> findOrInsert(@MaybeNull ClassLoader classLoader, T key, Callable<Class<?>> lazy) {
        Class<?> type = this.find(classLoader, key);
        if (type != null) {
            return type;
        }
        try {
            void var3_4;
            void var2_3;
            return this.insert(classLoader, var2_3, (Class)var3_4.call());
        }
        catch (Throwable throwable) {
            void var1_2;
            throw new IllegalArgumentException("Could not create type", (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Class<?> findOrInsert(@MaybeNull ClassLoader classLoader, T key, Callable<Class<?>> lazy, Object monitor) {
        Class<?> type = this.find(classLoader, key);
        if (type != null) {
            return type;
        }
        Object object = monitor;
        synchronized (object) {
            void var3_4;
            void var2_3;
            void var1_1;
            return this.findOrInsert((ClassLoader)var1_1, var2_3, (Callable<Class<?>>)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void expungeStaleEntries() {
        Reference reference;
        while ((reference = this.poll()) != null) {
            void var1_1;
            this.cache.remove(var1_1);
        }
    }

    public void clear() {
        this.cache.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleKey {
        private final Set<String> types = new HashSet<String>();
        private transient /* synthetic */ int hashCode;

        /*
         * WARNING - void declaration
         */
        public SimpleKey(Class<?> type, Class<?> ... additionalType) {
            this((Class<?>)var1_1, Arrays.asList(var2_2));
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public SimpleKey(Class<?> type, Collection<? extends Class<?>> additionalTypes) {
            this(CompoundList.of(var1_1, new ArrayList(var2_2)));
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public SimpleKey(Collection<? extends Class<?>> types) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                Class type = (Class)iterator.next();
                this.types.add(var2_2.getName());
            }
        }

        @CachedReturnPlugin.Enhance(value="hashCode")
        public int hashCode() {
            int n;
            int n2 = this.hashCode;
            if (n2 != 0) {
                n = 0;
            } else {
                SimpleKey simpleKey = this;
                n = n2 = simpleKey.types.hashCode();
            }
            if (n == 0) {
                n2 = this.hashCode;
            } else {
                this.hashCode = n2;
            }
            return n2;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(@MaybeNull Object other) {
            void var1_1;
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            SimpleKey simpleKey = (SimpleKey)other;
            return this.types.equals(var1_1.types);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WithInlineExpunction<S>
    extends TypeCache<S> {
        public WithInlineExpunction() {
            this(Sort.STRONG);
        }

        /*
         * WARNING - void declaration
         */
        public WithInlineExpunction(Sort sort) {
            super((Sort)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Class<?> find(@MaybeNull ClassLoader classLoader, S key) {
            try {
                void var2_3;
                Class<?> clazz;
                clazz = super.find((ClassLoader)((Object)clazz), var2_3);
                return clazz;
            }
            finally {
                this.expungeStaleEntries();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Class<?> insert(@MaybeNull ClassLoader classLoader, S key, Class<?> type) {
            try {
                void var3_4;
                void var2_3;
                Class<?> clazz;
                clazz = super.insert((ClassLoader)((Object)clazz), var2_3, (Class<?>)var3_4);
                return clazz;
            }
            finally {
                this.expungeStaleEntries();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Class<?> findOrInsert(@MaybeNull ClassLoader classLoader, S key, Callable<Class<?>> builder) {
            try {
                void var3_4;
                void var2_3;
                Class<?> clazz;
                clazz = super.findOrInsert((ClassLoader)((Object)clazz), var2_3, (Callable<Class<?>>)var3_4);
                return clazz;
            }
            finally {
                this.expungeStaleEntries();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Class<?> findOrInsert(@MaybeNull ClassLoader classLoader, S key, Callable<Class<?>> builder, Object monitor) {
            try {
                void var3_4;
                void var2_3;
                Class<?> clazz;
                clazz = super.findOrInsert((ClassLoader)((Object)clazz), var2_3, (Callable<Class<?>>)var3_4, monitor);
                return clazz;
            }
            finally {
                this.expungeStaleEntries();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StorageKey
    extends WeakReference<ClassLoader> {
        private final int hashCode;

        /*
         * WARNING - void declaration
         */
        protected StorageKey(@MaybeNull ClassLoader classLoader, ReferenceQueue<? super ClassLoader> referenceQueue) {
            super(classLoader, var2_2);
            void var1_1;
            void var2_2;
            this.hashCode = System.identityHashCode(var1_1);
        }

        public int hashCode() {
            return this.hashCode;
        }

        /*
         * WARNING - void declaration
         */
        @SuppressFBWarnings(value={"EQ_CHECK_FOR_OPERAND_NOT_COMPATIBLE_WITH_THIS"}, justification="Cross-comparison is intended.")
        public boolean equals(@MaybeNull Object other) {
            LookupKey lookupKey;
            if (this == other) {
                return true;
            }
            if (other instanceof LookupKey) {
                lookupKey = (LookupKey)other;
                return this.hashCode == lookupKey.hashCode && this.get() == lookupKey.classLoader;
            }
            if (lookupKey instanceof StorageKey) {
                void var1_1;
                StorageKey storageKey = (StorageKey)((Object)lookupKey);
                return this.hashCode == storageKey.hashCode && this.get() == var1_1.get();
            }
            return false;
        }
    }

    protected static class LookupKey {
        @MaybeNull
        private final ClassLoader classLoader;
        private final int hashCode;

        /*
         * WARNING - void declaration
         */
        protected LookupKey(@MaybeNull ClassLoader classLoader) {
            void var1_1;
            this.classLoader = classLoader;
            this.hashCode = System.identityHashCode(var1_1);
        }

        public int hashCode() {
            return this.hashCode;
        }

        /*
         * WARNING - void declaration
         */
        @SuppressFBWarnings(value={"EQ_CHECK_FOR_OPERAND_NOT_COMPATIBLE_WITH_THIS"}, justification="Cross-comparison is intended.")
        public boolean equals(@MaybeNull Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof LookupKey) {
                return this.classLoader == ((LookupKey)other).classLoader;
            }
            if (other instanceof StorageKey) {
                void var1_1;
                StorageKey storageKey = (StorageKey)other;
                return this.hashCode == storageKey.hashCode && this.classLoader == var1_1.get();
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sort {
        WEAK{

            /*
             * WARNING - void declaration
             */
            @Override
            protected final Reference<Class<?>> wrap(Class<?> type) {
                void var1_1;
                return new WeakReference<void>(var1_1);
            }
        }
        ,
        SOFT{

            /*
             * WARNING - void declaration
             */
            @Override
            protected final Reference<Class<?>> wrap(Class<?> type) {
                void var1_1;
                return new SoftReference<void>(var1_1);
            }
        }
        ,
        STRONG{

            @Override
            protected final Class<?> wrap(Class<?> type) {
                return type;
            }
        };


        protected abstract Object wrap(Class<?> var1);
    }
}

