/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import net.bytebuddy.build.AccessControllerPlugin;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFileVersion
implements Serializable,
Comparable<ClassFileVersion> {
    private static final long serialVersionUID = 1L;
    protected static final int BASE_VERSION = 44;
    public static final ClassFileVersion JAVA_V1;
    public static final ClassFileVersion JAVA_V2;
    public static final ClassFileVersion JAVA_V3;
    public static final ClassFileVersion JAVA_V4;
    public static final ClassFileVersion JAVA_V5;
    public static final ClassFileVersion JAVA_V6;
    public static final ClassFileVersion JAVA_V7;
    public static final ClassFileVersion JAVA_V8;
    public static final ClassFileVersion JAVA_V9;
    public static final ClassFileVersion JAVA_V10;
    public static final ClassFileVersion JAVA_V11;
    public static final ClassFileVersion JAVA_V12;
    public static final ClassFileVersion JAVA_V13;
    public static final ClassFileVersion JAVA_V14;
    public static final ClassFileVersion JAVA_V15;
    public static final ClassFileVersion JAVA_V16;
    public static final ClassFileVersion JAVA_V17;
    public static final ClassFileVersion JAVA_V18;
    public static final ClassFileVersion JAVA_V19;
    public static final ClassFileVersion JAVA_V20;
    public static final ClassFileVersion JAVA_V21;
    public static final ClassFileVersion JAVA_V22;
    public static final ClassFileVersion JAVA_V23;
    public static final ClassFileVersion JAVA_V24;
    private static final ClassFileVersion[] CLASS_FILE_VERSIONS;
    private static final VersionLocator VERSION_LOCATOR;
    private final int versionNumber;
    private static final boolean ACCESS_CONTROLLER;

    /*
     * WARNING - void declaration
     */
    protected ClassFileVersion(int versionNumber) {
        void var1_1;
        this.versionNumber = var1_1;
    }

    @AccessControllerPlugin.Enhance
    private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        if (ACCESS_CONTROLLER) {
            return AccessController.doPrivileged(privilegedAction);
        }
        return privilegedAction.run();
    }

    /*
     * WARNING - void declaration
     */
    public static ClassFileVersion ofMinorMajor(int versionNumber) {
        void var1_1;
        ClassFileVersion classFileVersion = new ClassFileVersion(versionNumber);
        if (classFileVersion.getMajorVersion() > 0 && classFileVersion.getMajorVersion() <= 44) {
            int n;
            throw new IllegalArgumentException("Class version " + n + " is not valid");
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static ClassFileVersion ofJavaVersionString(String javaVersionString) {
        int index = javaVersionString.indexOf(46);
        try {
            int javaVersion;
            if (index == -1) {
                javaVersion = Integer.parseInt(javaVersionString);
            } else {
                void var1_1;
                javaVersion = Integer.parseInt(javaVersionString.substring(index + 1));
                if (Integer.parseInt(javaVersionString.substring(0, (int)var1_1)) != 1 || javaVersion > 8) {
                    throw new IllegalArgumentException("Java versions with minor version must be of format 1.[1-7]: " + javaVersionString);
                }
            }
            return ClassFileVersion.ofJavaVersion(javaVersion);
        }
        catch (NumberFormatException exception) {
            void var2_3;
            String string;
            throw new IllegalStateException("Failed to read Java version from: " + string, (Throwable)var2_3);
        }
    }

    public static ClassFileVersion ofJavaVersion(int javaVersion) {
        int n;
        if (javaVersion <= 0) {
            throw new IllegalArgumentException("Java version must be positive: " + javaVersion);
        }
        if (javaVersion - 1 < CLASS_FILE_VERSIONS.length) {
            return CLASS_FILE_VERSIONS[javaVersion - 1];
        }
        return new ClassFileVersion(n + 44);
    }

    public static ClassFileVersion latest() {
        return JAVA_V24;
    }

    public static ClassFileVersion ofThisVm() {
        return VERSION_LOCATOR.resolve();
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback.")
    public static ClassFileVersion ofThisVm(ClassFileVersion fallback) {
        try {
            return ClassFileVersion.ofThisVm();
        }
        catch (Exception exception) {
            ClassFileVersion classFileVersion;
            return classFileVersion;
        }
    }

    public static ClassFileVersion of(Class<?> type) throws IOException {
        Class<?> clazz = type;
        return ClassFileVersion.of(clazz, ClassFileLocator.ForClassLoader.of(clazz.getClassLoader()));
    }

    /*
     * WARNING - void declaration
     */
    public static ClassFileVersion of(Class<?> type, ClassFileLocator classFileLocator) throws IOException {
        void var1_1;
        return ClassFileVersion.of(TypeDescription.ForLoadedType.of(type), (ClassFileLocator)var1_1);
    }

    public static ClassFileVersion of(TypeDescription typeDescription, ClassFileLocator classFileLocator) throws IOException {
        TypeDescription typeDescription2;
        return ClassFileVersion.ofClassFile(classFileLocator.locate(typeDescription2.getName()).resolve());
    }

    public static ClassFileVersion ofClassFile(byte[] binaryRepresentation) {
        byte[] byArray;
        if (binaryRepresentation.length < 7) {
            throw new IllegalArgumentException("Supplied byte array is too short to be a class file with " + binaryRepresentation.length + " byte");
        }
        return ClassFileVersion.ofMinorMajor(binaryRepresentation[4] << 24 | binaryRepresentation[5] << 16 | binaryRepresentation[6] << 8 | byArray[7]);
    }

    public int getMinorMajorVersion() {
        return this.versionNumber;
    }

    public short getMajorVersion() {
        return (short)this.versionNumber;
    }

    public short getMinorVersion() {
        return (short)(this.versionNumber >>> 16);
    }

    public int getJavaVersion() {
        return this.getMajorVersion() - 44;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAtLeast(ClassFileVersion classFileVersion) {
        void var1_1;
        return this.compareTo((ClassFileVersion)var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isGreaterThan(ClassFileVersion classFileVersion) {
        void var1_1;
        return this.compareTo((ClassFileVersion)var1_1) > 0;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAtMost(ClassFileVersion classFileVersion) {
        void var1_1;
        return this.compareTo((ClassFileVersion)var1_1) <= 0;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isLessThan(ClassFileVersion classFileVersion) {
        void var1_1;
        return this.compareTo((ClassFileVersion)var1_1) < 0;
    }

    public ClassFileVersion asPreviewVersion() {
        return new ClassFileVersion(this.versionNumber | 0xFFFF0000);
    }

    public boolean isPreviewVersion() {
        return (this.versionNumber & 0xFFFF0000) == -65536;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(ClassFileVersion other) {
        void var1_1;
        return Integer.signum(this.getMajorVersion() == other.getMajorVersion() ? this.getMinorVersion() - other.getMinorVersion() : this.getMajorVersion() - var1_1.getMajorVersion());
    }

    public int hashCode() {
        return this.versionNumber;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@MaybeNull Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.versionNumber == ((ClassFileVersion)var1_1).versionNumber;
    }

    public String toString() {
        return "Java " + this.getJavaVersion() + " (" + this.getMinorMajorVersion() + ")";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            Class.forName("java.security.AccessController", false, null);
            ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            ACCESS_CONTROLLER = false;
        }
        catch (SecurityException securityException) {
            ACCESS_CONTROLLER = true;
        }
        JAVA_V1 = new ClassFileVersion(196653);
        JAVA_V2 = new ClassFileVersion(46);
        JAVA_V3 = new ClassFileVersion(47);
        JAVA_V4 = new ClassFileVersion(48);
        JAVA_V5 = new ClassFileVersion(49);
        JAVA_V6 = new ClassFileVersion(50);
        JAVA_V7 = new ClassFileVersion(51);
        JAVA_V8 = new ClassFileVersion(52);
        JAVA_V9 = new ClassFileVersion(53);
        JAVA_V10 = new ClassFileVersion(54);
        JAVA_V11 = new ClassFileVersion(55);
        JAVA_V12 = new ClassFileVersion(56);
        JAVA_V13 = new ClassFileVersion(57);
        JAVA_V14 = new ClassFileVersion(58);
        JAVA_V15 = new ClassFileVersion(59);
        JAVA_V16 = new ClassFileVersion(60);
        JAVA_V17 = new ClassFileVersion(61);
        JAVA_V18 = new ClassFileVersion(62);
        JAVA_V19 = new ClassFileVersion(63);
        JAVA_V20 = new ClassFileVersion(64);
        JAVA_V21 = new ClassFileVersion(65);
        JAVA_V22 = new ClassFileVersion(66);
        JAVA_V23 = new ClassFileVersion(67);
        JAVA_V24 = new ClassFileVersion(68);
        CLASS_FILE_VERSIONS = new ClassFileVersion[]{JAVA_V1, JAVA_V2, JAVA_V3, JAVA_V4, JAVA_V5, JAVA_V6, JAVA_V7, JAVA_V8, JAVA_V9, JAVA_V10, JAVA_V11, JAVA_V12, JAVA_V13, JAVA_V14, JAVA_V15, JAVA_V16, JAVA_V17, JAVA_V18, JAVA_V19, JAVA_V20, JAVA_V21, JAVA_V22, JAVA_V23, JAVA_V24};
        VERSION_LOCATOR = ClassFileVersion.doPrivileged(VersionLocator.Resolver.INSTANCE);
    }

    protected static interface VersionLocator {
        public static final String EARLY_ACCESS = "-ea";
        public static final String INTERNAL = "-internal";
        public static final String JAVA_VERSION = "java.version";

        public ClassFileVersion resolve();

        @HashCodeAndEqualsPlugin.Enhance
        public static class Unresolved
        implements VersionLocator {
            private final String message;

            /*
             * WARNING - void declaration
             */
            protected Unresolved(String message) {
                void var1_1;
                this.message = var1_1;
            }

            public ClassFileVersion resolve() {
                throw new IllegalStateException("Failed to resolve the class file version of the current VM: " + this.message);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.message.equals(((Unresolved)object).message);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.message.hashCode();
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class Resolved
        implements VersionLocator {
            private final ClassFileVersion classFileVersion;

            /*
             * WARNING - void declaration
             */
            protected Resolved(ClassFileVersion classFileVersion) {
                void var1_1;
                this.classFileVersion = var1_1;
            }

            public ClassFileVersion resolve() {
                return this.classFileVersion;
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.classFileVersion.equals(((Resolved)object).classFileVersion);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.classFileVersion.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Resolver implements PrivilegedAction<VersionLocator>
        {
            INSTANCE;


            /*
             * WARNING - void declaration
             */
            @Override
            @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback.")
            public final VersionLocator run() {
                try {
                    Method method;
                    Class<?> type = Class.forName(Runtime.class.getName() + "$Version");
                    try {
                        method = type.getMethod("feature", new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        method = type.getMethod("major", new Class[0]);
                    }
                    return new Resolved(ClassFileVersion.ofJavaVersion((Integer)method.invoke(Runtime.class.getMethod("version", new Class[0]).invoke(null, new Object[0]), new Object[0])));
                }
                catch (Throwable throwable) {
                    try {
                        void var1_2;
                        String versionString = System.getProperty(VersionLocator.JAVA_VERSION);
                        if (versionString == null) {
                            throw new IllegalStateException("Java version property is not set");
                        }
                        if (versionString.equals("0")) {
                            return new Resolved(JAVA_V6);
                        }
                        if (versionString.endsWith(VersionLocator.EARLY_ACCESS)) {
                            versionString = versionString.substring(0, versionString.length() - 3);
                        } else if (versionString.endsWith(VersionLocator.INTERNAL)) {
                            versionString = versionString.substring(0, versionString.length() - 9);
                        }
                        int[] versionIndex = new int[]{-1, 0, 0};
                        for (int index = 1; index < 3; ++index) {
                            versionIndex[index] = versionString.indexOf(46, versionIndex[index - 1] + 1);
                            if (versionIndex[index] != -1) continue;
                            throw new IllegalStateException("This JVM's version string does not seem to be valid: " + versionString);
                        }
                        return new Resolved(ClassFileVersion.ofJavaVersion(Integer.parseInt(versionString.substring(versionIndex[1] + 1, (int)var1_2[2]))));
                    }
                    catch (Throwable throwable2) {
                        void var2_5;
                        return new Unresolved(var2_5.getMessage());
                    }
                }
            }
        }
    }
}

