/*
 * Decompiled with CFR 0.152.
 */
package com.nfeld.jsonpathkt;

import com.nfeld.jsonpathkt.tokens.ArrayAccessorToken;
import com.nfeld.jsonpathkt.tokens.ArrayLengthBasedRangeAccessorToken;
import com.nfeld.jsonpathkt.tokens.DeepScanArrayAccessorToken;
import com.nfeld.jsonpathkt.tokens.DeepScanLengthBasedArrayAccessorToken;
import com.nfeld.jsonpathkt.tokens.DeepScanObjectAccessorToken;
import com.nfeld.jsonpathkt.tokens.DeepScanWildcardToken;
import com.nfeld.jsonpathkt.tokens.MultiArrayAccessorToken;
import com.nfeld.jsonpathkt.tokens.MultiObjectAccessorToken;
import com.nfeld.jsonpathkt.tokens.ObjectAccessorToken;
import com.nfeld.jsonpathkt.tokens.Token;
import com.nfeld.jsonpathkt.tokens.WildcardToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\r\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000f\u0010\u0010"}, d2={"Lcom/nfeld/jsonpathkt/PathCompiler;", "", "<init>", "()V", "", "path", "", "Lcom/nfeld/jsonpathkt/tokens/Token;", "compile", "(Ljava/lang/String;)Ljava/util/List;", "", "openingIndex", "closingIndex", "compileBracket", "(Ljava/lang/String;II)Lcom/nfeld/jsonpathkt/tokens/Token;", "findMatchingClosingBracket", "(Ljava/lang/String;I)I"})
@SourceDebugExtension(value={"SMAP\nPathCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathCompiler.kt\ncom/nfeld/jsonpathkt/PathCompiler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,366:1\n1#2:367\n1549#3:368\n1620#3,3:369\n*S KotlinDebug\n*F\n+ 1 PathCompiler.kt\ncom/nfeld/jsonpathkt/PathCompiler\n*L\n354#1:368\n354#1:369,3\n*E\n"})
public final class PathCompiler {
    public static final PathCompiler INSTANCE = new PathCompiler();

    private PathCompiler() {
    }

    /*
     * WARNING - void declaration
     */
    public final List<Token> compile(String path) throws IllegalArgumentException, IllegalStateException {
        void var2_4;
        int i2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!(!StringsKt.isBlank((CharSequence)path))) {
            String string = "Path cannot be empty";
            throw new IllegalArgumentException(string.toString());
        }
        List tokens = new ArrayList();
        Ref.BooleanRef isDeepScan = new Ref.BooleanRef();
        Ref.BooleanRef isWildcard = new Ref.BooleanRef();
        StringBuilder keyBuilder = new StringBuilder();
        int len = path.length();
        Character c = StringsKt.firstOrNull((CharSequence)path);
        int n = i2 = c != null && c.charValue() == '$' ? 1 : 0;
        while (i2 < len) {
            int n2;
            char c2 = path.charAt(i2);
            Character next = StringsKt.getOrNull((CharSequence)path, (int)(i2 + 1));
            char c3 = c2;
            if (c3 == '*') {
                isWildcard.element = true;
            } else if (c3 == '.') {
                if (((CharSequence)keyBuilder).length() > 0 || isWildcard.element) {
                    PathCompiler.compile$addCurrentToken(keyBuilder, isDeepScan, isWildcard, tokens);
                    PathCompiler.compile$resetForNextToken(isDeepScan, isWildcard, keyBuilder);
                }
                if ((c2 = next) != null && c2.charValue() == '.') {
                    isDeepScan.element = true;
                    ++i2;
                } else {
                    Character c4 = c2;
                    if (c4 != null && c4.charValue() == '*') {
                        isWildcard.element = true;
                        ++i2;
                    } else if (c2 == null) {
                        throw new IllegalArgumentException("Unexpected ending with dot");
                    }
                }
            } else if (c3 == '[') {
                int closingBracketIndex;
                if (((CharSequence)keyBuilder).length() > 0 || isWildcard.element) {
                    PathCompiler.compile$addCurrentToken(keyBuilder, isDeepScan, isWildcard, tokens);
                    PathCompiler.compile$resetForNextToken(isDeepScan, isWildcard, keyBuilder);
                }
                if (!((closingBracketIndex = this.findMatchingClosingBracket(path, i2)) > i2 + 1)) {
                    String i2 = "Expecting closing array bracket with a value inside";
                    throw new IllegalArgumentException(i2.toString());
                }
                Token token = this.compileBracket(path, i2, closingBracketIndex);
                if (isDeepScan.element) {
                    Token token2 = token;
                    if ((token2 instanceof WildcardToken ? (Token)DeepScanWildcardToken.INSTANCE : (token2 instanceof ObjectAccessorToken ? (Token)new DeepScanObjectAccessorToken(CollectionsKt.listOf((Object)((ObjectAccessorToken)token).getKey())) : (token2 instanceof MultiObjectAccessorToken ? (Token)new DeepScanObjectAccessorToken(((MultiObjectAccessorToken)token).getKeys()) : (token2 instanceof ArrayAccessorToken ? (Token)new DeepScanArrayAccessorToken(CollectionsKt.listOf((Object)((ArrayAccessorToken)token).getIndex())) : (token2 instanceof MultiArrayAccessorToken ? (Token)new DeepScanArrayAccessorToken(((MultiArrayAccessorToken)token).getIndices()) : (token = token2 instanceof ArrayLengthBasedRangeAccessorToken ? (Token)new DeepScanLengthBasedArrayAccessorToken(((ArrayLengthBasedRangeAccessorToken)token).getStartIndex(), ((ArrayLengthBasedRangeAccessorToken)token).getEndIndex(), ((ArrayLengthBasedRangeAccessorToken)token).getOffsetFromEnd()) : null)))))) != null) {
                        Token it;
                        it = it;
                        tokens.add(it);
                    }
                    PathCompiler.compile$resetForNextToken(isDeepScan, isWildcard, keyBuilder);
                } else {
                    void var7_10;
                    tokens.add(var7_10);
                }
                n2 = closingBracketIndex;
            } else {
                void var8_11;
                keyBuilder.append((char)var8_11);
            }
            ++n2;
        }
        if (((CharSequence)keyBuilder).length() > 0 || isWildcard.element) {
            void var3_3;
            PathCompiler.compile$addCurrentToken(keyBuilder, (Ref.BooleanRef)var3_3, isWildcard, tokens);
        }
        return CollectionsKt.toList((Iterable)((Iterable)var2_4));
    }

    public final int findMatchingClosingBracket(String path, int openingIndex) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean isQuoteOpened = false;
        boolean isSingleQuote = false;
        int len = path.length();
        for (int i = openingIndex + 1; i < len; ++i) {
            Character next;
            block9: {
                block8: {
                    char c = path.charAt(i);
                    next = StringsKt.getOrNull((CharSequence)path, (int)(i + 1));
                    if (c == '\'' || c == '\"') {
                        if (!isQuoteOpened) {
                            isQuoteOpened = true;
                            isSingleQuote = c == '\'';
                            continue;
                        }
                        if (isSingleQuote && c == '\'') {
                            isQuoteOpened = false;
                            continue;
                        }
                        if (isSingleQuote || c != '\"') continue;
                        isQuoteOpened = false;
                        continue;
                    }
                    if (c == ']' && !isQuoteOpened) {
                        return i;
                    }
                    if (c != '\\' || !isQuoteOpened) continue;
                    Character c2 = next;
                    if (c2 != null && c2.charValue() == '\'') break block8;
                    Character c3 = next;
                    if (c3 != null && c3.charValue() == '\\') break block8;
                    Character c4 = next;
                    if (c4 == null || c4.charValue() != '\"') break block9;
                }
                ++i;
                continue;
            }
            if (next != null) continue;
            throw new IllegalArgumentException("Unexpected char at end of path");
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final Token compileBracket(String path, int openingIndex, int closingIndex) {
        Token token;
        void offsetFromEnd2;
        int start;
        Token token2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Ref.BooleanRef isObjectAccessor = new Ref.BooleanRef();
        Ref.BooleanRef isNegativeArrayAccessor = new Ref.BooleanRef();
        Ref.BooleanRef isQuoteOpened = new Ref.BooleanRef();
        boolean isSingleQuote = false;
        boolean hasStartColon = false;
        boolean hasEndColon = false;
        boolean isRange = false;
        boolean isWildcard = false;
        Ref.IntRef i = new Ref.IntRef();
        new Ref.IntRef().element = openingIndex + 1;
        Ref.CharRef lastChar = new Ref.CharRef();
        new Ref.CharRef().element = path.charAt(openingIndex);
        List keys = new ArrayList();
        StringBuilder keyBuilder = new StringBuilder();
        while (i.element < closingIndex) {
            char c = path.charAt(i.element);
            boolean setLastChar = true;
            if (c == ' ' && !isQuoteOpened.element) {
                setLastChar = false;
            } else if (c == ':' && !isQuoteOpened.element) {
                if (PathCompiler.compileBracket$isBracketBefore(lastChar) && PathCompiler.compileBracket$isBracketNext(i, closingIndex, path, isQuoteOpened)) {
                    hasStartColon = true;
                    hasEndColon = true;
                } else if (PathCompiler.compileBracket$isBracketBefore(lastChar)) {
                    hasStartColon = true;
                } else if (PathCompiler.compileBracket$isBracketNext(i, closingIndex, path, isQuoteOpened)) {
                    hasEndColon = true;
                    PathCompiler.compileBracket$buildAndAddKey(keyBuilder, isObjectAccessor, isNegativeArrayAccessor, keys);
                } else if (((CharSequence)keyBuilder).length() > 0) {
                    PathCompiler.compileBracket$buildAndAddKey(keyBuilder, isObjectAccessor, isNegativeArrayAccessor, keys);
                    isRange = true;
                }
            } else if (c == '-' && !isObjectAccessor.element) {
                isNegativeArrayAccessor.element = true;
            } else if (c == ',' && !isQuoteOpened.element) {
                if (!isObjectAccessor.element && ((CharSequence)keyBuilder).length() > 0) {
                    PathCompiler.compileBracket$buildAndAddKey(keyBuilder, isObjectAccessor, isNegativeArrayAccessor, keys);
                }
            } else if (c == '\\' && isQuoteOpened.element) {
                char nextChar = path.charAt(i.element + 1);
                if ((nextChar == '\\' ? true : nextChar == '\'') ? true : nextChar == '\"') {
                    keyBuilder.append(nextChar);
                    ++i.element;
                    int cfr_ignored_0 = i.element;
                }
            } else if (c == '\'' && isQuoteOpened.element && isSingleQuote) {
                PathCompiler.compileBracket$buildAndAddKey(keyBuilder, isObjectAccessor, isNegativeArrayAccessor, keys);
                isQuoteOpened.element = false;
            } else if (c == '\"' && isQuoteOpened.element && !isSingleQuote) {
                PathCompiler.compileBracket$buildAndAddKey(keyBuilder, isObjectAccessor, isNegativeArrayAccessor, keys);
                isQuoteOpened.element = false;
            } else if (!(c != '\'' && c != '\"' || isNegativeArrayAccessor.element || isQuoteOpened.element)) {
                isQuoteOpened.element = true;
                isSingleQuote = c == '\'';
                isObjectAccessor.element = true;
            } else if (c == '*' && !isQuoteOpened.element && PathCompiler.compileBracket$isBracketBefore(lastChar) && PathCompiler.compileBracket$isBracketNext(i, closingIndex, path, isQuoteOpened)) {
                isWildcard = true;
            } else if (Character.isDigit(c) && !isQuoteOpened.element || isObjectAccessor.element && isQuoteOpened.element) {
                keyBuilder.append(c);
            } else {
                throw new IllegalArgumentException("Unexpected char, char=" + c + ", index=" + i.element);
            }
            ++i.element;
            int cfr_ignored_1 = i.element;
            if (!setLastChar) continue;
            lastChar.element = c;
        }
        if (((CharSequence)keyBuilder).length() > 0) {
            PathCompiler.compileBracket$buildAndAddKey(keyBuilder, isObjectAccessor, isNegativeArrayAccessor, keys);
        }
        if (isObjectAccessor.element) {
            if (keys.size() > 1) {
                token2 = new MultiObjectAccessorToken(keys);
            } else {
                ObjectAccessorToken objectAccessorToken;
                String string = (String)CollectionsKt.firstOrNull((List)keys);
                if (string != null) {
                    String it = string;
                    objectAccessorToken = new ObjectAccessorToken(it);
                } else {
                    objectAccessorToken = null;
                }
                token2 = objectAccessorToken;
            }
        } else if (isWildcard) {
            token2 = WildcardToken.INSTANCE;
        } else if (isRange) {
            boolean isEndNegative;
            start = Integer.parseInt((String)keys.get(0), CharsKt.checkRadix((int)10));
            int end = Integer.parseInt((String)keys.get(1), CharsKt.checkRadix((int)10));
            boolean bl = isEndNegative = end < 0;
            if (start < 0 || isEndNegative) {
                int offsetFromEnd2 = isEndNegative ? end : 0;
                Integer endIndex = !isEndNegative ? Integer.valueOf(end) : null;
                token2 = new ArrayLengthBasedRangeAccessorToken(start, endIndex, offsetFromEnd2);
            } else {
                token2 = new MultiArrayAccessorToken(CollectionsKt.toList((Iterable)((Iterable)new IntRange(start, end - 1))));
            }
        } else if (hasStartColon && hasEndColon) {
            token2 = new ArrayLengthBasedRangeAccessorToken(0, null, 0);
        } else if (hasStartColon) {
            int end = Integer.parseInt((String)offsetFromEnd2.get(0), CharsKt.checkRadix((int)10));
            token2 = end < 0 ? (Token)new ArrayLengthBasedRangeAccessorToken(0, null, end) : (Token)new MultiArrayAccessorToken(CollectionsKt.toList((Iterable)((Iterable)new IntRange(0, end - 1))));
        } else if (hasEndColon) {
            start = Integer.parseInt((String)offsetFromEnd2.get(0), CharsKt.checkRadix((int)10));
            token2 = new ArrayLengthBasedRangeAccessorToken(start, null, 0, 6, null);
        } else if (offsetFromEnd2.size() == 1) {
            token2 = new ArrayAccessorToken(Integer.parseInt((String)offsetFromEnd2.get(0), CharsKt.checkRadix((int)10)));
        } else if (offsetFromEnd2.size() > 1) {
            void var2_5;
            Object object;
            Iterable $this$map$iv;
            Iterable endIndex = $this$map$iv = (Iterable)offsetFromEnd2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            object = object.iterator();
            while (object.hasNext()) {
                void var3_8;
                Object item$iv$iv = object.next();
                item$iv$iv = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                collection.add(Integer.parseInt((String)var3_8, CharsKt.checkRadix((int)10)));
            }
            object = (List)var2_5;
            token2 = new MultiArrayAccessorToken((List<Integer>)object);
        } else {
            token2 = token = null;
        }
        if (token2 != null) {
            Token token3 = token;
            return token3;
        }
        throw new IllegalArgumentException("Not a valid path");
    }

    /*
     * WARNING - void declaration
     */
    private static final void compile$resetForNextToken(Ref.BooleanRef isDeepScan, Ref.BooleanRef isWildcard, StringBuilder keyBuilder) {
        void var2_2;
        isDeepScan.element = false;
        var1_1.element = false;
        StringsKt.clear((StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void compile$addCurrentToken(StringBuilder keyBuilder, Ref.BooleanRef isDeepScan, Ref.BooleanRef isWildcard, List<Token> tokens) {
        String string;
        void var3_3;
        void var2_2;
        void var1_1;
        String string2 = keyBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String key = string2;
        String token = isDeepScan.element && isWildcard.element ? (Token)DeepScanWildcardToken.INSTANCE : (var1_1.element ? (Token)new DeepScanObjectAccessorToken(CollectionsKt.listOf((Object)key)) : (var2_2.element ? (Token)WildcardToken.INSTANCE : (Token)new ObjectAccessorToken(key)));
        var3_3.add(string);
    }

    /*
     * WARNING - void declaration
     */
    private static final void compileBracket$buildAndAddKey(StringBuilder keyBuilder, Ref.BooleanRef isObjectAccessor, Ref.BooleanRef isNegativeArrayAccessor, List<String> keys) {
        StringBuilder stringBuilder;
        void var3_3;
        void var1_1;
        String string = keyBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String key = string;
        if (!var1_1.element && isNegativeArrayAccessor.element) {
            key = "-" + key;
            var2_2.element = false;
        }
        var3_3.add(key);
        StringsKt.clear((StringBuilder)stringBuilder);
    }

    private static final char compileBracket$getNextCharIgnoringWhitespace(Ref.IntRef i, int $closingIndex, String $path, Ref.BooleanRef isQuoteOpened) {
        int n = i.element + 1;
        if (n <= $closingIndex) {
            while (true) {
                char c;
                if ((c = $path.charAt(n)) != ' ' || isQuoteOpened.element) {
                    return c;
                }
                if (n == $closingIndex) break;
                ++n;
            }
        }
        throw new IllegalStateException("Shouldn't reach this point".toString());
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean compileBracket$isBracketNext(Ref.IntRef i, int $closingIndex, String $path, Ref.BooleanRef isQuoteOpened) {
        void var3_3;
        void var2_2;
        void var1_1;
        return PathCompiler.compileBracket$getNextCharIgnoringWhitespace(i, (int)var1_1, (String)var2_2, (Ref.BooleanRef)var3_3) == ']';
    }

    private static final boolean compileBracket$isBracketBefore(Ref.CharRef lastChar) {
        return lastChar.element == '[';
    }
}

