/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.core.okio;

import androidx.datastore.core.InterProcessCoordinator;
import androidx.datastore.core.Storage;
import androidx.datastore.core.StorageConnection;
import androidx.datastore.core.okio.OkioSerializer;
import androidx.datastore.core.okio.OkioStorageConnection;
import androidx.datastore.core.okio.Synchronizer;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.FileSystem;
import okio.Path;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0007\u0018\u0000 \u001b*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002:\u0001\u001bBG\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u001a\b\u0002\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u0007\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0016\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R&\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0017R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0018R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0019R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u001a"}, d2={"Landroidx/datastore/core/okio/OkioStorage;", "T", "Landroidx/datastore/core/Storage;", "Lokio/FileSystem;", "fileSystem", "Landroidx/datastore/core/okio/OkioSerializer;", "serializer", "Lkotlin/Function2;", "Lokio/Path;", "Landroidx/datastore/core/InterProcessCoordinator;", "coordinatorProducer", "Lkotlin/Function0;", "producePath", "<init>", "(Lokio/FileSystem;Landroidx/datastore/core/okio/OkioSerializer;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function0;)V", "Landroidx/datastore/core/StorageConnection;", "createConnection", "()Landroidx/datastore/core/StorageConnection;", "canonicalPath$delegate", "Lkotlin/Lazy;", "getCanonicalPath", "()Lokio/Path;", "canonicalPath", "Lkotlin/jvm/functions/Function2;", "Lokio/FileSystem;", "Lkotlin/jvm/functions/Function0;", "Landroidx/datastore/core/okio/OkioSerializer;", "Companion"})
@SourceDebugExtension(value={"SMAP\nOkioStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkioStorage.kt\nandroidx/datastore/core/okio/OkioStorage\n+ 2 Atomic.jvm.kt\nandroidx/datastore/core/okio/Synchronizer\n*L\n1#1,230:1\n49#2,2:231\n*S KotlinDebug\n*F\n+ 1 OkioStorage.kt\nandroidx/datastore/core/okio/OkioStorage\n*L\n64#1:231,2\n*E\n"})
public final class OkioStorage<T>
implements Storage<T> {
    public static final Companion Companion = new Companion(null);
    private final FileSystem fileSystem;
    private final OkioSerializer<T> serializer;
    private final Function2<Path, FileSystem, InterProcessCoordinator> coordinatorProducer;
    private final Function0<Path> producePath;
    private final Lazy canonicalPath$delegate;
    private static final Set<String> activeFiles = new LinkedHashSet();
    private static final Synchronizer activeFilesLock = new Synchronizer();

    /*
     * WARNING - void declaration
     */
    public OkioStorage(FileSystem fileSystem, OkioSerializer<T> serializer, Function2<? super Path, ? super FileSystem, ? extends InterProcessCoordinator> coordinatorProducer, Function0<Path> producePath) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter(coordinatorProducer, (String)"coordinatorProducer");
        Intrinsics.checkNotNullParameter(producePath, (String)"producePath");
        this.fileSystem = var1_1;
        this.serializer = var2_2;
        this.coordinatorProducer = var3_3;
        this.producePath = producePath;
        this.canonicalPath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Path>(this){
            final /* synthetic */ OkioStorage<T> this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final Path invoke() {
                void var1_1;
                Object path = (Path)OkioStorage.access$getProducePath$p(this.this$0).invoke();
                boolean bl = path.isAbsolute();
                OkioStorage<T> okioStorage = this.this$0;
                if (!bl) {
                    path = "OkioStorage requires absolute paths, but did not get an absolute path from producePath = " + OkioStorage.access$getProducePath$p(okioStorage) + ", instead got " + path;
                    throw new IllegalStateException(path.toString());
                }
                return var1_1.normalized();
            }
        }));
    }

    public /* synthetic */ OkioStorage(FileSystem fileSystem, OkioSerializer okioSerializer, Function2 function2, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function2 = 1.INSTANCE;
        }
        this(fileSystem, okioSerializer, (Function2<? super Path, ? super FileSystem, ? extends InterProcessCoordinator>)function2, (Function0<Path>)function0);
    }

    private final Path getCanonicalPath() {
        Lazy lazy = this.canonicalPath$delegate;
        return (Path)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final StorageConnection<T> createConnection() {
        String path = this.getCanonicalPath().toString();
        Synchronizer synchronizer = activeFilesLock;
        Synchronizer synchronizer2 = synchronizer;
        synchronizer2 = synchronizer;
        synchronized (synchronizer) {
            void var1_1;
            if (!(!activeFiles.contains(path))) {
                path = "There are multiple DataStores active for the same file: " + path + ". You should either maintain your DataStore as a singleton or confirm that there is no two DataStore's active on the same file (by confirming that the scope is cancelled).";
                throw new IllegalStateException(path.toString());
            }
            activeFiles.add((String)var1_1);
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return new OkioStorageConnection<T>(this.fileSystem, this.getCanonicalPath(), this.serializer, (InterProcessCoordinator)this.coordinatorProducer.invoke((Object)this.getCanonicalPath(), (Object)this.fileSystem), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ OkioStorage<T> this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    super(0);
                }

                public final void invoke() {
                    Synchronizer synchronizer = OkioStorage.Companion.getActiveFilesLock();
                    OkioStorage<T> okioStorage = this.this$0;
                    synchronized (synchronizer) {
                        OkioStorage.Companion.getActiveFiles$datastore_core_okio().remove(OkioStorage.access$getCanonicalPath(okioStorage).toString());
                        return;
                    }
                }
            }));
        }
    }

    public static final /* synthetic */ Path access$getCanonicalPath(OkioStorage $this) {
        return $this.getCanonicalPath();
    }

    public static final /* synthetic */ Function0 access$getProducePath$p(OkioStorage $this) {
        return $this.producePath;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e"}, d2={"Landroidx/datastore/core/okio/OkioStorage$Companion;", "", "<init>", "()V", "", "", "activeFiles", "Ljava/util/Set;", "getActiveFiles$datastore_core_okio", "()Ljava/util/Set;", "Landroidx/datastore/core/okio/Synchronizer;", "activeFilesLock", "Landroidx/datastore/core/okio/Synchronizer;", "getActiveFilesLock", "()Landroidx/datastore/core/okio/Synchronizer;"})
    public static final class Companion {
        private Companion() {
        }

        public final Set<String> getActiveFiles$datastore_core_okio() {
            return activeFiles;
        }

        public final Synchronizer getActiveFilesLock() {
            return activeFilesLock;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

