/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.j2objc.annotations.Weak;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;

final class CollectSpliterators {
    /*
     * WARNING - void declaration
     */
    static <InElementT, OutElementT> Spliterator<OutElementT> flatMap(Spliterator<InElementT> fromSpliterator, Function<? super InElementT, Spliterator<OutElementT>> function, int topCharacteristics, long topSize) {
        void var3_3;
        void var2_2;
        void var1_1;
        Spliterator<InElementT> spliterator;
        Preconditions.checkArgument((topCharacteristics & 0x4000) == 0, "flatMap does not support SUBSIZED characteristic");
        Preconditions.checkArgument((topCharacteristics & 4) == 0, "flatMap does not support SORTED characteristic");
        Preconditions.checkNotNull(fromSpliterator);
        Preconditions.checkNotNull(function);
        return new FlatMapSpliteratorOfObject(null, spliterator, var1_1, (int)var2_2, (long)var3_3);
    }

    static final class FlatMapSpliteratorOfObject<InElementT, OutElementT>
    extends FlatMapSpliterator<InElementT, OutElementT, Spliterator<OutElementT>> {
        /*
         * WARNING - void declaration
         */
        FlatMapSpliteratorOfObject(Spliterator<OutElementT> prefix, Spliterator<InElementT> from, Function<? super InElementT, Spliterator<OutElementT>> function, int characteristics, long estimatedSize) {
            super(var1_1, var2_2, var3_3, FlatMapSpliteratorOfObject::new, characteristics, estimatedSize);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }

    static abstract class FlatMapSpliterator<InElementT, OutElementT, OutSpliteratorT extends Spliterator<OutElementT>>
    implements Spliterator<OutElementT> {
        @Weak
        OutSpliteratorT prefix;
        final Spliterator<InElementT> from;
        final Function<? super InElementT, OutSpliteratorT> function;
        final Factory<InElementT, OutSpliteratorT> factory;
        int characteristics;
        long estimatedSize;

        /*
         * WARNING - void declaration
         */
        FlatMapSpliterator(OutSpliteratorT prefix, Spliterator<InElementT> from, Function<? super InElementT, OutSpliteratorT> function, Factory<InElementT, OutSpliteratorT> factory, int characteristics, long estimatedSize) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.prefix = var1_1;
            this.from = var2_2;
            this.function = var3_3;
            this.factory = factory;
            this.characteristics = characteristics;
            this.estimatedSize = estimatedSize;
        }

        @Override
        public boolean tryAdvance(Consumer<? super OutElementT> action) {
            do {
                if (this.prefix != null && this.prefix.tryAdvance(action)) {
                    if (this.estimatedSize != Long.MAX_VALUE) {
                        --this.estimatedSize;
                    }
                    return true;
                }
                this.prefix = null;
            } while (this.from.tryAdvance((? super T fromElement) -> {
                void var1_1;
                this.prefix = (Spliterator)this.function.apply(var1_1);
            }));
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void forEachRemaining(Consumer<? super OutElementT> action) {
            void var1_1;
            if (this.prefix != null) {
                this.prefix.forEachRemaining(action);
                this.prefix = null;
            }
            this.from.forEachRemaining(arg_0 -> this.lambda$forEachRemaining$1((Consumer)var1_1, arg_0));
            this.estimatedSize = 0L;
        }

        /*
         * WARNING - void declaration
         */
        public final OutSpliteratorT trySplit() {
            Spliterator<InElementT> fromSplit = this.from.trySplit();
            if (fromSplit != null) {
                void var1_1;
                void var3_4;
                int splitCharacteristics = this.characteristics & 0xFFFFFFBF;
                long estSplitSize = this.estimateSize();
                if (estSplitSize < Long.MAX_VALUE) {
                    this.estimatedSize -= (estSplitSize /= 2L);
                    this.characteristics = splitCharacteristics;
                }
                OutSpliteratorT result = this.factory.newFlatMapSpliterator(this.prefix, fromSplit, this.function, splitCharacteristics, (long)var3_4);
                this.prefix = null;
                return var1_1;
            }
            if (this.prefix != null) {
                void var2_3;
                OutSpliteratorT result = this.prefix;
                this.prefix = null;
                return var2_3;
            }
            return null;
        }

        @Override
        public final long estimateSize() {
            if (this.prefix != null) {
                this.estimatedSize = Math.max(this.estimatedSize, this.prefix.estimateSize());
            }
            return Math.max(this.estimatedSize, 0L);
        }

        @Override
        public final int characteristics() {
            return this.characteristics;
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ void lambda$forEachRemaining$1(Consumer action, Object fromElement) {
            Spliterator elements = (Spliterator)this.function.apply(fromElement);
            if (elements != null) {
                void var1_1;
                void var2_2;
                var2_2.forEachRemaining(var1_1);
            }
        }

        static interface Factory<InElementT, OutSpliteratorT extends Spliterator<?>> {
            public OutSpliteratorT newFlatMapSpliterator(OutSpliteratorT var1, Spliterator<InElementT> var2, Function<? super InElementT, OutSpliteratorT> var3, int var4, long var5);
        }
    }
}

