/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentRange;
import io.ktor.http.RangesSpecifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a'\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0005*\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u001f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u0005*\b\u0012\u0004\u0012\u00020\t0\u0005H\u0000\u00a2\u0006\u0004\b\f\u0010\r"}, d2={"", "rangeSpec", "Lio/ktor/http/RangesSpecifier;", "parseRangesSpecifier", "(Ljava/lang/String;)Lio/ktor/http/RangesSpecifier;", "", "Lio/ktor/http/ContentRange;", "", "contentLength", "Lkotlin/ranges/LongRange;", "toLongRanges", "(Ljava/util/List;J)Ljava/util/List;", "mergeRangesKeepOrder", "(Ljava/util/List;)Ljava/util/List;"})
@SourceDebugExtension(value={"SMAP\nRanges.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Ranges.kt\nio/ktor/http/RangesKt\n+ 2 Text.kt\nio/ktor/util/TextKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n41#2,3:140\n41#2,3:146\n1557#3:143\n1628#3,2:144\n1630#3:149\n1557#3:150\n1628#3,3:151\n827#3:154\n855#3,2:155\n1053#3:157\n1797#3,3:158\n*S KotlinDebug\n*F\n+ 1 Ranges.kt\nio/ktor/http/RangesKt\n*L\n81#1:140,3\n86#1:146,3\n82#1:143\n82#1:144,2\n82#1:149\n105#1:150\n105#1:151,3\n111#1:154\n111#1:155,2\n115#1:157\n115#1:158,3\n*E\n"})
public final class RangesKt {
    /*
     * WARNING - void declaration
     */
    public static final RangesSpecifier parseRangesSpecifier(String rangeSpec) {
        Intrinsics.checkNotNullParameter((Object)rangeSpec, (String)"rangeSpec");
        try {
            List list;
            List $this$mapTo$iv$iv;
            void $this$chomp$iv;
            String string = rangeSpec;
            List separator$iv = "=";
            int idx$iv22 = StringsKt.indexOf$default((CharSequence)((CharSequence)$this$chomp$iv), (String)((Object)separator$iv), (int)0, (boolean)false, (int)6, null);
            if (idx$iv22 == -1) {
                return null;
            }
            String string2 = $this$chomp$iv.substring(0, idx$iv22);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String string3 = $this$chomp$iv.substring(idx$iv22 + ((String)((Object)separator$iv)).length());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            separator$iv = TuplesKt.to((Object)string2, (Object)string3);
            String unit = (String)separator$iv.component1();
            separator$iv = (String)separator$iv.component2();
            char[] cArray = new char[1];
            char[] idx$iv22 = cArray;
            cArray[0] = 44;
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)((CharSequence)((Object)separator$iv)), (char[])idx$iv22, (boolean)false, (int)0, (int)6, null);
            separator$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $this$mapTo$iv$iv = $this$mapTo$iv$iv.iterator();
            while ($this$mapTo$iv$iv.hasNext()) {
                ContentRange contentRange;
                void it;
                Object item$iv$iv = $this$mapTo$iv$iv.next();
                item$iv$iv = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                if (StringsKt.startsWith$default((String)it, (String)"-", (boolean)false, (int)2, null)) {
                    contentRange = new ContentRange.Suffix(Long.parseLong(StringsKt.removePrefix((String)it, (CharSequence)"-")));
                } else {
                    void var3_4;
                    Pair pair;
                    void $this$chomp$iv2;
                    String separator$iv2 = "-";
                    int idx$iv = StringsKt.indexOf$default((CharSequence)((CharSequence)$this$chomp$iv2), (String)separator$iv2, (int)0, (boolean)false, (int)6, null);
                    if (idx$iv == -1) {
                        pair = TuplesKt.to((Object)"", (Object)"");
                    } else {
                        String string4 = $this$chomp$iv2.substring(0, idx$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                        String string5 = $this$chomp$iv2.substring(idx$iv + separator$iv2.length());
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                        pair = TuplesKt.to((Object)string4, (Object)string5);
                    }
                    separator$iv2 = pair;
                    String from = (String)pair.component1();
                    String to = (String)separator$iv2.component2();
                    contentRange = ((CharSequence)to).length() > 0 ? (ContentRange)new ContentRange.Bounded(Long.parseLong(from), Long.parseLong(to)) : (ContentRange)new ContentRange.TailFrom(Long.parseLong((String)var3_4));
                }
                collection.add(contentRange);
            }
            List allRanges = (List)destination$iv$iv;
            if (allRanges.isEmpty() || ((CharSequence)unit).length() == 0) {
                return null;
            }
            RangesSpecifier spec = new RangesSpecifier(string, (List<? extends ContentRange>)list);
            if (RangesSpecifier.isValid$default(spec, null, 1, null)) {
                void var2_3;
                return var2_3;
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final List<LongRange> toLongRanges(List<? extends ContentRange> $this$toLongRanges, long contentLength) {
        Iterable<ContentRange> iterable;
        ContentRange contentRange;
        Object $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toLongRanges, (String)"<this>");
        Iterable<ContentRange> $this$map$iv = $this$toLongRanges;
        Object object = $this$map$iv;
        Iterable<ContentRange> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        $this$mapTo$iv$iv = $this$mapTo$iv$iv.iterator();
        while ($this$mapTo$iv$iv.hasNext()) {
            LongRange longRange;
            void it;
            Object item$iv$iv = $this$mapTo$iv$iv.next();
            contentRange = (ContentRange)item$iv$iv;
            Iterable<ContentRange> iterable2 = destination$iv$iv;
            item$iv$iv = it;
            if (item$iv$iv instanceof ContentRange.Bounded) {
                longRange = new LongRange(((ContentRange.Bounded)it).getFrom(), kotlin.ranges.RangesKt.coerceAtMost((long)((ContentRange.Bounded)it).getTo(), (long)(contentLength - 1L)));
            } else if (item$iv$iv instanceof ContentRange.TailFrom) {
                longRange = kotlin.ranges.RangesKt.until((long)((ContentRange.TailFrom)it).getFrom(), (long)contentLength);
            } else if (item$iv$iv instanceof ContentRange.Suffix) {
                longRange = kotlin.ranges.RangesKt.until((long)kotlin.ranges.RangesKt.coerceAtLeast((long)(contentLength - ((ContentRange.Suffix)it).getLastCount()), (long)0L), (long)contentLength);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            iterable2.add((ContentRange)longRange);
        }
        destination$iv$iv = destination$iv$iv;
        $this$mapTo$iv$iv = destination$iv$iv;
        destination$iv$iv = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            Object element$iv$iv = object.next();
            contentRange = (LongRange)element$iv$iv;
            if (contentRange.isEmpty()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    public static final List<LongRange> mergeRangesKeepOrder(List<LongRange> $this$mergeRangesKeepOrder) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter($this$mergeRangesKeepOrder, (String)"<this>");
        Iterable iterable = $this$mergeRangesKeepOrder;
        iterable = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)new Comparator(){

            /*
             * WARNING - void declaration
             */
            public final int compare(T a, T b) {
                void var1_1;
                Comparable comparable;
                a = (LongRange)a;
                LongRange it = (LongRange)comparable;
                comparable = Long.valueOf(a.getFirst());
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Long.valueOf(var1_1.getFirst()));
            }
        });
        Object object = new ArrayList<LongRange>($this$mergeRangesKeepOrder.size());
        ArrayList<LongRange> accumulator$iv = object;
        for (Object element$iv : $this$fold$iv) {
            LongRange range = (LongRange)element$iv;
            ArrayList<LongRange> acc = accumulator$iv;
            if (acc.isEmpty()) {
                acc.add(range);
            } else if (((LongRange)CollectionsKt.last((List)acc)).getLast() < range.getFirst() - 1L) {
                acc.add(range);
            } else {
                LongRange last = (LongRange)CollectionsKt.last((List)acc);
                ArrayList<LongRange> arrayList = acc;
                arrayList.set(CollectionsKt.getLastIndex((List)arrayList), new LongRange(last.getFirst(), Math.max(last.getLast(), range.getLast())));
            }
            accumulator$iv = acc;
        }
        ArrayList<LongRange> sortedMerged = accumulator$iv;
        LongRange[] result = new LongRange[$this$mergeRangesKeepOrder.size()];
        Iterator iterator = ((ArrayList)object).iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        object = iterator;
        block1: while (object.hasNext()) {
            Object e = object.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            LongRange range = (LongRange)e;
            int n = ((Collection)$this$mergeRangesKeepOrder).size();
            for (int i = 0; i < n; ++i) {
                if (!io.ktor.util.RangesKt.contains((LongRange)range, (LongRange)$this$mergeRangesKeepOrder.get(i))) continue;
                result[i] = range;
                continue block1;
            }
        }
        return ArraysKt.filterNotNull((Object[])iterable);
    }
}

