/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.MimesKt;
import io.ktor.util.CharsetKt;
import io.ktor.util.CollectionsKt;
import io.ktor.util.TextKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\f\u001a\u0019\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u0019\u0010\u0007\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0007\u0010\u0005\u001a\u001f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\b*\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0004\b\t\u0010\n\u001a\u001f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\b*\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0001\u00a2\u0006\u0004\b\f\u0010\n\u001a\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\b*\u00020\u0003\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u0019\u0010\u000f\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00030\bH\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u0013\u0010\u0012\u001a\u00020\u0011*\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u0013\u0010\u0014\u001a\u00020\u0003*\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001aC\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\b0\u001a\"\u0004\b\u0000\u0010\u0016\"\u0004\b\u0001\u0010\u0017*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00190\u0018H\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a\u0013\u0010\u001d\u001a\u00020\u0003*\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001e\"-\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"-\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\b0\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010 \u001a\u0004\b%\u0010\""}, d2={"Lio/ktor/http/ContentType$Companion;", "", "extension", "Lio/ktor/http/ContentType;", "defaultForFileExtension", "(Lio/ktor/http/ContentType$Companion;Ljava/lang/String;)Lio/ktor/http/ContentType;", "path", "defaultForFilePath", "", "fromFilePath", "(Lio/ktor/http/ContentType$Companion;Ljava/lang/String;)Ljava/util/List;", "ext", "fromFileExtension", "fileExtensions", "(Lio/ktor/http/ContentType;)Ljava/util/List;", "selectDefault", "(Ljava/util/List;)Lio/ktor/http/ContentType;", "", "matchApplicationTypeWithCharset", "(Lio/ktor/http/ContentType;)Z", "withCharsetUTF8IfNeeded", "(Lio/ktor/http/ContentType;)Lio/ktor/http/ContentType;", "A", "B", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "", "groupByPairs", "(Lkotlin/sequences/Sequence;)Ljava/util/Map;", "toContentType", "(Ljava/lang/String;)Lio/ktor/http/ContentType;", "contentTypesByExtensions$delegate", "Lkotlin/Lazy;", "getContentTypesByExtensions", "()Ljava/util/Map;", "contentTypesByExtensions", "extensionsByContentType$delegate", "getExtensionsByContentType", "extensionsByContentType"})
@SourceDebugExtension(value={"SMAP\nFileContentType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileContentType.kt\nio/ktor/http/FileContentTypeKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n992#2:115\n1021#2,3:116\n1024#2,3:126\n381#3,7:119\n462#3:129\n412#3:130\n1246#4,2:131\n1557#4:133\n1628#4,3:134\n1249#4:137\n1#5:138\n*S KotlinDebug\n*F\n+ 1 FileContentType.kt\nio/ktor/http/FileContentTypeKt\n*L\n106#1:115\n106#1:116,3\n106#1:126,3\n106#1:119,7\n107#1:129\n107#1:130\n107#1:131,2\n107#1:133\n107#1:134,3\n107#1:137\n*E\n"})
public final class FileContentTypeKt {
    private static final Lazy contentTypesByExtensions$delegate = LazyKt.lazy(FileContentTypeKt::contentTypesByExtensions_delegate$lambda$1);
    private static final Lazy extensionsByContentType$delegate = LazyKt.lazy(FileContentTypeKt::extensionsByContentType_delegate$lambda$3);

    /*
     * WARNING - void declaration
     */
    public static final ContentType defaultForFileExtension(ContentType.Companion $this$defaultForFileExtension, String extension) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$defaultForFileExtension, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        return FileContentTypeKt.selectDefault(FileContentTypeKt.fromFileExtension(ContentType.Companion, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static final ContentType defaultForFilePath(ContentType.Companion $this$defaultForFilePath, String path) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$defaultForFilePath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return FileContentTypeKt.selectDefault(FileContentTypeKt.fromFilePath(ContentType.Companion, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static final List<ContentType> fromFilePath(ContentType.Companion $this$fromFilePath, String path) {
        ContentType.Companion companion;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$fromFilePath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        int slashIndex = StringsKt.lastIndexOfAny$default((CharSequence)path, (char[])CharsetKt.toCharArray((String)"/\\"), (int)0, (boolean)false, (int)6, null);
        int index = StringsKt.indexOf$default((CharSequence)path, (char)'.', (int)(slashIndex + 1), (boolean)false, (int)4, null);
        if (index == -1) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        String string = var1_1.substring((int)(var2_2 + true));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return FileContentTypeKt.fromFileExtension(companion, string);
    }

    /*
     * WARNING - void declaration
     */
    public static final List<ContentType> fromFileExtension(ContentType.Companion $this$fromFileExtension, String ext) {
        Intrinsics.checkNotNullParameter((Object)$this$fromFileExtension, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        Object current = TextKt.toLowerCasePreservingASCIIRules((String)StringsKt.removePrefix((String)ext, (CharSequence)"."));
        while (((CharSequence)current).length() > 0) {
            List<ContentType> type = FileContentTypeKt.getContentTypesByExtensions().get(current);
            if (type != null) {
                void var1_1;
                return var1_1;
            }
            current = StringsKt.substringAfter((String)current, (String)".", (String)"");
        }
        return kotlin.collections.CollectionsKt.emptyList();
    }

    public static final List<String> fileExtensions(ContentType $this$fileExtensions) {
        ContentType contentType;
        Intrinsics.checkNotNullParameter((Object)$this$fileExtensions, (String)"<this>");
        List list = FileContentTypeKt.getExtensionsByContentType().get($this$fileExtensions);
        if (list == null && (list = FileContentTypeKt.getExtensionsByContentType().get(contentType.withoutParameters())) == null) {
            list = kotlin.collections.CollectionsKt.emptyList();
        }
        return list;
    }

    private static final Map<String, List<ContentType>> getContentTypesByExtensions() {
        Lazy lazy = contentTypesByExtensions$delegate;
        return (Map)lazy.getValue();
    }

    private static final Map<ContentType, List<String>> getExtensionsByContentType() {
        Lazy lazy = extensionsByContentType$delegate;
        return (Map)lazy.getValue();
    }

    public static final ContentType selectDefault(List<ContentType> $this$selectDefault) {
        Object object;
        Object contentType;
        Intrinsics.checkNotNullParameter($this$selectDefault, (String)"<this>");
        Object object2 = (ContentType)kotlin.collections.CollectionsKt.firstOrNull($this$selectDefault);
        if (object2 == null) {
            object2 = contentType = ContentType.Application.INSTANCE.getOctetStream();
        }
        if (((ContentType)object2).match(ContentType.Text.INSTANCE.getAny())) {
            return FileContentTypeKt.withCharsetUTF8IfNeeded((ContentType)contentType);
        }
        if (((ContentType)contentType).match(ContentType.Image.INSTANCE.getSVG())) {
            return FileContentTypeKt.withCharsetUTF8IfNeeded((ContentType)contentType);
        }
        if (FileContentTypeKt.matchApplicationTypeWithCharset((ContentType)contentType)) {
            return FileContentTypeKt.withCharsetUTF8IfNeeded((ContentType)contentType);
        }
        return object;
    }

    private static final boolean matchApplicationTypeWithCharset(ContentType $this$matchApplicationTypeWithCharset) {
        ContentType contentType;
        if (!$this$matchApplicationTypeWithCharset.match(ContentType.Application.INSTANCE.getAny())) {
            return false;
        }
        return $this$matchApplicationTypeWithCharset.match(ContentType.Application.INSTANCE.getAtom()) || $this$matchApplicationTypeWithCharset.match(ContentType.Application.INSTANCE.getJavaScript()) || $this$matchApplicationTypeWithCharset.match(ContentType.Application.INSTANCE.getRss()) || $this$matchApplicationTypeWithCharset.match(ContentType.Application.INSTANCE.getXml()) || contentType.match(ContentType.Application.INSTANCE.getXml_Dtd());
    }

    private static final ContentType withCharsetUTF8IfNeeded(ContentType $this$withCharsetUTF8IfNeeded) {
        ContentType contentType;
        if (ContentTypesKt.charset($this$withCharsetUTF8IfNeeded) != null) {
            return $this$withCharsetUTF8IfNeeded;
        }
        return ContentTypesKt.withCharset(contentType, Charsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static final <A, B> Map<A, List<B>> groupByPairs(Sequence<? extends Pair<? extends A, ? extends B>> $this$groupByPairs) {
        Object object;
        Iterable $this$mapValuesTo$iv$iv;
        Object $this$mapValues$iv;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        Object element$iv$iv;
        Object $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$groupByPairs, (String)"<this>");
        Object object2 = $this$groupByPairs;
        Object destination$iv$iv = new LinkedHashMap();
        $this$groupByTo$iv$iv = $this$groupByTo$iv$iv.iterator();
        while ($this$groupByTo$iv$iv.hasNext()) {
            Object object3;
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            element$iv$iv = $this$groupByTo$iv$iv.next();
            Object object4 = (Pair)element$iv$iv;
            key$iv$iv = object4.getFirst();
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = object4;
            } else {
                object3 = value$iv$iv$iv;
            }
            object4 = (List)object3;
            object4.add(element$iv$iv);
        }
        $this$groupByTo$iv$iv = $this$mapValues$iv = destination$iv$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        $this$mapValuesTo$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $this$mapValuesTo$iv$iv) {
            Iterator iterator;
            void e;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object object5 = destination$iv$iv;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Object object6 = object5;
            Iterable $this$map$iv = (Iterable)e.getValue();
            element$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv = iterator.next();
                item$iv$iv = (Pair)item$iv$iv;
                object5 = destination$iv$iv2;
                object5.add(it.getSecond());
            }
            object2 = (List)object2;
            object6.put(k, object2);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static final ContentType toContentType(String $this$toContentType) {
        ContentType contentType;
        Intrinsics.checkNotNullParameter((Object)$this$toContentType, (String)"<this>");
        try {
            contentType = ContentType.Companion.parse($this$toContentType);
        }
        catch (Throwable e) {
            void var1_2;
            String string;
            throw new IllegalArgumentException("Failed to parse " + string, (Throwable)var1_2);
        }
        return contentType;
    }

    private static final Map contentTypesByExtensions_delegate$lambda$1() {
        Map map;
        Map map2 = map = CollectionsKt.caseInsensitiveMap();
        map.putAll(FileContentTypeKt.groupByPairs(kotlin.collections.CollectionsKt.asSequence((Iterable)MimesKt.getMimes())));
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair extensionsByContentType_delegate$lambda$3$lambda$2(Pair object) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)object, (String)"<destruct>");
        String first = (String)object.component1();
        object = (ContentType)object.component2();
        return TuplesKt.to((Object)object, (Object)var1_1);
    }

    private static final Map extensionsByContentType_delegate$lambda$3() {
        return FileContentTypeKt.groupByPairs(SequencesKt.map((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)MimesKt.getMimes()), FileContentTypeKt::extensionsByContentType_delegate$lambda$3$lambda$2));
    }
}

