/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.pool;

import io.ktor.utils.io.pool.ObjectPool;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\b'\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00028\u0000H$\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00028\u00002\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\r\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0011\u0010\tJ\u0015\u0010\u0012\u001a\u00020\r2\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0012\u0010\u000fJ\r\u0010\u0013\u001a\u00020\r\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\n\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0011\u0010\u0018\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0004\b\u0018\u0010\tJ\u0017\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0007J\u000f\u0010\u001b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b\u001e\u0010\u001cR\u0014\u0010\u001f\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001dR\u0014\u0010 \u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010\u001dR\u001c\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&"}, d2={"Lio/ktor/utils/io/pool/DefaultPool;", "", "T", "Lio/ktor/utils/io/pool/ObjectPool;", "", "capacity", "<init>", "(I)V", "produceInstance", "()Ljava/lang/Object;", "instance", "clearInstance", "(Ljava/lang/Object;)Ljava/lang/Object;", "", "validateInstance", "(Ljava/lang/Object;)V", "disposeInstance", "borrow", "recycle", "dispose", "()V", "", "tryPush", "(Ljava/lang/Object;)Z", "tryPop", "index", "pushTop", "popTop", "()I", "I", "getCapacity", "maxIndex", "shift", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "instances", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "", "next", "[I"})
@SourceDebugExtension(value={"SMAP\nDefaultPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultPool.kt\nio/ktor/utils/io/pool/DefaultPool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
public abstract class DefaultPool<T>
implements ObjectPool<T> {
    private final int capacity;
    private volatile /* synthetic */ long top;
    private static final /* synthetic */ AtomicLongFieldUpdater top$FU;
    private final int maxIndex;
    private final int shift;
    private final AtomicReferenceArray<T> instances;
    private final int[] next;

    /*
     * WARNING - void declaration
     */
    public DefaultPool(int capacity) {
        void var1_1;
        this.capacity = var1_1;
        if (!(this.capacity > 0)) {
            String string = "capacity should be positive but it is " + this.capacity;
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.capacity <= 0x1FFFFFFF)) {
            String string = "capacity should be less or equal to 536870911 but it is " + this.capacity;
            throw new IllegalArgumentException(string.toString());
        }
        this.top = 0L;
        this.maxIndex = Integer.highestOneBit((this.capacity << 2) - 1) << 1;
        this.shift = Integer.numberOfLeadingZeros(this.maxIndex) + 1;
        this.instances = new AtomicReferenceArray(this.maxIndex + 1);
        this.next = new int[this.maxIndex + 1];
    }

    @Override
    public final int getCapacity() {
        return this.capacity;
    }

    protected abstract T produceInstance();

    /*
     * WARNING - void declaration
     */
    protected T clearInstance(T instance) {
        void var1_1;
        Intrinsics.checkNotNullParameter(instance, (String)"instance");
        return var1_1;
    }

    protected void validateInstance(T instance) {
        Intrinsics.checkNotNullParameter(instance, (String)"instance");
    }

    protected void disposeInstance(T instance) {
        Intrinsics.checkNotNullParameter(instance, (String)"instance");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final T borrow() {
        T t;
        block3: {
            block2: {
                void var1_1;
                t = this.tryPop();
                if (t == null) break block2;
                T it = t;
                t = this.clearInstance(var1_1);
                if (t != null) break block3;
            }
            t = this.produceInstance();
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void recycle(T instance) {
        Intrinsics.checkNotNullParameter(instance, (String)"instance");
        this.validateInstance(instance);
        if (!this.tryPush(instance)) {
            void var1_1;
            this.disposeInstance(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void dispose() {
        while (this.tryPop() != null) {
            void var1_1;
            this.disposeInstance(var1_1);
        }
        return;
    }

    private final boolean tryPush(T instance) {
        int index = (System.identityHashCode(instance) * -1640531527 >>> this.shift) + 1;
        for (int i = 0; i < 8; ++i) {
            if (this.instances.compareAndSet(index, null, instance)) {
                this.pushTop(index);
                return true;
            }
            if ((index += -1) != 0) continue;
            index = this.maxIndex;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final T tryPop() {
        void var1_1;
        int index = this.popTop();
        if (index == 0) {
            return null;
        }
        return this.instances.getAndSet((int)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void pushTop(int index) {
        long newTop;
        void var2_3;
        if (!(index > 0)) {
            String string = "index should be positive";
            throw new IllegalArgumentException(string.toString());
        }
        do {
            long top = this.top;
            long topVersion = (top >> 32 & 0xFFFFFFFFL) + 1L;
            int topIndex = (int)top;
            newTop = topVersion << 32 | (long)index;
            this.next[index] = topIndex;
        } while (!top$FU.compareAndSet(this, (long)var2_3, newTop));
    }

    /*
     * WARNING - void declaration
     */
    private final int popTop() {
        int topIndex;
        int next;
        void var3_2;
        void newTop;
        void var1_1;
        do {
            long top;
            if ((top = this.top) == 0L) {
                return 0;
            }
            long newVersion = (top >> 32 & 0xFFFFFFFFL) + 1L;
            topIndex = (int)top;
            if (topIndex != 0) continue;
            return 0;
        } while (!top$FU.compareAndSet(this, (long)var1_1, (long)(newTop = var3_2 << 32 | (long)(next = this.next[topIndex]))));
        return topIndex;
    }

    @Override
    public void close() {
        ObjectPool.DefaultImpls.close(this);
    }

    static {
        top$FU = AtomicLongFieldUpdater.newUpdater(DefaultPool.class, "top");
    }
}

