/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.core;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Segment;
import kotlinx.io.Sink;
import kotlinx.io.SinksJvmKt;
import kotlinx.io.Source;
import kotlinx.io.SourcesJvmKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0019\u0010\u0007\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0019\u0010\n\u001a\u00020\t*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u001a%\u0010\u000e\u001a\u00020\t*\u00020\u00022\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\t0\f\u00a2\u0006\u0004\b\u000e\u0010\u000f"}, d2={"Ljava/nio/ByteBuffer;", "byteBuffer", "Lkotlinx/io/Source;", "ByteReadPacket", "(Ljava/nio/ByteBuffer;)Lkotlinx/io/Source;", "buffer", "", "readAvailable", "(Lkotlinx/io/Source;Ljava/nio/ByteBuffer;)I", "", "readFully", "(Lkotlinx/io/Source;Ljava/nio/ByteBuffer;)V", "Lkotlin/Function1;", "block", "read", "(Lkotlinx/io/Source;Lkotlin/jvm/functions/Function1;)V"})
@SourceDebugExtension(value={"SMAP\nByteReadPacketExtensions.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteReadPacketExtensions.jvm.kt\nio/ktor/utils/io/core/ByteReadPacketExtensions_jvmKt\n+ 2 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,36:1\n99#2:37\n100#2,8:39\n1#3:38\n*S KotlinDebug\n*F\n+ 1 ByteReadPacketExtensions.jvm.kt\nio/ktor/utils/io/core/ByteReadPacketExtensions_jvmKt\n*L\n28#1:37\n28#1:39,8\n28#1:38\n*E\n"})
public final class ByteReadPacketExtensions_jvmKt {
    public static final Source ByteReadPacket(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2;
        Buffer buffer;
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        Buffer buffer2 = buffer = new Buffer();
        SinksJvmKt.write((Sink)((Sink)buffer), (ByteBuffer)byteBuffer2);
        return (Source)buffer;
    }

    /*
     * WARNING - void declaration
     */
    public static final int readAvailable(Source $this$readAvailable, ByteBuffer buffer) {
        void var1_1;
        void var2_2;
        Source source;
        Intrinsics.checkNotNullParameter((Object)$this$readAvailable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int result = buffer.remaining();
        SourcesJvmKt.readAtMostTo((Source)source, (ByteBuffer)buffer);
        return (int)(var2_2 - var1_1.remaining());
    }

    public static final void readFully(Source $this$readFully, ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)$this$readFully, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        while (!$this$readFully.exhausted() && buffer.hasRemaining()) {
            SourcesJvmKt.readAtMostTo((Source)$this$readFully, (ByteBuffer)buffer);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void read(Source $this$read, Function1<? super ByteBuffer, Unit> block) {
        void var3_5;
        void endExclusive;
        void start;
        Intrinsics.checkNotNullParameter((Object)$this$read, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Source buffer$iv = $this$read.getBuffer();
        if (!(!buffer$iv.exhausted())) {
            block = "Buffer is empty";
            throw new IllegalArgumentException(block.toString());
        }
        Segment segment = buffer$iv.getHead();
        Intrinsics.checkNotNull((Object)segment);
        Segment head$iv = segment;
        int n = head$iv.getLimit();
        int n2 = head$iv.getPos();
        byte[] byArray = segment.dataAsByteArray(true);
        ByteBuffer wrap = ByteBuffer.wrap(byArray, (int)start, (int)(endExclusive - start));
        Intrinsics.checkNotNull((Object)wrap);
        block.invoke((Object)wrap);
        int bytesRead$iv = block = var3_5.position() - start;
        if (block != 0) {
            void var1_2;
            Source source;
            void var2_3;
            if (bytesRead$iv < 0) {
                throw new IllegalStateException("Returned negative read bytes count");
            }
            if (bytesRead$iv > var2_3.getSize()) {
                throw new IllegalStateException("Returned too many bytes");
            }
            source.skip((long)var1_2);
        }
    }
}

