/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.protobuf.ProtoIntegerType;
import kotlinx.serialization.protobuf.internal.ByteArrayInput;
import kotlinx.serialization.protobuf.internal.ProtoWireType;
import kotlinx.serialization.protobuf.internal.ProtobufDecodingException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\r\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\f\u00a2\u0006\u0004\b\u0013\u0010\u000eJ\r\u0010\u0014\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0014\u0010\u0012J\r\u0010\u0015\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u0015\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001c\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001c\u0010\bJ\u0015\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010 \u001a\u00020\u001d\u00a2\u0006\u0004\b \u0010!J\r\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b#\u0010$J\r\u0010%\u001a\u00020\"\u00a2\u0006\u0004\b%\u0010$J\u000f\u0010&\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b&\u0010\bJ\u000f\u0010'\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b'\u0010!J\r\u0010)\u001a\u00020(\u00a2\u0006\u0004\b)\u0010*J\r\u0010+\u001a\u00020(\u00a2\u0006\u0004\b+\u0010*J\r\u0010-\u001a\u00020,\u00a2\u0006\u0004\b-\u0010.J\r\u0010/\u001a\u00020,\u00a2\u0006\u0004\b/\u0010.J\u0017\u00101\u001a\u00020\f2\u0006\u00100\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b1\u00102J\u0019\u00103\u001a\u00020\u00062\b\b\u0002\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b3\u0010\u001bJ\u0017\u00104\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b4\u0010\u001fJ\u0017\u00105\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b5\u00106J\u0017\u00107\u001a\u00020\u001d2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b7\u00108R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00109R\u0016\u0010:\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b:\u0010;R\u0016\u0010=\u001a\u00020<8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b=\u0010>R\u0016\u0010@\u001a\u00020?8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010AR\u0016\u0010B\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010;R\u0011\u0010E\u001a\u00020?8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010D"}, d2={"Lkotlinx/serialization/protobuf/internal/ProtobufReader;", "", "Lkotlinx/serialization/protobuf/internal/ByteArrayInput;", "input", "<init>", "(Lkotlinx/serialization/protobuf/internal/ByteArrayInput;)V", "", "readTag", "()I", "header", "updateIdAndType", "(I)I", "", "pushBackTag", "()V", "skipElement", "", "readByteArray", "()[B", "skipSizeDelimited", "readByteArrayNoTag", "objectInput", "()Lkotlinx/serialization/protobuf/internal/ByteArrayInput;", "objectTaglessInput", "Lkotlinx/serialization/protobuf/ProtoIntegerType;", "format", "readInt", "(Lkotlinx/serialization/protobuf/ProtoIntegerType;)I", "readInt32NoTag", "", "readLong", "(Lkotlinx/serialization/protobuf/ProtoIntegerType;)J", "readLongNoTag", "()J", "", "readFloat", "()F", "readFloatNoTag", "readIntLittleEndian", "readLongLittleEndian", "", "readDouble", "()D", "readDoubleNoTag", "", "readString", "()Ljava/lang/String;", "readStringNoTag", "length", "checkLength", "(I)V", "decode32", "decode64", "decodeSignedVarintInt", "(Lkotlinx/serialization/protobuf/internal/ByteArrayInput;)I", "decodeSignedVarintLong", "(Lkotlinx/serialization/protobuf/internal/ByteArrayInput;)J", "Lkotlinx/serialization/protobuf/internal/ByteArrayInput;", "currentId", "I", "Lkotlinx/serialization/protobuf/internal/ProtoWireType;", "currentType", "Lkotlinx/serialization/protobuf/internal/ProtoWireType;", "", "pushBack", "Z", "pushBackHeader", "getEof", "()Z", "eof"})
@SourceDebugExtension(value={"SMAP\nProtobufReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtobufReader.kt\nkotlinx/serialization/protobuf/internal/ProtobufReader\n*L\n1#1,212:1\n70#1,2:213\n70#1,2:215\n70#1,2:217\n70#1,2:219\n70#1,2:221\n70#1,2:223\n70#1,2:225\n70#1,2:227\n*S KotlinDebug\n*F\n+ 1 ProtobufReader.kt\nkotlinx/serialization/protobuf/internal/ProtobufReader\n*L\n74#1:213,2\n79#1:215,2\n92#1:217,2\n104#1:219,2\n112#1:221,2\n119#1:223,2\n146#1:225,2\n155#1:227,2\n*E\n"})
public final class ProtobufReader {
    private final ByteArrayInput input;
    @JvmField
    public int currentId;
    @JvmField
    public ProtoWireType currentType;
    private boolean pushBack;
    private int pushBackHeader;

    /*
     * WARNING - void declaration
     */
    public ProtobufReader(ByteArrayInput input) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = var1_1;
        this.currentId = -1;
        this.currentType = ProtoWireType.INVALID;
    }

    public final boolean getEof() {
        return !this.pushBack && this.input.getAvailableBytes() == 0;
    }

    /*
     * WARNING - void declaration
     */
    public final int readTag() {
        void var1_2;
        if (this.pushBack) {
            this.pushBack = false;
            int previousHeader = this.currentId << 3 | this.currentType.getTypeId();
            ProtobufReader protobufReader = this;
            int n = protobufReader.updateIdAndType(protobufReader.pushBackHeader);
            this.pushBackHeader = previousHeader;
            return n;
        }
        this.pushBackHeader = this.currentId << 3 | this.currentType.getTypeId();
        int header = (int)this.input.readVarint64(true);
        return this.updateIdAndType((int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private final int updateIdAndType(int header) {
        void var1_1;
        if (header == -1) {
            this.currentId = -1;
            this.currentType = ProtoWireType.INVALID;
            return -1;
        }
        this.currentId = header >>> 3;
        this.currentType = ProtoWireType.Companion.fromLeastSignificantBits((int)var1_1);
        return this.currentId;
    }

    /*
     * WARNING - void declaration
     */
    public final void pushBackTag() {
        void var1_1;
        this.pushBack = true;
        int nextHeader = this.currentId << 3 | this.currentType.getTypeId();
        ProtobufReader protobufReader = this;
        protobufReader.updateIdAndType(protobufReader.pushBackHeader);
        this.pushBackHeader = var1_1;
    }

    public final void skipElement() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.currentType.ordinal()]) {
            case 1: {
                this.readInt(ProtoIntegerType.DEFAULT);
                return;
            }
            case 2: {
                this.readLong(ProtoIntegerType.FIXED);
                return;
            }
            case 3: {
                this.skipSizeDelimited();
                return;
            }
            case 4: {
                this.readInt(ProtoIntegerType.FIXED);
                return;
            }
        }
        throw new ProtobufDecodingException("Unsupported start group or end group wire type: " + (Object)((Object)this.currentType), null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] readByteArray() {
        void this_$iv;
        ProtobufReader protobufReader = this;
        ProtoWireType expected$iv = ProtoWireType.SIZE_DELIMITED;
        if (this_$iv.currentType != expected$iv) {
            void var2_2;
            throw new ProtobufDecodingException("Expected wire type " + var2_2 + ", but found " + (Object)((Object)protobufReader.currentType), null, 2, null);
        }
        return this.readByteArrayNoTag();
    }

    /*
     * WARNING - void declaration
     */
    public final void skipSizeDelimited() {
        void var1_2;
        void this_$iv;
        ProtobufReader protobufReader = this;
        ProtoWireType expected$iv = ProtoWireType.SIZE_DELIMITED;
        if (this_$iv.currentType != expected$iv) {
            void var2_3;
            throw new ProtobufDecodingException("Expected wire type " + var2_3 + ", but found " + (Object)((Object)this_$iv.currentType), null, 2, null);
        }
        int length = ProtobufReader.decode32$default(this, null, 1, null);
        this.checkLength(length);
        this.input.skipExactNBytes((int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] readByteArrayNoTag() {
        void var1_1;
        int length = ProtobufReader.decode32$default(this, null, 1, null);
        this.checkLength(length);
        return this.input.readExactNBytes((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final ByteArrayInput objectInput() {
        void this_$iv;
        ProtobufReader protobufReader = this;
        ProtoWireType expected$iv = ProtoWireType.SIZE_DELIMITED;
        if (this_$iv.currentType != expected$iv) {
            void var2_2;
            throw new ProtobufDecodingException("Expected wire type " + var2_2 + ", but found " + (Object)((Object)protobufReader.currentType), null, 2, null);
        }
        return this.objectTaglessInput();
    }

    /*
     * WARNING - void declaration
     */
    public final ByteArrayInput objectTaglessInput() {
        void var1_1;
        int length = ProtobufReader.decode32$default(this, null, 1, null);
        this.checkLength(length);
        return this.input.slice((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int readInt(ProtoIntegerType format) {
        void var1_1;
        void expected$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        ProtoWireType wireType = format == ProtoIntegerType.FIXED ? ProtoWireType.i32 : ProtoWireType.VARINT;
        ProtobufReader protobufReader = this;
        if (this_$iv.currentType != expected$iv) {
            void var2_2;
            throw new ProtobufDecodingException("Expected wire type " + var2_2 + ", but found " + (Object)((Object)protobufReader.currentType), null, 2, null);
        }
        return this.decode32((ProtoIntegerType)var1_1);
    }

    public final int readInt32NoTag() {
        return ProtobufReader.decode32$default(this, null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    public final long readLong(ProtoIntegerType format) {
        void var1_1;
        void expected$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        ProtoWireType wireType = format == ProtoIntegerType.FIXED ? ProtoWireType.i64 : ProtoWireType.VARINT;
        ProtobufReader protobufReader = this;
        if (this_$iv.currentType != expected$iv) {
            void var2_2;
            throw new ProtobufDecodingException("Expected wire type " + var2_2 + ", but found " + (Object)((Object)protobufReader.currentType), null, 2, null);
        }
        return this.decode64((ProtoIntegerType)var1_1);
    }

    public final long readLongNoTag() {
        return this.decode64(ProtoIntegerType.DEFAULT);
    }

    /*
     * WARNING - void declaration
     */
    public final float readFloat() {
        void this_$iv;
        ProtobufReader protobufReader = this;
        ProtoWireType expected$iv = ProtoWireType.i32;
        if (this_$iv.currentType != expected$iv) {
            void var2_2;
            throw new ProtobufDecodingException("Expected wire type " + var2_2 + ", but found " + (Object)((Object)protobufReader.currentType), null, 2, null);
        }
        return Float.intBitsToFloat(this.readIntLittleEndian());
    }

    public final float readFloatNoTag() {
        return Float.intBitsToFloat(this.readIntLittleEndian());
    }

    /*
     * WARNING - void declaration
     */
    private final int readIntLittleEndian() {
        void var1_1;
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            void var3_3;
            int n = this.input.read() & 0xFF;
            result |= var3_3 << (i << 3);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final long readLongLittleEndian() {
        void var1_1;
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            long l = this.input.read() & 0xFF;
            result |= l << (i << 3);
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final double readDouble() {
        void this_$iv;
        ProtobufReader protobufReader = this;
        ProtoWireType expected$iv = ProtoWireType.i64;
        if (this_$iv.currentType != expected$iv) {
            void var2_2;
            throw new ProtobufDecodingException("Expected wire type " + var2_2 + ", but found " + (Object)((Object)protobufReader.currentType), null, 2, null);
        }
        return Double.longBitsToDouble(this.readLongLittleEndian());
    }

    public final double readDoubleNoTag() {
        return Double.longBitsToDouble(this.readLongLittleEndian());
    }

    /*
     * WARNING - void declaration
     */
    public final String readString() {
        void var1_2;
        void this_$iv;
        ProtobufReader protobufReader = this;
        ProtoWireType expected$iv = ProtoWireType.SIZE_DELIMITED;
        if (this_$iv.currentType != expected$iv) {
            void var2_3;
            throw new ProtobufDecodingException("Expected wire type " + var2_3 + ", but found " + (Object)((Object)this_$iv.currentType), null, 2, null);
        }
        int length = ProtobufReader.decode32$default(this, null, 1, null);
        this.checkLength(length);
        return this.input.readString((int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public final String readStringNoTag() {
        void var1_1;
        int length = ProtobufReader.decode32$default(this, null, 1, null);
        this.checkLength(length);
        return this.input.readString((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkLength(int length) {
        if (length < 0) {
            void var1_1;
            throw new ProtobufDecodingException("Unexpected negative length: " + (int)var1_1, null, 2, null);
        }
    }

    private final int decode32(ProtoIntegerType format) {
        switch (WhenMappings.$EnumSwitchMapping$1[format.ordinal()]) {
            case 1: {
                return (int)this.input.readVarint64(false);
            }
            case 2: {
                ProtobufReader protobufReader = this;
                return protobufReader.decodeSignedVarintInt(protobufReader.input);
            }
            case 3: {
                return this.readIntLittleEndian();
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    static /* synthetic */ int decode32$default(ProtobufReader protobufReader, ProtoIntegerType protoIntegerType, int n, Object object) {
        if ((n & 1) != 0) {
            protoIntegerType = ProtoIntegerType.DEFAULT;
        }
        return protobufReader.decode32(protoIntegerType);
    }

    private final long decode64(ProtoIntegerType format) {
        switch (WhenMappings.$EnumSwitchMapping$1[format.ordinal()]) {
            case 1: {
                return this.input.readVarint64(false);
            }
            case 2: {
                ProtobufReader protobufReader = this;
                return protobufReader.decodeSignedVarintLong(protobufReader.input);
            }
            case 3: {
                return this.readLongLittleEndian();
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    private final int decodeSignedVarintInt(ByteArrayInput input) {
        void var1_2;
        int raw = input.readVarint32();
        int n = (raw << 31 >> 31 ^ raw) >> 1;
        return n ^ var1_2 & Integer.MIN_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    private final long decodeSignedVarintLong(ByteArrayInput input) {
        void var2_2;
        long raw = input.readVarint64(false);
        long l = (raw << 63 >> 63 ^ raw) >> 1;
        return l ^ var2_2 & Long.MIN_VALUE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ProtoWireType.values().length];
            try {
                nArray[ProtoWireType.VARINT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoWireType.i64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoWireType.SIZE_DELIMITED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoWireType.i32.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ProtoIntegerType.values().length];
            try {
                nArray[ProtoIntegerType.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoIntegerType.SIGNED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoIntegerType.FIXED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

