/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.MapLikeSerializer;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.protobuf.ProtoBuf;
import kotlinx.serialization.protobuf.ProtoIntegerType;
import kotlinx.serialization.protobuf.internal.HelpersKt;
import kotlinx.serialization.protobuf.internal.MapRepeatedEncoder;
import kotlinx.serialization.protobuf.internal.NestedRepeatedEncoder;
import kotlinx.serialization.protobuf.internal.ObjectEncoder;
import kotlinx.serialization.protobuf.internal.OneOfPolymorphicEncoder;
import kotlinx.serialization.protobuf.internal.PackedArrayEncoder;
import kotlinx.serialization.protobuf.internal.ProtobufTaggedEncoder;
import kotlinx.serialization.protobuf.internal.ProtobufWriter;
import kotlinx.serialization.protobuf.internal.RepeatedEncoder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0011\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J#\u0010\u001a\u001a\u00020\u00192\n\u0010\u0017\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010\u0018\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bJ#\u0010\u001d\u001a\u00020\u00192\n\u0010\u0017\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010\u0018\u001a\u00020\u001cH\u0014\u00a2\u0006\u0004\b\u001d\u0010\u001eJ#\u0010 \u001a\u00020\u00192\n\u0010\u0017\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010\u0018\u001a\u00020\u001fH\u0014\u00a2\u0006\u0004\b \u0010!J#\u0010\"\u001a\u00020\u00192\n\u0010\u0017\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010\u0018\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\"\u0010#J#\u0010%\u001a\u00020\u00192\n\u0010\u0017\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010\u0018\u001a\u00020$H\u0014\u00a2\u0006\u0004\b%\u0010&J#\u0010'\u001a\u00020\u00192\n\u0010\u0017\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010\u0018\u001a\u00020\u0015H\u0014\u00a2\u0006\u0004\b'\u0010(J#\u0010*\u001a\u00020\u00192\n\u0010\u0017\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010\u0018\u001a\u00020)H\u0014\u00a2\u0006\u0004\b*\u0010+J#\u0010-\u001a\u00020\u00192\n\u0010\u0017\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010\u0018\u001a\u00020,H\u0014\u00a2\u0006\u0004\b-\u0010.J#\u00100\u001a\u00020\u00192\n\u0010\u0017\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010\u0018\u001a\u00020/H\u0014\u00a2\u0006\u0004\b0\u00101J+\u00104\u001a\u00020\u00192\n\u0010\u0017\u001a\u00060\u0015j\u0002`\u00162\u0006\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b4\u00105J\u001f\u00106\u001a\u00060\u0015j\u0002`\u0016*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b6\u00107J+\u0010;\u001a\u00020\u0019\"\u0004\b\u0000\u001082\f\u0010:\u001a\b\u0012\u0004\u0012\u00028\u0000092\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b;\u0010<J\u0017\u0010>\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020=H\u0002\u00a2\u0006\u0004\b>\u0010?J+\u0010@\u001a\u00020\u0019\"\u0004\b\u0000\u001082\f\u0010:\u001a\b\u0012\u0004\u0012\u00028\u0000092\u0006\u0010\u0018\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b@\u0010<R\u0014\u0010\u0003\u001a\u00020\u00028\u0004X\u0085\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010AR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010BR\u0014\u0010\u0007\u001a\u00020\u00068\u0004X\u0085\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010CR\u0014\u0010G\u001a\u00020D8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010F"}, d2={"Lkotlinx/serialization/protobuf/internal/ProtobufEncoder;", "Lkotlinx/serialization/protobuf/internal/ProtobufTaggedEncoder;", "Lkotlinx/serialization/protobuf/ProtoBuf;", "proto", "Lkotlinx/serialization/protobuf/internal/ProtobufWriter;", "writer", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "<init>", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/internal/ProtobufWriter;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "", "index", "", "shouldEncodeElementDefault", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)Z", "collectionSize", "Lkotlinx/serialization/encoding/CompositeEncoder;", "beginCollection", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)Lkotlinx/serialization/encoding/CompositeEncoder;", "beginStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlinx/serialization/encoding/CompositeEncoder;", "", "Lkotlinx/serialization/protobuf/internal/ProtoDesc;", "tag", "value", "", "encodeTaggedInt", "(JI)V", "", "encodeTaggedByte", "(JB)V", "", "encodeTaggedShort", "(JS)V", "encodeTaggedBoolean", "(JZ)V", "", "encodeTaggedChar", "(JC)V", "encodeTaggedLong", "(JJ)V", "", "encodeTaggedFloat", "(JF)V", "", "encodeTaggedDouble", "(JD)V", "", "encodeTaggedString", "(JLjava/lang/String;)V", "enumDescriptor", "ordinal", "encodeTaggedEnum", "(JLkotlinx/serialization/descriptors/SerialDescriptor;I)V", "getTag", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)J", "T", "Lkotlinx/serialization/SerializationStrategy;", "serializer", "encodeSerializableValue", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "", "serializeByteArray", "([B)V", "serializeMap", "Lkotlinx/serialization/protobuf/ProtoBuf;", "Lkotlinx/serialization/protobuf/internal/ProtobufWriter;", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "serializersModule"})
@SourceDebugExtension(value={"SMAP\nProtobufEncoding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtobufEncoding.kt\nkotlinx/serialization/protobuf/internal/ProtobufEncoder\n+ 2 Helpers.kt\nkotlinx/serialization/protobuf/internal/HelpersKt\n*L\n1#1,291:1\n61#2:292\n61#2:293\n61#2:294\n61#2:295\n61#2:296\n61#2:297\n61#2:298\n*S KotlinDebug\n*F\n+ 1 ProtobufEncoding.kt\nkotlinx/serialization/protobuf/internal/ProtobufEncoder\n*L\n80#1:292\n93#1:293\n101#1:294\n109#1:295\n117#1:296\n133#1:297\n154#1:298\n*E\n"})
public class ProtobufEncoder
extends ProtobufTaggedEncoder {
    @JvmField
    protected final ProtoBuf proto;
    private final ProtobufWriter writer;
    @JvmField
    protected final SerialDescriptor descriptor;

    /*
     * WARNING - void declaration
     */
    public ProtobufEncoder(ProtoBuf proto, ProtobufWriter writer, SerialDescriptor descriptor) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.proto = var1_1;
        this.writer = var2_2;
        this.descriptor = var3_3;
    }

    public SerializersModule getSerializersModule() {
        return this.proto.getSerializersModule();
    }

    @Override
    public boolean shouldEncodeElementDefault(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this.proto.getEncodeDefaults$kotlinx_serialization_protobuf();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeEncoder beginCollection(SerialDescriptor descriptor, int collectionSize) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
            ProtobufEncoder protobufEncoder;
            long tag = this.getCurrentTagOrDefault();
            if (HelpersKt.isPacked(tag) && HelpersKt.isPackable(descriptor.getElementDescriptor(0))) {
                protobufEncoder = new PackedArrayEncoder(this.proto, this.writer, this.getCurrentTagOrDefault(), descriptor, null, 16, null);
            } else {
                if (tag == 19500L) {
                    void var2_2;
                    this.writer.writeInt((int)var2_2);
                }
                protobufEncoder = Intrinsics.areEqual((Object)this.descriptor.getKind(), (Object)StructureKind.LIST.INSTANCE) && tag != 19500L && !Intrinsics.areEqual((Object)this.descriptor, (Object)descriptor) ? (ProtobufEncoder)new NestedRepeatedEncoder(this.proto, this.writer, tag, descriptor, null, 16, null) : (ProtobufEncoder)new RepeatedEncoder(this.proto, this.writer, tag, descriptor);
            }
            return protobufEncoder;
        }
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
            return new MapRepeatedEncoder(this.proto, this.getCurrentTag(), this.writer, descriptor);
        }
        throw new SerializationException("This serial kind is not supported as collection: " + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public CompositeEncoder beginStructure(SerialDescriptor descriptor) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
            return HelpersKt.isPackable(descriptor.getElementDescriptor(0)) && HelpersKt.isPacked(this.getCurrentTagOrDefault()) ? (ProtobufEncoder)new PackedArrayEncoder(this.proto, this.writer, this.getCurrentTagOrDefault(), descriptor, null, 16, null) : (ProtobufEncoder)new RepeatedEncoder(this.proto, this.writer, this.getCurrentTagOrDefault(), descriptor);
        }
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE) || serialKind instanceof PolymorphicKind) {
            void var3_3;
            long tag = this.getCurrentTagOrDefault();
            return tag == 19500L && Intrinsics.areEqual((Object)descriptor, (Object)this.descriptor) ? this : (HelpersKt.isOneOf((long)var3_3) ? (ProtobufEncoder)new OneOfPolymorphicEncoder(this.proto, this.writer, descriptor) : (ProtobufEncoder)new ObjectEncoder(this.proto, this.getCurrentTagOrDefault(), this.writer, null, descriptor, 8, null));
        }
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
            return new MapRepeatedEncoder(this.proto, this.getCurrentTagOrDefault(), this.writer, descriptor);
        }
        throw new SerializationException("This serial kind is not supported as structure: " + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void encodeTaggedInt(long tag, int value) {
        void var1_1;
        void var3_2;
        if (tag == 19500L) {
            this.writer.writeInt(value);
            return;
        }
        long l = tag;
        this.writer.writeInt((int)var3_2, (int)(l & Integer.MAX_VALUE), HelpersKt.getIntegerType((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void encodeTaggedByte(long tag, byte value) {
        void var3_2;
        void var1_1;
        this.encodeTaggedInt((long)var1_1, (int)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void encodeTaggedShort(long tag, short value) {
        void var3_2;
        void var1_1;
        this.encodeTaggedInt((long)var1_1, (int)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void encodeTaggedBoolean(long tag, boolean value) {
        void var3_2;
        void var1_1;
        this.encodeTaggedInt((long)var1_1, var3_2 != false ? 1 : 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void encodeTaggedChar(long tag, char value) {
        void var3_2;
        void var1_1;
        this.encodeTaggedInt((long)var1_1, (int)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void encodeTaggedLong(long tag, long value) {
        void var1_1;
        void var3_2;
        if (tag == 19500L) {
            this.writer.writeLong(value);
            return;
        }
        long l = tag;
        this.writer.writeLong((long)var3_2, (int)(l & Integer.MAX_VALUE), HelpersKt.getIntegerType((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void encodeTaggedFloat(long tag, float value) {
        void var3_2;
        void var1_1;
        if (tag == 19500L) {
            this.writer.writeFloat(value);
            return;
        }
        void var4_3 = var1_1;
        this.writer.writeFloat((float)var3_2, (int)(var4_3 & Integer.MAX_VALUE));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void encodeTaggedDouble(long tag, double value) {
        void var3_2;
        void var1_1;
        if (tag == 19500L) {
            this.writer.writeDouble(value);
            return;
        }
        void var5_3 = var1_1;
        this.writer.writeDouble((double)var3_2, (int)(var5_3 & Integer.MAX_VALUE));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void encodeTaggedString(long tag, String value) {
        void var3_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (tag == 19500L) {
            this.writer.writeString(value);
            return;
        }
        void var4_3 = var1_1;
        this.writer.writeString((String)var3_2, (int)(var4_3 & Integer.MAX_VALUE));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void encodeTaggedEnum(long tag, SerialDescriptor enumDescriptor, int ordinal) {
        void var3_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        int id = HelpersKt.extractProtoId(enumDescriptor, ordinal, true);
        if (tag == 19500L) {
            this.writer.writeInt(id);
            return;
        }
        void var6_5 = var1_1;
        this.writer.writeInt((int)var3_3, (int)(var6_5 & Integer.MAX_VALUE), ProtoIntegerType.DEFAULT);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long getTag(SerialDescriptor $this$getTag, int index) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"<this>");
        return HelpersKt.extractParameters((SerialDescriptor)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> void encodeSerializableValue(SerializationStrategy<? super T> serializer, T value) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        if (serializer instanceof MapLikeSerializer) {
            this.serializeMap(serializer, value);
            return;
        }
        if (Intrinsics.areEqual((Object)serializer.getDescriptor(), (Object)BuiltinSerializersKt.ByteArraySerializer().getDescriptor())) {
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.ByteArray");
            this.serializeByteArray((byte[])value);
            return;
        }
        var1_1.serialize((Encoder)this, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final void serializeByteArray(byte[] value) {
        void var1_1;
        void var2_2;
        long tag = this.popTagOrDefault();
        if (tag == 19500L) {
            this.writer.writeBytes(value);
            return;
        }
        void var4_3 = var2_2;
        this.writer.writeBytes((byte[])var1_1, (int)(var4_3 & Integer.MAX_VALUE));
    }

    /*
     * WARNING - void declaration
     */
    private final <T> void serializeMap(SerializationStrategy<? super T> serializer, T value) {
        void var2_2;
        KSerializer kSerializer;
        Intrinsics.checkNotNull(serializer, (String)"null cannot be cast to non-null type kotlinx.serialization.internal.MapLikeSerializer<kotlin.Any?, kotlin.Any?, T of kotlinx.serialization.protobuf.internal.ProtobufEncoder.serializeMap, *>");
        MapLikeSerializer casted = (MapLikeSerializer)serializer;
        kSerializer = BuiltinSerializersKt.MapEntrySerializer((KSerializer)casted.getKeySerializer(), (KSerializer)kSerializer.getValueSerializer());
        KSerializer kSerializer2 = BuiltinSerializersKt.SetSerializer((KSerializer)kSerializer);
        Encoder encoder = this;
        Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
        kSerializer2.serialize(encoder, ((Map)var2_2).entrySet());
    }
}

