/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.internal.AbstractCollectionSerializer;
import kotlinx.serialization.internal.ElementMarker;
import kotlinx.serialization.internal.MapLikeSerializer;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.protobuf.ProtoBuf;
import kotlinx.serialization.protobuf.ProtoIntegerType;
import kotlinx.serialization.protobuf.internal.HelpersKt;
import kotlinx.serialization.protobuf.internal.MapEntryReader;
import kotlinx.serialization.protobuf.internal.OneOfPolymorphicReader;
import kotlinx.serialization.protobuf.internal.PackedArrayDecoder;
import kotlinx.serialization.protobuf.internal.ProtoWireType;
import kotlinx.serialization.protobuf.internal.ProtobufDecodingException;
import kotlinx.serialization.protobuf.internal.ProtobufDecodingKt;
import kotlinx.serialization.protobuf.internal.ProtobufReader;
import kotlinx.serialization.protobuf.internal.ProtobufTaggedDecoder;
import kotlinx.serialization.protobuf.internal.RepeatedDecoder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0011\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J/\u0010\u0014\u001a\u00020\n*\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0018J\u001f\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001cJ\u0017\u0010 \u001a\u00020\u001f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b \u0010!J\u0017\u0010\"\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\"\u0010\fJ\u001b\u0010'\u001a\u00020&2\n\u0010%\u001a\u00060#j\u0002`$H\u0014\u00a2\u0006\u0004\b'\u0010(J\u001b\u0010*\u001a\u00020)2\n\u0010%\u001a\u00060#j\u0002`$H\u0014\u00a2\u0006\u0004\b*\u0010+J\u001b\u0010-\u001a\u00020,2\n\u0010%\u001a\u00060#j\u0002`$H\u0014\u00a2\u0006\u0004\b-\u0010.J\u001b\u0010/\u001a\u00020\r2\n\u0010%\u001a\u00060#j\u0002`$H\u0014\u00a2\u0006\u0004\b/\u00100J\u001b\u00101\u001a\u00020#2\n\u0010%\u001a\u00060#j\u0002`$H\u0014\u00a2\u0006\u0004\b1\u00102J\u001b\u00104\u001a\u0002032\n\u0010%\u001a\u00060#j\u0002`$H\u0014\u00a2\u0006\u0004\b4\u00105J\u001b\u00107\u001a\u0002062\n\u0010%\u001a\u00060#j\u0002`$H\u0014\u00a2\u0006\u0004\b7\u00108J\u001b\u0010:\u001a\u0002092\n\u0010%\u001a\u00060#j\u0002`$H\u0014\u00a2\u0006\u0004\b:\u0010;J\u001b\u0010=\u001a\u00020<2\n\u0010%\u001a\u00060#j\u0002`$H\u0014\u00a2\u0006\u0004\b=\u0010>J#\u0010@\u001a\u00020\r2\n\u0010%\u001a\u00060#j\u0002`$2\u0006\u0010?\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b@\u0010AJ#\u0010E\u001a\u00028\u0000\"\u0004\b\u0000\u0010B2\f\u0010D\u001a\b\u0012\u0004\u0012\u00028\u00000CH\u0016\u00a2\u0006\u0004\bE\u0010FJ-\u0010E\u001a\u00028\u0000\"\u0004\b\u0000\u0010B2\f\u0010D\u001a\b\u0012\u0004\u0012\u00028\u00000C2\b\u0010G\u001a\u0004\u0018\u00018\u0000H\u0014\u00a2\u0006\u0004\bE\u0010HJ\u0019\u0010J\u001a\u00020I2\b\u0010G\u001a\u0004\u0018\u00010IH\u0002\u00a2\u0006\u0004\bJ\u0010KJ-\u0010L\u001a\u00028\u0000\"\u0004\b\u0000\u0010B2\f\u0010D\u001a\b\u0012\u0004\u0012\u00028\u00000C2\b\u0010G\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0004\bL\u0010HJ\u001f\u0010M\u001a\u00060#j\u0002`$*\u00020\u00062\u0006\u0010\u0013\u001a\u00020\rH\u0014\u00a2\u0006\u0004\bM\u0010NJ\u0017\u0010O\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\bO\u0010PJ\u000f\u0010Q\u001a\u00020&H\u0016\u00a2\u0006\u0004\bQ\u0010RJ\u001f\u0010S\u001a\u00020&2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\rH\u0002\u00a2\u0006\u0004\bS\u0010TR\u0014\u0010\u0003\u001a\u00020\u00028\u0004X\u0085\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010UR\u0014\u0010\u0005\u001a\u00020\u00048\u0004X\u0085\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010VR\u0014\u0010\u0007\u001a\u00020\u00068\u0004X\u0085\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010WR\u0014\u0010[\u001a\u00020X8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bY\u0010ZR\u0018\u0010]\u001a\u0004\u0018\u00010\\8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b]\u0010^R$\u0010_\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b_\u0010`R$\u0010a\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\ba\u0010`R\u0016\u0010b\u001a\u00020&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bb\u0010cR\u0014\u0010e\u001a\u00020d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\be\u0010f"}, d2={"Lkotlinx/serialization/protobuf/internal/ProtobufDecoder;", "Lkotlinx/serialization/protobuf/internal/ProtobufTaggedDecoder;", "Lkotlinx/serialization/protobuf/ProtoBuf;", "proto", "Lkotlinx/serialization/protobuf/internal/ProtobufReader;", "reader", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "<init>", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/internal/ProtobufReader;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "", "populateCache", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "", "elements", "populateCacheMap", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)V", "", "protoId", "index", "putProtoId", "(Ljava/util/Map;II)V", "protoNum", "getIndexByNum", "(I)I", "protoTag", "getIndexByNumSlowPath", "findIndexByTag", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)I", "desc", "findIndexByTagSlowPath", "Lkotlinx/serialization/encoding/CompositeDecoder;", "beginStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlinx/serialization/encoding/CompositeDecoder;", "endStructure", "", "Lkotlinx/serialization/protobuf/internal/ProtoDesc;", "tag", "", "decodeTaggedBoolean", "(J)Z", "", "decodeTaggedByte", "(J)B", "", "decodeTaggedShort", "(J)S", "decodeTaggedInt", "(J)I", "decodeTaggedLong", "(J)J", "", "decodeTaggedFloat", "(J)F", "", "decodeTaggedDouble", "(J)D", "", "decodeTaggedChar", "(J)C", "", "decodeTaggedString", "(J)Ljava/lang/String;", "enumDescription", "decodeTaggedEnum", "(JLkotlinx/serialization/descriptors/SerialDescriptor;)I", "T", "Lkotlinx/serialization/DeserializationStrategy;", "deserializer", "decodeSerializableValue", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "previousValue", "(Lkotlinx/serialization/DeserializationStrategy;Ljava/lang/Object;)Ljava/lang/Object;", "", "deserializeByteArray", "([B)[B", "deserializeMap", "getTag", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)J", "decodeElementIndex", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)I", "decodeNotNullMark", "()Z", "readIfAbsent", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)Z", "Lkotlinx/serialization/protobuf/ProtoBuf;", "Lkotlinx/serialization/protobuf/internal/ProtobufReader;", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "serializersModule", "", "indexCache", "[I", "sparseIndexCache", "Ljava/util/Map;", "index2IdMap", "nullValue", "Z", "Lkotlinx/serialization/internal/ElementMarker;", "elementMarker", "Lkotlinx/serialization/internal/ElementMarker;"})
@SourceDebugExtension(value={"SMAP\nProtobufDecoding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtobufDecoding.kt\nkotlinx/serialization/protobuf/internal/ProtobufDecoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Helpers.kt\nkotlinx/serialization/protobuf/internal/HelpersKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,551:1\n360#1,10:567\n360#1,10:578\n360#1,10:589\n360#1,10:600\n360#1,10:611\n360#1,10:626\n369#1:643\n1563#2:552\n1634#2,2:553\n1636#2:556\n1869#2,2:557\n1222#2,2:637\n1252#2,4:639\n61#3:555\n54#3,5:560\n61#3:565\n61#3:566\n61#3:577\n61#3:588\n61#3:599\n61#3:610\n61#3:621\n61#3:622\n61#3:623\n61#3:624\n61#3:625\n61#3:636\n61#3:644\n61#3:645\n1#4:559\n*S KotlinDebug\n*F\n+ 1 ProtobufDecoding.kt\nkotlinx/serialization/protobuf/internal/ProtobufDecoder\n*L\n191#1:567,10\n200#1:578,10\n210#1:589,10\n219#1:600,10\n230#1:611,10\n283#1:626,10\n363#1:643\n78#1:552\n78#1:553,2\n78#1:556\n79#1:557,2\n301#1:637,2\n301#1:639,4\n78#1:555\n137#1:560,5\n157#1:565\n174#1:566\n191#1:577\n200#1:588\n210#1:599\n219#1:610\n230#1:621\n264#1:622\n267#1:623\n268#1:624\n272#1:625\n283#1:636\n363#1:644\n369#1:645\n*E\n"})
public class ProtobufDecoder
extends ProtobufTaggedDecoder {
    @JvmField
    protected final ProtoBuf proto;
    @JvmField
    protected final ProtobufReader reader;
    @JvmField
    protected final SerialDescriptor descriptor;
    private int[] indexCache;
    private Map<Integer, Integer> sparseIndexCache;
    private Map<Integer, Integer> index2IdMap;
    private boolean nullValue;
    private final ElementMarker elementMarker;

    /*
     * WARNING - void declaration
     */
    public ProtobufDecoder(ProtoBuf proto, ProtobufReader reader, SerialDescriptor descriptor) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.proto = var1_1;
        this.reader = var2_2;
        this.descriptor = var3_3;
        this.elementMarker = new ElementMarker(this.descriptor, (Function2)new Function2<SerialDescriptor, Integer, Boolean>((Object)this){
            {
                void var1_1;
            }

            public final Boolean invoke(SerialDescriptor p0, int p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ProtobufDecoder.access$readIfAbsent((ProtobufDecoder)this.receiver, p0, p1);
            }
        });
        ProtobufDecoder protobufDecoder = this;
        protobufDecoder.populateCache(protobufDecoder.descriptor);
    }

    public SerializersModule getSerializersModule() {
        return this.proto.getSerializersModule();
    }

    /*
     * WARNING - void declaration
     */
    public final void populateCache(SerialDescriptor descriptor) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        int elements = descriptor.getElementsCount();
        if (elements < 32) {
            int n = 0;
            int n2 = elements + 1;
            int[] nArray = new int[n2];
            while (n < n2) {
                int n3 = n++;
                nArray[n3] = -1;
            }
            int i = 0;
            while (i < elements) {
                int protoId = HelpersKt.extractProtoId(descriptor, i, false);
                if (protoId > elements || protoId == -2) {
                    this.populateCacheMap(descriptor, elements);
                    return;
                }
                cache[protoId] = i++;
            }
            this.indexCache = nArray;
            return;
        }
        this.populateCacheMap((SerialDescriptor)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final void populateCacheMap(SerialDescriptor descriptor, int elements) {
        void var3_3;
        HashMap map = new HashMap(elements, 1.0f);
        int oneOfCount = 0;
        for (int i = 0; i < elements; ++i) {
            int n = HelpersKt.extractProtoId(descriptor, i, false);
            if (n == -2) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = HelpersKt.getAllOneOfSerializerOfField(descriptor.getElementDescriptor(i), this.getSerializersModule());
                Iterator iterator = $this$map$iv;
                Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    item$iv$iv = (SerialDescriptor)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    long l = HelpersKt.extractParameters((SerialDescriptor)it, 0);
                    collection.add((int)(l & Integer.MAX_VALUE));
                }
                destination$iv$iv2 = (List)destination$iv$iv2;
                for (Object destination$iv$iv2 : destination$iv$iv2) {
                    int it = ((Number)destination$iv$iv2).intValue();
                    this.putProtoId(map, it, i);
                }
                ++oneOfCount;
                continue;
            }
            this.putProtoId(map, HelpersKt.extractProtoId(descriptor, i, false), i);
        }
        if (oneOfCount > 0) {
            this.index2IdMap = new HashMap(oneOfCount, 1.0f);
        }
        this.sparseIndexCache = (Map)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final void putProtoId(Map<Integer, Integer> $this$putProtoId, int protoId, int index) {
        void var3_3;
        void var2_2;
        $this$putProtoId.put((int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private final int getIndexByNum(int protoNum) {
        void var1_1;
        int[] array = this.indexCache;
        if (this.indexCache != null) {
            void var2_2;
            boolean bl = protoNum >= 0 ? protoNum < ((void)var2_2).length : false;
            if (bl) {
                return (int)var2_2[protoNum];
            }
            return -1;
        }
        return this.getIndexByNumSlowPath((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final int getIndexByNumSlowPath(int protoTag) {
        void var1_1;
        Map<Integer, Integer> map = this.sparseIndexCache;
        Intrinsics.checkNotNull(map);
        Map<Integer, Integer> map2 = map;
        Integer n = map2.get((int)var1_1);
        if (n == null) {
            n = -1;
        }
        return ((Number)n).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private final int findIndexByTag(SerialDescriptor descriptor, int protoTag) {
        void var2_2;
        void var1_1;
        int n;
        if (protoTag < descriptor.getElementsCount() && protoTag >= 0 && (n = HelpersKt.extractProtoId(descriptor, protoTag, true)) == protoTag) {
            return protoTag;
        }
        return this.findIndexByTagSlowPath((SerialDescriptor)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final int findIndexByTagSlowPath(SerialDescriptor desc, int protoTag) {
        void var2_2;
        int n = desc.getElementsCount();
        for (int i = 0; i < n; ++i) {
            int n2 = HelpersKt.extractProtoId(desc, i, true);
            if (n2 != protoTag) continue;
            return i;
        }
        throw new ProtobufDecodingException((int)var2_2 + " is not among valid " + this.descriptor.getSerialName() + " enum proto numbers", null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompositeDecoder beginStructure(SerialDescriptor descriptor) {
        SerialKind serialKind;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        try {
            serialKind = descriptor.getKind();
            if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
                long tag = this.getCurrentTagOrDefault();
                if (Intrinsics.areEqual((Object)this.descriptor.getKind(), (Object)StructureKind.LIST.INSTANCE) && tag != 19500L && !Intrinsics.areEqual((Object)this.descriptor, (Object)descriptor)) {
                    ProtobufReader reader = ProtobufDecodingKt.access$makeDelimited(this.reader, tag);
                    reader.readTag();
                    ProtoIntegerType type$iv = ProtoIntegerType.DEFAULT;
                    return new RepeatedDecoder(this.proto, reader, 0L | type$iv.getSignature$kotlinx_serialization_protobuf() | 1L, descriptor);
                }
                if (this.reader.currentType == ProtoWireType.SIZE_DELIMITED && HelpersKt.isPackable(descriptor.getElementDescriptor(0))) {
                    ProtobufReader sliceReader = new ProtobufReader(this.reader.objectInput());
                    return new PackedArrayDecoder(this.proto, sliceReader, descriptor);
                }
                return new RepeatedDecoder(this.proto, this.reader, tag, descriptor);
            }
            if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE) || serialKind instanceof PolymorphicKind) {
                long tag = this.getCurrentTagOrDefault();
                if (tag == 19500L && Intrinsics.areEqual((Object)this.descriptor, (Object)descriptor)) {
                    return this;
                }
                if (HelpersKt.isOneOf(tag)) {
                    long l;
                    long l2 = tag;
                    int rawIndex = (int)(l2 & Integer.MAX_VALUE) - 1;
                    Map<Integer, Integer> map = this.index2IdMap;
                    if (map != null && (map = map.get(rawIndex)) != null) {
                        void var2_3;
                        int it = ((Number)((Object)map)).intValue();
                        l = HelpersKt.overrideId(tag, (int)var2_3);
                    } else {
                        l = tag;
                    }
                    long restoredTag = l;
                    return new OneOfPolymorphicReader(this.proto, this.reader, restoredTag, descriptor);
                }
                return new ProtobufDecoder(this.proto, ProtobufDecodingKt.access$makeDelimited(this.reader, tag), descriptor);
            }
            if (!Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
                throw new SerializationException("Primitives are not supported at top-level");
            }
            serialKind = new MapEntryReader(this.proto, ProtobufDecodingKt.access$makeDelimitedForced(this.reader, this.getCurrentTagOrDefault()), this.getCurrentTagOrDefault(), descriptor);
        }
        catch (ProtobufDecodingException e) {
            void var3_6;
            void var1_1;
            long l = this.getCurrentTagOrDefault();
            throw new ProtobufDecodingException("Fail to begin structure for " + var1_1.getSerialName() + " in " + this.descriptor.getSerialName() + " at proto number " + (int)(l & Integer.MAX_VALUE), (Throwable)var3_6);
        }
        return serialKind;
    }

    @Override
    public void endStructure(SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean decodeTaggedBoolean(long tag) {
        void var1_2;
        int value = this.decodeTaggedInt(tag);
        switch (value) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new SerializationException("Unexpected boolean value: " + (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte decodeTaggedByte(long tag) {
        void var1_1;
        return (byte)this.decodeTaggedInt((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected short decodeTaggedShort(long tag) {
        void var1_1;
        return (short)this.decodeTaggedInt((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int decodeTaggedInt(long tag) {
        int n;
        ProtobufDecoder protobufDecoder = this;
        long tag$iv = tag;
        try {
            if (tag != 19500L) {
                return this.reader.readInt(HelpersKt.getIntegerType(tag));
            }
            n = this.reader.readInt32NoTag();
        }
        catch (ProtobufDecodingException e$iv) {
            void var1_3;
            void tag$iv$iv;
            void e$iv$iv;
            ProtobufDecoder protobufDecoder2 = protobufDecoder;
            long l = tag$iv;
            e$iv$iv = e$iv$iv;
            void var11_8 = tag$iv$iv;
            throw new ProtobufDecodingException("Error while decoding proto number " + (int)(var11_8 & Integer.MAX_VALUE) + " of " + protobufDecoder2.descriptor.getSerialName(), (Throwable)var1_3);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long decodeTaggedLong(long tag) {
        long l;
        ProtobufDecoder protobufDecoder = this;
        long tag$iv = tag;
        try {
            if (tag != 19500L) {
                return this.reader.readLong(HelpersKt.getIntegerType(tag));
            }
            l = this.reader.readLongNoTag();
        }
        catch (ProtobufDecodingException e$iv) {
            void var1_3;
            void tag$iv$iv;
            void e$iv$iv;
            ProtobufDecoder protobufDecoder2 = protobufDecoder;
            long l2 = tag$iv;
            e$iv$iv = e$iv$iv;
            void var11_8 = tag$iv$iv;
            throw new ProtobufDecodingException("Error while decoding proto number " + (int)(var11_8 & Integer.MAX_VALUE) + " of " + protobufDecoder2.descriptor.getSerialName(), (Throwable)var1_3);
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected float decodeTaggedFloat(long tag) {
        float f;
        ProtobufDecoder protobufDecoder = this;
        long tag$iv = tag;
        try {
            if (tag != 19500L) {
                return this.reader.readFloat();
            }
            f = this.reader.readFloatNoTag();
        }
        catch (ProtobufDecodingException e$iv) {
            void var1_3;
            void tag$iv$iv;
            void e$iv$iv;
            ProtobufDecoder protobufDecoder2 = protobufDecoder;
            long l = tag$iv;
            e$iv$iv = e$iv$iv;
            void var11_8 = tag$iv$iv;
            throw new ProtobufDecodingException("Error while decoding proto number " + (int)(var11_8 & Integer.MAX_VALUE) + " of " + protobufDecoder2.descriptor.getSerialName(), (Throwable)var1_3);
        }
        return f;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected double decodeTaggedDouble(long tag) {
        double d;
        ProtobufDecoder protobufDecoder = this;
        long tag$iv = tag;
        try {
            if (tag != 19500L) {
                return this.reader.readDouble();
            }
            d = this.reader.readDoubleNoTag();
        }
        catch (ProtobufDecodingException e$iv) {
            void var1_3;
            void tag$iv$iv;
            void e$iv$iv;
            ProtobufDecoder protobufDecoder2 = protobufDecoder;
            long l = tag$iv;
            e$iv$iv = e$iv$iv;
            void var11_8 = tag$iv$iv;
            throw new ProtobufDecodingException("Error while decoding proto number " + (int)(var11_8 & Integer.MAX_VALUE) + " of " + protobufDecoder2.descriptor.getSerialName(), (Throwable)var1_3);
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected char decodeTaggedChar(long tag) {
        void var1_1;
        return (char)this.decodeTaggedInt((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String decodeTaggedString(long tag) {
        String string;
        ProtobufDecoder protobufDecoder = this;
        long tag$iv = tag;
        try {
            if (tag != 19500L) {
                return this.reader.readString();
            }
            string = this.reader.readStringNoTag();
        }
        catch (ProtobufDecodingException e$iv) {
            void var1_3;
            void tag$iv$iv;
            void e$iv$iv;
            ProtobufDecoder protobufDecoder2 = protobufDecoder;
            long l = tag$iv;
            e$iv$iv = e$iv$iv;
            void var11_8 = tag$iv$iv;
            throw new ProtobufDecodingException("Error while decoding proto number " + (int)(var11_8 & Integer.MAX_VALUE) + " of " + protobufDecoder2.descriptor.getSerialName(), (Throwable)var1_3);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int decodeTaggedEnum(long tag, SerialDescriptor enumDescription) {
        void var1_1;
        void var3_2;
        Intrinsics.checkNotNullParameter((Object)enumDescription, (String)"enumDescription");
        return this.findIndexByTag((SerialDescriptor)var3_2, this.decodeTaggedInt((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T decodeSerializableValue(DeserializationStrategy<? extends T> deserializer) {
        void var1_1;
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        return this.decodeSerializableValue((DeserializationStrategy<? extends T>)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected <T> T decodeSerializableValue(DeserializationStrategy<? extends T> deserializer, T previousValue) {
        void var2_2;
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        try {
            previousValue = deserializer instanceof MapLikeSerializer ? this.deserializeMap(deserializer, previousValue) : (Intrinsics.areEqual((Object)deserializer.getDescriptor(), (Object)BuiltinSerializersKt.ByteArraySerializer().getDescriptor()) ? (Object)this.deserializeByteArray((byte[])previousValue) : (deserializer instanceof AbstractCollectionSerializer ? ((AbstractCollectionSerializer)deserializer).merge((Decoder)this, previousValue) : deserializer.deserialize((Decoder)this)));
        }
        catch (ProtobufDecodingException e) {
            void var2_3;
            void var1_1;
            String string;
            long currentTag = this.getCurrentTagOrDefault();
            if (!Intrinsics.areEqual((Object)this.descriptor, (Object)deserializer.getDescriptor())) {
                if (Intrinsics.areEqual((Object)this.descriptor.getKind(), (Object)StructureKind.LIST.INSTANCE) && !Intrinsics.areEqual((Object)deserializer.getDescriptor().getKind(), (Object)StructureKind.MAP.INSTANCE)) {
                    long l = currentTag;
                    string = "Error while decoding index " + ((int)(l & Integer.MAX_VALUE) - 1) + " in repeated field of " + deserializer.getDescriptor().getSerialName();
                } else if (Intrinsics.areEqual((Object)this.descriptor.getKind(), (Object)StructureKind.MAP.INSTANCE)) {
                    long l = currentTag;
                    int index = ((int)(l & Integer.MAX_VALUE) - 1) / 2;
                    long l2 = currentTag;
                    String field = ((int)(l2 & Integer.MAX_VALUE) - 1) % 2 == 0 ? "key" : "value";
                    string = "Error while decoding " + field + " of index " + index + " in map field of " + deserializer.getDescriptor().getSerialName();
                } else {
                    long l = currentTag;
                    string = "Error while decoding " + deserializer.getDescriptor().getSerialName() + " at proto number " + (int)(l & Integer.MAX_VALUE) + " of " + this.descriptor.getSerialName();
                }
            } else {
                string = "Error while decoding " + this.descriptor.getSerialName();
            }
            String msg = string;
            throw new ProtobufDecodingException((String)var1_1, (Throwable)var2_3);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] deserializeByteArray(byte[] previousValue) {
        void var2_6;
        void var1_1;
        byte[] byArray;
        long tag2 = this.getCurrentTagOrDefault();
        ProtobufDecoder protobufDecoder = this;
        long tag$iv = tag2;
        try {
            byArray = tag2 == 19500L ? this.reader.readByteArrayNoTag() : this.reader.readByteArray();
        }
        catch (ProtobufDecodingException e$iv) {
            void var1_3;
            void this_$iv$iv;
            void tag$iv$iv;
            void e$iv$iv;
            void this_$iv;
            void tag2 = this_$iv;
            long l = tag$iv;
            e$iv$iv = e$iv$iv;
            void var13_10 = tag$iv$iv;
            throw new ProtobufDecodingException("Error while decoding proto number " + (int)(var13_10 & Integer.MAX_VALUE) + " of " + this_$iv$iv.descriptor.getSerialName(), (Throwable)var1_3);
        }
        byte[] array = byArray;
        void v1 = var1_1;
        if (v1 == null) {
            return array;
        }
        return ArraysKt.plus((byte[])v1, (byte[])var2_6);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> T deserializeMap(DeserializationStrategy<? extends T> deserializer, T previousValue) {
        void var2_4;
        Iterator iterator;
        Intrinsics.checkNotNull(deserializer, (String)"null cannot be cast to non-null type kotlinx.serialization.internal.MapLikeSerializer<kotlin.Any?, kotlin.Any?, T of kotlinx.serialization.protobuf.internal.ProtobufDecoder.deserializeMap, *>");
        MapLikeSerializer serializer = (MapLikeSerializer)deserializer;
        Object mapEntrySerial = BuiltinSerializersKt.MapEntrySerializer((KSerializer)serializer.getKeySerializer(), (KSerializer)serializer.getValueSerializer());
        Map map = previousValue instanceof Map ? (Map)previousValue : null;
        Set oldSet = map != null ? map.entrySet() : null;
        KSerializer kSerializer = BuiltinSerializersKt.SetSerializer((KSerializer)mapEntrySerial);
        Intrinsics.checkNotNull((Object)kSerializer, (String)"null cannot be cast to non-null type kotlinx.serialization.internal.AbstractCollectionSerializer<kotlin.collections.Map.Entry<kotlin.Any?, kotlin.Any?>, kotlin.collections.Set<kotlin.collections.Map.Entry<kotlin.Any?, kotlin.Any?>>, *>");
        mapEntrySerial = (Set)((AbstractCollectionSerializer)kSerializer).merge((Decoder)this, oldSet);
        Iterable $this$associateBy$iv = (Iterable)mapEntrySerial;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object k;
            Object element$iv$iv = iterator.next();
            Map.Entry entry = (Map.Entry)element$iv$iv;
            Map map2 = destination$iv$iv;
            Map.Entry it = (Map.Entry)k;
            k = it.getKey();
            entry = it.getValue();
            map2.put(k, entry);
        }
        return (T)((Object)var2_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long getTag(SerialDescriptor $this$getTag, int index) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"<this>");
        return HelpersKt.extractParameters((SerialDescriptor)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public int decodeElementIndex(SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        try {
            void var3_4;
            int index;
            int protoId;
            while (true) {
                if ((protoId = this.reader.readTag()) == -1) {
                    return this.elementMarker.nextUnmarkedIndex();
                }
                if (protoId == 0) {
                    throw new SerializationException("0 is not allowed as the protobuf field number in " + descriptor.getSerialName() + ", the input bytes may have been corrupted");
                }
                index = this.getIndexByNum(protoId);
                if (index != -1) break;
                this.reader.skipElement();
            }
            if (HelpersKt.isOneOf(HelpersKt.extractParameters(descriptor, index))) {
                Map<Integer, Integer> map = this.index2IdMap;
                if (map != null) {
                    map.put(index, protoId);
                }
            }
            this.elementMarker.mark(index);
            return (int)var3_4;
        }
        catch (ProtobufDecodingException e) {
            void var2_3;
            void var1_1;
            throw new ProtobufDecodingException("Fail to get element index for " + var1_1.getSerialName() + " in " + this.descriptor.getSerialName(), (Throwable)var2_3);
        }
    }

    @Override
    public boolean decodeNotNullMark() {
        return !this.nullValue;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean readIfAbsent(SerialDescriptor descriptor, int index) {
        if (!descriptor.isElementOptional(index)) {
            void var1_1;
            void var2_3;
            SerialDescriptor elementDescriptor = descriptor.getElementDescriptor(index);
            SerialKind kind = elementDescriptor.getKind();
            if (Intrinsics.areEqual((Object)kind, (Object)StructureKind.MAP.INSTANCE) || Intrinsics.areEqual((Object)var2_3, (Object)StructureKind.LIST.INSTANCE)) {
                this.nullValue = false;
                return true;
            }
            if (var1_1.isNullable()) {
                this.nullValue = true;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean access$readIfAbsent(ProtobufDecoder $this, SerialDescriptor descriptor, int index) {
        void var2_2;
        void var1_1;
        return $this.readIfAbsent((SerialDescriptor)var1_1, (int)var2_2);
    }
}

