/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.protobuf.ProtoBuf;
import kotlinx.serialization.protobuf.ProtoNumber;
import kotlinx.serialization.protobuf.internal.HelpersKt;
import kotlinx.serialization.protobuf.internal.ProtobufDecoder;
import kotlinx.serialization.protobuf.internal.ProtobufDecodingKt;
import kotlinx.serialization.protobuf.internal.ProtobufReader;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0013\u001a\u00020\u00128\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014"}, d2={"Lkotlinx/serialization/protobuf/internal/OneOfElementReader;", "Lkotlinx/serialization/protobuf/internal/ProtobufDecoder;", "Lkotlinx/serialization/protobuf/ProtoBuf;", "proto", "Lkotlinx/serialization/protobuf/internal/ProtobufReader;", "decoder", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "<init>", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/internal/ProtobufReader;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "Lkotlinx/serialization/encoding/CompositeDecoder;", "beginStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlinx/serialization/encoding/CompositeDecoder;", "", "decodeElementIndex", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)I", "classId", "I", "", "contentDecoded", "Z"})
@SourceDebugExtension(value={"SMAP\nProtobufDecoding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtobufDecoding.kt\nkotlinx/serialization/protobuf/internal/OneOfElementReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,551:1\n808#2,11:552\n*S KotlinDebug\n*F\n+ 1 ProtobufDecoding.kt\nkotlinx/serialization/protobuf/internal/OneOfElementReader\n*L\n505#1:552,11\n*E\n"})
final class OneOfElementReader
extends ProtobufDecoder {
    private final int classId;
    private boolean contentDecoded;

    /*
     * WARNING - void declaration
     */
    public OneOfElementReader(ProtoBuf proto, ProtobufReader decoder, SerialDescriptor descriptor) {
        void var1_1;
        void var2_2;
        Iterator $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        super((ProtoBuf)proto, decoder, descriptor);
        if (!(descriptor.getElementsCount() == 1)) {
            proto = "Implementation of oneOf type " + descriptor.getSerialName() + " should contain only 1 element, but get " + descriptor.getElementsCount();
            throw new IllegalArgumentException(proto.toString());
        }
        proto = descriptor.getElementAnnotations(0);
        Collection destination$iv$iv = new ArrayList();
        $this$filterIsInstanceTo$iv$iv = $this$filterIsInstanceTo$iv$iv.iterator();
        while ($this$filterIsInstanceTo$iv$iv.hasNext()) {
            Object element$iv$iv = $this$filterIsInstanceTo$iv$iv.next();
            if (!(element$iv$iv instanceof ProtoNumber)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object protoNumber = (ProtoNumber)CollectionsKt.singleOrNull((List)((List)var2_2));
        if (!(protoNumber != null)) {
            void var3_3;
            protoNumber = "Implementation of oneOf type " + var3_3.getSerialName() + " should have @ProtoNumber annotation";
            throw new IllegalArgumentException(protoNumber.toString());
        }
        this.classId = var1_1.number();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CompositeDecoder beginStructure(SerialDescriptor descriptor) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE) || serialKind instanceof PolymorphicKind) {
            void var3_3;
            long tag = this.getCurrentTagOrDefault();
            if (tag == 19500L && Intrinsics.areEqual((Object)this.descriptor, (Object)descriptor)) {
                return this;
            }
            if (HelpersKt.isOneOf(tag)) {
                throw new SerializationException("An oneof element cannot be directly child of another oneof element");
            }
            return new ProtobufDecoder(this.proto, ProtobufDecodingKt.access$makeDelimited(this.reader, (long)var3_3), descriptor);
        }
        throw new SerializationException("Type " + var1_1.getKind() + " cannot be directly child of oneof element");
    }

    @Override
    public final int decodeElementIndex(SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.contentDecoded) {
            return -1;
        }
        this.contentDecoded = true;
        return 0;
    }
}

