/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.ContextAwareKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorKt;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.protobuf.ProtoIntegerType;
import kotlinx.serialization.protobuf.ProtoNumber;
import kotlinx.serialization.protobuf.ProtoOneOf;
import kotlinx.serialization.protobuf.ProtoPacked;
import kotlinx.serialization.protobuf.ProtoType;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u001a#\u0010\u0004\u001a\u00060\u0000j\u0002`\u0001*\u00060\u0000j\u0002`\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u001f\u0010\b\u001a\u00060\u0000j\u0002`\u0001*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\b\u0010\t\u001a'\u0010\r\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0000\u00a2\u0006\u0004\b\r\u0010\u000e\u001a'\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016*\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a%\u0010\u0019\u001a\u0004\u0018\u00010\u0006*\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001a\"\u001c\u0010\u001e\u001a\u00020\u001b*\u00060\u0000j\u0002`\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\"\u0018\u0010\u001f\u001a\u00020\u000b*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \"\u001c\u0010!\u001a\u00020\u000b*\u00060\u0000j\u0002`\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\"\u001c\u0010#\u001a\u00020\u000b*\u00060\u0000j\u0002`\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\"*\f\b\u0000\u0010$\"\u00020\u00002\u00020\u0000"}, d2={"", "Lkotlinx/serialization/protobuf/internal/ProtoDesc;", "", "protoId", "overrideId", "(JI)J", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "index", "extractParameters", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)J", "descriptor", "", "zeroBasedDefault", "extractProtoId", "(Lkotlinx/serialization/descriptors/SerialDescriptor;IZ)I", "fieldNumber", "propertyIndex", "", "checkFieldNumber", "(IILkotlinx/serialization/descriptors/SerialDescriptor;)V", "Lkotlinx/serialization/modules/SerializersModule;", "serializersModule", "", "getAllOneOfSerializerOfField", "(Lkotlinx/serialization/descriptors/SerialDescriptor;Lkotlinx/serialization/modules/SerializersModule;)Ljava/util/List;", "getActualOneOfSerializer", "(Lkotlinx/serialization/descriptors/SerialDescriptor;Lkotlinx/serialization/modules/SerializersModule;I)Lkotlinx/serialization/descriptors/SerialDescriptor;", "Lkotlinx/serialization/protobuf/ProtoIntegerType;", "getIntegerType", "(J)Lkotlinx/serialization/protobuf/ProtoIntegerType;", "integerType", "isPackable", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Z", "isPacked", "(J)Z", "isOneOf", "ProtoDesc"})
@SourceDebugExtension(value={"SMAP\nHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Helpers.kt\nkotlinx/serialization/protobuf/internal/HelpersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n56#1,3:173\n61#1:182\n2756#2:176\n2746#2,3:178\n1#3:177\n1#3:181\n*S KotlinDebug\n*F\n+ 1 Helpers.kt\nkotlinx/serialization/protobuf/internal/HelpersKt\n*L\n114#1:173,3\n170#1:182\n159#1:176\n160#1:178,3\n159#1:177\n*E\n"})
public final class HelpersKt {
    public static final ProtoIntegerType getIntegerType(long $this$integerType) {
        long l = $this$integerType & 0x600000000L;
        if (l == ProtoIntegerType.DEFAULT.getSignature$kotlinx_serialization_protobuf()) {
            return ProtoIntegerType.DEFAULT;
        }
        if (l == ProtoIntegerType.SIGNED.getSignature$kotlinx_serialization_protobuf()) {
            return ProtoIntegerType.SIGNED;
        }
        return ProtoIntegerType.FIXED;
    }

    public static final boolean isPackable(SerialDescriptor $this$isPackable) {
        SerialDescriptor serialDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$isPackable, (String)"<this>");
        serialDescriptor = serialDescriptor.getKind();
        return !Intrinsics.areEqual((Object)serialDescriptor, (Object)PrimitiveKind.STRING.INSTANCE) && serialDescriptor instanceof PrimitiveKind;
    }

    public static final boolean isPacked(long $this$isPacked) {
        return ($this$isPacked & 0x100000000L) != 0L;
    }

    public static final boolean isOneOf(long $this$isOneOf) {
        return ($this$isOneOf & 0x1000000000L) != 0L;
    }

    /*
     * WARNING - void declaration
     */
    public static final long overrideId(long $this$overrideId, int protoId) {
        void var2_1;
        return $this$overrideId & 0xFFFFFFF00000000L | (long)var2_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final long extractParameters(SerialDescriptor $this$extractParameters, int index) {
        void protoId$iv;
        void type$iv;
        void var0_1;
        void packed$iv;
        void var3_4;
        int i;
        Intrinsics.checkNotNullParameter((Object)$this$extractParameters, (String)"<this>");
        List annotations = $this$extractParameters.getElementAnnotations(index);
        int protoId = index + 1;
        ProtoIntegerType format = ProtoIntegerType.DEFAULT;
        boolean protoPacked = false;
        boolean isOneOf = false;
        int n = ((Collection)annotations).size();
        for (i = 0; i < n; ++i) {
            Annotation annotation = (Annotation)annotations.get(i);
            if (annotation instanceof ProtoNumber) {
                protoId = ((ProtoNumber)annotation).number();
                HelpersKt.checkFieldNumber(protoId, i, $this$extractParameters);
                continue;
            }
            if (annotation instanceof ProtoType) {
                format = ((ProtoType)annotation).type();
                continue;
            }
            if (annotation instanceof ProtoPacked) {
                protoPacked = true;
                continue;
            }
            if (!(annotation instanceof ProtoOneOf)) continue;
            isOneOf = true;
        }
        if (isOneOf) {
            void var1_2;
            protoId = var1_2 + true;
        }
        i = var3_4;
        ProtoIntegerType protoIntegerType = format;
        boolean annotation = protoPacked;
        boolean oneOf$iv = isOneOf;
        long packedBits$iv = packed$iv != false ? 0x100000000L : 0L;
        long oneOfBits$iv = var0_1 != false ? 0x1000000000L : 0L;
        return packedBits$iv | oneOfBits$iv | type$iv.getSignature$kotlinx_serialization_protobuf() | (long)protoId$iv;
    }

    /*
     * WARNING - void declaration
     */
    public static final int extractProtoId(SerialDescriptor descriptor, int index, boolean zeroBasedDefault) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        List annotations = descriptor.getElementAnnotations(index);
        int result = zeroBasedDefault ? index : index + 1;
        int n = ((Collection)annotations).size();
        for (int i = 0; i < n; ++i) {
            Annotation annotation = (Annotation)annotations.get(i);
            if (annotation instanceof ProtoOneOf) {
                return -2;
            }
            if (!(annotation instanceof ProtoNumber)) continue;
            result = ((ProtoNumber)annotation).number();
            if (zeroBasedDefault) continue;
            HelpersKt.checkFieldNumber(result, i, descriptor);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkFieldNumber(int fieldNumber, int propertyIndex, SerialDescriptor descriptor) {
        if (fieldNumber <= 0) {
            void var2_2;
            void var1_1;
            int n;
            throw new SerializationException(n + " is not allowed in ProtoNumber for property '" + descriptor.getElementName((int)var1_1) + "' of '" + var2_2.getSerialName() + "', because protobuf supports field numbers in range 1..2147483647");
        }
    }

    public static final List<SerialDescriptor> getAllOneOfSerializerOfField(SerialDescriptor $this$getAllOneOfSerializerOfField, SerializersModule serializersModule) {
        List list;
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)$this$getAllOneOfSerializerOfField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        Object object = $this$getAllOneOfSerializerOfField.getKind();
        if (Intrinsics.areEqual((Object)object, (Object)PolymorphicKind.OPEN.INSTANCE)) {
            list = ContextAwareKt.getPolymorphicDescriptors((SerializersModule)iterable, (SerialDescriptor)$this$getAllOneOfSerializerOfField);
        } else if (Intrinsics.areEqual((Object)object, (Object)PolymorphicKind.SEALED.INSTANCE)) {
            list = CollectionsKt.toList((Iterable)SerialDescriptorKt.getElementDescriptors((SerialDescriptor)$this$getAllOneOfSerializerOfField.getElementDescriptor(1)));
        } else {
            throw new IllegalArgumentException("Class " + $this$getAllOneOfSerializerOfField.getSerialName() + " should be abstract or sealed or interface to be used as @ProtoOneOf property.");
        }
        Iterable iterable2 = list;
        object = iterable2;
        iterable = iterable2;
        object = iterable2;
        for (Object e : iterable2) {
            boolean bl;
            SerialDescriptor desc = (SerialDescriptor)e;
            Iterable $this$none$iv = desc.getElementAnnotations(0);
            if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) {
                for (Object object2 : $this$none$iv) {
                    if (!((object2 = (Annotation)object2) instanceof ProtoNumber)) continue;
                    bl = false;
                    break;
                }
            } else {
                bl = true;
            }
            if (!bl) continue;
            throw new IllegalArgumentException(e.getSerialName() + " implementing oneOf type " + $this$getAllOneOfSerializerOfField.getSerialName() + " should have @ProtoNumber annotation in its single property.");
        }
        return (List)iterable;
    }

    public static final SerialDescriptor getActualOneOfSerializer(SerialDescriptor $this$getActualOneOfSerializer, SerializersModule serializersModule, int protoId) {
        Object v0;
        block1: {
            Object e;
            Object object;
            Intrinsics.checkNotNullParameter((Object)$this$getActualOneOfSerializer, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
            object = HelpersKt.getAllOneOfSerializerOfField((SerialDescriptor)object, (SerializersModule)e);
            object = object.iterator();
            while (object.hasNext()) {
                e = object.next();
                SerialDescriptor serialDescriptor = (SerialDescriptor)e;
                long l = HelpersKt.extractParameters(serialDescriptor, 0);
                if (!((int)(l & Integer.MAX_VALUE) == protoId)) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

