/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0010\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0014\u0010\bJ\u0015\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001a\u0010\bJ\u0015\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0015\u00a2\u0006\u0004\b\u001b\u0010\u0018J\u001f\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0016\u0010#\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$"}, d2={"Lkotlinx/serialization/protobuf/internal/ByteArrayOutput;", "", "<init>", "()V", "", "elementsToAppend", "", "ensureCapacity", "(I)V", "size", "()I", "", "toByteArray", "()[B", "buffer", "write", "([B)V", "output", "(Lkotlinx/serialization/protobuf/internal/ByteArrayOutput;)V", "intValue", "writeInt", "", "longValue", "writeLong", "(J)V", "value", "encodeVarint32", "encodeVarint64", "length", "encodeVarint", "(JI)V", "varIntLength", "(J)I", "array", "[B", "position", "I", "Companion"})
public final class ByteArrayOutput {
    private static final Companion Companion = new Companion(null);
    private byte[] array = new byte[32];
    private int position;
    private static final int[] VAR_INT_LENGTHS;

    /*
     * WARNING - void declaration
     */
    private final void ensureCapacity(int elementsToAppend) {
        void var1_2;
        if (this.position + elementsToAppend <= this.array.length) {
            return;
        }
        byte[] newArray = new byte[Integer.highestOneBit(this.position + elementsToAppend) << 1];
        ArraysKt.copyInto$default((byte[])this.array, (byte[])newArray, (int)0, (int)0, (int)0, (int)14, null);
        this.array = var1_2;
    }

    public final int size() {
        return this.position;
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] toByteArray() {
        void var1_1;
        byte[] newArray = new byte[this.position];
        ArraysKt.copyInto$default((byte[])this.array, (byte[])newArray, (int)0, (int)0, (int)this.position, (int)2, null);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void write(byte[] buffer) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int count = buffer.length;
        if (count == 0) {
            return;
        }
        this.ensureCapacity(count);
        ArraysKt.copyInto((byte[])var1_1, (byte[])this.array, (int)this.position, (int)0, (int)count);
        this.position += var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void write(ByteArrayOutput output) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        int count = output.size();
        this.ensureCapacity(count);
        ArraysKt.copyInto((byte[])var1_1.array, (byte[])this.array, (int)this.position, (int)0, (int)count);
        this.position += var2_2;
    }

    public final void writeInt(int intValue) {
        this.ensureCapacity(4);
        for (int i = 3; i >= 0; --i) {
            int n = this.position;
            this.position = n + 1;
            this.array[n] = (byte)(intValue >> (i << 3));
        }
    }

    public final void writeLong(long longValue) {
        this.ensureCapacity(8);
        for (int i = 7; i >= 0; --i) {
            int n = this.position;
            this.position = n + 1;
            this.array[n] = (byte)(longValue >> (i << 3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void encodeVarint32(int value) {
        void var2_3;
        void var1_1;
        this.ensureCapacity(5);
        if ((value & 0xFFFFFF80) == 0) {
            int n = this.position;
            this.position = n + 1;
            this.array[n] = (byte)value;
            return;
        }
        int length = this.varIntLength(value);
        this.encodeVarint((long)var1_1, (int)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public final void encodeVarint64(long value) {
        void var3_2;
        void var1_1;
        int length = this.varIntLength(value);
        this.ensureCapacity(length + 1);
        this.encodeVarint((long)var1_1, (int)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    private final void encodeVarint(long value, int length) {
        void var3_3;
        long current = value;
        for (int i = 0; i < length; ++i) {
            this.array[this.position + i] = (byte)(current & 0x7FL | 0x80L);
            current >>>= 7;
        }
        this.array[this.position + length] = (byte)current;
        this.position += var3_3 + true;
    }

    /*
     * WARNING - void declaration
     */
    private final int varIntLength(long value) {
        void var1_1;
        return VAR_INT_LENGTHS[Long.numberOfLeadingZeros((long)var1_1)];
    }

    static {
        int n = 0;
        int[] nArray = new int[65];
        while (n < 65) {
            int n2 = n++;
            nArray[n2] = (63 - n2) / 7;
        }
        VAR_INT_LENGTHS = nArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006"}, d2={"Lkotlinx/serialization/protobuf/internal/ByteArrayOutput$Companion;", "", "<init>", "()V", "", "VAR_INT_LENGTHS", "[I"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

