/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\t\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000e\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0018\u0010\fJ\u0015\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\"\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\"\u0010\fR\u0016\u0010\u0003\u001a\u00020\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0003\u0010#R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010$R\u0016\u0010%\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010$R\u0011\u0010'\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\f"}, d2={"Lkotlinx/serialization/protobuf/internal/ByteArrayInput;", "", "", "array", "", "endIndex", "<init>", "([BI)V", "size", "slice", "(I)Lkotlinx/serialization/protobuf/internal/ByteArrayInput;", "read", "()I", "bytesCount", "readExactNBytes", "(I)[B", "", "skipExactNBytes", "(I)V", "ensureEnoughBytes", "length", "", "readString", "(I)Ljava/lang/String;", "readVarint32", "", "eofAllowed", "", "readVarint64", "(Z)J", "eof", "()V", "readVarint64SlowPath", "()J", "readVarint32SlowPath", "[B", "I", "position", "getAvailableBytes", "availableBytes"})
public final class ByteArrayInput {
    private byte[] array;
    private final int endIndex;
    private int position;

    /*
     * WARNING - void declaration
     */
    public ByteArrayInput(byte[] array, int endIndex) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.array = var1_1;
        this.endIndex = var2_2;
    }

    public /* synthetic */ ByteArrayInput(byte[] byArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = byArray.length;
        }
        this(byArray, n);
    }

    public final int getAvailableBytes() {
        return this.endIndex - this.position;
    }

    /*
     * WARNING - void declaration
     */
    public final ByteArrayInput slice(int size) {
        void var2_2;
        void var1_1;
        this.ensureEnoughBytes(size);
        ByteArrayInput result = new ByteArrayInput(this.array, this.position + size);
        new ByteArrayInput(this.array, this.position + size).position = this.position;
        this.position += var1_1;
        return var2_2;
    }

    public final int read() {
        if (this.position < this.endIndex) {
            int n = this.position;
            this.position = n + 1;
            return this.array[n] & 0xFF;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] readExactNBytes(int bytesCount) {
        void var1_2;
        void var2_3;
        void copied;
        this.ensureEnoughBytes(bytesCount);
        byte[] b = new byte[bytesCount];
        int length = b.length;
        copied = this.endIndex - this.position < length ? this.endIndex - this.position : copied;
        ArraysKt.copyInto((byte[])this.array, (byte[])b, (int)0, (int)this.position, (int)(this.position + copied));
        this.position += var2_3;
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void skipExactNBytes(int bytesCount) {
        void var1_1;
        this.ensureEnoughBytes(bytesCount);
        this.position += var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureEnoughBytes(int bytesCount) {
        if (bytesCount > this.getAvailableBytes()) {
            void var1_1;
            throw new SerializationException("Unexpected EOF, available " + this.getAvailableBytes() + " bytes, requested: " + (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String readString(int length) {
        void var2_2;
        void var1_1;
        String result = StringsKt.decodeToString$default((byte[])this.array, (int)this.position, (int)(this.position + length), (boolean)false, (int)4, null);
        this.position += var1_1;
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final int readVarint32() {
        int result;
        if (this.position == this.endIndex) {
            this.eof();
        }
        int currentPosition = this.position;
        if ((result = this.array[currentPosition++]) >= 0) {
            this.position = currentPosition;
            return result;
        }
        if (this.endIndex - this.position > 1 && (result ^= this.array[currentPosition++] << 7) < 0) {
            void var2_2;
            void var1_1;
            this.position = var1_1;
            return var2_2 ^ 0xFFFFFF80;
        }
        return this.readVarint32SlowPath();
    }

    /*
     * WARNING - void declaration
     */
    public final long readVarint64(boolean eofAllowed) {
        long result;
        if (this.position == this.endIndex) {
            if (eofAllowed) {
                return -1L;
            }
            this.eof();
        }
        int currentPosition = this.position;
        if ((result = (long)this.array[currentPosition++]) >= 0L) {
            this.position = currentPosition;
            return result;
        }
        if (this.endIndex - this.position > 1 && (result ^= (long)this.array[currentPosition++] << 7) < 0L) {
            void var3_2;
            void var1_1;
            this.position = var1_1;
            return (long)(var3_2 ^ 0xFFFFFFFFFFFFFF80L);
        }
        return this.readVarint64SlowPath();
    }

    private final void eof() {
        throw new SerializationException("Unexpected EOF");
    }

    private final long readVarint64SlowPath() {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            int n = this.read();
            result |= (long)(n & 0x7F) << shift;
            if ((n & 0x80) != 0) continue;
            return result;
        }
        throw new SerializationException("Input stream is malformed: Varint too long (exceeded 64 bits)");
    }

    /*
     * WARNING - void declaration
     */
    private final int readVarint32SlowPath() {
        int result = 0;
        for (int shift = 0; shift < 32; shift += 7) {
            void var3_3;
            int n = this.read();
            result |= (n & 0x7F) << shift;
            if ((var3_3 & 0x80) != 0) continue;
            return result;
        }
        throw new SerializationException("Input stream is malformed: Varint too long (exceeded 32 bits)");
    }
}

