/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.sse;

import java.io.Closeable;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.EventListener;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.sse.ServerSentEventReader;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J+\u0010\u0015\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010#\u001a\u00020\n2\u0006\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010%\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b%\u0010&J\u0013\u0010)\u001a\u00020(*\u00020'H\u0002\u00a2\u0006\u0004\b)\u0010*R\u0016\u0010\u0018\u001a\u00020+8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u0018\u0010,R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010-R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010."}, d2={"Lokhttp3/internal/sse/RealEventSource;", "Lokhttp3/sse/EventSource;", "Lokhttp3/internal/sse/ServerSentEventReader$Callback;", "Lokhttp3/Callback;", "Lokhttp3/Request;", "request", "Lokhttp3/sse/EventSourceListener;", "listener", "<init>", "(Lokhttp3/Request;Lokhttp3/sse/EventSourceListener;)V", "", "cancel", "()V", "Lokhttp3/OkHttpClient;", "client", "connect", "(Lokhttp3/OkHttpClient;)V", "", "id", "type", "data", "onEvent", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "Lokhttp3/Call;", "call", "Ljava/io/IOException;", "e", "onFailure", "(Lokhttp3/Call;Ljava/io/IOException;)V", "Lokhttp3/Response;", "response", "onResponse", "(Lokhttp3/Call;Lokhttp3/Response;)V", "", "timeMs", "onRetryChange", "(J)V", "processResponse", "(Lokhttp3/Response;)V", "Lokhttp3/ResponseBody;", "", "isEventStream", "(Lokhttp3/ResponseBody;)Z", "Lokhttp3/internal/connection/RealCall;", "Lokhttp3/internal/connection/RealCall;", "Lokhttp3/sse/EventSourceListener;", "Lokhttp3/Request;"})
public final class RealEventSource
implements Callback,
ServerSentEventReader.Callback,
EventSource {
    private final Request request;
    private final EventSourceListener listener;
    private RealCall call;

    /*
     * WARNING - void declaration
     */
    public RealEventSource(Request request, EventSourceListener listener) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.request = var1_1;
        this.listener = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void connect(OkHttpClient client) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        client = client.newBuilder().eventListener(EventListener.NONE).build();
        Call call = var1_1.newCall(this.request);
        Intrinsics.checkNotNull((Object)call, (String)"null cannot be cast to non-null type okhttp3.internal.connection.RealCall");
        this.call = (RealCall)call;
        RealCall realCall = this.call;
        if (realCall == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"call");
            realCall = null;
        }
        realCall.enqueue((Callback)this);
    }

    /*
     * WARNING - void declaration
     */
    public final void onResponse(Call call, Response response) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.processResponse((Response)var2_2);
    }

    public final void processResponse(Response response) {
        Throwable throwable;
        ResponseBody body;
        Throwable throwable2;
        Closeable closeable;
        block12: {
            block11: {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                closeable = (Closeable)response;
                throwable2 = null;
                Response cfr_ignored_0 = (Response)closeable;
                if (response.isSuccessful()) break block11;
                this.listener.onFailure(this, null, response);
                CloseableKt.closeFinally((Closeable)closeable, null);
                return;
            }
            ResponseBody responseBody = response.body();
            Intrinsics.checkNotNull((Object)responseBody);
            body = responseBody;
            if (this.isEventStream(body)) break block12;
            this.listener.onFailure(this, new IllegalStateException("Invalid content-type: " + body.contentType()), response);
            CloseableKt.closeFinally((Closeable)closeable, null);
            return;
        }
        RealCall realCall = this.call;
        if (realCall == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"call");
            realCall = null;
        }
        realCall.timeoutEarlyExit();
        response = response.newBuilder().body(Util.EMPTY_RESPONSE).build();
        ServerSentEventReader reader = new ServerSentEventReader(body.source(), this);
        try {
            this.listener.onOpen(this, response);
            while (reader.processNextEvent()) {
            }
        }
        catch (Exception e) {
            this.listener.onFailure(this, e, (Response)throwable);
            CloseableKt.closeFinally((Closeable)closeable, null);
            return;
        }
        try {
            this.listener.onClosed(this);
        }
        catch (Throwable throwable3) {
            try {
                throwable = throwable3;
                throwable2 = throwable3;
                throw throwable;
            }
            catch (Throwable throwable4) {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                throw throwable4;
            }
        }
        CloseableKt.closeFinally((Closeable)closeable, null);
        return;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isEventStream(ResponseBody $this$isEventStream) {
        void var1_1;
        MediaType mediaType = $this$isEventStream.contentType();
        if (mediaType == null) {
            return false;
        }
        MediaType contentType = mediaType;
        return Intrinsics.areEqual((Object)mediaType.type(), (Object)"text") && Intrinsics.areEqual((Object)var1_1.subtype(), (Object)"event-stream");
    }

    /*
     * WARNING - void declaration
     */
    public final void onFailure(Call call, IOException e) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.listener.onFailure(this, (Throwable)var2_2, null);
    }

    @Override
    public final void cancel() {
        RealCall realCall = this.call;
        if (realCall == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"call");
            realCall = null;
        }
        realCall.cancel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onEvent(String id, String type, String data) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.listener.onEvent(this, (String)var1_1, (String)var2_2, (String)var3_3);
    }

    @Override
    public final void onRetryChange(long timeMs) {
    }
}

