/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.support.eventmanager;

import com.sun.jna.Callback;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import uk.co.caprica.vlcj.binding.internal.libvlc_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_manager_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.support.eventmanager.EventNotification;

public abstract class NativeEventManager<E, L> {
    private final libvlc_instance_t libvlcInstance;
    private final E eventObject;
    private final libvlc_event_e firstEvent;
    private final libvlc_event_e lastEvent;
    private final String callbackName;
    private final List<L> eventListenerList = new CopyOnWriteArrayList<L>();
    private EventCallback callback;
    private boolean callbackRegistered;

    /*
     * WARNING - void declaration
     */
    protected NativeEventManager(libvlc_instance_t libvlcInstance, E eventObject, libvlc_event_e firstEvent, libvlc_event_e lastEvent, String callbackName) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.libvlcInstance = var1_1;
        this.eventObject = var2_2;
        this.firstEvent = var3_3;
        this.lastEvent = lastEvent;
        this.callbackName = callbackName;
    }

    /*
     * WARNING - void declaration
     */
    public final void addEventListener(L listener) {
        if (listener != null) {
            void var1_1;
            this.eventListenerList.add(var1_1);
            this.addNativeEventListener();
            return;
        }
        throw new IllegalArgumentException("Listener must not be null");
    }

    /*
     * WARNING - void declaration
     */
    public final void removeEventListener(L listener) {
        void var1_1;
        this.eventListenerList.remove(var1_1);
        this.removeNativeEventListener();
    }

    private void addNativeEventListener() {
        if (!this.callbackRegistered && !this.eventListenerList.isEmpty()) {
            this.callbackRegistered = true;
            this.callback = new EventCallback();
            NativeEventManager nativeEventManager = this;
            libvlc_event_manager_t mediaEventManager = nativeEventManager.onGetEventManager(nativeEventManager.eventObject);
            for (libvlc_event_e event : libvlc_event_e.values()) {
                if (event.intValue() < this.firstEvent.intValue() || event.intValue() > this.lastEvent.intValue()) continue;
                LibVlc.libvlc_event_attach((libvlc_event_manager_t)mediaEventManager, (int)event.intValue(), (libvlc_callback_t)this.callback, null);
            }
        }
    }

    private void removeNativeEventListener() {
        if (this.callbackRegistered && this.eventListenerList.isEmpty()) {
            this.callbackRegistered = false;
            NativeEventManager nativeEventManager = this;
            libvlc_event_manager_t eventManager = nativeEventManager.onGetEventManager(nativeEventManager.eventObject);
            for (libvlc_event_e event : libvlc_event_e.values()) {
                if (event.intValue() < this.firstEvent.intValue() || event.intValue() > this.lastEvent.intValue()) continue;
                LibVlc.libvlc_event_detach((libvlc_event_manager_t)eventManager, (int)event.intValue(), (libvlc_callback_t)this.callback, null);
            }
            this.callback = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void raiseEvent(EventNotification<L> event) {
        if (event != null && !this.eventListenerList.isEmpty()) {
            for (L listener : this.eventListenerList) {
                void var3_3;
                event.notify(var3_3);
            }
        }
    }

    public final void release() {
        this.eventListenerList.clear();
        this.removeNativeEventListener();
    }

    protected abstract libvlc_event_manager_t onGetEventManager(E var1);

    protected abstract EventNotification<L> onCreateEvent(libvlc_instance_t var1, libvlc_event_t var2, E var3);

    private class EventCallback
    implements libvlc_callback_t {
        private final CallbackThreadInitializer cti;

        private EventCallback() {
            this.cti = new CallbackThreadInitializer(true, false, NativeEventManager.this.callbackName);
            EventCallback eventCallback = this;
            Native.setCallbackThreadInitializer((Callback)eventCallback, (CallbackThreadInitializer)eventCallback.cti);
        }

        /*
         * WARNING - void declaration
         */
        public void callback(libvlc_event_t event, Pointer userData) {
            void var1_1;
            NativeEventManager.this.raiseEvent(NativeEventManager.this.onCreateEvent(NativeEventManager.this.libvlcInstance, (libvlc_event_t)var1_1, NativeEventManager.this.eventObject));
        }
    }
}

