/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded.videosurface;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import uk.co.caprica.vlcj.binding.internal.libvlc_display_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_lock_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_unlock_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_cleanup_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_format_cb;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.embedded.videosurface.NativeBuffers;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurface;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurfaceAdapter;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormat;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormatCallback;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.RenderCallback;

public class CallbackVideoSurface
extends VideoSurface {
    private final libvlc_video_format_cb setup = new SetupCallback();
    private final libvlc_video_cleanup_cb cleanup = new CleanupCallback();
    private final libvlc_lock_callback_t lock = new LockCallback();
    private final libvlc_unlock_callback_t unlock = new UnlockCallback();
    private final libvlc_display_callback_t display = new DisplayCallback();
    private final BufferFormatCallback bufferFormatCallback;
    private final RenderCallback renderCallback;
    private final NativeBuffers nativeBuffers;
    private MediaPlayer mediaPlayer;
    private BufferFormat bufferFormat;

    /*
     * WARNING - void declaration
     */
    public CallbackVideoSurface(BufferFormatCallback bufferFormatCallback, RenderCallback renderCallback, boolean lockBuffers, VideoSurfaceAdapter videoSurfaceAdapter) {
        super(videoSurfaceAdapter);
        void var3_3;
        void var2_2;
        void var1_1;
        this.bufferFormatCallback = var1_1;
        this.renderCallback = var2_2;
        this.nativeBuffers = new NativeBuffers((boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void attach(MediaPlayer mediaPlayer) {
        void var1_1;
        this.mediaPlayer = mediaPlayer;
        LibVlc.libvlc_video_set_format_callbacks((libvlc_media_player_t)mediaPlayer.mediaPlayerInstance(), (libvlc_video_format_cb)this.setup, (libvlc_video_cleanup_cb)this.cleanup);
        LibVlc.libvlc_video_set_callbacks((libvlc_media_player_t)var1_1.mediaPlayerInstance(), (libvlc_lock_callback_t)this.lock, (libvlc_unlock_callback_t)this.unlock, (libvlc_display_callback_t)this.display, null);
    }

    private final class SetupCallback
    implements libvlc_video_format_cb {
        private SetupCallback() {
        }

        /*
         * WARNING - void declaration
         */
        public final int format(PointerByReference opaque, PointerByReference chroma, IntByReference width, IntByReference height, PointerByReference pitches, PointerByReference lines) {
            void var1_2;
            void var3_4;
            void var2_3;
            CallbackVideoSurface.this.bufferFormat = CallbackVideoSurface.this.bufferFormatCallback.getBufferFormat(width.getValue(), height.getValue());
            SetupCallback setupCallback = this;
            setupCallback.applyBufferFormat(setupCallback.CallbackVideoSurface.this.bufferFormat, (PointerByReference)var2_3, (IntByReference)var3_4, height, pitches, lines);
            int result = CallbackVideoSurface.this.nativeBuffers.allocate(CallbackVideoSurface.this.bufferFormat);
            CallbackVideoSurface.this.bufferFormatCallback.allocatedBuffers(CallbackVideoSurface.this.nativeBuffers.buffers());
            return (int)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        private void applyBufferFormat(BufferFormat bufferFormat, PointerByReference chroma, IntByReference width, IntByReference height, PointerByReference pitches, PointerByReference lines) {
            void var1_1;
            void var2_2;
            void var3_3;
            byte[] chromaBytes = bufferFormat.getChroma().getBytes();
            chroma.getPointer().write(0L, chromaBytes, 0, chromaBytes.length < 4 ? chromaBytes.length : 4);
            var3_3.setValue(bufferFormat.getWidth());
            height.setValue(bufferFormat.getHeight());
            int[] pitchValues = bufferFormat.getPitches();
            int[] lineValues = bufferFormat.getLines();
            pitches.getPointer().write(0L, pitchValues, 0, ((void)var2_2).length);
            lines.getPointer().write(0L, lineValues, 0, ((void)var1_1).length);
        }
    }

    private final class CleanupCallback
    implements libvlc_video_cleanup_cb {
        private CleanupCallback() {
        }

        public final void cleanup(Pointer opaque) {
            CallbackVideoSurface.this.nativeBuffers.free();
        }
    }

    private final class LockCallback
    implements libvlc_lock_callback_t {
        private LockCallback() {
        }

        /*
         * WARNING - void declaration
         */
        public final Pointer lock(Pointer opaque, PointerByReference planes) {
            void var1_1;
            void var2_2;
            Pointer[] pointers = CallbackVideoSurface.this.nativeBuffers.pointers();
            var2_2.getPointer().write(0L, pointers, 0, ((void)var1_1).length);
            return null;
        }
    }

    private final class UnlockCallback
    implements libvlc_unlock_callback_t {
        private UnlockCallback() {
        }

        public final void unlock(Pointer opaque, Pointer picture, Pointer plane) {
        }
    }

    private final class DisplayCallback
    implements libvlc_display_callback_t {
        private DisplayCallback() {
        }

        public final void display(Pointer opaque, Pointer picture) {
            CallbackVideoSurface.this.renderCallback.display(CallbackVideoSurface.this.mediaPlayer, CallbackVideoSurface.this.nativeBuffers.buffers(), CallbackVideoSurface.this.bufferFormat);
        }
    }
}

