/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.component.overlay;

import com.sun.jna.platform.WindowUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import javax.swing.JWindow;

public abstract class AbstractJWindowOverlayComponent
extends JWindow {
    private int layoutWidth = -1;
    private int layoutHeight = -1;

    /*
     * WARNING - void declaration
     */
    public AbstractJWindowOverlayComponent(Window owner) {
        this((Window)var1_1, WindowUtils.getAlphaCompatibleGraphicsConfiguration());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AbstractJWindowOverlayComponent(Window owner, GraphicsConfiguration graphicsConfiguration) {
        super(owner, (GraphicsConfiguration)var2_2);
        void var1_1;
        void var2_2;
        if (var1_1 == null) {
            throw new IllegalArgumentException("The overlay window owner must not be null");
        }
        this.onSetWindowTransparency();
        this.onCreateOverlay();
        if (this.onHideCursor()) {
            AbstractJWindowOverlayComponent abstractJWindowOverlayComponent = this;
            abstractJWindowOverlayComponent.setCursor(abstractJWindowOverlayComponent.getBlankCursor());
        }
    }

    protected void onSetWindowTransparency() {
        GenericDeclaration genericDeclaration;
        String javaSpecificationVersion = System.getProperty("java.specification.version");
        if ("1.7".compareTo((String)((Object)genericDeclaration)) <= 0) {
            this.setBackground(new Color(0, 0, 0, 0));
            return;
        }
        try {
            genericDeclaration = Class.forName("com.sun.awt.AWTUtilities");
            genericDeclaration = genericDeclaration.getMethod("setWindowOpaque", Window.class, Boolean.class);
            ((Method)genericDeclaration).invoke(null, this, Boolean.FALSE);
            return;
        }
        catch (Exception exception) {
            this.setBackground(new Color(0, 0, 0, 0));
            return;
        }
    }

    protected void onCreateOverlay() {
    }

    protected boolean onHideCursor() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void paint(Graphics g) {
        void var1_1;
        this.layoutHeight = this.getHeight();
        this.layoutWidth = this.getWidth();
        if (this.layoutWidth != this.layoutWidth | this.layoutHeight != this.layoutHeight) {
            AbstractJWindowOverlayComponent abstractJWindowOverlayComponent = this;
            abstractJWindowOverlayComponent.onNewSize(abstractJWindowOverlayComponent.layoutWidth, this.layoutHeight);
        }
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        this.onPrepareGraphicsContext(g2);
        this.onPaintOverlay((Graphics2D)var1_1);
    }

    protected void onNewSize(int width, int height) {
    }

    /*
     * WARNING - void declaration
     */
    protected void onPrepareGraphicsContext(Graphics2D g2) {
        void var1_1;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        var1_1.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    protected void onPaintOverlay(Graphics2D g2) {
    }

    /*
     * WARNING - void declaration
     */
    private Cursor getBlankCursor() {
        void var1_1;
        BufferedImage blankImage = new BufferedImage(1, 1, 2);
        return Toolkit.getDefaultToolkit().createCustomCursor((Image)var1_1, new Point(0, 0), "");
    }
}

