/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.media.EventApi;
import uk.co.caprica.vlcj.media.InfoApi;
import uk.co.caprica.vlcj.media.Media;
import uk.co.caprica.vlcj.media.MediaEventListener;
import uk.co.caprica.vlcj.media.MediaFactory;
import uk.co.caprica.vlcj.media.MediaRef;
import uk.co.caprica.vlcj.media.MediaSlaveType;
import uk.co.caprica.vlcj.media.MetaApi;
import uk.co.caprica.vlcj.media.OptionsApi;
import uk.co.caprica.vlcj.media.ParseApi;
import uk.co.caprica.vlcj.media.SlaveApi;
import uk.co.caprica.vlcj.media.SubitemApi;
import uk.co.caprica.vlcj.media.callback.CallbackMedia;
import uk.co.caprica.vlcj.player.base.BaseApi;
import uk.co.caprica.vlcj.player.base.MediaPlayer;

public final class MediaApi
extends BaseApi {
    private static final String START_PAUSED_OPTION = "start-paused";
    private final List<MediaEventListener> persistentMediaEventListeners = new ArrayList<MediaEventListener>();
    private Media media;

    /*
     * WARNING - void declaration
     */
    MediaApi(MediaPlayer mediaPlayer) {
        super((MediaPlayer)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean prepare(String mrl, String ... options) {
        void var2_2;
        void var1_1;
        MediaApi mediaApi = this;
        return mediaApi.changeMedia(MediaFactory.newMedia(mediaApi.libvlcInstance, (String)var1_1, (String[])var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean play(String mrl, String ... options) {
        void var2_2;
        void var1_1;
        if (this.prepare((String)var1_1, (String[])var2_2)) {
            return this.play();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean start(String mrl, String ... options) {
        void var2_2;
        void var1_1;
        if (this.prepare((String)var1_1, (String[])var2_2)) {
            return this.start();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean prepare(CallbackMedia callbackMedia, String ... options) {
        void var2_2;
        void var1_1;
        MediaApi mediaApi = this;
        return mediaApi.changeMedia(MediaFactory.newMedia(mediaApi.libvlcInstance, (CallbackMedia)var1_1, (String[])var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean play(CallbackMedia callbackMedia, String ... options) {
        void var2_2;
        void var1_1;
        if (this.prepare((CallbackMedia)var1_1, (String[])var2_2)) {
            return this.play();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean start(CallbackMedia callbackMedia, String ... options) {
        void var2_2;
        void var1_1;
        if (this.prepare((CallbackMedia)var1_1, (String[])var2_2)) {
            return this.start();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean prepare(MediaRef mediaRef, String ... options) {
        void var2_2;
        void var1_1;
        MediaApi mediaApi = this;
        return mediaApi.changeMedia(MediaFactory.newMedia(mediaApi.libvlcInstance, (MediaRef)var1_1, (String[])var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean play(MediaRef mediaRef, String ... options) {
        void var2_2;
        void var1_1;
        if (this.prepare((MediaRef)var1_1, (String[])var2_2)) {
            return this.play();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean start(MediaRef mediaRef, String ... options) {
        void var2_2;
        void var1_1;
        if (this.prepare((MediaRef)var1_1, (String[])var2_2)) {
            return this.start();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean startPaused(String mrl, String ... options) {
        void var1_2;
        void var2_3;
        boolean started = this.start(mrl, this.startPausedOptions((String[])var2_3));
        if (started) {
            this.mediaPlayer.controls().setPosition(0.0f);
        }
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean startPaused(CallbackMedia callbackMedia, String ... options) {
        void var1_2;
        void var2_3;
        boolean started = this.start(callbackMedia, this.startPausedOptions((String[])var2_3));
        if (started) {
            this.mediaPlayer.controls().setPosition(0.0f);
        }
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean startPaused(MediaRef mediaRef, String ... options) {
        void var1_2;
        void var2_3;
        boolean started = this.start(mediaRef, this.startPausedOptions((String[])var2_3));
        if (started) {
            this.mediaPlayer.controls().setPosition(0.0f);
        }
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addSlave(MediaSlaveType type, String uri, boolean select) {
        void var3_3;
        void var2_2;
        void var1_1;
        return LibVlc.libvlc_media_player_add_slave((libvlc_media_player_t)this.mediaPlayerInstance, (int)var1_1.intValue(), (String)var2_2, (int)(var3_3 != false ? 1 : 0)) == 0;
    }

    public final Media newMedia() {
        if (this.media != null) {
            return this.media.newMedia();
        }
        return null;
    }

    public final MediaRef newMediaRef() {
        if (this.media != null) {
            return this.media.newMediaRef();
        }
        return null;
    }

    public final boolean isValid() {
        return this.media != null;
    }

    public final EventApi events() {
        if (this.media != null) {
            return this.media.events();
        }
        return null;
    }

    public final InfoApi info() {
        if (this.media != null) {
            return this.media.info();
        }
        return null;
    }

    public final MetaApi meta() {
        if (this.media != null) {
            return this.media.meta();
        }
        return null;
    }

    public final OptionsApi options() {
        if (this.media != null) {
            return this.media.options();
        }
        return null;
    }

    public final ParseApi parsing() {
        if (this.media != null) {
            return this.media.parsing();
        }
        return null;
    }

    public final SlaveApi slaves() {
        if (this.media != null) {
            return this.media.slaves();
        }
        return null;
    }

    public final SubitemApi subitems() {
        if (this.media != null) {
            return this.media.subitems();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean changeMedia(Media newMedia) {
        if (this.media != null) {
            this.media.release();
        }
        if (newMedia != null) {
            void var1_1;
            this.media = var1_1;
            this.setPersistentEventListeners();
            this.applyMedia();
            return true;
        }
        this.media = null;
        return false;
    }

    private boolean play() {
        this.mediaPlayer.controls().play();
        return true;
    }

    private boolean start() {
        return this.mediaPlayer.controls().start();
    }

    /*
     * WARNING - void declaration
     */
    private void applyMedia() {
        void var1_1;
        libvlc_media_t mediaInstance = this.media.mediaInstance();
        LibVlc.libvlc_media_player_set_media((libvlc_media_player_t)this.mediaPlayerInstance, (libvlc_media_t)mediaInstance);
        this.mediaPlayer.subitems().changeMedia((libvlc_media_t)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private String[] startPausedOptions(String ... options) {
        void var2_2;
        ArrayList<String> list = new ArrayList<String>(options != null ? options.length + 1 : 1);
        list.add(START_PAUSED_OPTION);
        if (options != null) {
            void var1_1;
            list.addAll(Arrays.asList(var1_1));
        }
        return var2_2.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    final void addPersistentMediaEventListener(MediaEventListener listener) {
        this.persistentMediaEventListeners.add(listener);
        if (this.media != null) {
            void var1_1;
            this.media.events().addMediaEventListener((MediaEventListener)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    final void removePersistentMediaEventListener(MediaEventListener listener) {
        this.persistentMediaEventListeners.remove(listener);
        if (this.media != null) {
            void var1_1;
            this.media.events().removeMediaEventListener((MediaEventListener)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setPersistentEventListeners() {
        if (this.media != null) {
            for (MediaEventListener listener : this.persistentMediaEventListeners) {
                void var2_2;
                this.media.events().addMediaEventListener((MediaEventListener)var2_2);
            }
        }
    }

    @Override
    protected final void release() {
        if (this.media != null) {
            this.media.release();
        }
    }
}

