/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.co.caprica.vlcj.player.base.EqualizerListener;

public final class Equalizer {
    private final int bandCount;
    private final List<EqualizerListener> listeners = new ArrayList<EqualizerListener>();
    private float preamp;
    private final float[] bandAmps;

    /*
     * WARNING - void declaration
     */
    public Equalizer(int bandCount) {
        void var1_1;
        this.bandCount = bandCount;
        this.bandAmps = new float[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public final void addEqualizerListener(EqualizerListener listener) {
        void var1_1;
        this.listeners.add((EqualizerListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeEqualizerListener(EqualizerListener listener) {
        void var1_1;
        this.listeners.remove(var1_1);
    }

    public final int bandCount() {
        return this.bandCount;
    }

    public final float preamp() {
        return this.preamp;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPreamp(float newPreamp) {
        void var1_1;
        this.checkAmp(newPreamp);
        this.preamp = var1_1;
        this.fireEqualizerChanged();
    }

    /*
     * WARNING - void declaration
     */
    public final float amp(int index) {
        if (index >= 0 && index < this.bandCount) {
            void var1_1;
            return this.bandAmps[var1_1];
        }
        throw new IllegalArgumentException("Invalid band index");
    }

    /*
     * WARNING - void declaration
     */
    public final void setAmp(int index, float newAmp) {
        this.checkAmp(newAmp);
        if (index >= 0 && index < this.bandCount) {
            void var2_2;
            this.bandAmps[var1_1] = var2_2;
            this.fireEqualizerChanged();
            return;
        }
        throw new IllegalArgumentException("Invalid band index");
    }

    /*
     * WARNING - void declaration
     */
    public final float[] amps() {
        void var1_1;
        float[] result = new float[this.bandCount];
        Equalizer equalizer = this;
        equalizer.copy(equalizer.bandAmps, result);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setAmps(float[] newAmps) {
        if (newAmps != null && newAmps.length == this.bandCount) {
            void var1_1;
            float[] fArray = newAmps;
            int n = newAmps.length;
            for (int i = 0; i < n; ++i) {
                float newAmp = fArray[i];
                this.checkAmp(newAmp);
            }
            this.copy((float[])var1_1, this.bandAmps);
            this.fireEqualizerChanged();
            return;
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - void declaration
     */
    public final void setEqualizer(Equalizer equalizer) {
        if (equalizer != null) {
            void var1_1;
            this.preamp = equalizer.preamp;
            this.copy(var1_1.bandAmps, this.bandAmps);
            this.fireEqualizerChanged();
            return;
        }
        throw new IllegalArgumentException();
    }

    public final void reset() {
        this.preamp = 0.0f;
        for (int i = 0; i < this.bandCount; ++i) {
            this.bandAmps[i] = 0.0f;
        }
        this.fireEqualizerChanged();
    }

    /*
     * WARNING - void declaration
     */
    private void checkAmp(float amp) {
        if (amp < -20.0f || amp > 20.0f) {
            void var1_1;
            throw new IllegalArgumentException("Invalid amplification value: " + (float)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void copy(float[] from, float[] to) {
        void var2_2;
        System.arraycopy(from, 0, var2_2, 0, this.bandCount);
    }

    private void fireEqualizerChanged() {
        for (EqualizerListener equalizerListener : this.listeners) {
            equalizerListener.equalizerChanged(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder(40);
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("preamp=").append(this.preamp).append(',');
        sb.append("bandAmps=").append(Arrays.toString(this.bandAmps)).append(']');
        return var1_1.toString();
    }
}

