/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.List;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_output_device_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_equalizer_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.binding.support.strings.NativeString;
import uk.co.caprica.vlcj.player.base.AudioCallbacks;
import uk.co.caprica.vlcj.player.base.AudioChannel;
import uk.co.caprica.vlcj.player.base.AudioDevice;
import uk.co.caprica.vlcj.player.base.BaseApi;
import uk.co.caprica.vlcj.player.base.Descriptions;
import uk.co.caprica.vlcj.player.base.Equalizer;
import uk.co.caprica.vlcj.player.base.EqualizerListener;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.TrackDescription;
import uk.co.caprica.vlcj.player.base.callback.AudioCallback;

public final class AudioApi
extends BaseApi
implements EqualizerListener {
    private final AudioCallbacks audioCallbacks;
    private Equalizer equalizer;
    private libvlc_equalizer_t equalizerInstance;

    /*
     * WARNING - void declaration
     */
    AudioApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
        void var1_1;
        this.audioCallbacks = new AudioCallbacks((MediaPlayer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean setOutput(String output) {
        void var1_1;
        return 0 == LibVlc.libvlc_audio_output_set((libvlc_media_player_t)this.mediaPlayerInstance, (String)var1_1);
    }

    public final String outputDevice() {
        return NativeString.copyAndFreeNativeString((Pointer)LibVlc.libvlc_audio_output_device_get((libvlc_media_player_t)this.mediaPlayerInstance));
    }

    /*
     * WARNING - void declaration
     */
    public final void setOutputDevice(String output, String outputDeviceId) {
        void var2_2;
        void var1_1;
        LibVlc.libvlc_audio_output_device_set((libvlc_media_player_t)this.mediaPlayerInstance, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final List<AudioDevice> outputDevices() {
        void var1_1;
        ArrayList<AudioDevice> result = new ArrayList<AudioDevice>();
        libvlc_audio_output_device_t audioDevices = LibVlc.libvlc_audio_output_device_enum((libvlc_media_player_t)this.mediaPlayerInstance);
        if (audioDevices != null) {
            void var2_2;
            libvlc_audio_output_device_t audioDevice = audioDevices;
            while (audioDevice != null) {
                String device = NativeString.copyNativeString((Pointer)audioDevice.psz_device);
                String description = NativeString.copyNativeString((Pointer)audioDevice.psz_description);
                result.add(new AudioDevice(device, description));
                audioDevice = audioDevice.p_next;
            }
            LibVlc.libvlc_audio_output_device_list_release((Pointer)var2_2.getPointer());
        }
        return var1_1;
    }

    public final boolean mute() {
        LibVlc.libvlc_audio_toggle_mute((libvlc_media_player_t)this.mediaPlayerInstance);
        return this.isMute();
    }

    /*
     * WARNING - void declaration
     */
    public final void setMute(boolean mute) {
        void var1_1;
        LibVlc.libvlc_audio_set_mute((libvlc_media_player_t)this.mediaPlayerInstance, (int)(var1_1 != false ? 1 : 0));
    }

    public final boolean isMute() {
        return LibVlc.libvlc_audio_get_mute((libvlc_media_player_t)this.mediaPlayerInstance) != 0;
    }

    public final int volume() {
        return LibVlc.libvlc_audio_get_volume((libvlc_media_player_t)this.mediaPlayerInstance);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean setVolume(int volume) {
        void var1_1;
        return LibVlc.libvlc_audio_set_volume((libvlc_media_player_t)this.mediaPlayerInstance, (int)var1_1) == 0;
    }

    public final AudioChannel channel() {
        return AudioChannel.audioChannel(LibVlc.libvlc_audio_get_channel((libvlc_media_player_t)this.mediaPlayerInstance));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean setChannel(AudioChannel channel) {
        void var1_1;
        return LibVlc.libvlc_audio_set_channel((libvlc_media_player_t)this.mediaPlayerInstance, (int)var1_1.intValue()) == 0;
    }

    public final long delay() {
        return LibVlc.libvlc_audio_get_delay((libvlc_media_player_t)this.mediaPlayerInstance);
    }

    /*
     * WARNING - void declaration
     */
    public final void setDelay(long delay) {
        void var1_1;
        LibVlc.libvlc_audio_set_delay((libvlc_media_player_t)this.mediaPlayerInstance, (long)var1_1);
    }

    public final Equalizer equalizer() {
        return this.equalizer;
    }

    /*
     * WARNING - void declaration
     */
    public final void setEqualizer(Equalizer equalizer) {
        void var1_1;
        if (this.equalizer != null) {
            this.equalizer.removeEqualizerListener(this);
            LibVlc.libvlc_audio_equalizer_release((libvlc_equalizer_t)this.equalizerInstance);
            this.equalizerInstance = null;
        }
        this.equalizer = var1_1;
        if (this.equalizer != null) {
            this.equalizerInstance = LibVlc.libvlc_audio_equalizer_new();
            this.equalizer.addEqualizerListener(this);
        }
        this.applyEqualizer();
    }

    @Override
    public final void equalizerChanged(Equalizer equalizer) {
        this.applyEqualizer();
    }

    private void applyEqualizer() {
        if (this.equalizerInstance != null) {
            LibVlc.libvlc_audio_equalizer_set_preamp((libvlc_equalizer_t)this.equalizerInstance, (float)this.equalizer.preamp());
            for (int i = 0; i < LibVlc.libvlc_audio_equalizer_get_band_count(); ++i) {
                LibVlc.libvlc_audio_equalizer_set_amp_at_index((libvlc_equalizer_t)this.equalizerInstance, (float)this.equalizer.amp(i), (int)i);
            }
            LibVlc.libvlc_media_player_set_equalizer((libvlc_media_player_t)this.mediaPlayerInstance, (libvlc_equalizer_t)this.equalizerInstance);
            return;
        }
        LibVlc.libvlc_media_player_set_equalizer((libvlc_media_player_t)this.mediaPlayerInstance, null);
    }

    public final int trackCount() {
        return LibVlc.libvlc_audio_get_track_count((libvlc_media_player_t)this.mediaPlayerInstance);
    }

    public final int track() {
        return LibVlc.libvlc_audio_get_track((libvlc_media_player_t)this.mediaPlayerInstance);
    }

    /*
     * WARNING - void declaration
     */
    public final int setTrack(int track) {
        void var1_1;
        LibVlc.libvlc_audio_set_track((libvlc_media_player_t)this.mediaPlayerInstance, (int)var1_1);
        return this.track();
    }

    public final List<TrackDescription> trackDescriptions() {
        return Descriptions.audioTrackDescriptions(this.mediaPlayerInstance);
    }

    /*
     * WARNING - void declaration
     */
    public final void callback(String format, int rate, int channels, AudioCallback audioCallback) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.callback((String)var1_1, (int)var2_2, (int)var3_3, audioCallback, false);
    }

    /*
     * WARNING - void declaration
     */
    public final void callback(String format, int rate, int channels, AudioCallback audioCallback, boolean manageVolume) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.audioCallbacks.callback((String)var1_1, (int)var2_2, (int)var3_3, audioCallback, manageVolume);
    }

    @Override
    protected final void release() {
        this.setEqualizer(null);
    }
}

