/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.medialist;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.List;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_list_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.binding.support.strings.NativeString;
import uk.co.caprica.vlcj.media.Media;
import uk.co.caprica.vlcj.media.MediaFactory;
import uk.co.caprica.vlcj.media.MediaRef;
import uk.co.caprica.vlcj.media.callback.CallbackMedia;
import uk.co.caprica.vlcj.medialist.BaseApi;
import uk.co.caprica.vlcj.medialist.MediaList;
import uk.co.caprica.vlcj.medialist.MediaListRef;

public final class MediaApi
extends BaseApi {
    /*
     * WARNING - void declaration
     */
    MediaApi(MediaList mediaList) {
        super((MediaList)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean add(String mrl, String ... options) {
        void var2_2;
        void var1_1;
        MediaApi mediaApi = this;
        return mediaApi.add(MediaFactory.newMediaRef(mediaApi.libvlcInstance, (String)var1_1, (String[])var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean add(CallbackMedia callbackMedia, String ... options) {
        void var2_2;
        void var1_1;
        MediaApi mediaApi = this;
        return mediaApi.add(MediaFactory.newMediaRef(mediaApi.libvlcInstance, (CallbackMedia)var1_1, (String[])var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean add(MediaRef mediaRef, String ... options) {
        void var2_2;
        void var1_1;
        MediaApi mediaApi = this;
        return mediaApi.add(MediaFactory.newMediaRef(mediaApi.libvlcInstance, (MediaRef)var1_1, (String[])var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private boolean add(MediaRef mediaRef) {
        if (mediaRef != null && !this.isReadOnly()) {
            this.lock();
            try {
                boolean bl = LibVlc.libvlc_media_list_add_media((libvlc_media_list_t)this.mediaListInstance, (libvlc_media_t)mediaRef.mediaInstance()) == 0;
                this.unlock();
                mediaRef.release();
                return bl;
            }
            catch (Throwable throwable) {
                void var1_1;
                this.unlock();
                var1_1.release();
                throw throwable;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean insert(int index, String mrl, String ... options) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.insert((int)var1_1, MediaFactory.newMediaRef(this.libvlcInstance, (String)var2_2, (String[])var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean insert(int index, CallbackMedia callbackMedia, String ... options) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.insert((int)var1_1, MediaFactory.newMediaRef(this.libvlcInstance, (CallbackMedia)var2_2, (String[])var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean insert(int index, MediaRef mediaRef, String ... options) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.insert((int)var1_1, MediaFactory.newMediaRef(this.libvlcInstance, (MediaRef)var2_2, (String[])var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private boolean insert(int index, MediaRef mediaRef) {
        if (mediaRef != null && !this.isReadOnly()) {
            this.lock();
            try {
                boolean bl;
                bl = LibVlc.libvlc_media_list_insert_media((libvlc_media_list_t)this.mediaListInstance, (libvlc_media_t)mediaRef.mediaInstance(), (int)(bl ? 1 : 0)) == 0;
                this.unlock();
                mediaRef.release();
                return bl;
            }
            catch (Throwable throwable) {
                void var2_3;
                this.unlock();
                var2_3.release();
                throw throwable;
            }
        }
        return false;
    }

    public final boolean remove(int index) {
        if (!this.isReadOnly()) {
            this.lock();
            try {
                boolean bl;
                bl = LibVlc.libvlc_media_list_remove_index((libvlc_media_list_t)this.mediaListInstance, (int)(bl ? 1 : 0)) == 0;
                return bl;
            }
            finally {
                this.unlock();
            }
        }
        return false;
    }

    public final boolean clear() {
        if (!this.isReadOnly()) {
            this.lock();
            try {
                int n;
                while ((n = LibVlc.libvlc_media_list_remove_index((libvlc_media_list_t)this.mediaListInstance, (int)0)) == 0) {
                }
                return true;
            }
            finally {
                this.unlock();
            }
        }
        return false;
    }

    public final int count() {
        this.lock();
        try {
            int n = LibVlc.libvlc_media_list_count((libvlc_media_list_t)this.mediaListInstance);
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final List<String> mrls() {
        this.lock();
        try {
            void var2_3;
            int count = LibVlc.libvlc_media_list_count((libvlc_media_list_t)this.mediaListInstance);
            ArrayList<String> result = new ArrayList<String>(count);
            for (int i = 0; i < count; ++i) {
                libvlc_media_t item = LibVlc.libvlc_media_list_item_at_index((libvlc_media_list_t)this.mediaListInstance, (int)i);
                result.add(NativeString.copyAndFreeNativeString((Pointer)LibVlc.libvlc_media_get_mrl((libvlc_media_t)item)));
                LibVlc.libvlc_media_release((libvlc_media_t)item);
            }
            void var3_5 = var2_3;
            return var3_5;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String mrl(int index) {
        this.lock();
        try {
            String string;
            libvlc_media_t media = LibVlc.libvlc_media_list_item_at_index((libvlc_media_list_t)this.mediaListInstance, (int)index);
            if (media == null) return null;
            try {
                string = NativeString.copyAndFreeNativeString((Pointer)LibVlc.libvlc_media_get_mrl((libvlc_media_t)media));
            }
            catch (Throwable throwable) {
                void var1_2;
                LibVlc.libvlc_media_release((libvlc_media_t)var1_2);
                throw throwable;
            }
            LibVlc.libvlc_media_release((libvlc_media_t)media);
            return string;
        }
        finally {
            this.unlock();
        }
    }

    public final MediaRef newMediaRef(int index) {
        this.lock();
        try {
            libvlc_media_t media = LibVlc.libvlc_media_list_item_at_index((libvlc_media_list_t)this.mediaListInstance, (int)index);
            if (media != null) {
                MediaRef mediaRef;
                mediaRef = new MediaRef(this.libvlcInstance, (libvlc_media_t)mediaRef);
                return mediaRef;
            }
            return null;
        }
        finally {
            this.unlock();
        }
    }

    public final Media newMedia(int index) {
        this.lock();
        try {
            libvlc_media_t media = LibVlc.libvlc_media_list_item_at_index((libvlc_media_list_t)this.mediaListInstance, (int)index);
            if (media != null) {
                Media media2;
                media2 = new Media(this.libvlcInstance, (libvlc_media_t)media2);
                return media2;
            }
            return null;
        }
        finally {
            this.unlock();
        }
    }

    public final boolean isReadOnly() {
        return LibVlc.libvlc_media_list_is_readonly((libvlc_media_list_t)this.mediaListInstance) != 0;
    }

    public final MediaList newMediaList() {
        return new MediaList(this.libvlcInstance, this.mediaListInstance);
    }

    public final MediaListRef newMediaListRef() {
        return new MediaListRef(this.libvlcInstance, this.mediaListInstance);
    }

    private void lock() {
        LibVlc.libvlc_media_list_lock((libvlc_media_list_t)this.mediaListInstance);
    }

    private void unlock() {
        LibVlc.libvlc_media_list_unlock((libvlc_media_list_t)this.mediaListInstance);
    }
}

