/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.factory.discovery.strategy;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.co.caprica.vlcj.factory.discovery.strategy.NativeDiscoveryStrategy;

public abstract class BaseNativeDiscoveryStrategy
implements NativeDiscoveryStrategy {
    protected static final String PLUGIN_ENV_NAME = "VLC_PLUGIN_PATH";
    private final Pattern[] patternsToMatch;
    private final String[] pluginPathFormats;

    /*
     * WARNING - void declaration
     */
    public BaseNativeDiscoveryStrategy(String[] filenamePatterns, String[] pluginPathFormats) {
        void var2_2;
        this.patternsToMatch = new Pattern[filenamePatterns.length];
        for (int i = 0; i < filenamePatterns.length; ++i) {
            this.patternsToMatch[i] = Pattern.compile(filenamePatterns[i]);
        }
        this.pluginPathFormats = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String discover() {
        for (String discoveryDirectory : this.discoveryDirectories()) {
            void var2_2;
            if (!this.find(discoveryDirectory)) continue;
            return var2_2;
        }
        return null;
    }

    protected abstract List<String> discoveryDirectories();

    /*
     * WARNING - void declaration
     */
    private boolean find(String directoryName) {
        File dir = new File(directoryName);
        if (!dir.exists()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            void var1_1;
            HashSet<String> matches = new HashSet<String>(this.patternsToMatch.length);
            for (void file : var1_1) {
                Pattern[] patternArray = this.patternsToMatch;
                int n = this.patternsToMatch.length;
                for (int i = 0; i < n; ++i) {
                    Pattern pattern = patternArray[i];
                    Matcher matcher = pattern.matcher(file.getName());
                    if (!matcher.matches()) continue;
                    matches.add(pattern.pattern());
                    if (matches.size() != this.patternsToMatch.length) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean onFound(String path) {
        return true;
    }

    @Override
    public final boolean onSetPluginPath(String path) {
        String[] stringArray = this.pluginPathFormats;
        int n = this.pluginPathFormats.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            String pluginPath = String.format(string, path);
            if (!new File(pluginPath).exists()) continue;
            return this.setPluginPath(pluginPath);
        }
        return false;
    }

    protected abstract boolean setPluginPath(String var1);
}

