/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.factory.discovery.provider;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import uk.co.caprica.vlcj.binding.support.runtime.RuntimeUtil;
import uk.co.caprica.vlcj.factory.discovery.provider.DiscoveryDirectoryProvider;

public class WindowsInstallDirectoryProvider
implements DiscoveryDirectoryProvider {
    private static final String VLC_REGISTRY_KEY = "SOFTWARE\\VideoLAN\\VLC";
    private static final String VLC_INSTALL_DIR_KEY = "InstallDir";

    @Override
    public int priority() {
        return -3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String[] directories() {
        String installDir = this.getVlcInstallDir();
        if (installDir != null) {
            void var1_1;
            return new String[]{var1_1};
        }
        return new String[0];
    }

    @Override
    public boolean supported() {
        return RuntimeUtil.isWindows();
    }

    private String getVlcInstallDir() {
        try {
            return Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)VLC_REGISTRY_KEY, (String)VLC_INSTALL_DIR_KEY);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

