/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.factory.discovery;

import com.sun.jna.NativeLibrary;
import com.sun.jna.StringArray;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.binding.support.runtime.RuntimeUtil;
import uk.co.caprica.vlcj.factory.discovery.strategy.LinuxNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.factory.discovery.strategy.NativeDiscoveryStrategy;
import uk.co.caprica.vlcj.factory.discovery.strategy.OsxNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.factory.discovery.strategy.WindowsNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.support.version.LibVlcVersion;

public class NativeDiscovery {
    protected static final String PLUGIN_ENV_NAME = "VLC_PLUGIN_PATH";
    private static boolean alreadyFound;
    private NativeDiscoveryStrategy successfulStrategy;
    private String discoveredPath;
    private static final NativeDiscoveryStrategy[] DEFAULT_STRATEGIES;
    private final NativeDiscoveryStrategy[] discoveryStrategies;

    /*
     * WARNING - void declaration
     */
    public NativeDiscovery(NativeDiscoveryStrategy ... discoveryStrategies) {
        void var1_1;
        this.discoveryStrategies = discoveryStrategies.length > 0 ? var1_1 : DEFAULT_STRATEGIES;
    }

    public final boolean discover() {
        if (alreadyFound) {
            return true;
        }
        NativeDiscoveryStrategy[] nativeDiscoveryStrategyArray = this.discoveryStrategies;
        int n = this.discoveryStrategies.length;
        for (int i = 0; i < n; ++i) {
            String path;
            NativeDiscoveryStrategy discoveryStrategy = nativeDiscoveryStrategyArray[i];
            if (!discoveryStrategy.supported() || (path = discoveryStrategy.discover()) == null) continue;
            if (discoveryStrategy.onFound(path)) {
                NativeLibrary.addSearchPath((String)RuntimeUtil.getLibVlcLibraryName(), (String)path);
            }
            this.tryPluginPath(path, discoveryStrategy);
            if (this.tryLoadingLibrary()) {
                this.successfulStrategy = discoveryStrategy;
                this.discoveredPath = path;
                this.onFound(path, discoveryStrategy);
                alreadyFound = true;
                return true;
            }
            this.onFailed(path, discoveryStrategy);
            return false;
        }
        this.onNotFound();
        return false;
    }

    public final NativeDiscoveryStrategy successfulStrategy() {
        return this.successfulStrategy;
    }

    public final String discoveredPath() {
        return this.discoveredPath;
    }

    /*
     * WARNING - void declaration
     */
    private void tryPluginPath(String path, NativeDiscoveryStrategy discoveryStrategy) {
        void var3_3;
        String env = System.getenv(PLUGIN_ENV_NAME);
        if (env == null || var3_3.length() == 0) {
            void var1_1;
            void var2_2;
            var2_2.onSetPluginPath((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean tryLoadingLibrary() {
        try {
            Object instance = LibVlc.libvlc_new((int)0, (StringArray)new StringArray(new String[0]));
            if (instance != null) {
                LibVlc.libvlc_release((libvlc_instance_t)instance);
                instance = new LibVlcVersion();
                if (instance.isSupported()) {
                    return true;
                }
            }
        }
        catch (UnsatisfiedLinkError e) {
            void var1_2;
            System.err.println(var1_2.getMessage());
        }
        return false;
    }

    protected void onFound(String path, NativeDiscoveryStrategy strategy) {
    }

    protected void onFailed(String path, NativeDiscoveryStrategy strategy) {
    }

    protected void onNotFound() {
    }

    static {
        DEFAULT_STRATEGIES = new NativeDiscoveryStrategy[]{new LinuxNativeDiscoveryStrategy(), new OsxNativeDiscoveryStrategy(), new WindowsNativeDiscoveryStrategy()};
    }
}

