/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.factory;

import com.sun.jna.StringArray;
import java.util.Collection;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.factory.ApplicationApi;
import uk.co.caprica.vlcj.factory.AudioApi;
import uk.co.caprica.vlcj.factory.DialogsApi;
import uk.co.caprica.vlcj.factory.EqualizerApi;
import uk.co.caprica.vlcj.factory.MediaApi;
import uk.co.caprica.vlcj.factory.MediaDiscovererApi;
import uk.co.caprica.vlcj.factory.MediaPlayerApi;
import uk.co.caprica.vlcj.factory.NativeLibraryMappingException;
import uk.co.caprica.vlcj.factory.RendererApi;
import uk.co.caprica.vlcj.factory.VideoSurfaceApi;
import uk.co.caprica.vlcj.factory.discovery.NativeDiscovery;
import uk.co.caprica.vlcj.factory.discovery.strategy.NativeDiscoveryStrategy;
import uk.co.caprica.vlcj.support.eventmanager.TaskExecutor;
import uk.co.caprica.vlcj.support.version.LibVlcVersion;

public class MediaPlayerFactory {
    protected final libvlc_instance_t libvlcInstance;
    private final TaskExecutor executor = new TaskExecutor();
    private final ApplicationApi applicationApi;
    private final AudioApi audioApi;
    private final DialogsApi dialogsApi;
    private final MediaDiscovererApi mediaDiscovererApi;
    private final EqualizerApi equalizerApi;
    private final MediaPlayerApi mediaPlayerApi;
    private final MediaApi mediaApi;
    private final RendererApi rendererApi;
    private final VideoSurfaceApi videoSurfaceApi;
    private NativeDiscoveryStrategy nativeDiscoveryStrategy;
    private String nativeLibraryPath;

    /*
     * WARNING - void declaration
     */
    public MediaPlayerFactory(NativeDiscovery discovery, String ... libvlcArgs) {
        void var2_2;
        void var1_1;
        this.discoverNativeLibrary((NativeDiscovery)var1_1);
        this.libvlcInstance = this.newLibVlcInstance((String[])(libvlcArgs != null ? var2_2 : new String[]{}));
        this.applicationApi = new ApplicationApi(this);
        this.audioApi = new AudioApi(this);
        this.dialogsApi = new DialogsApi(this);
        this.mediaDiscovererApi = new MediaDiscovererApi(this);
        this.equalizerApi = new EqualizerApi(this);
        this.mediaPlayerApi = new MediaPlayerApi(this);
        this.mediaApi = new MediaApi(this);
        this.rendererApi = new RendererApi(this);
        this.videoSurfaceApi = new VideoSurfaceApi(this);
    }

    /*
     * WARNING - void declaration
     */
    public MediaPlayerFactory(String ... libvlcArgs) {
        this(new NativeDiscovery(new NativeDiscoveryStrategy[0]), (String[])var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MediaPlayerFactory(NativeDiscovery discovery, Collection<String> libvlcArgs) {
        this((NativeDiscovery)var1_1, var2_2.toArray(new String[0]));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MediaPlayerFactory(Collection<String> libvlcArgs) {
        this(new NativeDiscovery(new NativeDiscoveryStrategy[0]), (Collection<String>)var1_1);
        void var1_1;
    }

    public MediaPlayerFactory() {
        this(new NativeDiscovery(new NativeDiscoveryStrategy[0]), new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    private void discoverNativeLibrary(NativeDiscovery discovery) {
        if (discovery != null) {
            discovery.discover();
            this.nativeDiscoveryStrategy = discovery.successfulStrategy();
            this.nativeLibraryPath = discovery.discoveredPath();
        }
        try {
            this.checkVersion();
            return;
        }
        catch (NoClassDefFoundError e) {
            void var1_2;
            throw new NativeLibraryMappingException("Failed to properly initialise the native library", (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkVersion() {
        LibVlcVersion version = new LibVlcVersion();
        if (!version.isSupported()) {
            void var1_1;
            throw new RuntimeException(String.format("Failed to find minimum required VLC version %s, found %s", version.getRequiredVersion(), var1_1.getVersion()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private libvlc_instance_t newLibVlcInstance(String ... libvlcArgs) {
        libvlc_instance_t result = LibVlc.libvlc_new((int)libvlcArgs.length, (StringArray)new StringArray(libvlcArgs));
        if (result != null) {
            void var1_1;
            return var1_1;
        }
        throw new RuntimeException("Failed to get a new native library instance");
    }

    public final ApplicationApi application() {
        return this.applicationApi;
    }

    public final AudioApi audio() {
        return this.audioApi;
    }

    public final DialogsApi dialogs() {
        return this.dialogsApi;
    }

    public final MediaDiscovererApi mediaDiscoverers() {
        return this.mediaDiscovererApi;
    }

    public final EqualizerApi equalizer() {
        return this.equalizerApi;
    }

    public final MediaPlayerApi mediaPlayers() {
        return this.mediaPlayerApi;
    }

    public final MediaApi media() {
        return this.mediaApi;
    }

    public final RendererApi renderers() {
        return this.rendererApi;
    }

    public final VideoSurfaceApi videoSurfaces() {
        return this.videoSurfaceApi;
    }

    /*
     * WARNING - void declaration
     */
    public final void submit(Runnable r) {
        void var1_1;
        this.executor.submit((Runnable)var1_1);
    }

    public final void release() {
        this.executor.release();
        this.onBeforeRelease();
        this.applicationApi.release();
        this.audioApi.release();
        this.dialogsApi.release();
        this.mediaDiscovererApi.release();
        this.equalizerApi.release();
        this.mediaPlayerApi.release();
        this.mediaApi.release();
        this.rendererApi.release();
        this.videoSurfaceApi.release();
        LibVlc.libvlc_release((libvlc_instance_t)this.libvlcInstance);
        this.onAfterRelease();
    }

    public final NativeDiscoveryStrategy nativeDiscoveryStrategy() {
        return this.nativeDiscoveryStrategy;
    }

    public final String nativeLibraryPath() {
        return this.nativeLibraryPath;
    }

    protected void onBeforeRelease() {
    }

    protected void onAfterRelease() {
    }
}

