/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import uk.co.caprica.vlcj.binding.internal.libvlc_equalizer_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.factory.BaseApi;
import uk.co.caprica.vlcj.factory.MediaPlayerFactory;
import uk.co.caprica.vlcj.player.base.Equalizer;

public final class EqualizerApi
extends BaseApi {
    private final List<Float> bands = this.cacheBands();
    private final List<String> presets = this.cachePresets();

    /*
     * WARNING - void declaration
     */
    EqualizerApi(MediaPlayerFactory factory) {
        super((MediaPlayerFactory)var1_1);
        void var1_1;
    }

    public final List<Float> bands() {
        return new ArrayList<Float>(this.bands);
    }

    public final List<String> presets() {
        return new ArrayList<String>(this.presets);
    }

    public final Equalizer newEqualizer() {
        return new Equalizer(LibVlc.libvlc_audio_equalizer_get_band_count());
    }

    /*
     * WARNING - void declaration
     */
    public final Equalizer newEqualizer(String presetName) {
        void var1_1;
        int index = this.presets.indexOf(presetName);
        if (index != -1) {
            libvlc_equalizer_t presetEqualizer = LibVlc.libvlc_audio_equalizer_new_from_preset((int)index);
            if (presetEqualizer != null) {
                void var2_3;
                Equalizer equalizer = new Equalizer(LibVlc.libvlc_audio_equalizer_get_band_count());
                equalizer.setPreamp(LibVlc.libvlc_audio_equalizer_get_preamp((libvlc_equalizer_t)presetEqualizer));
                for (int i = 0; i < LibVlc.libvlc_audio_equalizer_get_band_count(); ++i) {
                    equalizer.setAmp(i, LibVlc.libvlc_audio_equalizer_get_amp_at_index((libvlc_equalizer_t)presetEqualizer, (int)i));
                }
                LibVlc.libvlc_audio_equalizer_release((libvlc_equalizer_t)var1_1);
                return var2_3;
            }
            return null;
        }
        throw new IllegalArgumentException("No such preset named '" + (String)var1_1 + "'");
    }

    /*
     * WARNING - void declaration
     */
    public final Map<String, Equalizer> allPresetEqualizers() {
        void var1_1;
        TreeMap<String, Equalizer> result = new TreeMap<String, Equalizer>();
        for (String preset : this.presets) {
            void var3_3;
            result.put(preset, this.newEqualizer((String)var3_3));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private List<Float> cacheBands() {
        void var2_2;
        int numBands = LibVlc.libvlc_audio_equalizer_get_band_count();
        ArrayList<Float> result = new ArrayList<Float>(numBands);
        for (int i = 0; i < numBands; ++i) {
            result.add(Float.valueOf(LibVlc.libvlc_audio_equalizer_get_band_frequency((int)i)));
        }
        return Collections.unmodifiableList(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private List<String> cachePresets() {
        void var2_2;
        int numPresets = LibVlc.libvlc_audio_equalizer_get_preset_count();
        ArrayList<String> result = new ArrayList<String>(numPresets);
        for (int i = 0; i < numPresets; ++i) {
            result.add(LibVlc.libvlc_audio_equalizer_get_preset_name((int)i));
        }
        return Collections.unmodifiableList(var2_2);
    }
}

