/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.factory;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.List;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_output_device_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_output_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.binding.support.strings.NativeString;
import uk.co.caprica.vlcj.factory.AudioOutput;
import uk.co.caprica.vlcj.factory.BaseApi;
import uk.co.caprica.vlcj.factory.MediaPlayerFactory;
import uk.co.caprica.vlcj.player.base.AudioDevice;

public final class AudioApi
extends BaseApi {
    /*
     * WARNING - void declaration
     */
    AudioApi(MediaPlayerFactory factory) {
        super((MediaPlayerFactory)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final List<AudioOutput> audioOutputs() {
        void var1_1;
        ArrayList<AudioOutput> result = new ArrayList<AudioOutput>();
        libvlc_audio_output_t audioOutputs = LibVlc.libvlc_audio_output_list_get((libvlc_instance_t)this.libvlcInstance);
        if (audioOutputs != null) {
            void var2_2;
            libvlc_audio_output_t audioOutput = audioOutputs;
            while (audioOutput != null) {
                String name = NativeString.copyNativeString((Pointer)audioOutput.psz_name);
                String description = NativeString.copyNativeString((Pointer)audioOutput.psz_description);
                result.add(new AudioOutput(name, description, this.getAudioOutputDevices(name)));
                audioOutput = audioOutput.p_next;
            }
            LibVlc.libvlc_audio_output_list_release((Pointer)var2_2.getPointer());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private List<AudioDevice> getAudioOutputDevices(String outputName) {
        void var2_2;
        ArrayList<AudioDevice> result = new ArrayList<AudioDevice>();
        libvlc_audio_output_device_t audioDevices = LibVlc.libvlc_audio_output_device_list_get((libvlc_instance_t)this.libvlcInstance, (String)outputName);
        if (audioDevices != null) {
            void var1_1;
            libvlc_audio_output_device_t audioDevice = audioDevices;
            while (audioDevice != null) {
                String device = NativeString.copyNativeString((Pointer)audioDevice.psz_device);
                String description = NativeString.copyNativeString((Pointer)audioDevice.psz_description);
                result.add(new AudioDevice(device, description));
                audioDevice = audioDevice.p_next;
            }
            LibVlc.libvlc_audio_output_device_list_release((Pointer)var1_1.getPointer());
        }
        return var2_2;
    }
}

