/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.shapes;

import androidx.graphics.shapes.CornerRounding;
import androidx.graphics.shapes.PointKt;
import androidx.graphics.shapes.RoundedPolygon;
import androidx.graphics.shapes.RoundedPolygonKt;
import androidx.graphics.shapes.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0002\u001a;\u0010\b\u001a\u00020\u0007*\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u0007\u00a2\u0006\u0004\b\b\u0010\t\u001ak\u0010\u0011\u001a\u00020\u0007*\u00020\u00002\u0006\u0010\n\u001a\u00020\u00012\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000f2\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a7\u0010\u0014\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015"}, d2={"Landroidx/graphics/shapes/RoundedPolygon$Companion;", "", "numVertices", "", "radius", "centerX", "centerY", "Landroidx/graphics/shapes/RoundedPolygon;", "circle", "(Landroidx/graphics/shapes/RoundedPolygon$Companion;IFFF)Landroidx/graphics/shapes/RoundedPolygon;", "numVerticesPerRadius", "innerRadius", "Landroidx/graphics/shapes/CornerRounding;", "rounding", "innerRounding", "", "perVertexRounding", "star", "(Landroidx/graphics/shapes/RoundedPolygon$Companion;IFFLandroidx/graphics/shapes/CornerRounding;Landroidx/graphics/shapes/CornerRounding;Ljava/util/List;FF)Landroidx/graphics/shapes/RoundedPolygon;", "", "starVerticesFromNumVerts", "(IFFFF)[F"})
@SourceDebugExtension(value={"SMAP\nShapes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Shapes.kt\nandroidx/graphics/shapes/ShapesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,459:1\n1368#2:460\n1454#2,5:461\n1368#2:466\n1454#2,5:467\n*S KotlinDebug\n*F\n+ 1 Shapes.kt\nandroidx/graphics/shapes/ShapesKt\n*L\n155#1:460\n155#1:461,5\n294#1:466\n294#1:467,5\n*E\n"})
public final class ShapesKt {
    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public static final RoundedPolygon circle(RoundedPolygon.Companion $this$circle, int numVertices, float radius, float centerX, float centerY) {
        void var3_5;
        void var0_1;
        void var1_2;
        void var2_3;
        Intrinsics.checkNotNullParameter((Object)$this$circle, (String)"<this>");
        if (numVertices < 3) {
            throw new IllegalArgumentException("Circle must have at least three vertices");
        }
        float theta = Utils.getFloatPi() / (float)numVertices;
        float polygonRadius = radius / (float)Math.cos(theta);
        CornerRounding cornerRounding = new CornerRounding((float)var2_3, 0.0f, 2, null);
        return RoundedPolygonKt.RoundedPolygon$default((int)var1_2, (float)var0_1, (float)var3_5, centerY, cornerRounding, null, 32, null);
    }

    public static /* synthetic */ RoundedPolygon circle$default(RoundedPolygon.Companion companion, int n, float f, float f2, float f3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 8;
        }
        if ((n2 & 2) != 0) {
            f = 1.0f;
        }
        if ((n2 & 4) != 0) {
            f2 = 0.0f;
        }
        if ((n2 & 8) != 0) {
            f3 = 0.0f;
        }
        return ShapesKt.circle(companion, n, f, f2, f3);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public static final RoundedPolygon star(RoundedPolygon.Companion $this$star, int numVerticesPerRadius, float radius, float innerRadius, CornerRounding rounding, CornerRounding innerRounding, List<CornerRounding> perVertexRounding, float centerX, float centerY) {
        void var3_3;
        void var2_2;
        void var1_1;
        List<CornerRounding> list;
        Intrinsics.checkNotNullParameter((Object)$this$star, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        if (radius <= 0.0f || innerRadius <= 0.0f) {
            throw new IllegalArgumentException("Star radii must both be greater than 0");
        }
        if (innerRadius >= radius) {
            throw new IllegalArgumentException("innerRadius must be less than radius");
        }
        List<CornerRounding> pvRounding = perVertexRounding;
        if (pvRounding == null && innerRounding != null) {
            pvRounding = (Iterable)RangesKt.until((int)0, (int)numVerticesPerRadius);
            Collection destination$iv$iv = new ArrayList();
            list = list.iterator();
            while (list.hasNext()) {
                ((IntIterator)list).nextInt();
                Object[] objectArray = new CornerRounding[2];
                Object[] objectArray2 = objectArray;
                objectArray[0] = rounding;
                objectArray2[1] = innerRounding;
                Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray2);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return RoundedPolygonKt.RoundedPolygon(ShapesKt.starVerticesFromNumVerts((int)var1_1, (float)var2_2, (float)var3_3, centerX, centerY), rounding, list, centerX, centerY);
    }

    public static /* synthetic */ RoundedPolygon star$default(RoundedPolygon.Companion companion, int n, float f, float f2, CornerRounding cornerRounding, CornerRounding cornerRounding2, List list, float f3, float f4, int n2, Object object) {
        if ((n2 & 2) != 0) {
            f = 1.0f;
        }
        if ((n2 & 4) != 0) {
            f2 = 0.5f;
        }
        if ((n2 & 8) != 0) {
            cornerRounding = CornerRounding.Unrounded;
        }
        if ((n2 & 0x10) != 0) {
            cornerRounding2 = null;
        }
        if ((n2 & 0x20) != 0) {
            list = null;
        }
        if ((n2 & 0x40) != 0) {
            f3 = 0.0f;
        }
        if ((n2 & 0x80) != 0) {
            f4 = 0.0f;
        }
        return ShapesKt.star(companion, n, f, f2, cornerRounding, cornerRounding2, list, f3, f4);
    }

    private static final float[] starVerticesFromNumVerts(int numVerticesPerRadius, float radius, float innerRadius, float centerX, float centerY) {
        float[] result = new float[numVerticesPerRadius << 2];
        int arrayIndex = 0;
        for (int i = 0; i < numVerticesPerRadius; ++i) {
            long vertex = Utils.radialToCartesian-L6JJ3z0$default(radius, Utils.getFloatPi() / (float)numVerticesPerRadius * 2.0f * (float)i, 0L, 4, null);
            result[arrayIndex++] = PointKt.getX-DnnuFBc(vertex) + centerX;
            result[arrayIndex++] = PointKt.getY-DnnuFBc(vertex) + centerY;
            vertex = Utils.radialToCartesian-L6JJ3z0$default(innerRadius, Utils.getFloatPi() / (float)numVerticesPerRadius * (float)(2 * i + 1), 0L, 4, null);
            result[arrayIndex++] = PointKt.getX-DnnuFBc(vertex) + centerX;
            result[arrayIndex++] = PointKt.getY-DnnuFBc(vertex) + centerY;
        }
        return result;
    }
}

