/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.shapes;

import androidx.collection.FloatFloatPair;
import androidx.collection.MutableFloatList;
import androidx.graphics.shapes.CornerRounding;
import androidx.graphics.shapes.Cubic;
import androidx.graphics.shapes.Feature;
import androidx.graphics.shapes.PointKt;
import androidx.graphics.shapes.RoundedCorner;
import androidx.graphics.shapes.RoundedPolygon;
import androidx.graphics.shapes.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001aQ\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0001\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u00062\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\bH\u0007\u00a2\u0006\u0004\b\u000b\u0010\f\u001aG\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u0007\u001a\u00020\u00062\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\b2\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u000b\u0010\u000f\u001a-\u0010\u000b\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\b2\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u000b\u0010\u0012\u001a\u001b\u0010\u0015\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u000e\u001a\u00020\rH\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a/\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018"}, d2={"", "numVertices", "", "radius", "centerX", "centerY", "Landroidx/graphics/shapes/CornerRounding;", "rounding", "", "perVertexRounding", "Landroidx/graphics/shapes/RoundedPolygon;", "RoundedPolygon", "(IFFFLandroidx/graphics/shapes/CornerRounding;Ljava/util/List;)Landroidx/graphics/shapes/RoundedPolygon;", "", "vertices", "([FLandroidx/graphics/shapes/CornerRounding;Ljava/util/List;FF)Landroidx/graphics/shapes/RoundedPolygon;", "Landroidx/graphics/shapes/Feature;", "features", "(Ljava/util/List;FF)Landroidx/graphics/shapes/RoundedPolygon;", "Landroidx/collection/FloatFloatPair;", "Landroidx/graphics/shapes/Point;", "calculateCenter", "([F)J", "verticesFromNumVerts", "(IFFF)[F"})
@SourceDebugExtension(value={"SMAP\nRoundedPolygon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoundedPolygon.kt\nandroidx/graphics/shapes/RoundedPolygonKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FloatFloatPair.kt\nandroidx/collection/FloatFloatPair\n+ 4 PackingHelpers.jvm.kt\nandroidx/collection/internal/PackingHelpers_jvmKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,759:1\n1557#2:760\n1628#2,3:761\n67#3:764\n80#3:766\n51#3:768\n55#3:770\n22#4:765\n22#4:769\n22#4:771\n1#5:767\n*S KotlinDebug\n*F\n+ 1 RoundedPolygon.kt\nandroidx/graphics/shapes/RoundedPolygonKt\n*L\n363#1:760\n363#1:761,3\n430#1:764\n430#1:766\n477#1:768\n478#1:770\n430#1:765\n477#1:769\n478#1:771\n*E\n"})
public final class RoundedPolygonKt {
    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public static final RoundedPolygon RoundedPolygon(int numVertices, float radius, float centerX, float centerY, CornerRounding rounding, List<CornerRounding> perVertexRounding) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n;
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        return RoundedPolygonKt.RoundedPolygon(RoundedPolygonKt.verticesFromNumVerts(n, (float)var1_1, centerX, centerY), rounding, perVertexRounding, (float)var2_2, (float)var3_3);
    }

    public static /* synthetic */ RoundedPolygon RoundedPolygon$default(int n, float f, float f2, float f3, CornerRounding cornerRounding, List list, int n2, Object object) {
        if ((n2 & 2) != 0) {
            f = 1.0f;
        }
        if ((n2 & 4) != 0) {
            f2 = 0.0f;
        }
        if ((n2 & 8) != 0) {
            f3 = 0.0f;
        }
        if ((n2 & 0x10) != 0) {
            cornerRounding = CornerRounding.Unrounded;
        }
        if ((n2 & 0x20) != 0) {
            list = null;
        }
        return RoundedPolygonKt.RoundedPolygon(n, f, f2, f3, cornerRounding, list);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public static final RoundedPolygon RoundedPolygon(float[] vertices, CornerRounding rounding, List<CornerRounding> perVertexRounding, float centerX, float centerY) {
        void var1_3;
        void var3_7;
        float[] fArray;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)vertices, (String)"vertices");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        if (vertices.length < 6) {
            throw new IllegalArgumentException("Polygons must have at least 3 vertices");
        }
        if (vertices.length % 2 == 1) {
            throw new IllegalArgumentException("The vertices array should have even size");
        }
        if (perVertexRounding != null && perVertexRounding.size() << 1 != vertices.length) {
            throw new IllegalArgumentException("perVertexRounding list should be either null or the same size as the number of vertices (vertices.size / 2)");
        }
        List corners = new ArrayList();
        int n = vertices.length / 2;
        List roundedCorners = new ArrayList();
        for (int i = 0; i < n; ++i) {
            List<CornerRounding> list = perVertexRounding;
            if (list == null || (list = list.get(i)) == null) {
                list = rounding;
            }
            List<CornerRounding> vtxRounding = list;
            int prevIndex = (i + n - 1) % n << 1;
            int nextIndex = (i + 1) % n << 1;
            roundedCorners.add(new RoundedCorner(FloatFloatPair.constructor-impl((float)vertices[prevIndex], (float)vertices[prevIndex + 1]), FloatFloatPair.constructor-impl((float)vertices[i << 1], (float)vertices[(i << 1) + 1]), FloatFloatPair.constructor-impl((float)vertices[nextIndex], (float)vertices[nextIndex + 1]), (CornerRounding)((Object)vtxRounding), null));
        }
        Iterable nextIndex = $this$map$iv = (Iterable)RangesKt.until((int)0, (int)n);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void ix;
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            float expectedRoundCut = ((RoundedCorner)roundedCorners.get((int)ix)).getExpectedRoundCut() + ((RoundedCorner)roundedCorners.get((int)((ix + true) % n))).getExpectedRoundCut();
            float expectedCut = ((RoundedCorner)roundedCorners.get((int)ix)).getExpectedCut() + ((RoundedCorner)roundedCorners.get((int)((ix + true) % n))).getExpectedCut();
            float vtxX = vertices[ix << 1];
            float nextVtxX = vertices[(ix + true) % n << 1];
            float vtxY = vertices[(ix << 1) + true];
            float nextVtxY = vertices[((ix + true) % n << 1) + true];
            float sideSize = Utils.distance(vtxX - nextVtxX, vtxY - nextVtxY);
            collection.add(expectedRoundCut > sideSize ? TuplesKt.to((Object)Float.valueOf(sideSize / expectedRoundCut), (Object)Float.valueOf(0.0f)) : (expectedCut > sideSize ? TuplesKt.to((Object)Float.valueOf(1.0f), (Object)Float.valueOf((sideSize - expectedRoundCut) / (expectedCut - expectedRoundCut))) : TuplesKt.to((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f))));
        }
        List cutAdjusts = (List)destination$iv$iv;
        for (int i = 0; i < n; ++i) {
            MutableFloatList allowedCuts = new MutableFloatList(2);
            for (int delta = 0; delta < 2; ++delta) {
                destination$iv$iv = (Pair)cutAdjusts.get((i + n - 1 + delta) % n);
                float roundCutRatio = ((Number)destination$iv$iv.component1()).floatValue();
                float cutRatio = ((Number)destination$iv$iv.component2()).floatValue();
                allowedCuts.add(((RoundedCorner)roundedCorners.get(i)).getExpectedRoundCut() * roundCutRatio + (((RoundedCorner)roundedCorners.get(i)).getExpectedCut() - ((RoundedCorner)roundedCorners.get(i)).getExpectedRoundCut()) * cutRatio);
            }
            corners.add(((RoundedCorner)roundedCorners.get(i)).getCubics(allowedCuts.get(0), allowedCuts.get(1)));
        }
        List tempFeatures = new ArrayList();
        for (int i = 0; i < n; ++i) {
            void var2_6;
            int prevVtxIndex = (i + n - 1) % n;
            int nextVtxIndex = (i + 1) % n;
            long currVertex = FloatFloatPair.constructor-impl((float)vertices[i << 1], (float)vertices[(i << 1) + 1]);
            long prevVertex = FloatFloatPair.constructor-impl((float)vertices[prevVtxIndex << 1], (float)vertices[(prevVtxIndex << 1) + 1]);
            long nextVertex = FloatFloatPair.constructor-impl((float)vertices[nextVtxIndex << 1], (float)vertices[(nextVtxIndex << 1) + 1]);
            boolean convex = Utils.convex-b22R3LQ(prevVertex, currVertex, nextVertex);
            tempFeatures.add(new Feature.Corner((List)corners.get(i), (boolean)var2_6));
            tempFeatures.add(new Feature.Edge(CollectionsKt.listOf((Object)Cubic.Companion.straightLine(((Cubic)CollectionsKt.last((List)((List)corners.get(i)))).getAnchor1X(), ((Cubic)CollectionsKt.last((List)((List)corners.get(i)))).getAnchor1Y(), ((Cubic)CollectionsKt.first((List)((List)corners.get((i + 1) % n)))).getAnchor0X(), ((Cubic)CollectionsKt.first((List)((List)corners.get((i + 1) % n)))).getAnchor0Y()))));
        }
        long l = centerX == Float.MIN_VALUE || centerY == Float.MIN_VALUE ? RoundedPolygonKt.calculateCenter(fArray) : FloatFloatPair.constructor-impl((float)var3_7, (float)centerY);
        int n3 = (int)(l >> 32);
        float cx = Float.intBitsToFloat(n3);
        int n4 = (int)l;
        float cy = Float.intBitsToFloat(n4);
        return RoundedPolygonKt.RoundedPolygon(tempFeatures, (float)var1_3, cy);
    }

    public static /* synthetic */ RoundedPolygon RoundedPolygon$default(float[] fArray, CornerRounding cornerRounding, List list, float f, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            cornerRounding = CornerRounding.Unrounded;
        }
        if ((n & 4) != 0) {
            list = null;
        }
        if ((n & 8) != 0) {
            f = Float.MIN_VALUE;
        }
        if ((n & 0x10) != 0) {
            f2 = Float.MIN_VALUE;
        }
        return RoundedPolygonKt.RoundedPolygon(fArray, cornerRounding, list, f, f2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public static final RoundedPolygon RoundedPolygon(List<? extends Feature> features, float centerX, float centerY) {
        List<? extends Feature> list;
        float f;
        void cX;
        float f2;
        Iterator<Cubic> iterator;
        List list2;
        Intrinsics.checkNotNullParameter(features, (String)"features");
        if (!(features.size() >= 2)) {
            String string = "Polygons must have at least 2 features";
            throw new IllegalArgumentException(string.toString());
        }
        List $this$RoundedPolygon_u24lambda_u24222 = list2 = CollectionsKt.createListBuilder();
        for (Feature n : features) {
            iterator = n.getCubics().iterator();
            while (iterator.hasNext()) {
                Cubic l = iterator.next();
                $this$RoundedPolygon_u24lambda_u24222.add(Float.valueOf(l.getAnchor0X()));
                $this$RoundedPolygon_u24lambda_u24222.add(Float.valueOf(l.getAnchor0Y()));
            }
        }
        float[] vertices = CollectionsKt.toFloatArray((Collection)CollectionsKt.build((List)list2));
        if (Float.isNaN(centerX)) {
            long $this$RoundedPolygon_u24lambda_u24222 = RoundedPolygonKt.calculateCenter(vertices);
            int n = (int)($this$RoundedPolygon_u24lambda_u24222 >> 32);
            f2 = Float.intBitsToFloat(n);
        } else {
            void var1_1;
            f2 = cX = var1_1;
        }
        if (Float.isNaN(centerY)) {
            long l = RoundedPolygonKt.calculateCenter(iterator);
            int n = (int)l;
            f = Float.intBitsToFloat(n);
        } else {
            void var2_2;
            f = var2_2;
        }
        void cY = f;
        return new RoundedPolygon(list, FloatFloatPair.constructor-impl((float)cX, (float)cY), null);
    }

    /*
     * WARNING - void declaration
     */
    public static final long calculateCenter(float[] vertices) {
        float[] fArray;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)vertices, (String)"vertices");
        float cumulativeX = 0.0f;
        float cumulativeY = 0.0f;
        int index = 0;
        while (index < vertices.length) {
            cumulativeX += vertices[index++];
            cumulativeY += vertices[index++];
        }
        return FloatFloatPair.constructor-impl((float)(var1_1 / (float)(vertices.length / 2)), (float)(var2_2 / (float)(fArray.length / 2)));
    }

    private static final float[] verticesFromNumVerts(int numVertices, float radius, float centerX, float centerY) {
        float[] result = new float[numVertices << 1];
        int arrayIndex = 0;
        for (int i = 0; i < numVertices; ++i) {
            long vertex = PointKt.plus-ybeJwSQ(Utils.radialToCartesian-L6JJ3z0$default(radius, Utils.getFloatPi() / (float)numVertices * 2.0f * (float)i, 0L, 4, null), FloatFloatPair.constructor-impl((float)centerX, (float)centerY));
            result[arrayIndex++] = PointKt.getX-DnnuFBc(vertex);
            result[arrayIndex++] = PointKt.getY-DnnuFBc(vertex);
        }
        return result;
    }
}

