/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.shapes;

import androidx.collection.FloatFloatPair;
import androidx.graphics.shapes.Cubic;
import androidx.graphics.shapes.CubicKt;
import androidx.graphics.shapes.Feature;
import androidx.graphics.shapes.PointKt;
import androidx.graphics.shapes.PointTransformer;
import androidx.graphics.shapes.Utils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 -2\u00020\u0001:\u0001-B#\b\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J#\u0010\u0019\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010\u0018\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001a\u0010\u001c\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010!\u001a\u0004\b\"\u0010#R\u0018\u0010\u0007\u001a\u00060\u0005j\u0002`\u00068\u0000X\u0080\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010$R\u0011\u0010(\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0011\u0010*\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010'R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020+0\u00028\u0006\u00a2\u0006\u0006\n\u0004\b,\u0010!"}, d2={"Landroidx/graphics/shapes/RoundedPolygon;", "", "", "Landroidx/graphics/shapes/Feature;", "features", "Landroidx/collection/FloatFloatPair;", "Landroidx/graphics/shapes/Point;", "center", "<init>", "(Ljava/util/List;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "Landroidx/graphics/shapes/PointTransformer;", "f", "transformed", "(Landroidx/graphics/shapes/PointTransformer;)Landroidx/graphics/shapes/RoundedPolygon;", "normalized", "()Landroidx/graphics/shapes/RoundedPolygon;", "", "toString", "()Ljava/lang/String;", "", "bounds", "calculateMaxBounds", "([F)[F", "", "approximate", "calculateBounds", "([FZ)[F", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Ljava/util/List;", "getFeatures", "()Ljava/util/List;", "J", "", "getCenterX", "()F", "centerX", "getCenterY", "centerY", "Landroidx/graphics/shapes/Cubic;", "cubics", "Companion"})
@SourceDebugExtension(value={"SMAP\nRoundedPolygon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoundedPolygon.kt\nandroidx/graphics/shapes/RoundedPolygon\n+ 2 Utils.kt\nandroidx/graphics/shapes/Utils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,759:1\n146#2,4:760\n146#2,4:764\n146#2,4:768\n1#3:772\n*S KotlinDebug\n*F\n+ 1 RoundedPolygon.kt\nandroidx/graphics/shapes/RoundedPolygon\n*L\n103#1:760,4\n106#1:764,4\n111#1:768,4\n*E\n"})
public final class RoundedPolygon {
    public static final Companion Companion = new Companion(null);
    private final List<Feature> features;
    public final long center;
    public final List<Cubic> cubics;

    /*
     * WARNING - void declaration
     */
    private RoundedPolygon(List<? extends Feature> features, long center2) {
        void $this$cubics_u24lambda_u240;
        Intrinsics.checkNotNullParameter(features, (String)"features");
        this.features = features;
        this.center = center2;
        List center2 = features = CollectionsKt.createListBuilder();
        RoundedPolygon roundedPolygon = this;
        Cubic firstCubic = null;
        Cubic lastCubic = null;
        List firstFeatureSplitStart = null;
        List firstFeatureSplitEnd = null;
        if (this.features.size() > 0 && this.features.get(0).getCubics().size() == 3) {
            Cubic cubic = this.features.get(0).getCubics().get(1);
            Pair<Cubic, Cubic> pair = cubic.split(0.5f);
            Cubic start = (Cubic)pair.component1();
            Cubic end = (Cubic)pair.component2();
            Object[] objectArray = new Cubic[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this.features.get(0).getCubics().get(0);
            objectArray2[1] = start;
            firstFeatureSplitStart = CollectionsKt.mutableListOf((Object[])objectArray2);
            Cubic[] cubicArray = new Cubic[2];
            objectArray2 = cubicArray;
            cubicArray[0] = end;
            objectArray2[1] = this.features.get(0).getCubics().get(2);
            firstFeatureSplitEnd = CollectionsKt.mutableListOf((Object[])objectArray2);
        }
        int i = 0;
        int n = this.features.size();
        if (n >= 0) {
            while (true) {
                List list;
                if (i == 0 && firstFeatureSplitEnd != null) {
                    list = firstFeatureSplitEnd;
                } else if (i == this.features.size()) {
                    list = firstFeatureSplitStart;
                    if (list == null) {
                        break;
                    }
                } else {
                    list = this.features.get(i).getCubics();
                }
                List featureCubics = list;
                int n2 = ((Collection)featureCubics).size();
                for (int j = 0; j < n2; ++j) {
                    Cubic cubic = featureCubics.get(j);
                    if (!cubic.zeroLength$graphics_shapes()) {
                        if (lastCubic != null) {
                            $this$cubics_u24lambda_u240.add(lastCubic);
                        }
                        lastCubic = cubic;
                        if (firstCubic != null) continue;
                        firstCubic = cubic;
                        continue;
                    }
                    if (lastCubic == null) continue;
                    float[] fArray = lastCubic.getPoints$graphics_shapes();
                    float[] fArray2 = Arrays.copyOf(fArray, fArray.length);
                    Intrinsics.checkNotNullExpressionValue((Object)fArray2, (String)"copyOf(...)");
                    lastCubic = new Cubic(fArray2);
                    lastCubic.getPoints$graphics_shapes()[6] = cubic.getAnchor1X();
                    lastCubic.getPoints$graphics_shapes()[7] = cubic.getAnchor1Y();
                }
                if (i == n) break;
                ++i;
            }
        }
        if (lastCubic != null && firstCubic != null) {
            void var3_7;
            $this$cubics_u24lambda_u240.add(CubicKt.Cubic(lastCubic.getAnchor0X(), lastCubic.getAnchor0Y(), lastCubic.getControl0X(), lastCubic.getControl0Y(), lastCubic.getControl1X(), var3_7.getControl1Y(), firstCubic.getAnchor0X(), firstCubic.getAnchor0Y()));
        } else {
            $this$cubics_u24lambda_u240.add(CubicKt.Cubic(this.getCenterX(), this.getCenterY(), this.getCenterX(), this.getCenterY(), this.getCenterX(), this.getCenterY(), this.getCenterX(), this.getCenterY()));
        }
        roundedPolygon.cubics = CollectionsKt.build((List)features);
        Cubic prevCubic = this.cubics.get(this.cubics.size() - 1);
        int n3 = ((Collection)this.cubics).size();
        for (int index = 0; index < n3; ++index) {
            Cubic cubic = this.cubics.get(index);
            if (Math.abs(cubic.getAnchor0X() - prevCubic.getAnchor1X()) > 1.0E-4f || Math.abs(cubic.getAnchor0Y() - prevCubic.getAnchor1Y()) > 1.0E-4f) {
                throw new IllegalArgumentException("RoundedPolygon must be contiguous, with the anchor points of all curves matching the anchor points of the preceding and succeeding cubics");
            }
            prevCubic = cubic;
        }
    }

    public final List<Feature> getFeatures() {
        return this.features;
    }

    public final float getCenterX() {
        return PointKt.getX-DnnuFBc(this.center);
    }

    public final float getCenterY() {
        return PointKt.getY-DnnuFBc(this.center);
    }

    /*
     * WARNING - void declaration
     */
    public final RoundedPolygon transformed(PointTransformer f) {
        void var2_2;
        List list;
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        long center = PointKt.transformed-so9K2fw(this.center, f);
        List $this$transformed_u24lambda_u244 = list = CollectionsKt.createListBuilder();
        int n = ((Collection)this.features).size();
        for (int i = 0; i < n; ++i) {
            $this$transformed_u24lambda_u244.add(this.features.get(i).transformed(f));
        }
        void var8_7 = var2_2;
        List list2 = CollectionsKt.build((List)list);
        return new RoundedPolygon(list2, (long)var8_7, null);
    }

    /*
     * WARNING - void declaration
     */
    public final RoundedPolygon normalized() {
        void var1_2;
        void var2_3;
        void var3_4;
        float[] bounds = RoundedPolygon.calculateBounds$default(this, null, false, 3, null);
        float width = bounds[2] - bounds[0];
        float height = bounds[3] - bounds[1];
        float side = Math.max(width, height);
        float offsetX = (side - width) / 2.0f - bounds[0];
        float offsetY = (side - var3_4) / 2.0f - bounds[1];
        return this.transformed(new PointTransformer((float)var2_3, side, (float)var1_2){
            final /* synthetic */ float $offsetX;
            final /* synthetic */ float $side;
            final /* synthetic */ float $offsetY;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.$offsetX = var1_1;
                this.$side = var2_2;
                this.$offsetY = var3_3;
            }

            /*
             * WARNING - void declaration
             */
            public final long transform-XgqJiTY(float x, float y) {
                void var2_2;
                return FloatFloatPair.constructor-impl((float)((x + this.$offsetX) / this.$side), (float)((var2_2 + this.$offsetY) / this.$side));
            }
        });
    }

    public final String toString() {
        return "[RoundedPolygon. Cubics = " + CollectionsKt.joinToString$default((Iterable)this.cubics, null, null, null, (int)0, null, null, (int)63, null) + " || Features = " + CollectionsKt.joinToString$default((Iterable)this.features, null, null, null, (int)0, null, null, (int)63, null) + " || Center = (" + this.getCenterX() + ", " + this.getCenterY() + ")]";
    }

    /*
     * WARNING - void declaration
     */
    public final float[] calculateMaxBounds(float[] bounds) {
        void var1_1;
        void var3_4;
        void var2_5;
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        if (!(bounds.length >= 4)) {
            String string = "Required bounds size of 4";
            throw new IllegalArgumentException(string.toString());
        }
        float maxDistSquared = 0.0f;
        int n = ((Collection)this.cubics).size();
        for (int i = 0; i < n; ++i) {
            Cubic cubic = this.cubics.get(i);
            float anchorDistance = Utils.distanceSquared(cubic.getAnchor0X() - this.getCenterX(), cubic.getAnchor0Y() - this.getCenterY());
            long middlePoint = cubic.pointOnCurve-OOQOV4g$graphics_shapes(0.5f);
            float middleDistance = Utils.distanceSquared(PointKt.getX-DnnuFBc(middlePoint) - this.getCenterX(), PointKt.getY-DnnuFBc(middlePoint) - this.getCenterY());
            maxDistSquared = Math.max(maxDistSquared, Math.max(anchorDistance, middleDistance));
        }
        float distance = (float)Math.sqrt((double)var2_5);
        bounds[0] = this.getCenterX() - distance;
        bounds[1] = this.getCenterY() - distance;
        bounds[2] = this.getCenterX() + distance;
        bounds[3] = this.getCenterY() + var3_4;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final float[] calculateBounds(float[] bounds, boolean approximate) {
        void var1_1;
        void var3_5;
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        if (!(bounds.length >= 4)) {
            String string = "Required bounds size of 4";
            throw new IllegalArgumentException(string.toString());
        }
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float maxY = Float.MIN_VALUE;
        int n = ((Collection)this.cubics).size();
        for (int i = 0; i < n; ++i) {
            Cubic cubic = this.cubics.get(i);
            cubic.calculateBounds$graphics_shapes(bounds, approximate);
            minX = Math.min(minX, bounds[0]);
            minY = Math.min(minY, bounds[1]);
            maxX = Math.max(maxX, bounds[2]);
            maxY = Math.max(maxY, bounds[3]);
        }
        bounds[0] = var3_5;
        bounds[1] = minY;
        bounds[2] = maxX;
        bounds[3] = maxY;
        return var1_1;
    }

    public static /* synthetic */ float[] calculateBounds$default(RoundedPolygon roundedPolygon, float[] fArray, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            fArray = new float[4];
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return roundedPolygon.calculateBounds(fArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (!(other instanceof RoundedPolygon)) {
            return false;
        }
        return Intrinsics.areEqual(this.features, ((RoundedPolygon)var1_1).features);
    }

    public final int hashCode() {
        return ((Object)this.features).hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ RoundedPolygon(List features, long center, DefaultConstructorMarker $constructor_marker) {
        this((List<? extends Feature>)var1_1, (long)var2_2);
        void var2_2;
        void var1_1;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Landroidx/graphics/shapes/RoundedPolygon$Companion;", "", "<init>", "()V"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

