/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.shapes;

import androidx.collection.FloatFloatPair;
import androidx.graphics.shapes.CornerRounding;
import androidx.graphics.shapes.Cubic;
import androidx.graphics.shapes.PointKt;
import androidx.graphics.shapes.Utils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b#\b\u0002\u0018\u00002\u00020\u0001B7\u0012\n\u0010\u0004\u001a\u00060\u0002j\u0002`\u0003\u0012\n\u0010\u0005\u001a\u00060\u0002j\u0002`\u0003\u0012\n\u0010\u0006\u001a\u00060\u0002j\u0002`\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014Jc\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\n\u0010\u0017\u001a\u00060\u0002j\u0002`\u00032\n\u0010\u0018\u001a\u00060\u0002j\u0002`\u00032\n\u0010\u0019\u001a\u00060\u0002j\u0002`\u00032\n\u0010\u001a\u001a\u00060\u0002j\u0002`\u00032\n\u0010\u001b\u001a\u00060\u0002j\u0002`\u00032\u0006\u0010\u001c\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJG\u0010$\u001a\n\u0018\u00010\u0002j\u0004\u0018\u0001`\u00032\n\u0010\u0004\u001a\u00060\u0002j\u0002`\u00032\n\u0010 \u001a\u00060\u0002j\u0002`\u00032\n\u0010\u0005\u001a\u00060\u0002j\u0002`\u00032\n\u0010!\u001a\u00060\u0002j\u0002`\u0003H\u0002\u00a2\u0006\u0004\b\"\u0010#R\u0015\u0010\u0004\u001a\u00060\u0002j\u0002`\u00038\u0006\u00a2\u0006\u0006\n\u0004\b\u0004\u0010%R\u0015\u0010\u0005\u001a\u00060\u0002j\u0002`\u00038\u0006\u00a2\u0006\u0006\n\u0004\b\u0005\u0010%R\u0015\u0010\u0006\u001a\u00060\u0002j\u0002`\u00038\u0006\u00a2\u0006\u0006\n\u0004\b\u0006\u0010%R\u0013\u0010\b\u001a\u0004\u0018\u00010\u00078\u0006\u00a2\u0006\u0006\n\u0004\b\b\u0010&R\u0015\u0010!\u001a\u00060\u0002j\u0002`\u00038\u0006\u00a2\u0006\u0006\n\u0004\b!\u0010%R\u0015\u0010'\u001a\u00060\u0002j\u0002`\u00038\u0006\u00a2\u0006\u0006\n\u0004\b'\u0010%R\u0011\u0010(\u001a\u00020\u000b8\u0006\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020\u000b8\u0006\u00a2\u0006\u0006\n\u0004\b*\u0010)R\u0011\u0010+\u001a\u00020\u000b8\u0006\u00a2\u0006\u0006\n\u0004\b+\u0010)R\u0011\u0010,\u001a\u00020\u000b8\u0006\u00a2\u0006\u0006\n\u0004\b,\u0010)R\u0017\u0010-\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b-\u0010)\u001a\u0004\b.\u0010/R\u0011\u00101\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010/R\u001a\u00102\u001a\u00060\u0002j\u0002`\u00038\u0006@\u0006X\u0086\f\u00a2\u0006\u0006\n\u0004\b2\u0010%"}, d2={"Landroidx/graphics/shapes/RoundedCorner;", "", "Landroidx/collection/FloatFloatPair;", "Landroidx/graphics/shapes/Point;", "p0", "p1", "p2", "Landroidx/graphics/shapes/CornerRounding;", "rounding", "<init>", "(JJJLandroidx/graphics/shapes/CornerRounding;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "", "allowedCut0", "allowedCut1", "", "Landroidx/graphics/shapes/Cubic;", "getCubics", "(FF)Ljava/util/List;", "allowedCut", "calculateActualSmoothingValue", "(F)F", "actualRoundCut", "actualSmoothingValues", "corner", "sideStart", "circleSegmentIntersection", "otherCircleSegmentIntersection", "circleCenter", "actualR", "computeFlankingCurve-oAJzIJU", "(FFJJJJJF)Landroidx/graphics/shapes/Cubic;", "computeFlankingCurve", "d0", "d1", "lineIntersection-CBFvKDc", "(JJJJ)Landroidx/collection/FloatFloatPair;", "lineIntersection", "J", "Landroidx/graphics/shapes/CornerRounding;", "d2", "cornerRadius", "F", "smoothing", "cosAngle", "sinAngle", "expectedRoundCut", "getExpectedRoundCut", "()F", "getExpectedCut", "expectedCut", "center"})
final class RoundedCorner {
    public final long p0;
    public final long p1;
    public final long p2;
    public final CornerRounding rounding;
    public final long d1;
    public final long d2;
    public final float cornerRadius;
    public final float smoothing;
    public final float cosAngle;
    public final float sinAngle;
    private final float expectedRoundCut;
    public long center;

    /*
     * WARNING - void declaration
     */
    private RoundedCorner(long p0, long p1, long p2, CornerRounding rounding) {
        void var3_3;
        this.p0 = p0;
        this.p1 = var3_3;
        this.p2 = p2;
        this.rounding = rounding;
        long v01 = PointKt.minus-ybeJwSQ(this.p0, this.p1);
        long v21 = PointKt.minus-ybeJwSQ(this.p2, this.p1);
        float d01 = PointKt.getDistance-DnnuFBc(v01);
        float d21 = PointKt.getDistance-DnnuFBc(v21);
        if (d01 > 0.0f && d21 > 0.0f) {
            RoundedCorner roundedCorner;
            void var2_8;
            void var1_2;
            this.d1 = PointKt.div-so9K2fw(v01, (float)var1_2);
            this.d2 = PointKt.div-so9K2fw(v21, (float)var2_8);
            CornerRounding cornerRounding = this.rounding;
            this.cornerRadius = cornerRounding != null ? cornerRounding.getRadius() : 0.0f;
            CornerRounding cornerRounding2 = this.rounding;
            this.smoothing = cornerRounding2 != null ? cornerRounding2.getSmoothing() : 0.0f;
            this.cosAngle = PointKt.dotProduct-ybeJwSQ(this.d1, this.d2);
            this.sinAngle = (float)Math.sqrt(1.0f - Utils.square(this.cosAngle));
            this.expectedRoundCut = (double)roundedCorner.sinAngle > 0.001 ? this.cornerRadius * (this.cosAngle + 1.0f) / this.sinAngle : 0.0f;
        } else {
            this.d1 = FloatFloatPair.constructor-impl((float)0.0f, (float)0.0f);
            this.d2 = FloatFloatPair.constructor-impl((float)0.0f, (float)0.0f);
            this.cornerRadius = 0.0f;
            this.smoothing = 0.0f;
            this.cosAngle = 0.0f;
            this.sinAngle = 0.0f;
            this.expectedRoundCut = 0.0f;
        }
        this.center = FloatFloatPair.constructor-impl((float)0.0f, (float)0.0f);
    }

    public final float getExpectedRoundCut() {
        return this.expectedRoundCut;
    }

    public final float getExpectedCut() {
        return (1.0f + this.smoothing) * this.expectedRoundCut;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final List<Cubic> getCubics(float allowedCut0, float allowedCut1) {
        void var2_4;
        void var1_2;
        void var3_5;
        float allowedCut = Math.min(allowedCut0, allowedCut1);
        if (this.expectedRoundCut < 1.0E-4f || allowedCut < 1.0E-4f || this.cornerRadius < 1.0E-4f) {
            this.center = this.p1;
            return CollectionsKt.listOf((Object)Cubic.Companion.straightLine(PointKt.getX-DnnuFBc(this.p1), PointKt.getY-DnnuFBc(this.p1), PointKt.getX-DnnuFBc(this.p1), PointKt.getY-DnnuFBc(this.p1)));
        }
        float actualRoundCut = Math.min(allowedCut, this.expectedRoundCut);
        float actualSmoothing0 = this.calculateActualSmoothingValue(allowedCut0);
        float actualSmoothing1 = this.calculateActualSmoothingValue(allowedCut1);
        float actualR = this.cornerRadius * actualRoundCut / this.expectedRoundCut;
        float centerDistance = (float)Math.sqrt(Utils.square(actualR) + Utils.square(actualRoundCut));
        this.center = PointKt.plus-ybeJwSQ(this.p1, PointKt.times-so9K2fw(PointKt.getDirection-DnnuFBc(PointKt.div-so9K2fw(PointKt.plus-ybeJwSQ(this.d1, this.d2), 2.0f)), centerDistance));
        long circleIntersection0 = PointKt.plus-ybeJwSQ(this.p1, PointKt.times-so9K2fw(this.d1, actualRoundCut));
        long circleIntersection2 = PointKt.plus-ybeJwSQ(this.p1, PointKt.times-so9K2fw(this.d2, actualRoundCut));
        Cubic flanking0 = this.computeFlankingCurve-oAJzIJU(actualRoundCut, actualSmoothing0, this.p1, this.p0, circleIntersection0, circleIntersection2, this.center, actualR);
        Cubic flanking2 = this.computeFlankingCurve-oAJzIJU((float)var3_5, actualSmoothing1, this.p1, this.p2, circleIntersection2, circleIntersection0, this.center, actualR).reverse();
        Object[] objectArray = new Cubic[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = flanking0;
        objectArray2[1] = Cubic.Companion.circularArc(PointKt.getX-DnnuFBc(this.center), PointKt.getY-DnnuFBc(this.center), flanking0.getAnchor1X(), var1_2.getAnchor1Y(), flanking2.getAnchor0X(), flanking2.getAnchor0Y());
        objectArray2[2] = var2_4;
        return CollectionsKt.listOf((Object[])objectArray2);
    }

    /*
     * WARNING - void declaration
     */
    private final float calculateActualSmoothingValue(float allowedCut) {
        if (allowedCut > this.getExpectedCut()) {
            return this.smoothing;
        }
        if (allowedCut > this.expectedRoundCut) {
            void var1_1;
            return this.smoothing * (var1_1 - this.expectedRoundCut) / (this.getExpectedCut() - this.expectedRoundCut);
        }
        return 0.0f;
    }

    /*
     * WARNING - void declaration
     */
    private final Cubic computeFlankingCurve-oAJzIJU(float actualRoundCut, float actualSmoothingValues, long corner, long sideStart, long circleSegmentIntersection, long otherCircleSegmentIntersection, long circleCenter, float actualR) {
        void var2_2;
        void var1_1;
        void var3_3;
        long sideDirection = PointKt.getDirection-DnnuFBc(PointKt.minus-ybeJwSQ(sideStart, corner));
        long curveStart = PointKt.plus-ybeJwSQ((long)var3_3, PointKt.times-so9K2fw(PointKt.times-so9K2fw(sideDirection, (float)var1_1), actualSmoothingValues + 1.0f));
        long l = circleSegmentIntersection;
        long p = PointKt.interpolate-dLqxh1s(l, PointKt.div-so9K2fw(PointKt.plus-ybeJwSQ(l, otherCircleSegmentIntersection), 2.0f), (float)var2_2);
        long curveEnd = PointKt.plus-ybeJwSQ(circleCenter, PointKt.times-so9K2fw(Utils.directionVector(PointKt.getX-DnnuFBc(p) - PointKt.getX-DnnuFBc(circleCenter), PointKt.getY-DnnuFBc(p) - PointKt.getY-DnnuFBc(circleCenter)), actualR));
        long circleTangent = Utils.rotate90-DnnuFBc(PointKt.minus-ybeJwSQ(curveEnd, circleCenter));
        FloatFloatPair floatFloatPair = this.lineIntersection-CBFvKDc(sideStart, sideDirection, curveEnd, circleTangent);
        long anchorEnd = floatFloatPair != null ? floatFloatPair.unbox-impl() : circleSegmentIntersection;
        long anchorStart = PointKt.div-so9K2fw(PointKt.plus-ybeJwSQ(curveStart, PointKt.times-so9K2fw(anchorEnd, 2.0f)), 3.0f);
        return new Cubic(curveStart, anchorStart, anchorEnd, curveEnd, null);
    }

    /*
     * WARNING - void declaration
     */
    private final FloatFloatPair lineIntersection-CBFvKDc(long p0, long d0, long p1, long d1) {
        void var3_2;
        void var1_1;
        float f;
        long rotatedD1 = Utils.rotate90-DnnuFBc(d1);
        float den = PointKt.dotProduct-ybeJwSQ(d0, rotatedD1);
        if (Math.abs(f) < 1.0E-4f) {
            return null;
        }
        float num = PointKt.dotProduct-ybeJwSQ(PointKt.minus-ybeJwSQ(p1, p0), rotatedD1);
        if (Math.abs(den) < 1.0E-4f * Math.abs(num)) {
            return null;
        }
        float k = num / den;
        return FloatFloatPair.box-impl((long)PointKt.plus-ybeJwSQ((long)var1_1, PointKt.times-so9K2fw((long)var3_2, k)));
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ RoundedCorner(long p0, long p1, long p2, CornerRounding rounding, DefaultConstructorMarker $constructor_marker) {
        this((long)var1_2, (long)var3_3, p2, rounding);
        void var3_3;
        void var1_2;
    }
}

