/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.shapes;

import androidx.collection.FloatList;
import androidx.collection.MutableFloatList;
import androidx.graphics.shapes.Cubic;
import androidx.graphics.shapes.Feature;
import androidx.graphics.shapes.Measurer;
import androidx.graphics.shapes.PolygonMeasureKt;
import androidx.graphics.shapes.ProgressableFeature;
import androidx.graphics.shapes.RoundedPolygon;
import androidx.graphics.shapes.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.AbstractList;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\b\u0001\u0018\u0000 \u001d2\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0002\u001e\u001dB5\b\u0012\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001c\u0010\u0014\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0012H\u0096\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0016R\u001e\u0010\t\u001a\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0017R\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b"}, d2={"Landroidx/graphics/shapes/MeasuredPolygon;", "Lkotlin/collections/AbstractList;", "Landroidx/graphics/shapes/MeasuredPolygon$MeasuredCubic;", "Landroidx/graphics/shapes/Measurer;", "measurer", "", "Landroidx/graphics/shapes/ProgressableFeature;", "features", "Landroidx/graphics/shapes/Cubic;", "cubics", "Landroidx/collection/FloatList;", "outlineProgress", "<init>", "(Landroidx/graphics/shapes/Measurer;Ljava/util/List;Ljava/util/List;Landroidx/collection/FloatList;)V", "", "cuttingPoint", "cutAndShift", "(F)Landroidx/graphics/shapes/MeasuredPolygon;", "", "index", "get", "(I)Landroidx/graphics/shapes/MeasuredPolygon$MeasuredCubic;", "Landroidx/graphics/shapes/Measurer;", "Ljava/util/List;", "getFeatures", "()Ljava/util/List;", "getSize", "()I", "size", "Companion", "MeasuredCubic"})
@SourceDebugExtension(value={"SMAP\nPolygonMeasure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolygonMeasure.kt\nandroidx/graphics/shapes/MeasuredPolygon\n+ 2 FloatList.kt\nandroidx/collection/FloatList\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Utils.kt\nandroidx/graphics/shapes/Utils\n*L\n1#1,357:1\n65#2:358\n1#3:359\n360#4,7:360\n146#5,4:367\n*S KotlinDebug\n*F\n+ 1 PolygonMeasure.kt\nandroidx/graphics/shapes/MeasuredPolygon\n*L\n35#1:358\n169#1:360,7\n182#1:367,4\n*E\n"})
public final class MeasuredPolygon
extends AbstractList<MeasuredCubic> {
    public static final Companion Companion = new Companion(null);
    private final Measurer measurer;
    private final List<MeasuredCubic> cubics;
    private final List<ProgressableFeature> features;

    public final List<ProgressableFeature> getFeatures() {
        return this.features;
    }

    private MeasuredPolygon(Measurer measurer, List<ProgressableFeature> features, List<? extends Cubic> cubics, FloatList outlineProgress) {
        FloatList floatList = outlineProgress;
        if (!(floatList._size == cubics.size() + 1)) {
            measurer = "Outline progress size is expected to be the cubics size + 1";
            throw new IllegalArgumentException(measurer.toString());
        }
        if (!(outlineProgress.first() == 0.0f)) {
            measurer = "First outline progress value is expected to be zero";
            throw new IllegalArgumentException(measurer.toString());
        }
        if (!(outlineProgress.last() == 1.0f)) {
            measurer = "Last outline progress value is expected to be one";
            throw new IllegalArgumentException(measurer.toString());
        }
        this.measurer = measurer;
        this.features = features;
        List measuredCubics = new ArrayList();
        float startOutlineProgress = 0.0f;
        int n = ((Collection)cubics).size();
        for (int index = 0; index < n; ++index) {
            if (!(outlineProgress.get(index + 1) - outlineProgress.get(index) > 1.0E-4f)) continue;
            measuredCubics.add(new MeasuredCubic(this, cubics.get(index), startOutlineProgress, outlineProgress.get(index + 1)));
            startOutlineProgress = outlineProgress.get(index + 1);
        }
        List list = measuredCubics;
        MeasuredCubic.updateProgressRange$graphics_shapes$default((MeasuredCubic)list.get(CollectionsKt.getLastIndex((List)list)), 0.0f, 1.0f, 1, null);
        this.cubics = measuredCubics;
    }

    /*
     * WARNING - void declaration
     */
    public final MeasuredPolygon cutAndShift(float cuttingPoint) {
        void var3_5;
        List list;
        int index;
        int n;
        Object[] it;
        Pair<MeasuredCubic, MeasuredCubic> $this$indexOfFirst$iv;
        block11: {
            if (!(0.0f <= cuttingPoint ? cuttingPoint <= 1.0f : false)) {
                String string = "Cutting point is expected to be between 0 and 1";
                throw new IllegalArgumentException(string.toString());
            }
            if (cuttingPoint < 1.0E-4f) {
                return this;
            }
            $this$indexOfFirst$iv = this.cubics;
            int index$iv = 0;
            for (Object e : $this$indexOfFirst$iv) {
                it = (Object[])e;
                float f = it.getStartOutlineProgress();
                boolean bl = cuttingPoint <= it.getEndOutlineProgress() ? f <= cuttingPoint : false;
                if (bl) {
                    n = index$iv;
                    break block11;
                }
                ++index$iv;
            }
            n = -1;
        }
        int targetIndex = n;
        $this$indexOfFirst$iv = this.cubics.get(targetIndex);
        $this$indexOfFirst$iv = $this$indexOfFirst$iv.cutAtProgress(cuttingPoint);
        MeasuredCubic b12 = (MeasuredCubic)$this$indexOfFirst$iv.component1();
        MeasuredCubic b32 = (MeasuredCubic)$this$indexOfFirst$iv.component2();
        PolygonMeasureKt.access$getLOG_TAG$p();
        Object[] objectArray = new Cubic[1];
        it = objectArray;
        objectArray[0] = b32.getCubic();
        List retCubics = CollectionsKt.mutableListOf((Object[])it);
        int b32 = this.cubics.size();
        for (int i = 1; i < b32; ++i) {
            retCubics.add(this.cubics.get((i + targetIndex) % this.cubics.size()).getCubic());
        }
        retCubics.add(b12.getCubic());
        MutableFloatList retOutlineProgress = new MutableFloatList(this.cubics.size() + 2);
        int n2 = this.cubics.size() + 2;
        for (index = 0; index < n2; ++index) {
            float f;
            int b12 = index;
            if (b12 == 0) {
                f = 0.0f;
            } else if (b12 == this.cubics.size() + 1) {
                f = 1.0f;
            } else {
                int cubicIndex = (targetIndex + index - 1) % this.cubics.size();
                f = Utils.positiveModulo(this.cubics.get(cubicIndex).getEndOutlineProgress() - cuttingPoint, 1.0f);
            }
            retOutlineProgress.add(f);
        }
        List $this$cutAndShift_u24lambda_u2410 = list = CollectionsKt.createListBuilder();
        index = ((Collection)this.features).size();
        for (int i = 0; i < index; ++i) {
            $this$cutAndShift_u24lambda_u2410.add(new ProgressableFeature(Utils.positiveModulo(this.features.get(i).getProgress() - cuttingPoint, 1.0f), this.features.get(i).getFeature()));
        }
        List newFeatures = CollectionsKt.build((List)list);
        return new MeasuredPolygon(this.measurer, (List<ProgressableFeature>)var3_5, retCubics, (FloatList)retOutlineProgress);
    }

    public final int getSize() {
        return this.cubics.size();
    }

    /*
     * WARNING - void declaration
     */
    public final MeasuredCubic get(int index) {
        void var1_1;
        return this.cubics.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ MeasuredPolygon(Measurer measurer, List features, List cubics, FloatList outlineProgress, DefaultConstructorMarker $constructor_marker) {
        this((Measurer)var1_1, (List<ProgressableFeature>)var2_2, (List<? extends Cubic>)var3_3, outlineProgress);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Landroidx/graphics/shapes/MeasuredPolygon$Companion;", "", "<init>", "()V", "Landroidx/graphics/shapes/Measurer;", "measurer", "Landroidx/graphics/shapes/RoundedPolygon;", "polygon", "Landroidx/graphics/shapes/MeasuredPolygon;", "measurePolygon$graphics_shapes", "(Landroidx/graphics/shapes/Measurer;Landroidx/graphics/shapes/RoundedPolygon;)Landroidx/graphics/shapes/MeasuredPolygon;", "measurePolygon"})
    @SourceDebugExtension(value={"SMAP\nPolygonMeasure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolygonMeasure.kt\nandroidx/graphics/shapes/MeasuredPolygon$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Utils.kt\nandroidx/graphics/shapes/Utils\n*L\n1#1,357:1\n2953#2:358\n2853#2,3:359\n2856#2,6:363\n1#3:362\n146#4,4:369\n*S KotlinDebug\n*F\n+ 1 PolygonMeasure.kt\nandroidx/graphics/shapes/MeasuredPolygon$Companion\n*L\n259#1:358\n259#1:359,3\n259#1:363,6\n259#1:362\n275#1:369,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final MeasuredPolygon measurePolygon$graphics_shapes(Measurer measurer, RoundedPolygon polygon) {
            void var3_6;
            void var1_1;
            List list;
            List list2;
            Object $this$scan$iv;
            Intrinsics.checkNotNullParameter((Object)measurer, (String)"measurer");
            Intrinsics.checkNotNullParameter((Object)polygon, (String)"polygon");
            List cubics = new ArrayList();
            List featureToCubic = new ArrayList();
            int n = ((Collection)polygon.getFeatures()).size();
            for (int featureIndex = 0; featureIndex < n; ++featureIndex) {
                Feature feature = polygon.getFeatures().get(featureIndex);
                int n2 = ((Collection)feature.getCubics()).size();
                for (int cubicIndex = 0; cubicIndex < n2; ++cubicIndex) {
                    if (feature instanceof Feature.Corner && cubicIndex == feature.getCubics().size() / 2) {
                        featureToCubic.add(TuplesKt.to((Object)feature, (Object)cubics.size()));
                    }
                    cubics.add(feature.getCubics().get(cubicIndex));
                }
            }
            Iterable iterable = cubics;
            Float initial$iv2 = Float.valueOf(0.0f);
            Object $this$runningFold$iv$iv = $this$scan$iv;
            int estimatedSize$iv$iv = CollectionsKt.collectionSizeOrDefault((Iterable)$this$runningFold$iv$iv, (int)9);
            if (estimatedSize$iv$iv == 0) {
                list2 = CollectionsKt.listOf((Object)initial$iv2);
            } else {
                ArrayList<Float> featureIndex = new ArrayList<Float>(estimatedSize$iv$iv + 1);
                $this$scan$iv = featureIndex;
                featureIndex.add(initial$iv2);
                ArrayList<Float> result$iv$iv = featureIndex;
                Object accumulator$iv$iv = initial$iv2;
                $this$scan$iv = $this$runningFold$iv$iv.iterator();
                while ($this$scan$iv.hasNext()) {
                    void it;
                    float cubic22;
                    Object element$iv$iv22 = $this$scan$iv.next();
                    Float f = accumulator$iv$iv;
                    accumulator$iv$iv = (Cubic)element$iv$iv22;
                    float f2 = ((Number)f).floatValue();
                    float initial$iv2 = f2;
                    initial$iv2 = cubic22 = measurer.measureCubic((Cubic)((Object)cubic22));
                    float element$iv$iv22 = f2;
                    if (!(it >= 0.0f)) {
                        measurer = "Measured cubic is expected to be greater or equal to zero";
                        throw new IllegalArgumentException(measurer.toString());
                    }
                    Float cubic22 = Float.valueOf(element$iv$iv22 + cubic22);
                    result$iv$iv.add(cubic22);
                }
                list2 = result$iv$iv;
            }
            List measures = list2;
            float totalMeasure = ((Number)CollectionsKt.last((List)list2)).floatValue();
            MutableFloatList outlineProgress = new MutableFloatList(measures.size());
            int n3 = ((Collection)measures).size();
            for (int i = 0; i < n3; ++i) {
                outlineProgress.add(((Number)measures.get(i)).floatValue() / totalMeasure);
            }
            PolygonMeasureKt.access$getLOG_TAG$p();
            List $this$measurePolygon_u24lambda_u244 = list = CollectionsKt.createListBuilder();
            int n4 = ((Collection)featureToCubic).size();
            for (int i = 0; i < n4; ++i) {
                int ix = ((Number)((Pair)featureToCubic.get(i)).getSecond()).intValue();
                $this$measurePolygon_u24lambda_u244.add(new ProgressableFeature(Utils.positiveModulo((outlineProgress.get(ix) + outlineProgress.get(ix + 1)) / 2.0f, 1.0f), (Feature)((Pair)featureToCubic.get(i)).getFirst()));
            }
            List features = CollectionsKt.build((List)list);
            return new MeasuredPolygon((Measurer)var1_1, features, (List)var3_6, (FloatList)outlineProgress, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0081\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ#\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\n\u0010\u000bJ)\u0010\u0010\u001a\u0016\u0012\b\u0012\u00060\u0000R\u00020\u000f\u0012\b\u0012\u00060\u0000R\u00020\u000f0\u000e2\u0006\u0010\r\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0003\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00048\u0006\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0019\u001a\u0004\b\u001b\u0010\u001cR$\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0019\u001a\u0004\b\u001d\u0010\u001c"}, d2={"Landroidx/graphics/shapes/MeasuredPolygon$MeasuredCubic;", "", "Landroidx/graphics/shapes/Cubic;", "cubic", "", "startOutlineProgress", "endOutlineProgress", "<init>", "(Landroidx/graphics/shapes/MeasuredPolygon;Landroidx/graphics/shapes/Cubic;FF)V", "", "updateProgressRange$graphics_shapes", "(FF)V", "updateProgressRange", "cutOutlineProgress", "Lkotlin/Pair;", "Landroidx/graphics/shapes/MeasuredPolygon;", "cutAtProgress", "(F)Lkotlin/Pair;", "", "toString", "()Ljava/lang/String;", "Landroidx/graphics/shapes/Cubic;", "getCubic", "()Landroidx/graphics/shapes/Cubic;", "measuredSize", "F", "value", "getStartOutlineProgress", "()F", "getEndOutlineProgress"})
    @SourceDebugExtension(value={"SMAP\nPolygonMeasure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolygonMeasure.kt\nandroidx/graphics/shapes/MeasuredPolygon$MeasuredCubic\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Utils.kt\nandroidx/graphics/shapes/Utils\n*L\n1#1,357:1\n1#2:358\n146#3,4:359\n*S KotlinDebug\n*F\n+ 1 PolygonMeasure.kt\nandroidx/graphics/shapes/MeasuredPolygon$MeasuredCubic\n*L\n128#1:359,4\n*E\n"})
    public final class MeasuredCubic {
        private final Cubic cubic;
        public final float measuredSize;
        private float startOutlineProgress;
        private float endOutlineProgress;
        final /* synthetic */ MeasuredPolygon this$0;

        /*
         * WARNING - void declaration
         */
        public MeasuredCubic(MeasuredPolygon this$0, Cubic cubic, float startOutlineProgress, float endOutlineProgress) {
            void var3_3;
            void var2_2;
            String string;
            Intrinsics.checkNotNullParameter((Object)cubic, (String)"cubic");
            this.this$0 = string;
            this.cubic = var2_2;
            if (!(endOutlineProgress >= startOutlineProgress)) {
                string = "endOutlineProgress is expected to be equal or greater than startOutlineProgress";
                throw new IllegalArgumentException(string.toString());
            }
            this.measuredSize = this.this$0.measurer.measureCubic(this.cubic);
            this.startOutlineProgress = var3_3;
            this.endOutlineProgress = endOutlineProgress;
        }

        public final Cubic getCubic() {
            return this.cubic;
        }

        public final float getStartOutlineProgress() {
            return this.startOutlineProgress;
        }

        public final float getEndOutlineProgress() {
            return this.endOutlineProgress;
        }

        /*
         * WARNING - void declaration
         */
        public final void updateProgressRange$graphics_shapes(float startOutlineProgress2, float endOutlineProgress) {
            void var2_3;
            void var1_1;
            if (!(endOutlineProgress >= startOutlineProgress2)) {
                String startOutlineProgress2 = "endOutlineProgress is expected to be equal or greater than startOutlineProgress";
                throw new IllegalArgumentException(startOutlineProgress2.toString());
            }
            this.startOutlineProgress = var1_1;
            this.endOutlineProgress = var2_3;
        }

        public static /* synthetic */ void updateProgressRange$graphics_shapes$default(MeasuredCubic measuredCubic, float f, float f2, int n, Object object) {
            if ((n & 1) != 0) {
                f = measuredCubic.startOutlineProgress;
            }
            if ((n & 2) != 0) {
                f2 = measuredCubic.endOutlineProgress;
            }
            measuredCubic.updateProgressRange$graphics_shapes(f, f2);
        }

        /*
         * WARNING - void declaration
         */
        public final Pair<MeasuredCubic, MeasuredCubic> cutAtProgress(float cutOutlineProgress) {
            void var1_1;
            void var2_3;
            void var3_6;
            float boundedCutOutlineProgress = RangesKt.coerceIn((float)cutOutlineProgress, (float)this.startOutlineProgress, (float)this.endOutlineProgress);
            float outlineProgressSize = this.endOutlineProgress - this.startOutlineProgress;
            float f = boundedCutOutlineProgress - this.startOutlineProgress;
            float relativeProgress = f / outlineProgressSize;
            float t22 = this.this$0.measurer.findCubicCutPoint(this.cubic, relativeProgress * this.measuredSize);
            if (!(0.0f <= t22 ? t22 <= 1.0f : false)) {
                String string = "Cubic cut point is expected to be between 0 and 1";
                throw new IllegalArgumentException(string.toString());
            }
            PolygonMeasureKt.access$getLOG_TAG$p();
            Pair<Cubic, Cubic> t22 = this.cubic.split(t22);
            Cubic c1 = (Cubic)t22.component1();
            Cubic c2 = (Cubic)t22.component2();
            return TuplesKt.to((Object)new MeasuredCubic(this.this$0, (Cubic)var3_6, this.startOutlineProgress, boundedCutOutlineProgress), (Object)new MeasuredCubic(this.this$0, (Cubic)var2_3, (float)var1_1, this.endOutlineProgress));
        }

        public final String toString() {
            return "MeasuredCubic(outlineProgress=[" + this.startOutlineProgress + " .. " + this.endOutlineProgress + "], size=" + this.measuredSize + ", cubic=" + this.cubic + ")";
        }
    }
}

