/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.shapes;

import androidx.graphics.shapes.FloatMappingKt;
import androidx.graphics.shapes.ProgressableFeature;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0003\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tR,\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b0\n8\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013"}, d2={"Landroidx/graphics/shapes/MappingHelper;", "", "<init>", "()V", "Landroidx/graphics/shapes/ProgressableFeature;", "f1", "f2", "", "addMapping", "(Landroidx/graphics/shapes/ProgressableFeature;Landroidx/graphics/shapes/ProgressableFeature;)V", "", "Lkotlin/Pair;", "", "mapping", "Ljava/util/List;", "getMapping", "()Ljava/util/List;", "", "usedF1", "Ljava/util/Set;", "usedF2"})
@SourceDebugExtension(value={"SMAP\nFeatureMapping.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureMapping.kt\nandroidx/graphics/shapes/MappingHelper\n+ 2 Collections.kt\nkotlin/collections/CollectionsKt__CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n403#2,7:188\n1#3:195\n*S KotlinDebug\n*F\n+ 1 FeatureMapping.kt\nandroidx/graphics/shapes/MappingHelper\n*L\n129#1:188,7\n*E\n"})
final class MappingHelper {
    private final List<Pair<Float, Float>> mapping = new ArrayList();
    private final Set<ProgressableFeature> usedF1 = new LinkedHashSet();
    private final Set<ProgressableFeature> usedF2 = new LinkedHashSet();

    public final List<Pair<Float, Float>> getMapping() {
        return this.mapping;
    }

    /*
     * WARNING - void declaration
     */
    public final void addMapping(ProgressableFeature f1, ProgressableFeature f2) {
        void var2_2;
        void var1_1;
        void var3_4;
        void $this$binarySearchBy_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)f1, (String)"f1");
        Intrinsics.checkNotNullParameter((Object)f2, (String)"f2");
        if (this.usedF1.contains(f1) || this.usedF2.contains(f2)) {
            return;
        }
        List<Pair<Float, Float>> list = this.mapping;
        Object key$iv = Float.valueOf(f1.getProgress());
        int toIndex$iv = $this$binarySearchBy_u24default$iv.size();
        int index = CollectionsKt.binarySearch((List)$this$binarySearchBy_u24default$iv, (int)0, (int)toIndex$iv, (Function1)((Function1)new Function1<Pair<? extends Float, ? extends Float>, Integer>((Comparable)key$iv){
            final /* synthetic */ Comparable $key;
            {
                void var1_1;
                this.$key = var1_1;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Integer invoke(Object it) {
                Pair pair = (Pair)it;
                return ComparisonsKt.compareValues((Comparable)((Float)pair.getFirst()), (Comparable)this.$key);
            }
        }));
        if (!(index < 0)) {
            key$iv = "There can't be two features with the same progress";
            throw new IllegalArgumentException(key$iv.toString());
        }
        int insertionIndex = -index - 1;
        int n = this.mapping.size();
        if (n > 0) {
            Pair<Float, Float> pair = this.mapping.get((insertionIndex + n - 1) % n);
            float before1 = ((Number)pair.component1()).floatValue();
            float before2 = ((Number)pair.component2()).floatValue();
            Pair<Float, Float> pair2 = this.mapping.get(insertionIndex % n);
            float after1 = ((Number)pair2.component1()).floatValue();
            float after2 = ((Number)pair2.component2()).floatValue();
            if (FloatMappingKt.progressDistance(f1.getProgress(), before1) < 1.0E-4f || FloatMappingKt.progressDistance(f1.getProgress(), after1) < 1.0E-4f || FloatMappingKt.progressDistance(f2.getProgress(), before2) < 1.0E-4f || FloatMappingKt.progressDistance(f2.getProgress(), after2) < 1.0E-4f) {
                return;
            }
            if (n > 1 && !FloatMappingKt.progressInRange(f2.getProgress(), before2, after2)) {
                return;
            }
        }
        this.mapping.add((int)var3_4, (Pair<Float, Float>)TuplesKt.to((Object)Float.valueOf(f1.getProgress()), (Object)Float.valueOf(f2.getProgress())));
        this.usedF1.add((ProgressableFeature)var1_1);
        this.usedF2.add((ProgressableFeature)var2_2);
    }
}

