/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.shapes;

import androidx.collection.FloatList;
import androidx.graphics.shapes.Utils;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\u001a'\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a'\u0010\u000b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u001f\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014"}, d2={"", "progress", "progressFrom", "progressTo", "", "progressInRange", "(FFF)Z", "Landroidx/collection/FloatList;", "xValues", "yValues", "x", "linearMap", "(Landroidx/collection/FloatList;Landroidx/collection/FloatList;F)F", "p", "", "validateProgress", "(Landroidx/collection/FloatList;)V", "p1", "p2", "progressDistance", "(FF)F"})
@SourceDebugExtension(value={"SMAP\nFloatMapping.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatMapping.kt\nandroidx/graphics/shapes/FloatMappingKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FloatList.kt\nandroidx/collection/FloatList\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1#2:127\n74#3:128\n65#3:130\n65#3:132\n65#3:133\n230#4:129\n231#4:131\n*S KotlinDebug\n*F\n+ 1 FloatMapping.kt\nandroidx/graphics/shapes/FloatMappingKt\n*L\n44#1:128\n44#1:130\n45#1:132\n105#1:133\n44#1:129\n44#1:131\n*E\n"})
public final class FloatMappingKt {
    /*
     * WARNING - void declaration
     */
    public static final boolean progressInRange(float progress, float progressFrom, float progressTo) {
        void var2_2;
        float f;
        void var1_1;
        if (progressTo >= progressFrom) {
            if (progressFrom <= progress) {
                return progress <= progressTo;
            }
            return false;
        }
        return progress >= var1_1 || f <= var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static final float linearMap(FloatList xValues, FloatList yValues, float x) {
        void var3_9;
        void var1_1;
        FloatList floatList;
        void var2_2;
        float f;
        int element$iv22;
        block2: {
            Intrinsics.checkNotNullParameter((Object)xValues, (String)"xValues");
            Intrinsics.checkNotNullParameter((Object)yValues, (String)"yValues");
            if (!(0.0f <= x ? x <= 1.0f : false)) {
                String string = "Invalid progress: " + x;
                throw new IllegalArgumentException(string.toString());
            }
            Object this_$iv = xValues;
            this_$iv = (Iterable)RangesKt.until((int)0, (int)((FloatList)this_$iv)._size);
            this_$iv = this_$iv.iterator();
            while (this_$iv.hasNext()) {
                int it22 = element$iv22 = ((IntIterator)this_$iv).nextInt();
                FloatList it22 = xValues;
                if (!FloatMappingKt.progressInRange(x, xValues.get(it22), xValues.get((it22 + 1) % it22._size))) continue;
                break block2;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        int segmentStartIndex = element$iv22;
        FloatList element$iv22 = xValues;
        int segmentEndIndex = (segmentStartIndex + 1) % element$iv22._size;
        float segmentSizeX = Utils.positiveModulo(xValues.get(segmentEndIndex) - xValues.get(segmentStartIndex), 1.0f);
        float segmentSizeY = Utils.positiveModulo(yValues.get(segmentEndIndex) - yValues.get(segmentStartIndex), 1.0f);
        float it = segmentSizeX;
        float positionInSegment = f < 0.001f ? 0.5f : Utils.positiveModulo((float)(var2_2 - floatList.get(segmentStartIndex)), 1.0f) / it;
        return Utils.positiveModulo(var1_1.get((int)var3_9) + segmentSizeY * positionInSegment, 1.0f);
    }

    public static final void validateProgress(FloatList p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        float prev = p.last();
        int wraps = 0;
        FloatList floatList = p;
        int n = floatList._size;
        for (int i = 0; i < n; ++i) {
            float f;
            float curr = p.get(i);
            if (!(f >= 0.0f && curr < 1.0f)) {
                p = "FloatMapping - Progress outside of range: " + FloatList.joinToString$default((FloatList)p, null, null, null, (int)0, null, (int)31, null);
                throw new IllegalArgumentException(p.toString());
            }
            if (!(FloatMappingKt.progressDistance(curr, prev) > 1.0E-4f)) {
                p = "FloatMapping - Progress repeats a value: " + FloatList.joinToString$default((FloatList)p, null, null, null, (int)0, null, (int)31, null);
                throw new IllegalArgumentException(p.toString());
            }
            if (curr < prev && !(++wraps <= 1)) {
                p = "FloatMapping - Progress wraps more than once: " + FloatList.joinToString$default((FloatList)p, null, null, null, (int)0, null, (int)31, null);
                throw new IllegalArgumentException(p.toString());
            }
            prev = curr;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final float progressDistance(float p1, float p2) {
        float f;
        void var1_1;
        float it = Math.abs(p1 - var1_1);
        return Math.min(it, 1.0f - f);
    }
}

