/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.shapes;

import androidx.collection.FloatFloatPair;
import androidx.graphics.shapes.Cubic;
import androidx.graphics.shapes.DistanceVertex;
import androidx.graphics.shapes.DoubleMapper;
import androidx.graphics.shapes.Feature;
import androidx.graphics.shapes.MappingHelper;
import androidx.graphics.shapes.PointKt;
import androidx.graphics.shapes.ProgressableFeature;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000@\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a3\u0010\u0006\u001a\u00020\u00052\u0010\u0010\u0003\u001a\f\u0012\u0004\u0012\u00020\u00010\u0000j\u0002`\u00022\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00010\u0000j\u0002`\u0002H\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a=\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b0\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u00002\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0000H\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u001f\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u001b\u0010\u0014\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0011\u001a\u00020\fH\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015\"&\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b0\u00008\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\"\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0083D\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001a*\u0018\b\u0000\u0010\u001b\"\b\u0012\u0004\u0012\u00020\u00010\u00002\b\u0012\u0004\u0012\u00020\u00010\u0000"}, d2={"", "Landroidx/graphics/shapes/ProgressableFeature;", "Landroidx/graphics/shapes/MeasuredFeatures;", "features1", "features2", "Landroidx/graphics/shapes/DoubleMapper;", "featureMapper", "(Ljava/util/List;Ljava/util/List;)Landroidx/graphics/shapes/DoubleMapper;", "Lkotlin/Pair;", "", "doMapping", "(Ljava/util/List;Ljava/util/List;)Ljava/util/List;", "Landroidx/graphics/shapes/Feature;", "f1", "f2", "featureDistSquared", "(Landroidx/graphics/shapes/Feature;Landroidx/graphics/shapes/Feature;)F", "feature", "Landroidx/collection/FloatFloatPair;", "Landroidx/graphics/shapes/Point;", "featureRepresentativePoint", "(Landroidx/graphics/shapes/Feature;)J", "IdentityMapping", "Ljava/util/List;", "", "LOG_TAG", "Ljava/lang/String;", "MeasuredFeatures"})
@SourceDebugExtension(value={"SMAP\nFeatureMapping.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureMapping.kt\nandroidx/graphics/shapes/FeatureMappingKt\n+ 2 Utils.kt\nandroidx/graphics/shapes/Utils\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n146#2,4:188\n146#2,4:194\n146#2,4:198\n146#2,4:202\n146#2,4:210\n37#3,2:192\n1053#4:206\n1863#4,2:208\n1#5:207\n*S KotlinDebug\n*F\n+ 1 FeatureMapping.kt\nandroidx/graphics/shapes/FeatureMappingKt\n*L\n51#1:188,4\n53#1:194,4\n88#1:198,4\n89#1:202,4\n173#1:210,4\n52#1:192,2\n99#1:206\n110#1:208,2\n*E\n"})
public final class FeatureMappingKt {
    private static final List<Pair<Float, Float>> IdentityMapping;
    private static final String LOG_TAG;

    /*
     * WARNING - void declaration
     */
    public static final DoubleMapper featureMapper(List<ProgressableFeature> features1, List<ProgressableFeature> features2) {
        void var3_3;
        List list;
        Object object;
        Intrinsics.checkNotNullParameter(features1, (String)"features1");
        Intrinsics.checkNotNullParameter(features2, (String)"features2");
        Pair[] $this$featureMapper_u24lambda_u240 = object = CollectionsKt.createListBuilder();
        int n = ((Collection)features1).size();
        for (int i = 0; i < n; ++i) {
            if (!(features1.get(i).getFeature() instanceof Feature.Corner)) continue;
            $this$featureMapper_u24lambda_u240.add(features1.get(i));
        }
        List filteredFeatures1 = CollectionsKt.build((List)object);
        $this$featureMapper_u24lambda_u240 = CollectionsKt.createListBuilder();
        List $this$featureMapper_u24lambda_u241 = $this$featureMapper_u24lambda_u240;
        int n2 = ((Collection)features2).size();
        for (int i = 0; i < n2; ++i) {
            if (!(features2.get(i).getFeature() instanceof Feature.Corner)) continue;
            $this$featureMapper_u24lambda_u241.add(features2.get(i));
        }
        List filteredFeatures2 = CollectionsKt.build((List)$this$featureMapper_u24lambda_u240);
        List<Pair<Float, Float>> featureProgressMapping = FeatureMappingKt.doMapping(list, (List<ProgressableFeature>)object);
        Collection collection = (Collection)var3_3;
        Collection collection2 = collection;
        collection2 = collection;
        object = collection.toArray(new Pair[0]);
        object = new DoubleMapper(Arrays.copyOf(object, ((Pair[])object).length));
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static final List<Pair<Float, Float>> doMapping(List<ProgressableFeature> features1, List<ProgressableFeature> features2) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter(features1, (String)"features1");
        Intrinsics.checkNotNullParameter(features2, (String)"features2");
        Object object = CollectionsKt.createListBuilder();
        List $this$doMapping_u24lambda_u2412 = object;
        features1 = features1.iterator();
        while (features1.hasNext()) {
            ProgressableFeature f1 = (ProgressableFeature)features1.next();
            for (ProgressableFeature f2 : features2) {
                float d = FeatureMappingKt.featureDistSquared(f1.getFeature(), f2.getFeature());
                if (d == Float.MAX_VALUE) continue;
                $this$doMapping_u24lambda_u2412.add(new DistanceVertex(d, f1, f2));
            }
        }
        Iterable distanceVertexList = CollectionsKt.sortedWith((Iterable)(object = (Iterable)CollectionsKt.build((List)object)), (Comparator)new Comparator(){

            /*
             * WARNING - void declaration
             */
            public final int compare(T a, T b) {
                void var1_1;
                Comparable comparable;
                a = (DistanceVertex)a;
                DistanceVertex it = (DistanceVertex)((Object)comparable);
                comparable = Float.valueOf(((DistanceVertex)a).getDistance());
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Float.valueOf(var1_1.getDistance()));
            }
        });
        if (distanceVertexList.isEmpty()) {
            return IdentityMapping;
        }
        if (distanceVertexList.size() == 1) {
            void var0_1;
            DistanceVertex it = (DistanceVertex)CollectionsKt.first((List)distanceVertexList);
            float f1 = it.getF1().getProgress();
            float f2 = it.getF2().getProgress();
            Pair[] pairArray = new Pair[2];
            Iterator<ProgressableFeature> iterator = pairArray;
            pairArray[0] = TuplesKt.to((Object)Float.valueOf(f1), (Object)Float.valueOf(f2));
            iterator[1] = TuplesKt.to((Object)Float.valueOf((float)((var0_1 + 0.5f) % 1.0f)), (Object)Float.valueOf((f2 + 0.5f) % 1.0f));
            return CollectionsKt.listOf(iterator);
        }
        object = new MappingHelper();
        MappingHelper $this$doMapping_u24lambda_u2416 = object;
        iterable = iterable;
        for (ProgressableFeature progressableFeature : iterable) {
            DistanceVertex it = (DistanceVertex)((Object)progressableFeature);
            $this$doMapping_u24lambda_u2416.addMapping(it.getF1(), it.getF2());
        }
        return ((MappingHelper)object).getMapping();
    }

    /*
     * WARNING - void declaration
     */
    public static final float featureDistSquared(Feature f1, Feature f2) {
        void var1_1;
        Feature feature;
        Intrinsics.checkNotNullParameter((Object)f1, (String)"f1");
        Intrinsics.checkNotNullParameter((Object)f2, (String)"f2");
        if (f1 instanceof Feature.Corner && f2 instanceof Feature.Corner && ((Feature.Corner)f1).getConvex() != ((Feature.Corner)f2).getConvex()) {
            return Float.MAX_VALUE;
        }
        return PointKt.getDistanceSquared-DnnuFBc(PointKt.minus-ybeJwSQ(FeatureMappingKt.featureRepresentativePoint(feature), FeatureMappingKt.featureRepresentativePoint((Feature)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static final long featureRepresentativePoint(Feature feature) {
        void var0_1;
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        float x = (((Cubic)CollectionsKt.first(feature.getCubics())).getAnchor0X() + ((Cubic)CollectionsKt.last(feature.getCubics())).getAnchor1X()) / 2.0f;
        float y = (((Cubic)CollectionsKt.first(feature.getCubics())).getAnchor0Y() + ((Cubic)CollectionsKt.last(feature.getCubics())).getAnchor1Y()) / 2.0f;
        return FloatFloatPair.constructor-impl((float)var1_2, (float)var0_1);
    }

    static {
        Object[] objectArray = new Pair[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = TuplesKt.to((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        objectArray2[1] = TuplesKt.to((Object)Float.valueOf(0.5f), (Object)Float.valueOf(0.5f));
        IdentityMapping = CollectionsKt.listOf((Object[])objectArray2);
        LOG_TAG = "FeatureMapping";
    }
}

